/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["../library","sap/base/Log","sap/m/Bar","sap/m/Button","sap/m/Dialog","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/m/Title","sap/m/Text","sap/ui/Device","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/Supportability"],function(e,t,i,a,s,n,r,o,l,g,p,u,d,c,f){"use strict";var y=c.TitleLevel;var m=e.CardBlockingMessageType;var h=u.extend("sap.ui.integration.controls.BlockingMessage",{metadata:{library:"sap.ui.integration",properties:{type:{type:"sap.ui.integration.CardBlockingMessageType",defaultValue:m.Information},height:{type:"sap.ui.core.CSSSize",defaultValue:""},illustrationType:{type:"string",defaultValue:"ErrorScreen"},illustrationSize:{type:"sap.m.IllustratedMessageSize",defaultValue:o.Auto},title:{type:"string",defaultValue:""},description:{type:"string",defaultValue:""},details:{type:"string",defaultValue:""},httpResponse:{type:"object",defaultValue:null},imageSrc:{type:"string",defaultValue:""}},aggregations:{additionalContent:{type:"sap.m.Button",multiple:true,forwarding:{getter:"_getIllustratedMessage",aggregation:"additionalContent"}},_illustratedMessage:{type:"sap.m.IllustratedMessage",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).class("sapUiIntBlockingMsg");if(t.getHeight()){e.style("height",t.getHeight())}e.openEnd();e.renderControl(t.getAggregation("_illustratedMessage"));e.close("div")}}});h.create=function(e,i){var a=e.illustrationType,s=e.illustrationSize||o.Auto,n="100%",l=e.title,g=e.description,p=e.details;if(e.type===m.Error){a=a||r.ErrorScreen}else if(e.type===m.NoData){a=a||r.NoData}if(i.getCardContent()&&i.getCardContent().getDomRef()){n=i.getCardContent().getDomRef().offsetHeight+"px"}var u=new h({type:e.type,height:n,illustrationType:a,illustrationSize:s,title:l,description:g,httpResponse:e.httpResponse,details:p,additionalContent:h._createButtons(e.additionalContent)});if(e.imageSrc){u.setImageSrc(i.getRuntimeUrl(e.imageSrc))}if(p&&f.isDebugModeEnabled()){u.addAdditionalContent(h._createDetailsButton(p));t.error(p)}return u};h._createButtons=function(e){const t=e||[];return t.map(e=>new a({text:e.text,icon:e.icon,tooltip:e.tooltip,type:e.buttonType,ariaHasPopup:e.ariaHasPopup,press:e.press}))};h._createDetailsButton=function(e){var t=d.getResourceBundleFor("sap.ui.integration");return new a({text:t.getText("CARD_BUTTON_SHOW_MORE"),press:function(){var n=new g({renderWhitespace:true,text:e}).addStyleClass("sapUiSmallMargin");var r=new s({stretch:p.system.phone,customHeader:new i({contentMiddle:new l({text:t.getText("CARD_ERROR_DIALOG_TITLE"),level:y.H1}),contentRight:new a({icon:"sap-icon://copy",tooltip:t.getText("CARD_TEXT_COPY"),press:function(){var e=document.createRange(),t=n.getDomRef();e.selectNode(t);window.getSelection().removeAllRanges();window.getSelection().addRange(e);window.navigator.clipboard.writeText(t.textContent)}})}),content:[n],buttons:[new a({text:t.getText("CARD_DIALOG_CLOSE_BUTTON"),press:function(){r.close()}})],afterClose:function(){r.destroy()}});r.open()}})};h.prototype.onBeforeRendering=function(){var e=this._getIllustratedMessage();e.setIllustrationType(this.getIllustrationType()).setIllustrationSize(this.getIllustrationSize()).setTitle(this.getTitle()).setDescription(this.getDescription())};h.prototype._getIllustratedMessage=function(){let e=this.getAggregation("_illustratedMessage");if(!e){e=new n({enableDefaultTitleAndDescription:false,enableVerticalResponsiveness:true});e.addEventDelegate({onAfterRendering:this._illustrationAfterRendering.bind(this)});this.setAggregation("_illustratedMessage",e)}return e};h.prototype._illustrationAfterRendering=function(){const e=this.getImageSrc();if(!e){return}const t=this.getAggregation("_illustratedMessage").getDomRef().getElementsByClassName("sapMIllustratedMessageMainContent")[0];const i=t.getElementsByTagName("svg")[0];const a=i.getBoundingClientRect();const s=document.createElement("div");s.classList.add("sapUiIntCardCustomImage");t.append(s);s.style.backgroundImage="url("+e+")";s.style.width=a.width+"px";s.style.height=a.height+"px"};h.prototype.getStaticConfiguration=function(){return{type:this.getType()===m.NoData?"noData":"error",illustrationType:this.getIllustrationType(),illustrationSize:this.getIllustrationSize(),title:this.getTitle(),description:this.getDescription()?this.getDescription():undefined,imageSrc:this.getImageSrc()?this.getImageSrc():undefined,details:this.getDetails()?this.getDetails():undefined}};return h});
//# sourceMappingURL=BlockingMessage.js.map