/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["./MicrochartRenderer","sap/m/library","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/base/DataType","sap/base/Log","sap/ui/integration/util/BindingHelper"],function(e,a,t,r,i,o,l){"use strict";var n,s,u,c,p,h,m,f,d,g,y,C,b;var v=a.ValueColor;var w=a.Size;function L(e){if(!e||typeof e!=="string"){return e}var a=i.getType("sap.m.ValueColor").isValid(e);if(!a){o.error("The value for stacked bar color must be a valid 'sap.m.ValueColor'. Given '"+e+"'.","sap.ui.integration.controls.Microchart");return null}return e}function V(e){if(!e){return w.Responsive}if(typeof e!=="string"){return l.reuse(e)}const a=e===w.S||e===w.Responsive;if(!a){o.error("The value for size is not correct. Only size 'S' and 'Responsive' are supported. Given '"+e+"'.","sap.ui.integration.controls.Microchart");return w.Responsive}return e}var B=t.extend("sap.ui.integration.controls.Microchart",{metadata:{library:"sap.ui.integration",properties:{displayValue:{type:"string"},valueColor:{type:"sap.m.ValueColor",defaultValue:v.Neutral},height:{type:"sap.ui.core.CSSSize",defaultValue:"1rem"},size:{type:"sap.m.Size",defaultValue:w.Responsive}},aggregations:{chart:{type:"sap.ui.core.Control",multiple:false}}},renderer:e});B.loadDependencies=function(){return new Promise(function(e,a){r.load({name:"sap.suite.ui.microchart"}).then(function(){sap.ui.require(["sap/suite/ui/microchart/BulletMicroChart","sap/suite/ui/microchart/BulletMicroChartData","sap/suite/ui/microchart/StackedBarMicroChart","sap/suite/ui/microchart/StackedBarMicroChartBar","sap/suite/ui/microchart/HarveyBallMicroChart","sap/suite/ui/microchart/HarveyBallMicroChartItem","sap/suite/ui/microchart/LineMicroChart","sap/suite/ui/microchart/LineMicroChartLine","sap/suite/ui/microchart/LineMicroChartPoint","sap/suite/ui/microchart/RadialMicroChart","sap/suite/ui/microchart/ColumnMicroChart","sap/suite/ui/microchart/ColumnMicroChartData","sap/suite/ui/microchart/ColumnMicroChartLabel"],function(){n=arguments[0];s=arguments[1];u=arguments[2];c=arguments[3];p=arguments[4];h=arguments[5];m=arguments[6];f=arguments[7];d=arguments[8];g=arguments[9];y=arguments[10];C=arguments[11];b=arguments[12];e()},function(e){a(e)})}).catch(function(){a("The usage of Microcharts is not available with this distribution.")})})};B.create=function(e,a){var t,r="1rem";if(e.type==="Bullet"){t=B._createBulletChart(e)}else if(e.type==="StackedBar"){t=B._createStackedBarChart(e)}else if(e.type==="HarveyBall"){t=B._createHarveyBallChart(e);r="3rem"}else if(e.type==="Line"){t=B._createLineChart(e);r="3rem"}else if(e.type==="Radial"){t=B._createRadialChart(e);r="2rem"}else if(e.type==="Column"){t=B._createColumnChart(e);r="3rem"}const i=new B({valueColor:l.reuse(e.color),size:V(e.size),displayValue:e.displayValue,chart:t,height:r,visible:e.visible});if(a){i.addStyleClass("sapUiIntMicrochartInHeader")}return i};B._createBulletChart=function(e){var a=[];if(e.thresholds){a=e.thresholds.map(function(e){return new s({value:e.value,color:e.color})})}return new n({size:V(e.size),minValue:e.minValue,maxValue:e.maxValue,targetValue:e.target,showTargetValue:!!e.target,scaleColor:"Light",scale:e.scale,actual:new s({value:e.value,color:l.reuse(e.color)}),thresholds:a})};B._createStackedBarChart=function(e){var a=e.bars.map(function(e){var a=L(e.color);return new c({value:e.value,displayValue:e.displayValue,valueColor:a})});return new u({size:V(e.size),bars:a,maxValue:e.maxValue,displayZeroValue:e.displayZeroValue})};B._createHarveyBallChart=function(e){var a=L(e.color);return new p({size:V(e.size),total:e.total,totalScale:e.totalScale,alignContent:"Right",items:[new h({fraction:e.fraction,fractionScale:e.fractionScale,color:l.reuse(a),fractionLabel:e.fractionLabel,formattedLabel:false})]})};B._createLineChart=function(e){var a=L(e.color);var t=new m({size:V(e.size),color:l.reuse(a),maxXValue:e.maxXValue,minXValue:e.minXValue,maxYValue:e.maxYValue,minYValue:e.minYValue,threshold:e.threshold,leftTopLabel:e.leftTopLabel,leftBottomLabel:e.leftBottomLabel,rightTopLabel:e.rightTopLabel,rightBottomLabel:e.rightBottomLabel});if(Array.isArray(e.points)){e.points.forEach(function(e){t.addPoint(new d({x:e.x,y:e.y}))})}else if(e.points?.path&&e.points?.template){t.bindAggregation("points",{path:e.points.path,template:new d(e.points.template),templateShareable:true})}if(Array.isArray(e.lines)){e.lines.forEach(function(e){var a=L(e.color);t.addLine(new f({color:a,showPoints:e.showPoints,type:e.lineType,points:e.points.map(function(e){return new d({x:e.x,y:e.y})})}))})}else if(e.lines?.path&&e.lines?.template){var r=e.lines.template;var i=new f({color:r.color,showPoints:r.showPoints,type:r.lineType});if(r.points?.path&&r.points?.template){i.bindAggregation("points",{path:r.points.path,template:new d(r.points.template),templateShareable:true})}t.bindAggregation("lines",{path:e.lines.path,template:i,templateShareable:true})}else{o.info("lines or points property is not properly configured for the LineMicroChart","sap.ui.integration.controls.Microchart")}return t};B._createRadialChart=function(e){var a=L(e.color);return new g({size:V(e.size),valueColor:l.reuse(a),total:e.total,showPercentageSymbol:e.showPercentageSymbol,percentage:e.percentage,fraction:e.fraction,alignContent:"Right"})};B._createColumnChart=function(e){var a={size:V(e.size),allowColumnLabels:e.allowColumnLabels,leftTopLabel:new b({label:e.leftTopLabel}),leftBottomLabel:new b({label:e.leftBottomLabel}),rightTopLabel:new b({label:e.rightTopLabel}),rightBottomLabel:new b({label:e.rightBottomLabel})};var t=new y(a);if(Array.isArray(e.columns)){e.columns.forEach(function(e){var a=L(e.color);t.addColumn(new C({color:a,label:e.label,displayValue:e.displayValue,value:e.value}))})}else if(e.columns?.path&&e.columns?.template){t.bindAggregation("columns",{path:e.columns.path,template:new C(e.columns.template),templateShareable:true})}else{o.info("Columns property is not properly configured for the ColumnMicroChart","sap.ui.integration.controls.Microchart")}return t};return B});
//# sourceMappingURL=Microchart.js.map