/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/integration/delegate/PreventKeyboardScrolling"],function(t,e){"use strict";const n=t.extend("sap.ui.integration.delegate.OverflowHandler",{constructor:function(e){t.call(this);this._oContent=e;this._bIsOverflowing=false;this._oDelegate={onAfterRendering:this._onAfterRendering.bind(this)}}});n.prototype.attach=function(){this._oContent.addEventDelegate(this._oDelegate)};n.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);if(this._oPreventKeyboardScrolling){this._oPreventKeyboardScrolling.destroy();this._oPreventKeyboardScrolling=null}if(this._oHeightObserver){this._oHeightObserver.disconnect();this._oHeightObserver=null}this._oContent.removeEventDelegate(this._oDelegate)};n.prototype._onAfterRendering=function(){const t=this._getContentSection();const e=this._getInnerContent();if(!t||!e){return}if(this._oHeightObserver){this._oHeightObserver.disconnect()}this._oHeightObserver=new ResizeObserver(()=>{this._resize()});this._oHeightObserver.observe(t);this._oHeightObserver.observe(e)};n.prototype._resize=function(){const t=this._isOverflowing();if(t===this._bIsOverflowing){return}this._bIsOverflowing=t;const n=this._oContent.getCardInstance();n.getCardFooter().setShowMoreButton(t);n.toggleStyleClass("sapUiIntCardIsOverflowing",t);if(t&&!this._oPreventKeyboardScrolling){this._oPreventKeyboardScrolling=new e(this._oContent)}this._oPreventKeyboardScrolling?.toggle(t)};n.prototype._getContentSection=function(){const t=this._oContent.getCardInstance();return t?.getDomRef("contentSection")};n.prototype._getInnerContent=function(){const t=this._oContent;let e=t.getAggregation("_content")?.getDomRef();if(!e){e=t.getDomRef()?.firstChild}return e};n.prototype._isOverflowing=function(){const t=this._getContentSection()?.getBoundingClientRect().height;const e=this._getInnerContent()?.getBoundingClientRect().height;return e>t};return n});
//# sourceMappingURL=OverflowHandler.js.map