/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/openCardShowMore","sap/ui/integration/util/Utils","sap/m/BusyIndicator"],(t,e,i,a,o)=>{"use strict";const n=t.extend("sap.ui.integration.delegate.Paginator",{metadata:{library:"sap.ui.integration",properties:{active:{type:"boolean",defaultValue:false},card:{type:"object"},configuration:{type:"object"},paginatorModel:{type:"object"}}}});n.create=function(t){if(!t){return null}const e=new n(t);e._applySettings();e._updatePaginatorModel();return e};n.prototype.init=function(){this._iPageNumber=0;this._iPageCount=0};n.prototype._applySettings=function(){const t=this.getConfiguration();const i=this.getCard();let a=t.pageSize;if(i.isSkeleton()&&!t.totalCount){a=i.getModelSizeLimit()}let o=i;const n=i.getCardContent();if(n){o=i.getCardContent()}this._iTotalCount=e.resolveValue(t.totalCount,o);this._iPageSize=e.resolveValue(a,o)};n.prototype.exit=function(){this._oBusyIndicator?.destroy()};n.prototype.openDialog=function(){const t=this.getCard();return i(t)};n.prototype.isServerSide=function(){return this._iTotalCount>0};n.prototype.onDataChanged=function(t){if(!t.hasData()){this._iPageCount=0;this.fireEvent("_ready");return}this._applySettings();const e=this._iTotalCount||t.getDataLength();this._iPageCount=Math.ceil(e/this._iPageSize);this._iPageNumber=Math.min(Math.max(0,this._iPageNumber),this._getLastPageNumber());if(!this.getActive()){this.fireEvent("_ready");return}if(this.isServerSide()){this._onDataChangedServerSidePagination(t,e);if(this._bInitialLoadComplete){this.fireEvent("_ready")}}else{this.fireEvent("_ready")}};n.prototype.setModelData=function(t,e){const i=this.getCard();const o=i.getManifestEntry("/sap.card/content/data/path")||i.getManifestEntry("/sap.card/data/path")||"/";const n=e.getProperty(o);const r=a.getNestedPropertyValue(t,o);if(n&&r){e.setProperty(o,n.concat(r))}else{e.setData(t)}this._loadingMore=false;this.fireEvent("_loadMoreComplete")};n.prototype.isLoadingMore=function(){return this._loadingMore};n.prototype.reset=function(){this.getPaginatorModel().setData({skip:0,size:0,pageIndex:0});this._iPageNumber=0;this._loadingMore=false};n.prototype.render=function(t){if(this._oBusyIndicator&&this.isLoadingMore()){t.renderControl(this._oBusyIndicator)}};n.prototype.getStaticConfiguration=function(){return{pageCount:this._iPageCount,pageIndex:this._iPageNumber}};n.prototype.getPageCount=function(){return this._iPageCount};n.prototype.getPageSize=function(){return this._iPageSize};n.prototype._onDataChangedServerSidePagination=function(t,e){const i=t.getInnerList();this._oBusyIndicator=this._oBusyIndicator||(new o).addStyleClass("sapUiIntPaginatorBusyIndicator");if(!this._bInitialLoadComplete&&t.getDataLength()<e){this._loadMore();this.attachEventOnce("_loadMoreComplete",()=>{this._bInitialLoadComplete=true})}else{this._bInitialLoadComplete=true}const a=t=>{if(this.isLoadingMore()){return}const i=300;if(t.target.scrollHeight-t.target.scrollTop-t.target.clientHeight<i&&this.getCard().getCardContent().getDataLength()<e){this._loadMore()}};const n={onAfterRendering:()=>{i.removeEventDelegate(n);const o=i.getDomRef().closest(".sapFCardContent");o.removeEventListener("scroll",a);o.addEventListener("scroll",a);if(!this.isLoadingMore()&&t.hasData()&&o.clientHeight>=o.scrollHeight&&t.getDataLength()<e){this._loadMore()}}};i.addEventDelegate(n)};n.prototype._loadMore=function(){if(!this.isServerSide()){return}this._loadingMore=true;this.getCard().getCardContent().invalidate();this._iPageNumber=Math.min(this._getLastPageNumber(),this._iPageNumber+1);this._updatePaginatorModel()};n.prototype._updatePaginatorModel=function(){this.getPaginatorModel().setData({skip:this._iPageNumber*this._iPageSize,size:this._iPageSize,pageIndex:this._iPageNumber})};n.prototype._getLastPageNumber=function(){return Math.max(0,this._iPageCount-1)};return n});
//# sourceMappingURL=Paginator.js.map