/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Element","sap/ui/integration/designtime/baseEditor/util/findClosestInstance","sap/ui/integration/designtime/baseEditor/util/createPromise","sap/ui/integration/designtime/baseEditor/util/escapeParameter","sap/ui/integration/designtime/baseEditor/propertyEditor/PropertyEditorFactory","sap/base/util/restricted/_merge","sap/base/util/restricted/_omit","sap/base/util/deepEqual"],function(t,e,i,r,o,n,a,s,p){"use strict";var g="config";var h="propertyName";var d=t.extend("sap.ui.integration.designtime.baseEditor.PropertyEditor",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.core.IFormContent"],properties:{propertyName:{type:"string"},renderLabel:{type:"boolean"},value:{type:"any"},config:{type:"object"}},aggregations:{propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor",multiple:false,visibility:"hidden"}},associations:{editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor",multiple:false}},events:{editorChange:{parameters:{previousEditor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"},editor:{type:"sap.ui.integration.designtime.baseEditor.BaseEditor"}}},propertyEditorChange:{parameters:{previousPropertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"},propertyEditor:{type:"sap.ui.integration.designtime.baseEditor.propertyEditor.BasePropertyEditor"}}},configChange:{parameters:{previousConfig:{type:"object"},config:{type:"object"}}},propertyNameChange:{parameters:{previousPropertyName:{type:"string"},propertyName:{type:"string"}}},ready:{},validationErrorChange:{parameters:{hasError:{type:"boolean"}}},beforeValueChange:{parameters:{path:{type:"string"},value:{type:"any"},nextValue:{type:"any"}}},valueChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},designtimeMetadataChange:{parameters:{path:{type:"string"},value:{type:"any"},previousValue:{type:"any"}}},init:{}}},_bEditorAutoDetect:false,_sCreatedBy:null,constructor:function(){t.prototype.constructor.apply(this,o(arguments,function(t,e){return e==="config"&&n.hasType(t.type)}));if(!this.getEditor()){this._bEditorAutoDetect=true}this._propagationListener=this._propagationListener.bind(this);this.attachEditorChange(function(t){if(this._sCreatedBy){this._removePropertyEditor(t.getParameter("previousEditor"))}this._initPropertyEditor()});this.attachConfigChange(function(t){var e=t.getParameter("previousConfig");var i=t.getParameter("config");var r=this.getAggregation("propertyEditor");if(this._fnCancelInit||!r||!e||!i||e.type!==i.type||e.path!==i.path){this._removePropertyEditor(this.getEditor());this._initPropertyEditor()}else{r.setConfig(i);if(i.visible!==false&&e.visible===false){r.setValue(this.getValue())}}});this.attachPropertyNameChange(function(){if(this._sCreatedBy===h){this._removePropertyEditor(this.getEditor())}if(this._sCreatedBy!==g){this._initPropertyEditor()}});this._initPropertyEditor()},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.style("display","inline-block");t.style("width","100%");t.openEnd();t.renderControl(e.getAggregation("propertyEditor"));t.close("div")}}});d.prototype.init=function(){Promise.resolve().then(function(){this.fireInit()}.bind(this))};d.prototype.getEditor=function(){return e.getElementById(this.getAssociation("editor"))};d.prototype._prepareConfig=function(t){var e=this.getEditor();var i=t.type&&e?(e.getConfig().propertyEditorConfigs||{})[t.type]:{};return a({},i,t)};d.prototype.setConfig=function(t){var e=this.getConfig();var i=t&&a({},{designtime:undefined},this._prepareConfig(t));if(!p(e,i)){this.setProperty("config",i);this.fireConfigChange({previousConfig:e,config:i})}};d.prototype.setPropertyName=function(t){var e=this.getPropertyName();if(e!==t){this.setProperty("propertyName",t);this.firePropertyNameChange({previousPropertyName:e,propertyName:t})}};d.prototype.setEditor=function(t){var i=this.getEditor();var r=typeof t==="string"?e.getElementById(t):t;if(i!==r){this.setAssociation("editor",t);var r=this.getEditor();this.fireEditorChange({previousEditor:i,editor:r});this.setConfig(this.getConfig())}};d.prototype.destroy=function(){this._removePropertyEditor(this.getEditor());t.prototype.destroy.apply(this,arguments)};d.prototype._cleanupCancelledInit=function(t){t.destroy()};d.prototype._removePropertyEditor=function(t){var e=this.getAggregation("propertyEditor");if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit}if(e){this.setAggregation("propertyEditor",null);e.detachReady(this._onPropertyEditorReady,this);e.detachValidationErrorChange(this._onPropertyEditorError,this);e.destroy();this._sCreatedBy=null;this.firePropertyEditorChange({propertyEditor:null})}if(t&&this._mConfig&&this._isAbsolutePath(this._mConfig.path)){t.deregisterPropertyEditor(this,this._mConfig.__propertyName)}};d.prototype.isReady=function(){var t=this.getAggregation("propertyEditor");return t&&t.isReady()||false};d.prototype.hasError=function(){var t=this.getAggregation("propertyEditor");return t&&t.hasError()};d.prototype.ready=function(){return new Promise(function(t){var e=function(e){e.ready().then(t)};var i=this.getAggregation("propertyEditor");if(i){e(i)}else{var r=function(t){var i=t.getParameter("propertyEditor");if(i){this.detachPropertyEditorChange(r,this);e(i)}};this.attachPropertyEditorChange(r,this)}}.bind(this))};d.prototype._onPropertyEditorReady=function(){this.fireReady()};d.prototype._onPropertyEditorError=function(t){this.fireValidationErrorChange({hasError:t.getParameter("hasError")})};d.prototype._initPropertyEditor=function(){if(!this.getEditor()){return}if(this.getConfig()||!this.getBindingInfo("config")&&this.getPropertyName()&&this.getEditor()){if(this._fnCancelInit){this._fnCancelInit().then(this._cleanupCancelledInit);delete this._fnCancelInit}this._mConfig=this.getConfig()||this.getEditor().getPropertyConfigByName(this.getPropertyName());var t=this.getConfig()?g:h;var e=r(function(t,e){n.create(this._mConfig.type).then(t).catch(e)}.bind(this));this._fnCancelInit=e.cancel;if(this._isAbsolutePath(this._mConfig.path)){this.getEditor().registerPropertyEditor(this,this._mConfig.__propertyName)}e.promise.then(function(e){e.initI18n(this.getEditor().getModel("i18n"));e.setConfig(s(a({},this._mConfig),"__propertyName"));e.attachBeforeValueChange(function(t){this.fireBeforeValueChange(s(t.getParameters(),"id"))},this);e.attachValueChange(function(t){this.setValue(t.getParameter("value"));this.fireValueChange(s(t.getParameters(),"id"))},this);e.attachDesigntimeMetadataChange(function(t){this.fireDesigntimeMetadataChange(s(t.getParameters(),"id"))},this);e.setValue(this.getValue(),true);this._sCreatedBy=t;this.setAggregation("propertyEditor",e);var i=this.getRenderLabel();if(i!==undefined){e.setRenderLabel(i)}e.attachReady(this._onPropertyEditorReady,this);if(e.isReady()){this.fireReady()}e.attachValidationErrorChange(this._onPropertyEditorError,this);if(e.hasError()){this.fireValidationErrorChange({hasError:true})}this.firePropertyEditorChange({propertyEditor:e});delete this._fnCancelInit}.bind(this))}};d.prototype._isAbsolutePath=function(t){return t&&t.startsWith("/")};d.prototype._propagationListener=function(){var t=i(this.getParent(),"sap.ui.integration.designtime.baseEditor.BaseEditor");if(t){this.setEditor(t);this.removePropagationListener(this._propagationListener)}};d.prototype.setParent=function(e){t.prototype.setParent.apply(this,arguments);if(this._bEditorAutoDetect){var r=i(e,"sap.ui.integration.designtime.baseEditor.BaseEditor");if(r){this.setEditor(r)}else{this.addPropagationListener(this._propagationListener)}}};d.prototype.setRenderLabel=function(t){this.setProperty("renderLabel",t);var e=this.getAggregation("propertyEditor");if(e){e.setRenderLabel(t)}};d.prototype.getContent=function(){var t=this.getAggregation("propertyEditor");return t&&t.getContent()};d.prototype.setValue=function(t){this.setProperty("value",t);var e=this.getAggregation("propertyEditor");if(e){e.setValue(t,true)}};d.prototype.getRuntimeConfig=function(){return this._mConfig};d.prototype.enhanceAccessibilityState=function(t,e){var i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(this,e)}};d.prototype.getFocusDomRef=function(){var t=this.getAggregation("propertyEditor");if(t){return t.getFocusDomRef()}};d.prototype.getIdForLabel=function(){var t=this.getAggregation("propertyEditor");if(t){return t.getIdForLabel()}};return d});
//# sourceMappingURL=PropertyEditor.js.map