/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/core/Fragment","sap/ui/integration/designtime/baseEditor/util/EvalUtils","sap/m/MessageToast"],function(t,e,o,i){"use strict";function r(t){if(!t){return""}var e=Array.isArray(t);var o=[];var i=function(t){if(typeof t==="object"&&t!==null){return r(t)}if(typeof t==="function"){return t.toString().replaceAll("\t","")}if(typeof t==="string"){return'"'+t+'"'}return t};for(var n in t){var s=i(t[n]);if(!e){s='"'+n+'": '+s}o.push(s)}var a=o.join(",");if(e){a="["+a+"]"}else{a="{"+a+"}"}return a}var n=t.extend("sap.ui.integration.designtime.baseEditor.propertyEditor.codeEditor.CodeEditor",{xmlFragment:"sap.ui.integration.designtime.baseEditor.propertyEditor.codeEditor.CodeEditor",metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer().render});n.configMetadata=Object.assign({},t.configMetadata,{allowBindings:{defaultValue:true,mergeStrategy:"mostRestrictiveWins"},typeLabel:{defaultValue:"BASE_EDITOR.TYPES.OBJECT"}});n.prototype.setConfig=function(e){t.prototype.setConfig.apply(this,arguments);this._sCodeType=this.getConfig().codeType?this.getConfig().codeType:"json"};n.prototype._onLiveChange=function(){var t=this.getContent();if(this._sCodeType==="json"){var e=this._parseJson(t.getValue());if(e instanceof Error){t.setValueState("Error");t.setValueStateText("Error: "+e)}else{t.setValueState("None");this.setValue(e)}}};n.prototype._parseJson=function(t){try{var e=JSON.parse(t);return e}catch(t){return t}};n.prototype.formatValue=function(t){t=r(t);return t};n.prototype._openCodeEditor=function(){if(this._oDialog){this._oDialog.destroy()}return e.load({name:"sap.ui.integration.designtime.baseEditor.propertyEditor.codeEditor.CodeEditorDialog",controller:this}).then(function(t){this._oDialog=t;this._oEditor=this._oDialog.getContent()[0];this._oEditor.getAceEditor().getSession().on("changeAnnotation",this.onChangeAnnotation.bind(this));this._oDialog.attachAfterOpen(function(){this._oEditor.getAceEditor().focus();this._oEditor.getAceEditor().navigateFileEnd()},this);this.addDependent(this._oDialog);this._openDialog();return this._oDialog}.bind(this))};n.prototype._openDialog=function(){var t=this.getContent().getValue();try{var e=JSON.stringify(JSON.parse(t),0,"\t");this._oEditor.setValue(e)}catch(e){this._oEditor.setValue(t)}this._oDialog.open();this._oEditor.prettyPrint()};n.prototype.onClose=function(){this._oCode=null;this._oDialog.close()};n.prototype.onBeautify=function(){try{var t=JSON.stringify(JSON.parse(this._oEditor.getValue()),0,"\t");this._oEditor.setValue(t)}catch(t){this._oEditor.prettyPrint()}};n.prototype.onChangeAnnotation=function(){if(!this._oDialog.isOpen()){return}var t=(this._oEditor.getAceEditor().getSession().getAnnotations()||[]).filter(function(t){return t.type==="error"});if(t.length>0){this._oDialog.getBeginButton().setEnabled(false)}else{var e=this._oEditor.getAceEditor().getValue();if(e&&e!==""){this._oCode=e}else{this._oCode=undefined}this._oDialog.getBeginButton().setEnabled(true)}};n.prototype.onSave=function(){var t=this.getContent();if(this._oCode&&this._oCode!==""){t.setValueState("None");if(this._oCode&&this._oCode!==""){try{if(o.isEvalAllowed()){this._oCode=o.evalJson(this._oCode)}else{this._oCode=JSON.parse(this._oCode)}}catch(t){i.show(t);this._oDialog.getBeginButton().setEnabled(false);return}}}else{this._oCode=undefined}this.setValue(this._oCode);this._oDialog.close()};return n});
//# sourceMappingURL=CodeEditor.js.map