/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/base/util/deepClone","sap/base/util/ObjectPath","sap/base/util/isPlainObject","sap/ui/base/BindingParser","sap/base/util/deepEqual"],function(t,i,e,n,r,s){"use strict";var o=t.extend("sap.ui.integration.designtime.baseEditor.util.ObjectBinding",{metadata:{library:"sap.ui.integration",properties:{object:{type:"object"},_value:{type:"any",hidden:true}},events:{change:{parameters:{path:{type:"string"},value:{type:"any"}}}}},_originalObject:null});o.prototype.init=function(){this._aIgnoreList=[];this._oModelMap={}};o.prototype.exit=function(){this._cleanup()};o.prototype.setObject=function(t){this._setOriginalObject(t);this._init();return this};o.prototype._setObject=function(t){var e=i(t,50);return this.setProperty("object",e)};o.prototype._setOriginalObject=function(t){this._originalObject=i(t,50)};o.prototype._getOriginalObject=function(){return this._originalObject};o.prototype.setModel=function(i,e){var n=false;var r=Object.keys(this.oModels||{}).find(function(t){if(this.oModels[t]===i){n=true;return true}return false}.bind(this));this._oModelMap[e]=n?this._oModelMap[r]:e;var s=t.prototype.setModel.apply(this,arguments);this._init();return s};o.prototype.setBindingContext=function(){var i=t.prototype.setBindingContext.apply(this,arguments);this._init();return i};o.prototype._init=function(){this._cleanup();var t=this._getOriginalObject();if(t){this._setObject(t);this._createPropertyBindings(t)}};o.prototype._cleanup=function(){if(this._mSimpleBindings){Object.keys(this._mSimpleBindings).forEach(function(t){var i=this._mSimpleBindings[t].binding;i.getModel().removeBinding(i);i.destroy()}.bind(this))}this._mSimpleBindings={}};o.prototype._createPropertyBindings=function(t,i){Object.keys(t).filter(function(t){return!this.isIgnored(t)},this).forEach(function(e){var s=i?i+"/"+e:e;if(typeof t[e]==="string"){var o=r.complexParser(t[e]);if(o){if(o.parts){if(!o.parts.find(function(t){return!this.getModel(t.model)}.bind(this))){o.parts.forEach(function(t){this._createSimpleBinding(t,s,o)}.bind(this))}else{return}}else if(this.getModel(o.model)){this._createSimpleBinding(o,s,o)}else{return}this._updateValue([{path:s,bindingInfo:o}])}}else if(t[e]&&(n(t[e])||Array.isArray(t[e]))){this._createPropertyBindings(t[e],s)}},this)};o.prototype._updateValue=function(t){var n=[];t.forEach(function(t){var r=this.getObject();var o=t.path.split("/");var a=o.pop();if(o.length){r=e.get(o,r)}this.bindProperty("_value",i(t.bindingInfo));var p=i(this.getProperty("_value"));this.unbindProperty("_value");if(p!==r[a]&&(a!=="value"||!(r.value===undefined&&s(p,r.defaultValue)))){r[a]=p;n.push({path:t.path,value:p})}}.bind(this));if(n.length){this.fireChange({changes:n})}};o.prototype._createSimpleBinding=function(t,i,e){var n=this.getBindingContext(t.model);var r=this._oModelMap[t.model];var s=this.oModels[t.model];var o=s.resolve(t.path,n);var a=r+">"+o;var p=this._mSimpleBindings[a];if(!p){p=this.getModel(t.model).bindProperty(t.path,n);this._mSimpleBindings[a]={binding:p,properties:[]};p.attachChange(function(){this._updateValue(this._mSimpleBindings[a].properties)}.bind(this))}this._mSimpleBindings[a].properties.push({path:i,bindingInfo:e});return p};o.prototype.addToIgnore=function(t){this._aIgnoreList=this._aIgnoreList.concat(t);this._init()};o.prototype.removeFromIgnore=function(t){this._aIgnoreList=this._aIgnoreList.filter(function(i){return i!==t});this._init()};o.prototype.isIgnored=function(t){return this._aIgnoreList.includes(t)};return o});
//# sourceMappingURL=ObjectBinding.js.map