/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 *
 * @private
 * @experimental
 */
sap.ui.define(["sap/ui/integration/designtime/cardEditor/config/generateActionConfig","sap/ui/integration/designtime/cardEditor/util/CommonPatterns"],function(t,e){"use strict";return{objectGroups:{tags:["content"],label:"{i18n>CARD_EDITOR.OBJECT.GROUPS}",type:"array",path:"content/groups",itemLabel:"{title}",addItemLabel:"{i18n>CARD_EDITOR.OBJECT.GROUP}",template:{title:{label:"{i18n>CARD_EDITOR.TITLE}",type:"string",path:"title"},items:{tags:["content","objectGroup"],label:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEMS}",type:"array",path:"items",itemLabel:"{label}",addItemLabel:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM}",template:{icon:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.ICON}",type:"icon",path:"icon"},label:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.LABEL}",type:"string",path:"label"},value:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.VALUE}",type:"string",path:"value",validators:{emailPattern:{type:"pattern",config:{pattern:e.email,modifiers:"i"},errorMessage:"CARD_EDITOR.VALIDATOR.INVALID_EMAIL",isEnabled:"{= ${type} === 'email'}"}}},type:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.LABEL.TYPE}",type:"select",items:[{key:"phone",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.PHONE}"},{key:"email",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.EMAIL}"},{key:"link",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.LINK}"},{key:"text",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.TEXT}"},{key:"RatingIndicator",title:"{i18n>CARD_EDITOR.OBJECT.GROUP.TYPE.RATINGINDICATOR}"}],defaultValue:"text",path:"type"},url:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.LABEL.URL}",type:"string",path:"url",visible:"{= ${type} === 'link'}"},target:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.TARGET}",type:"select",items:[{key:"_blank",description:"{i18n>CARD_EDITOR.TARGET.BLANK}"},{key:"_self",description:"{i18n>CARD_EDITOR.TARGET.SELF}"}],defaultValue:"_blank",path:"target",visible:"{= ${type} === 'link' && !!${url}}"},emailSubject:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.EMAILSUBJECT}",type:"string",path:"emailSubject",visible:"{= ${type} === 'email'}"},maxValue:{tags:["content","objectGroupItem"],label:"{i18n>CARD_EDITOR.OBJECT.GROUP.ITEM.RATINGMAXVALUE}",type:"integer",path:"maxValue",defaultValue:5,visible:"{= ${type} === 'RatingIndicator'}"}}}},visible:"{= ${context>type} === 'Object' }"},objectActions:t({tags:["content"],path:"content/actions",maxItems:1,visible:"{= ${context>type} === 'Object' }"})}});
//# sourceMappingURL=ObjectCardConfig.js.map