/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/integration/designtime/baseEditor/propertyEditor/BasePropertyEditor","sap/ui/integration/designtime/baseEditor/util/isValidBindingString","sap/ui/core/Fragment","sap/ui/unified/ColorPickerPopover","sap/ui/unified/library","sap/ui/model/json/JSONModel","sap/base/util/deepClone","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/restricted/_omit","sap/ui/core/IconPool"],function(t,e,o,i,s,a,n,r,l,g,p,c){"use strict";var d=e.extend("sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",{metadata:{library:"sap.ui.integration"},xmlFragment:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditor",renderer:e.getMetadata().getRenderer().render});d.configMetadata=Object.assign({},e.configMetadata,{typeLabel:{defaultValue:"BASE_EDITOR.TYPES.ICON"}});var u={config:{type:"simpleicon"},key:"src"};var h={config:{type:"string",maxLength:2,validators:{isAlphabetic:{type:"pattern",config:{pattern:"^[A-Za-z]*$"},errorMessage:"CARD_EDITOR.VALIDATOR.NOT_AN_ALPHABETIC"}}},key:"text"};var _={config:{type:"string"},key:"src"};var f={type:"icon",src:"",shape:"Circle",alt:"",text:"",backgroundColor:"",color:""};var y=a.ColorPickerMode;var C=a.ColorPickerDisplayMode;d.prototype.init=function(){this._oIconModel=new n(r(f));this._oIconModel.setDefaultBindingMode("OneWay");this.setModel(this._oIconModel,"icon");this._oConfigsModel=new n({selectConfig:{type:"select",items:[],allowBindings:false},valueConfig:u});this._oConfigsModel.setDefaultBindingMode("OneWay");this.setModel(this._oConfigsModel,"configs");this._oSettingsModel=new n({shapes:[],altVisible:true,backgroundColorVisible:false,colorVisible:false});this._oSettingsModel.setDefaultBindingMode("OneWay");this.setModel(this._oSettingsModel,"settings");this.attachModelContextChange(function(){if(this.getModel("i18n")){var t=r(this._oConfigsModel.getData());t.selectConfig.items=[{key:"icon",title:this.getI18nProperty("BASE_EDITOR.ICON.TYPE_ICON")},{key:"text",title:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_TEXT_LABEL")},{key:"picture",title:this.getI18nProperty("BASE_EDITOR.ICON.TYPE_PICTURE")}];this._oConfigsModel.setData(t);var e=r(this._oSettingsModel.getData());e.shapes=[{key:"Square",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_SQUARE")},{key:"Circle",text:this.getI18nProperty("BASE_EDITOR.ICON.SETTINGS_DIALOG_SHAPE_CIRCLE")}];this._oSettingsModel.setData(e)}},this)};d.prototype.getExpectedWrapperCount=function(){return 2};d.prototype.setValue=function(t){var o=g(t)?undefined:t;e.prototype.setValue.call(this,o);this._oIconModel.setData(Object.assign({},this._oIconModel.getData(),t,{type:this.getDesigntimeMetadataValue().type||D(t)}))};function D(t){if(l(t)){if(t.src){if(t.backgroundColor||t.color||c.isIconURI(t.src)&&c.getIconInfo(t.src)||o(t.src,false)){return"icon"}else{return"picture"}}else if(t.text){return"text"}}return f.type}d.prototype._prepareValue=function(t,e){return e[t]};d.prototype._onTypeChange=function(t){var e;var o=t.getSource().getValue();switch(o){case"icon":e=u;this._oSettingsModel.setProperty("/altVisible",true);break;case"text":e=h;this._oSettingsModel.setProperty("/altVisible",false);break;case"picture":e=_;this._oSettingsModel.setProperty("/altVisible",true);break}this._oConfigsModel.setData(Object.assign({},this._oConfigsModel.getData(),{valueConfig:e}));this.setDesigntimeMetadataValue({type:o});this.setValue(this._processOutputValue(this._oIconModel.getData()))};d.prototype._updateValue=function(t){var e=this._oConfigsModel.getData().valueConfig.key;var o={};o[e]=t.getSource().getValue();var i=Object.assign({},this._oIconModel.getData(),o);this.setValue(this._processOutputValue(i))};d.prototype._handleSettings=function(){this._oOldData=r(this.getModel("icon").getData());if(!this._oSettingsDialog){return i.load({name:"sap.ui.integration.designtime.cardEditor.propertyEditor.iconEditor.IconEditorSettingsDialog",controller:this}).then(function(t){this._oDialogModel=new n(this._oOldData);this._oSettingsDialog=t;this._oSettingsDialog.setModel(this._oDialogModel,"data");this.addDependent(this._oSettingsDialog);this._oSettingsDialog.open();return this._oSettingsDialog}.bind(this))}else{this._oSettingsDialog.open();this._oDialogModel.setData(this._oOldData);return Promise.resolve(this._oSettingsDialog)}};d.prototype._onSettingsSave=function(){this._oSettingsDialog.close();this.setValue(this._processOutputValue(this._oDialogModel.getData()))};d.prototype._onSettingsCancel=function(){this._oSettingsDialog.close()};d.prototype._processOutputValue=function(t){var e=this.getDesigntimeMetadataValue().type;var o=["type"];Object.keys(t).forEach(function(e){if(!t[e]||t[e]===f[e]){o.push(e)}});switch(e){case"icon":o.push("text");if(!t["src"]){o.push("shape","alt","backgroundColor","color")}break;case"picture":o.push("text","backgroundColor","color");if(!t["src"]){o.push("shape","alt")}break;case"text":o.push("src","alt");if(!t["text"]){o.push("shape","backgroundColor","color")}break}return p(t,o)};d.prototype._openColorPickerPopup=function(t){this._inputId=t.getSource().getId();if(!this.oColorPickerSimplifiedPopover){this.oColorPickerSimplifiedPopover=new s("oColorPickerSimpplifiedPopover",{colorString:"blue",displayMode:C.Simplified,mode:y.HSL,change:this._handleColorPickerChange.bind(this)})}this.oColorPickerSimplifiedPopover.openBy(t.getSource())};d.prototype._handleColorPickerChange=function(e){var o=t.getElementById(this._inputId);o.setValue(e.getParameter("hex"));o.setValueState("None");this._inputId=""};d.prototype.getFocusDomRef=function(){var t=this.getContent();if(t){return this.getContent().getItems()[0].getContent()[0].getFocusDomRef()}};d.prototype.getIdForLabel=function(){var t=this.getContent();if(t){return this.getContent().getItems()[0].getContent()[0].getIdForLabel()}};return d});
//# sourceMappingURL=IconEditor.js.map