/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/integration/editor/Editor","sap/ui/integration/widgets/Card","sap/ui/integration/editor/Merger","sap/ui/model/json/JSONModel","sap/base/util/merge","sap/ui/model/resource/ResourceModel","sap/ui/integration/library","sap/ui/integration/designtime/editor/CardPreview","sap/base/util/extend","sap/ui/integration/util/Utils","sap/base/Log"],function(e,t,i,r,n,o,a,s,d,g,u,l,_){"use strict";var h=d.CardDataMode,p;var c=i.extend("sap.ui.integration.designtime.editor.CardEditor",{metadata:{library:"sap.ui.integration",properties:{card:{type:"any",defaultValue:null}},aggregations:{_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"}}},renderer:i.getMetadata().getRenderer().render});c.prototype.hasPreview=function(){var e=this.getAggregation("_preview");if(e){if(e.getSettings()&&e.getSettings().preview&&e.getSettings().preview.modes==="None"){return false}return true}return false};c.prototype.getSeparatePreview=function(){var e=this.getPreviewPosition();if(!this.isReady()||e!=="separate"){return null}return this._initPreview()};c.prototype._updatePreview=function(){var e=this.getAggregation("_preview");if(e&&e.update&&e._getCurrentMode()!=="None"){e.update()}};c.prototype.setCard=function(t,i){if(t===this.getProperty("card")){return this}if(this._oEditorCard){this._oEditorCard.destroy()}this.setProperty("card",t,i);if(typeof t==="string"){try{t=JSON.parse(t)}catch(i){var n=e.getElementById(t);if(!n){var o=document.getElementById(t);if(o&&o.tagName&&o.tagName.toUpperCase()==="ui-integration-card".toUpperCase()){n=o._getControl()}}t=n}}if(t&&t.isA&&t.isA("sap.ui.integration.widgets.Card")){t={manifest:t.getManifest(),manifestChanges:t.getManifestChanges(),host:t.getHost(),baseUrl:t.getBaseUrl(),dataMode:h.Active}}if(typeof t==="object"){if(!t.dataMode){t.dataMode=h.Active}this._oEditorCard=new r(t);this._oEditorCard.attachEventOnce("_contentReady",function(){var e=this._oEditorCard.getCardContent();if(e){e.onBeforeRendering()}}.bind(this));this._oEditorCard.attachEventOnce("_dataReady",function(){this.propagateModels(this._oEditorCard,this,["i18n","context","contextflat"]);this.setJson(t,i)}.bind(this));this._oEditorCard.onBeforeRendering()}};c.prototype.initDestinations=function(e){this._destinationsModel=new o({});this.setModel(this._destinationsModel,"destinations");var t=this.getHostInstance();if(e&&!t){_.error("sap.ui.integration.designtime.editor.CardEditor: Host with id '"+e+"' is not available during card editor initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the card editor.","sap.ui.integration.designtime.editor.CardEditor")}this._oDestinations=this._oEditorCard._oDestinations};c.prototype.propagateModels=function(e,t,i){var r=u({},e.oPropagatedProperties.oModels,e.oModels),n=Object.keys(r),o=e.getModel();if(o){t.setModel(o)}i=i||[];n.forEach(function(r){if(r==="undefined"){return}if(i.includes(r)){return}var n=e.getModel(r);if(n){t.setModel(n,r)}})};c.prototype.createManifest=async function(e,t){this._isManifestReady=false;if(this._oEditorManifest){this._oEditorManifest.destroy()}this.destroyAggregation("_extension");var i=n.layers[this.getMode()];this._oEditorManifest=this._oEditorCard._oCardManifest;this._registerManifestModulePath();var r=this._oEditorManifest._oInitialJson;this._oInitialManifestModel=new o(r);this.setProperty("json",r,t);var d;if(this._beforeLayerManifestChanges){d=n.mergeDelta(r,[this._beforeLayerManifestChanges])}else{d=r}var g=a({},d);this._beforeManifestModel=new o(g);if(i<n.layers["translation"]&&this._currentLayerManifestChanges){d=n.mergeDelta(d,[this._currentLayerManifestChanges])}this._manifestModel=new o(d);this._isManifestReady=true;this.fireManifestReady();this._initResourceBundlesForMultiTranslation();if(this.getMode()==="translation"){await this._loadSpecialTranslations()}this._createContextModel();if(this._oEditorManifest&&this._oEditorManifest.getResourceBundle()){var u=this._oEditorManifest.getResourceBundle();var l=new s({bundle:u});await l.getResourceBundle();this.setModel(l,"i18n");if(this._oResourceBundle){await l.enhance(this._oResourceBundle)}this._oResourceBundle=await l.getResourceBundle()}return this._loadExtension().then(function(){this._initInternal()}.bind(this))};c.prototype._initPreview=function(){var e=this._oDesigntimeInstance.getSettings()||{};e.preview=e.preview||{};e.preview.position=this.getPreviewPosition();var t=new g({settings:e,card:this._oEditorCard,parentWidth:this.getWidth(),parentHeight:this.getHeight()});this.setAggregation("_preview",t);t.setAssociation("_editor",this);return t};c.prototype._loadExtension=function(){return new Promise(function(e,t){var i=this._oEditorCard.getAggregation("_extension");this.setAggregation("_extension",i);e()}.bind(this))};c.prototype._mergeContextData=function(e){var t={};t["empty"]=p.empty;for(var i in e){t[i]=e[i]}t["card.internal"]=p["card.internal"];return t};c.initContextEntries=function(){return{empty:{label:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"card.internal":{label:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_INTERNAL_VAL"),todayIso:{type:"string",label:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),description:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_TODAY_DESC"),tags:[],placeholder:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),description:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_NOW_DESC"),tags:[],placeholder:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),description:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:i.oResourceBundle.getText("CARDEDITOR_CONTEXT_CARD_LANG_VAL"),value:"{{parameters.LOCALE}}"}}}};p=c.initContextEntries();c.prototype._applyLanguageChange=function(){p=c.initContextEntries()};return c});
//# sourceMappingURL=CardEditor.js.map