/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/Core","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/base/Interface","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/integration/Designtime","sap/ui/model/json/JSONModel","sap/ui/model/odata/v4/ODataModel","sap/ui/integration/util/Utils","sap/ui/integration/util/Destinations","sap/ui/integration/util/DataProviderFactory","sap/m/Label","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/ResponsivePopover","sap/m/Popover","sap/m/Text","sap/base/Log","sap/ui/core/Popup","sap/base/i18n/ResourceBundle","sap/ui/integration/editor/EditorResourceBundles","sap/ui/dom/includeStylesheet","sap/base/util/LoaderExtensions","sap/ui/core/theming/Parameters","sap/base/util/ObjectPath","sap/m/FormattedText","sap/m/MessageStrip","sap/m/ToolbarSpacer","sap/ui/model/resource/ResourceModel","./Manifest","./Merger","./Settings","sap/m/FlexItemData","sap/m/FlexBox","sap/m/Button"],function(e,t,i,a,n,s,r,o,l,d,f,u,g,p,h,c,_,m,v,y,b,I,M,C,P,x,T,D,E,S,A,w,R,L,B,F,O,V,U,j){"use strict";var k=b.prototype.init;b.prototype.init=function(){k.apply(this,arguments);var e=this.oPopup._applyPosition,t=this;this.oPopup._applyPosition=function(){var i=t.close;t.close=function(){};e.apply(this,arguments);t.close=i}};function N(e){if(e&&e.nodeType!==1){return 0}var t=parseInt(window.getComputedStyle(e).getPropertyValue("z-index"));if(isNaN(t)){return N(e.parentNode)}return t+1}var W=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g,H=/\{\{parameters\.([^\}\}]+)/g,q=5e3,G="_strip",K="module:",z;var J=t.extend("sap.ui.integration.editor.Editor",{metadata:{library:"sap.ui.integration",properties:{mode:{type:"string",defaultValue:"admin"},language:{type:"string",defaultValue:""},allowDynamicValues:{type:"boolean",defaultValue:false},allowSettings:{type:"boolean",defaultValue:false},designtime:{type:"object"},section:{type:"string",defaultValue:"sap.card"},host:{type:"string",defaultValue:""},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},json:{type:"object"},previewPosition:{type:"string",defaultValue:"right"},width:{type:"sap.ui.core.CSSSize",defaultValue:""},height:{type:"sap.ui.core.CSSSize",defaultValue:""}},aggregations:{_formContent:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_preview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.editor.Extension",multiple:false,visibility:"hidden"}},events:{manifestReady:{},fieldReady:{},destinationReady:{},UIReady:{},ready:{}}},renderer:{apiVersion:2,render:function(e,t){var i=t.getAggregation("_preview");var a=t.getMode()!=="translation"&&t.hasPreview();var s=t.getPreviewPosition();if(a&&(s==="top"||s==="bottom")){e.openStart("div",t);e.openEnd();if(t.isFieldReady()&&s==="top"){e.renderControl(i)}}if(a&&s==="left"){e.openStart("div",t);e.class("sapUiIntegrationEditor");e.openEnd();if(t.isFieldReady()){e.renderControl(i)}}else if(a&&(s==="top"||s==="bottom")){e.openStart("div");e.class("sapUiIntegrationEditor");e.openEnd()}else{e.openStart("div",t);e.class("sapUiIntegrationEditor");e.openEnd()}if(t.isFieldReady()){e.openStart("div");e.class("sapUiIntegrationEditorForm");if(t.getMode()!=="translation"){e.class("settingsButtonSpace")}e.openEnd();if(t.getMode()!=="translation"){e.renderControl(t.getAggregation("_messageStrip"))}var r=t.getAggregation("_formContent");if(r){var l;var d;var f;var u;var g=[];var p=[];var h;var c=function(){if(g.length>0){var e=2-g.length;for(var t=0;t<e;t++){g.push(new m)}l.addContent(new U({alignItems:"Start",justifyContent:"SpaceBetween",items:g}));g=[]}};var v=function(){if(p.length>0){var e=2-p.length;for(var t=0;t<e;t++){p.push(new m)}d.addContent(new U({alignItems:"Start",justifyContent:"SpaceBetween",items:p}));p=[]}};var y=function(t){if(t.getContent().length>0){var i=t.getContent();if(i.length===1&&i[0].isA("sap.m.MessageStrip")){return}if(i[0].isA("sap.m.MessageStrip")){t.removeContent(0);t.addContent(i[0])}e.renderControl(t.getParent());if(t._messageStrip){e.renderControl(t._messageStrip)}}};var b=function(e,t){if(e&&t.getContent().length>0){var i=t.getContent();if(i[0].isA("sap.m.MessageStrip")){t.removeContent(0);t.addContent(i[0])}e.addContent(t.getParent());if(t._messageStrip){e.addContent(t._messageStrip)}}else{t=null}};var I=function(e,t){var i=e.getContent(),a;if(i.length>0){for(var n=0;n<i.length;n++){if(i[n].getAggregation("_field")&&i[n].getAggregation("_field").isA("sap.m.IconTabBar")){a=i[n].getAggregation("_field")}}}if(a&&t.getContent().length>0){a.addItem(t)}};for(var M=0;M<r.length;M++){var C=r[M];if(t.getMode()!=="translation"){if(C.isA("sap.ui.integration.editor.fields.GroupField")){var P=C.getAggregation("_field");if(!P){continue}if(d){v();if(P.isA("sap.m.Panel")&&d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}var x=0;if(P.isA("sap.m.Panel")){x=P._level}else if(P.isA("sap.m.IconTabBar")){x="1"}if(x==="1"){if(g.length>0){c()}if(P.isA("sap.m.IconTabBar")){var T=l.getContent(),D=false,E;if(T.length>0){for(var S=0;S<T.length;S++){if(T[S].getAggregation("_field")&&T[S].getAggregation("_field").isA("sap.m.IconTabBar")){D=true;E=T[S].getAggregation("_field")}}}d=P.getItems()[0];d._subItems=d._subItems||[];if(!D){P.removeItem(P.getItems()[0]);if(P._messageStrip){l.addContent(P._messageStrip)}P.addStyleClass("sapUiIntegrationEditorSubTab");l.addContent(C)}else{E.addItem(P.getItems()[0]);P.destroy()}}else{d=P;d._subItems=d._subItems||[]}}else{if(l){c();y(l);d=null}l=P;l._subItems=l._subItems||[];l.addStyleClass("sapUiIntegrationEditorItem")}if(M===r.length-1){c();y(l)}continue}if(C.isA("sap.m.FormattedText")){if(d){d.addContent(C.addStyleClass("sapUiIntegrationEditorHint"))}else{l.addContent(C.addStyleClass("sapUiIntegrationEditorHint"))}if(M===r.length-1){if(d){v();b(l,d)}c();y(l)}continue}var A=C._layout;if(C.isA("sap.m.Label")){C.addStyleClass("sapUiIntegrationEditorItemLabel");if(C.getRequired()){C.addStyleClass("sapUiIntegrationEditorItemLabelWithRequired")}if(A&&!n(A,{})){if(A.alignment&&A.alignment.label==="end"){C.setTextAlign("End")}u=C}else{if(C._cols===2){if(d){v()}else{c()}}else if(p.length===2){v()}else if(g.length===2){c()}if(d){d.addContent(C)}else{l.addContent(C)}}}else if(C.isA("sap.m.ToolbarSpacer")){if(C._hasLine){C.addStyleClass("sapUiIntegrationEditorSpacerWithLine")}else{C.addStyleClass("sapUiIntegrationEditorSpacerWithoutLine")}if(d){v();d.addContent(C)}else{c();l.addContent(C)}}else{var w=C.getConfiguration(),R=new _,L=.1,B=0,F;if(C._descriptionIcon){R.addItem(C._descriptionIcon);L+=.9}var O=o.getElementById(C.getAssociation("_messageIcon"));if(C.getAssociation("_messageIcon")&&O){R.addItem(O);L+=1.2}if(C._settingsButton){C._settingsButton.addStyleClass("sapUiIntegrationEditorSettingsButton");B=2}var j=new V({growFactor:10,maxWidth:"calc(100% - "+B+"rem)"});var k=new V({maxWidth:"calc(100% - "+L+"rem)"});if(u){var N,W,H="50%";if(A&&A["label-width"]){H=A["label-width"]}var q=parseInt(H);var G=100-q;if(C._cols===2){q=q-.5;G=G-.5}if(A.alignment&&A.alignment.field==="end"){C.addStyleClass("sapUiIntegrationEditorFieldAlignEnd")}if(A.alignment&&A.alignment.label==="end"){u.setLayoutData(new V({maxWidth:"calc(100% - "+L+"rem)",minWidth:"calc(100% - "+L+"rem)"}))}else{u.setLayoutData(k)}if(R.getItems().length>0){u.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");F=new _({items:[u,R]})}else{F=u}if(A&&A.position&&A.position==="field-label"){F.setLayoutData(j);W=new _({alignItems:"Start",justifyContent:"SpaceBetween",items:[F,C._settingsButton]});W.setLayoutData(new V({growFactor:q,maxWidth:q+"%"}));C.setLayoutData(new V({growFactor:G,maxWidth:G+"%"}));N=new _({alignItems:"Start",justifyContent:"SpaceBetween",items:[C,W]})}else{C.setLayoutData(j);W=new _({alignItems:"Start",justifyContent:"SpaceBetween",items:[C,C._settingsButton]});F.setLayoutData(new V({growFactor:q,maxWidth:q+"%"}));W.setLayoutData(new V({growFactor:G,maxWidth:G+"%"}));N=new _({alignItems:"Start",justifyContent:"SpaceBetween",items:[F,W]})}if(C._cols===1){if(d){if(p.length===2){v()}if(w.hint){var K=t._createHint(w.hint,C.getParameterId());var z=new m({items:[N,K.addStyleClass("sapUiIntegrationEditorHint")]});z.addStyleClass("col1");p.push(z)}else{N.addStyleClass("col1");p.push(N)}}else{if(g.length===2){c()}if(w.hint){var K=t._createHint(w.hint,C.getParameterId());var z=new m({items:[N,K.addStyleClass("sapUiIntegrationEditorHint")]});z.addStyleClass("col1");g.push(z)}else{N.addStyleClass("col1");g.push(N)}}}else if(d){v();d.addContent(N)}else{c();l.addContent(N)}u=null}else{var J;if(d){J=d.getContent().pop()}else{J=l.getContent().pop()}J.setLayoutData(k);if(R.getItems().length>0){J.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");F=new _({items:[J,R]})}else{F=J}F.setLayoutData(j);var X=new U({alignItems:"Start",justifyContent:"SpaceBetween",items:[F,C._settingsButton]});if(C._cols===1){var z=new m({items:[X,C]});if(w.hint){var K=t._createHint(w.hint,C.getParameterId());z.addItem(K.addStyleClass("sapUiIntegrationEditorHint"))}z.addStyleClass("col1");if(d){p.push(z)}else{g.push(z)}}else if(d){d.addContent(X);d.addContent(C)}else{l.addContent(X);l.addContent(C)}}if(d){d._subItems.push({settingspath:C.getConfiguration()._settingspath,itemId:C.getId()})}l._subItems.push({settingspath:C.getConfiguration()._settingspath,itemId:C.getId()})}if(M===r.length-1){if(d){v();if(d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}c();y(l)}}else{if(M===0){f=C.getAggregation("_field");e.renderControl(C);C.addStyleClass("sapUiIntegrationEditorTranslationPanel");continue}if(C.isA("sap.ui.integration.editor.fields.GroupField")){var P=C.getAggregation("_field");if(d){if(P.isA("sap.m.Panel")&&d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}var Y=0;if(P.isA("sap.m.Panel")){Y=P._level}else if(P.isA("sap.m.IconTabBar")){if(P.getItems().length>0&&P.getItems()[0]._level){Y=P.getItems()[0]._level}}if(Y==="1"){if(P.isA("sap.m.IconTabBar")){if(M!==r.length-1||M<r.length&&(r[M].isA("sap.m.IconTabBar")||r[M].isA("sap.m.Panel"))){var Z=l.getContent(),Q=false;if(Z.length>0){for(var $=0;$<Z.length;$++){if(Z[$].getAggregation("_field")&&Z[$].getAggregation("_field").isA("sap.m.IconTabBar")){Q=true}}}if(!Q){d=P.getItems()[0];P.removeItem(P.getItems()[0]);l.addContent(P.getParent())}else{d=P.getItems()[0]}}}else{d=P}}else{d=null;if(l&&l.getContent().length>0){f.addContent(l.getParent())}l=P}if(M===r.length-1){c();y(l)}continue}if(C.isA("sap.m.ToolbarSpacer")){continue}if(C.isA("sap.m.FormattedText")){continue}if(C.isA("sap.m.Label")){if(d){d.addContent(C)}else{l.addContent(C)}continue}if(C.isOrigLangField){h=C;continue}h.addStyleClass("sapUiIntegrationFieldTranslationText");var N=new _({items:[h,C]}).addStyleClass("notWrappingRow");if(d){d.addContent(N)}else{l.addContent(N)}if(M===r.length-1){if(d){if(d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}f.addContent(l.getParent())}}}}e.close("div");if(a&&s==="right"){e.renderControl(i)}}e.close("div");if(a&&(s==="top"||s==="bottom")){if(s==="bottom"){e.renderControl(i)}e.close("div")}if(t.isFieldReady()&&!t.isReady()){t.fireUIReady();if(t._aFieldDataReadyPromise.length>0){Promise.all(t._aFieldDataReadyPromise).then(function(){t._aFieldDataReadyPromise=[];if(!t.isReady()){t._ready=true;t.fireReady()}})}else{t._ready=true;t.fireReady()}}}}});J.prototype.init=function(){if(J.oResourceBundle&&J.oResourceBundle.sLocale!==g._language){J.oResourceBundle=l.getResourceBundleFor("sap.ui.integration",g._language);this._applyLanguageChange()}this._fieldReady=false;this._ready=false;this._aFieldReadyPromise=[];this._aFieldDataReadyPromise=[];this._oResourceBundle=l.getResourceBundleFor("sap.ui.integration",g._language);this._appliedLayerManifestChanges=[];this._currentLayerManifestChanges={};this._mDestinationDataProviders={};var t=new w(this.getId()+G,{showIcon:false});t.addStyleClass("sapUiIntegrationEditorFieldMessageStrip");this.setAggregation("_messageStrip",t);G=t.getId();this.setLanguage(e.getLanguage());this._oLimitedInterface=new r(this,["getParameters","resolveDestination","request","getModel"])};J.prototype.getParameters=function(){if(!this._isManifestReady){M.error("sap.ui.integration.editor.Editor: the manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null}var e=this._oEditorManifest.getProcessedParameters(),t={},i;for(i in e){t[i]=e[i].value}return t};J.prototype.resolveDestination=function(e){return this._oDestinations.getUrl(e)};J.prototype.isReady=function(){return this._ready};J.prototype.isFieldReady=function(){return this._fieldReady};J.prototype.hasPreview=function(){var e=this.getAggregation("_preview");if(e&&e.visible!==false){return true}return false};J.prototype.getSeparatePreview=function(){var e=this.getPreviewPosition();if(!this.isFieldReady()||e!=="separate"){return null}if(!this._oPreview){this._oPreview=this.getAggregation("_preview")}return this._oPreview};J.prototype.flattenData=function(e,t,i,a){a=a||"";i=i||[];if(typeof e==="object"){if(!e[t]){for(var n in e){this.flattenData(e[n],t,i,a+"/"+n)}}else{if(e.type){i.push({path:e.pathvalue||a.substring(1),value:e.pathvalue||"{context>"+a.substring(1)+"/value}",object:e})}else{i.push({path:a.substring(1),object:e});for(var n in e){this.flattenData(e[n],t,i,a+"/"+n)}}}}return i};J.prototype.setJson=function(e,t){this._fieldReady=false;this._ready=false;if(n(e,this._preIdOrSettings)){return this}this._preIdOrSettings=a(e,500);if(typeof e==="string"){try{e=JSON.parse(e)}catch(e){}}if(typeof e==="object"){if(e.manifestChanges){g.mapLanguagesInManifestChanges(e.manifestChanges);this._filterManifestChangesByLayer(e)}if(this._manifestModel){return}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy()}if(e.host){this.setProperty("host",e.host)}if(e.baseUrl){this.setProperty("baseUrl",e.baseUrl)}this._appliedLayerManifestChanges=e.manifestChanges;this.createManifest(e,t)}};J.prototype.createManifest=function(e,t){var i=this.getBaseUrl();var a={},n=e.manifest;this._isManifestReady=false;if(typeof n==="string"){a.manifestUrl=n;n=null}if(this._oEditorManifest){this._oEditorManifest.destroy()}this.destroyAggregation("_extension");var r=F.layers[this.getMode()];this._oEditorManifest=new B(this.getSection(),n,i,e.manifestChanges);this._oEditorManifest.load(a).then(async function(){this._registerManifestModulePath();this._oInitialManifestModel=new f(this._oEditorManifest._oInitialJson);this.setProperty("json",this._oEditorManifest._oInitialJson,t);var e=this._oEditorManifest.oJson;var i=s({},e);this._beforeManifestModel=new f(i);if(r<F.layers["translation"]&&this._currentLayerManifestChanges){e=F.mergeDelta(e,[this._currentLayerManifestChanges],this.getSection())}this._manifestModel=new f(e);this._isManifestReady=true;this.fireManifestReady();this._initResourceBundlesForMultiTranslation();this._loadDefaultTranslations();if(this.getMode()==="translation"){await this._loadSpecialTranslations()}this._createContextModel();if(this._oEditorManifest.getResourceBundle()){this._enhanceI18nModel(this._oEditorManifest.getResourceBundle())}return this._loadExtension().then(function(){this._initInternal()}.bind(this))}.bind(this))};J.prototype._initResourceBundlesForMultiTranslation=function(){var e=this._oEditorManifest.get("/sap.app/i18n");var t;var i;if(typeof e==="string"){t=this.getBaseUrl()+e}else if(typeof e==="object"){if(e.bundleUrl){t=this.getBaseUrl()+e.bundleUrl}if(e.supportedLocales){i=e.supportedLocales}}this._oEditorResourceBundles=new x({url:t,languages:J._oLanguages,supportedLocales:i});this._oEditorResourceBundles.loadResourceBundles()};J.prototype._registerManifestModulePath=function(){if(!this._oEditorManifest){return}this._sAppId=this._oEditorManifest.get("/sap.app/id");if(this._sAppId){D.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oEditorManifest.getUrl()||"/")}else{M.error("sap.ui.integration.editor.Editor: sap.app/id entry in the manifest is mandatory")}};J.prototype._loadDefaultTranslations=async function(){if(this._defaultTranslationsLoaded){return}var e=new L({bundle:this._oResourceBundle});await e.getResourceBundle();this.setModel(e,"i18n");this._defaultTranslationsLoaded=true};J.prototype._enhanceI18nModel=async function(e){var t=this.getModel("i18n");if(t.getResourceBundle().oUrlInfo.url!==e.oUrlInfo.url){await t.enhance(e);this._oResourceBundle=await t.getResourceBundle()}};J.prototype._loadExtension=function(){var e=this._oEditorManifest.get(this.getConfigurationPath()+"/extension")||this._oEditorManifest.get("/"+this.getSection()+"/extension"),t;if(!e){M.info("sap.ui.integration.editor.Editor: extension is not defined in manifest, do not load it.");return new Promise(function(e,t){e()})}if(e.startsWith(K)){t=e.replace(K,"")}else{t=this._sAppId.replace(/\./g,"/")+"/"+e}return new Promise(function(i,a){sap.ui.require([t],function(e){var t=new e;if(t._setEditor){t._setEditor(this,this._oLimitedInterface);this.setAggregation("_extension",t)}i()}.bind(this),function(t){M.error("sap.ui.integration.editor.Editor: failed to load "+e+". Check if the path is correct. Reason: "+t);a(t)})}.bind(this))};J.prototype.request=function(e){var t=this._oDataProviderFactory.create({request:e}).setAllowCustomDataType(true);return t._waitDependencies().then(function(){return t.getData()})};J.prototype.initDestinations=function(e){this._destinationsModel=new f({});this.setModel(this._destinationsModel,"destinations");var t=this.getHostInstance();if(e&&!t){M.error("sap.ui.integration.editor.Editor: Host with id '"+e+"' is not available during editor initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the editor.","sap.ui.integration.editor.Editor")}if(this._oDestinations){this._oDestinations.setHost(t)}else{var i=this.getConfigurationPath();this._oDestinations=new p({host:t,manifestConfig:this._manifestModel.getProperty(i+"/destinations")})}};J.prototype.initDataProviderFactory=function(){if(this._oDataProviderFactory){this._oDataProviderFactory.destroy()}var e=this.getAggregation("_extension");this._oDataProviderFactory=new h({destinations:this._oDestinations,extension:e,csrfTokensConfig:this._oEditorManifest.get(this.getConfigurationPath()+"/csrfTokens"),editor:this})};J.prototype.getRuntimeUrl=function(e){var t=this._sAppId,i,a=e&&e.trim().replace(/^\//,"");if(t===null){M.error("sap.ui.integration.editor.Editor: manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null}if(!t||e.startsWith("http://")||e.startsWith("https://")||e.startsWith("//")){return e}i=t.replace(/\./g,"/");return sap.ui.require.toUrl(i)+"/"+a};J.prototype.getBindingNamespaces=function(){var e={},t=this.getAggregation("_extension");if(t){e.extension={formatters:t.getFormatters()}}return e};J.prototype.getHostInstance=function(){var e=this.getHost();if(!e){return null}return o.getElementById(e)};J.prototype.setLanguage=function(e,t){if(!e||typeof e!=="string"){return this}this._language=e.replaceAll("_","-");if(this.getLanguage()!=e){this._loadDefaultTranslations()}this.setProperty("language",e,t);if(!J._oLanguages[this._language]){this._language=this._language.split("-")[0]}if(!J._oLanguages[this._language]){M.warning("sap.ui.integration.editor.Editor: language: "+e+" is currently unknown, some UI controls might show "+e+" instead of the language name.")}return this};J.prototype.onAfterRendering=function(){if(this.getDomRef()){this._iZIndex=N(this.getDomRef());C.setInitialZIndex(this._iZIndex)}};J.prototype._filterManifestChangesByLayer=function(t){var i=[],a=this,n={},r={":layer":F.layers[this.getMode()]},o=F.layers[a.getMode()];t.manifestChanges.forEach(function(t){var l=t.hasOwnProperty(":layer")?t[":layer"]:1e3;if(l===F.layers["translation"]){var d=a._language;if(d===""){d=e.getLanguage().replaceAll("_","-")}var f={texts:{}};delete t.texts;f.texts[d]={};Object.keys(t).forEach(function(e){if(e.charAt(0)==="/"){f.texts[d][e]=t[e]}else{f[e]=t[e]}});t=f}if(l<o){i.push(t);n=s(n,t)}else if(l===o){r=t}});t.manifestChanges=i;this._currentLayerManifestChanges=r;this._beforeLayerManifestChanges=n};J.prototype._initInternal=function(){var e=this;var t=e.getConfigurationPath();var i=e._oEditorManifest.get(t+"/editor");if(!i){i=e._oEditorManifest.get("/"+e.getSection()+"/designtime")}var a=e._manifestModel.getProperty(t),n,s=e.getDesigntime();if(s){if(typeof s==="function"){n=new Promise(function(t,i){var a=new s;e._applyDesigntimeDefaults(a.getSettings());t(a)})}else if(typeof s==="object"){n=new Promise(function(t,i){sap.ui.require(["sap/ui/integration/Designtime"],function(i){var a=i.extend("test.Designtime");a.prototype.create=function(){return s};var n=new a;e._applyDesigntimeDefaults(n.getSettings());t(n)})})}}else if(i){n=e.loadDesigntime().then(function(t){e._applyDesigntimeDefaults(t.getSettings());return t})}else{n=Promise.resolve(e._createParameterDesigntime(a))}n.then(function(t){e._oDesigntimeInstance=t;e.initDestinations();e.initDataProviderFactory();if(e.getMode()==="admin"||e.getMode()==="all"){e._addDestinationSettings(a)}else{e._deleleDestinationSettings()}e._settingsModel=new f(e._oDesigntimeInstance.getSettings());e.setModel(e._settingsModel,"currentSettings");e.setModel(e._settingsModel,"items");return e._loadValueContextInDesigntime()}).then(function(){e._applyDesigntimeLayers();return e._requestExtensionData()}).then(function(){e._requireFields().then(function(){e._startEditor()})})};J.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime)}if(!this._oEditorManifest){return new Promise(function(e,t){this.attachManifestReady(function(){this.loadDesigntime().then(e,t)}.bind(this))}.bind(this))}if(!this._sAppId){return Promise.reject("App id not maintained")}return new Promise(function(e,t){var i=this._oEditorManifest.get(this.getConfigurationPath()+"/editor");if(!i){i=this._oEditorManifest.get("/"+this.getSection()+"/designtime")}var a=this._sAppId.replace(/\./g,"/")+"/"+i;if(a){sap.ui.require([a],function(t){t=new t;t._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=t;e(t)}.bind(this))}.bind(this),function(){t({error:a+" not found"})})}else{t()}}.bind(this))};J.prototype.getConfigurationPath=function(){return"/"+this.getSection()+"/configuration"};J.prototype.getCurrentSettings=function(){var e=this._settingsModel.getProperty("/"),t={},i;if(e&&e.form&&e.form.items){for(var r in e.form.items){var o=e.form.items[r];if(o.editable&&o.visible){if(this.getMode()!=="translation"){if(o.translatable&&!o._changed&&o._translatedPlaceholder&&!this._currentLayerManifestChanges[o.manifestpath]){}else{if(o.valueItems&&!n(this._beforeLayerManifestChanges[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueItems"],o.valueItems)){t[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueItems"]=o.valueItems}if(o.valueTokens&&!n(this._beforeLayerManifestChanges[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueTokens"],o.valueTokens)){t[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueTokens"]=o.valueTokens}var l=this._beforeLayerManifestChanges[o.manifestpath];if(typeof o.value!=="undefined"&&!n(l,o.value)){switch(o.type){case"string":if(!o.translatable){t[o.manifestpath]=o.value}else if(o._hasDynamicValue){t[o.manifestpath]=o.value;this.deleteAllTranslationValuesInTexts(o.manifestpath)}else if(o._beforeValue&&(o._beforeValue.indexOf("{context>")===0||o._beforeValue.indexOf("{{parameters")===0)){t[o.manifestpath]=o.value}break;case"group":break;case"date":case"datetime":if(l){if(o.value){var d=new Date(l);var f=new Date(o.value);if(d.getTime()!==f.getTime()){t[o.manifestpath]=o.value}}}else if(o.value){t[o.manifestpath]=o.value}break;case"object":if(o.value&&o.value!==""&&typeof o.value==="object"){t[o.manifestpath]=o.value}break;case"object[]":if(Array.isArray(o.value)){var u=a(o.value,500);u=u.sort(function(e,t){if(!e._dt||!e._dt._position||!t._dt||!t._dt._position){return 0}return e._dt._position-t._dt._position});for(var g=0;g<u.length;g++){var p=u[g];p._dt=p._dt||{};p._dt._position=g+1}t[o.manifestpath]=u}break;default:t[o.manifestpath]=o.value}}}}else if(o.translatable&&o.value){if(o._changed){t[o.manifestpath]=o.value}else if(this._currentLayerManifestChanges&&this._currentLayerManifestChanges.texts&&this._currentLayerManifestChanges.texts[this._language]&&this._currentLayerManifestChanges.texts[this._language][o.manifestpath]){t[o.manifestpath]=this._currentLayerManifestChanges.texts[this._language][o.manifestpath]}}if(o._next&&this.getAllowSettings()){if(o.type==="destination"){if(o._next.pageAdminNewDestinationParameter){i=i||{};i[o._settingspath+"/pageAdminNewDestinationParameter"]=o._next.pageAdminNewDestinationParameter}}else{var h=typeof o.visibleToUser==="undefined"?true:o.visibleToUser;var c=typeof o.editableToUser==="undefined"?true:o.editableToUser;var _=typeof o.allowDynamicValues==="undefined"?true:o.allowDynamicValues;if(o._next.visible===!h){i=i||{};i[o._settingspath+"/visible"]=o._next.visible}if(o._next.editable===!c){i=i||{};i[o._settingspath+"/editable"]=o._next.editable}if(o._next.allowDynamicValues===!_){i=i||{};i[o._settingspath+"/allowDynamicValues"]=o._next.allowDynamicValues}if(o._next.pageAdminValues){i=i||{};i[o._settingspath+"/pageAdminValues"]=o._next.pageAdminValues}}}}}}if(this.getMode()==="translation"){delete t.texts}else if(e.texts){t.texts=a(e.texts,500)||{};var m=s({},this._beforeLayerManifestChanges.texts);if(n(m,t.texts)){delete t.texts}else{for(var v in t.texts){if(n(m[v],t.texts[v])){delete t.texts[v]}else{for(var y in t.texts[v]){if(m[v]&&n(m[v][y],t.texts[v][y])){delete t.texts[v][y]}else if(typeof t.texts[v][y]==="object"){var b=t[y];if(!b||typeof b!=="object"||n(b,{})||n(b,[])){delete t.texts[v][y]}else if(Array.isArray(b)){var I=b.map(function(e){return e._dt?e._dt._uuid||"":""});for(var M in t.texts[v][y]){if(!I.includes(M)){delete t.texts[v][y][M]}}}else{var C=b._dt?b._dt._uuid||"":"";if(C!==""){var P=t.texts[v][y][C];if(!P){delete t.texts[v][y]}else{t.texts[v][y]={};t.texts[v][y][C]=P}}else{delete t.texts[v][y]}}}}if(n(t.texts[v],{})){delete t.texts[v]}}}if(n(t.texts,{})){delete t.texts}}}t[":layer"]=F.layers[this.getMode()];t[":errors"]=this.checkCurrentSettings()[":errors"];if(i){t[":designtime"]=i}if(e[":designtime"]){t[":designtime"]=s(t[":designtime"],e[":designtime"])}return t};J.prototype.checkCurrentSettings=function(){var e=this._settingsModel.getProperty("/"),t={};if(e&&e.form&&e.form.items){for(var i in e.form.items){var a=e.form.items[i];if(a.editable){if(a.validateCheck==="failed"){t[a.manifestpath]=false}else if((a.isValid||a.required)&&!(this.getMode()==="translation"&&a.translatable)){if(a.isValid){t[a.manifestpath]=a.isValid(a)}t[a.manifestpath]=true;var n=a.value;var s=a.type;if(s==="string"&&n===""){t[a.manifestpath]=n}if((s==="date"||s==="datetime")&&isNaN(Date.parse(n))){t[a.manifestpath]=n}if(s==="integer"){if(isNaN(parseInt(n))){t[a.manifestpath]=n}else if(n<a.min||n>a.max){t[a.manifestpath]=n}}if(s==="number"){if(isNaN(parseFloat(n))){t[a.manifestpath]=n}else if(n<a.min||n>a.max){t[a.manifestpath]=n}}}}}t[":layer"]=F.layers[this.getMode()]}t[":errors"]=Object.values(t).indexOf(false)>-1;return t};J.prototype._createContextModel=function(){var e=this.getHostInstance(),t=new f({}),i=new f([]);this.setModel(t,"context");this.setModel(i,"contextflat");t._aPendingPromises=[];i._getPathObject=function(e){var t=this.getData().filter(function(t){if(t.path===e){return true}});return t.length?t[0]:null};i._getValueObject=function(e){var t=this.getData()||[];t=t.filter(function(t){if(t.value===e||t.object.value===e){return true}});return t.length?t[0]:null};var a=new Promise(function(t,i){if(e&&e.getContext){var a=false;setTimeout(function(){if(a){return}M.error("sap.ui.integration.editor.Editor: context could not be determined with "+q+".");a=true;t({})},q);e.getContext().then(function(e){if(a){M.error("sap.ui.integration.editor.Editor: context returned after more than "+q+". Context is ignored.")}a=true;t(e||{})})}else{t({})}});a.then(function(e){var a=this._mergeContextData(e);t.setData(a);i.setData(this.flattenData(a,"label"))}.bind(this));t.getProperty=function(t,i){if(t&&!t.startsWith("/")&&!i){t="/"+t}var a=this.resolve(t,i),n;if(a.endsWith("/value")){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(a)){return this._mValues[a]}this._mValues[a]=undefined;n=g.timeoutPromise(e.getContextValue(a.substring(1)));n=n.then(function(e){this._mValues[a]=e;this.checkUpdate()}.bind(this)).catch(function(e){this._mValues[a]=null;this.checkUpdate();M.error("sap.ui.integration.editor.Editor: path "+a+" could not be resolved. Reason: "+e)}.bind(this));this._aPendingPromises.push(n);return undefined}else{return f.prototype.getProperty.apply(this,arguments)}}};J.prototype._mergeContextData=function(e){var t={};t["empty"]=z.empty;for(var i in e){t[i]=e[i]}t["editor.internal"]=z["editor.internal"];return t};J.prototype._loadValueContextInDesigntime=function(){var e=this.getModel("context");var t=this._oDesigntimeInstance.getSettings();var i;if(t&&t.form&&t.form.items){i=JSON.stringify(t.form.items)}if(i){var a=/\{context\>[\/?\w+.]+\}/g;var n=i.match(a);var s;if(n&&n.length>0){n=n.filter(function(e){return e.endsWith("value}")});s=n.map(function(e){return e.substring("{context>".length,e.length-1)});s.forEach(function(t){e.getProperty(t)});return Promise.all(e._aPendingPromises).then(function(){e._aPendingPromises=[]})}}return Promise.resolve()};J.fieldMap={string:"sap/ui/integration/editor/fields/StringField","string[]":"sap/ui/integration/editor/fields/StringListField",integer:"sap/ui/integration/editor/fields/IntegerField",number:"sap/ui/integration/editor/fields/NumberField",boolean:"sap/ui/integration/editor/fields/BooleanField",date:"sap/ui/integration/editor/fields/DateField",datetime:"sap/ui/integration/editor/fields/DateTimeField",object:"sap/ui/integration/editor/fields/ObjectField","object[]":"sap/ui/integration/editor/fields/ObjectListField",destination:"sap/ui/integration/editor/fields/DestinationField",group:"sap/ui/integration/editor/fields/GroupField"};J.Fields=null;J.prototype._requireFields=function(){if(J.Fields){return Promise.resolve()}return new Promise(function(e){sap.ui.require(Object.values(J.fieldMap),function(){J.Fields={};for(var t in J.fieldMap){J.Fields[t]=arguments[Object.keys(J.fieldMap).indexOf(t)]}e()})})};J.prototype._createDescription=function(e,t){var i=new v(this.getId()+"_"+t+"_description_icon",{src:"sap-icon://message-information",color:"Marker",size:"12px",useIconTooltip:false,visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});i.addStyleClass("sapUiIntegrationEditorDescriptionIcon");i.onmouseover=function(t){t.addDependent(this._getPopover());this._getPopover().getContent()[0].applySettings({text:e.description});this._getPopover().openBy(t)}.bind(this,i);i.onmouseout=function(e){this._getPopover().close();e.removeDependent(this._getPopover())}.bind(this,i);return i};J.prototype._createMessageIcon=function(e,t){var i=e.getConfiguration();var a=new v(this.getId()+"_"+t+"_message_icon",{src:"sap-icon://message-information",size:"12px",visible:typeof i.visible==="boolean"?"{currentSettings>visible}":i.visible,useIconTooltip:false,objectBindings:{currentSettings:{path:"currentSettings>"+i._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});a.onmouseover=function(e){e._showMessage()}.bind(this,e);a.onmouseout=function(e){e._hideMessage()}.bind(this,e);a.addStyleClass("sapUiIntegrationEditorMessageIcon");return a};J.prototype._createLabel=function(e,t){var i=new c(this.getId()+"_"+t+"_label",{text:e.label,tooltip:e.tooltip||e.label,required:e.required&&e.editable||false,visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});i._cols=e.cols||2;if(e.layout){i._layout=e.layout}i._sOriginalType=e.type;return i};J.prototype._createSettingsButton=function(e,t){var i=e.getConfiguration();var a=new j(this.getId()+"_"+t+"_settings_btn",{icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",type:"Transparent",tooltip:this._oResourceBundle.getText("EDITOR_FIELD_MORE_SETTINGS"),press:function(t){this._openSettingsDialog(200,t.oSource,e)}.bind(this),visible:typeof i.visible==="boolean"?"{currentSettings>visible}":i.visible,objectBindings:{currentSettings:{path:"currentSettings>"+i._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});return a};J.prototype._getSettingsPanel=function(e){if(!e._oSettingsPanel){e._oSettingsPanel=new O}return e._oSettingsPanel};J.prototype._openSettingsDialog=function(e,t,i){var a=this._getSettingsPanel(i);window.setTimeout(function(){a.setConfiguration(i.getConfiguration());a.open(t,t,this,i.getHost(),i,i._applySettings.bind(i),i._cancelSettings.bind(i))}.bind(this),e||600)};J.prototype._getPopover=function(){if(this._oPopover){return this._oPopover}var e=new I({text:""});e.addStyleClass("sapUiTinyMargin sapUiIntegrationEditorDescriptionText");this._oPopover=new y(this.getId()+"_popover",{showHeader:false,content:[e]});this._oPopover.addStyleClass("sapUiIntegrationEditorPopover");return this._oPopover};J.prototype._createField=function(e,t){var i=new J.Fields[e.type](this.getId()+"_"+t+"_field",{configuration:e,mode:this.getMode(),host:this.getHostInstance(),parameterKey:t,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"},destinations:{path:"destinations>/"}},visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible});i.setAssociation("_editor",this);this._aFieldReadyPromise.push(i._readyPromise.then(function(){if(e.type!=="group"){if(e.require||e.validation||e.validations&&e.validations.length>0||e.values&&e.values.data&&!e.values.data.json){var a=this._createMessageIcon(i,t);i.setAssociation("_messageIcon",a)}if(e.description&&this.getMode()!=="translation"){i._descriptionIcon=this._createDescription(e,t)}if(e._changeDynamicValues){i._settingsButton=this._createSettingsButton(i,t);i._applyButtonStyles()}}}.bind(this)));if(e.type!=="group"){i._oValueBinding=this._settingsModel.bindProperty(e._settingspath+"/value");i._oValueBinding.attachChange(function(){if(!this._bIgnoreUpdates){e._changed=true;if(e._dependentFields&&e._dependentFields.length>0){this._updateEditor(e._dependentFields)}this._updatePreview()}}.bind(this));if(i.isFilterBackend()){var a=this._settingsModel.bindProperty(e._settingspath+"/suggestValue");a.attachChange(function(){var t=s({},e);t._cancel=false;this._addValueListModel(t,i)}.bind(this))}if(e.values){if(e.values.metadata){this._addMetadataModel(e,i)}if(e.type==="string[]"&&i.isFilterBackend()&&e.visualization&&e.visualization.type==="MultiInput"){i.setModel(new f({}),undefined)}else{var n=g.timeoutPromise(this._addValueListModel(e,i));n=n.catch(function(e){M.error("sap.ui.integration.editor.Editor: get data of field "+t+" could not be resolved. Reason: "+e)});this._aFieldDataReadyPromise.push(n)}}this._createDependentFields(e,i);i._oDataProviderFactory=this._oDataProviderFactory}i._cols=e.cols||2;if(e.layout){i._layout=e.layout}i._oEditorResourceBundles=this._oEditorResourceBundles;i.setAssociation("_messageStrip",G);return i};J.prototype._updateEditor=function(e){if(this._fieldReady){if(e.length===0){return}for(var t=0;t<e.length;t++){var i=e[t];i.config._cancel=true}if(!this._oDataProviderFactory){return}this._bIgnoreUpdates=true;for(var t=0;t<e.length;t++){var i=e[t];i.config._cancel=false;this._addValueListModel(i.config,i.field,500*t)}this._bIgnoreUpdates=false}};J.prototype._updatePreview=function(){var e=this.getAggregation("_preview")||this._oPreview;if(e&&e.update){e.update()}};J.prototype._requestData=function(e,t){var i=this._oDataProviderFactory.create(e.values.data);i.bindObject({path:"items>/form/items"});i.bindObject({path:"currentSettings>"+e._settingspath});i.bindObject({path:"context>/"});return i._waitDependencies().then(function(){return i.getData()}).then(function(i){if(e._cancel){e._values=[];this._settingsModel.setProperty(e._settingspath+"/_loading",false);return}var a=e.values.data.path,n,s=[];if(a&&a!=="/"){if(a.startsWith("/")){a=a.substring(1)}if(a.endsWith("/")){a=a.substring(0,a.length-1)}n=a.split("/");s=S.get(n,i)}else{s=i}if(e.type==="object"||e.type==="object[]"){s.forEach(function(e){e._dt={_editable:false}})}if(this.getMode()==="content"&&e.pageAdminValues&&e.pageAdminValues.length>0){var r=e.pageAdminValues,o=e.value,l=e.valueItems||[],d=[],f=[],u=[];this.prepareFieldsInKey(e);if(r.length>0){for(var g=0;g<r.length;g++){for(var p=0;p<s.length;p++){var h=this.getKeyFromItem(s[p]);if(r[g]===h){d.push(s[p])}}if(Array.isArray(o)){for(var c=0;c<o.length;c++){if(r[g]===o[c]){f.push(o[c])}}for(var _=0;_<l.length;_++){var m=this.getKeyFromItem(l[_]);if(r[g]===m){u.push(l[_])}}}}if(f.length>0){e.value=[];e.value=f}if(u.length>0){e.valueItems=[];e.valueItems=u}}if(e.values.data.path&&e.values.data.path!=="/"){delete i[n];S.set(n,d,i)}else{i=[];i=d}}var v=t.getConfiguration();if(e.type==="string[]"){var y=e.values.data.path;if(y&&y!=="/"){if(y.startsWith("/")){y=y.substring(1)}if(y.endsWith("/")){y=y.substring(0,y.length-1)}var n=y.split("/");var b=S.get(n,i);if(Array.isArray(b)){for(var I in b){var M=t.getKeyFromItem(b[I]);if(Array.isArray(v.value)&&v.value.length>0&&v.value.includes(M)){b[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED")}else{b[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED")}}S.set(n,b,i)}}else if(Array.isArray(i)){for(var I in i){var M=t.getKeyFromItem(i[I]);if(Array.isArray(v.value)&&v.value.length>0&&v.value.includes(M)){i[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED")}else{i[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED")}}}}e._values=i;var C=t.getModel();C.setData(i);C.checkUpdate(true);C.firePropertyChange();if(e.type==="object"||e.type==="object[]"){t.mergeValueWithRequestResult(s)}this._settingsModel.setProperty(e._settingspath+"/_loading",false);t._hideValueState(true,true)}.bind(this)).catch(function(i){var a=new Promise(function(e){var t=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(i)&&i.length>0){t=i[0];var a=i[1];if(a){var n;a.text().then(function(i){if(g.isJson(i)){n=JSON.parse(i).error}else{t=i}if(n){t=(n.code||n.errorCode||a.status)+": "+n.message}e(t)});return}else{e(t);return}}else if(typeof i==="string"){t=i;e(t);return}else{e(t);return}}.bind(this));return a.then(function(i){var a=t.getModel();a.firePropertyChange();if(e.type==="object"||e.type==="object[]"){t.mergeValueWithRequestResult()}this._settingsModel.setProperty(e._settingspath+"/_loading",false);t._showValueState("error",i,true)}.bind(this))}.bind(this))};J.prototype._requestExtensionData=function(){var e=this.getAggregation("_extension");if(!e){M.info("sap.ui.integration.editor.Editor: extension is not defined or created, do not load data of it.");return new Promise(function(e,t){e()})}var t=false;var i={};var a=this._oEditorManifest.get(this.getConfigurationPath()+"/data/extension");var n;if(a){t=true;n=this._oEditorManifest.get(this.getConfigurationPath()+"/data/path");i={extension:a};if(n){i.path=n}}else{a=this._oEditorManifest.get("/"+this.getSection()+"/data/extension");if(a){t=true;n=this._oEditorManifest.get("/"+this.getSection()+"/data/path");i={extension:a};if(n){i.path=n}}}if(!t){M.info("sap.ui.integration.editor.Editor: extension data is not defined in manifest, do not load data of it.");return new Promise(function(e,t){e()})}var s=this._oDataProviderFactory.create(i);return s._waitDependencies().then(function(){return s.getData()}).then(function(t){var i=e.getModel();if(!i){i=new f(t||{});e.setModel(i,undefined)}else{i.setData(t)}i.checkUpdate(true)}).catch(function(e){var t=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(e)&&e.length>0){t=e[0];var i=e[1];if(i){var a;i.text().then(function(e){if(g.isJson(e)){a=JSON.parse(e).error}else{t=e}if(a){t=(a.code||a.errorCode||i.status)+": "+a.message}M.error("sap.ui.integration.editor.Editor: request extension data failed, "+t)})}}else if(typeof e==="string"){t=e;M.error("sap.ui.integration.editor.Editor: request extension data failed, "+t)}}.bind(this))};J.prototype._addValueListModel=function(e,t,i){if(e.values){var a;if(e.values.data){t.bindObject({path:e.values.data.path||"/"});if(this._oDataProviderFactory){a=t.getModel();if(!a){a=new f({});t.setModel(a,undefined)}this._settingsModel.setProperty(e._settingspath+"/_loading",true);if(!i){return this._requestData(e,t)}else{setTimeout(function(){return this._requestData(e,t)}.bind(this),i)}}}else if(this.getAggregation("_extension")){a=this.getAggregation("_extension").getModel();if(a&&this.getMode()==="content"&&e.pageAdminValues&&e.pageAdminValues.length>0){this.prepareFieldsInKey(e);var n=e.values.path;if(n.length>1){n=n.substring(1)}var s=S.get([n],a.getData()),r=e.pageAdminValues,o=[];for(var l=0;l<r.length;l++){for(var d=0;d<s.length;d++){var u=this.getKeyFromItem(s[d]);if(r[l]===u){o.push(s[d])}}}delete s[n];S.set(n,o,s);a.setData(s)}t.bindObject({path:e.values.path||"/"});t.setModel(a,undefined);return Promise.resolve(null)}}};J.prototype._addMetadataModel=function(e,t){if(e.values&&e.values.metadata){var i=s({},e.values.metadata.request);var a={url:i.serviceUrl};var n=Promise.resolve(a);if(this._oDestinations){n=this._oDestinations.process(a)}n.then(function(e){if(!e.url.endsWith("/")){e.url=e.url+"/"}i.serviceUrl=e.url;var a=new u(i);a.oMetaModel.fetchData().then(function(e){t.setModel(new f(e),"meta")})})}};J.prototype._createDependentFields=function(e,t){if(e.values){var i=JSON.stringify(e.values.data);if(i){var a=/parameters\.([^\}\}]+)|destinations\.([^\}\}]+)|\{items\>[\/?\w+]+\}/g,n=i.match(a);if(n){for(var r=0;r<n.length;r++){var o="/value";var l=this.getConfigurationPath();if(n[r].indexOf("destinations.")===0||n[r].indexOf("parameters.")===0){if(n[r].indexOf("destinations.")===0){o="/name"}l=l+"/"+n[r].replace(".","/")+o}else if(n[r].indexOf("{items>")===0){l=l+"/parameters/"+n[r].slice(7,-1)}var d=this._mItemsByPaths[l];if(d){if(d._settingspath===e._settingspath){e=s({},e)}d._dependentFields=d._dependentFields||[];d._dependentFields.push({field:t,config:e})}}}}}};J.prototype.getBeforeLayerChange=function(e){if(!this._beforeLayerManifestChanges){this._beforeLayerManifestChanges={}}return this._beforeLayerManifestChanges[e]};J.prototype.getTranslationValueInTexts=function(e,t){var i="/texts/"+e;var a=this._settingsModel.getProperty(i)||{};return a[t]};J.prototype.deleteAllTranslationValuesInTexts=function(e){var t=this;var i=t._settingsModel.getData();if(!i||!i.texts){return}var n="/texts";var s=a(i.texts,500);for(var r in s){if(s[r][e]){delete s[r][e]}}this._settingsModel.setProperty(n,s)};J.prototype._addItem=function(e,t){var i=this.getMode();if(this.getAllowDynamicValues()===false||!e.allowDynamicValues){e.allowDynamicValues=false}if(this.getAllowSettings()===false){e.allowSettings=false}e.__cols=e.cols||2;if(e.visible===false||!e.translatable&&i==="translation"&&e.type!=="group"){return}if(e.type==="group"){e.expanded=e.expanded!==false;var n=this._createField(e,t);this.addAggregation("_formContent",n);if(e.hint){this._addHint(e.hint,this.getId()+"_"+t)}return}if(e.type==="separator"){var s=new R;this.addAggregation("_formContent",s);return}var r=null;var o=g._language;if(i==="translation"){if(e.type!=="string"){return}if(typeof e.value==="string"&&e.value.indexOf("{")===0||typeof e.values!=="undefined"){return}e._language={value:e.value};e.cols=1;delete e.values;var l=a(e,500);l._settingspath+="/_language";l.editable=false;l.required=false;if(!J._oLanguages[o]&&o.indexOf("-")>-1){o=o.substring(0,o.indexOf("-"))}if(J._oLanguages[o]){var d=this.getTranslationValueInTexts(o,e.manifestpath);if(d){l.value=d}}if(!l.value){l.value="-"}var f=this._createLabel(l,t);this.addAggregation("_formContent",f);var u=this._createField(l,t+"_ori");u.isOrigLangField=true;this.addAggregation("_formContent",u);e.editable=e.visible=e.translatable;o=this._language;if(!this.getBeforeLayerChange(e.manifestpath)){e.value=e._translatedValue||""}var d=this.getTranslationValueInTexts(o,e.manifestpath);if(d){e.value=d}e.label=e._translatedLabel||"";e.required=false;var p=this._createField(e,t+"_trans");var h={onAfterRendering:function(e){var t=document.getElementById(p.getId());t.setAttribute("aria-label",f)}};p.addEventDelegate(h);this.addAggregation("_formContent",p)}else{r=this._createLabel(e,t);this.addAggregation("_formContent",r);var c=this.getBeforeLayerChange(e.manifestpath);if(c){e._beforeLayerChange=c}if(this._currentLayerManifestChanges&&this._currentLayerManifestChanges[e.manifestpath]){e.value=this._currentLayerManifestChanges[e.manifestpath];e._beforeLayerChange=e.value}if(e.type==="string"){o=this._language;var d=this.getTranslationValueInTexts(o,e.manifestpath);if(d){e.value=d}}var n=this._createField(e,t);var _={onAfterRendering:function(e){var t=document.getElementById(n.getId());t.setAttribute("aria-label",r)}};n.addEventDelegate(_);this.addAggregation("_formContent",n)}if(e.hint&&(!e.cols||e.cols===2)){this._addHint(e.hint,this.getId()+"_"+t)}e.cols=e.__cols;delete e.__cols};J.prototype._createHint=function(e,t){e=e.replace(/<a href/g,"<a target='blank' href");var i=new A(t+"_hint",{htmlText:e});return i};J.prototype._addHint=function(e,t){var i=this._createHint(e,t);this.addAggregation("_formContent",i)};J.prototype._getCurrentLanguageSpecificText=function(e){if(this._oTranslationBundle){var t=this._oTranslationBundle.getText(e,[],true);if(t===undefined){return""}return t}return""};J.prototype._loadSpecialTranslations=async function(){if(this._oTranslationBundle){return}var e=this._language;if(!e){return}var t=this._oEditorManifest.get("/sap.app/i18n"),i,a;if(!t){return}if(typeof t==="string"){i=this.getBaseUrl()+t}else if(typeof t==="object"){if(t.bundleUrl){i=this.getBaseUrl()+t.bundleUrl}if(t.supportedLocales&&Array.isArray(t.supportedLocales)){a=t.supportedLocales;for(var n=0;n<a.length;n++){a[n]=a[n].replaceAll("_","-")}}}if(i){var s=[e];if(e.indexOf("-")>-1){s.push(e.substring(0,e.indexOf("-")))}if(!s.includes("en")){s.push("en")}s=this._filterSupportedFallbackLanguages(s,a);var r=await P.create({url:i,async:true,locale:s[0],supportedLocales:s,fallbackLocale:"en"});var o=new L({bundle:r});this._oTranslationBundle=await o.getResourceBundle()}};J.prototype._filterSupportedFallbackLanguages=function(e,t){if(Array.isArray(t)){var i=[];for(var a=0;a<e.length;a++){if(t.includes(e[a])){i.push(e[a])}}e=i}return e};J.prototype._startEditor=function(){var e=this.getAggregation("_formContent");if(e&&e.length>0){this.destroyAggregation("_formContent")}var t=this._settingsModel.getData();var i;if(t.form&&t.form.items){i=t.form.items;var a=false,n=this._destinationGroupAtTop?1:0,r=Object.keys(i),o=r.length,l=0;for(var d=n;d<o;d++){var f=i[r[d]];if(f.type==="destination"){if(!this._destinationGroupAtTop){break}l=d;continue}else if(f.type==="group"&&f.level!=="1"){break}else if(f.visible){a=true;break}}if(a){var u={type:"group",translatable:true,expanded:true,label:this._oResourceBundle.getText("EDITOR_PARAMETERS_GENERALSETTINGS"),_settingspath:"/form/items/generalPanel"};if(this._destinationGroupAtTop){var p={};var h=0;r.forEach(function(e){p[e]=i[e];if(h===l){p["generalPanel"]=u}h++});i=p}else{i=s({generalPanel:u},i)}t.form.items=i;this._settingsModel.setData(t)}}var c=this._settingsModel.getProperty("/");this._mItemsByPaths={};if(c.form&&c.form.items){i=c.form.items;var _=this._language||this.getLanguage()||g._language;if(this.getMode()==="translation"){this._addItem({type:"group",translatable:true,expandable:false,expanded:true,label:this._oResourceBundle.getText("EDITOR_ORIGINALLANG")+": "+J._oLanguages[_]},"translationTopPanel")}for(var m in i){var f=i[m];if(f){f.label=f.label||m;var v;if(f.manifestpath){this._mItemsByPaths[f.manifestpath]=f;if(this.getMode()!=="translation"){v=this._currentLayerManifestChanges[f.manifestpath]}}f._changed=v!==undefined&&this.getMode()!=="translation";if(f.values){f.translatable=false}f._beforeValue=this._getManifestBeforelValue(f.manifestpath);if(f.type==="string"){f._translatedDefaultPlaceholder=this._getManifestDefaultValue(f.manifestpath);var y=null,b=f._translatedDefaultPlaceholder;if(b){if(this._isValueWithParameterSyntax(b)){f.translatable=false}if(this._isValueWithHandlebarsTranslation(b)){y=b.substring(2,b.length-2)}else if(b.startsWith("{i18n>")){y=b.substring(6,b.length-1)}if(y){f.translatable=true}else if(f.translatable&&this.getMode()==="translation"&&!this.getBeforeLayerChange(f.manifestpath)){f._translatedValue=f._translatedDefaultPlaceholder;f.value=f._translatedValue}}f._translatedPlaceholder=f._beforeValue;b=f._translatedPlaceholder;if(b){if(this._isValueWithParameterSyntax(b)){f.translatable=false}if(this._isValueWithHandlebarsTranslation(b)){y=b.substring(2,b.length-2)}else if(b.startsWith("{i18n>")){y=b.substring(6,b.length-1)}}if(f.value&&(f.value.indexOf("{context>")===0||f.value.indexOf("{{parameters")===0)){this.deleteAllTranslationValuesInTexts(f.manifestpath);y=null}var I=this.getTranslationValueInTexts(_,f.manifestpath);if(y){f._translatedValue=this.getModel("i18n").getResourceBundle().getText(y);if(f._changed){f.value=v}else if(f.value===f._translatedDefaultPlaceholder){f.value=f._translatedValue}if(this.getMode()==="translation"){var M=this._getCurrentLanguageSpecificText(y);if(M!==""){f._translatedValue=M}}else if(I){f.value=I}}else if(this.getMode()!=="translation"&&f.translatable&&I){f.value=I}if(this.getMode()==="translation"){if(this._isValueWithHandlebarsTranslation(f.label)){f._translatedLabel=this._getCurrentLanguageSpecificText(f.label.substring(2,f.label.length-2),true)}else if(f.label&&f.label.startsWith("{i18n>")){f._translatedLabel=this._getCurrentLanguageSpecificText(f.label.substring(6,f.label.length-1),true)}}}else if(f.type==="string[]"){var C=f.manifestpath.substring(0,f.manifestpath.lastIndexOf("/"))+"/valueItems";var P=this._manifestModel.getProperty(C);if(P){f.valueItems=P}var x=f.manifestpath.substring(0,f.manifestpath.lastIndexOf("/"))+"/valueTokens";var T=this._manifestModel.getProperty(x);if(T){f.valueTokens=T}}else if(typeof f.value==="object"&&f.type==="object"){if(typeof f.value._editable==="boolean"){f.value._dt={_editable:f.value._editable};delete f.value._editable}}else if(Array.isArray(f.value)&&f.value.length>0&&f.type==="object[]"){f.value.forEach(function(e){if(typeof e._editable==="boolean"){e._dt={_editable:e._editable};delete e._editable}})}if(f.label&&this._isValueWithHandlebarsTranslation(f.label)){var D=f.label.substring(2,f.label.length-2);if(D){f.label=this.getModel("i18n").getResourceBundle().getText(D)}}}}}for(var m in i){var f=i[m];this._addItem(f,m)}var E=this._settingsModel.getProperty("/form/height")!==undefined?this._settingsModel.getProperty("/form/height"):"350px",S=this._settingsModel.getProperty("/form/width")!==undefined?this._settingsModel.getProperty("/form/width"):"100%";if(this.getProperty("height")===""){this.setProperty("height",E);document.body.style.setProperty("--sapUiIntegrationEditorFormHeight",E);document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight",E)}if(this.getProperty("width")===""){this.setProperty("width",S);document.body.style.setProperty("--sapUiIntegrationEditorFormWidth",S)}if(this.getMode()!=="translation"&&this.getPreviewPosition()!=="separate"){this._initPreview()}Promise.all(this._aFieldReadyPromise).then(function(){this._fieldReady=true;this.fireFieldReady();if(this.getMode()!=="admin"&&this.getMode()!=="all"){setTimeout(function(){this.fireDestinationReady()}.bind(this),100)}}.bind(this))};J.prototype.setHeight=function(e){if(e){this.setProperty("height",e);document.body.style.setProperty("--sapUiIntegrationEditorFormHeight",e);document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight",e)}};J.prototype.setWidth=function(e){if(e){this.setProperty("width",e);document.body.style.setProperty("--sapUiIntegrationEditorFormWidth",e)}};J.prototype.destroy=function(){if(this._oPopover){this._oPopover.destroy()}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy()}var e=this.getAggregation("_preview");if(e&&e.destroy){e.destroy()}var i=o.getElementById(G);if(i){i.destroy()}this._manifestModel=null;this._beforeManifestModel=null;this._oInitialManifestModel=null;this._settingsModel=null;this._destinationsModel=null;this._oEditorResourceBundles=null;document.body.style.removeProperty("--sapUiIntegrationEditorFormWidth");document.body.style.removeProperty("--sapUiIntegrationEditorFormHeight");t.prototype.destroy.apply(this,arguments)};J.prototype._initPreview=function(){};J.prototype._applyDesigntimeDefaults=function(e){e=e||{};e.form=e.form||{};e.form.items=e.form.items||{};var t=e.form.items||e.form.items;for(var i in t){var a=t[i];if(a.type==="destination"){continue}if(a.manifestpath){a.value=this._manifestModel.getProperty(a.manifestpath)}if(a.visible===undefined||a.visible===null){a.visible=true}if(a.editable===undefined||a.editable===null){a.editable=true}if(this.getMode()!=="admin"){if(a.visibleToUser!==undefined){a.visible=a.visibleToUser}if(a.editableToUser!==undefined){a.editable=a.editableToUser}}if(typeof a.translatable!=="boolean"){a.translatable=false}if(!a.label){a.label=i}if(!a.type||a.type==="enum"){a.type="string"}if(a.value===undefined||a.value===null){switch(a.type){case"boolean":a.value=false;break;case"integer":case"number":a.value=0;break;case"string[]":a.value=[];break;case"object":a.value=undefined;break;case"object[]":a.value=undefined;break;default:a.value=""}}if(a.type==="group"){if(a.visible===undefined||a.value===null){a.visible=true}}a._settingspath="/form/items/"+i}};J.prototype._applyDesigntimeLayers=function(e){var t={};var i={};if(this._appliedLayerManifestChanges&&Array.isArray(this._appliedLayerManifestChanges)){for(var a=0;a<this._appliedLayerManifestChanges.length;a++){var r=this._appliedLayerManifestChanges[a][":designtime"];if(r){var o=Object.keys(r);for(var l=0;l<o.length;l++){var d=o[l],f=r[d];if(!d.endsWith("/pageAdminValues")&&typeof f==="object"){if(f.configuration&&f.configuration.parameterFromDestination){var u=f.configuration;delete u.parameterFromDestination;u.value=this._manifestModel.getProperty(u.manifestpath);u._settingspath="/form/items/"+f.parameter;this._settingsModel.setProperty(u._settingspath,u)}else{i[o[l]]=s(i[o[l]],f);continue}}else{this._settingsModel.setProperty(o[l],f)}}}var g=this._appliedLayerManifestChanges[a]["texts"];if(g){t=s(t,g)}}}if(this._currentLayerManifestChanges){var r=this._currentLayerManifestChanges[":designtime"];if(r){var o=Object.keys(r);for(var l=0;l<o.length;l++){var d=o[l],f=r[d];p=d.substring(0,d.lastIndexOf("/")+1)+"_next";if(!d.endsWith("/pageAdminValues")&&typeof f==="object"){if(!f.configuration||!f.configuration.parameterFromDestination){i[d]=s(i[d],f);continue}}if(!this._settingsModel.getProperty(p)){this._settingsModel.setProperty(p,{})}var p=d.substring(0,d.lastIndexOf("/")+1)+"_next",h=d.substring(d.lastIndexOf("/")+1);this._settingsModel.setProperty(p+"/"+h,f)}}var c=this._currentLayerManifestChanges["texts"];if(c){t=s(t,c)}}if(!n(t,{})){this._settingsModel.setProperty("/texts",t)}if(!n(i,{})){this._settingsModel.setProperty("/:designtime",i)}};J.prototype._createParameterDesigntime=function(e){var t={},i=this.getConfigurationPath()+"/parameters",a=this.getMode();if(e&&e.parameters){t.form=t.form||{};t.form.items=t.form.items||{};var n=t.form.items;Object.keys(e.parameters).forEach(function(t){n[t]=s({manifestpath:i+"/"+t+"/value",editable:a!=="translation",_settingspath:"/form/items/"+t},e.parameters[t]);var r=n[t];if(!r.type){r.type="string"}if(!r.hasOwnProperty("visible")){r.visible=true}})}return new d(t)};J.prototype._addDestinationSettings=function(e){var t=this._oDesigntimeInstance.getSettings(),i=this.getConfigurationPath()+"/destinations";t.form=t.form||{};t.form.items=t.form.items||{};if(t&&e&&e.destinations){this._destinationGroupAtTop=false;var a=t.form.items,n={},r=this.getHostInstance();var o={label:this._oResourceBundle.getText("EDITOR_DESTINATIONS")||"Destinations",type:"group",expanded:true,visible:true,_settingspath:"/form/items/destination.group"};if(a["destination.group"]){this._destinationGroupAtTop=Object.keys(a)[0]==="destination.group";o=s(o,a["destination.group"]);delete a["destination.group"]}n["destination.group"]=o;Object.keys(e.destinations).forEach(function(t){var r=s({manifestpath:i+"/"+t+"/name",visible:true,type:"destination",editable:true,allowDynamicValues:false,allowSettings:false,value:e.destinations[t].name,defaultValue:e.destinations[t].defaultUrl,_settingspath:"/form/items/"+[t+".destination"],_values:[],_destinationName:t},e.destinations[t]);if(typeof r.label==="undefined"){r.label=t}if(a[t+".destination"]){r=s(r,a[t+".destination"]);delete a[t+".destination"]}n[t+".destination"]=r});if(this._destinationGroupAtTop){t.form.items=s(n,a)}else{t.form.items=s(a,n)}var l=false;if(r){this._destinationsModel.setProperty("/_loading",true);this._destinationsModel.checkUpdate(true);this.getHostInstance().getDestinations().then(function(e){l=true;this._destinationsModel.setProperty("/_values",e);this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.setSizeLimit(e.length);this._destinationsModel.checkUpdate(true);setTimeout(function(){this.fireDestinationReady()}.bind(this),100)}.bind(this)).catch(function(){return this.getHostInstance().getDestinations()}.bind(this)).then(function(e){if(l){return}this._destinationsModel.setProperty("/_values",e);this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.setSizeLimit(e.length);this._destinationsModel.checkUpdate(true);setTimeout(function(){this.fireDestinationReady()}.bind(this),100)}.bind(this)).catch(function(e){this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.checkUpdate(true);setTimeout(function(){this.fireDestinationReady()}.bind(this),100);M.error("sap.ui.integration.editor.Editor: can not get destinations list from '"+r.getId()+"'.")}.bind(this))}}};J.prototype._deleleDestinationSettings=function(){var e=this._oDesigntimeInstance.getSettings();e.form=e.form||{};e.form.items=e.form.items||{};delete e.form.items["destination.group"];for(var t in e.form.items){var i=e.form.items[t];if(i.type==="destination"){delete e.form.items[t]}}};J.prototype._getManifestDefaultValue=function(e){return this._oInitialManifestModel.getProperty(e)};J.prototype._getManifestBeforelValue=function(e){return this._beforeManifestModel.getProperty(e)};J.prototype._isValueWithHandlebarsTranslation=function(e){if(typeof e==="string"){return!!e.match(W)}return false};J.prototype._isValueWithParameterSyntax=function(e){if(typeof e==="string"){return!!e.match(H)}return false};J.prototype.prepareFieldsInKey=function(e){this._sKeySeparator=e.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#"}var t=e.values.item.key;this._aFields=t.split(this._sKeySeparator);for(var i in this._aFields){if(this._aFields[i].startsWith("{")){this._aFields[i]=this._aFields[i].substring(1)}if(this._aFields[i].endsWith("}")){this._aFields[i]=this._aFields[i].substring(0,this._aFields[i].length-1)}}};J.prototype.getKeyFromItem=function(e){var t="";this._aFields.forEach(function(i){t+=e[i].toString()+this._sKeySeparator}.bind(this));if(t.endsWith(this._sKeySeparator)){t=t.substring(0,t.length-this._sKeySeparator.length)}return t};J.oResourceBundle=l.getResourceBundleFor("sap.ui.integration",g._language);J.initContextEntries=function(){return{empty:{label:J.oResourceBundle.getText("EDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:J.oResourceBundle.getText("EDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"editor.internal":{label:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_INTERNAL_VAL"),todayIso:{type:"string",label:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),description:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_TODAY_DESC"),tags:[],placeholder:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),description:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_NOW_DESC"),tags:[],placeholder:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),description:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),value:"{{parameters.LOCALE}}"}}}};z=J.initContextEntries();J.prototype._applyLanguageChange=function(){z=J.initContextEntries()};J._oLanguages={};J._appendThemeVars=function(){var e=["sapUiButtonHoverBackground","sapUiBaseBG","sapUiContentLabelColor","sapUiTileSeparatorColor","sapUiHighlight","sapUiListSelectionBackgroundColor","sapUiNegativeText","sapUiCriticalText","sapUiPositiveText","sapUiChartScrollbarBorderColor"];var t=E.get({name:e,callback:function(e){}});if(t){for(var i in t){document.body.style.setProperty("--"+i,t[i])}}};J.init=function(){this.init=function(){};J._appendThemeVars();var e=sap.ui.require.toUrl("sap.ui.integration.editor.css.Editor".replace(/\./g,"/")+".css");T(e);J._oLanguages=D.loadResource("sap/ui/integration/editor/languages.json",{dataType:"json",failOnError:false,async:false})};J.prototype.onThemeChanged=function(){J._appendThemeVars()};J.init();return J});
//# sourceMappingURL=Editor.js.map