/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/m/Popover","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/model/json/JSONModel","sap/m/Button","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/VBox","sap/m/HBox","sap/m/Select","sap/ui/core/ListItem","sap/m/Label","sap/m/Text","sap/m/Title","sap/m/CheckBox","sap/m/Menu","sap/m/MenuItem","sap/m/Input","sap/ui/integration/util/ParameterMap","sap/base/util/merge","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/ScrollContainer","sap/base/util/ObjectPath","sap/ui/integration/util/BindingHelper","sap/ui/integration/editor/fields/ObjectListField","sap/ui/layout/form/SimpleForm","sap/ui/integration/util/Utils","sap/base/util/deepClone","sap/base/util/deepEqual"],function(e,t,a,n,s,i,l,r,o,d,u,p,_,g,c,m,f,v,y,b,S,h,T,w,I,x,P,E,D,V,M,C,O,A){"use strict";var R=e.extend("sap.ui.integration.editor.Settings",{metadata:{library:"sap.ui.integration"},renderer:null});var N=n.getResourceBundleFor("sap.ui.integration",C._language),L,B,j=null,U,F,$,K,k,H,G,W,Y,z,Z,q,X,J=450,Q=360;R.prototype.setConfiguration=function(e){this._originalConfig=e;e=T({},e);var t=new s(e);this.setModel(t,"currentSettings");this.bindElement({path:"currentSettings>/"})};R.prototype.open=function(e,t,s,i,l,r,o){if(N&&N.sLocale!==C._language){N=n.getResourceBundleFor("sap.ui.integration",C._language)}var d=this.getModel("currentSettings").getData(),u=l.getParameterId();if(d.values&&d.values.item){this.prepareFieldsInKey(d)}j=this;X=ee(d,l);this.addDependent(X);this.oHost=i;this.fnApply=r;this.fnCancel=o;this._oOpener=l;B=true;e.addDependent(this);if(!d.allowDynamicValues&&d.values&&d.values.item){a.getElementById(u+"_settings_popover_scroll_container").setHeight("155px")}this.getModel("currentSettings").checkUpdate(true,true);ye(N.getText("EDITOR_SELECT_FROM_LIST"),[]);if(t){var p=s.getDomRef().offsetHeight;p=p>J?J:p;X.setContentHeight(p-50+"px");var _;var g="Right";var c=s.getDomRef().getBoundingClientRect();var m=e.getDomRef().getBoundingClientRect();var f=m.x+m.width/2-c.x;var v=c.width;if(2*f>v){g="Left";_=f-m.width*1.5}else{_=v-f-m.width}_=_>Q?Q:_;X.setContentWidth(_+"px");X.setPlacement(g);k.setValue(e._label);X.openBy(e)}else{X.open()}L=this.getModel("currentSettings");if(L.getProperty("/type")==="destination"){le(u)}else if(L.getProperty("/_hasDynamicValue")){re(u)}else if(L.getProperty("/_hasSettings")){ie(u)}else if(L.getProperty("/allowDynamicValues")){re(u)}else if(L.getProperty("/allowSettings")){ie(u)}};R.prototype._applyCurrentSettings=function(){this.fnApply(L.getData())};R.prototype._cancelCurrentSettings=function(){this.fnCancel(this._originalConfig)};R.prototype.destroy=function(){this.removeDependent(X);return e.prototype.destroy.apply(this,arguments)};function ee(e,n){var s=n.getParameterId(),l=ne(e,s),r=se(e,s,n),u=pe(s),p=_e(s),_=ge(e,n),g=ce(e,n),c=new t({id:s+"_settings_popover",showArrow:true,contentWidth:"400px",showHeader:false,horizontalScrolling:false,verticalScrolling:false,modal:false,footer:new o({content:[r,new d,new i(s+"_settings_popover_ok_btn",{text:N.getText("EDITOR_MORE_OK"),type:"Emphasized",press:function(){if(e.type==="destination"){if(n._oNewParameter){var t=Object.assign({},n._oNewParameter);var i=O(Object.assign([],n._oValue.value));i=i.sort(function(e,t){if(!e._dt||!e._dt._position||!t._dt||!t._dt._position){return 0}return e._dt._position-t._dt._position});i.forEach(function(e){delete e._dt});t.configuration.values.data.json={values:i};oe("pageAdminNewDestinationParameter",t)}}else{if(e.values&&e.values.item){var l=a.getElementById(s+"_settings_popover_pav_table"),r=l.getSelectedContexts(),o=[];if(L.getProperty("/selectedValues")==="Partion"){for(var d=0;d<r.length;d++){var u=j.getKeyFromItem(r[d].getObject());o.push(u)}oe("pageAdminValues",o)}else{oe("pageAdminValues",[])}}}j._applyCurrentSettings();B=false;c.close()}}),new i(s+"_settings_popover_cancel_btn",{text:N.getText("EDITOR_MORE_CANCEL"),press:function(){c.close()}})]}),afterClose:function(){if(B){j._cancelCurrentSettings()}B=true;c.destroy()},afterOpen:function(){window.requestAnimationFrame(function(){c.getDomRef()&&(c.getDomRef().style.opacity="1")});if(e.values&&e.values.item){var t=a.getElementById(s+"_settings_popover_pav_table"),i=L.getProperty("/_next/pageAdminValues");if(i!==undefined&&i.length>0){t.removeSelections();L.setProperty("/selectedValues","None");var l=L.getProperty("/_next/pageAdminValues"),r=t.getItems();for(var o=0;o<l.length;o++){for(var d=0;d<r.length;d++){var u=j.getKeyFromItem(r[d].getBindingContext().getObject());if(l[o]===u){t.setSelectedItem(r[d])}}}L.setProperty("/selectedValues","Partion")}else{t.selectAll();L.setProperty("/selectedValues","All")}}n.fireSettingsPanelOpened()}});c.setCustomHeader(l);c.addContent(u);c.addContent(p);c.addContent(_);c.addContent(g);c.addStyleClass("sapUiIntegrationFieldSettings");return c}function te(e){z=new r({text:N.getText("EDITOR_MORE_SETTINGS"),tooltip:N.getText("EDITOR_MORE_SETTINGS"),key:"settings",icon:"sap-icon://action-settings",width:"50%",press:function(t){ie(e)}}).addStyleClass("setbtn");return z}function ae(e){z=te(e);Z=new l(e+"_settings_popover_segmented_btn",{width:"100%",visible:"{= ${currentSettings>allowDynamicValues} && ${currentSettings>allowSettings}}",items:[new r({text:N.getText("EDITOR_MORE_DYNAMICVALUES"),tooltip:N.getText("EDITOR_MORE_DYNAMICVALUES"),key:"dynamic",icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",width:"50%",press:function(t){re(e)}}).addStyleClass("dynbtn sel"),z]});return Z}function ne(e,t){Z=ae(t);var a=new m(t+"_settings_popover_dynamicvalue_txt",{text:N.getText("EDITOR_MORE_DYNAMICVALUES"),tooltip:N.getText("EDITOR_MORE_DYNAMICVALUES"),visible:e.type!=="destination"&&e.allowDynamicValues&&!e.allowSettings}).addStyleClass("sapUiTinyMagin");var n=new m(t+"_settings_popover_settings_txt",{text:N.getText("EDITOR_MORE_SETTINGS"),visible:e.type!=="destination"&&!e.allowDynamicValues&&e.allowSettings}).addStyleClass("sapUiTinyMagin");var s=new m(t+"_settings_popover_transform_txt",{text:N.getText("EDITOR_MORE_TRANSFORM"),visible:e.type==="destination"}).addStyleClass("sapUiTinyMagin");var i=new o({content:[Z,a,n,s]}).addStyleClass("headertitle");return i}function se(e,t,n){q=new i(t+"_settings_popover_reset_btn",{type:"Transparent",text:N.getText("EDITOR_MORE_RESET"),enabled:"{= ${currentSettings>_next/visible} === (typeof(${currentSettings>visibleToUser}) === 'undefined' ? false : !${currentSettings>visibleToUser}) || ${currentSettings>_next/editable} === (typeof(${currentSettings>editableToUser}) === 'undefined' ? false : !${currentSettings>editableToUser}) || ${currentSettings>_next/allowDynamicValues} === (typeof(${currentSettings>allowDynamicValues}) === 'undefined' ? false : !${currentSettings>allowDynamicValues}) || ${currentSettings>_beforeValue} !== ${currentSettings>value} || ${currentSettings>type} === 'destination'}",tooltip:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_RESET"),press:function(){if(e.type==="destination"){oe("pageAdminNewDestinationParameter",undefined);n._oValue=undefined;n._oNewParameter=undefined}else{var s=typeof L.getProperty("/visibleToUser")==="undefined"?true:L.getProperty("/visibleToUser");var i=typeof L.getProperty("/editableToUser")==="undefined"?true:L.getProperty("/editableToUser");var l=typeof L.getProperty("/allowDynamicValues")==="undefined"?true:L.getProperty("/allowDynamicValues");oe("visible",s);oe("editable",i);oe("allowDynamicValues",l);if(L.getProperty("/translatable")){if(L.getProperty("/_translatedDefaultValue")&&L.getProperty("/_translatedDefaultValue")!==""){L.setProperty("/value",L.getProperty("/_translatedDefaultValue"))}else if(L.getProperty("/_translatedDefaultPlaceholder")&&L.getProperty("/_translatedDefaultPlaceholder")!==""){L.setProperty("/value",L.getProperty("/_translatedDefaultPlaceholder"))}L.setProperty("/_changed",false)}else{L.setProperty("/value",L.getProperty("/_beforeValue"));if(e.type.indexOf("object")>-1){n.setValue(L.getProperty("/_beforeValue"));n.resetControl()}}if(e.values&&e.values.item){var r=a.getElementById(t+"_settings_popover_pav_table"),o=L.getProperty("/_next/pageAdminValues"),d=r.getItems();if(o!==undefined&&o.length>0&&o.length<d.length){r.removeSelections();for(var u=0;u<o.length;u++){for(var p=0;p<d.length;p++){var _=j.getKeyFromItem(d[p].getBindingContext().getObject());if(o[u]===_){r.setSelectedItem(d[p])}}}L.setProperty("/selectedValues","Partion")}else{r.selectAll();L.setProperty("/selectedValues","All")}}}var g=a.getElementById(t+"_settings_popover");g.getFooter().getContent()[2].firePress()}}).addStyleClass("resetbutton");return q}function ie(e){F.setVisible(true);U.setVisible(false);$.setVisible(false);a.getElementById(e+"_settings_popover_segmented_btn").setSelectedKey("settings");var t=a.getElementById(e+"_settings_popover_currentvalue");t.setVisible(false)}function le(e){$.setVisible(true);F.setVisible(false);U.setVisible(false);var t=a.getElementById(e+"_settings_popover_currentvalue");t.setVisible(false)}function re(e){F.setVisible(false);$.setVisible(false);U.setVisible(true);a.getElementById(e+"_settings_popover_segmented_btn").setSelectedKey("dynamic");var t=j.getModel("contextflat"),n=t._getValueObject(L.getProperty("/value"));if(n&&n.object.label){k.setValue(n.object.label);ye(n.object.description,n.object.tags);if(n.path==="empty"){k.setValue(n.object.label)}Se(n)}var s=a.getElementById(e+"_settings_popover_currentvalue");s.setVisible(true)}function oe(e,t){if(!L.getProperty("/_next")){L.setProperty("/_next",{})}L.setProperty("/_next/"+e,t)}function de(e,t){var a=[];for(var n in e){if(e[n]&&e[n].label){var s=new b({text:e[n].label});s.__data=e[n];e[n].pathvalue=(t+"/"+n).substring(1);a.push(s);var i=de(e[n],t+"/"+n);for(var l=0;l<i.length;l++){s.addItem(i[l])}}}return a}var ue=[{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Relative date/datetime text of the value",description:"Should be applied to dynamic values of type date or datetime or string values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss'",example:"4 weeks ago",syntax:"handlebars",binding:"{= format.dateTime('__|VALUE|__',{relative:true})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Short date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss.sss'",example:"9/18/20, 2:09 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'short'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Medium date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'medium'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Long date, date-time text of the value",description:"Should be applied to dynamic values of type date or date-time or string values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'long'})}"}];function pe(e){U=new u({visible:true});U.addStyleClass("sapUiSmallMargin");k=new S(e+"_settings_popover_dynamicvalue_input",{width:"100%",showValueHelp:true,valueHelpOnly:true,valueHelpRequest:function(){if(H){H.destroy()}H=new y({});G=de(U.getModel("context").getData(),"");for(var e=0;e<G.length;e++){H.addItem(G[e])}H.attachItemSelected(function(e){var t=e.getParameter("item").__data;ye(t.description||"",t.tags||[]);k.setValue(t.placeholder||t.label);var a=j.getModel("contextflat");Se(a._getPathObject(t.pathvalue))});k.addDependent(H);H.addStyleClass("sapUiIntegrationFieldSettingsMenu");H.openBy(k,false,null,null,"1 0")}});k.addStyleClass("selectvariable");var t=new c(e+"_settings_popover_dynamicvalue_label",{text:N.getText("EDITOR_MORE_DYNAMICVALUES_SELECT_DYNAMIC_VALUE")});k.addAriaLabelledBy(t);var a=new u({items:[t,k]});U.addItem(a);K=new m(e+"_settings_popover_dynamicvalue_desc_txt",{text:"",maxLines:6,renderWhitespace:true});a=new u({width:"100%",items:[K]});K.addStyleClass("description");U.addItem(a);if(ue.length===-1){W=new _(e+"_settings_popover_dynamicvalue_format_select",{width:"100%",enabled:true,change:function(){Y.setText(W.getSelectedItem()._data.description)}});a=new u({visible:false,items:[new c({text:"Customize the value..."}),W]});U.addItem(a);Y=new m(e+"_settings_popover_dynamicvalue_format_label",{text:"",maxLines:4,renderWhitespace:true});Y.addStyleClass("description");a=new u({width:"100%",items:[Y]});U.addItem(a);U.getItems()[2].getItems()[0].addStyleClass("sapUiTinyMarginTop")}U.getItems()[0].getItems()[0].addStyleClass("sapUiTinyMarginTop");return U}function _e(e){var t=new m(e+"_settings_popover_actualvalue_label",{text:N.getText("EDITOR_ACTUAL_VALUE")});var a=new S(e+"_settings_popover_actualvalue_input",{value:{path:"currentSettings>_currentContextValue"},editable:false});a.addAriaLabelledBy(t);var n=new u(e+"_settings_popover_currentvalue",{width:"100%",items:[t,a]});n.addStyleClass("currentval");return n}function ge(e,t){var a=t.getParameterId();F=new u({visible:false});if(e.type==="destination"){return F}var n=(new u).addStyleClass("commonSettings");F.addItem(n);n.addItem(new m({text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN"),wrapping:true}).addStyleClass("stitle"));var l=new c(a+"_settings_popover_adminvisible_label",{text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VISIBLE"),wrapping:true});var r=new v(a+"_settings_popover_adminvisible_checkbox",{selected:"{= ${currentSettings>_next/visible} !== false}",select:function(e){oe("visible",e.getParameter("selected"))}});r.addAriaLabelledBy(l);n.addItem(new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[l,r]}).addStyleClass("cbrow"));var o=new c(a+"_settings_popover_admineditable_label",{text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_EDIT"),wrapping:true});var d=new v(a+"_settings_popover_admineditable_checkbox",{selected:"{= ${currentSettings>_next/editable} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false}",select:function(e){oe("editable",e.getParameter("selected"))}});d.addAriaLabelledBy(o);n.addItem(new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[o,d]}).addStyleClass("cbrow"));var _=new c(a+"_settings_popover_allowdynamicvalues_label",{text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_DYN"),wrapping:true});var g=new v(a+"_settings_popover_allowdynamicvalues_checkbox",{selected:"{= ${currentSettings>_next/allowDynamicValues} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",select:function(e){oe("allowDynamicValues",e.getParameter("selected"))}});g.addAriaLabelledBy(_);n.addItem(new p({alignItems:"Start",justifyContent:"SpaceBetween",visible:"{= ${currentSettings>allowDynamicValues}!== false}",items:[_,g]}).addStyleClass("cbrow"));if(e.values&&e.values.item){var f;if(e.values.data){var y=e.values.data.path,b;if(y&&y!=="/"){if(y.startsWith("/")){y=y.substring(1)}if(y.endsWith("/")){y=y.substring(0,y.length-1)}b=y.split("/");f=E.get(["_values",b],e)}else{f=E.get(["_values"],e)}}else if(t.getParent().getParent().getAggregation("_extension")){var S=e.values.path;if(S.length>1){S=S.substring(1)}f=E.get([S],t.getModel().getData())}n.addItem(new p({alignItems:"Start",justifyContent:"SpaceBetween",visible:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",items:[new c(a+"_settings_popover_allowselectedvalues_label",{text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VALUES_LIST"),tooltip:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VALUES_LIST_TOOLTIPS"),wrapping:false}),new i(a+"_settings_popover_allowselectedvalues_all_btn",{type:"Transparent",enabled:f!==undefined,icon:{path:"currentSettings>selectedValues",formatter:function(e){if(e==="All"){return"sap-icon://multiselect-all"}else if(e==="Partion"){return"sap-icon://multi-select"}else if(e==="None"){return"sap-icon://multiselect-none"}}},tooltip:{path:"currentSettings>selectedValues",formatter:function(e){if(e==="All"){return N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_DESELECT_ALL")}else{return N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_SELECT_ALL")}}},press:function(){me(a)}})]}).addStyleClass("cbrow"));var h=new w({id:a+"_settings_popover_pav_table",mode:"MultiSelect",select:function(e){fe(e,a)},columns:[new I]}).addStyleClass("tableHdr");var T=e.values.item.text,V=new s(f);h.setModel(V);var M=(new x).addStyleClass("pavlistItem");if(f){for(var C=0;C<f.length;C++){M.addCell(new p({items:[new m({text:D.createBindingInfos(T)}).addStyleClass("pavTblCellText")]})).addStyleClass("pavlistItem")}}h.bindItems("/",M);var O=new P({id:a+"_settings_popover_scroll_container",height:"125px",vertical:true,horizontal:false,visible:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",content:[h]}).addStyleClass("SettingsPAVTable");F.addItem(O)}return F}function ce(e,t){$=new u({visible:false});if(e.type!=="destination"){return $}var a=new c({text:N.getText("EDITOR_MORE_TRANSFORM_P_ADMIN_LABEL"),wrapping:true});var n=new S({id:t.getAssociation("_editor")+"_"+t.getParameterKey()+".toParameter_label",value:"{/configuration/label}"});n.addAriaLabelledBy(a);var i=new c({text:N.getText("EDITOR_MORE_TRANSFORM_P_ADMIN_MAPPINGS"),wrapping:true});var l=1,r=O(t.getModel("destinations").getData()._values),o=e._next?e._next.pageAdminNewDestinationParameter:undefined;if(!t._oValue){var d=o?o.configuration.values.data.json.values:[];if(Array.isArray(d)&&d.length>0){d.forEach(function(e){e.label=e.label||e.name;e._dt={_uuid:C.generateUuidV4(),_position:l};l++})}else{var p=t.getAggregation("_field").getSelectedItem();var _=p?p.getBindingContext("destinations").getPath():undefined;if(_){var g=O(p.getModel("destinations").getProperty(_));g.label=g.label||g.name;g._dt={_uuid:C.generateUuidV4(),_position:l};d=[g]}}t._oValue={value:d}}else{t._oValue.value.forEach(function(e){e._dt=e._dt||{};var t=O(e);delete t._dt;if(typeof t==="object"&&!A(t,{})){e.label=t.label||t.name}})}var m=new s(t._oValue);t._oDestinationValueObjectConfig={label:"Destination Mappings",type:"object[]",values:{data:{path:"/value"},allowAdd:true},showSelectionColumn:false,properties:{label:{label:"Label",column:{width:"50%"},cell:{text:"{label}",editable:true}},name:{label:"Name",column:{width:"50%"},cell:{type:"string",editable:true,values:{data:{json:r,path:"/"},item:{text:"{settings>name}",key:"{settings>name}"},sorter:"name"},change:function(e){var t=e.getSource();var a=t.getBindingContext().getObject();if(a&&!a.label&&a.name){a.label=a.name}}}}},value:t._oValue.value};var f=new V(t.getAssociation("_editor")+"_"+t.getParameterKey()+".toParameter_field",{configuration:t._oDestinationValueObjectConfig,allowPopover:false,parameterKey:t.getParameterKey()+".toParameter",objectBindings:{currentSettings:{path:"currentSettings>/"}}});f.setAssociation("_editor",t.getAssociation("_editor"));f.setModel(m);f.setModel(new s(t._oDestinationValueObjectConfig),"currentSettings");var v=new M({layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,content:[a,n,i,f]});if(!t._oNewParameter){t._oNewParameter={parameter:t.getParameterKey()+".toParameter",configuration:{label:e.label,manifestpath:e.manifestpath,type:"string",visible:true,editable:true,values:{data:{path:"/values"},item:{text:"{label}",key:"{name}"}},parameterFromDestination:true}};if(o){delete o.configuration.values.data.json;t._oNewParameter=Object.assign(t._oNewParameter,o)}}var y=new s(t._oNewParameter);v.setModel(y);$.addItem(v);return $}function me(e){var t=a.getElementById(e+"_settings_popover_pav_table"),n=a.getElementById(e+"_settings_popover_reset_btn"),s=L.getProperty("/selectedValues");if(s==="All"){t.removeSelections();L.setProperty("/selectedValues","None")}else{t.selectAll();L.setProperty("/selectedValues","All")}if(!n.getEnabled()){n.setEnabled(true)}}function fe(e,t){var n=e.getSource(),s=n.getSelectedItems(),i=n.getItems(),l=a.getElementById(t+"_settings_popover_reset_btn");if(s.length===i.length){L.setProperty("/selectedValues","All")}else if(s.length<i.length&&s.length>0){L.setProperty("/selectedValues","Partion")}else{L.setProperty("/selectedValues","None")}if(!l.getEnabled()){l.setEnabled(true)}}function ve(e,t){e=e||[];W.removeAllItems();var a=[];W.addItem(new g({text:"No customizing needed",key:""}));for(var n=0;n<ue.length;n++){var s=ue[n],i=new g({text:s.label,key:"key"+n});i._data=s;if(s.sourceTypes.indexOf(t)>-1||e.indexOf(s.formatMethod)>-1){W.addItem(i)}else{a.push(i)}}for(var n=0;n<a.length;n++){W.addItem(a[n])}}function ye(e,t){t=t||[];if(t.indexOf("technical")>-1){e=e+"\n"+N.getText("EDITOR_MORE_DYNAMICVALUES_TECHHINT")}K.setText(e)}function be(e){if(ue.length===-1){if(!e){W.removeAllItems();W.addItem(new g({text:"No customizing available for this value"}));Y.setText("");W.setEnabled(false)}else{ve(e.customize,e.type);W.setEnabled(true)}}}function Se(e){if(e){L.setProperty("/_hasDynamicValue",true);var t=e.value;L.setProperty("/value",t);L.setProperty("/_contextpath",e.path);if(e.object&&e.object.value&&e.object.value.indexOf("{{")===0){L.setProperty("/_currentContextValue",h.processPredefinedParameter(e.object.value));be(e.object)}else{if(e.path==="empty"){L.setProperty("/value","");L.setProperty("/_currentContextValue","");L.setProperty("/_hasDynamicValue",false);be()}else{be(e.object);if(e.object&&e.object.hasOwnProperty("value")){L.setProperty("/_currentContextValue",e.object.value)}else{j.oHost.getContextValue(e.path+"/value").then(function(t){if(t===null){L.setProperty("/_currentContextValue","(not available)")}else{L.setProperty("/_currentContextValue",t)}e.object&&(e.object.value=t)})}}}}}R._private=function(){return{oPopover:X,oSegmentedButton:Z,oSettingsButton:z,oDynamicPanel:U,oSettingsPanel:F,oTransformPanel:$,oCurrentModel:L,updateCurrentValue:Se,oCurrentInstance:j,oDynamicValueField:k,oResetToDefaultButton:q,getMenuItems:function(){return G},getMenu:function(){return H}}};R.prototype.prepareFieldsInKey=function(e){this._sKeySeparator=e.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#"}var t=e.values.item.key;this._aFields=t.split(this._sKeySeparator);for(var a in this._aFields){if(this._aFields[a].startsWith("{")){this._aFields[a]=this._aFields[a].substring(1)}if(this._aFields[a].endsWith("}")){this._aFields[a]=this._aFields[a].substring(0,this._aFields[a].length-1)}}};R.prototype.getKeyFromItem=function(e){var t="";this._aFields.forEach(function(a){t+=e[a].toString()+this._sKeySeparator}.bind(this));if(t.endsWith(this._sKeySeparator)){t=t.substring(0,t.length-this._sKeySeparator.length)}return t};return R});
//# sourceMappingURL=Settings.js.map