/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/integration/editor/fields/BaseField","sap/m/Panel","sap/m/IconTabBar","sap/m/IconTabFilter","sap/m/MessageStrip"],function(e,t,r,i,n,a){"use strict";var s=t.extend("sap.ui.integration.editor.fields.GroupField",{metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer()});s.prototype.initVisualization=function(t){var n=t.visualization;if(!n||n.type==="Panel"){n={type:r,settings:{headerText:t.label,visible:t.visible,expandable:t.expandable!==false,expanded:"{currentSettings>expanded}",width:"auto",backgroundDesign:"Transparent",objectBindings:{currentSettings:{path:"currentSettings>"+(t._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}},expand:function(t){var r=t.getParameter("expand");if(r){var i=t.getSource();var n=this.getConfiguration();if(!i._level){i._level=n.level||0}var a=i._level==="1"&&this.getParent().getParent()?this.getParent().getParent().getAggregation("_messageStrip"):this.getParent().getAggregation("_messageStrip");if(a===null){a=e.getElementById(this.getAssociation("_messageStrip"))}i.addContent(a);i.focus()}}.bind(this)}}}else if(n.type==="Tab"){n={type:i,settings:{expandable:t.expandable!==false,visible:t.visible,expanded:"{currentSettings>expanded}",objectBindings:{currentSettings:{path:"currentSettings>"+(t._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}},select:this.checkErrorsInIconTabBar.bind(this)}}}this._visualization=n;this.attachAfterInit(this._afterInit)};s.prototype._afterInit=function(){var e=this.getConfiguration();var t=this.getAggregation("_field");if(t instanceof r){if(this.getMode()!=="translation"){var s=this.getResourceBundle();var o=new a({id:this.getParameterId()+"_strip",showIcon:false,visible:"{= !${currentSettings>expanded} && ${currentSettings>hasError} === true}",text:{path:"currentSettings>errorType",formatter:function(e){var t="";switch(e){case"Error":t=s.getText("EDITOR_GROUP_ERRORS");break;case"Warning":t=s.getText("EDITOR_GROUP_WARNINGS");break;default:}return t}},type:"{currentSettings>errorType}",objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")}}});if(e.level!=="1"){o.setModel(this._settingsModel,"currentSettings")}o.addStyleClass("sapUiIntegrationEditorPanelMessageStrip");t._messageStrip=o}t._cols=e.cols||2;t._level=e.level||0;var l={onAfterRendering:function(t){var n=t.srcControl;var a=document.getElementById(n.getId());a.setAttribute("aria-label",e.label);if(n._subItems&&n._subItems.length>0){this.checkErrorsInSubItems(this._settingsModel,n)}var s=n._messageStrip;if(n._level!=="1"&&s){s.invalidate()}if(n.getExpanded()){var o=n.getContent();o.forEach(function(e){if(e.isA("sap.ui.integration.editor.fields.GroupField")){var t=e.getAggregation("_field");if(t instanceof r&&t._subItems&&t._subItems.length>0){e.checkErrorsInSubItems(e._settingsModel,t)}else if(t instanceof i&&t.getItems().length>0){e.checkErrorsInIconTabBar()}}})}}.bind(this)};t.addEventDelegate(l)}else if(t instanceof i){var g=new n(this.getParameterId()+"_control_icontabfilter",{text:e.label,visible:e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}}});t.addItem(g);t.setBackgroundDesign("Transparent");t.setHeaderBackgroundDesign("Transparent");if(this.getMode()!=="translation"){var d=new a({id:this.getParameterId()+"_strip",showIcon:false,visible:false,objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")}}});d.addStyleClass("sapUiIntegrationEditorTabMessageStrip");t._messageStrip=d}g._level=e.level||0}};s.prototype.checkErrorsInIconTabBar=function(t){var r=this.getAggregation("_field"),i=r.getSelectedKey(),a=r.getItems(),s=r.getExpanded(),o=false;for(var l=0;l<a.length;l++){if(!s){o=true}else if(a[l].getId()!==i){o=true}else if(a[l].getId()===i){o=false}if(o){var g=false,d="None";if(a[l]._subItems&&a[l]._subItems.length>0){var c=a[l].getModel("currentSettings");var u=this.checkErrorsInSubItems(c,a[l]);g=u.hasError;d=u.errorType}if(g){var p=new n,f=a[l];if(f.getItems().length>0){f.removeAllItems()}f.addItem(p);this._handleITBValidation(f,d);if(f._oExpandButton===undefined){this._delayHandleITBValidation(f,d)}else{this._handleITBValidation(f,d)}}}else if(a[l].getItems().length>0){a[l].removeItem(a[l].getItems()[0]);if(a[l]._oExpandButton){a[l]._oExpandButton.visible=false}var h=this.getParent().getParent().getAggregation("_messageStrip");if(h===null){h=e.getElementById(this.getAssociation("_messageStrip"))}a[l].addContent(h)}}};s.prototype.checkErrorsInSubItems=function(t,r){var i=false;var n="None";for(var a=0;a<r._subItems.length;a++){var s=r._subItems[a].settingspath;var o=e.getElementById(r._subItems[a].itemId);if(t.getProperty(s+"/hasError")===true&&o.getVisible()){i=true;var l=t.getProperty(s+"/errorType");if(l==="Error"){n="Error";break}else if(l==="Warning"&&n!=="Error"){n="Warning"}}}t.setProperty("hasError",i,this.getBindingContext("currentSettings"));t.setProperty("errorType",n,this.getBindingContext("currentSettings"));return{hasError:i,errorType:n}};s.prototype._handleITBValidation=function(t,r){var i=this.getResourceBundle();if(t.getItems().length>0&&t._oExpandButton){var n=t._oExpandButton;var a=null;if(r==="Error"){a=i.getText("EDITOR_GROUP_ERRORS");n.setIcon("sap-icon://message-error");n.addStyleClass("errorBTNImage")}else if(r==="Warning"){a=i.getText("EDITOR_GROUP_WARNINGS");n.setIcon("sap-icon://message-warning");n.addStyleClass("warningBTNImage")}n.setTooltip(null);n.addEventDelegate({onAfterRendering:function(e){var t=document.getElementById(n.getId());t.setAttribute("aria-label","With validation errors");t.setAttribute("title","")}});n.setEnabled(false);n.addStyleClass("errorBTN").addStyleClass("errorBTNDisabled");var s=e.getElementById(this.getParameterId()+"_strip");n.addEventDelegate({onmouseover:function(){s.setVisible(true);s.setType(r);s.setText(a)},onmouseout:function(){s.setVisible(false)}},this)}};s.prototype._delayHandleITBValidation=function(e,t){var r=this;var i=setInterval(function(){if(e._oExpandButton){r._handleITBValidation(e,t);clearInterval(i)}},50)};return s});
//# sourceMappingURL=GroupField.js.map