/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/editor/fields/BaseField","sap/m/Text","sap/m/TextArea","sap/m/Input","sap/m/NavContainer","sap/m/Page","sap/m/Popover","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/ui/model/json/JSONModel","sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/rowmodes/Fixed","sap/m/Label","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/util/deepEqual","sap/ui/core/Icon","sap/m/Switch","sap/m/CheckBox","sap/m/MessageBox","sap/m/MessageToast","sap/base/util/deepClone","sap/m/Link","sap/ui/layout/form/SimpleForm","sap/base/util/merge","sap/ui/model/Sorter","sap/ui/integration/util/Utils","sap/m/table/columnmenu/Menu","sap/m/ComboBox","sap/ui/core/ListItem","sap/ui/model/type/Integer","sap/ui/model/type/Float","sap/m/HBox","sap/ui/core/CustomData","sap/ui/integration/editor/fields/viz/IconSelect","sap/m/Image"],function(e,t,a,r,o,n,l,i,s,d,u,p,_,c,g,v,f,T,b,h,y,O,P,m,E,I,S,D,w,C,L,x,V,B,A,M,R,j){"use strict";var U=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g;var N=e.extend("sap.ui.integration.editor.fields.ObjectField",{metadata:{library:"sap.ui.integration",events:{tableUpdated:{},translationPopoverOpened:{}}},renderer:e.getMetadata().getRenderer()});N.prototype.initVisualization=function(e){var t=this;t._newObjectTemplate={_dt:{_selected:true,_uuid:""}};var a=e.visualization;if(!a){if(e.value&&!e.properties&&(!e.values||e.values&&!e.values.metadata)){t.parseValueProperties()}if(e.values){a=t.createTableVisualization(e)}else if(e.properties){a=t.createSimpleFormVisualization(e)}else{a=t.createTextAreaVisualization(e)}e.withLabel=true}this._visualization=a;this.attachAfterInit(this._afterInit)};N.prototype._afterInit=function(){var e=this;var t=this.getAggregation("_field");if(t instanceof I){t.addStyleClass("sapUiIntegrationEditorItemObjectFieldForm");var a=m(e.getConfiguration().value,500)||{};t.setModel(new u({value:a,editMode:"Properties"}))}else if(t instanceof p){t.addStyleClass("sapUiIntegrationEditorItemObjectFieldTable");e._oMenu=new C;var r=t.getColumns();for(var o=0;o<r.length;o++){if(r[o].getFilterProperty()||r[o].getSortProperty()){r[o].setHeaderMenu(e._oMenu.getId())}}}};N.prototype.parseValueProperties=function(){var e=this;var t=e.getConfiguration();if(typeof t.value==="object"&&!T(t.value,{})&&!Array.isArray(t.value)&&!t.properties){var a={};for(var r in t.value){if(r!=="_dt"){var o=typeof t.value[r];var n=o==="string"?{}:{type:o};a[r]=n}}if(!T(a,{})){t.properties=a;t._propertiesParsedFromValue=true}}};N.prototype.createTableVisualization=function(e){var t=this;var a=t.createTableToolbar(e);var r=[];var o=e.values?e.values.data.path||"/":"/value";if(e.values&&e.values.metadata){r={path:"meta>/"+e.values.metadata.namespace+"."+e.values.metadata.entityTypeName,filters:new v({path:"$kind",operator:f.EQ,value1:"Property"}),factory:t.columnFactory.bind(t)}}else{r=t.buildTableColumns()}var n={type:p,settings:{rowMode:new c({rowCount:5}),busy:"{currentSettings>_loading}",busyIndicatorDelay:200,columns:r,selectionBehavior:"RowOnly",rowSelectionChange:t.onTableSelectionChange.bind(t),extension:a,filter:t.onFilter.bind(t)}};if(e.type==="object"){n.settings.rows="{"+o+"}"}else{n.settings.rows="{path: '"+o+"', sorter: {path: '_dt/_position', descending: false}}"}return n};N.prototype.createSimpleFormVisualization=function(e){var t=this;var a=t.getParameterId();var r=t.getResourceBundle();var o=function(){var e=this.getAggregation("_field").getModel();e.checkUpdate(true);var t=e.getProperty("/value")||{};if(!t._dt){t._dt={_uuid:w.generateUuidV4()}}else if(!t._dt._uuid){t._dt._uuid=w.generateUuidV4()}t=m(t,500);this.setValue(t)}.bind(t);var n=t.createFormContents(o,"/value/",false,t.openTranslationPopup);var l=new d(a+"_control_form_editmode_btn",{icon:{path:"/editMode",formatter:function(e){if(e==="Properties"){return"sap-icon://syntax"}else{return"sap-icon://form"}}},tooltip:{path:"/editMode",formatter:function(e){if(e==="Properties"){return r.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_JSON")}else{return r.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_PROPERTIES")}}},press:function(){var e=t.getAggregation("_field").getModel();var a=e.getProperty("/editMode");if(a==="Properties"){e.setProperty("/editMode","Json")}else{e.setProperty("/editMode","Properties")}}});var u=new d(a+"_control_form_delete_btn",{icon:"sap-icon://delete",tooltip:r.getText("EDITOR_FIELD_OBJECT_DELETE"),visible:e.enabled,enabled:{path:"currentSettings>value",formatter:function(e){if(!e||e===""){return false}return true}},press:function(e){t.setValue(undefined);var a=t.getAggregation("_field").getModel();var r=a.getProperty("/value");if(r&&r._dt&&r._dt._uuid){t.deleteTranslationValueInTexts(undefined,r._dt._uuid)}a.setProperty("/value",{});a.checkUpdate(true)}});var p={type:I,settings:{layout:"ResponsiveGridLayout",visible:e.visible,labelSpanXL:2,labelSpanL:2,labelSpanM:2,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,toolbar:new i({content:[new s,l,u]}).addStyleClass("sapMTB"),content:n}};return p};N.prototype.createTextAreaVisualization=function(e){var t=this;var r={type:a,settings:{value:{path:"currentSettings>value",formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:"{config/editable}",width:"100%",enabled:"{config/enabled}",placeholder:"{config/placeholder}",visible:e.visible,change:this.onChangeOfTextArea.bind(t),rows:7}};return r};N.prototype.buildSelectionColumnLabels=function(){var e=this;var t=e.getConfiguration();var a=e.getResourceBundle();return new d(e.getParameterId()+"_control_table_column_selection_label_clearall_btn",{icon:"sap-icon://clear-all",type:"Transparent",enabled:typeof t.values==="undefined"?false:"{/_hasSelected}",tooltip:a.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_TOOLTIP_REMOVE"),press:e.onUnSelectAll.bind(e)})};N.prototype.buildTableColumns=function(){var e=this;var o=e.getParameterId();var n=e.getConfiguration();var p=[];var c=Object.keys(n.properties);if(c.length>0){var v=e.getResourceBundle();var f=typeof n.values==="undefined"?false:true;if(f){f=typeof n.showSelectionColumn==="undefined"?true:n.showSelectionColumn}var T=e.buildSelectionColumnLabels();var O=new _(o+"_control_table_column_selection",{width:"3.2rem",hAlign:"Center",visible:f,multiLabels:[T],template:new y({selected:"{_dt/_selected}",enabled:typeof n.values==="undefined"?false:true,tooltip:{path:"_dt/_selected",formatter:function(e){if(e){if(n.type==="object"){return v.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_UNSELECT")}else{return v.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_REMOVE")}}else if(n.type==="object"){return v.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_SELECT")}else{return v.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_ADD")}}},select:e.onSelectionChange.bind(e)})});p.push(O);for(var P in n.properties){var C=o+"_control_table_column_property_"+P;var V=n.properties[P];var B=V.label||P;var R="{"+P+"}";if(V.defaultValue){e._newObjectTemplate[P]=V.defaultValue}var N={width:"7rem",label:B};if(V.column){N=S(N,V.column)}if(N.label.match(U)){N.label="{i18n>"+N.label.substring(2,N.label.length-1)}N.tooltip=N.label;N.label=new g({text:N.label});var F=V.cell&&V.cell.type?V.cell.type:V.type||"Text";var k;var J;var $=m(V.cell)||{};if(!$.values&&V.values){$.values=V.values}delete $.type;if(F==="string"&&$.values){F="ComboBox"}if(F==="Text"&&$.editable){F="Input"}F=F.toLowerCase();switch(F){case"int":case"number":J={text:R,wrapping:false};J=S(J,$);k=new t(J);break;case"string":case"text":J={text:R,wrapping:false};J=S(J,$);var H=J.text;var z=new u({translatable:V.translatable||false,property:P});if(typeof H==="string"){var K=e.getTranslationKey(H);if(K){J.text=v.getText(K)}else if(H.startsWith("{")&&H.endsWith("}")){J.text={path:H.substring(1,H.length-1),formatter:function(t){var a=this.getBindingContext(),r,o=this.getModel("settings").getData(),n=e.getTranslationKey(t);if(o.translatable||n){if(a&&a.getObject()&&a.getObject()._dt){r=e.getTranslationValueInTexts(w._language,a.getObject()._dt._uuid,o.property);if(r){return r}}if(n){t=v.getText(n);return t}}return t}}}}J.tooltip=$.tooltip||J.text;k=new t(J);k.setModel(z,"settings");break;case"icon":var W={src:R,visible:"{= $"+R+".indexOf('data:image/') === 0}",press:function(e){var t=e.getSource();if(!t._oImagePopover){t._oImagePopover=new l(t.getId()+"-imagePopover",{placement:"Right",showHeader:false}).addStyleClass("sapUiIntegrationImageSelect")}t._oImagePopover.destroyContent();t._oImagePopover.addContent(new j(t.getId()+"-imagePopover-image",{src:t.getSrc()}).addStyleClass("image"));t._oImagePopover.openBy(t)}};var G={src:R,visible:"{= $"+R+".indexOf('data:image/') === -1}"};W=S(W,j.getMetadata().removeUnknownSettings($));G=S(G,b.getMetadata().removeUnknownSettings($));k=new A({alignItems:"Center",justifyContent:"Center",items:[new j(W).addStyleClass("imageCell"),new b(G)]});break;case"boolean":J={selected:R,enabled:false};J=S(J,$);k=new y(J);break;case"switch":J={state:R,enabled:false};J=S(J,$);k=new h(J);break;case"link":J={text:R,target:"_blank",href:R};J=S(J,$);k=new E(J);break;case"combobox":var X=this.addModelPrefix($.values.item,"settings");J={width:"100%",selectedKey:R,editable:false,items:{path:"settings>"+$.values.data.path,template:new x(X),templateShareable:false}};if($.values.sorter){J.items.sorter=[new D({path:$.values.sorter})];delete $.values.sorter}J=S(J,$);var q=new u($.values.data.json);delete J.values;k=new L(J);k.setModel(q,"settings");break;case"input":J={value:R};if($.text){J.value=$.text}J.tooltip=$.tooltip||J.text;k=new r(J);break;case"object":J={value:{path:P,formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:false};J=S(J,$);k=new A({items:[new r(J),new d({icon:"sap-icon://display",customData:[new M({key:"value",value:R})],press:function(t){var r=t.getSource();if(!e._oObjectPropertyDetailsPopover){var n=new a(o+"_control_objectproperty_details_popover_textarea",{editable:false,rows:9});var u=new d(o+"_control_objectproperty_details_popover_close_btn",{text:v.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CLOSE"),press:function(){e._oObjectPropertyDetailsPopover.close()}});e._oObjectPropertyDetailsPopover=new l(o+"_control_objectproperty_details_popover",{placement:"Right",contentWidth:"200px",contentHeight:"240px",modal:true,title:v.getText("EDITOR_FIELD_OBJECT_PROPERTY_POPOVER_TITLE"),content:[new I({layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,content:[n]})],footer:new i({content:[new s,u]})}).addStyleClass("sapUiIntegrationEditorItemObjectFieldDetailsPopover");e._oObjectPropertyDetailsPopover._oTextArea=n;e._oObjectPropertyDetailsPopover._oCloseButton=u}var p=r.getCustomData()[0];var _=p.getValue();if(_){_=JSON.stringify(_,null,"\t");if(typeof _==="object"&&!_.length){_=_.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}}e._oObjectPropertyDetailsPopover._oTextArea.setValue(_);e._oObjectPropertyDetailsPopover.openBy(r)}})]});break;default:k=new t({text:R,wrapping:false});break}N.template=k;var Z=new _(C,N);p.push(Z)}}return p};N.prototype.checkHasFilterDefined=function(e){var t=true;if(e._propertiesParsedFromValue===true){t=false}else{var a=JSON.stringify(e.properties,null,"\t");t=a.indexOf("filterProperty")>-1?true:false}return t};N.prototype.createTableToolbar=function(e){var t=this;var a=t.getParameterId();var r=t.getResourceBundle();var o=t.checkHasFilterDefined(e);var n=e.enabled!==false;var l=e.addButtonText||r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_ADD_TOOLTIP");if(n&&e.values){n=e.values.allowAdd===true}var u=[new s,new d(a+"_control_table_add_btn",{icon:"sap-icon://add",visible:n,tooltip:l,press:t.addNewObject.bind(t)}),new d(a+"_control_table_edit_btn",{icon:"sap-icon://edit",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_EDIT_TOOLTIP"),enabled:"{= !!${/_hasTableSelected}}",visible:t.getAllowPopover(),press:t.onEditOrViewDetail.bind(t)}),new d(a+"_control_table_delete_btn",{icon:"sap-icon://delete",tooltip:r.getText("EDITOR_FIELD_OBJECT_DELETE"),enabled:"{= !!${/_canDelete}}",press:t.onDelete.bind(t)}),new d(a+"_control_table_filter_btn",{icon:"sap-icon://clear-filter",visible:o,enabled:"{= !!${/_hasFilter}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_CLEAR_ALL_FILTERS_TOOLTIP"),press:t.clearAllFilters.bind(t)}),new d(a+"_control_table_multiselect_all_btn",{icon:"sap-icon://multiselect-all",visible:false,enabled:"{= !${/_hasTableAllSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_SELECT_ALL_SELETIONS_TOOLTIP"),press:t.selectAllTableSelections.bind(t)}),new d(a+"_control_table_multiselect_none_btn",{icon:"sap-icon://multiselect-none",visible:false,enabled:"{= !!${/_hasTableSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_CLEAR_ALL_SELETIONS_TOOLTIP"),press:t.clearAllTableSelections.bind(t)})];if(e.type==="object[]"){u=u.concat([new d(a+"_control_table_navigationup_btn",{icon:"sap-icon://navigation-up-arrow",enabled:"{= !!${/_hasOnlyOneRowSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_MOVE_UP_TOOLTIP"),press:t.moveRowUp.bind(t)}),new d(a+"_control_table_navigationdown_btn",{icon:"sap-icon://navigation-down-arrow",enabled:"{= !!${/_hasOnlyOneRowSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_MOVE_DOWN_TOOLTIP"),press:t.moveRowDown.bind(t)})])}return new i({content:u})};N.prototype.onUnSelectAll=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getBindingContext().getPath();var o=a.getModel();var n=o.getProperty(r);n.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false});o.setProperty("/_hasSelected",false);o.checkUpdate(true);t.setValue(undefined)};N.prototype.onEditOrViewDetail=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getSelectedIndices()[0];var o=a.getBinding("rows").getContexts();var n=o[r].getObject();var l=a.getFirstVisibleRow();var i=a.getRows()[r-l];var s=i.getCells()[0];t.openObjectDetailsPopover(n,s,!n._dt||n._dt._editable!==false?"update":"view")};N.prototype.onFilter=function(e){var t=this;var a=t.getAggregation("_field");a.detachEvent("rowsUpdated",t.updateTable,t);a.attachEventOnce("rowsUpdated",t.updateTable,t)};N.prototype.updateTable=function(e){var t=this;t.updateSelectionColumn();t.updateToolbar();t.fireTableUpdated()};N.prototype.updateSelectionColumn=function(){var e=this;var t=e.getAggregation("_field");var a=t.getBinding("rows").getContexts();var r=false;for(var o=0;o<a.length;o++){var n=a[o].getObject();if(n._dt&&n._dt._selected){r=true;break}}t.getModel().setProperty("/_hasSelected",r)};N.prototype.updateToolbar=function(){var e=this;var t=e.getAggregation("_field");var a=t.getColumns();var r=false;for(var o=0;o<a.length;o++){if(a[o].getFiltered()){r=true;break}}t.getModel().setProperty("/_hasFilter",r)};N.prototype.columnFactory=function(e,a){var r=a.getPath();var o=r.substring(a.getPath().lastIndexOf("/")+1);var n=a.getProperty("$Type");var l=a.getProperty("$MaxLength");var i="7rem";l=l?parseInt(l):10;l=l<7?7:l;if(l>50){i="15rem"}else if(l>9){i="10rem"}return new _(e,{visible:true,filterProperty:n&&n.indexOf("String")>=0?o:null,width:i,label:new g({text:o}),hAlign:n&&n.indexOf("Decimal")>=0?"End":"Begin",template:new t({text:{path:o},wrapping:false})})};N.prototype.onTableSelectionChange=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=a.getSelectedIndices();if(o.length>0){r.setProperty("/_hasTableSelected",true);if(o.length===1){r.setProperty("/_hasOnlyOneRowSelected",true)}else{r.setProperty("/_hasOnlyOneRowSelected",false)}}else{r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.setProperty("/_canDelete",false);return}if(o.length===a.getBinding("rows").getContexts().length){r.setProperty("/_hasTableAllSelected",true)}else{r.setProperty("/_hasTableAllSelected",false)}var n=[];var l=a.getBinding("rows").getContexts();o.forEach(function(e){var t=l[e].getObject();if(t._dt&&t._dt._editable!==false){var a=l[e].getPath();n.push(a)}});if(n.length===0){r.setProperty("/_canDelete",false)}else{r.setProperty("/_canDelete",true)}};N.prototype.selectAllTableSelections=function(e){var t=this;var a=t.getAggregation("_field");a.selectAll();a.getModel().setProperty("/_hasTableAllSelected",true)};N.prototype.clearAllTableSelections=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();a.clearSelection();r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.setProperty("/_canDelete",false);r.setProperty("/_hasTableAllSelected",false)};N.prototype.moveRowUp=function(e){this.moveSelectedRow("Up")};N.prototype.moveRowDown=function(e){this.moveSelectedRow("Down")};N.prototype.moveSelectedRow=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=a.getSelectedIndices()[0];var n=a.getContextByIndex(o);var l=o+(e==="Up"?-1:1);var i=a.getContextByIndex(l);if(!i){return}var s=i.getProperty("_dt/_position");var d=n.getProperty("_dt/_position");r.setProperty("_dt/_position",s,n);r.setProperty("_dt/_position",d,i);r.refresh(true);a.setSelectedIndex(l);t.refreshValue();t.updateTable()};N.prototype.onSelectionChange=function(e){var t=this;var a=e.getSource();var r=e.getParameter("selected");var o=t.getAggregation("_field");var n=o.getBindingContext().getPath();var l=o.getModel();if(r){var i=l.getProperty(n);i.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false});var s=a.getBindingContext().getObject();s._dt._selected=true;var d=m(s);l.setProperty("/_hasSelected",true);t.setValue(d)}else{l.setProperty("/_hasSelected",false);t.setValue(undefined)}};N.prototype.addNewObject=function(e){var t=this;var a=e.getSource();t._newObjectTemplate._dt._uuid=w.generateUuidV4();if(t.getAllowPopover()){t.openObjectDetailsPopover(t._newObjectTemplate,a,"add")}else{t.onAddDirectly(t._newObjectTemplate)}};N.prototype.mergeValueWithRequestResult=function(e){var t=this;var a=t.getConfiguration();var r=t.getAggregation("_field");var o=r.getModel();var n=r.getBinding("rows").getPath();if(a.value&&typeof a.value==="object"&&!T(a.value,{})){var l=m(a.value,500);if(Array.isArray(e)&&e.length>0){if(l._dt&&l._dt._editable===false){var i=l._dt._uuid||w.generateUuidV4();delete l._dt._uuid;e.forEach(function(e){if(T(e,l)){e._dt._selected=true;e._dt._uuid=i}else{e._dt._uuid=w.generateUuidV4()}})}else{e.forEach(function(e){e._dt._uuid=w.generateUuidV4()});l._dt=l._dt||{};l._dt._selected=true;l._dt._uuid=l._dt._uuid||w.generateUuidV4();e.unshift(l)}}else{l._dt=l._dt||{};l._dt._selected=true;l._dt._uuid=l._dt._uuid||w.generateUuidV4();e=[l]}o.setProperty("/_hasSelected",true);o.setProperty(n,e)}else{if(Array.isArray(e)&&e.length>0){e.forEach(function(e){e._dt._uuid=w.generateUuidV4()})}else{o.setProperty(n,{})}o.setProperty("/_hasSelected",false)}o.checkUpdate();t.updateTable()};N.prototype.onChangeOfTextArea=function(e){var t=this;var a=t.getResourceBundle();var r=e.getSource();var o=r.getValue();if(!o||o===""){t.saveValue(undefined,r)}else{try{var n=JSON.parse(o);if(n instanceof Array){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_SINGLE_JSONOBJECT"));return}t.saveValue(n,r)}catch(e){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};N.prototype.onChangeOfTextAreaInPopover=function(e){var t=this;var a=t.getResourceBundle();var r=e.getSource();var o=r.getValue();if(!o||o===""){t.saveValue(undefined,r,true)}else{try{var n=JSON.parse(o);if(n instanceof Array){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_SINGLE_JSONOBJECT"));return}t.saveValue(n,r,true)}catch(e){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};N.prototype.createFormContents=function(e,t,r,o){var n=this;var l=n.getConfiguration();var i=n.createPropertyContents(e,t,r,o);i.push(new g({visible:false}).addStyleClass("sapFormLabel"));var s=r?n.getParameterId()+"_control_objectdetails_popover_form_textarea":n.getParameterId()+"_control_form_textarea";i.push(new a(s,{value:{path:t,formatter:function(e){if(!e||e===""){return undefined}if(T(e,{})&&!r&&!n._getCurrentProperty("value")){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:l.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",width:"100%",placeholder:"{config/placeholder}",visible:"{= ${/editMode} === 'Json'}",change:r===true?this.onChangeOfTextAreaInPopover.bind(n):this.onChangeOfTextArea.bind(n),rows:r===true?11:7}));return i};N.prototype.createPropertyContents=function(e,t,o,n){var l=this;var i=l.getParameterId();var s=o?i+"_control_objectdetails_popover_form_property_":i+"_control_form_property_";var d=l.getConfiguration();var p=[];if(!t){t="currentSettings>value/"}var _={};if(d.values&&d.values.metadata){var c=l.getModel("meta");var v="/"+d.values.metadata.namespace+"."+d.values.metadata.entityTypeName;var f=c.getProperty(v);for(var b in f){var O=f[b];var P=O["$Type"];if(O["$kind"]==="Property"&&P){if(P.indexOf("Int")>=0){_[b]={type:"int"}}else if(P.indexOf("Boolean")>=0){_[b]={type:"boolean"}}else if(P.indexOf("Decimal")>=0){_[b]={type:"number"}}else{_[b]={type:"string"}}}}}if(T(_,{})){_=d.properties}for(var E in _){var I=_[E];var D=I.label||E;if(D.match(U)){var w=D.substring(2,D.length-2);D="{i18n>"+w+"}"}var C=s+E+"_label";var A=s+E+"_control";var M=new g(C,{text:D,visible:"{= ${/editMode} === 'Properties'}",required:I.required||false}).addStyleClass("propertyLabel");p.push(M);var j;I.values=I.values||I.cell&&I.cell.values;if(I.type==="string"&&I.values){I.type="ComboBox"}var N=m(I,500);delete N.type;delete N.label;delete N.translatable;delete N.defaultValue;delete N.formatter;delete N.column;delete N.cell;delete N.values;var F;if(I.type){I.type=I.type.toLowerCase()}switch(I.type){case"boolean":if(I.cell&&I.cell.type==="Switch"){F={state:"{"+t+E+"}",visible:"{= ${/editMode} === 'Properties'}",enabled:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:e};if(I.cell.customTextOn){F.customTextOn=I.cell.customTextOn}if(I.cell.customTextOff){F.customTextOff=I.cell.customTextOff}F=S(F,N);j=new h(A,F)}else{F={selected:"{"+t+E+"}",visible:"{= ${/editMode} === 'Properties'}",enabled:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",select:e};F=S(F,N);j=new y(A,F)}break;case"int":case"integer":F={value:{path:t+E,type:new V(I.formatter)},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",type:"Number",change:e};F=S(F,N);j=new r(A,F);break;case"number":F={value:{path:t+E,type:new B(I.formatter)},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",type:"Number",change:e};F=S(F,N);j=new r(A,F);break;case"combobox":var k=this.addModelPrefix(I.values.item,"settings");F={width:"100%",selectedKey:"{"+t+E+"}",visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",items:{path:"settings>"+I.values.data.path,template:new x(k),templateShareable:false},change:e};F=S(F,N);j=new L(A,F);var J=new u(I.values.data.json);j.setModel(J,"settings");break;case"object":F={value:{path:t+E,formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:function(t){var a=t.getSource();var r=t.getParameter("value");var o=a.getModel();if(!r||r===""){o.setProperty(a.getBindingPath("value"),undefined);o.checkUpdate(true);a.setValueState("None");a.setValueStateText("");e(t)}else{try{var n=JSON.parse(r);o.setProperty(a.getBindingPath("value"),n);o.checkUpdate(true);a.setValueState("None");a.setValueStateText("");e(t)}catch(e){var i=l.getResourceBundle();a.setValueState("Error");a.setValueStateText(i.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}},rows:3};F=S(F,N);j=new a(A,F);break;case"icon":var $=new u({uuidPath:t+"_dt/_uuid",property:E});F={value:"{"+t+E+"}",allowNone:!I.required&&I.allowNone!==false,allowFile:I.allowFile!==false,visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:e};j=new R(A,F);j.setModel($,"settings");break;default:var H=new u({translatable:I.translatable||false,uuidPath:t+"_dt/_uuid",property:E});F={value:"{"+t+E+"}",visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:function(t){var a=t.getSource();var r=t.getParameter("value");if(r&&r.match(U)){var o=r.substring(2,r.length-2);r="{i18n>"+o+"}";a.setValue(r);a.fireChange()}else if(e){e(t)}}};F=S(F,N);if(n){F.valueHelpIconSrc="sap-icon://translate";F.valueHelpRequest=n.bind(l,E);if(I.translatable){F.showValueHelp=true}else{F.showValueHelp={path:t+E,formatter:function(e){var t=this.getModel("settings").getData();var a=this.getModel().getProperty(t.uuidPath);var r="translatable";if(l.getTranslationKey(e)){if(!this.getShowValueHelp()&&l.getObjectPropertyConfigValueInDesigntime(a,t.property,r)===false){l.setObjectPropertyConfigValueInDesigntime(a,t.property,r,true)}return true}if(this.getShowValueHelp()){l.deleteTranslationValueInTexts(undefined,a,t.property);l.setObjectPropertyConfigValueInDesigntime(a,t.property,r,false);l._oUpdatedTranslations={}}return false}}}}j=new r(A,F);j.setModel(H,"settings")}p.push(j)}return p};N.prototype.saveValue=function(e,t,a){var r=this;var o;if(!a){r.setValue(e);o=r.getAggregation("_field").getModel();if(o){e=m(e,500);o.setProperty("/value",e||{})}t.setValueState("None");t.setValueStateText("");if(r.getConfiguration()._propertiesParsedFromValue){r.refreshSimpleForm()}}else{o=t.getModel();o.setProperty("/value",e);t.setValueState("None");t.setValueStateText("")}};N.prototype.refreshSimpleForm=function(){var e=this;var t=e.getConfiguration();var a=e.getAggregation("_field");var r=a.removeAllContent();for(var o=0;o<r.length-2;o++){r[o].destroy()}r=r.slice(-2);delete t.properties;e.parseValueProperties();var n=function(){var t=a.getModel();t.checkUpdate(true);var r=t.getProperty("/value");r=m(r,500);e.setValue(r)};var l=e.createPropertyContents(n,"/value/");l=l.concat(r);l.forEach(function(e){a.addContent(e)})};N.prototype.getOriginTranslatedValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();for(var r in a){var o=a[r];var n="";var l="";if(e&&o){var i=o.resourceBundle&&o.resourceBundle.getText(e);n=i;l=i}else{n="";l=""}var s={key:r,description:o.language,value:n,originValue:l,editable:true};t.push(s)}return t};N.prototype.buildPropertyTranslationValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();for(var r in a){t.push({key:r,description:a[r].language,value:e,originValue:e,editable:true})}return t};N.prototype.openObjectDetailsPopover=function(e,t,a){var r=this;var p=r.getParameterId();var _=r.getResourceBundle();var c=m(e,500);var g;var v="Right";if(a==="add"){v=this.getPopoverPlacement(t)}if(!r._oObjectDetailsPopover){var f=new d(p+"_control_objectdetails_popover_add_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_ADD"),visible:a==="add",enabled:{path:"/value",formatter:function(e){if(typeof e!=="object"||T(e,{})){return false}else{var t=m(e);delete t._dt;if(T(t,{})){return false}}return true}},press:r.onAdd.bind(r)});var b=new d(p+"_control_objectdetails_popover_update_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_UPDATE"),visible:a==="update",enabled:{path:"/value",formatter:function(e){if(!e||e===""||T(e,{})){return false}return true}},press:r.onUpdate.bind(r)});var h=new d(p+"_control_objectdetails_popover_cancel_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CANCEL"),visible:a!=="view",press:function(){if(a==="add"){var e=r._oObjectDetailsPopover.getModel().getProperty("/value");r.deleteTranslationValueInTexts(undefined,e._dt._uuid)}r._oObjectDetailsPopover.close()}});var y=new d(p+"_control_objectdetails_popover_close_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CLOSE"),visible:a==="view",press:function(){r._oObjectDetailsPopover.close()}});var O=new d(p+"_control_objectdetails_popover_editmode_btn",{icon:{path:"/editMode",formatter:function(e){if(e==="Properties"){return"sap-icon://syntax"}else{return"sap-icon://form"}}},tooltip:{path:"/editMode",formatter:function(e){if(e==="Properties"){return _.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_JSON")}else{return _.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_PROPERTIES")}}},press:function(e){var t=e.getSource();var a=t.getModel();var r=a.getProperty("/editMode");if(r==="Properties"){a.setProperty("/editMode","Json")}else{a.setProperty("/editMode","Properties")}}});var P;r._oNavContainer=new o;r._oObjectDetailsPage=new n({title:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_TITLE"),headerContent:O,footer:new i({content:[new s,f,b,h,y]})});var E=function(e){r._oNavContainer.back();r._oObjectDetailsPage.focus()};var S=r.buildTranslationsList(p+"_control_objectdetails_popover_translation_page_value_list");var D=r.buildTranslationsFooter(S,false);r._oTranslationListPage=new n({title:_.getText("EDITOR_FIELD_OBJECT_TRANSLATION_LIST_TITLE",["{languages>/property}"]),showNavButton:true,navButtonPress:E,content:S,footer:D});var w=function(e){var t=r._oObjectDetailsPopover.getModel();t.checkUpdate(true);var a=t.getProperty("/value");if(a&&a!==""&&typeof a==="object"&&!T(a,{})){f.setEnabled(true)}else{f.setEnabled(false)}};var C=function(){};if(e._dt&&e._dt._editable===false){P=r.createFormContents(C,"/value/",true,r.navToTranslationPage)}else{P=r.createFormContents(w,"/value/",true,r.navToTranslationPage)}var L=new I({layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,content:P});r._oObjectDetailsPage.addContent(L);r._oNavContainer.addPage(r._oObjectDetailsPage);r._oNavContainer.addPage(r._oTranslationListPage);r._oObjectDetailsPopover=new l(p+"_control_objectdetails_popover",{placement:v,showHeader:false,contentWidth:"300px",contentHeight:"345px",modal:true,content:r._oNavContainer}).addStyleClass("sapUiIntegrationEditorItemObjectFieldDetailsPopover");g=new u({value:c,editMode:"Properties"});r._oObjectDetailsPopover.setModel(g);r._oObjectDetailsPopover.setModel(r.getModel("i18n"),"i18n");r._oObjectDetailsPopover._oAddButton=f;r._oObjectDetailsPopover._oUpdateButton=b;r._oObjectDetailsPopover._oCancelButton=h;r._oObjectDetailsPopover._oCloseButton=y;r._oObjectDetailsPopover._openBy=t}else{g=r._oObjectDetailsPopover.getModel();g.setProperty("/value",c);g.checkUpdate(true);if(a==="add"){r._oObjectDetailsPopover._oAddButton.setVisible(true);r._oObjectDetailsPopover._oUpdateButton.setVisible(false);r._oObjectDetailsPopover._oCancelButton.setVisible(true);r._oObjectDetailsPopover._oCloseButton.setVisible(false)}else if(a==="update"){r._oObjectDetailsPopover._oAddButton.setVisible(false);r._oObjectDetailsPopover._oUpdateButton.setVisible(true);r._oObjectDetailsPopover._oCancelButton.setVisible(true);r._oObjectDetailsPopover._oCloseButton.setVisible(false)}else{r._oObjectDetailsPopover._oAddButton.setVisible(false);r._oObjectDetailsPopover._oUpdateButton.setVisible(false);r._oObjectDetailsPopover._oCancelButton.setVisible(false);r._oObjectDetailsPopover._oCloseButton.setVisible(true)}r._oObjectDetailsPopover._openBy=t;r._oObjectDetailsPopover.setPlacement(v);r._oNavContainer.back()}r._oObjectDetailsPopover.openBy(t)};N.prototype.buildTranslationsData=function(e,t,a,r){var o=this;var n=o.getResourceBundle();o._oOriginTranslatedValues=o._oOriginTranslatedValues||{};o._oUpdatedTranslations=o._oUpdatedTranslations||{};var l=a+"_"+r;var i=e;if(t==="key"){if(!o._oOriginTranslatedValues[e]){o._oOriginTranslatedValues[e]=o.getOriginTranslatedValues(e)}}else if(t==="property"){i=l;o._oOriginTranslatedValues[i]=o.buildPropertyTranslationValues(e)}var s=[];o._oOriginTranslatedValues[i].forEach(function(e){var t=m(e,500);t.updated=false;var l=o.getTranslationValueInTexts(t.key,a,r);if(l){t.value=l;if(Array.isArray(o._oUpdatedTranslations[i])){if(o._oUpdatedTranslations[i].includes(t.key)){t.value=o.getTranslationValueInTexts(t.key,a,r);t.updated=true}else{t.originValue=t.value}}}if(t.key===w._language){t.description+=" ("+n.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")+")";s.unshift(t)}else{s.push(t)}});var d={isUpdated:false,key:e,translationKey:i,translationType:t,uuid:a,property:r,translatedLanguages:s};return d};N.prototype.getTranslationKey=function(e){var t;if(e&&e.match(U)){t=e.substring(2,e.length-2)}else if(e&&e.startsWith("{i18n>")&&e.endsWith("}")){t=e.substring(6,e.length-1)}return t};N.prototype.buildTranslationsFooter=function(e,t){var a=this;var r=a.getParameterId();var o=a.getResourceBundle();var n=t?r+"_control_translation_popover":r+"_control_objectdetails_popover_translation_page";var l=new d(n+"_save_btn",{type:"Emphasized",text:o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var r=e.getModel("languages");var o=r.getData();var n=[];var l=o.key;var i=o.translationKey;var s=o.translationType;var d=o.uuid;var u=o.property;o.translatedLanguages.forEach(function(e){if(e.value!==e.originValue){if(e.updated){a.setTranslationValueInTexts(e.key,d,u,e.value);n.push(e.key)}}else if(e.updated){a.deleteTranslationValueInTexts(e.key,d,u)}});var p=false;if(n.length>0){a._oUpdatedTranslations=a._oUpdatedTranslations||{};a._oUpdatedTranslations[i]=n;if(n.includes(w._language)){p=true}}else if(a._oUpdatedTranslations){delete a._oUpdatedTranslations[i]}o=a.buildTranslationsData(l,s,d,u);r.setData(o);r.checkUpdate(true);if(a.getModel()){a.getModel().checkUpdate(true)}if(p&&a._oValueBinding){a._oValueBinding.fireEvent("change")}if(t){a._oTranslationPopover.close()}}});var u=new d(n+"_reset_btn",{text:o.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_RESET"),enabled:"{languages>/isUpdated}",press:function(t){var a=e.getModel("languages");var r=a.getData();r.translatedLanguages.forEach(function(e){e.value=e.originValue;e.updated=false});r.isUpdated=false;a.setData(r);a.checkUpdate(true)}});var p=new d(n+"_cancel_btn",{text:o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),visible:t,press:function(){a._oTranslationPopover.close()}});return new i({content:[new s,l,u,p]})};N.prototype.openTranslationPopup=function(e,t){var a=this;if(!a._oEditorResourceBundles.isReady()){setTimeout(function(){a.openTranslationPopup(e,t)},100);return}var r=t.getSource();var o=a.getResourceBundle();var n=r.getModel().getProperty("/value");if(!n._dt){n._dt={_uuid:w.generateUuidV4()}}else if(!n._dt._uuid){n._dt._uuid=w.generateUuidV4()}var i=r.getValue();var s=a.getTranslationKey(i);var d="property";if(s&&s!==""){d="key"}else{s=i}var u=a.buildTranslationsData(s,d,n._dt._uuid,e);var p;var _=this.getPopoverPlacement(r._oValueHelpIcon);if(!a._oTranslationPopover){var c=a.getParameterId();var g=a.buildTranslationsList(c+"_control_translation_popover_value_list");var v=a.buildTranslationsFooter(g,true);a._oTranslationPopover=new l(c+"_control_translation_popover",{placement:_,contentWidth:"300px",contentHeight:"345px",title:o.getText("EDITOR_FIELD_OBJECT_TRANSLATION_LIST_TITLE",["{languages>/property}"]),content:g,afterOpen:function(){a.fireTranslationPopoverOpened()},footer:v}).addStyleClass("sapUiIntegrationFieldTranslation");p=a.buildTranslationsModel(u);a._oTranslationPopover.setModel(p,"languages")}else{a._oTranslationPopover.setPlacement(_);p=a._oTranslationPopover.getModel("languages");p.setData(u);p.checkUpdate(true)}a._oTranslationPopover.openBy(r._oValueHelpIcon)};N.prototype.navToTranslationPage=function(e,t){var a=this;if(!a._oEditorResourceBundles.isReady()){setTimeout(function(){a.navToTranslationPage(e,t)},100);return}var r=a._oObjectDetailsPopover.getModel().getProperty("/value");var o=r[e];var n=a.getTranslationKey(o);var l="property";if(n&&n!==""){l="key"}else{n=o}var i=a.buildTranslationsData(n,l,r._dt._uuid,e);var s=a._oTranslationListPage.getModel("languages");if(!s){s=a.buildTranslationsModel(i);a._oTranslationListPage.setModel(s,"languages")}else{s.setData(i)}a._oNavContainer.to(a._oTranslationListPage);a._oTranslationListPage.focus()};N.prototype.onAdd=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=t._oObjectDetailsPopover.getModel().getProperty("/value");var n=a.getBinding("rows").getPath();var l=r.getProperty(n);l.forEach(function(e){if(e._dt._selected){e._dt._selected=false}});l.push(o);r.setProperty("/_hasSelected",true);r.setProperty("/_hasTableAllSelected",false);r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.checkUpdate();t.refreshValue();t.updateTable();t._oObjectDetailsPopover.close()};N.prototype.onAddDirectly=function(e){var t=this;var a=m(e,500);var r=t.getAggregation("_field");var o=r.getModel();var n=r.getBinding("rows").getPath();var l=o.getProperty(n);var i=1;l.unshift(a);l.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false;e._dt._position=i;i++});o.checkUpdate();t.refreshValue();t.updateTable()};N.prototype.onUpdate=function(e){var t=this;var a=t.getAggregation("_field");var r=t._oObjectDetailsPopover.getModel().getProperty("/value");var o=a.getModel();var n=t._oObjectDetailsPopover._openBy.getParent();var l=n.getIndex();var i=a.getBinding("rows").getContexts();var s=i[l].getPath();o.setProperty(s,m(r,500));o.checkUpdate();if(r._dt&&r._dt._selected){t.refreshValue()}t.updateTable();t._oObjectDetailsPopover.close()};N.prototype.onDelete=function(e){var t=this;var a=t.getAggregation("_field");var r=t.getResourceBundle();var o=a.getSelectedIndices();var n=[];var l=a.getBinding("rows").getContexts();o.forEach(function(e){var t=l[e].getObject();if(t._dt&&t._dt._editable!==false){var a=l[e].getPath();var r=a.substring(a.lastIndexOf("/")+1);n.push(r)}});if(n.length===0){O.error(r.getText("EDITOR_FIELD_OBJECT_DELETE_ERROR_MSG"));return}if(t.getAllowPopover()){O.confirm(r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_MSG"),{title:r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_TITLE"),onClose:function(e){if(e===O.Action.OK){var o=a.getBindingContext().getPath();var l=a.getModel();var i=l.getProperty(o);var s=[];for(var d=0;d<i.length;d++){if(n.includes(d+"")){t.deleteTranslationValueInTexts(undefined,i[d]._dt._uuid)}else{s.push(i[d])}}l.setProperty(o,s);l.checkUpdate(true);t.refreshValue();t.updateTable()}else{P.show(r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_CANCLE"))}}})}else{var i=a.getBinding("rows").getPath();var s=a.getModel();var d=s.getProperty(i);var u=[];for(var p=0;p<d.length;p++){if(n.includes(p+"")){t.deleteTranslationValueInTexts(undefined,d[p]._dt._uuid)}else{u.push(d[p])}}s.setProperty(i,u);s.checkUpdate(true);t.refreshValue();t.updateTable()}};N.prototype.refreshValue=function(){var e=this;var t=e.getAggregation("_field");var a=t.getModel();var r=t.getBinding("rows").getPath();var o=a.getProperty(r);var n;for(var l=0;l<o.length;l++){var i=o[l];if(i._dt._selected){n=m(i);break}}e.setValue(n)};N.prototype.resetControl=function(){var e=this;var t=e.getAggregation("_field");var a=e._getCurrentProperty("value");var r=t.getModel();if(t instanceof I){var o=r.getProperty("/value");if(o&&o._dt&&o._dt._uuid){e.deleteTranslationValueInTexts(undefined,o._dt._uuid)}a=a||{};r.setProperty("/value",a);r.checkUpdate(true)}else if(t instanceof p){var n=e.getConfiguration();var l;if(n.values){var i=t.getBinding("rows").getPath();l=r.getProperty(i);l.forEach(function(e){delete e._dt._selected})}e.mergeValueWithRequestResult(l)}};N.prototype.clearAllFilters=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getColumns();for(var o=0;o<r.length;o++){var n=r[o];if(o<r.length-1){n._applySelection=false}a.filter(n,undefined)}};N.prototype.setValue=function(e){var t=this;t.cleanDT(e);t._setCurrentProperty("value",e)};N.prototype.cleanDT=function(e){if(e&&e._dt&&e._dt._selected){delete e._dt._selected}if(e&&e._dt&&T(e._dt,{})){delete e._dt}};N.prototype.getTranslationValueInTexts=function(e,t,a){var r=this;var o=r.getConfiguration();var n="/texts/"+e;var l=this._settingsModel.getProperty(n)||{};var i=l[o.manifestpath];var s;if(i&&i[t]){s=i[t][a]}return s};N.prototype.setObjectPropertyConfigValueInDesigntime=function(e,t,a,r){var o=this;var n=o.getConfiguration();var l="/:designtime";var i=this._settingsModel.getData();if(!i){return}var s;if(!i.hasOwnProperty(":designtime")){s={}}else{s=m(i[":designtime"],500)}if(!s.hasOwnProperty(n.manifestpath)){s[n.manifestpath]={}}if(!s[n.manifestpath].hasOwnProperty(e)){s[n.manifestpath][e]={}}if(!s[n.manifestpath][e].hasOwnProperty(t)){s[n.manifestpath][e][t]={}}s[n.manifestpath][e][t][a]=r;this._settingsModel.setProperty(l,s)};N.prototype.getObjectPropertyConfigValueInDesigntime=function(e,t,a){var r=this;var o;var n=r.getConfiguration();var l=this._settingsModel.getData();if(l&&l[":designtime"]&&l[":designtime"][n.manifestpath]&&l[":designtime"][n.manifestpath][e]&&l[":designtime"][n.manifestpath][e][t]&&l[":designtime"][n.manifestpath][e][t].hasOwnProperty(a)){o=l[":designtime"][n.manifestpath][e][t][a]}return o};N.prototype.setTranslationValueInTexts=function(e,t,a,r){var o=this;var n=o.getConfiguration();var l="/texts";var i=this._settingsModel.getData();if(!i){return}var s;if(!i.hasOwnProperty("texts")){s={}}else{s=m(i.texts,500)}if(!s.hasOwnProperty(e)){s[e]={}}if(!s[e].hasOwnProperty(n.manifestpath)){s[e][n.manifestpath]={}}if(!s[e][n.manifestpath].hasOwnProperty(t)){s[e][n.manifestpath][t]={}}s[e][n.manifestpath][t][a]=r;this._settingsModel.setProperty(l,s)};N.prototype.deleteTranslationValueInTexts=function(e,t,a){var r=this;var o=r._settingsModel.getData();if(!o||!o.texts||!t){return}var n=r.getConfiguration();var l="/texts";var i=m(o.texts,500);if(e){if(i[e]&&i[e][n.manifestpath]&&i[e][n.manifestpath][t]){if(a){if(i[e][n.manifestpath][t].hasOwnProperty(a)){delete i[e][n.manifestpath][t][a];if(T(i[e][n.manifestpath][t],{})){delete i[e][n.manifestpath][t]}this._settingsModel.setProperty(l,i)}}else{delete i[e][n.manifestpath][t];if(T(i[e][n.manifestpath],{})){delete i[e][n.manifestpath];if(T(i[e],{})){delete i[e]}}this._settingsModel.setProperty(l,i)}}}else{for(var s in i){r.deleteTranslationValueInTexts(s,t,a)}}};return N});
//# sourceMappingURL=ObjectField.js.map