/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/Title","sap/m/Select","sap/m/ComboBox","sap/m/Popover","sap/m/Button","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/ui/core/ListItem","sap/m/VBox","sap/base/util/each","sap/base/util/restricted/_debounce","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/integration/util/Utils"],function(e,t,a,n,s,i,r,l,o,u,g,d,p,c,v,h,f){"use strict";var _=/parameters\.([^\}\}]+)/g;var T=["TODAY_ISO","NOW_ISO","LOCALE"];var y=e.extend("sap.ui.integration.editor.fields.StringField",{metadata:{library:"sap.ui.integration",events:{translationPopoverOpened:{}}},renderer:e.getMetadata().getRenderer()});y.prototype.initVisualization=function(e){var n=e.visualization;var r;if(!n){var l=e.value?e.value.match(_):undefined;var o,u,d;if(l&&l.length>0){l=l.filter(function(e){var t=e.substring(11);return!T.includes(t)})}if(l&&l.length>0){o=l.map(function(e){if(this.isOrigLangField){return"items>"+e.substring(11)+"/_language/value"}return"items>"+e.substring(11)+"/value"}.bind(this));o.unshift("currentSettings>value");u={parts:o,formatter:function(e){var t=Array.prototype.slice.call(arguments,1);for(var a=0;a<t.length;a++){if(t[a]){e=e.replaceAll("{{"+l[a]+"}}",t[a])}}return e}};d=function(e){var t=e.getSource().getValue();var a=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(a+"/value",t);var n=this._settingsModel.getBindings();var s=a.substring(a.lastIndexOf("/")+1);p(n,function(e,t){if(t.sPath==="/form/items/"+s+"/value"){t.checkUpdate(true)}})}.bind(this)}if(this.getMode()==="translation"){if(e.editable){n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder}}}else{n={type:a,settings:{text:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},visible:e.visible,wrapping:false}}}}else if(e.enum){r=new g({key:{path:"currentSettings>"},text:{path:"currentSettings>"}});n={type:s,settings:{selectedKey:{path:"currentSettings>value"},forceSelection:false,editable:e.editable,visible:e.visible,showSecondaryValues:false,width:"100%",items:{path:"currentSettings>enum",template:r}}}}else if(e.values){r=this.formatListItem(e.values.item);if(!e.values.item.key){e.values.item.key=e.values.item.text}n={type:i,settings:{busy:{path:"currentSettings>_loading"},selectedKey:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:r}}};if(this.isFilterBackend()){n.settings.selectedKey={parts:["currentSettings>value","currentSettings>suggestValue"],formatter:function(e,t){if((!e||e==="")&&t){return t.replaceAll("''","'")}else{return e}}}}}else if(this.getMode()!=="translation"&&e.translatable){n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder,valueHelpIconSrc:"sap-icon://translate",showValueHelp:true,valueHelpRequest:this.openTranslationListPopup.bind(this),change:function(e){var t=e.getSource();var a=t.getValue();var n=f._language;t.getParent().setTranslationValueInTexts(n,a)}}};if(o){delete n.settings.tooltip;n.settings.value=u;n.settings.change=d;n.settings.showValueHelp=false;delete n.settings.valueHelpRequest}}else{n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder}};if(o){delete n.settings.tooltip;n.settings.value=u;n.settings.change=d}}}else if(n.type==="TextArea"){n.type="sap/m/TextArea"}else if(n.type==="Select"&&e.values){r=this.formatListItem(e.values.item);var c=Object.assign({selectedKey:{path:"currentSettings>value"},forceSelection:false,editable:e.editable,visible:e.visible,showSecondaryValues:false,width:"100%",items:{path:"",template:r}},n.settings||{});n={type:s,settings:c}}this._visualization=n;this.attachAfterInit(this._afterInit)};y.prototype._afterInit=function(){var e=this.getAggregation("_field");if(e instanceof i){if(this.isFilterBackend()){this.onInput=c(this.onInput,500);e.oninput=this.onInput.bind(this);e.attachSelectionChange(this.onSelectionChange.bind(this))}}};y.prototype.onSelectionChange=function(e){var t=e.getParameter("selectedItem")||{};var a=t.getKey();var n=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(n+"/value",a)};y.prototype.onInput=function(e){var t=e.target.value;var a=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(a+"/suggestValue",t.replaceAll("'","''"));this._settingsModel.setProperty(a+"/_loading",true);this._settingsModel.setProperty(a+"/value","");var n=this._settingsModel.getBindings();var s=a.substring(a.lastIndexOf("/")+1);p(n,function(e,t){if(t.sPath==="/form/items/"+s+"/value"){t.checkUpdate(true)}});var i=e.srcControl;i.open();i.setValue(t);i.setSelection(null)};y.prototype.getOriginTranslatedValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();var n;if(e._translatedDefaultPlaceholder&&e._translatedDefaultPlaceholder.startsWith("{i18n>")&&e._translatedDefaultPlaceholder.endsWith("}")){n=e._translatedDefaultPlaceholder.substring(6,e._translatedDefaultPlaceholder.length-1)}else if(e._translatedDefaultPlaceholder&&e._translatedDefaultPlaceholder.startsWith("{{")&&e._translatedDefaultPlaceholder.endsWith("}}")){n=e._translatedDefaultPlaceholder.substring(2,e._translatedDefaultPlaceholder.length-2)}for(var s in a){var i=a[s];var r="";var l="";if(n&&i){var o=i.resourceBundle&&i.resourceBundle.getText(n,[],true);if(o!==undefined){r=o;l=o}else{r=e._translatedValue||"";l=e._translatedValue||""}}else{r=e._translatedDefaultPlaceholder||"";l=e._translatedDefaultPlaceholder||""}var u={key:s,description:i.language,value:r,originValue:l,editable:true};t.push(u)}return t};y.prototype.getTranslationValueInTexts=function(e,t){var a="/texts/"+e;var n=this._settingsModel.getProperty(a)||{};return n[t]};y.prototype.setTranslationValueInTexts=function(e,t){var a=this.getConfiguration().manifestpath;var n="/texts";var s=this._settingsModel.getData();if(!s){return}if(!s.hasOwnProperty("texts")){var i={};i[e]={};i[e][a]=t;this._settingsModel.setProperty(n,i)}else{n="/texts/"+e;var r;if(!s.texts.hasOwnProperty(e)){r={}}else{r=s.texts[e]}r[a]=t;this._settingsModel.setProperty(n,r)}};y.prototype.deleteTranslationValueInTexts=function(e){var t=this.getConfiguration().manifestpath;var a=this._settingsModel.getData();if(a&&a.texts&&a.texts[e]){delete a.texts[e][t]}if(h(a.texts[e],{})){delete a.texts[e]}if(h(a.texts,{})){delete a.texts}this._settingsModel.setData(a)};y.prototype.openTranslationListPopup=function(e){var s=this;if(!s._oEditorResourceBundles.isReady()){setTimeout(function(){s.openTranslationListPopup(e)},100);return}var i=e.getSource();var g=s.getParameterId();var p=s.getResourceBundle();var c=s.buildTranslationsData(i);var v;var h=s.getPopoverPlacement(i._oValueHelpIcon);if(!s._oTranslationPopover){var f=s.buildTranslationsList(g+"_translation_popover_value_list");s._oTranslationPopover=new r(g+"_translation_popover",{placement:h,contentWidth:"300px",contentHeight:"345px",customHeader:new d({items:[new n({text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_TITLE")}).addStyleClass("sapMPopoverTitle"),new n({text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")}).addStyleClass("sapMHeaderTitle"),new d({items:[new a(g+"_translation_popover_currentlanguage_description_label",{text:"{languages>/currentLanguage/description}"}),new t(g+"_translation_popover_currentlanguage_value_input",{value:"{languages>/currentLanguage/value}",editable:false})]}).addStyleClass("sapMCurrentLanguageVBox"),new n({text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_OTHERLANGUAGES")}).addStyleClass("sapMHeaderTitle")]}),content:f,afterOpen:function(){s.fireTranslationPopoverOpened()},footer:new o({content:[new u,new l(g+"_translation_popover_save_btn",{type:"Emphasized",text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var e=s._oTranslationPopover.getModel("languages").getData();var t=[];e.translatedLanguages.forEach(function(e){if(e.value!==e.originValue){if(e.updated){s.setTranslationValueInTexts(e.key,e.value);t.push(e.key)}}else if(e.updated){s.deleteTranslationValueInTexts(e.key)}});if(t.length>0){s._aUpdatedLanguages=t}else{s._aUpdatedLanguages=undefined}s._oTranslationPopover.close()}}),new l(g+"_translation_popover_cancel_btn",{text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),press:function(){s._oTranslationPopover.close()}})]})}).addStyleClass("sapUiIntegrationFieldTranslation");v=s.buildTranslationsModel(c);s._oTranslationPopover.setModel(v,"languages")}else{s._oTranslationPopover.setPlacement(h);v=s._oTranslationPopover.getModel("languages");v.setData(c);v.checkUpdate(true)}s._oTranslationPopover.openBy(i._oValueHelpIcon)};y.prototype.buildTranslationsData=function(e){var t=this;var a=t.getConfiguration();if(!t._aOriginTranslatedValues){t._aOriginTranslatedValues=t.getOriginTranslatedValues(a)}var n=v(t._aOriginTranslatedValues,500);n.forEach(function(e){var n=t.getTranslationValueInTexts(e.key,a.manifestpath);if(n){e.value=n;if(Array.isArray(t._aUpdatedLanguages)&&!t._aUpdatedLanguages.includes(e.key)){e.originValue=e.value}}else if(a._beforeLayerChange){e.value=a._beforeLayerChange;if(Array.isArray(t._aUpdatedLanguages)&&!t._aUpdatedLanguages.includes(e.key)){e.originValue=e.value}}e.updated=false;if(e.key===f._language){e.editable=false}});var s={currentLanguage:{},isUpdated:false,translatedLanguages:[]};if(n){n.forEach(function(n){if(Array.isArray(t._aUpdatedLanguages)&&t._aUpdatedLanguages.includes(n.key)){n.value=t.getTranslationValueInTexts(n.key,a.manifestpath);n.updated=true}if(n.key===f._language){n.value=e.getValue();s.currentLanguage=n}else{s.translatedLanguages.push(n)}})}return s};return y});
//# sourceMappingURL=StringField.js.map