/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/MultiComboBox","sap/m/MultiInput","sap/base/util/restricted/_debounce","sap/base/util/restricted/_isEqual","sap/base/util/ObjectPath","sap/base/util/merge","sap/ui/core/SeparatorItem","sap/ui/model/Sorter","sap/m/Token","sap/m/Tokenizer","sap/base/util/deepClone","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver"],function(e,t,r,a,i,n,s,o,u,l,g,v,c,h,p){"use strict";var d=e.extend("sap.ui.integration.editor.fields.StringListField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});d.prototype.initVisualization=function(e){var i=this,n;var s=e.visualization;if(!s){if(e.values){n=this.formatListItem(e.values.item);s={type:r,settings:{selectedKeys:{path:"currentSettings>value"},busy:{path:"currentSettings>_loading"},editable:e.editable,visible:e.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:n,sorter:[new l({path:"Selected",descending:false,group:true})],groupHeaderFactory:i.getGroupHeader}}};if(this.isFilterBackend()){s.settings.selectedKeys={parts:["currentSettings>value","currentSettings>suggestValue"],formatter:function(e,t){if(t){i.setSuggestValue()}return e}}}}else{s={type:t,settings:{value:{path:"currentSettings>value",formatter:function(e){e=e||[];return e.join(",")}},change:function(e){var t=e.getSource();t.getBinding("value").setRawValue(t.getValue().split(","))},editable:e.editable,visible:e.visible,placeholder:e.placeholder}}}}else if(e.values&&this.isFilterBackend()&&s.type==="MultiInput"){n=this.formatListItem(e.values.item);var u={busy:{path:"currentSettings>_loading"},placeholder:e.placeholder,editable:e.editable,visible:e.visible,showSuggestion:true,autocomplete:false,showValueHelp:false,filterSuggests:false,width:"100%",suggestionItems:{path:"",template:n,sorter:[new l({path:"Selected",descending:false,group:true})],groupHeaderFactory:i.getGroupHeader}};if(s.settings){u=o(u,s.settings)}s={type:a,settings:u}}this._visualization=s;this.attachAfterInit(this._afterInit)};d.prototype._afterInit=function(){var e=this.getAggregation("_field");var t=this.getModel();if(e instanceof r){if(this.isFilterBackend()){this.onInputForMultiComboBox=i(this.onInputForMultiComboBox,500);e.oninput=this.onInputForMultiComboBox;e.attachSelectionChange(this.onSelectionChangeForFilterBackend);e.attachSelectionFinish(this.onSelectionFinishForFilterBackend);t.attachPropertyChange(this.onPropertyChangeForFilterBackend,this)}else{e.attachSelectionChange(this.onSelectionChange);t.attachPropertyChange(this.onPropertyChange,this)}}else if(e instanceof a){this.initTokens();this.onInputForMultiInput=i(this.onInputForMultiInput,500);e.oninput=this.onInputForMultiInput;t.attachPropertyChange(this.onPropertyChangeForFilterBackend,this);t.attachPropertyChange(this.initTokens,this);e.attachTokenChange(this.onTokenChange)}};d.prototype.initTokens=function(){var e=this.getAggregation("_field");var t=this.getConfiguration();var r=[];if(Array.isArray(t.valueTokens)&&t.valueTokens.length>0){t.valueTokens.forEach(function(e){var t=new g(e);r.push(t)})}else if(Array.isArray(t.value)&&t.value.length>0&&Array.isArray(t.valueItems)&&t.valueItems.length>0){t.valueTokens=[];t.valueItems.forEach(function(e){var a=new h;a.setData(e);var i=p.resolveValue(t.values.item.key,a);if(t.value.includes(i)){var n=p.resolveValue(t.values.item.text,a);var s={key:i,text:n};var o=new g(s);r.push(o);t.valueTokens.push(s)}})}e.setTokens(r)};d.prototype.getKeyFromItem=function(e){var t=this.getConfiguration();var r=new h;r.setData(e);return p.resolveValue(t.values.item.key,r)};d.prototype.onPropertyChangeForFilterBackend=function(e){var t=this.getConfiguration();if(!t.valueItems){t.valueItems=[]}var r=t.values.data.path||"/";var a=this.getModel();var i=a.getData();if(r!=="/"){if(r.startsWith("/")){r=r.substring(1)}if(r.endsWith("/")){r=r.substring(0,r.length-1)}var n=r.split("/");var o=s.get(n,i);o=this.mergeSelectedItems(t,o);s.set(n,o,i)}else{i=this.mergeSelectedItems(t,i)}a.setData(i);this.setSuggestValue()};d.prototype.onPropertyChange=function(e){var t=this.getAggregation("_field");var r=t.getSelectedItems().map(function(e){return e.getKey()});var a=this.getBindingContext("currentSettings").sPath;var i=this.getModel("currentSettings");i.setProperty(a+"/value",r)};d.prototype.mergeSelectedItems=function(e,t){var r=this;var a=r.getResourceBundle();if(Array.isArray(t)){var i=e.valueItems.map(function(e){return this.getKeyFromItem(e)}.bind(this));var s=t.filter(function(e){var t=this.getKeyFromItem(e);return!i.includes(t)}.bind(this));var o=s.filter(function(e){return e.Selected===a.getText("EDITOR_ITEM_SELECTED")});e.valueItems=e.valueItems.concat(o);var u=s.filter(function(e){return e.Selected!==a.getText("EDITOR_ITEM_SELECTED")});t=e.valueItems.concat(u);var l=this.getAggregation("_field");if(l.isOpen&&l.isOpen()){i=e.valueItems.map(function(e){return this.getKeyFromItem(e)}.bind(this));var g=l.getSelectedKeys();if(!n(i,g)){l.setSelectedKeys(i)}}}else{t=e.valueItems}return t};d.prototype.setSuggestValue=function(){var e=this.getAggregation("_field");var t=this.getBindingContext("currentSettings").sPath;var r=this.getModel("currentSettings");var a=r.getProperty(t+"/suggestValue");if(a&&a!==""){e.setValue(a.replaceAll("''","'"))}};d.prototype.getSuggestValue=function(){var e=this.getBindingContext("currentSettings").sPath;var t=this.getModel("currentSettings");return t.getProperty(e+"/suggestValue")};d.prototype.getGroupHeader=function(e){return new u({text:e.key})};d.prototype.onSelectionChangeForFilterBackend=function(e){var t=e.getSource().getParent();var r=t.getConfiguration();var a=t.getResourceBundle();var i=e.getParameter("changedItem");var n=i.getKey();var o=e.getParameter("selected");var u=this.getModel().getData();var l=r.values.data.path||"/";var g,v;if(l!=="/"){if(l.startsWith("/")){l=l.substring(1)}if(l.endsWith("/")){l=l.substring(0,l.length-1)}g=l.split("/");v=s.get(g,u)}else{v=u}if(v){if(!r.valueItems){r.valueItems=[]}var h=[];v.forEach(function(e){var i=c(e,500);var s=t.getKeyFromItem(i);if(s===n){if(o){i.Selected=a.getText("EDITOR_ITEM_SELECTED");r.valueItems=r.valueItems.concat([i])}else{i.Selected=a.getText("EDITOR_ITEM_UNSELECTED");r.valueItems=r.valueItems.filter(function(e){var r=t.getKeyFromItem(e);return r!==n})}}h.push(i)});if(g!==undefined){s.set(g,h,u);this.getModel().checkUpdate(true)}else{this.getModel().setData(h)}}};d.prototype.onTokenChange=function(e){var t=this.getParent();var r=t.getConfiguration();var a=t.getResourceBundle();var i=t.getModel("currentSettings");var n=t.getBindingContext("currentSettings").sPath;var o=i.getProperty(n+"/value");var u=e.getParameter("token");if(u){var l=u.getKey();if(!r.valueTokens){r.valueTokens=[]}if(!o){o=[]}var g=e.getParameter("type");switch(g){case v.TokenChangeType.Removed:o=o.filter(function(e){return e!==l});r.value=o;r.valueTokens=r.valueTokens.filter(function(e){return e.key!==l});break;case v.TokenChangeType.Added:if(!o.includes(l)){o=o.concat([l]);r.value=o}var h=r.valueTokens.map(function(e){return e.key});if(!h.includes(l)){r.valueTokens=r.valueTokens.concat([{key:l,text:u.getText()}])}break;case v.TokenChangeType.RemovedAll:r.value=[];r.valueItems=[];r.valueTokens=[];break;default:break}var p=t.getModel().getData();var d;var f=r.values.data.path||"/";var m;if(f!=="/"){if(f.startsWith("/")){f=f.substring(1)}if(f.endsWith("/")){f=f.substring(0,f.length-1)}m=f.split("/");d=c(s.get(m,p),10)}else{d=c(p,10)}if(Array.isArray(d)){r.valueItems=[];d.forEach(function(e){var i=t.getKeyFromItem(e);if(r.value.includes(i)){e.Selected=a.getText("EDITOR_ITEM_SELECTED");r.valueItems.push(e)}else{e.Selected=a.getText("EDITOR_ITEM_UNSELECTED")}});if(f!=="/"){s.set(m,d,p)}else{p=d}t.getModel().setData(p);t.getModel().checkUpdate(true)}i.setProperty(n+"/value",r.value);i.setProperty(n+"/valueItems",r.valueItems);i.setProperty(n+"/valueTokens",r.valueTokens)}};d.prototype.onSelectionChange=function(e){var t=e.oSource.getParent();var r=t.getConfiguration();var a=t.getResourceBundle();var i=e.getParameter("changedItem");var n=i.getKey();var o=e.getParameter("selected");var u=this.getModel().getData();var l=r.values.data.path||"/";if(l!=="/"){if(l.startsWith("/")){l=l.substring(1)}if(l.endsWith("/")){l=l.substring(0,l.length-1)}var g=l.split("/");var v=s.get(g,u);if(Array.isArray(v)){for(var c in v){var h=t.getKeyFromItem(v[c]);if(h===n){if(o){v[c].Selected=a.getText("EDITOR_ITEM_SELECTED")}else{v[c].Selected=a.getText("EDITOR_ITEM_UNSELECTED")}}}s.set(g,v,u)}}else if(Array.isArray(u)){for(var c in u){var h=t.getKeyFromItem(u[c]);if(h===n){if(o){u[c].Selected=a.getText("EDITOR_ITEM_SELECTED")}else{u[c].Selected=a.getText("EDITOR_ITEM_UNSELECTED")}}}}this.getModel().setData(u);this.getModel().checkUpdate(true)};d.prototype.onSelectionFinishForFilterBackend=function(e){var t=this.getParent();var r=t.getConfiguration();var a=e.getParameter("selectedItems").map(function(e){return e.getKey()});var i=this.getModel().getData();var n=r.values.data.path||"/";if(n!=="/"){if(n.startsWith("/")){n=n.substring(1)}if(n.endsWith("/")){n=n.substring(0,n.length-1)}var o=n.split("/");i=s.get(o,i)}if(i){r.valueItems=i.filter(function(e){var r=t.getKeyFromItem(e);return a.includes(r)})}var u=this.getBindingContext("currentSettings").sPath;var l=this.getModel("currentSettings");l.setProperty(u+"/value",a);var g=t.getSuggestValue();if(g&&g!==""){l.setProperty(u+"/suggestValue","")}};d.prototype.onInputForMultiComboBox=function(e){var t=e.target.value;var r=this.getBindingContext("currentSettings").sPath;var a=this.getModel("currentSettings");a.setProperty(r+"/suggestValue",t.replaceAll("'","''"));a.setProperty(r+"/_loading",true);e.srcControl.open();e.srcControl._getSuggestionsPopover()._sTypedInValue=t};d.prototype.onInputForMultiInput=function(e){var t=e.srcControl;a.prototype.oninput.apply(t,arguments);var r=e.target.value;if(r===""){return}var i=this.getBindingContext("currentSettings").sPath;var n=this.getModel("currentSettings");var s=n.getProperty(i+"/suggestValue");if(s!==r.replaceAll("'","''")){n.setProperty(i+"/suggestValue",r.replaceAll("'","''"));n.setProperty(i+"/_loading",true)}};return d});
//# sourceMappingURL=StringListField.js.map