/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/integration/editor/fields/viz/VizBase","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/core/IconPool","sap/ui/core/_IconRegistry","sap/base/util/merge","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/integration/formatters/IconFormatter","sap/m/Popover","sap/m/Image","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Text","sap/m/CheckBox","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/integration/util/Utils"],function(e,t,o,i,n,s,l,a,r,c,p,d,u,h,f,g,_,I,y,S,C){"use strict";var m=t.getResourceBundleFor("sap.ui.integration",C._language),b,v,T=false;var P=o.extend("sap.ui.integration.editor.fields.viz.IconSelect",{metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:""},allowFile:{type:"boolean",defaultValue:true},allowNone:{type:"boolean",defaultValue:true},allowDefaultIcons:{type:"boolean",defaultValue:true}},events:{change:{}}},renderer:{apiVersion:2}});P.prototype._initDefaultIcons=function(){b=[];var e=l.getIconNames();e=e.sort(function(e,t){return e.toLowerCase().localeCompare(t.toLowerCase())});e.filter(function(e){var t=l.getIconInfo(e).text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);b.push({icon:"sap-icon://"+e,key:"sap-icon://"+e,text:t,additionalText:"sap-icon://"+e,tooltip:t,enabled:true,type:"UI5"})});if(!T){return}var t=a.getFontRegistry();if(!t["SAP-icons-TNT"]){l.registerFont({fontFamily:"SAP-icons-TNT",collectionName:"SAP-icons-TNT",fontURI:sap.ui.require.toUrl("sap/tnt/themes/base/fonts")})}if(!t["BusinessSuiteInAppSymbols"]){l.registerFont({fontFamily:"BusinessSuiteInAppSymbols",collectionName:"BusinessSuiteInAppSymbols",fontURI:sap.ui.require.toUrl("sap/ushell/themes/base/fonts/")})}v=Promise.all([l.fontLoaded("SAP-icons-TNT"),l.fontLoaded("BusinessSuiteInAppSymbols")]).then(function(){e=l.getIconNames("SAP-icons-TNT");e=e.filter(function(e){var t=e.substring(0,1).charCodeAt();return e.indexOf(" ")<0&&t>=97&&t<=122});e.sort();e.filter(function(e){var t=l.getIconInfo(e,"SAP-icons-TNT").text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);b.push({icon:"sap-icon://SAP-icons-TNT/"+e,key:"sap-icon://SAP-icons-TNT/"+e,text:t,additionalText:"sap-icon://SAP-icons-TNT/"+e,tooltip:t,enabled:true,type:"SAP-icons-TNT"})});e=l.getIconNames("BusinessSuiteInAppSymbols");e.sort();e.filter(function(e){var t=l.getIconInfo(e,"BusinessSuiteInAppSymbols").text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);b.push({icon:"sap-icon://BusinessSuiteInAppSymbols/"+e,key:"sap-icon://BusinessSuiteInAppSymbols/"+e,text:t,additionalText:"sap-icon://BusinessSuiteInAppSymbols/"+e,tooltip:t,enabled:true,type:"BusinessSuiteInAppSymbols"})})})};P.prototype._initIconModel=function(){var e=[{icon:"",text:m.getText("EDITOR_ICON_NONE"),tooltip:"",key:d.SRC_FOR_HIDDEN_ICON,enabled:true,type:"Action"},{icon:"sap-icon://upload",text:m.getText("EDITOR_ICON_CHOOSE"),tooltip:"",key:"file",enabled:true,type:"Action"},{icon:"sap-icon://download",text:m.getText("EDITOR_ICON_SELECTED"),tooltip:"",key:"selected",enabled:false,type:"Action"}];this._oIconModel=new s(e);this._oIconModel.setSizeLimit(e.length)};P.prototype._initConfigModel=function(){var e={icons:{layout:"Grid",types:{Action:true,UI5:true,"SAP-icons-TNT":true,BusinessSuiteInAppSymbols:true}}};this._oConfigModel=new s(e)};P.prototype.onInit=function(){if(m&&m.sLocale!==C._language){m=t.getResourceBundleFor("sap.ui.integration",C._language)}if(!this._oIconModel){this._initIconModel()}if(!b){this._initDefaultIcons()}if(v){v.then(function(){if(this.getAllowDefaultIcons()){var e=this._oIconModel.getData();e=e.concat(c(b,500));this._oIconModel.setData(e);this._oIconModel.setSizeLimit(e.length);this._oIconModel.checkUpdate(true);this._oControl&&this._oControl.setSelectedKey(this.getValue())}v=undefined}.bind(this))}else if(this.getAllowDefaultIcons()){var e=this._oIconModel.getData();e=e.concat(c(b,500));this._oIconModel.setData(e);this._oIconModel.setSizeLimit(e.length)}if(!this._oConfigModel){this._initConfigModel()}var o=new n({icon:"{iconlist>icon}",text:"{iconlist>text}",tooltip:"{iconlist>tooltip}",key:"{iconlist>key}",additionalText:"{iconlist>additionalText}",enabled:{parts:["config>/icons/types","iconlist>type","iconlist>enabled"],formatter:function(e,t,o){return o&&e[t]}}});this._oFileUpload=document.createElement("INPUT");this._oFileUpload.type="file";this._oFileUpload.accept=".png,.jpg,.jpeg,.svg";this._boundFileUploadChange=this._fileUploadChange.bind(this);this._oFileUpload.addEventListener("change",this._boundFileUploadChange);this._oControl=new i({width:"100%",items:{path:"iconlist>/",template:o},change:function(e){var t=e.getSource(),o=e.getSource().getSelectedKey();if(o==="file"){t._customImage=null;this._oFileUpload.click();this._boundFocusBack=this._focusBack.bind(this);t.getDomRef("hiddenSelect").addEventListener("focus",this._boundFocusBack)}else{this.setValue(o);this.fireChange(e)}}.bind(this)});this._oControl.setModel(this._oIconModel,"iconlist");this._oControl.setModel(this._oConfigModel,"config");this._oControl._fnOpen=this._oControl.open;if(this.getAllowDefaultIcons()){var s=this;this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);s._oPicker=this.getPicker();var e=false;if(!s._oPicker.getFooter()&&e){var t=new f({content:[new y({selectedKey:"{config>/icons/layout}",items:[new S({icon:"sap-icon://grid",tooltip:"Grid View",key:"Grid"}),new S({icon:"sap-icon://list",tooltip:"Details View",key:"Details"})],select:function(e){var t=e.getSource();var o=t.getSelectedKey();if(o==="Grid"){this._oPicker.addStyleClass("sapUiIntegrationIconSelectList");this._oControl.setShowSecondaryValues(false)}else if(o==="Details"){this._oPicker.removeStyleClass("sapUiIntegrationIconSelectList");this._oControl.setShowSecondaryValues(true)}}.bind(s)}),new g,new _({text:"Icon Types:"}),new I({selected:"{config>/icons/types/UI5}",text:"UI5",select:s.onIconTypeChanged.bind(s)}),new I({selected:"{config>/icons/types/SAP-icons-TNT}",text:"Fiori",select:s.onIconTypeChanged.bind(s)}),new I({selected:"{config>/icons/types/BusinessSuiteInAppSymbols}",text:"Business Suite",select:s.onIconTypeChanged.bind(s)})]});s._oPicker.setFooter(t)}if(!p(s._oConfigModel.getProperty("/icons/types"),{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){s._oPicker.addStyleClass("sapUiIntegrationIconSelectList");s._oPicker.setContentHeight("400px")}}}this._oControl.addDelegate({onAfterRendering:this.onAfterRenderingSelect.bind(this)});this._oControl.addDelegate({onsappageup:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();this._oControl.setSelectedIndex(e-50)}}.bind(this),onsappagedown:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();if(e<3){this._oControl.setSelectedIndex(29)}else{this._oControl.setSelectedIndex(e+50)}}}.bind(this),onsapup:function(){if(this._oControl.isOpen()){var e=this.getAllowFile();var t=this.getAllowNone();var o=this._oIconModel.getProperty("/2/enabled");var i=this._oControl.getSelectedIndex();if(i>11+2){this._oControl.setSelectedIndex(i-11)}else if(i>=3){if(t&&!e){this._oControl.setSelectedIndex(0)}else if(o){this._oControl.setSelectedIndex(2)}else{this._oControl.setSelectedIndex(3)}}}}.bind(this),onsapdown:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();if(e>1){this._oControl.setSelectedIndex(e+11)}}}.bind(this),onsapleft:function(){if(this._oControl.isOpen()){this._oControl.onsapup.apply(this._oControl,arguments)}}.bind(this),onsapright:function(){if(this._oControl.isOpen()){this._oControl.onsapdown.apply(this._oControl,arguments)}}.bind(this)},true)};P.prototype.applyStyle=function(e){e.class("sapUiIntegrationIconSelect");if(this._oControl&&this._oControl.getWidth){e.style("width",this._oControl.getWidth())}};P.prototype.onIconTypeChanged=function(e){this._oConfigModel.checkUpdate(true);var t=this._oConfigModel.getProperty("/icons/types");if(p(t,{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){this._oPicker.setContentHeight("")}else{this._oPicker.setContentHeight("400px")}var o=this.getValue();if(o&&o.indexOf("data:image/")===0){this._oControl._customImage=o;this._oIconModel.setProperty("/2/enabled",true);this._oControl.setSelectedKey("selected")}else{this._oControl.setSelectedKey(o)}};P.prototype._fileUploadChange=function(){var e=new window.FileReader;e.onload=function(){this.setValue(e.result);this._oControl.invalidate()}.bind(this);if(this._oFileUpload.files.length===1){e.readAsDataURL(this._oFileUpload.files[0])}};P.prototype._focusBack=function(){this._oControl.getDomRef("hiddenSelect").removeEventListener("focus",this._boundFocusBack);setTimeout(function(){this.setValue(this.getValue())}.bind(this),150)};P.prototype.bindPropertyToControl=function(e,t){if(e==="editable"){var o=r({},t);this._oControl.bindProperty("editable",o)}};P.prototype.setValue=function(e){this.setProperty("value",e,true);if(e&&e.indexOf("data:image/")===0){this._oControl._customImage=e;this._oIconModel.setProperty("/2/enabled",true);this._oControl.setSelectedKey("selected")}else{this._oControl._customImage=null;this._oIconModel.setProperty("/2/enabled",false);this._oControl.setSelectedKey(e)}this._oControl.invalidate();return this};P.prototype.setAllowFile=function(e){this.setProperty("allowFile",e,true);e=this.getAllowFile();this._oIconModel.setProperty("/1/enabled",e);return this};P.prototype.setAllowNone=function(e){this.setProperty("allowNone",e,true);e=this.getAllowNone();this._oIconModel.setProperty("/0/enabled",e);return this};P.prototype.onAfterRenderingSelect=function(){var t=this._oControl.getDomRef("labelIcon");if(t){var o=this._oControl._customImage;var i=e.getElementById(t.id);if(o){t.style.backgroundImage="url('"+o+"')";t.classList.add("sapMSelectListItemIconCustom");t.children[0].title=m.getText("EDITOR_IMAGE_CUSTOMICON_TOOLTIP");i.onclick=function(e){e.stopImmediatePropagation();if(!i._oImagePopover){i._oImagePopover=new u(i.getId()+"-imagePopover",{placement:"Right",showHeader:false}).addStyleClass("sapUiIntegrationImageSelect")}i._oImagePopover.destroyContent();i._oImagePopover.addContent(new h(i.getId()+"-imagePopover-image",{src:o}).addStyleClass("image"));i._oImagePopover.openBy(i)}}else{t.style.backgroundImage="unset";t.classList.remove("sapMSelectListItemIconCustom");i.onclick=undefined}}};P.prototype.setAllowDefaultIcons=function(e){if(typeof e==="boolean"&&this.getAllowDefaultIcons()!==e){var t=this._oIconModel.getData();if(e){t=t.concat(c(b,500));var o=this._oConfigModel.getProperty("/icons/types");this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);if(!p(o,{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){this._oPicker.addStyleClass("sapUiIntegrationIconSelectList");this._oPicker.setContentHeight("400px")}}}else{t=t.slice(0,3);this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);this.getPicker().removeStyleClass("sapUiIntegrationIconSelectList")}}this._oIconModel.setData(t);this._oIconModel.setSizeLimit(t.length)}};return P});
//# sourceMappingURL=IconSelect.js.map