/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/ui/integration/Extension","sap/ui/integration/util/OAuth3LOHelper","sap/ui/integration/util/Utils","sap/m/IllustratedMessageType","sap/ui/integration/library","sap/ui/core/library","sap/m/library","sap/base/Log"],function(t,e,n,o,s,i,r,a){"use strict";const l=i.aria.HasPopup;const p=s.CardBlockingMessageType;const u=r.ButtonType;const c=t.extend("sap.ui.integration.extensions.OAuth3LO");c.prototype.overrideBlockingMessage=function(t){if(!t){return null}if(!e.needsConsent(t)){return null}if(e.hasConsentError(t)){return this._createConsentErrorMessage(t)}return this._createConsentMessage(t)};c.prototype.fetch=async function(n,o,s){const i=await t.prototype.fetch.apply(this,arguments);if(e.needsConsent(i)){this._aPollingRequest=[n,o,s]}return i};c.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._sConsentId){e.unregisterCard(this._sConsentId,this.getCard())}if(this._oPolling){this._oPolling.stop();this._oPolling=null}};c.prototype._createConsentMessage=function(t){const n=this.getCard();const s=e.readHeader(t);this._sConsentId=s.consent.id;e.registerCard(this._sConsentId,n);const i=new URL(s.consent.url,window.location.href);return{type:p.Information,illustrationType:o.Connection,imageSrc:s.imageSrc,title:s.title||n.getTranslatedText("CARD_OAUTH3LO_FALLBACK_TITLE"),description:s.description||n.getTranslatedText("CARD_OAUTH3LO_FALLBACK_DESCRIPTION",[i.origin]),additionalContent:[{text:s.buttonText||n.getTranslatedText("CARD_OAUTH3LO_FALLBACK_BUTTON_TEXT"),buttonType:u.Accept,ariaHasPopup:l.Dialog,press:()=>{this._triggerConsent(s)}}]}};c.prototype._createConsentErrorMessage=function(t){const n=this.getCard();const s=e.readHeader(t);a.error(s.message,this);return{type:p.Error,illustrationType:o.ErrorScreen,title:n.getTranslatedText("CARD_ERROR_CONFIGURATION_TITLE"),description:n.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION")}};c.prototype._triggerConsent=function(t){const n=t.consent.url;if(!n){a.error("Consent url for OAuth3LO is empty.",this);return}e.openConsentWindow(n,t.popupWindow);window.addEventListener("focus",()=>{this._startPolling(t)},{once:true})};c.prototype._startPolling=function(o){const s=o.polling;if(this._oPolling){this._oPolling.stop()}this._oPolling=n.polling(async()=>{a.info("Polling for 3LO consent.",this);const n=await t.prototype.fetch.apply(this,this._aPollingRequest);if(e.hasConsentError(n)){this.getCard().showBlockingMessage(this._createConsentErrorMessage(n));return true}if(e.needsConsent(n)){return false}if(n.ok){e.handleConsent(o.consent.id)}return true},s.frequency,s.maximum)};return c});
//# sourceMappingURL=OAuth3LO.js.map