/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function (window) {
	"use strict";
	var Core;
	var Lib;

	//initialize the loader
	function boot() {
		if (window.sap.ui.require("sap/ui/core/Core") && window.sap.ui.require("sap/ui/core/Lib")) {
			Core = window.sap.ui.require("sap/ui/core/Core");
			Lib = window.sap.ui.require("sap/ui/core/Lib");
			initTags();
			return;
		}

		window.sap.ui.require(["sap/ui/core/Core", "sap/ui/core/Lib"],
			function (_Core, _Lib) {
				Core = _Core;
				Lib = _Lib;

				/**
				 * @deprecated As of version 1.120
				 */
				Core.boot();

				Core.ready().then(initTags);
			});
	}

	function registerLibraryTags(oIntegrationLib) {
		var mCustomElements = oIntegrationLib.extensions["sap.ui.integration"].customElements,
			aTags = Object.keys(mCustomElements);

		//collect all the implementation classes and require them
		window.sap.ui.require(
			aTags.map(
				function (o, i) {
					return mCustomElements[aTags[i]];
				}
			)
		);
	}

	function initTags() {
		Lib.load({ name: "sap.ui.integration" })
			.then(function (oIntegrationLib) {
				//register the tags for this library
				registerLibraryTags(oIntegrationLib);
			});
	}

	boot();
})(window);