//@ui5-bundle sap/ui/integration/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/ActionDefinition", ["sap/m/library","sap/ui/core/Element"],function(e,t){"use strict";var i=e.ButtonType;var a=t.extend("sap.ui.integration.ActionDefinition",{metadata:{library:"sap.ui.integration",properties:{type:{type:"sap.ui.integration.CardActionType"},text:{type:"string",defaultValue:""},icon:{type:"sap.ui.core.URI"},buttonType:{type:"sap.m.ButtonType",defaultValue:i.Transparent},enabled:{type:"boolean",defaultValue:true},visible:{type:"boolean",defaultValue:true},parameters:{type:"object"},startsSection:{type:"boolean",defaultValue:false}},events:{press:{}},associations:{_menuItem:{type:"sap.m.MenuItem",multiple:false,visibility:"hidden"}},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true}}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/Designtime", ["sap/ui/base/ManagedObject"],function(t){"use strict";var e=t.extend("sap.ui.integration.Designtime",{metadata:{library:"sap.ui.integration"},constructor:function(e){t.apply(this);this.settings=e||this.create&&this.create()||{}}});e.prototype.init=function(){this._oCard=null};e.prototype.exit=function(){this._oCard=null};e.prototype.onCardReady=function(t,e){this._oCard=t;this._oInternalCardInstance=e};e.prototype._readyPromise=function(t,e){this.onCardReady(t,e);return Promise.resolve()};e.prototype.getCard=function(){return this._oCard};e.prototype.getSettings=function(){return this.settings};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/Extension", ["sap/ui/integration/library","sap/base/Log","sap/ui/base/ManagedObject","sap/base/util/fetch"],function(t,e,r,o){"use strict";var i=r.extend("sap.ui.integration.Extension",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]",deprecated:true},formatters:{type:"object"}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:"object"},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},formData:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}}}}});i.prototype.init=function(){this._oCardInterface=null;this._oCard=null};i.prototype.exit=function(){this._oCardInterface=null;this._oCard=null};i.prototype.setActions=function(t){this.setProperty("actions",t);if(this._oCard){this._oCard._refreshActionsMenu()}return this};i.prototype.setFormatters=function(t){this.setProperty("formatters",t);if(!this._oCard){return this}if(!this._oCard._bApplyManifest||this._oCard.getAggregation("_extension")!==this){e.error("Extension formatters must be set before the initialization of the card. Do this inside Extension#init().")}return this};i.prototype.onCardReady=function(){};i.prototype.loadDependencies=function(){return Promise.resolve()};i.prototype.getCard=function(){return this._oCardInterface};i.prototype.fetch=function(t,e,r){var i=this._oCard,n=this._oCard.getHostInstance();if(n){return n.fetch(t,e,r,i)}else{return o(t,e)}};i.prototype.overrideBlockingMessage=function(){return null};i.prototype._setCard=function(t,e){this._oCard=t;this._oCardInterface=e};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/Host", ["sap/ui/integration/library","sap/ui/core/Element","sap/ui/core/Supportability","sap/base/util/fetch"],function(e,t,r,o){"use strict";var i=t.extend("sap.ui.integration.Host",{metadata:{library:"sap.ui.integration",properties:{actions:{type:"sap.ui.integration.CardMenuAction[]"},resolveDestination:{type:"function",invalidate:false,parameters:{destinationName:{type:"string"},card:{type:"sap.ui.integration.widgets.Card"}}}},events:{action:{allowPreventDefault:true,parameters:{card:{type:"sap.ui.core.Control"},actionConfig:{type:"object"},actionSource:{type:"sap.ui.core.Control"},parameters:{type:"object"},formData:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},cardConfigurationChange:{parameters:{card:{type:"sap.ui.core.Control"},changes:{type:"object"}}},cardStateChanged:{parameters:{card:{type:"sap.ui.core.Control"}}},cardInitialized:{parameters:{card:{type:"sap.ui.core.Control"}}},message:{parameters:{data:{type:"object"}}}}}});i.prototype.init=function(){this._handlePostMessageBound=this._handlePostMessage.bind(this)};i.prototype.getDestination=function(e,t){var r=this.getResolveDestination(),o;if(typeof r!=="function"){return Promise.reject("Could not resolve destination '"+e+"'. There is no 'resolveDestination' callback function configured in the host.")}o=r(e,t);if(o===null||o===undefined){return Promise.reject("Destination '"+e+"' could not be resolved by the host.")}if(o instanceof Promise){return o}return Promise.resolve(o)};i.prototype.getCsrfToken=function(e){return Promise.resolve()};i.prototype.csrfTokenFetched=function(e,t){};i.prototype.csrfTokenExpired=function(e){};i.prototype.getContextValue=function(e){if(!e){return Promise.resolve(null)}return Promise.resolve(null)};i.prototype.getDestinations=function(){return Promise.resolve([])};i.prototype.getContexts=function(){return Promise.resolve({})};i.prototype.useExperimentalCaching=function(){this.bUseExperimentalCaching=true;this.subscribeForMessages()};i.prototype.stopUsingExperimentalCaching=function(){this.bUseExperimentalCaching=false;this.unsubscribeForMessages()};i.prototype.modifyRequestHeaders=function(e,t,r){return e};i.prototype.modifyRequest=function(e,t,r){return e};i.prototype.fetch=function(e,t,i,a){if(r.isStatisticsEnabled()){e=this._addStatisticsParameter(e)}if(this.bUseExperimentalCaching){this._addCacheHeaders(t.headers,i)}return o(e,t)};i.prototype.getAnalyticsCloudWidgetSrc=function(){};i.prototype._addStatisticsParameter=function(e){var t=new URL(e,window.location.href);t.searchParams.set("sap-statistics","true");return t.href};i.prototype._addCacheHeaders=function(e,t){var r=t.cache,o=[];if(r.enabled===false){o.push("max-age=0");o.push("no-store")}else{o.push("max-age="+parseInt(r.maxAge||0));if(r.staleWhileRevalidate){o.push("x-stale-while-revalidate")}}if(o.length){e.set("Cache-Control",o.join(", "))}e.set("x-sap-card","true");e.set("x-use-cryptocache","true")};i.prototype.subscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return}navigator.serviceWorker.addEventListener("message",this._handlePostMessageBound)};i.prototype.unsubscribeForMessages=function(){if(!navigator||!navigator.serviceWorker){return}navigator.serviceWorker.removeEventListener("message",this._handlePostMessageBound)};i.prototype._handlePostMessage=function(e){this.fireMessage({data:e.data})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/bindingFeatures/DateRange", ["sap/ui/core/date/UniversalDateUtils","sap/base/Log"],function(e,n){"use strict";var r={start:function(e,n){var r=this._getRange(e,n);if(!r){return null}return r[0]},end:function(e,n){var r=this._getRange(e,n);if(!r){return null}return r[1]},_getRange:function(r,t){var a=e.ranges[r];if(!a){n.error("The requested date range type '"+r+"' is not found","sap.ui.integration.widgets.Card");return null}return a(t)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AdaptiveContent", ["sap/base/i18n/Localization","sap/ui/core/Lib","sap/ui/integration/library","sap/ui/dom/includeScript","sap/ui/integration/cards/BaseContent","sap/ui/integration/cards/adaptivecards/elements/hostConfig","sap/m/VBox","sap/ui/core/HTML","sap/ui/model/json/JSONModel","sap/base/Log"],function(t,e,n,i,a,r,o,s,d,p){"use strict";var u,l,c,g,h,f,C,m,y,v;var _=n.CardMessageType;var b=a.extend("sap.ui.integration.cards.AdaptiveContent",{metadata:{library:"sap.ui.integration"},renderer:{apiVersion:2,render:function(t,e){var n=a.getMetadata().getRenderer();return n.render.apply(this,arguments)}}});b.prototype.init=function(){a.prototype.init.apply(this,arguments);this.awaitEvent("_adaptiveCardElementsReady");this.fireEvent("_actionContentReady");this.setComponentsReady(false);this._setupCardContent()};b.prototype.onAfterRendering=function(){this._renderMSCardContent(this._oCardTemplate||this.getConfiguration())};b.prototype.loadDependencies=function(t){var e=[this._loadWebcomponents()];e.push(new Promise(function(t,e){sap.ui.require(["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/thirdparty/adaptivecards-templating","sap/ui/integration/cards/adaptivecards/elements/UI5InputText","sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber","sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet","sap/ui/integration/cards/adaptivecards/elements/UI5InputTime","sap/ui/integration/cards/adaptivecards/elements/UI5InputDate","sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle","sap/ui/integration/cards/adaptivecards/overwrites/ActionRender"],function(e,n,i,a,r,o,s,d,p){u=e;l=n;g=i;h=a;f=r;C=o;m=s;y=d;v=p;this._setupAdaptiveCardDependency();t()}.bind(this),e)}.bind(this)));if(t.get("/sap.card/configuration/enableMarkdown")){e.push(new Promise(function(t,e){sap.ui.require(["sap/ui/integration/thirdparty/markdown-it"],function(e){c=e;t()},e)}))}return Promise.all(e)};b.prototype._setupCardContent=function(){var t=new s(this.getId()+"content",{preferDOM:false,content:"<div>&nbsp;</div>"});this.setAggregation("_content",new o({items:[t]}))};b.prototype.applyConfiguration=function(){var t=this.getConfiguration();if(t&&t.request&&t.request.url){this._loadManifestFromUrl(t.request.url);return}this._handleMarkDown();this._setupMSCardContent()};b.prototype.onThemeChanged=function(){if(this.getDomRef()&&u){this._adjustHostConfig();this.invalidate()}};b.prototype._handleMarkDown=function(){var t=this;u.AdaptiveCard.onProcessMarkdown=function(e,n){var i=t.getParent(),a=i&&i.getManifestEntry("/sap.card/configuration/enableMarkdown");if(a){n.outputHtml=(new c).render(e);n.didProcess=true;return n}}};b.prototype._loadManifestFromUrl=function(t){var e=new d,n=this;e.loadData(t).then(function(){n.setConfiguration(Object.assign(n.getConfiguration(),e.getData()))}).then(function(){n._handleMarkDown();n._setupMSCardContent()}).then(function(){e.destroy();e=null}).catch(function(){this.fireEvent("_dataReady");this.fireEvent("_adaptiveCardElementsReady");p.error("No JSON file found on this URL. Please provide a correct path to the JSON-serialized card object model file.")}.bind(this))};b.prototype._setupAdaptiveCardDependency=function(){this.adaptiveCardInstance=new u.AdaptiveCard;this._doMSCardsOverwrites();this._adjustHostConfig();this._handleActions();this._replaceElements();this._isRtl()};b.prototype._doMSCardsOverwrites=function(){u.Action.prototype.render=v};b.prototype._adjustHostConfig=function(){this.adaptiveCardInstance.hostConfig=new u.HostConfig(r())};b.prototype._isRtl=function(){this.adaptiveCardInstance.isRtl=function(){return t.getRTL()}};b.prototype._handleActions=function(){this.adaptiveCardInstance.onExecuteAction=function(t){var e,i,a;if(t instanceof u.OpenUrlAction){i={url:t.url};e=n.CardActionType.Navigation}else if(t instanceof u.SubmitAction){this.getModel("form").setProperty("/",t.data);e=n.CardActionType.Submit}else{return}a=this.getActions();if(a){a.fireAction(this,e,i)}}.bind(this)};b.prototype.onActionSubmitStart=function(t){this.getParent().setBusy(true)};b.prototype.onActionSubmitEnd=function(t,n){var i=e.getResourceBundleFor("sap.ui.integration"),a=n?i.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_ERROR"):i.getText("CARDS_ADAPTIVE_ACTION_SUBMIT_SUCCESS"),r=n?_.Error:_.Success;this.showMessage(a,r);this.getParent().setBusy(false)};b.prototype._replaceElements=function(){u.GlobalRegistry.elements.unregister("Input.Text");u.GlobalRegistry.elements.register("Input.Text",g);u.GlobalRegistry.elements.unregister("Input.Number");u.GlobalRegistry.elements.register("Input.Number",h);u.GlobalRegistry.elements.unregister("Input.ChoiceSet");u.GlobalRegistry.elements.register("Input.ChoiceSet",f);u.GlobalRegistry.elements.unregister("Input.Time");u.GlobalRegistry.elements.register("Input.Time",C);u.GlobalRegistry.elements.unregister("Input.Date");u.GlobalRegistry.elements.register("Input.Date",m);u.GlobalRegistry.elements.unregister("Input.Toggle");u.GlobalRegistry.elements.register("Input.Toggle",y)};b.prototype.setCardDataProvider=function(t){this._oCardDataProvider=t};b.prototype._setupMSCardContent=function(){var t=this.getConfiguration(),e,n=this._oCardDataProvider;if(!this.adaptiveCardInstance||!t){return}e=t.$data||t.data;if(!e&&!n){this._oCardTemplate=null;this._renderMSCardContent(t);this.fireEvent("_dataReady");return}if(t.$data){e={json:e}}this.setDataConfiguration(e)};b.prototype.onDataChanged=function(){var t=this.getBindingContext().getPath(),e=this.getModel().getProperty(t);this._oCardTemplate=this._setTemplating(this.getConfiguration(),e);this.invalidate()};b.prototype._renderMSCardContent=function(t){var e=this.getAggregation("_content").getItems()[0].$(),n=!!this.isLoading();this.setBusy(n);this.getAggregation("_content").toggleStyleClass("sapFCardContentHidden",n);if(this.adaptiveCardInstance&&t&&e.length){this.adaptiveCardInstance.parse(t);e.html(this.adaptiveCardInstance.render());this.fireEvent("_adaptiveCardElementsReady");if(this.adaptiveCardInstance.renderedElement){this.adaptiveCardInstance.renderedElement.tabIndex=-1}}};b.prototype._setTemplating=function(t,e){var n=new l.Template(t);return n.expand({$root:e})};b.prototype._loadWebcomponents=function(){if(this.getComponentsReady()){p.debug("WebComponents were already loaded");return Promise.resolve()}return new Promise(function(t,e){setTimeout(function(){if(window.customElements.get("ui5-button")){t();return}i({id:"webcomponents-bundle",attributes:{type:"module"},url:sap.ui.require.toUrl("sap/ui/integration/thirdparty/webcomponents/bundle.esm.js")}).then(t)})}).then(function(){this.setComponentsReady(true)}.bind(this))};b.prototype.setComponentsReady=function(t){this._bComponentsReady=t;return this};b.prototype.getComponentsReady=function(){return!!this._bComponentsReady};return b});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AnalyticalContent", ["./AnalyticalContentRenderer","./BaseContent","sap/f/cards/loading/AnalyticalPlaceholder","sap/m/IllustratedMessageType","sap/ui/core/Lib","sap/ui/integration/library","sap/ui/integration/util/BindingResolver","sap/base/Log","sap/base/util/merge"],function(t,e,a,i,n,o,r,s,p){"use strict";var l=o.CardActionArea;var c,u,d,g,h,v;var f={Top:"top",Bottom:"bottom",Left:"left",Right:"right"};var y={TopLeft:"topLeft",Center:"center"};var m={Left:"left",Center:"center",Right:"right"};var _={Line:"line",StackedColumn:"stacked_column",StackedBar:"stacked_bar",Donut:"donut"};var A={Chart:"Chart",Full:"Full"};var C=e.extend("sap.ui.integration.cards.AnalyticalContent",{metadata:{library:"sap.ui.integration"},renderer:t});C.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oPopover){this._oPopover.destroy()}};C.prototype.applyConfiguration=function(){var t=this.getParsedConfiguration();if(!t){return}this._createChart()};C.prototype.createLoadingPlaceholder=function(e){return new a({chartType:e.chartType,minHeight:this.getOverflowWithShowMore()?0:t.getMinHeight(e)})};C.prototype.loadDependencies=function(t){return new Promise(function(t,e){n.load("sap.viz").then(function(){sap.ui.require(["sap/viz/ui5/controls/VizFrame","sap/viz/ui5/controls/common/feeds/FeedItem","sap/viz/ui5/controls/Popover","sap/viz/ui5/data/FlattenedDataset","sap/viz/ui5/data/MeasureDefinition","sap/viz/ui5/data/DimensionDefinition"],function(e,a,i,n,o,r){c=e;u=a;g=i;d=n;h=o;v=r;t()},function(t){e(t)})}).catch(function(){e("Analytical content type is not available with this distribution.")})})};C.prototype.onDataChanged=function(){this._updateChart();var t=this.getAggregation("_content");if(t){var e=t._getVizDataset(),a=e&&e._FlatTableD&&e._FlatTableD._data&&Array.isArray(e._FlatTableD._data)&&e._FlatTableD._data.length;if(a){this.hideNoDataMessage()}else{this.showNoDataMessage({illustrationType:i.NoEntries,title:this.getCardInstance().getTranslatedText("CARD_NO_ITEMS_ERROR_LISTS")})}}};C.prototype._createChart=function(){var t=this.getParsedConfiguration();if(!t.chartType){s.error('"sap.card".content.chartType is mandatory property.',null,"sap.ui.integration.widgets.Card");return}var e=r.resolveValue(t,this,"/");var a=new c({uiConfig:{applicationSet:"fiori"},height:"100%",width:"100%",vizType:_[e.chartType]||e.chartType});this.setAggregation("_content",a);this._attachActions(t);if(e.popover&&e.popover.active){this._attachPopover()}};C.prototype._supportsOverflow=function(){return false};C.prototype._updateChart=function(){var t=this.getParsedConfiguration();var e=this.getAggregation("_content");var a=r.resolveValue(t,this,"/");if(!e){return}e.destroyDataset().destroyFeeds();e.applySettings({vizProperties:this._getVizProperties(a),dataset:this._getDataset(t,a),feeds:this._getFeeds(a),vizType:_[a.chartType]||a.chartType})};C.prototype._attachActions=function(t){var e={area:l.Content,actions:t.actions,control:this};if(t.actionableArea===A.Chart){e.eventName="selectData";e.actionControl=this.getAggregation("_content");this._oActions.setBindingPathResolver(t=>{const e=this._getContextPath(t);return e})}else{e.eventName="press"}this._oActions.attach(e)};C.prototype._attachPopover=function(){if(this._oPopover){this._oPopover.destroy()}this._oPopover=new g;this._oPopover.connect(this.getAggregation("_content").getVizUid());const t=this.getParsedConfiguration();const e=t.popover.actionsStrip;if(e&&e[0]?.actions?.length){const t=e[0];const a=this.getAggregation("_content");a.attachSelectData(e=>{const i=this._getContextPath(e);const n=r.resolveValue(t,this,i);this._oPopover.setActionItems([{type:"action",text:n.text,press:()=>{this._oActions.fireAction(a,n.actions[0].type,n.actions[0].parameters)}}])})}};C.prototype._getVizProperties=function(t){if(!t){return null}var e=t.title,a=t.legend,i=t.plotArea;var n={title:{style:{fontWeight:"normal"},layout:{respectPlotPosition:false}},legend:{},legendGroup:{layout:{}},plotArea:{window:{start:"firstDataPoint",end:"lastDataPoint"}},categoryAxis:{title:{}},valueAxis:{title:{}},interaction:{noninteractiveMode:true}};if(t.actions||t.popover){var o=t.actionableArea===A.Chart||t.popover&&t.popover.active;n.interaction.noninteractiveMode=!o}if(e){n.title.text=e.text;n.title.visible=e.visible;n.title.alignment=m[e.alignment];s.warning('"sap.card".content.title is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}if(a){n.legend.visible=a.visible;n.legendGroup.layout.position=f[a.position];n.legendGroup.layout.alignment=y[a.alignment];s.warning('"sap.card".content.legend is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}if(i){if(i.dataLabel){n.plotArea.dataLabel=i.dataLabel}if(i.categoryAxisText){n.categoryAxis.title.visible=i.categoryAxisText.visible}if(i.valueAxisText){n.valueAxis.title.visible=i.valueAxisText.visible}s.warning('"sap.card".content.plotArea is deprecated. Use "sap.card".content.chartProperties instead',null,"sap.ui.integration.widgets.Card")}p(n,t.chartProperties);return n};C.prototype._getDataset=function(t,e){var a,i;if(t.dimensions){i=t.dimensions.map(function(t,a){return new v({name:e.dimensions[a].name||e.dimensions[a].label,value:t.value,displayValue:t.displayValue,dataType:t.dataType})})}if(t.measures){a=t.measures.map(function(t,a){return new h({name:e.measures[a].name||e.measures[a].label,value:t.value})})}return new d({measures:a,dimensions:i,data:{path:this.getBindingContext().getPath()}})};C.prototype._getFeeds=function(t){var e=t.feeds;if(t.measureAxis||t.dimensionAxis){s.warning('"sap.card".content.measureAxis and "sap.card".content.dimensionAxis are deprecated. Use "sap.card".content.feeds instead',null,"sap.ui.integration.widgets.Card");e=[{uid:t.measureAxis,type:"Measure",values:t.measures.map(function(t){return t.label})},{uid:t.dimensionAxis,type:"Dimension",values:t.dimensions.map(function(t){return t.label})}]}return e.map(function(t){return new u(t)})};C.prototype._getContextPath=function(t){const e=t.getParameter("data")[0].data._context_row_number;const a=this.getBindingContext().getPath();return a!=="/"?a+"/"+e:a+e};C.prototype.getFocusDomRef=function(){return this.getAggregation("_content").getDomRef().querySelector(".v-info")||this.getDomRef()};return C});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AnalyticalContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var n=e.extend("sap.ui.integration.cards.AnalyticalContentRenderer",{apiVersion:2,MIN_ANALYTICAL_CONTENT_HEIGHT:"14rem"});n.getMinHeight=function(e,t){if(e.minHeight){return e.minHeight}return n.MIN_ANALYTICAL_CONTENT_HEIGHT};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AnalyticsCloudContent", ["./AnalyticsCloudContentRenderer","./BaseContent","sap/ui/core/HTML","sap/ui/integration/util/BindingResolver","sap/m/IllustratedMessageType","sap/base/Log","sap/base/util/deepClone","sap/ui/integration/util/AnalyticsCloudHelper"],function(t,e,n,i,o,s,r,a){"use strict";var d=e.extend("sap.ui.integration.cards.AnalyticsCloudContent",{metadata:{library:"sap.ui.integration"},renderer:t});d.prototype.init=function(){e.prototype.init.apply(this,arguments);var t=this.getId()+"-widgetContainer";this._oWidgetContainer=new n(t,{content:"<div id="+t+" class='sapUiIntAnalyticsCloudContentContainer'></div>"});this.setAggregation("_content",this._oWidgetContainer)};d.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oWidgetContainer){this._oWidgetContainer.destroy();this._oWidgetContainer=null}};d.prototype.loadDependencies=function(t){return a.loadWidget(this.getCardInstance()?.getHostInstance())};d.prototype.applyConfiguration=function(){this.fireEvent("_actionContentReady")};d.prototype.getStaticConfiguration=function(){return this._getResolvedConfiguration()};d.prototype.onAfterRendering=function(){if(this.getAggregation("_blockingMessage")){return}this._renderWidget()};d.prototype._supportsOverflow=function(){return false};d.prototype._renderWidget=function(){if(this._bIsBeingDestroyed){return}const t=this.getCardInstance();if(!t.isReady()){t.attachEventOnce("_ready",()=>{this.invalidate()});return}if(!sap?.sac?.api?.widget){this._showError("Object sap.sac.api.widget not found on the page.");return}const e=this._getResolvedConfiguration();if(!e.sacTenantDestination){this._showError("Required configuration /sap.card/content/sacTenantDestination was not found or is empty.");return}const n=this._oWidgetContainer.getId();const i=e?.widget;const o=e?.interpretation;const s=this._getOptions(e);if(i){sap.sac.api.widget.renderWidget(n,{proxy:e.sacTenantDestination},i.storyId,i.widgetId,s)}else if(o){sap.sac.api.widget.renderWidgetForJustAsk(n,{proxy:e.sacTenantDestination},o,s)}else{this._showError("Required configuration /sap.card/content/widget or /sap.card/content/interpretation was not found or is empty.")}};d.prototype._getResolvedConfiguration=function(){return i.resolveValue(this.getParsedConfiguration(),this,this.getBindingContext()?.getPath()||"/")};d.prototype._getOptions=function(t){const e=r(t.options)||{};const n={enableInteraction:false,enableUndoRedo:false,enableMenus:false,showHeader:false,showFooter:false};e.attributes=Object.assign({},n,e.attributes);e.renderComplete={onSuccess:this._onWidgetSuccess.bind(this),onFailure:this._onWidgetFailure.bind(this)};return e};d.prototype._onWidgetSuccess=function(){const t=this._getResolvedConfiguration()?.widget?.widgetId||"interpretation";s.info(`Widget rendered successfully: ${t}`,this);this._updateWidgetInfo()};d.prototype._onWidgetFailure=function(t){const e=this._getResolvedConfiguration()?.widget;const n=e?.storyId||"interpretation";const i=e?.widgetId||"interpretation";let o=`There was a failure in sap.sac.api.widget.renderWidget with storyId ${n} and widgetId ${i}.`;if(t instanceof Error){o+=" "+t.toString();s.error(t.stack)}else if(typeof t==="object"){o+=" "+JSON.stringify(t)}else if(t){o+=" "+t}s.error(o,this);this._updateWidgetInfo()};d.prototype._updateWidgetInfo=async function(){const t=this.getCardInstance();const e=this._oWidgetContainer.getId();let n={};try{n=await sap.sac.api.widget.getWidgetInfo(e)}catch(t){s.error("Call to sap.sac.api.widget.getWidgetInfo failed.",this)}t.getModel("widgetInfo").setData(n);t.scheduleFireStateChanged()};d.prototype._showError=function(t){const e=this.getCardInstance();s.error(t,this);this.handleError({illustrationType:o.ErrorScreen,title:e.getTranslatedText("CARD_ERROR_ANALYTICS_CLOUD_TITLE"),description:e.getTranslatedText("CARD_ERROR_ANALYTICS_CLOUD_DESCRIPTION")})};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/AnalyticsCloudContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var n=e.extend("sap.ui.integration.cards.AnalyticsCloudContentRenderer",{apiVersion:2,MIN_ANALYTICS_CLOUD_CONTENT_HEIGHT:"14rem"});n.getMinHeight=function(e,t){if(e.minHeight){return e.minHeight}return n.MIN_ANALYTICS_CLOUD_CONTENT_HEIGHT};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/BaseContent", ["./BaseContentRenderer","sap/f/cards/loading/GenericPlaceholder","sap/m/MessageStrip","sap/m/VBox","sap/m/library","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/InvisibleMessage","sap/ui/core/library","sap/ui/integration/controls/BlockingMessage","sap/ui/integration/model/ObservableModel","sap/ui/base/ManagedObjectObserver","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/delegate/OverflowHandler","sap/base/util/merge","sap/ui/integration/library","sap/ui/core/message/MessageType"],function(t,e,i,n,a,o,s,r,d,g,h,l,p,c,u,f,y,v,_,C,m){"use strict";const D=h.InvisibleMessageMode;const P=C.CardDesign;const b=C.CardBlockingMessageType;const M=C.CardMessageType;const A=C.CardPreviewMode;var w=r.extend("sap.ui.integration.cards.BaseContent",{metadata:{library:"sap.ui.integration",properties:{design:{type:"sap.ui.integration.CardDesign",group:"Appearance",defaultValue:P.Solid},configuration:{type:"object"},noDataConfiguration:{type:"object"},overflowWithShowMore:{type:"boolean",defaultValue:false}},aggregations:{_content:{multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_loadingPlaceholder:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_messageContainer:{type:"sap.m.VBox",multiple:false,visibility:"hidden"},_blockingMessage:{type:"sap.ui.integration.controls.BlockingMessage",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{press:{parameters:{originalEvent:{type:"object"}}},ready:{}}},renderer:t});w.prototype.init=function(){this._oAwaitedEvents=new Set;this._bReady=false;this._mObservers={};this.setAggregation("_loadingProvider",new u);this.awaitEvent("_dataReady");this.awaitEvent("_actionContentReady")};w.prototype.onBeforeRendering=function(){const t=this.getCardInstance();if(!t){return}const e=this.getParsedConfiguration();let i=this.getAggregation("_loadingPlaceholder");if(!i&&e){this.setAggregation("_loadingPlaceholder",this.createLoadingPlaceholder(e));i=this.getAggregation("_loadingPlaceholder")}if(i){i.setRenderTooltip(t.getPreviewMode()!==A.Abstract);if(typeof this._getTable==="function"){i.setHasContent(this._getTable().getColumns().length>0)}}if(!this._oOverflowHandler&&this.getOverflowWithShowMore()&&this._supportsOverflow()){this._oOverflowHandler=new v(this);this._oOverflowHandler.attach()}};w.prototype.ontap=function(t){if(!t.isMarked()){this.firePress({originalEvent:t})}};w.prototype.exit=function(){this.hideLoadingPlaceholders();this._oAwaitedEvents=null;if(this._mObservers){Object.keys(this._mObservers).forEach(function(t){this._mObservers[t].disconnect();delete this._mObservers[t]},this)}this._oServiceManager=null;this._oDataProviderFactory=null;this._oIconFormatter=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}this._sContentBindingPath=null;if(this._oOverflowHandler){this._oOverflowHandler.destroy();this._oOverflowHandler=null}};w.prototype.createLoadingPlaceholder=function(t){return new e};w.prototype.loadDependencies=function(t){return Promise.resolve()};w.prototype.applyConfiguration=function(){};w.prototype.setLoadDependenciesPromise=function(t){this._pLoadDependencies=t;this.awaitEvent("_loadDependencies");this._pLoadDependencies.then(function(){this.fireEvent("_loadDependencies")}.bind(this))};w.prototype.getLoadDependenciesPromise=function(){return this._pLoadDependencies};w.prototype.getActions=function(){return this._oActions};w.prototype.setActions=function(t){this._oActions=t};w.prototype.awaitEvent=function(t){if(this._oAwaitedEvents.has(t)){return}this._bReady=false;this._oAwaitedEvents.add(t);this.showLoadingPlaceholders(true);this.attachEventOnce(t,function(){this._oAwaitedEvents.delete(t);if(this._oAwaitedEvents.size===0){this._bReady=true;this.hideLoadingPlaceholders();this.fireReady()}}.bind(this))};w.prototype._supportsOverflow=function(){return true};w.prototype._forceCompleteAwaitedEvents=function(){this._oAwaitedEvents.forEach(function(t){this.fireEvent(t)}.bind(this))};w.prototype.getParsedConfiguration=function(){var t=_({},this.getConfiguration()),e=t.data;delete t.data;t=f.createBindingInfos(t,this.getCardInstance().getBindingNamespaces());if(e){t.data=e}return t};w.prototype.getStaticConfiguration=function(){return this.getConfiguration()};w.prototype.showMessage=function(t,e,n){const a=this._getMessageContainer();this.hideMessage();if(e===M.Loading){n=false;this.addStyleClass("sapFCardBaseContentHasMessageLoading");this.setBusyIndicatorDelay(0);this.setBusy(true)}if(e===M.Toast){n=n??true}const o=e===M.Loading||e===M.Toast;const s=new i({text:f.createBindingInfos(t,this.getCardInstance().getBindingNamespaces()),type:o?m.Information:e,showCloseButton:true,showIcon:e===M.Loading?false:true,close:function(){this.hideMessage()}.bind(this)});s.addStyleClass("sapFCardContentMessage");s.addStyleClass("sapFCardContentMessage"+e);const r=t=>{s.addStyleClass(t.animationName+"Finished")};s.addEventDelegate({onBeforeRendering:()=>{const t=s.getDomRef();t?.removeEventListener("animationend",r);t?.removeEventListener("animationcancel",r)},onAfterRendering:()=>{const t=s.getDomRef();t.addEventListener("animationend",r);t.addEventListener("animationcancel",r)}});a.addItem(s);if(n){const e=t?Math.max(t.split(" ").length*250,3e3):3e3;setTimeout(()=>{s.close()},e+400);setTimeout(()=>{s.addStyleClass("sapFCardContentMessageClosing")},e)}const d=this.getDomRef();if(d&&d.contains(document.activeElement)){g.getInstance().announce(t,D.Assertive)}else{g.getInstance().announce(t,D.Polite)}};w.prototype.hideMessage=function(){var t=this._getMessageContainer();t.destroyItems();if(this.hasStyleClass("sapFCardBaseContentHasMessageLoading")){this.removeStyleClass("sapFCardBaseContentHasMessageLoading");this.setBusy(false)}};w.prototype.showBlockingMessage=function(t){this.destroyAggregation("_blockingMessage");this.setAggregation("_blockingMessage",l.create(t,this.getCardInstance()));this._forceCompleteAwaitedEvents()};w.prototype.hideBlockingMessage=function(){this.destroyAggregation("_blockingMessage")};w.prototype.getBlockingMessage=function(){var t=this.getAggregation("_blockingMessage");if(t){return{type:t.getType(),illustrationType:t.getIllustrationType(),illustrationSize:t.getIllustrationSize(),title:t.getTitle(),description:t.getDescription(),imageSrc:t.getImageSrc(),httpResponse:t.getHttpResponse(),additionalContent:t.getAdditionalContent()}}return null};w.prototype.getBlockingMessageStaticConfiguration=function(){return this.getAggregation("_blockingMessage")?.getStaticConfiguration()};w.prototype.showNoDataMessage=function(t){var e=this.getNoDataConfiguration()||{};e=y.resolveValue(e,this.getCardInstance());var i={type:b.NoData,illustrationType:o[e.type]||e.type||t.illustrationType,illustrationSize:s[e.size]||t.illustrationSize,title:e.title||t.title,description:e.description||t.description};this.showBlockingMessage(i)};w.prototype.hideNoDataMessage=function(){this.hideBlockingMessage()};w.prototype.setDataConfiguration=function(t){var e=this.getCardInstance(),i;if(!t){this._sContentBindingPath=null;this.fireEvent("_dataReady");return}this._sContentBindingPath=y.resolveValue(t.path||"/",this.getCardInstance());this.bindObject(this._sContentBindingPath);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t.name){i=e.getModel(t.name)}else if(this._oDataProvider){i=new p;i.setSizeLimit(e.getModelSizeLimit());this.setModel(i)}if(!i){this.fireEvent("_dataReady");return}i.attachEvent("change",function(){this.getLoadDependenciesPromise().then(function(t){if(t&&!this.isDestroyed()){this.onDataChanged();this.onDataRequestComplete()}}.bind(this))}.bind(this));if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.onDataRequested()}.bind(this));this._oDataProvider.attachDataChanged(function(t){var e=t.getParameter("data");this.getLoadDependenciesPromise().then(function(t){if(t&&!this.isDestroyed()){this.setModelData(e,i)}}.bind(this))}.bind(this));this._oDataProvider.attachError(function(t){this.handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getResolvedConfiguration()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};w.prototype.onDataRequested=function(){this.awaitEvent("_dataReady")};w.prototype.onDataRequestComplete=function(){var t=this.getCardInstance();this.fireEvent("_dataReady");if(t){t._fireContentDataChange()}};w.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};w.prototype.showLoadingPlaceholders=function(t){if(!t&&this._isDataProviderJson()){return}var e=this.getAggregation("_loadingProvider"),i=this.getCardInstance();e.setLoading(true);if(i){i.addActiveLoadingProvider(e)}};w.prototype.hideLoadingPlaceholders=function(){var t=this.getAggregation("_loadingProvider"),e=this.getCardInstance();if(!t.getLoading()){return}t.setLoading(false);if(e){e.removeActiveLoadingProvider(t)}};w.prototype.onDataChanged=function(){};w.prototype.onCardDataChanged=function(){this.getLoadDependenciesPromise().then(function(t){if(t&&!this.isDestroyed()){this.onDataChanged()}}.bind(this))};w.prototype.setModelData=function(t,e){e.setData(t)};w.prototype._bindAggregationToControl=function(t,e,i){var n;if(!i){return}if(!i.path){i.path=this._sContentBindingPath}if(!i.path){n=this.getCardInstance().getBindingContext();i.path=n&&n.getPath()}if(!i.path){return}this._observeAggregation(t,e);e.bindAggregation(t,i)};w.prototype._observeAggregation=function(t,e){var i=this.getCardInstance().getModel("parameters"),n;if(this._mObservers[t]){return}n=new c(function(n){var a;if(n.name!==t){return}if(!(n.mutation==="insert"||n.mutation==="remove")){return}a=e.getMetadata().getAggregation(t).get(e);var o=a.length;a.forEach(function(t){if(t.isA("sap.m.GroupHeaderListItem")){o-=1}});i.setProperty("/visibleItems",o)});i.setProperty("/visibleItems",0);n.observe(e,{aggregations:[t]});this._mObservers[t]=n};w.prototype.isReady=function(){return this._bReady};w.prototype.handleError=function(t){this.fireEvent("_error",{errorInfo:t})};w.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};w.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};w.prototype.setIconFormatter=function(t){this._oIconFormatter=t;return this};w.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};w.prototype.attachPress=function(){var t=Array.prototype.slice.apply(arguments);t.unshift("press");r.prototype.attachEvent.apply(this,t);this.invalidate();return this};w.prototype.detachPress=function(){var t=Array.prototype.slice.apply(arguments);t.unshift("press");r.prototype.detachEvent.apply(this,t);this.invalidate();return this};w.prototype.onActionSubmitStart=function(t){};w.prototype.onActionSubmitEnd=function(t,e){};w.prototype.validateControls=function(t,e){};w.prototype.getCardInstance=function(){return d.getElementById(this.getCard())};w.prototype.isSkeleton=function(){var t=this.getCardInstance();return t&&t.isSkeleton()};w.prototype.getDataLength=function(){return 0};w.prototype._getMessageContainer=function(){var t=this.getAggregation("_messageContainer");if(!t){t=new n({renderType:a.FlexRendertype.Bare,alignItems:a.FlexAlignItems.Center}).addStyleClass("sapFCardContentMessageContainer");this.setAggregation("_messageContainer",t)}return t};w.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};w.prototype.getHeaderTitleId=function(){var t=this.getCardInstance();if(!t){return undefined}return t.getId()+"-header-title"};w.prototype.isInteractive=function(){return this.hasListeners("press")};return w});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/BaseContentRenderer", ["sap/ui/core/Renderer","sap/ui/integration/library"],function(e,t){"use strict";var n=t.CardPreviewMode;var r=e.extend("sap.ui.integration.cards.BaseContentRenderer",{apiVersion:2});r.DEFAULT_MIN_HEIGHT="5rem";r.render=function(e,t){var n="sapFCard",r=t.getMetadata().getName(),a=r.slice(r.lastIndexOf(".")+1),i=t.getCardInstance(),o=t.getAggregation("_messageContainer"),s=t.getAggregation("_blockingMessage");n+=a;e.openStart("div",t).class(n).class("sapFCardBaseContent");if(t.isInteractive()){e.class("sapFCardSectionClickable")}if(i&&i.getHeight()==="auto"&&!t.getOverflowWithShowMore()){var g=this.getMinHeight(t.getParsedConfiguration(),t,i);e.style("min-height",g)}this.renderLoadingClass(e,t);e.openEnd();this.renderLoadingPlaceholder(e,t);if(o){e.renderControl(o)}if(s){e.renderControl(s)}else{this.renderContent(e,t)}e.close("div")};r.renderContent=function(e,t){e.renderControl(t.getAggregation("_content"))};r.renderLoadingClass=function(e,t){const r=t.getCardInstance();const a=r&&r.getPreviewMode()===n.Abstract;if(t.isLoading()||a){e.class("sapFCardContentLoading")}};r.renderLoadingPlaceholder=function(e,t){const r=t.getCardInstance();const a=r&&r.getPreviewMode()===n.Abstract;if(t.isLoading()||a){e.renderControl(t.getAggregation("_loadingPlaceholder"))}};r.getMinHeight=function(e,t){return this.DEFAULT_MIN_HEIGHT};r.isCompact=function(e){var t=e,n=e.getParent();if(!e.getDomRef()&&n&&n.isA("sap.f.ICard")){t=n}return t.getDomRef()?.closest(".sapUiSizeCompact")?.classList.contains("sapUiSizeCompact")};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/BaseListContent", ["./BaseContent","./BaseListContentRenderer","sap/ui/integration/util/BindingResolver","sap/m/IllustratedMessageType","sap/ui/integration/library","sap/base/Log"],function(t,e,i,n,o,s){"use strict";var a=t.extend("sap.ui.integration.cards.BaseListContent",{metadata:{library:"sap.ui.integration"},renderer:e});a.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oAwaitingPromise=null;this._fMinHeight=0};a.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oAwaitingPromise=null};a.prototype.onAfterRendering=function(){if(this.isReady()&&this.getCardInstance()?.isReady()){this._keepHeight()}};a.prototype.onDataChanged=function(){if(this.hasData()){this.hideNoDataMessage()}else{this.showNoDataMessage({illustrationType:n.NoEntries,title:this.getCardInstance().getTranslatedText("CARD_NO_ITEMS_ERROR_LISTS")})}this.getPaginator()?.onDataChanged(this)};a.prototype.setModelData=function(e,i){const n=this.getPaginator();if(n?.isLoadingMore()){n.setModelData(e,i)}else{t.prototype.setModelData.apply(this,arguments)}};a.prototype._keepHeight=function(){if(!this.getDomRef()){return}const t=this.getDomRef().getBoundingClientRect().height;if(t>this._fMinHeight){this._fMinHeight=t}const e=this.getCardInstance()?.getDomRef("contentSection");const i=e?.getBoundingClientRect().height;if(i&&this._fMinHeight>i){this._fMinHeight=i}if(this._fMinHeight){this.getDomRef().style.minHeight=this._fMinHeight+"px"}this._keepPlaceholderMinItems()};a.prototype._keepPlaceholderMinItems=function(){var t=this.getAggregation("_loadingPlaceholder"),e=!!this.getAggregation("_content"),i,n;if(!t||!t.getMinItems||!e){return}i=this.getItemsLength();n=Math.max(t.getMinItems(),i);t.setMinItems(n)};a.prototype.applyConfiguration=function(){const t=this.getParsedConfiguration();const e=this.getInnerList();if(!t||!e){return}this._fMinHeight=0;const n=this.getPaginator();if(n?.getActive()){return}let o=i.resolveValue(t.maxItems,this);o=parseInt(o);if(n&&(Number.isNaN(o)||!o)){o=n.getPageSize()}if(o){e.applySettings({growing:true,growingThreshold:o});e.addStyleClass("sapFCardMaxItems")}};a.prototype.getInnerList=function(){return null};a.prototype.getItemsLength=function(){return 0};a.prototype.setPaginator=function(t){this._oPaginator=t};a.prototype.getPaginator=function(){return this._oPaginator};a.prototype._checkHiddenNavigationItems=function(t){if(!t.actions){return}if(!this.getInnerList()){return}var e=this.getInnerList(),n=this.isA("sap.ui.integration.cards.TimelineContent")?e.getContent():e.getItems(),o=[],a=t.actions[0],r,g=0;if(!a||!a.service||a.type!=="Navigation"){return}if(a.service==="object"){r=a.service.name}else{r=a.service}n.forEach(function(t){var e=i.resolveValue(a.parameters,this,t.getBindingContext().getPath());o.push(this._oServiceManager.getService(r).then(function(t){if(!t.hidden){return false}return t.hidden({parameters:e})}).then(function(e){t.setVisible(!e);if(!e){g++}}).catch(function(t){s.error(t)}))}.bind(this));this.awaitEvent("_filterNavItemsReady");var h=this._oAwaitingPromise=Promise.all(o).then(function(){if(this._oAwaitingPromise===h){if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",g)}this.fireEvent("_filterNavItemsReady")}}.bind(this))};a.prototype.hasData=function(){var t=this.getInnerList(),e=t.getBinding(t.getMetadata().getDefaultAggregationName()),i=e.getModel(),n=e.getPath(),o=i.getProperty(n);if(o&&o.length){return true}return false};a.prototype.getDataLength=function(){var t=this.getModel().getProperty(this.getInnerList().getBindingContext().getPath());if(Array.isArray(t)){return t.length}return Object.getOwnPropertyNames(t).length};a.prototype.ontap=function(t){t.stopPropagation()};a.prototype.onsapenter=function(t){t.stopPropagation()};a.prototype.onsapspace=function(t){t.stopPropagation()};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/BaseListContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var n=e.extend("sap.ui.integration.cards.BaseListContentRenderer",{apiVersion:2});n.renderContent=function(e,n){e.renderControl(n.getAggregation("_content"));n.getPaginator()?.render(e)};n.renderLoadingClass=function(n,r){if(r.getPaginator()?.isLoadingMore()){return}e.renderLoadingClass(n,r)};n.renderLoadingPlaceholder=function(n,r){if(r.getPaginator()?.isLoadingMore()){return}e.renderLoadingPlaceholder(n,r)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/CalendarContent", ["./CalendarContentRenderer","sap/base/i18n/Formatting","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/integration/library","sap/ui/integration/cards/BaseContent","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/f/cards/loading/CalendarPlaceholder","sap/f/CalendarAppointmentInCard","sap/f/CalendarInCard","sap/f/PlanningCalendarInCardLegend","sap/m/library","sap/m/Button","sap/m/FlexBox","sap/ui/core/format/DateFormat","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/unified/calendar/CalendarDate","sap/ui/unified/calendar/CalendarUtils","sap/ui/unified/DateTypeRange","sap/ui/core/date/UniversalDate","sap/ui/unified/CalendarLegendItem","sap/ui/core/date/UI5Date","sap/ui/unified/DateRange"],function(t,e,a,i,n,s,o,r,l,p,d,g,m,h,c,u,f,D,_,I,C,y,S,A,b,v,T){"use strict";var L=n.CardActionArea;var M=s.extend("sap.ui.integration.cards.CalendarContent",{renderer:t,metadata:{library:"sap.ui.integration",properties:{visibleAppointmentsCount:{type:"int",group:"Data",defaultValue:2},noAppointmentsText:{type:"string",group:"Misc",defaultValue:null},use12HourFormat:{type:"boolean",defaultValue:false}},aggregations:{appointments:{type:"sap.f.CalendarAppointmentInCard",multiple:true,singularName:"appointment"}}}});M.prototype.changeMonth=function(t){var e=this._oCalendar,a=this._oCalendar.getSelectedDates()[0],i,n;i=a.getStartDate().getFullYear();n=new Date(i,t,1);e.focusDate(n);this.invalidate();this.getCardInstance().scheduleFireStateChanged()};M.prototype.changeDate=function(t){var e=this.getActions(),a=new T,i=this._oCalendar;a.setStartDate(t);i.destroySelectedDates();i.addAggregation("selectedDates",a);this._oFocusedDate=i.getSelectedDates()[0]?i.getSelectedDates()[0]:null;this.changeMonth(t.getMonth());e.fireAction(this,"DateChange",{selectedDate:t})};M.prototype._createCardContent=function(){this._oCalendar=new d(this.getId()+"-navigation",{startDateChange:function(t){var e=t.getSource()._getFocusedDate().toLocalJSDate();this._handleStartDateChange(e)}.bind(this),select:function(t){var e=t.getSource().getSelectedDates()[0].getStartDate();this._setParameters(t,t.getParameter("startDate"));this._refreshVisibleAppointments(e);this.invalidate();this._handleSelect(e)}.bind(this)});this._oLegend=new g(this.getId()+"-legend",{columnWidth:"7.5rem",standardItems:[]});this._oCalendar.setLegend(this._oLegend);this._oContent=new c(this.getId()+"-wrapper",{items:[this._oCalendar,this._oLegend]});this.setAggregation("_content",this._oContent);this._oFormatAria=u.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' "+P.call(this).getTimePattern("medium")})};M.prototype.init=function(){this._aVisibleAppointments=[];s.prototype.init.apply(this,arguments);this._createCardContent()};M.prototype.exit=function(){if(this._sTwoColumnsResizeListener){i.deregister(this._sTwoColumnsResizeListener);this._sTwoColumnsResizeListener=undefined}s.prototype.exit.apply(this,arguments);if(this._oAppointmentTemplate){this._oAppointmentTemplate.destroy();this._oAppointmentTemplate=null}if(this._oSpecialDateTemplate){this._oSpecialDateTemplate.destroy();this._oSpecialDateTemplate=null}if(this._oCalendarLegendItemTemplate){this._oCalendarLegendItemTemplate.destroy();this._oCalendarLegendItemTemplate=null}if(this._oAppointmentLegendItemTemplate){this._oAppointmentLegendItemTemplate.destroy();this._oAppointmentLegendItemTemplate=null}if(this._bDataInitiallyLoaded){this._bDataInitiallyLoaded=null}};M.prototype.onDataChanged=function(){var t=this._oCalendar.getSelectedDates()[0]&&this._oCalendar.getSelectedDates()[0].getStartDate();if(!t){return}if(!this._bDataInitiallyLoaded){this._handleSelect(t);this._handleStartDateChange(t);this._bDataInitiallyLoaded=true}this._setParameters();this._refreshVisibleAppointments(t);this.invalidate()};M.prototype.onBeforeRendering=function(){s.prototype.onBeforeRendering.apply(this,arguments);var t=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();this._setParameters();this._refreshVisibleAppointments(t);this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems)};M.prototype.onAfterRendering=function(){s.prototype.onAfterRendering.call(this,arguments);if(!this._sTwoColumnsResizeListener){this._sTwoColumnsResizeListener=i.register(this,this.resizeHandler);this.resizeHandler({control:this,target:this.getDomRef()})}};M.prototype.resizeHandler=function(t){t.control.toggleStyleClass("sapMPCInCardTwoColumns",t.target.getBoundingClientRect().width>576)};M.prototype.createLoadingPlaceholder=function(t){var e=this.getCardInstance(),a=e.getContentMinItems(t);return new l({minItems:a!==null?a:2,maxLegendItems:t.maxLegendItems?parseInt(t.maxLegendItems):2,item:t.item?t.item.template:{},legendItem:t.legendItem?t.legendItem.template:{}})};M.prototype.applyConfiguration=function(){var t=this.getParsedConfiguration();this.fireEvent("_actionContentReady");if(!t){return}if(t.item){this._addItem(t.item)}if(t.specialDate){this._addSpecialDate(t.specialDate)}if(t.legendItem){this._addLegendItem(t.legendItem)}if(t.date){this._addDate(t.date)}if(t.maxItems){this._addMaxItems(t.maxItems)}if(t.maxLegendItems){this._addMaxLegendItems(t.maxLegendItems)}if(t.use12HourFormat){this.setUse12HourFormat(t.use12HourFormat)}if(t.noItemsText){this._addNoItemsText(t.noItemsText)}if(t.moreItems&&t.moreItems.actions){this._oActions.attach({area:L.Content,actions:t.moreItems.actions,control:this._getMoreButton()})}if(t.calendarWeekNumbering){this._oCalendar.setCalendarWeekNumbering(t.calendarWeekNumbering)}};M.prototype._getStaticConfigurationLegendItems=function(t,e,a,i){var n=[];t.forEach(function(t,e){var s=Object.keys(a.legendItem.template),l={};s.forEach(function(t){var n=o.prependRelativePaths(a.legendItem.template[t],i.getBindingPath("items")+"/"+e);l[t]=r.resolveValue(n,this)}.bind(this));n.push(l)}.bind(this));e.forEach(function(t,e){var s=Object.keys(a.legendItem.template),l={};s.forEach(function(t){var n=o.prependRelativePaths(a.legendItem.template[t],i.getBindingPath("items")+"/"+e);l[t]=r.resolveValue(n,this)}.bind(this));n.push(l)}.bind(this));return n};M.prototype._getStaticConfigurationSpecialDates=function(t,e){var a=[];t.forEach(function(t,i){var n=this._oCalendar,s=t.getStartDate(),l=t.getEndDate(),p=n._getMonthPicker().getMonth()?n._getMonthPicker().getMonth():n._getFocusedDate().getMonth(),d=Number(n._getYearString()),g=s.getMonth()===p,m=l?l.getMonth()===p:false,h=s.getFullYear()===d,c=t.getEndDate()?t.getEndDate().getFullYear()===d:h,u=(g||m)&&(h||c),f,D;if(u){f=Object.keys(e.specialDate.template);var _={};f.forEach(function(t){_[t]=o.prependRelativePaths(e.specialDate.template[t],this._oCalendar.getBindingPath("specialDates")+"/"+i)}.bind(this));D=r.resolveValue(_,this);D.startDate=this.formatDate(D.startDate).toISOString();if(D.endDate){D.endDate=this.formatDate(D.endDate).toISOString()}a.push(D)}}.bind(this));return a};M.prototype._getStaticConfigurationAppointments=function(t,e,a,i){var n=[],s=false;t.forEach(function(t,l){var p=t.getStartDate(),d=t.getEndDate(),g,m,h=p>=e&&p<=a,c=d>=e&&d<=a,u=p<=e&&d>a,f=h||c||u;if(f){g=Object.keys(i.item.template);m={};g.forEach(function(t){var e=o.prependRelativePaths(i.item.template[t],this.getBindingPath("appointments")+"/"+l);m[t]=r.resolveValue(e,this)}.bind(this));m.startDate=this.formatDate(m.startDate).toISOString();if(m.endDate){m.endDate=this.formatDate(m.endDate).toISOString()}n.push(m);if(n.length>i.maxItems){s=true}}}.bind(this));return{resolvedItems:n,moreItems:s}};M.prototype.getStaticConfiguration=function(){var t=this.getParsedConfiguration(),e=this.getAppointments(),i=this._oCalendar.getSpecialDates(),n=this._oCalendar.getLegend(),s=a.getElementById(n),o=s.getItems(),l=s.getAppointmentItems(),p=this._oCalendar.getSelectedDates()[0]?this._oCalendar.getSelectedDates()[0].getStartDate():null,d=864e5,g=this._oCalendar.getSelectedDates()[0]?this._oCalendar.getSelectedDates()[0]:null,m=g.getStartDate?g.getStartDate().getTime()+d:null,h=g.getStartDate(),c=t.maxItems,u=t.maxLegendItems,f=t.noItemsText,D=false,_={},I,C,y,S,A;A=p?p.toISOString():null;A=A?A:t.date;I=this._getStaticConfigurationAppointments(e,h,m,t);S=I.resolvedItems;D=I.moreItems;C=this._getStaticConfigurationSpecialDates(i,t);y=this._getStaticConfigurationLegendItems(o,l,t,s);_.items=S;_.specialDates=C;_.legendItems=y;_.date=A;_.maxItems=c;_.maxLegendItems=u;_.noItemsText=f;if(D){_.moreItems=r.resolveValue(t.moreItems,this)}return _};M.prototype._setParameters=function(t,e){var a,i,n,s,o;if(e){a=e}else if(this._oCalendar.getSelectedDates().length){a=this._oCalendar.getSelectedDates()[0].getStartDate()}else{a=this._oCalendar.getStartDate()}i=v.getInstance(a.getFullYear(),a.getMonth(),a.getDate()).getTime();n=v.getInstance(a.getFullYear(),a.getMonth(),a.getDate()+1).getTime();s=this.getAppointments();if(s){o=s.filter(function(t){var e=t.getStartDate().getTime(),a=t.getEndDate().getTime();if(e>=i&&e<n||a>i&&a<=n||e<i&&a>n){return t}})}else{o=[]}this._iAllItems=o.length;this._iMaxItems=this.getVisibleAppointmentsCount();this._iVisibleItems=Math.min(this._iMaxItems,this._iAllItems);if(this.getModel("parameters")){this.getModel("parameters").setProperty("/visibleItems",this._iVisibleItems);this.getModel("parameters").setProperty("/allItems",this._iAllItems)}};M.prototype._refreshVisibleAppointments=function(t){this._aVisibleAppointments=this._calculateVisibleAppointments(this.getAppointments(),t)};M.prototype._calculateVisibleAppointments=function(t,e){var a=this._isAppointmentInSelectedDate(e);var i=function(t,a){var i=t.getEndDate(),n=v.getInstance();if(e.getDate()===n.getDate()&&e.getMonth()===n.getMonth()&&e.getFullYear()===n.getFullYear()){return this._iAllItems-a<this._iVisibleItems||i.getTime()>n.getTime()}return true};var n=t.filter(a,this).sort(this._sortByStartHourCB).filter(i,this).slice(0,this._iVisibleItems);return n};M.prototype._sortByStartHourCB=function(t,e){return t.getStartDate().getTime()-e.getStartDate().getTime()||e.getEndDate().getTime()-t.getEndDate().getTime()};M.prototype._isAppointmentInSelectedDate=function(t){return function(e){var a=e.getStartDate().getTime(),i=e.getEndDate().getTime(),n=t.getTime(),s=A.getInstance(v.getInstance(t.getTime())),o,r,l,p;s.setDate(s.getDate()+1);o=s.getTime()-1e3;r=a<n&&i>o;l=a>=n&&a<o;p=i>n&&i<=o;return r||l||p}};M.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments};M.prototype.formatDate=function(t){var e=u.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}).parse(t);if(!e){e=u.getInstance({pattern:"yyyy-MM-dd"}).parse(t)}return e};M.prototype._addItem=function(t){var e={title:t.template.title,text:t.template.text,type:t.template.type},a;if(t.template.startDate){e.startDate=o.formattedProperty(t.template.startDate,this.formatDate)}if(t.template.endDate){e.endDate=o.formattedProperty(t.template.endDate,this.formatDate)}if(t.template.icon&&t.template.icon.src){e.icon=o.formattedProperty(t.template.icon.src,function(t){return this._oIconFormatter.formatSrc(t)}.bind(this))}this._oAppointmentTemplate=new p(e);var i=this.getActions();i.attach({area:L.ContentItem,actions:t.template.actions,control:this,actionControl:this._oAppointmentTemplate,enabledPropertyName:"clickable",enabledPropertyValue:true,disabledPropertyValue:false});a={path:t.path,template:this._oAppointmentTemplate};this._bindAggregationToControl("appointments",this,a)};M.prototype._addSpecialDate=function(t){var e=t.template,a;if(e.startDate){e.startDate=o.formattedProperty(e.startDate,this.formatDate)}if(e.endDate){e.endDate=o.formattedProperty(e.endDate,this.formatDate)}this._oSpecialDateTemplate=new S(e);a={path:t.path,template:this._oSpecialDateTemplate};this._bindAggregationToControl("specialDates",this._oCalendar,a)};M.prototype._addLegendItem=function(t){var e={text:t.template.text,type:t.template.type},a={text:t.template.text,type:t.template.type},i,n;this._oCalendarLegendItemTemplate=new b(e);i={path:t.path,template:this._oCalendarLegendItemTemplate,filters:new _({path:"category",operator:I.Contains,value1:"calendar"})};this._bindAggregationToControl("items",this._oLegend,i);this._oAppointmentLegendItemTemplate=new b(a);n={path:t.path,template:this._oAppointmentLegendItemTemplate,filters:new _({path:"category",operator:I.Contains,value1:"appointment"})};this._bindAggregationToControl("appointmentItems",this._oLegend,n)};M.prototype._addDate=function(t){if(o.isBindingInfo(t)){if(!t){return}var e=new S;e.bindProperty("startDate",o.formattedProperty(t,this.formatDate));this._oCalendar.addSelectedDate(e)}else{this._oCalendar.addSelectedDate(new S({startDate:this.formatDate(t)}));var a=this.formatDate(t);this._handleSelect(a);this._handleStartDateChange(a);this._bDataInitiallyLoaded=true}};M.prototype._addMaxItems=function(t){if(o.isBindingInfo(t)){t&&this.bindProperty("visibleAppointmentsCount",t)}else{this.setVisibleAppointmentsCount(t)}};M.prototype._addMaxLegendItems=function(t){if(o.isBindingInfo(t)){t&&this._oLegend.bindProperty("visibleLegendItemsCount",t)}else{this._oLegend.setVisibleLegendItemsCount(t)}};M.prototype._addNoItemsText=function(t){if(o.isBindingInfo(t)){t&&this.bindProperty("noAppointmentsText",t)}else{this.setNoAppointmentsText(t)}};M.prototype._getMoreButton=function(){if(!this._oMoreAppsButton){this._oMoreAppsButton=new h({text:"More"})}return this._oMoreAppsButton};M.prototype._bNeedForMoreButton=function(){return this._iAllItems>this.getVisibleAppointmentsCount()};M.prototype._getCurrentAppointment=function(){var t=this._getVisibleAppointments(),e=v.getInstance(),a,i,n,s,o=this._oCalendar.getSelectedDates().length?this._oCalendar.getSelectedDates()[0].getStartDate():this._oCalendar.getStartDate();if(o.getDate()===e.getDate()&&o.getMonth()===e.getMonth()&&o.getFullYear()===e.getFullYear()){for(s=t.length-1;s>=0;s--){a=t[s];i=a.getStartDate().getTime();n=a.getEndDate().getTime();if(e.getTime()>i&&e.getTime()<n){return a}}}};M.prototype._handleStartDateChange=function(t){var e=this.getActions(),a=C.fromLocalJSDate(t),i=y._getFirstDateOfWeek(y._getFirstDateOfMonth(a)),n=new C(t.getFullYear(),t.getMonth()+1,1),s;n.setDate(n.getDate()-1);s=y._getFirstDateOfWeek(n);s.setDate(s.getDate()+6);e.fireAction(this,"MonthChange",{firstDate:i.toLocalJSDate(),lastDate:s.toLocalJSDate()})};M.prototype._handleSelect=function(t){var e=this.getActions();e.fireAction(this,"DateChange",{selectedDate:t})};M.prototype.ontap=function(t){t.stopPropagation()};function P(){if(!this._oLocaleData){var t=x.call(this);var e=new f(t);this._oLocaleData=D.getInstance(e)}return this._oLocaleData}function x(){if(!this._sLocale){this._sLocale=new f(e.getLanguageTag()).toString()}return this._sLocale}return M});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/CalendarContentRenderer", ["./BaseContentRenderer","sap/ui/core/IconPool","sap/ui/core/InvisibleText","sap/ui/core/Lib","sap/ui/unified/library","sap/ui/unified/CalendarLegendRenderer"],function(e,t,a,n,r,i){"use strict";var o=r.CalendarDayType;var p=e.extend("sap.ui.integration.cards.CalendarContentRenderer",{apiVersion:2});p.renderContent=function(e,t){var a=n.getResourceBundleFor("sap.ui.integration"),r=t.getId();e.openStart("div",r+"card-group");e.attr("role","group");e.attr("aria-label",a.getText("CARDS_CALENDAR"));e.class("sapFCalCard");e.openEnd();e.openStart("div",r+"card-layout");e.class("sapFCalCardLayout");e.openEnd();e.openStart("div",r+"left-side");e.class("sapFCalCardLeftSide");e.openEnd();e.renderControl(t._oCalendar);e.openStart("div",r+"card-legend");e.attr("aria-label",a.getText("CARDS_CALENDAR_LEGEND"));e.openEnd();e.renderControl(t._oLegend);e.close("div");e.openStart("div","card-line-separator");e.class("sapFCalCardLineSeparator");e.openEnd();e.close("div");e.close("div");e.openStart("div",r+"right-side");e.class("sapFCalCardRightSide");e.openEnd();p.renderAppointments(e,t);if(t._bNeedForMoreButton()){e.renderControl(t._getMoreButton())}e.close("div");e.close("div");e.close("div")};p.renderAppointments=function(e,t){var a=t._getVisibleAppointments(),r=t._getCurrentAppointment(),i=n.getResourceBundleFor("sap.ui.integration");e.openStart("div",t.getId()+"appointments-list");e.attr("role","list");e.attr("aria-label",i.getText("CARDS_CALENDAR_APPOINTMENTS"));e.class("sapFCalCardAppList");e.openEnd();if(!a.length){e.openStart("div");e.class("sapFCalCardNoItemsText");e.openEnd();e.text(t.getNoAppointmentsText());e.close("div")}a.forEach(function(a){p.renderAppointment(e,t,a,r==a)});e.close("div")};p.renderAppointment=function(e,t,a,n){var r=t._oCalendar.getSelectedDates()[0].getStartDate();e.openStart("div");e.attr("role","listitem");e.class("sapUiCalendarAppContainer");if(n){e.class("sapUiCalendarAppCurrent")}e.openEnd();e.openStart("div");e.class("sapUiCalendarAppContainerLeft");e.openEnd();e.openStart("div");e.class("sapUiCalendarAppStart");e.openEnd();e.text(a._getDateRangeIntersectionText(r,t.getUse12HourFormat()).start);e.close("div");e.openStart("div");e.class("sapUiCalendarAppEnd");e.openEnd();e.text(a._getDateRangeIntersectionText(r,t.getUse12HourFormat()).end);e.close("div");e.close("div");e.openStart("div");e.class("sapUiCalendarAppContainerRight");e.openEnd();this._renderAppointment(e,t,a,r);e.close("div");p.renderAdditionalAriaLabel(e,t,a);e.close("div")};p._renderAppointment=function(e,t,a,n){var r=a.getId();var i=a.getTitle();var l=a.getText();var d=a.getType();var s=a.getIcon();var c=!i||!l;e.openStart("div",a);e.class("sapUiCalendarApp");if(a.getClickable()){e.attr("tabindex","0")}else{e.class("sapUiCalendarAppDisabled")}e.accessibilityState(a,p.getAccProps(a));if(d&&d!=o.None){e.class("sapUiCalendarApp"+d)}if(c){e.class("sapUiCalendarAppOneLine")}e.openEnd();e.openStart("div");e.class("sapUiCalendarAppCont");e.openEnd();if(s){var g=["sapUiCalendarAppIcon"];var v={};v["id"]=r+"-Icon";v["title"]=null;v["role"]="img";e.icon(s,g,v)}e.openStart("div");e.class("sapUiCalendarAppTitleWrapper");e.openEnd();if(i){e.openStart("span",r+"-Title");e.class("sapUiCalendarAppTitle");e.openEnd();e.text(i);e.close("span")}if(l){e.openStart("span",r+"-Text");e.class("sapUiCalendarAppText");e.openEnd();e.text(l);e.close("span")}e.close("div");e.close("div");e.close("div")};p.renderAdditionalAriaLabel=function(e,t,a){var r=n.getResourceBundleFor("sap.ui.unified"),i=t._oFormatAria,p=a.getType(),l=t._oLegend?t._oLegend.getAppointmentItems():[];var d=r.getText("CALENDAR_START_TIME")+": "+i.format(a.getStartDate());d=d+"; "+r.getText("CALENDAR_END_TIME")+": "+i.format(a.getEndDate());if(p&&p!=o.None){d=d+"; "+this.getAriaTextForType(p,l)}e.openStart("span",a.getId()+"-Descr");e.class("sapUiInvisibleText");e.openEnd();e.text(d);e.close("span")};p.getAriaTextForType=function(e,t){var a,n,r,o;if(t&&t.length){for(var o=0;o<t.length;o++){r=t[o];if(r.getType()===e){a=r.getText();break}}}if(!a){n=i.getTypeAriaText(e);if(n){a=n.getText()}}return a};p.getAccProps=function(e){var t=e.getId();var n={labelledby:{value:a.getStaticId("sap.ui.unified","APPOINTMENT")+" "+t+"-Descr",append:true},selected:null};if(e.getTitle()){n["labelledby"].value=n["labelledby"].value+" "+t+"-Title"}if(e.getText()){n["labelledby"].value=n["labelledby"].value+" "+t+"-Text"}if(e.getSelected()){n["labelledby"].value=n["labelledby"].value+" "+a.getStaticId("sap.ui.unified","APPOINTMENT_SELECTED")}return n};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ComponentContent", ["./BaseContent","./ComponentContentRenderer","sap/ui/integration/library","sap/m/IllustratedMessageType","sap/ui/core/ComponentContainer","sap/ui/core/ComponentHooks"],function(t,e,n,o,a,i){"use strict";const r=n.CardPreviewMode;const s=n.CardDataMode;var p=t.extend("sap.ui.integration.cards.ComponentContent",{metadata:{library:"sap.ui.integration"},renderer:e});i.onInstanceCreated.register(function(t){var e=t.getComponentData();if(e&&e["__sapUiIntegration_card"]&&t.onCardReady){t.onCardReady(e["__sapUiIntegration_card"])}});p.prototype.onAfterRendering=function(){if(this._oComponent?.tileSetVisible){const t=this.getCardInstance();const e=t?._getActualDataMode()===s.Active;this._oComponent.tileSetVisible(e)}};p.prototype.refreshData=function(){t.prototype.refreshData.apply(this,arguments);if(this._oComponent?.tileRefresh){this._oComponent.tileRefresh()}};p.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oComponent=null};p.prototype.applyConfiguration=function(){const t=this.getCardInstance();const e=this.getParsedConfiguration();if(!e){return}if(t.getPreviewMode()===r.Abstract){this.fireEvent("_actionContentReady");return}const n=new a({manifest:e.componentManifest,async:true,settings:{componentData:this._prepareComponentData()},componentCreated:t=>{this._oComponent=t.getParameter("component");this.fireEvent("_actionContentReady");this.fireEvent("_updated")},componentFailed:()=>{this.fireEvent("_actionContentReady");this.handleError({illustrationType:o.ErrorScreen,title:t.getTranslatedText("CARD_DATA_LOAD_ERROR"),description:"Card content failed to create component"})}});this.setAggregation("_content",n)};p.prototype._prepareComponentData=function(){const t=this.getCardInstance();const e=t.getManifestEntry("/sap.card/configuration/componentData");const n=e||{};n["__sapUiIntegration_card"]=t;return n};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ComponentContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var n=e.extend("sap.ui.integration.cards.ComponentContentRenderer",{apiVersion:2});n.getMinHeight=function(n,t){if(n.minHeight){return n.minHeight}return e.getMinHeight.apply(this,arguments)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/Footer", ["sap/ui/core/Control","sap/base/util/merge","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/integration/controls/ActionsStrip","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/openCardShowMore","sap/m/library","sap/m/Button"],function(t,e,o,i,n,s,r,a,u){"use strict";const g=a.ButtonType;var l=t.extend("sap.ui.integration.cards.Footer",{metadata:{library:"sap.ui.integration",properties:{configuration:{type:"object"},showMoreButton:{type:"boolean"},showCloseButton:{type:"boolean"},detectVisibility:{type:"boolean"}},aggregations:{actionsStrip:{type:"sap.ui.integration.controls.ActionsStrip",multiple:false},_showMore:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_closeButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e).class("sapFCardFooter");if(e.getCardInstance().isLoading()&&e._hasBinding()){t.class("sapFCardFooterLoading")}t.openEnd();const o=e.getActionsStrip();if(o){t.renderControl(o)}const i=e.getAggregation("_showMore");if(i){t.renderControl(i)}const n=e.getAggregation("_closeButton");if(n){t.renderControl(n)}t.close("div")}}});l.create=function({card:t,configuration:e,paginator:o,showCloseButton:i,detectVisibility:r}){const a=i||l._shouldShowCloseButton(t);const u=!e||Object.keys(e).length===1&&e.closeButton&&e.closeButton.visible===false;if(u&&!a&&!r){return null}const g=new l({configuration:s.createBindingInfos(e,t.getBindingNamespaces()),card:t,showCloseButton:a,detectVisibility:r,actionsStrip:n.create(e?.actionsStrip,t,true),visible:e?.visible});g.setPaginator(o);return g};l._shouldShowCloseButton=function(t){const e=t._oCardManifest.get("/sap.card/footer");const o=t._oCardManifest.get("/sap.card/header");const i=!!t.getOpener();if(!i){return false}if(e?.closeButton&&"visible"in e.closeButton){return e.closeButton.visible}if(o?.closeButton&&"visible"in o.closeButton){return o.closeButton.visible}return true};l.prototype.onBeforeRendering=function(){if(this._shouldCreateShowMoreButton()){this._createShowMore()}else{this.destroyAggregation("_showMore")}if(this.getShowCloseButton()){this._createCloseButton()}else{this.destroyAggregation("_closeButton")}if(this.getDetectVisibility()){const t=this.hasVisibleItems();this.setVisible(t);this.getCardInstance().toggleStyleClass("sapUiIntCardFooterInvisible",!t)}};l.prototype.onDataChanged=function(){if(this.getActionsStrip()){this.getActionsStrip().onDataChanged()}};l.prototype.getFirstFocusableItem=function(){const t=this.getActionsStrip()?.getFirstFocusableItem();if(t){return t}const e=this.getAggregation("_showMore");if(e?.getVisible()){return e}const o=this.getAggregation("_closeButton");if(o?.getVisible()){return o}return false};l.prototype.hasVisibleItems=function(){if(this.getActionsStrip()?.hasVisibleItems()){return true}const t=this.getAggregation("_showMore");if(t?.getVisible()){return true}const e=this.getAggregation("_closeButton");if(e?.getVisible()){return true}return false};l.prototype._hasBinding=function(){var t=s.createBindingInfos(this.getConfiguration(),this.getCardInstance().getBindingNamespaces());return(t?.actionsStrip||[]).some(function(t){for(var e in t){if(s.isBindingInfo(t[e])){return true}}return false})};l.prototype.getCardInstance=function(){return o.getElementById(this.getCard())};l.prototype.setEnabled=function(t){var e=this.getActionsStrip();if(!e){return}if(t){e.enableItems()}else{e.disableItems()}};l.prototype.getStaticConfiguration=function(){var t=e({},this.getConfiguration());if(this._oPaginator){t.paginator=this._oPaginator.getStaticConfiguration()}return t};l.prototype.setPaginator=function(t){this._oPaginator=t};l.prototype._shouldCreateShowMoreButton=function(){if(this.getShowMoreButton()){return true}const t=this._oPaginator;if(t&&!t.getActive()){return true}return false};l.prototype._shouldShowMoreButtonBeVisible=function(){let t=this._shouldCreateShowMoreButton();const e=this._oPaginator;if(e){t=t&&e.getPageCount()>1}return t};l.prototype._createShowMore=function(){let t=this.getAggregation("_showMore");if(!t){const e=this._oPaginator;let o=false;t=new u(`${this.getId()}-showMore`,{text:i.getResourceBundleFor("sap.ui.integration").getText("CARD_FOOTER_SHOW_MORE"),type:g.Transparent,press:()=>{if(o){return}let t;if(e){t=e.openDialog()}else{t=r(this.getCardInstance())}o=true;t.attachAfterOpen(()=>{o=false})},visible:this._shouldShowMoreButtonBeVisible()}).addStyleClass("sapFCardFooterShowMoreButton");e?.attachEvent("_ready",()=>{t.setVisible(this._shouldShowMoreButtonBeVisible())});this.setAggregation("_showMore",t)}return t};l.prototype._createCloseButton=function(){let t=this.getAggregation("_closeButton");if(!t){t=new u(`${this.getId()}-closeBtn`,{text:i.getResourceBundleFor("sap.ui.integration").getText("CARD_DIALOG_CLOSE_BUTTON"),type:g.Emphasized,press:this.getCardInstance().hide.bind(this.getCardInstance())});this.setAggregation("_closeButton",t)}return t};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/Header", ["sap/ui/core/Element","sap/ui/model/json/JSONModel","sap/base/util/merge","sap/f/cards/Header","sap/f/cards/HeaderRenderer","sap/m/library","sap/m/Text","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/Utils","sap/ui/integration/formatters/IconFormatter"],function(t,e,i,a,r,o,n,s,d,c,u,h){"use strict";var l=o.AvatarColor;var p=a.extend("sap.ui.integration.cards.Header",{metadata:{library:"sap.ui.integration",properties:{interactive:{type:"boolean",defaultValue:false}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:r});p.create=function(t,e,i,a){e=e||{};var r={title:e.title,titleMaxLines:e.titleMaxLines,subtitle:e.subTitle,subtitleMaxLines:e.subTitleMaxLines,dataTimestamp:e.dataTimestamp,visible:e.visible,wrappingType:e.wrappingType};if(e.status&&e.status.text&&!e.status.text.format){r.statusText=e.status.text;r.statusVisible=e.status.visible}if(e.icon){var o=e.icon.initials||e.icon.text;var d=e.icon.backgroundColor||(o?l.Accent6:l.Transparent);r.iconSrc=e.icon.src;r.iconDisplayShape=e.icon.shape;r.iconInitials=o;r.iconAlt=e.icon.alt;r.iconBackgroundColor=d;r.iconVisible=e.icon.visible;r.iconFitType=e.icon.fitType}if(r.iconSrc){r.iconSrc=s.formattedProperty(r.iconSrc,function(t){return a.formatSrc(t)})}if(e.banner){r.bannerLines=e.banner.map(function(t){var e=new n({text:t.text,visible:t.visible});if(t.diminished){e.addStyleClass("sapFCardHeaderBannerLineDiminished")}return e})}r.toolbar=i;const c=new p(t,r);c._oConfiguration=e;c._oIconFormatter=a;return c};p.prototype.init=function(){a.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new c);this._aReadyPromises=[];this._awaitEvent("_dataReady");this._awaitEvent("_actionHeaderReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready")}.bind(this))};p.prototype.exit=function(){a.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}};p.prototype.shouldShowIcon=function(){return this.getIconVisible()&&this.getIconSrc()!==h.SRC_FOR_HIDDEN_ICON};p.prototype.isInteractive=function(){return this.getInteractive()};p.prototype.isReady=function(){return this._bReady};p.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};p.prototype._handleError=function(t){this.fireEvent("_error",{errorInfo:t})};p.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(e){this.attachEventOnce(t,function(){e()})}.bind(this)))};p.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};p.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};p.prototype.getStaticConfiguration=function(){var t=i({},this._oConfiguration),e=u.getNestedPropertyValue(t,"/status/text/format"),a;if(e){a=u.getStatusTextBindingInfo(e)}if(a){t.status.text=a}if(t.icon&&t.icon.src){t.icon.src=this._oIconFormatter.formatSrc(d.resolveValue(t.icon.src,this))}return t};p.prototype._setDataConfiguration=function(t){var i=this.getCardInstance(),a="/",r;if(t&&t.path){a=d.resolveValue(t.path,this.getCardInstance())}this.bindObject(a);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t&&t.name){r=i.getModel(t.name)}else if(this._oDataProvider){r=new e;this.setModel(r)}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(t){r.setData(t.getParameter("data"));this.onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(t){this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getResolvedConfiguration()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};p.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};p.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};p.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};p.prototype.onDataRequestComplete=function(){var t=this.getCardInstance();if(t){t._fireDataChange()}this.fireEvent("_dataReady");this.hideLoadingPlaceholders()};p.prototype.getCardInstance=function(){return t.getElementById(this.getCard())};p.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ListContent", ["./BaseListContent","./ListContentRenderer","sap/ui/util/openWindow","sap/m/library","sap/m/List","sap/f/cards/loading/ListPlaceholder","sap/ui/integration/controls/ObjectStatus","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/controls/Microchart","sap/ui/integration/controls/MicrochartLegend","sap/ui/integration/controls/ListContentItem","sap/ui/integration/controls/ActionsStrip","sap/ui/integration/cards/list/MicrochartsResizeHelper","sap/ui/integration/util/SorterHelper"],function(t,i,e,n,o,s,r,a,c,h,l,p,g,u,d,f){"use strict";var m=n.AvatarColor;var I=n.ListType;var v=n.ListSeparators;var y=a.CardActionArea;var _=n.EmptyIndicatorMode;var b="_legendColorsLoad";var S=t.extend("sap.ui.integration.cards.ListContent",{metadata:{library:"sap.ui.integration",aggregations:{_legend:{multiple:false,visibility:"hidden"}}},renderer:i});S.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);this._getList().setBackgroundDesign(this.getDesign())};S.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null}if(this._oMicrochartsResizeHelper){this._oMicrochartsResizeHelper.destroy();this._oMicrochartsResizeHelper=null}};S.prototype.createLoadingPlaceholder=function(t){var e=this.getCardInstance(),n=e.getContentMinItems(t);const o=h.resolveValue(t.item,this);const r=g.getPlaceholderInfo(o);return new s({minItems:n!==null?n:2,hasIcon:r.hasIcon,attributesLength:r.attributesLength,hasChart:r.hasChart,hasActionsStrip:r.hasActionsStrip,hasDescription:r.hasDescription,itemHeight:i.getItemMinHeight(t,this)+"rem"})};S.prototype.loadDependencies=function(t){if(!this.isSkeleton()&&t.get("/sap.card/content/item/chart")){return l.loadDependencies()}return Promise.resolve()};S.prototype.applyConfiguration=function(){t.prototype.applyConfiguration.apply(this,arguments);var i=this.getParsedConfiguration();if(!i){return}if(i.items){this._setStaticItems(i.items);return}if(i.item){this._setItem(i)}};S.prototype.getStaticConfiguration=function(){var t=this.getInnerList().getItems(),i=this.getParsedConfiguration(),e=t[0]&&t[0].isA("sap.m.GroupHeaderListItem"),n=[],o=[],s;t.forEach(function(t){if(t.isA("sap.m.GroupHeaderListItem")){if(s){o.push(s)}n=[];s={title:t.getTitle(),items:n}}else{var e=h.resolveValue(i.item,this,t.getBindingContext().getPath());if(e.icon&&e.icon.src){e.icon.src=this._oIconFormatter.formatSrc(e.icon.src)}n.push(e)}}.bind(this));if(s){o.push(s)}var r={};if(e){r.groups=o}else{r.groups=[{items:n}]}return r};S.prototype.getItemsLength=function(){return this._getList().getItems().filter(t=>!t.isA("sap.m.GroupHeaderListItem")).length};S.prototype.onDataChanged=function(){t.prototype.onDataChanged.apply(this,arguments);this._checkHiddenNavigationItems(this.getParsedConfiguration().item);this._getList().getItems().forEach(t=>{if(t.getActionsStrip&&t.getActionsStrip()){t.getActionsStrip().onDataChanged()}})};S.prototype._getList=function(){if(this._bIsBeingDestroyed){return null}if(!this._oList){this._oList=new o({id:this.getId()+"-list",growing:false,showNoData:false,ariaLabelledBy:this.getHeaderTitleId(),updateFinished:function(){if(this._iVisibleItems){var t=this._oList.getItems();for(var i=this._iVisibleItems+1;i<t.length;i++){t[i].setVisible(false)}}}.bind(this)});this._oList.addEventDelegate({onfocusin:function(t){if(!(t.srcControl instanceof g)){return}var i=t.target.getBoundingClientRect().bottom;var e=this.getDomRef().getBoundingClientRect().bottom;var n=Math.abs(i-e);var o=10;if(n<o){t.srcControl.addStyleClass("sapUiIntLCIRoundedCorners")}}},this);this.setAggregation("_content",this._oList)}return this._oList};S.prototype._setItem=function(t){var i=t.item,e=this._getList(),n=this.isSkeleton(),o,s={title:i.title&&(i.title.value||i.title),description:i.description&&(i.description.value||i.description),descriptionVisible:i.description?i.description.visible:undefined,highlight:i.highlight,highlightText:i.highlightText,hasInfo:!!i.info,info:i.info&&i.info.value,infoState:i.info&&i.info.state,infoVisible:i.info&&i.info.visible,showInfoStateIcon:i.info&&i.info.showStateIcon,customInfoStatusIcon:i.info&&i.info.customStateIcon,infoStateInverted:i.info&&i.info.inverted,attributes:[]};if(i.icon){s.icon=c.formattedProperty(i.icon.src,function(t){return this._oIconFormatter.formatSrc(t)}.bind(this));s.iconAlt=i.icon.alt;s.iconDisplayShape=i.icon.shape;s.iconFitType=i.icon.fitType;s.iconInitials=i.icon.initials||i.icon.text;s.iconVisible=i.icon.visible;if(i.icon.size){s.iconSize=i.icon.size}s.iconBackgroundColor=i.icon.backgroundColor||(s.iconInitials?undefined:m.Transparent)}if(i.attributesLayoutType){s.attributesLayoutType=i.attributesLayoutType}if(i.attributes){i.attributes.forEach(function(t){o=new r({text:t.value,state:t.state,emptyIndicatorMode:_.On,visible:t.visible,showStateIcon:t.showStateIcon,customIcon:t.customStateIcon,inverted:t.inverted});s.attributes.push(o)})}if(!n){if(i.chart){s.microchart=this._createChartAndAddLegend(i.chart)}if(i.actionsStrip){s.actionsStrip=u.create(i.actionsStrip,this.getCardInstance());e.setShowSeparators(v.All)}else{e.setShowSeparators(v.None)}}this._oItemTemplate=new g(s);this._oActions.attach({area:y.ContentItem,actions:i.actions,control:this,actionControl:this._oItemTemplate,enabledPropertyName:"type",enabledPropertyValue:I.Active,disabledPropertyValue:I.Inactive});var a=t.group;if(a){this._oSorter=f.getGroupSorter(a)}var h={template:this._oItemTemplate,sorter:this._oSorter};this._bindAggregationToControl("items",e,h)};S.prototype._createChartAndAddLegend=function(t){var i=l.create(t);this.destroyAggregation("_legend");if(t.type==="StackedBar"){var e=new p({chart:i.getChart(),colorsLoad:function(){this.fireEvent(b)}.bind(this),visible:t.visible});e.initItemsTitles(t.bars,this.getBindingContext().getPath());this.setAggregation("_legend",e);this.awaitEvent(b)}this._oMicrochartsResizeHelper=new d(this._oList);return i};S.prototype._setStaticItems=function(t){var i=this._getList();t.forEach(function(t){var n=new g({title:t.title?t.title:"",description:t.description?t.description:"",icon:t.icon?t.icon:"",infoState:t.infoState?t.infoState:"None",info:t.info?t.info:"",highlight:t.highlight?t.highlight:"None",highlightText:t.highlightText?t.highlightText:""});if(t.action){n.setType("Navigation");if(t.action.url){n.attachPress(function(){e(t.action.url,t.target||"_blank")})}}i.addItem(n)});this.fireEvent("_actionContentReady")};S.prototype.getInnerList=function(){return this._getList()};return S});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ListContentRenderer", ["./BaseListContentRenderer","../controls/ListContentItem","../controls/ActionsStrip"],function(t,e,n){"use strict";var i=t.extend("sap.ui.integration.cards.ListContentRenderer",{apiVersion:2});i.renderContent=function(t,e){t.renderControl(e.getAggregation("_content"));if(e.getAggregation("_legend")){t.renderControl(e.getAggregation("_legend"))}e.getPaginator()?.render(t)};i.getMinHeight=function(t,e,n){if(e._fMinHeight){return e._fMinHeight+"px"}var i=n.getContentMinItems(t),r;if(!t||!t.item||i==null){return this.DEFAULT_MIN_HEIGHT}r=this.getItemMinHeight(t,e);return i*r+"rem"};i.getItemMinHeight=function(t,i){if(!t||!t.item){return 0}var r=this.isCompact(i),o=t.item,g=r?2:2.75,s=0,a=e.getLinesCount(o,i);if(a===2){g=5}else if(a>2){g=a+(a-1)*.5;s=2}if(o.actionsStrip&&n.hasVisibleTemplateItems(o.actionsStrip,i)){g+=r?2:2.75;s+=.5;if(a>2){g+=.5;s=1.5}}g+=s;return g};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/NumericHeader", ["sap/base/util/extend","sap/f/cards/NumericHeader","sap/f/cards/NumericHeaderRenderer","sap/f/cards/NumericSideIndicator","sap/m/library","sap/m/Text","sap/ui/core/Element","sap/ui/integration/util/BindingHelper","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/LoadingProvider","sap/ui/integration/controls/Microchart"],function(t,e,i,a,r,n,o,s,d,c,l,u){"use strict";var h=r.AvatarColor;var p=e.extend("sap.ui.integration.cards.NumericHeader",{metadata:{library:"sap.ui.integration",properties:{interactive:{type:"boolean",defaultValue:false}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:i});p.create=function(e,i,r,o){i=i||{};var d={title:i.title,titleMaxLines:i.titleMaxLines,subtitle:i.subTitle,subtitleMaxLines:i.subTitleMaxLines,dataTimestamp:i.dataTimestamp,visible:i.visible,wrappingType:i.wrappingType};if(i.status&&i.status.text&&!i.status.text.format){d.statusText=i.status.text;d.statusVisible=i.status.visible}if(i.icon){var c=i.icon.initials||i.icon.text;var l=i.icon.backgroundColor||(c?h.Accent6:h.Transparent);d.iconSrc=i.icon.src;d.iconDisplayShape=i.icon.shape;d.iconInitials=c;d.iconAlt=i.icon.alt;d.iconBackgroundColor=l;d.iconVisible=i.icon.visible;d.iconFitType=i.icon.fitType}if(d.iconSrc){d.iconSrc=s.formattedProperty(d.iconSrc,function(t){return o.formatSrc(t)})}t(d,{unitOfMeasurement:i.unitOfMeasurement,details:i.details?.text??i.details,detailsMaxLines:i.details?.maxLines||i.detailsMaxLines,sideIndicatorsAlignment:i.sideIndicatorsAlignment});if(i.details?.state){d.detailsState=i.details.state}if(i.mainIndicator){d.number=i.mainIndicator.number;d.scale=i.mainIndicator.unit;d.trend=i.mainIndicator.trend;d.state=i.mainIndicator.state;d.numberVisible=i.mainIndicator.visible}if(i.sideIndicators){d.sideIndicators=i.sideIndicators.map(function(t){return new a(t)})}if(i.banner){d.bannerLines=i.banner.map(function(t){var e=new n({text:t.text,visible:t.visible});if(t.diminished){e.addStyleClass("sapFCardHeaderBannerLineDiminished")}return e})}d.toolbar=r;const g=new p(e,d);if(i.chart){u.loadDependencies().then(()=>{g.setMicroChart(u.create(i.chart,true))});if(i.sideIndicators){g.addStyleClass("sapFCardNumericHeaderSIMC")}else{g.addStyleClass("sapFCardNumericHeaderMC")}}return g};p.prototype.init=function(){e.prototype.init.call(this);this._bReady=false;this.setAggregation("_loadingProvider",new l);this._aReadyPromises=[];this._awaitEvent("_dataReady");Promise.all(this._aReadyPromises).then(function(){this._bReady=true;this.fireEvent("_ready")}.bind(this))};p.prototype.exit=function(){e.prototype.exit.call(this);this._oServiceManager=null;this._oDataProviderFactory=null;if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}if(this._oActions){this._oActions.destroy();this._oActions=null}};p.prototype.isInteractive=function(){return this.getInteractive()};p.prototype.isReady=function(){return this._bReady};p.prototype.isLoading=function(){if(!this.isReady()){return true}if(this._oDataProvider){return this.getAggregation("_loadingProvider").getLoading()}var t=this.getCardInstance();return t&&t.isLoading()};p.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(e){this.attachEventOnce(t,function(){e()})}.bind(this)))};p.prototype.setServiceManager=function(t){this._oServiceManager=t;return this};p.prototype.setDataProviderFactory=function(t){this._oDataProviderFactory=t;return this};p.prototype._setDataConfiguration=function(t){var e=this.getCardInstance(),i="/",a;if(t&&t.path){i=c.resolveValue(t.path,this.getCardInstance())}this.bindObject(i);if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t&&t.name){a=e.getModel(t.name)}else if(this._oDataProvider){a=new d;this.setModel(a)}if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(t){a.setData(t.getParameter("data"));this.onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(t){this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getResolvedConfiguration()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};p.prototype._handleError=function(t){this.fireEvent("_error",{errorInfo:t})};p.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};p.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};p.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};p.prototype.onDataRequestComplete=function(){this.fireEvent("_dataReady");this.hideLoadingPlaceholders()};p.prototype.getCardInstance=function(){return o.getElementById(this.getCard())};p.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};return p});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/cards/ObjectContent", ["./BaseContent","./ObjectContentRenderer","sap/ui/integration/library","sap/m/library","sap/m/IllustratedMessageType","sap/m/FlexItemData","sap/m/HBox","sap/m/VBox","sap/m/Text","sap/m/Avatar","sap/m/Link","sap/m/Label","sap/m/RatingIndicator","sap/m/Image","sap/m/ComboBox","sap/m/TextArea","sap/m/Input","sap/m/TimePicker","sap/base/Log","sap/base/util/isEmptyObject","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/core/ResizeHandler","sap/ui/layout/AlignedFlowLayout","sap/ui/dom/units/Rem","sap/ui/integration/util/ObjectStatusFactory","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/Utils","sap/ui/integration/util/Form","sap/ui/integration/util/DateRangeHelper","sap/ui/integration/util/Duration","sap/ui/integration/controls/ImageWithOverlay","sap/f/AvatarGroup","sap/f/AvatarGroupItem","sap/f/cards/NumericIndicators","sap/f/cards/NumericSideIndicator","sap/f/cards/loading/ObjectPlaceholder","sap/f/library","sap/m/OverflowToolbar","sap/m/OverflowToolbarButton","sap/ui/core/ListItem"],function(e,t,a,i,r,o,n,s,l,u,c,p,d,m,f,g,h,v,y,b,I,C,_,F,w,S,x,A,B,O,T,P,R,G,L,j,V,k,D,z,E,M){"use strict";var N=i.AvatarSize;var U=i.AvatarColor;var q=i.AvatarImageFitType;var W=i.ButtonType;var H=i.FlexRendertype;var K=i.FlexJustifyContent;var X=a.CardActionArea;var J=D.AvatarGroupType;var Q=i.ToolbarStyle;var Y=i.ImageMode;var Z=e.extend("sap.ui.integration.cards.ObjectContent",{metadata:{library:"sap.ui.integration",aggregations:{_form:{type:"sap.ui.integration.util.Form",multiple:false,visibility:"hidden"}}},renderer:t});Z.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._sResizeListenerId){_.deregister(this._sResizeListenerId);this._sResizeListenerId=""}};Z.prototype.createLoadingPlaceholder=function(e){return new k};Z.prototype.onDataChanged=function(){var e=this.getCardInstance();if(this._hasData()){this.hideNoDataMessage()}else{this.showNoDataMessage({illustrationType:r.NoData,title:this.getCardInstance().getTranslatedText("CARD_NO_ITEMS_ERROR_CHART")})}this._getForm().updateModel();if(e.isReady()){this.validateControls(false)}};Z.prototype._getForm=function(){var e=this.getAggregation("_form");if(!e){e=new O(this.getCardInstance());this.setAggregation("_form",e)}return e};Z.prototype.validateControls=function(e,t){this._getForm().validate(e,t)};Z.prototype._hasData=function(){var e=this.getConfiguration();if(!e.hasOwnProperty("hasData")){return true}var t=A.resolveValue(e.hasData,this,this.getBindingContext().getPath());if(Array.isArray(t)&&!t.length||I(t)&&b(t)){return false}return!!t};Z.prototype.applyConfiguration=function(){var e=this.getParsedConfiguration();if(!e){return}if(e.groups){this._addGroups(e)}};Z.prototype.getStaticConfiguration=function(){var e=this.getParsedConfiguration(),t;if(!this.getBindingContext()){if(e&&e.groups){e.groups.forEach(function(e){if(e.items){e.items.forEach(function(e){if(e.icon&&e.icon.src){e.icon.src=this._oIconFormatter.formatSrc(e.icon.src)}if(e.src){e.src=this._oIconFormatter.formatSrc(e.src)}}.bind(this))}}.bind(this))}return e}else{t=this.getBindingContext().getPath()}if(e.groups){e.groups.forEach(function(e){var a=[];if(e.items){e.items.forEach(function(e){var i=this._resolveGroupItem(e,e.path,t);a.push(i)}.bind(this))}e.items=a}.bind(this))}return e};Z.prototype._resolveGroupItem=function(e,t,a){var i=C({},e),r=[],o=a+t,n=["TextArea","Input","ComboBox","Duration","DateRange"].includes(e.type),s=["ButtonGroup","IconGroup"].includes(e.type);if(n){i=C(i,this._getForm().resolveControl(e))}if(e.type==="ComboBox"){if(e.item){s=true;o=a+e.item.path.substring(1);e.template=e.item.template;delete i.item}else{s=false}}if(s){var l=e.template,u=this.getModel().getProperty(o);u.forEach(function(e,t){var a=A.resolveValue(l,this,o+"/"+t+"/");if(a.icon&&a.icon.src){a.icon.src=this._oIconFormatter.formatSrc(a.icon.src)}else if(a.icon&&typeof a.icon==="string"){a.icon=this._oIconFormatter.formatSrc(a.icon)}r.push(a)}.bind(this));i.items=r;delete i.path;delete i.template}if(e.icon&&e.icon.src){i.icon.src=this._oIconFormatter.formatSrc(A.resolveValue(e.icon.src,this))}if(e.src){i.src=this._oIconFormatter.formatSrc(A.resolveValue(e.src,this))}return i};Z.prototype._getRootContainer=function(){var e=this.getAggregation("_content");if(!e){e=new s({renderType:H.Bare});this.setAggregation("_content",e);this._sResizeListenerId=_.register(e,this._onResize.bind(this))}return e};Z.prototype._addGroups=function(e){var t=this._getRootContainer(),a,i=true,r=e.groups||[];r.forEach(function(e,n){var s=this._createGroup(e,"/sap.card/content/groups/"+n);if(e.alignment==="Stretch"){s.setLayoutData(new o({growFactor:1}));t.addItem(s);i=true}else{if(i){a=this._createAFLayout();t.addItem(a);i=false}a.addContent(s)}if(n===r.length-1){s.addStyleClass("sapFCardObjectGroupLastInColumn")}},this);this._oActions.attach({area:X.Content,actions:e.actions,control:this})};Z.prototype._createGroup=function(e,t){var a;if(typeof e.visible=="string"){a=!B.hasFalsyValueAsString(e.visible)}else{a=e.visible}var i=new s({visible:a,renderType:H.Bare}).addStyleClass("sapFCardObjectGroup");if(e.title){i.addItem(new l({text:e.title,maxLines:e.titleMaxLines||1}).addStyleClass("sapFCardObjectItemTitle sapMTitle sapMTitleStyleAuto"));i.addStyleClass("sapFCardObjectGroupWithTitle")}e.items.forEach(function(a,r){a.labelWrapping=e.labelWrapping;this._createGroupItems(a,t+"/items/"+r).forEach(i.addItem,i)},this);return i};Z.prototype._createGroupItems=function(e,t){var a=e.label,i=e.showColon,r,o,l;e.showColon=i===undefined?true:i;if(typeof e.visible=="string"){o=!B.hasFalsyValueAsString(e.visible)}else{o=e.visible}if(a){r=new p({text:a,visible:o,wrapping:e.labelWrapping,showColon:e.showColon}).addStyleClass("sapFCardObjectItemLabel");r.addEventDelegate({onBeforeRendering:function(){r.setVisible(r.getVisible()&&!!r.getText())}})}l=this._createItem(e,o,r,t);if(l&&!l.isA("sap.m.Image")){l.addStyleClass("sapFCardObjectItemValue")}if(e.icon){var u=new s({renderType:H.Bare,justifyContent:K.Center,items:[r,l]}).addStyleClass("sapFCardObjectItemPairContainer");var c=new n({visible:o,renderType:H.Bare,items:[this._createGroupItemAvatar(e.icon),u]}).addStyleClass("sapFCardObjectItemLabel");return[c]}else{return[r,l]}};Z.prototype._createGroupItemAvatar=function(e){var t=x.formattedProperty(e.src,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this));var a=e.initials||e.text;var i=new u({displaySize:e.size||N.XS,src:t,initials:a,displayShape:e.shape,tooltip:e.alt,backgroundColor:e.backgroundColor||(a?undefined:U.Transparent),imageFitType:e.fitType||q.Cover,visible:e.visible}).addStyleClass("sapFCardObjectItemAvatar sapFCardIcon");return i};Z.prototype._createItem=function(e,t,a,i){var r,o=e.value,n=e.tooltip,s;switch(e.type){case"NumericData":r=this._createNumericDataItem(e,t);break;case"Status":r=S.createStatusItem(e);break;case"IconGroup":r=this._createIconGroupItem(e,t);break;case"ButtonGroup":r=this._createButtonGroupItem(e,t);break;case"ComboBox":r=this._createComboBoxItem(e,t,a,i);break;case"TextArea":r=this._createTextAreaItem(e,t,a,i);break;case"RatingIndicator":r=this._createRatingIndicatorItem(e,t);break;case"Image":r=this._createImageItem(e,t);break;case"Input":r=this._createInputItem(e,t,a,i);break;case"Duration":r=this._createDurationItem(e,t,a,i);break;case"DateRange":r=this._createDateRangeItem(e,t,a,i);break;case"link":y.warning("Usage of Object Group Item property 'type' with value 'link' is deprecated. Use Card Actions for navigation instead.",null,"sap.ui.integration.widgets.Card");r=new c({href:e.url||o,text:o,tooltip:n,target:e.target||"_blank",visible:x.reuse(t)});break;case"email":y.warning("Usage of Object Group Item property 'type' with value 'email' is deprecated. Use Card Actions for navigation instead.",null,"sap.ui.integration.widgets.Card");var l=[];if(e.value){l.push(e.value)}if(e.emailSubject){l.push(e.emailSubject)}s=x.formattedProperty(l,function(e,t){if(t){return"mailto:"+e+"?subject="+t}else{return"mailto:"+e}});r=new c({href:s,text:o,tooltip:n,visible:x.reuse(t)});break;case"phone":y.warning("Usage of Object Group Item property 'type' with value 'phone' is deprecated. Use Card Actions for navigation instead.",null,"sap.ui.integration.widgets.Card");s=x.formattedProperty(o,function(e){return"tel:"+e});r=new c({href:s,text:o,tooltip:n,visible:x.reuse(t)});break;default:r=this._createTextItem(e,t,a)}return r};Z.prototype._createNumericDataItem=function(e,t){var a=new s({visible:x.reuse(t)});var i=new j({number:e.mainIndicator.number,numberSize:e.mainIndicator.size,scale:e.mainIndicator.unit,trend:e.mainIndicator.trend,state:e.mainIndicator.state}).addStyleClass("sapUiIntOCNumericIndicators");a.addItem(i);if(e.sideIndicators){e.sideIndicators.forEach(function(e){i.addSideIndicator(new V({title:e.title,number:e.number,unit:e.unit,state:e.state}))})}if(e.details){a.addItem(new l({text:e.details,maxLines:1}).addStyleClass("sapUiIntOCNumericIndicatorsDetails"))}return a};Z.prototype._createTextItem=function(e,t,a){var i=e.value,r=e.tooltip,o;if(i&&e.actions){o=new c({text:i,tooltip:r,visible:x.reuse(t)});if(a){o.addAriaLabelledBy(a)}else{y.warning("Missing label for Object group item with actions.",null,"sap.ui.integration.widgets.Card")}this._oActions.attach({area:X.ContentItemDetail,actions:e.actions,control:this,actionControl:o,enabledPropertyName:"enabled"});o=new n({renderType:H.Bare,items:o})}else if(i){o=new l({text:i,visible:x.reuse(t),maxLines:e.maxLines})}return o};Z.prototype._createButtonGroupItem=function(e,t){var a=e.template;if(!a){return null}var i=new z({visible:x.reuse(t),style:Q.Clear});i.addStyleClass("sapUiIntCardObjectButtonGroup");var r=new E({icon:x.formattedProperty(a.icon,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this)),text:a.text||a.tooltip,tooltip:a.tooltip||a.text,type:W.Transparent,visible:a.visible});if(a.actions){r.attachPress(function(e){this._onButtonGroupPress(e,a.actions)}.bind(this))}i.bindAggregation("content",{path:e.path||"/",template:r,templateShareable:false});return i};Z.prototype._onButtonGroupPress=function(e,t){var a=e.getSource();var i=A.resolveValue(t,a,a.getBindingContext().getPath());var r=i[0];this.getActions().fireAction(this,r.type,r.parameters)};Z.prototype._createIconGroupItem=function(e,t){var a=e.template;if(!a){return null}var i=new G({avatarDisplaySize:e.size||N.XS,groupType:J.Individual,visible:x.reuse(t)});i._oShowMoreButton.setType(W.Transparent);i._oShowMoreButton.setEnabled(false);if(a.actions){i.attachPress(function(e){this._onIconGroupPress(e,a.actions)}.bind(this))}else{i._setInteractive(false)}var r=new L({src:x.formattedProperty(a.icon.src,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this)),initials:a.icon.initials||a.icon.text,tooltip:a.icon.alt});i.bindAggregation("items",{path:e.path||"/",template:r,templateShareable:false});return i};Z.prototype._onIconGroupPress=function(e,t){if(e.getParameter("overflowButtonPressed")){}else{var a=e.getParameter("eventSource");var i=A.resolveValue(t,a,a.getBindingContext().getPath());var r=i[0];this.getActions().fireAction(this,r.type,r.parameters)}};Z.prototype._createComboBoxItem=function(e,t,a,i){var r=this._getForm(),o={visible:x.reuse(t),placeholder:e.placeholder,required:r.getRequiredValidationValue(e)},n,s;if(e.selectedKey){o.selectedKey=e.selectedKey}else if(e.value){o.value=e.value}n=new f(o);if(a){a.setLabelFor(n)}if(e.item){s=new M({key:e.item.template.key,text:e.item.template.title});n.bindItems({path:e.item.path||"/",template:s,templateShareable:false})}r.addControl("change",n,e,i);return n};Z.prototype.setFormFieldValue=function(e){this._getForm().setControlValue(e)};Z.prototype._createTextAreaItem=function(e,t,a,i){var r=this._getForm(),o=new g({required:r.getRequiredValidationValue(e),value:e.value,visible:x.reuse(t),rows:e.rows,placeholder:e.placeholder});if(a){a.setLabelFor(o)}r.addControl("liveChange",o,e,i);return o};Z.prototype._createInputItem=function(e,t,a,i){var r=this._getForm(),o=new h({required:r.getRequiredValidationValue(e),value:e.value,visible:x.reuse(t),placeholder:e.placeholder});if(a){a.setLabelFor(o)}r.addControl("liveChange",o,e,i);return o};Z.prototype._createDurationItem=function(e,t,a,i){var r=this._getForm(),o=new v({valueFormat:"HH:mm",displayFormat:"HH:mm",support2400:true,required:r.getRequiredValidationValue(e),value:x.formattedProperty(e.value,P.fromISO),visible:x.reuse(t),placeholder:e.placeholder});if(a){a.setLabelFor(o)}r.addControl("change",o,e,i);return o};Z.prototype._createRatingIndicatorItem=function(e,t){var a=new d({editable:false,displayOnly:true,maxValue:e.maxValue,value:e.value,visualMode:e.visualMode,visible:x.reuse(t),iconSize:"1rem"});return a};Z.prototype._createImageItem=function(e,t){var a=x.formattedProperty(e.src,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this));var i;var r=new m({src:a,alt:e.alt,height:e.height});if(e.imageFit||e.imagePosition){r.setMode(Y.Background);r.setBackgroundSize(e.imageFit);r.setBackgroundPosition(e.imagePosition)}if(e.overlay){r.addStyleClass("sapUiIntImgWithOverlayImg");i=new R({image:r,tooltip:e.tooltip,supertitle:e.overlay.supertitle,title:e.overlay.title,subTitle:e.overlay.subTitle,verticalPosition:e.overlay.verticalPosition,horizontalPosition:e.overlay.horizontalPosition,textColor:e.overlay.textColor,textFilter:e.overlay.textFilter,background:e.overlay.background,padding:e.overlay.padding,animation:e.overlay.animation,visible:x.reuse(t)}).addStyleClass("sapFCardObjectImage");this.addStyleClass("sapFCardObjectContentWithOverlay")}else{r.setTooltip(e.tooltip);r.setVisible(x.reuse(t));r.addStyleClass("sapFCardObjectImage");i=r}if(e.fullWidth){i.addStyleClass("sapFCardObjectImageFullWidth")}const o=()=>{r.detachError(o);const t=this._oIconFormatter.formatSrc(A.resolveValue(e.fallbackSrc,this));if(t&&t!==r.getSrc()){r.setSrc(t)}};r.attachError(o);return i};Z.prototype._createDateRangeItem=function(e,t,a,i){var r={options:["date"],value:e.value,placeholder:e.placeholder};var o=this._getForm();var n=T.createInput(r,this.getCardInstance(),true);if(x.isBindingInfo(t)){n.bindProperty("visible",x.reuse(t))}else{n.setVisible(t)}n.setRequired(o.getRequiredValidationValue(e));if(a){a.setLabelFor(n)}o.addControl("change",n,e,i);return n};Z.prototype._createAFLayout=function(){var e=new F;e.addEventDelegate({onAfterRendering:function(){this.getContent().forEach(function(e){if(!e.getVisible()){document.getElementById("sap-ui-invisible-"+e.getId()).parentElement.classList.add("sapFCardInvisibleContent")}})}},e);return e};Z.prototype._onResize=function(e){if(e.size.width===e.oldSize.width){return}var t=this._getRootContainer().getItems();t.forEach(function(a,i){if(a.isA("sap.ui.layout.AlignedFlowLayout")){this._onAlignedFlowLayoutResize(a,e,i===t.length-1)}}.bind(this))};Z.prototype._onAlignedFlowLayoutResize=function(e,t,a){var i=e.getMinItemWidth(),r,o=e.getContent().filter(function(e){return e.getVisible()}).length;if(i.lastIndexOf("rem")!==-1){r=w.toPx(i)}else if(i.lastIndexOf("px")!==-1){r=parseFloat(i)}var n=Math.floor(t.size.width/r);if(n>o){n=o}var s=n-1,l=Math.ceil(o/n);e.getContent().forEach(function(e,t){e.addStyleClass("sapFCardObjectSpaceBetweenGroup");if(s===t&&s<o){e.removeStyleClass("sapFCardObjectSpaceBetweenGroup");s+=n}if(a&&t+1>(l-1)*n){e.addStyleClass("sapFCardObjectGroupLastInColumn")}else{e.removeStyleClass("sapFCardObjectGroupLastInColumn")}})};return Z});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/ObjectContentRenderer", ["./BaseContentRenderer"],function(e){"use strict";var n=e.extend("sap.ui.integration.cards.ObjectContentRenderer",{apiVersion:2,MIN_OBJECT_CONTENT_HEIGHT:"3rem"});n.getMinHeight=function(e,t){return n.MIN_OBJECT_CONTENT_HEIGHT};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/TableContent", ["./BaseListContent","./TableContentRenderer","sap/ui/integration/library","sap/f/cards/loading/TablePlaceholder","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/Text","sap/m/Link","sap/m/ProgressIndicator","sap/m/ObjectIdentifier","sap/ui/integration/controls/ObjectStatus","sap/m/Avatar","sap/ui/core/library","sap/m/library","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper","sap/base/Log","sap/ui/integration/util/SorterHelper"],function(t,e,i,n,r,o,a,s,l,c,p,g,h,d,u,f,m,y,v){"use strict";var C=u.AvatarSize;var b=u.AvatarColor;var I=u.AvatarImageFitType;var w=d.VerticalAlign;var T=u.ListSeparators;var _=u.ListType;var A=i.CardActionArea;var S=t.extend("sap.ui.integration.cards.TableContent",{metadata:{library:"sap.ui.integration"},renderer:e});S.prototype.onBeforeRendering=function(){t.prototype.onBeforeRendering.apply(this,arguments);this._getTable().setBackgroundDesign(this.getDesign())};S.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy();this._oItemTemplate=null}};S.prototype.createLoadingPlaceholder=function(t){var i=this.getCardInstance(),r=i.getContentMinItems(t);return new n({minItems:r!==null?r:2,itemHeight:e.getItemMinHeight(t,this)+"rem",columns:t.row?t.row.columns.length||2:2})};S.prototype._getTable=function(){if(this._bIsBeingDestroyed){return null}var t=this.getAggregation("_content");if(!t){t=new r({id:this.getId()+"-Table",showSeparators:T.None,ariaLabelledBy:this.getHeaderTitleId()});t.addEventDelegate({onfocusin:function(t){if(!(t.srcControl instanceof a)){return}var e=t.target.getBoundingClientRect().bottom;var i=this.getDomRef().getBoundingClientRect().bottom;var n=Math.abs(e-i);var r=10;if(n<r){t.srcControl.addStyleClass("sapUiIntTCIRoundedCorners")}}},this);this.setAggregation("_content",t)}return t};S.prototype.applyConfiguration=function(){t.prototype.applyConfiguration.apply(this,arguments);var e=this.getParsedConfiguration();if(!e){return}if(e.rows&&e.columns){this._setStaticColumns(e.rows,e.columns);return}if(e.row&&e.row.columns){this._setColumns(e.row)}};S.prototype.getStaticConfiguration=function(){var t=this.getInnerList().getItems(),e=this.getParsedConfiguration(),i=t[0]&&t[0].isA("sap.m.GroupHeaderListItem"),n=[],r=[],o=[],a,s;(e.row.columns||[]).forEach(function(t){t=f.resolveValue(t,this,this.getBindingContext().getPath());n.push(t)}.bind(this));t.forEach(function(t){if(t.isA("sap.m.GroupHeaderListItem")){if(s){o.push(s)}r=[];s={title:t.getTitle(),rows:r}}else{a=f.resolveValue(e.row,this,t.getBindingContext().getPath());(a.columns||[]).forEach(function(t){delete t.title;delete t.width;delete t.hAlign;delete t.visible;delete t.identifier;if(t.icon&&t.icon.src){t.icon.src=this._oIconFormatter.formatSrc(t.icon.src)}}.bind(this));r.push(a)}}.bind(this));if(s){o.push(s)}var l={headers:n};if(i){l.groups=o}else{l.groups=[{rows:r}]}return l};S.prototype.getItemsLength=function(){return this._getTable().getItems().filter(t=>!t.isA("sap.m.GroupHeaderListItem")).length};S.prototype.onDataChanged=function(){t.prototype.onDataChanged.apply(this,arguments);this._checkHiddenNavigationItems(this.getParsedConfiguration().row)};S.prototype._setColumns=function(t){var e=[],i=this._getTable(),n=t.columns;n.forEach(function(t){i.addColumn(new o({header:new s({text:t.title}),width:t.width,hAlign:t.hAlign,visible:t.visible}));e.push(this._createCell(t))}.bind(this));this._oItemTemplate=new a({cells:e,vAlign:w.Middle,highlight:t.highlight,highlightText:t.highlightText});this._oActions.attach({area:A.ContentItem,actions:t.actions,control:this,actionControl:this._oItemTemplate,enabledPropertyName:"type",enabledPropertyValue:_.Active,disabledPropertyValue:_.Inactive});var r=this.getParsedConfiguration().group;if(r){this._oSorter=v.getGroupSorter(r)}var l={template:this._oItemTemplate,sorter:this._oSorter};this._bindAggregationToControl("items",i,l)};S.prototype._setStaticColumns=function(t,e){var i=this._getTable();e.forEach(function(t){i.addColumn(new o({header:new s({text:t.title}),width:t.width,hAlign:t.hAlign}))});t.forEach(function(t){var e=new a({vAlign:w.Middle,highlight:t.highlight,highlightText:t.highlightText});if(t.cells&&Array.isArray(t.cells)){for(var n=0;n<t.cells.length;n++){e.addCell(this._createCell(t.cells[n]))}}if(t.actions&&Array.isArray(t.actions)){this._oActions.attach({area:A.ContentItem,actions:t.actions,control:this,actionControl:e,enabledPropertyName:"type",enabledPropertyValue:_.Active,disabledPropertyValue:_.Inactive})}i.addItem(e)}.bind(this));this.fireEvent("_actionContentReady")};S.prototype._createCell=function(t){var e;if(t.identifier){if(typeof t.identifier=="object"){if(!m.isBindingInfo(t.identifier)){y.warning("Usage of object type for column property 'identifier' is deprecated.",null,"sap.ui.integration.widgets.Card")}if(t.identifier.url){t.actions=[{type:"Navigation",parameters:{url:t.identifier.url,target:t.identifier.target}}]}}e=new p({title:t.value,text:t.additionalText});if(t.actions){e.setTitleActive(true);this._oActions.attach({area:A.ContentItemDetail,actions:t.actions,control:this,actionControl:e,enabledPropertyName:"titleActive",eventName:"titlePress"})}return e}if(t.url){y.warning("Usage of column property 'url' is deprecated. Use card actions for navigation.",null,"sap.ui.integration.widgets.Card");t.actions=[{type:"Navigation",parameters:{url:t.url,target:t.target}}]}if(t.actions){e=new l({text:t.value});this._oActions.attach({area:A.ContentItemDetail,actions:t.actions,control:this,actionControl:e,enabledPropertyName:"enabled"});return e}if(t.state){return new g({text:t.value,state:t.state,showStateIcon:t.showStateIcon,customIcon:t.customStateIcon})}if(t.value){return new s({text:t.value})}if(t.icon){var i=m.formattedProperty(t.icon.src,function(t){return this._oIconFormatter.formatSrc(t)}.bind(this));var n=t.icon.initials||t.icon.text;return new h({src:i,displayShape:t.icon.shape,displaySize:t.icon.size||C.XS,tooltip:t.icon.alt,initials:n,backgroundColor:t.icon.backgroundColor||(n?undefined:b.Transparent),imageFitType:t.icon.fitType||I.Cover,visible:t.icon.visible}).addStyleClass("sapFCardIcon")}if(t.progressIndicator){return new c({percentValue:t.progressIndicator.percent,displayValue:t.progressIndicator.text,state:t.progressIndicator.state})}};S.prototype.getInnerList=function(){return this._getTable()};return S});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/TableContentRenderer", ["./BaseListContentRenderer","../library"],function(t,e){"use strict";var n=t.extend("sap.ui.integration.cards.TableContentRenderer",{apiVersion:2});n.getMinHeight=function(t,e,n){if(e._fMinHeight){return e._fMinHeight+"px"}var i=n.getContentMinItems(t);if(i==null){return this.DEFAULT_MIN_HEIGHT}var r=this.isCompact(e),a=r?2:2.75,s=r?2:2.75;return i*a+s+"rem"};n.getItemMinHeight=function(t,e){if(!t||!t.row){return 0}var n=this.isCompact(e);return n?2:2.75};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/TimelineContent", ["./BaseListContent","./TimelineContentRenderer","sap/f/cards/loading/TimelinePlaceholder","sap/ui/core/Lib","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver"],function(e,t,i,n,o,r,a){"use strict";var s=o.CardActionArea;var m,c;var l=e.extend("sap.ui.integration.cards.TimelineContent",{metadata:{library:"sap.ui.integration"},renderer:t});l.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oTimeLineItemTemplate){this._oTimeLineItemTemplate.destroy();this._oTimeLineItemTemplate=null}};l.prototype.createLoadingPlaceholder=function(e){var n=this.getCardInstance(),o=n.getContentMinItems(e);return new i({minItems:o!==null?o:2,item:e.item,itemHeight:t.getItemMinHeight(e,this)+"rem"})};l.prototype.loadDependencies=function(e){return new Promise(function(e,t){n.load("sap.suite.ui.commons").then(function(){sap.ui.require(["sap/suite/ui/commons/Timeline","sap/suite/ui/commons/TimelineItem"],function(t,i){m=t;c=i;e()},function(e){t(e)})}).catch(function(){t("Timeline content type is not available with this distribution.")})})};l.prototype._getTimeline=function(){var e=this.getAggregation("_content");if(this._bIsBeingDestroyed){return null}if(!e){e=new m({id:this.getId()+"-Timeline",showHeaderBar:false,enableScroll:false,growingThreshold:0,ariaLabelledBy:this.getHeaderTitleId()});this.setAggregation("_content",e)}return e};l.prototype.applyConfiguration=function(){e.prototype.applyConfiguration.apply(this,arguments);var t=this.getParsedConfiguration();if(!t){return}if(t.items){this._setStaticItems(t.items);return}if(t.item){this._setItem(t.item)}};l.prototype.getItemsLength=function(){return this._getTimeline().getContent().length};l.prototype.onDataChanged=function(){e.prototype.onDataChanged.apply(this,arguments);this._checkHiddenNavigationItems(this.getParsedConfiguration().item)};l.prototype._setItem=function(e){var t={userNameClickable:false,title:e.title&&e.title.value,text:e.description&&e.description.value,dateTime:e.dateTime&&e.dateTime.value,userName:e.owner&&e.owner.value,icon:e.icon&&e.icon.src};if(e.ownerImage&&e.ownerImage.value){t.userPicture=r.formattedProperty(e.ownerImage.value,function(e){return this._oIconFormatter.formatSrc(e)}.bind(this))}this._oTimeLineItemTemplate=new c(t);this._oActions.attach({area:s.ContentItem,actions:e.actions,control:this,actionControl:this._oTimeLineItemTemplate,eventName:"select"});var i={template:this._oTimeLineItemTemplate};this._bindAggregationToControl("content",this._getTimeline(),i);return this};l.prototype._setStaticItems=function(e){var t=this._getTimeline(),i;e.forEach(function(e){i=new c({title:e.title,text:e.description,userPicture:e.ownerImage,dateTime:e.dateTime,userName:e.owner,icon:e.icon});t.addContent(i)})};l.prototype.getInnerList=function(){return this._getTimeline()};l.prototype.getStaticConfiguration=function(){var e=this.getInnerList().getContent(),t=this.getParsedConfiguration(),i=[];e.forEach(function(e){var n=a.resolveValue(t.item,this,e.getBindingContext().getPath());if(n.icon&&n.icon.src){n.icon.src=this._oIconFormatter.formatSrc(n.icon.src)}if(n.ownerImage&&n.ownerImage.value){n.ownerImage.value=this._oIconFormatter.formatSrc(n.ownerImage.value)}i.push(n)}.bind(this));var n={items:i};return n};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/TimelineContentRenderer", ["./BaseListContentRenderer"],function(e){"use strict";var t=e.extend("sap.ui.integration.cards.TimelineContentRenderer",{apiVersion:2});t.getMinHeight=function(e,t,n){if(t._fMinHeight){return t._fMinHeight+"px"}var i=n.getContentMinItems(e);if(i==null){return this.DEFAULT_MIN_HEIGHT}var r=this.getItemMinHeight(e,t);return i*r+"rem"};t.getItemMinHeight=function(e,t){if(!e||!e.item){return 0}return e.item.ownerImage?7:5.625};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/WebPageContent", ["./BaseContent","./WebPageContentRenderer","sap/ui/util/isCrossOriginURL","sap/m/IllustratedMessageType","sap/ui/integration/util/BindingHelper"],function(e,t,i,r,a){"use strict";var n="_frameLoaded";var o=15*1e3;var s=e.extend("sap.ui.integration.cards.WebPageContent",{metadata:{properties:{minHeight:{type:"sap.ui.core.CSSSize",defaultValue:t.MIN_WEB_PAGE_CONTENT_HEIGHT,bindable:true},src:{type:"sap.ui.core.URI",bindable:true},sandbox:{type:"string",defaultValue:"",bindable:true},allow:{type:"string",bindable:true},allowFullscreen:{type:"boolean",defaultValue:false,bindable:true},omitSandbox:{type:"boolean",defaultValue:false,bindable:true}},library:"sap.ui.integration"},renderer:t});s.prototype.init=function(){e.prototype.init.apply(this,arguments);this._onFrameLoadedBound=this._onFrameLoaded.bind(this);this._sPrevSrc=this.getSrc();this.attachEventOnce("_dataReady",()=>{this._bDataReady=true})};s.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._iLoadTimeout){clearTimeout(this._iLoadTimeout)}};s.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.apply(this,arguments);if(this.getDomRef("frame")){this.getDomRef("frame").removeEventListener("load",this._onFrameLoadedBound)}const t=this.getSrc();if(this._isDataReady()&&t!==undefined&&this._sPrevSrc!==t){this._sPrevSrc=t;if(this._checkSrc()){this._bSrcChecked=true;this._raceFrameLoad()}}};s.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);if(this.getDomRef("frame")){this.getDomRef("frame").addEventListener("load",this._onFrameLoadedBound)}};s.prototype.applyConfiguration=function(){const e=this.getParsedConfiguration();this.fireEvent("_actionContentReady");if(!e){return}this.applySettings({src:a.formattedProperty(e.src,e=>this._oIconFormatter.formatSrc(e)),sandbox:e.sandbox,minHeight:e.minHeight,allow:e.allow,allowFullscreen:e.allowFullscreen||e.allowfullscreen,omitSandbox:e.omitSandbox})};s.prototype._supportsOverflow=function(){return false};s.prototype._isDataReady=function(){if(!this.getCardInstance()){return this._bDataReady}return this._bDataReady&&this.getCardInstance().isDataReady()};s.prototype._checkSrc=function(){const e=this.getCardInstance(),t=this.getSrc();if(!e){return false}if(!t){this.handleError({illustrationType:r.ErrorScreen,title:e.getTranslatedText("CARD_WEB_PAGE_EMPTY_URL_ERROR"),description:e.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION")});return false}if(i(t)&&!t.startsWith("https")){this.handleError({illustrationType:r.ErrorScreen,title:e.getTranslatedText("CARD_WEB_PAGE_HTTPS_URL_ERROR"),description:e.getTranslatedText("CARD_ERROR_REQUEST_ACCESS_DENIED_DESCRIPTION")});return false}return true};s.prototype._raceFrameLoad=function(){this.awaitEvent(n);if(this._iLoadTimeout){clearTimeout(this._iLoadTimeout)}this._iLoadTimeout=setTimeout(function(){this.fireEvent(n);var e=o/1e3,t=this.getCardInstance();this.handleError({illustrationType:r.ReloadScreen,title:t.getTranslatedText("CARD_WEB_PAGE_TIMEOUT_ERROR",[e]),details:"Failed to load '"+this.getSrc()+"' after "+e+" seconds."})}.bind(this),o)};s.prototype._onFrameLoaded=function(){this.fireEvent(n);clearTimeout(this._iLoadTimeout)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/WebPageContentRenderer", ["./BaseContentRenderer","sap/ui/integration/util/BindingResolver"],function(e,t){"use strict";var n="2px";var r=e.extend("sap.ui.integration.cards.WebPageContentRenderer",{apiVersion:2,MIN_WEB_PAGE_CONTENT_HEIGHT:"150px"});r.renderContent=function(e,t){e.openStart("iframe",t.getId()+"-frame").class("sapUiIntWPCFrame");if(!t.getOverflowWithShowMore()){e.style("height","calc("+t.getMinHeight()+" - "+n+")")}if(t._bSrcChecked){e.attr("src",t.getSrc())}e.attr("tabindex","0");if(!t.getOmitSandbox()){e.attr("sandbox",t.getSandbox())}if(t.getAllow()){e.attr("allow",t.getAllow())}if(t.getAllowFullscreen()){e.attr("allowfullscreen",t.getAllowFullscreen())}e.openEnd().close("iframe")};r.getMinHeight=function(e,n){if(e.minHeight){return t.resolveValue(e.minHeight,n)}return r.MIN_WEB_PAGE_CONTENT_HEIGHT};r.renderLoadingPlaceholder=function(e,t){e.renderControl(t.getAggregation("_loadingPlaceholder"))};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/BaseAction", ["sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/integration/util/BindingResolver"],function(e,t,n){"use strict";var i=e.extend("sap.ui.integration.cards.actions.BaseAction",{metadata:{library:"sap.ui.integration",properties:{config:{type:"object"},parameters:{type:"object"},actionHandler:{type:"object"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false},source:{type:"sap.ui.base.EventProvider",multiple:false}}}});i.prototype.execute=function(){};i.prototype.getResolvedConfig=function(){var e=this.getSourceInstance(),t=e.getBindingContext(),i;if(t){i=e.getBindingContext().getPath()}return n.resolveValue(this.getConfig(),e,i)};i.prototype.getCardInstance=function(){return t.getElementById(this.getCard())};i.prototype.getSourceInstance=function(){return t.getElementById(this.getSource())};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/CardActions", ["sap/ui/integration/library","sap/base/Log","sap/ui/base/ManagedObject","sap/ui/integration/cards/actions/CustomAction","sap/ui/integration/cards/actions/DateChangeAction","sap/ui/integration/cards/actions/MonthChangeAction","sap/ui/integration/cards/actions/SubmitAction","sap/ui/integration/cards/actions/NavigationAction","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/base/strings/capitalize","sap/base/util/deepClone","sap/ui/integration/cards/actions/ShowCardAction","sap/ui/integration/cards/actions/HideCardAction"],function(e,t,a,n,i,r,o,s,c,l,u,d,f,p){"use strict";function g(e){if(e&&typeof e==="object"){return e.name}return e}var h=e.CardActionArea,v=e.CardActionType;var b=a.extend("sap.ui.integration.cards.actions.CardActions",{metadata:{library:"sap.ui.integration",properties:{card:{type:"object"},bindingPathResolver:{type:"function"}}}});b.prototype.attach=function(e){var t=e.control,a=e.area;e.actionControl=e.actionControl||e.control;e.enabledPropertyValue=e.enabledPropertyValue!==undefined?e.enabledPropertyValue:true;e.disabledPropertyValue=e.disabledPropertyValue||false;e.eventName=e.eventName||"press";if(!e.actions){this._fireActionReady(t,a);return}var n=e.actions[0];if(n&&n.type){e.action=n;this._attachAction(e)}else{this._fireActionReady(t,a)}};b.prototype._attachAction=function(e){var t=e.action,a=e.area,n=e.control,i=e.enabledPropertyName,r=true,o=this._isSingleAction(a),s=true;if(i){r=false;if(t.service&&!o){this._setControlEnabledStateUsingService(e)}else{this._setControlEnabledState(e)}}if(t.service&&o){this._getSingleActionEnabledState(t,n).then(function(t){if(t){this._attachEventListener(e)}this._fireActionReady(n,a)}.bind(this));return}if(r){s=t.enabled!==false&&t.enabled!=="false"}if(s){this._attachEventListener(e)}this._fireActionReady(n,a)};b.prototype._setControlEnabledStateUsingService=function(e){var t=e.action,n=e.control,i=e.actionControl,r=e.enabledPropertyName,o=e.enabledPropertyValue,s=e.disabledPropertyValue,c=a.bindingParser("{path:''}");c.formatter=function(e){var a=this.getBindingContext(),i,r;if(a){i=a.getPath()}r=l.resolveValue(t.parameters,n,i);if(e.__resolved){if(!e.__enabled||e.__enabled==="false"){return s}return o}if(!e.__promise){e.__promise=true;n._oServiceManager.getService(g(t.service)).then(function(t){if(t){t.enabled({parameters:r}).then(function(t){e.__resolved=true;e.__enabled=t;n.getModel().checkUpdate(true)}).catch(function(){e.__resolved=true;e.__enabled=false})}else{e.__resolved=true;e.__enabled=false}})}return s};i.bindProperty(r,c)};b.prototype._setControlEnabledState=function(e){var t=e.action,a=e.actionControl,n=e.enabledPropertyName,i=e.enabledPropertyValue,r=e.disabledPropertyValue,o,s;if(typeof t.enabled==="object"){o=c.formattedProperty(t.enabled,function(e){if(!e||e==="false"){return r}return i})}if(o){a.bindProperty(n,o)}else{s=t.enabled===false||t.enabled==="false"?r:i;a.setProperty(n,s)}};b.prototype._getSingleActionEnabledState=function(e,t){var a=t.getBindingContext(),n,i;if(a){i=a.getPath()}n=l.resolveValue(e.parameters,t,i);return new Promise(function(a){t._oServiceManager.getService(g(e.service)).then(function(e){if(e){e.enabled({parameters:n}).then(function(e){a(e)}).catch(function(){a(false)})}else{a(false)}}).catch(function(){a(false)})})};b.prototype._fireActionReady=function(e,t){var a=t===h.Header;var n=a?"_actionHeaderReady":"_actionContentReady";e.fireEvent(n)};b.prototype._resolveBindingPath=function(e){var t=e.getSource().getBindingContext(),a;if(this.getBindingPathResolver()){a=this.getBindingPathResolver()(e)}else if(t){a=t.getPath()}return a};b.prototype._handleServiceAction=function(e,a,n){var i=e.getSource();var r=this._resolveBindingPath(e);n._oServiceManager.getService(g(a.service)).then(function(e){if(e){e.navigate({parameters:l.resolveValue(a.parameters,i,r)})}}).catch(function(e){t.error("Navigation service unavailable",e)}).finally(function(){this._processAction(i,a,r)}.bind(this))};b.prototype._attachEventListener=function(e){var t=e.action;e.actionControl["attach"+u(e.eventName)](function(a){const n=a.getSource();const i=a.getParameter("originalEvent");if(i){i.stopPropagation();if(e.actionControl.getFocusDomRef()?.matches(":has(:focus-within)")){return}}if(t.service){this._handleServiceAction(a,t,e.control)}else{this._processAction(n,t,this._resolveBindingPath(a))}}.bind(this))};b.prototype._processAction=function(e,t,a){var n=this._getHostInstance(),i=this.getCard();b.fireAction({card:i,host:n,action:t,parameters:l.resolveValue(t.parameters,e,a),source:e})};b.prototype._getHostInstance=function(){var e=this.getCard();if(e){return e.getHostInstance()}return null};b.prototype.fireAction=function(e,t,a){b.fireAction({card:this.getCard(),host:this._getHostInstance(),action:{type:t},parameters:a,source:e})};b.fireAction=function(e){var t=e.host,a=e.card,n=a.getAggregation("_extension"),i=e.action.type,r=d(e.parameters,100)||{},o={type:i,card:a,actionSource:e.source},s,c=true;if(i===v.Submit||i===v.Custom){o.formData=a.getModel("form").getData()}if(i===v.Submit){r.data=r.data??a.getModel("form").getData()}o.parameters=r;s=Object.assign({},o,{manifestParameters:r});if(n){c=n.fireAction(o)}if(!c){return false}c=a.fireAction(s);if(!c){return false}if(t){c=t.fireAction(o)}if(!c){return false}var l=b._createHandler(e);if(l){l.execute();l.destroy()}return true};b.prototype._isSingleAction=function(e){return[h.Header,h.Content,h.ContentItemDetail,h.ActionsStrip].indexOf(e)>-1};b._createHandler=function(e){var a=null;switch(e.action.type){case v.Custom:a=n;break;case v.DateChange:a=i;break;case v.HideCard:a=p;break;case v.MonthChange:a=r;break;case v.Navigation:a=s;break;case v.ShowCard:a=f;break;case v.Submit:a=o;break;default:t.error("Unknown action type '"+e.action.type+"'. Expected one of "+Object.values(v).join(", "),null,"sap.ui.integration.widgets.Card")}if(a){return new a({config:e.action,parameters:e.parameters,actionHandler:e.card.getManifestEntry("/sap.card/configuration/actionHandlers/"+e.action.type.toLowerCase()),card:e.card,source:e.source})}return null};return b});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/CustomAction", ["./BaseAction"],function(t){"use strict";var i=t.extend("sap.ui.integration.cards.actions.CustomAction",{metadata:{library:"sap.ui.integration"}});i.prototype.execute=function(){var t=this.getConfig();if(typeof t.action==="function"){t.action(this.getCardInstance(),this.getSourceInstance())}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/DateChangeAction", ["./BaseAction"],function(a){"use strict";var t=a.extend("sap.ui.integration.cards.actions.DateChangeAction",{metadata:{library:"sap.ui.integration"}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/HideCardAction", ["./BaseAction","sap/m/Dialog"],function(t,e){"use strict";var a=t.extend("sap.ui.integration.cards.actions.HideCardAction",{metadata:{library:"sap.ui.integration"}});a.prototype.execute=function(){var t=this.getCardInstance(),a=t.getParent(),n=t.getHostInstance();if(n&&n.onHideCard){n.onHideCard(t);return}if(a instanceof e){a.close();a.attachAfterClose(function(){t.destroy()})}else{t.destroy()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/MonthChangeAction", ["./BaseAction"],function(t){"use strict";var a=t.extend("sap.ui.integration.cards.actions.MonthChangeAction",{metadata:{library:"sap.ui.integration"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/NavigationAction", ["./BaseAction","sap/ui/util/openWindow"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.cards.actions.NavigationAction",{metadata:{library:"sap.ui.integration"}});i.prototype.execute=function(){var t=this.getResolvedConfig();if(t.service){return}var e=this.getParameters(),n,r,a,o;if(e){a=e.url;o=e.target}n=t.url||a;r=t.target||o||i.DEFAULT_TARGET;if(n){this._openUrl(n,r)}};i.prototype._openUrl=function(t,i){e(t,i)};i.DEFAULT_TARGET="_blank";return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/ShowCardAction", ["./BaseAction","sap/ui/integration/util/openCardDialog","sap/ui/core/Element","sap/ui/dom/jquery/Focusable"],function(e,t,a){"use strict";var r=e.extend("sap.ui.integration.cards.actions.ShowCardAction",{metadata:{library:"sap.ui.integration"}});r.prototype.execute=function(){var e=this.getParameters()||{},r=this.getCardInstance(),i=r.getHostInstance();if(i&&i.onShowCard){let t;if(e._cardId){t=a.getElementById(e._cardId)}else{t=r._createChildCard(e)}i.onShowCard(t,e);return}t(r,this.getParameters())};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/actions/SubmitAction", ["./BaseAction","sap/base/Log","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/Utils"],function(t,e,n,i,a){"use strict";var r=t.extend("sap.ui.integration.cards.actions.SubmitAction",{metadata:{library:"sap.ui.integration"}});r.prototype.execute=function(){var t=this.getCardInstance(),n=this.getActionHandler();if(!t.validateControls()){return}if(!n){return}var i=this.getCardInstance()._oDataProviderFactory,a=t.getModel("form").getData();this._onActionSubmitStart(a);var r=i.create({request:this._createRequest(n,a)},undefined,undefined,true);r.getData().then(function(t){this._onActionSubmitEnd(t,null)}.bind(this),function(t){e.error(t);this._onActionSubmitEnd(null,{error:t})}.bind(this)).finally(function(){i.remove(r)})};r.prototype._onActionSubmitStart=function(t){var e=this.getSourceInstance();if(e.isA("sap.ui.integration.cards.BaseContent")){e.onActionSubmitStart(t)}};r.prototype._onActionSubmitEnd=function(t,e){var n=this.getSourceInstance();if(n.isA("sap.ui.integration.cards.BaseContent")){n.onActionSubmitEnd(t,e)}};r.prototype._createRequest=function(t,e){var r={mode:t.mode||"cors",url:t.url,method:t.method||"POST",parameters:t.parameters||e,headers:t.headers,withCredentials:!!t.withCredentials};r=i.resolveValue(n.createBindingInfos(r,this.getCardInstance().getBindingNamespaces()),this.getSourceInstance());a.makeUndefinedValuesNull(r.parameters);return r};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputChoiceSet", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(t,e){"use strict";function i(){t.ChoiceSetInput.apply(this,arguments)}i.prototype=Object.create(t.ChoiceSetInput.prototype);i.prototype.overrideInternalRender=function(){var i=t.TextInput.prototype.overrideInternalRender.call(this,arguments);e.overwriteLabel(this);e.overwriteRequired(this);return i};i.prototype.internalRender=function(){if(!this.isMultiSelect){if(this.isCompact){this._selectElement=document.createElement("ui5-select");this._selectElement.id=this.id;this._selectElement.addEventListener("change",function(){this.valueChanged()}.bind(this));var t=document.createDocumentFragment();for(var e=0;e<this.choices.length;e++){var i=document.createElement("ui5-option");i.value=this.choices[e].value;i.textContent=this.choices[e].title;if(this.choices[e].value===this.defaultValue){i.selected=true}t.appendChild(i)}this._selectElement.appendChild(t);return this._selectElement}var n=document.createElement("div");n.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");n.id=this.id;n.setAttribute("role","radiogroup");n.addEventListener("change",function(){this.valueChanged()}.bind(this));this._toggleInputs=[];for(var s=0;s<this.choices.length;s++){var r=document.createElement("ui5-radio-button");r.value=this.choices[s].value;r.text=this.choices[s].title;r.name=this.id;r.wrappingType=this.wrap?"Normal":"None";if(this.choices[s].value===this.defaultValue){r.checked=true}this._toggleInputs.push(r);n.appendChild(r)}return n}var l=this.defaultValue?this.defaultValue.split(","):null;var a=document.createElement("div");a.classList.add("sapFCardAdaptiveContentChoiceSetWrapper");a.setAttribute("role","group");a.id=this.id;a.addEventListener("change",function(){this.valueChanged()}.bind(this));this._toggleInputs=[];for(var o=0;o<this.choices.length;o++){var u=document.createElement("ui5-checkbox");u.value=this.choices[o].value;u.text=this.choices[o].title;u.name=this.id;u.wrappingType=this.wrap?"Normal":"None";if(l&&l.indexOf(this.choices[o].value)>=0){u.checked=true}this._toggleInputs.push(u);a.appendChild(u)}return a};Object.defineProperty(i.prototype,"value",{get:function t(){var e;if(!this.isMultiSelect){if(this.isCompact){return this._selectElement.selectedOption?this._selectElement.selectedOption.value:null}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null}for(e=0;e<this._toggleInputs.length;e++){if(this._toggleInputs[e].checked){return this._toggleInputs[e].value}}return null}}else{if(!this._toggleInputs||this._toggleInputs.length===0){return null}var i="";for(e=0;e<this._toggleInputs.length;e++){if(this._toggleInputs[e].checked){if(i!==""){i+=this.hostConfig.choiceSetInputValueSeparator}i+=this._toggleInputs[e].value}}return i===""?null:i}}});i.prototype.updateInputControlAriaLabelledBy=function(){var t=!this.isMultiSelect&&this.isCompact?"accessible-name-ref":"aria-labelledby";e.overwriteAriaLabelling(this,t)};i.prototype.showValidationErrorMessage=function(){if(!this._toggleInputs||!this._toggleInputs.length){return}this._toggleInputs.forEach(function(t){t.valueState="Error"})};i.prototype.resetValidationFailureCue=function(){t.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(!this._toggleInputs||!this._toggleInputs.length){return}this._toggleInputs.forEach(function(t){t.valueState="None"})};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputDate", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(t,e){"use strict";function n(){t.DateInput.apply(this,arguments)}n.prototype=Object.create(t.DateInput.prototype);n.prototype.overrideInternalRender=function(){var n=t.TextInput.prototype.overrideInternalRender.call(this,arguments);e.overwriteLabel(this);e.overwriteRequired(this);return n};n.prototype.internalRender=function(){this._dateInputElement=document.createElement("ui5-date-picker");this._dateInputElement.id=this.id;this._dateInputElement.placeholder=this.placeholder;this._dateInputElement.formatPattern="yyyy-MM-dd";this._dateInputElement.value=this.defaultValue||"";this._dateInputElement.minDate=this.min||"";this._dateInputElement.maxDate=this.max||"";e.createValueStateElement(this,this._dateInputElement);this._dateInputElement.addEventListener("input",function(){this.valueChanged()}.bind(this));return this._dateInputElement};n.prototype.updateInputControlAriaLabelledBy=function(){e.overwriteAriaLabelling(this,"accessible-name-ref")};n.prototype.showValidationErrorMessage=function(){if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="Error"}};n.prototype.resetValidationFailureCue=function(){t.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="None"}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputNumber", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(e,t){"use strict";function n(){e.NumberInput.apply(this,arguments)}n.prototype=Object.create(e.NumberInput.prototype);n.prototype.overrideInternalRender=function(){var n=e.TextInput.prototype.overrideInternalRender.call(this,arguments);t.overwriteLabel(this);t.overwriteRequired(this);return n};n.prototype.internalRender=function(){this._numberInputElement=document.createElement("ui5-step-input");this._numberInputElement.id=this.id;this._numberInputElement.placeholder=this.placeholder||"";this._numberInputElement.value=this.defaultValue||"";this._numberInputElement.min=this.min;this._numberInputElement.max=this.max;this._numberInputElement.style.width="13.125rem";t.createValueStateElement(this,this._numberInputElement);this._numberInputElement.addEventListener("input",function(e){this.valueChanged()}.bind(this));return this._numberInputElement};Object.defineProperty(n.prototype,"value",{get:function(){return this._numberInputElement?this._numberInputElement.value:undefined}});n.prototype.updateInputControlAriaLabelledBy=function(){t.overwriteAriaLabelling(this,"accessible-name-ref")};n.prototype.showValidationErrorMessage=function(){if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="Error"}};n.prototype.resetValidationFailureCue=function(){e.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="None"}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputText", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(e,t){"use strict";function r(){e.TextInput.apply(this,arguments)}r.prototype=Object.create(e.TextInput.prototype);r.prototype.overrideInternalRender=function(){var r=e.TextInput.prototype.overrideInternalRender.call(this,arguments);t.overwriteLabel(this);t.overwriteRequired(this);return r};r.prototype.internalRender=function(){if(this.isMultiline){var e=document.createElement("ui5-textarea");e.id=this.id;e.placeholder=this.placeholder||"";e.value=this.defaultValue||"";e.maxlength=this.maxLength||null;t.createValueStateElement(this,e);e.addEventListener("input",function(){this.valueChanged()}.bind(this));return e}var r=document.createElement("ui5-input");switch(this.style){case 1:r.type="Tel";break;case 2:r.type="URL";break;case 3:r.type="Email";break;default:r.type="Text"}r.id=this.id;r.placeholder=this.placeholder||"";r.value=this.defaultValue||"";r.maxlength=this.maxLength||null;t.createValueStateElement(this,r);r.addEventListener("input",function(){this.valueChanged()}.bind(this));return r};r.prototype.updateInputControlAriaLabelledBy=function(){t.overwriteAriaLabelling(this,"accessible-name-ref")};r.prototype.showValidationErrorMessage=function(){if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="Error"}};r.prototype.resetValidationFailureCue=function(){e.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="None"}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputTime", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(e,t){"use strict";function n(){e.TimeInput.apply(this,arguments)}var i="HH:mm";n.prototype=Object.create(e.TimeInput.prototype);n.prototype.overrideInternalRender=function(){var n=e.TextInput.prototype.overrideInternalRender.call(this,arguments);t.overwriteLabel(this);t.overwriteRequired(this);return n};n.prototype.internalRender=function(){var e="ui5-time-picker";this._timeInputElement=document.createElement(e);this._timeInputElement.id=this.id;this._timeInputElement.value=this.defaultValue||"";this._timeInputElement.formatPattern=i;t.createValueStateElement(this,this._timeInputElement);this._timeInputElement.addEventListener("input",function(e){this.valueChanged()}.bind(this));return this._timeInputElement};n.prototype.updateInputControlAriaLabelledBy=function(){t.overwriteAriaLabelling(this,"aria-labelledby")};n.prototype.showValidationErrorMessage=function(){if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="Error"}};n.prototype.resetValidationFailureCue=function(){e.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this.renderedInputControlElement){this.renderedInputControlElement.valueState="None"}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/UI5InputToggle", ["sap/ui/integration/thirdparty/adaptivecards","sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites"],function(e,t){"use strict";function n(){e.ToggleInput.apply(this,arguments)}n.prototype=Object.create(e.ToggleInput.prototype);n.prototype.overrideInternalRender=function(){var n=e.TextInput.prototype.overrideInternalRender.call(this,arguments);t.overwriteLabel(this);t.overwriteRequired(this);return n};n.prototype.internalRender=function(){this._checkboxInputElement=document.createElement("ui5-checkbox");this._checkboxInputElement.id=this.id;this._checkboxInputElement.text=this.title||"";this._checkboxInputElement.wrappingType=this.wrap?"Normal":"None";this._checkboxInputElement.checked=false;if(this.defaultValue===this.valueOn){this._checkboxInputElement.checked=true}this._checkboxInputElement.addEventListener("change",function(){this.valueChanged()}.bind(this));return this._checkboxInputElement};n.prototype.updateInputControlAriaLabelledBy=function(){t.overwriteAriaLabelling(this,"aria-labelledby")};n.prototype.showValidationErrorMessage=function(){if(this._checkboxInputElement){this._checkboxInputElement.valueState="Error"}};n.prototype.resetValidationFailureCue=function(){e.TextInput.prototype.resetValidationFailureCue.call(this,arguments);if(this._checkboxInputElement){this._checkboxInputElement.valueState="None"}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/elements/hostConfig", ["sap/ui/core/theming/Parameters"],function(e){"use strict";return function(){return{spacing:{small:8,default:16,medium:32,large:48,extraLarge:48,padding:16},separator:{lineThickness:1,lineColor:e.get("sapUiToolbarSeparatorColor")},supportsInteractivity:true,fontTypes:{default:{fontFamily:e.get("sapUiFontFamily"),fontSizes:{small:12,default:14,medium:14,large:16,extraLarge:20}},monospace:{}},containerStyles:{default:{backgroundColor:"transparent",foregroundColors:{default:{default:e.get("sapUiBaseText"),subtle:e.get("sapUiContentLabelColor")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},emphasis:{backgroundColor:e.get("sapTile_Background"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},accent:{backgroundColor:e.get("sapUiInformationBG"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},good:{backgroundColor:e.get("sapUiSuccessBG"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},attention:{backgroundColor:e.get("sapUiErrorBG"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}},warning:{backgroundColor:e.get("sapUiWarningBG"),foregroundColors:{default:{default:e.get("sapUiBaseText")},accent:{default:e.get("sapUiInformativeText")},attention:{default:e.get("sapUiNegativeText")},good:{default:e.get("sapUiPositiveText")},warning:{default:e.get("sapUiCriticalText")}}}}}}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/overwrites/ActionRender", ["sap/ui/integration/thirdparty/adaptivecards"],function(t){"use strict";return function(e){if(e===0){e="ac-pushButton"}var i=this.parent.hostConfig;var s=document.createElement("ui5-button");this.addCssClasses(s);s.setAttribute("aria-label",this.title);s.type="button";s.style.display="flex";s.style.alignItems="center";s.style.justifyContent="center";var n=this.style;if(n==="positive"){s.setAttribute("design","Positive")}else if(n==="destructive"){s.setAttribute("design","Negative")}var l=this.title;var a=document.createElement("div");a.style.overflow="hidden";a.style.textOverflow="ellipsis";if(!(i.actions.iconPlacement===t.ActionIconPlacement.AboveTitle||i.actions.allowTitleToWrap)){a.style.whiteSpace="nowrap"}if(l){a.innerText=this.title}if(!this.iconUrl){s.classList.add("noIcon");s.appendChild(a)}else{var o=document.createElement("img");o.src=this.iconUrl;o.style.width=i.actions.iconSize+"px";o.style.height=i.actions.iconSize+"px";o.style.flex="0 0 auto";if(i.actions.iconPlacement===t.ActionIconPlacement.AboveTitle){s.classList.add("iconAbove");s.style.flexDirection="column";if(l){o.style.marginBottom="4px"}}else{s.classList.add("iconLeft");if(l){o.style.marginRight="4px"}}s.appendChild(o);s.appendChild(a)}this._renderedElement=s}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/adaptivecards/overwrites/inputsGeneralOverwrites", ["sap/ui/core/InvisibleText","sap/ui/core/Lib"],function(e,t){"use strict";var r={};r.overwriteRequired=function(r){var n=r._renderedInputControlElement.getAttribute("role");if(n==="radiogroup"){return}r.renderedInputControlElement.removeAttribute("aria-required");if(!n){r.renderedInputControlElement.required=r.isRequired;return}if(n==="group"&&r.isRequired){var i=new e({id:r._renderedInputControlElement.id+"-InvisibleText",text:t.getResourceBundleFor("sap.ui.integration").getText("ADAPTIVE_CARDS_REQUIRED_FIELD")}).toStatic().getId();r.renderedInputControlElement.setAttribute("aria-describedby",i)}};r.overwriteLabel=function(e){if(!e._renderedLabelElement){return}var t=document.createElement("ui5-label");t.id=e._renderedLabelElement.id;t.innerText=e.label;t.for=e._renderedInputControlElement.id;t.required=e.isRequired;t.style.marginBottom=e.hostConfig.getEffectiveSpacing(e.hostConfig.inputs.label.inputSpacing)+"px";e._renderedLabelElement.remove();e._renderedLabelElement=t;e._outerContainerElement.insertBefore(e._renderedLabelElement,e.inputControlContainerElement)};r.overwriteAriaLabelling=function(e,t){if(!e._renderedInputControlElement){return}if(e._renderedLabelElement){e._renderedInputControlElement.setAttribute(t,e._renderedLabelElement.id)}else{e._renderedInputControlElement.removeAttribute(t)}};r.createValueStateElement=function(e,t){if(!e.errorMessage){return}var r=document.createElement("div");r.setAttribute("slot","valueStateMessage");r.innerText=e.errorMessage;t.appendChild(r)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/data/CsrfToken", [],()=>{"use strict";const e=new Map;class t{#e;#t;#i;#s;#n=-1;value;constructor(e,t,i){this.#e=e;this.#t=t;this.#i=i;this.#s=t.data.request.url}load(){return this.#r()}markExpired(){if(this.#n===e.get(this.#s)?.version){e.get(this.#s).expired=true}}async#r(){const t=await this.#i.fetchValueByHost(this.#t);if(t){this.#i.onTokenFetched(this.#e,t);this.value=t;return}let i=e.get(this.#s);if(!i||i?.expired){i={fetchPromise:this.#i.fetchValue(this.#t),version:(i?.version??0)+1,expired:false};e.set(this.#s,i)}const s=await i.fetchPromise;this.#n=e.get(this.#s).version;this.#i.onTokenFetched(this.#e,s);this.value=s}}return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/BaseFilter", ["sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/InvisibleText","sap/base/Log","sap/base/util/merge","sap/ui/core/Icon","sap/m/HBox","sap/m/Text","sap/ui/core/Lib","sap/ui/integration/model/ObservableModel","sap/ui/integration/util/LoadingProvider","sap/ui/integration/util/BindingHelper"],function(e,t,i,a,r,o,n,s,d,l,g,u){"use strict";var p=e.extend("sap.ui.integration.cards.filters.BaseFilter",{metadata:{abstract:true,library:"sap.ui.integration",properties:{key:{type:"string",defaultValue:""},config:{type:"object",defaultValue:"null"},value:{type:"object",defaultValue:null}},aggregations:{_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"},_label:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_error:{type:"sap.m.HBox",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}},events:{change:{parameters:{key:{type:"string"},value:{type:"string"}}}}},renderer:{apiVersion:2,render:function(e,t){const i=t.getAggregation("_error");e.openStart("div",t).class("sapFCardFilter");if(t.isLoading()){e.class("sapFCardFilterLoading")}e.openEnd();if(i){e.renderControl(i)}else{e.renderControl(t.getField())}e.close("div")}}});p.prototype.init=function(){this.setAggregation("_loadingProvider",new g);this.attachEventOnce("_dataReady",function(){this.fireEvent("_ready")})};p.prototype.exit=function(){if(this._oDataProvider){this._oDataProvider.destroy();this._oDataProvider=null}};p.prototype.isLoading=function(){var e=this.getAggregation("_loadingProvider");return e.getLoading()};p.prototype.getField=function(){return null};p.prototype.createLabel=function(e){if(e.label){this.setAggregation("_label",new i({text:e.label}).toStatic());return this.getAggregation("_label")}return null};p.prototype.showLoadingPlaceholders=function(){if(!this._isDataProviderJson()){this.getAggregation("_loadingProvider").setLoading(true)}};p.prototype.hideLoadingPlaceholders=function(){this.getAggregation("_loadingProvider").setLoading(false)};p.prototype.onDataChanged=function(){};p.prototype.setValueFromOutside=function(e){};p.prototype.getValueForModel=function(){};p.prototype.refreshData=function(){if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}};p.prototype.getCardInstance=function(){return t.getElementById(this.getCard())};p.prototype.getParsedConfiguration=function(){var e=r({},this.getConfig()),t=e.data;delete e.data;e=u.createBindingInfos(e,this.getCardInstance().getBindingNamespaces());if(t){e.data=t}return e};p.prototype.writeValueToConfiguration=function(e){};p.prototype._showError=function(){var e=d.getResourceBundleFor("sap.ui.integration").getText("CARD_FILTER_DATA_LOAD_ERROR");this.destroyAggregation("_error");this.setAggregation("_error",new n({justifyContent:"Center",alignItems:"Center",items:[new o({src:"sap-icon://message-error",size:"1rem"}).addStyleClass("sapUiTinyMargin"),new s({text:e})]}))};p.prototype._handleError=function(e){a.error(e);this._showError()};p.prototype._onDataRequestComplete=function(){this.hideLoadingPlaceholders()};p.prototype._setDataConfiguration=function(e){var t=this.getCardInstance(),i;if(!e){this.fireEvent("_dataReady");return}if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=t.getDataProviderFactory().create(e,null,true);if(e.name){i=t.getModel(e.name)}else if(this._oDataProvider){i=new l;i.setSizeLimit(t.getModelSizeLimit());this.setModel(i)}if(!i){this.fireEvent("_dataReady");return}i.attachEvent("change",()=>{this.onDataChanged();setTimeout(()=>{this.fireEvent("_dataReady")},0)});if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this.showLoadingPlaceholders()}.bind(this));this._oDataProvider.attachDataChanged(function(e){i.setData(e.getParameter("data"));this._onDataRequestComplete()}.bind(this));this._oDataProvider.attachError(function(e){this._handleError(e.getParameter("message"));this._onDataRequestComplete();this.fireEvent("_dataReady")}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady")}};p.prototype._syncValue=function(){const e=this.getValueForModel();this.setValue(e);this.fireChange({key:this.getKey(),value:e.value})};p.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/ComboBoxFilter", ["./BaseFilter","sap/ui/integration/controls/ComboBox","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/ComboBoxHelper","sap/base/util/merge","sap/ui/integration/util/SorterHelper"],function(e,t,o,i,a,s,l,n){"use strict";const r=e.extend("sap.ui.integration.cards.filters.ComboBoxFilter",{metadata:{library:"sap.ui.integration",aggregations:{_comboBox:{type:"sap.m.ComboBox",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2}});r.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy()}};r.prototype.getField=function(){return this._getComboBox()};r.prototype.onDataChanged=function(){const e=this._getComboBox();s.setValueAndKey(e,e.getSelectedKey(),e.getValue());this._syncValue()};r.prototype.getValueForModel=function(){const e=this._getComboBox();let t=e.getSelectedItem();const o=e.getCustomSelectedIndex();if(!t&&o>-1){t=this._getComboBox().getItems()[o];if(t&&!this._getComboBox().getValue()){e.setSelectedItem(t)}}if(t){return{value:this._getComboBox().getValue(),selectedItem:{title:t.getText(),key:t.getKey(),additionalText:t.getAdditionalText()}}}return{value:this._getComboBox().getValue()}};r.prototype.setValueFromOutside=function(e){const t=a.resolveValue(e,this.getCardInstance());s.setValueAndKey(this._getComboBox(),t?.selectedKey,t?.value);this._syncValue()};r.prototype.getStaticConfiguration=function(){const e=this.getParsedConfiguration();let t="/";let o=[];let i;if(e.item&&e.item.path){t=e.item.path}const s=this.getModel().getProperty(t);if(e.item&&e.item.template){i=e.item.template;o=s.map(function(e,o){const s=t==="/"?t+o:t+"/"+o;return a.resolveValue(i,this,s)}.bind(this))}else{o=s}o=o.map(e=>({key:e.key&&e.key.toString(),title:e.title&&e.title.toString(),additionalText:e.additionalText&&e.additionalText.toString()}));const n=l({},e);delete n.item;n.items=o;const r=this.getValueForModel();n.value=r.value;n.selectedKey=r.selectedItem?.key;return n};r.prototype.writeValueToConfiguration=function(e){const t=this.getValueForModel();e.value=t.value;if(t.selectedItem){e.selectedKey=t.selectedItem.key}};r.prototype._getComboBox=function(){let e=this.getAggregation("_comboBox");if(!e){e=this._createComboBox();this.setAggregation("_comboBox",e)}return e};r.prototype._createComboBox=function(){const e=this.getConfig();const l=new t({placeholder:e.placeholder,showSecondaryValues:true,filterSecondaryValues:true,customSelectedIndex:e.selectedIndex});let r,u,m,d="/";l.attachChange(e=>{this._syncValue()});if(e&&e.item){d=e.item.path||d}if(e&&e.item&&e.item.template){r=e.item.template.key;u=e.item.template.title;m=e.item.template.additionalText}const c=this.getCardInstance();if(e&&e.items){r="{key}";u="{title}";m="{additionalText}";const t=new i(e.items);t.setSizeLimit(c.getModelSizeLimit());this.setModel(t)}this._oItemTemplate=new o({key:r,text:u,additionalText:m});const g=e.group;if(g){this._oSorter=n.getGroupSorter(g)}l.bindItems({path:d,template:this._oItemTemplate,sorter:this._oSorter});s.setValueAndKey(l,a.resolveValue(e.selectedKey,c),a.resolveValue(e.value,c));const p=this.createLabel(e);if(p){l.addAriaLabelledBy(p)}return l};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/DateRangeFilter", ["./BaseFilter","sap/base/Log","sap/ui/core/library","sap/ui/integration/util/DateRangeHelper"],function(e,t,a,r){"use strict";var i=a.ValueState;var n=e.extend("sap.ui.integration.cards.filters.DateRangeFilter",{metadata:{library:"sap.ui.integration",aggregations:{_ddr:{type:"sap.m.DynamicDateRange",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2}});n.prototype.getField=function(){return this._getDdr()};n.prototype.setValueFromOutside=function(e){t.error("Setting a filter value programatically on a DateRangeFilter is currently unsupported.",null,"sap.ui.integration.widgets.Card")};n.prototype.getValueForModel=function(){return r.getValueForModel(this._getDdr())};n.prototype.writeValueToConfiguration=function(e){const t=this.getValueForModel();e.value.option=t.value.option;e.value.values=t.value.values};n.prototype._getDdr=function(){var e=this.getAggregation("_ddr");if(!e){e=this._createDdr();this.setAggregation("_ddr",e)}return e};n.prototype._createDdr=function(){var e=Object.assign({},this.getConfig());e.options=e.options||this._getDefaultOptions();var t=r.createInput(e,this.getCardInstance(),false);t.addStyleClass("sapFCardDateRangeField");t.attachChange(function(e){if(e.getParameter("valid")){t.setValueState(i.None);this._syncValue()}else{t.setValueState(i.Error)}}.bind(this));var a=this.createLabel(e);if(a){t.addAriaLabelledBy(a)}return t};n.prototype._getDefaultOptions=function(){return["date","today","dateRange","from","to","lastDays","nextDays","lastWeeks","nextWeeks"]};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/FilterBar", ["sap/ui/base/ManagedObjectObserver","sap/ui/core/Control"],function(e,t){"use strict";var i=t.extend("sap.ui.integration.cards.filters.FilterBar",{metadata:{library:"sap.ui.integration",properties:{},aggregations:{content:{type:"sap.ui.core.Control",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){var i=t._getFilters().some(function(e){return e.getVisible()});if(!i){return}e.openStart("div",t).class("sapFCardFilterBar").openEnd();e.renderControl(t.getContent());e.close("div")}}});i.prototype.init=function(){this._mObservers=new Map;this._oAggregationObserver=new e(this._onContentAggregationChange.bind(this));this._fnFilterVisibilityChangeHandler=this._onFilterVisibilityChange.bind(this);this._fnObserveFilter=this._observeFilter.bind(this);this._oAggregationObserver.observe(this,{aggregations:["content"]})};i.prototype.exit=function(){this._oAggregationObserver.disconnect();delete this._oAggregationObserver;this._mObservers.forEach(function(e){e.disconnect()});this._mObservers.clear();delete this._mObservers;delete this._fnFilterVisibilityChangeHandler;delete this._fnObserveFilter};i.prototype._onContentAggregationChange=function(e){if(e.mutation==="remove"){this._mObservers.forEach(function(e){e.disconnect()});this._mObservers.clear();return}var t=e.child,i="items";if(t.isA("sap.ui.layout.AlignedFlowLayout")){i="content"}if(e.mutation==="insert"){t.getAggregation(i).forEach(this._fnObserveFilter)}};i.prototype._observeFilter=function(t){var i=t.getParent().getId(),r=new e(this._fnFilterVisibilityChangeHandler);r.observe(t,{properties:["visible"]});this._mObservers.set(i,r)};i.prototype._onFilterVisibilityChange=function(){this.invalidate()};i.prototype.showLoadingPlaceholders=function(){this._getFilters().forEach(function(e){e.showLoadingPlaceholders()})};i.prototype.hideLoadingPlaceholders=function(){this._getFilters().forEach(function(e){e.hideLoadingPlaceholders()})};i.prototype.refreshData=function(){this._getFilters().forEach(function(e){e.refreshData()})};i.prototype._getFilters=function(){var e=this.getContent();if(!e||!e.isA(["sap.m.FlexBox","sap.ui.layout.AlignedFlowLayout"])){return[]}return e.getItems?e.getItems():e.getContent()};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/FilterBarFactory", ["./FilterBar","./SearchFilter","./SelectFilter","./ComboBoxFilter","./DateRangeFilter","sap/ui/base/Object","sap/m/library","sap/m/HBox","sap/ui/layout/AlignedFlowLayout"],function(e,t,a,r,n,i,s,o,l){"use strict";var c=s.FlexWrap;var u=s.FlexRendertype;var d=i.extend("sap.ui.integration.util.FilterBarFactory",{metadata:{library:"sap.ui.integration"},constructor:function(e){i.call(this);this._oCard=e}});d.prototype.create=function(t,a,r){var n=[],i=[],s,d,p,f,h=null;for(d in t){s=t[d];h=this._getClass(s.type);p=new h({card:this._oCard,key:d,config:s,value:{model:"filters",path:"/"+d},visible:s.visible,change:r});a.setProperty("/"+d,p.getValueForModel());this._awaitEvent(i,p,"_ready");p._setDataConfiguration(s.data);n.push(p)}if(!n.length){return null}if(n.length>1){f=new l({content:n,minItemWidth:"10rem",maxItemWidth:"20rem"});n.forEach(function(e){e.getField().setWidth("100%")});f.addStyleClass("sapFCardFilterBarAFLayout")}else{f=new o({wrap:c.Wrap,renderType:u.Bare,items:n})}f.addStyleClass("sapFCardFilterBarContent");var y=new e({content:f});Promise.all(i).then(function(){y.fireEvent("_filterBarDataReady")});return y};d.prototype._awaitEvent=function(e,t,a){e.push(new Promise(function(e){t.attachEventOnce(a,function(){e()})}))};d.prototype._getClass=function(e){e=e||"select";switch(e.toLowerCase()){case"string":case"integer":case"select":return a;case"daterange":return n;case"search":return t;case"combobox":return r;default:return undefined}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/SearchFilter", ["./BaseFilter","sap/m/SearchField","sap/base/util/merge"],function(e,t,i){"use strict";var a=e.extend("sap.ui.integration.cards.filters.SearchFilter",{metadata:{library:"sap.ui.integration",aggregations:{_searchField:{type:"sap.m.SearchField",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2}});a.prototype.getField=function(){return this._getSearchField()};a.prototype.setValueFromOutside=function(e){this._getSearchField().setValue(e);this._syncValue()};a.prototype.getValueForModel=function(){return{value:this._escapeDoubleQuotes(this._getSearchField().getValue())}};a.prototype.getStaticConfiguration=function(){const e=i({},this.getParsedConfiguration());e.value=this.getValueForModel().value;return e};a.prototype.writeValueToConfiguration=function(e){e.value=this.getValueForModel().value};a.prototype._getSearchField=function(){var e=this.getAggregation("_searchField");if(!e){e=this._createSearchField();this.setAggregation("_searchField",e)}return e};a.prototype._createSearchField=function(){var e=this.getConfig();var i=new t({value:e.value,placeholder:e.placeholder});var a=this.createLabel(e);if(a){i.addAriaLabelledBy(a)}i.attachChange(function(){this._syncValue()}.bind(this));return i};a.prototype._escapeDoubleQuotes=function(e){return e.replaceAll('"','\\"')};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/filters/SelectFilter", ["./BaseFilter","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver","sap/base/util/merge"],function(e,t,i,a,l,r){"use strict";var s=e.extend("sap.ui.integration.cards.filters.SelectFilter",{metadata:{library:"sap.ui.integration",aggregations:{_select:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2}});s.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oItemTemplate){this._oItemTemplate.destroy()}};s.prototype.getField=function(){return this._getSelect()};s.prototype.onDataChanged=function(){var e=this._getSelect();e.setSelectedKey(this.getValue().value);this._syncValue()};s.prototype.getValueForModel=function(){var e=this._getSelect().getSelectedItem();if(!e){e=this._getSelect().getItems()[0]}if(e){return{value:e.getKey(),selectedItem:{title:e.getText(),key:e.getKey()}}}return{value:this._getSelect().getSelectedKey()}};s.prototype.setValueFromOutside=function(e){this._getSelect().setSelectedKey(l.resolveValue(e,this.getCardInstance()));this._syncValue()};s.prototype.getStaticConfiguration=function(){var e=this.getParsedConfiguration();var t="/";var i;var a=[];var s;if(e.item&&e.item.path){t=e.item.path}i=this.getModel().getProperty(t);if(e.item&&e.item.template){s=e.item.template;a=i.map(function(e,i){var a=t==="/"?t+i:t+"/"+i;return l.resolveValue(s,this,a)}.bind(this))}else{a=i}a=a.map(function(e){return{key:e.key&&e.key.toString(),title:e.title&&e.title.toString()}});var n=r({},e);delete n.item;n.items=a;n.value=this.getValueForModel().value;return n};s.prototype.writeValueToConfiguration=function(e){e.value=this.getValueForModel().value};s.prototype._getSelect=function(){var e=this.getAggregation("_select");if(!e){e=this._createSelect();this.setAggregation("_select",e)}return e};s.prototype._createSelect=function(){var e=new t,r=this.getCardInstance(),s,n,o="/",u=this.getConfig(),p=this.createLabel(u),g;e.attachChange(function(e){this._syncValue()}.bind(this));if(u&&u.item){o=u.item.path||o}if(u&&u.item&&u.item.template){s=u.item.template.key;n=u.item.template.title}if(u&&u.items){s="{key}";n="{title}";g=new a(u.items);g.setSizeLimit(r.getModelSizeLimit());this.setModel(g)}this._oItemTemplate=new i({key:s,text:n});e.bindItems({path:o,template:this._oItemTemplate});e.setSelectedKey(l.resolveValue(u.value,r));if(p){e.addAriaLabelledBy(p)}return e};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/cards/list/MicrochartsResizeHelper", ["sap/ui/base/Object","sap/ui/core/ResizeHandler","sap/ui/base/ManagedObjectObserver"],function(e,i,t){"use strict";var s=e.extend("sap.ui.integration.cards.list.MicrochartsResizeHelper",{constructor:function(i){e.call(this);this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._oList=i;this._oItemsObserver=new t(this._onItemChange.bind(this));this._oItemsObserver.observe(i,{aggregations:["items"]})}});s.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);if(this._iMicrochartsResizeHandler){i.deregister(this._iMicrochartsResizeHandler);this._iMicrochartsResizeHandler=undefined}if(this._iResizeMicrochartsTimeout){clearTimeout(this._iResizeMicrochartsTimeout);this._iResizeMicrochartsTimeout=null}this._oItemsObserver=null;this._oItemDelegate=null};s.prototype._onItemChange=function(e){if(e.name!=="items"||!e?.child?.getMicrochart?.()){return}if(e.mutation==="insert"){e.child.getMicrochart().addEventDelegate(this._oItemDelegate,this)}else if(e.mutation==="remove"){e.child.getMicrochart().removeEventDelegate(this._oItemDelegate,this)}};s.prototype._onAfterItemRendering=function(){this._scheduleResizeMicrocharts()};s.prototype._scheduleResizeMicrocharts=function(){if(this._iResizeMicrochartsTimeout){clearTimeout(this._iResizeMicrochartsTimeout);this._iResizeMicrochartsTimeout=null}this._iResizeMicrochartsTimeout=setTimeout(function(){this._resizeMicrocharts()}.bind(this),0)};s.prototype._resizeMicrocharts=function(){var e=this._oList.$().find(".sapUiIntMicrochartChart"),t=Number.MAX_VALUE;if(e.length===0){return}e.each(function(e,i){t=Math.min(t,i.offsetWidth)});e.find(".sapUiIntMicrochartChartInner").css("max-width",t+"px");if(!this._iMicrochartsResizeHandler){this._iMicrochartsResizeHandler=i.register(this._oList,this._resizeMicrocharts.bind(this))}};return s});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ActionsStrip", ["../library","sap/m/library","sap/ui/core/library","sap/ui/core/Control","sap/ui/core/Element","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/model/json/JSONModel","sap/m/Button","sap/m/Link","sap/m/OverflowToolbarButton","sap/m/OverflowToolbar","sap/m/OverflowToolbarLayoutData","sap/m/ToolbarSpacer","sap/m/Label"],function(t,e,o,i,n,a,r,s,l,p,c,u,b,g,f,d){"use strict";const m=e.ToolbarStyle;const y=e.ToolbarDesign;const h=o.aria.HasPopup;const _=t.CardActionArea;const C=t.CardActionType;var I=i.extend("sap.ui.integration.controls.ActionsStrip",{metadata:{library:"sap.ui.integration",properties:{disableItemsInitially:{type:"boolean",defaultValue:false},configuration:{type:"object"},cardActions:{type:"object"}},aggregations:{_toolbar:{type:"sap.m.OverflowToolbar",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e).class("sapUiIntActionsStrip").openEnd();t.renderControl(e._getToolbar());t.close("div")}}});I.prototype.onDataChanged=function(){if(this.getConfiguration()?.item){this._updateToolbar(this._createItemsFromTemplate(this.getBindingContext().getProperty(this.getConfiguration().item?.path)))}};I.prototype.getFirstFocusableItem=function(){const t=this._getToolbar();return t.getContent().find(t=>{if(!(t.isA("sap.m.Button")||t.isA("sap.m.Link"))){return false}if(!(t.getVisible()&&t.getEnabled())){return false}return true})};I.prototype._getToolbar=function(){var t=this.getAggregation("_toolbar");if(!t){t=new b({style:m.Clear,design:y.Transparent});this.setAggregation("_toolbar",t)}return t};I.prototype._updateToolbar=function(t){if(!t||!t.length){return}const e=this._getToolbar();t.forEach(t=>{e.addContent(this._createItem(t))});const o=e.getContent().find(t=>t instanceof f);if(!o){e.insertContent(new f,0)}};I.prototype._createItems=function(t){if(!t||!t.length){return null}const e=n.getElementById(this.getCard());t=r.createBindingInfos(t,e.getBindingNamespaces());return t};I.prototype._createItemsFromTemplate=function(t){if(!t||!t.length){return null}const e=this.getConfiguration().item;let o=e.path+"/";if(!r.isAbsolutePath(o)){o=this.getBindingContext().getPath();if(o!=="/"){o+="/"}o+=e.path+"/"}const i=this.getBindingContext().getProperty();this.setModel(new l(i),"parent");return t.map((t,i)=>s.resolveValue(e.template,this,o+i))};I.prototype._createItem=function(t){let e;switch(t.type){case"Label":e=this._createLabel(t);break;case"ToolbarSpacer":return new f;case"Link":e=this._createLink(t);break;case"Button":default:e=this._createButton(t)}e.setLayoutData(new g({group:t.overflowGroup,priority:t.overflowPriority}));const o={area:_.ActionsStrip,control:e,actions:t.actions,enabledPropertyName:"enabled"};if(this.getDisableItemsInitially()){o.enabledPropertyValue=false;e._mActionsConfig=o;e._bIsDisabled=true}if(t.type!=="Label"){this.getCardActions().attach(o)}return e};I.prototype.disableItems=function(){var t=this._getToolbar().getContent();t.forEach(function(t){if(t.setEnabled&&!t._bIsDisabled&&t.getEnabled()){t.setEnabled(false);t._bIsDisabled=true}})};I.prototype.enableItems=function(){var t=this._getToolbar().getContent(),e;t.forEach(t=>{if(t.setEnabled&&t._bIsDisabled){e=t._mActionsConfig;if(e?.action){e.enabledPropertyValue=true;this.getCardActions()._setControlEnabledState(e)}else{t.setEnabled(true)}delete t._bIsDisabled}})};I.prototype._createLabel=function(t){var e=new d({text:t.text,visible:t.visible});return e};I.prototype._createLink=function(t){var e=new c({icon:t.icon,text:t.text,tooltip:t.tooltip,ariaHasPopup:t.ariaHasPopup??this._getAriaHasPopup(t),emphasized:t.emphasized,visible:t.visible});return e};I.prototype._createButton=function(t){const e=t.ariaHasPopup??this._getAriaHasPopup(t);const o={icon:t.icon,text:t.text,tooltip:t.tooltip,type:t.buttonType,ariaHasPopup:e,visible:t.visible};if(t.icon&&(t.preferIcon||!t.text)){o.text=t.text||t.tooltip;o.tooltip=t.tooltip||t.text;return new u(o)}return new p(o)};I.prototype._getAriaHasPopup=function(t){const e=t.actions;if(e?.length>0&&e[0].type===C.ShowCard){return h.Dialog}return null};I.create=function(t,e,o){if(!t){return null}const i=new I({card:e,configuration:t,cardActions:new a({card:e}),disableItemsInitially:o});if(Array.isArray(t)){i._updateToolbar(i._createItems(t))}return i};I.hasVisibleTemplateItems=function(t,e){const o=t;if(!Array.isArray(o)){return false}const i=s.resolveValue(o,e);return i.some(t=>!t.hasOwnProperty("visible")||!!t.visible)};I.prototype.hasVisibleItems=function(){const t=this._getToolbar(),e=t.getContent();return e.some(t=>!(t instanceof f)&&t.getVisible())};return I});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ActionsToolbar", ["./ActionsToolbarRenderer","sap/base/strings/capitalize","sap/ui/core/Control","sap/m/library","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/library","sap/m/Button","sap/ui/base/ManagedObjectObserver","sap/ui/integration/cards/actions/CardActions","sap/m/Menu","sap/m/MenuItem"],function(t,e,i,n,s,o,r,a,c,u,g,p){"use strict";var h=n.ButtonType;var l=r.aria.HasPopup;function f(t,e,i,n){return new Promise(function(s){var o;if(typeof i==="function"){o=i(n);if(o instanceof Promise){o.then(function(i){t.setProperty(e,i);s()});return}}else{o=i}t.setProperty(e,o);s()})}var b=i.extend("sap.ui.integration.controls.ActionsToolbar",{metadata:{library:"sap.ui.integration",properties:{},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true},_toolbar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_actionsMenu:{type:"sap.m.Menu",multiple:false,visibility:"hidden"}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:t});b.prototype.init=function(){var t=o.getResourceBundleFor("sap.ui.integration");this.setAggregation("_actionsMenu",new g({title:t.getText("CARD_ACTIONS")}));this._aActions=[];this._mActionObservers=new Map;this._oObserver=new c(this._observeActionsAggregation.bind(this));this._oObserver.observe(this,{aggregations:["actionDefinitions"]})};b.prototype.exit=function(){this._aActions=null;this._oObserver.disconnect();this._oObserver=null;this._mActionObservers.clear();this._mActionObservers=null};b.prototype.onBeforeRendering=function(){this._updateVisibility()};b.prototype.initializeContent=function(t){var e=this,i,n=[],s=[],o=this.getAggregation("_actionsMenu"),r=t.getHostInstance(),a=t.getAggregation("_extension");if(r){s=s.concat(r.getActions()||[])}if(a){s=s.concat(a.getActions()||[])}this._aActions=s;s.forEach(function(t){i=e._createActionMenuItem(t,false);n.push(i)});if(this._aMenuItems){this._aMenuItems.forEach(function(t){t.destroy()})}n.forEach(o.addItem,o);this._aMenuItems=n;this._refreshMenuItems().then(this._updateVisibility.bind(this))};b.prototype._open=function(){this._refreshMenuItems().then(function(){this.getAggregation("_actionsMenu").openBy(this._getToolbar())}.bind(this))};b.prototype._getToolbar=function(){var t=o.getResourceBundleFor("sap.ui.integration");var e=this.getAggregation("_toolbar");if(!e){e=new a({id:this.getId()+"-overflowButton",icon:"sap-icon://overflow",type:h.Transparent,ariaHasPopup:l.Menu,tooltip:t.getText("CARD_ACTIONS_OVERFLOW_BUTTON_TOOLTIP"),press:function(t){this._open()}.bind(this)});this.setAggregation("_toolbar",e)}return e};b.prototype._refreshMenuItems=function(){const t=[];this._refreshRecursiveMenuItems(this._aActions,this._aMenuItems,t);return Promise.all(t)};b.prototype._refreshRecursiveMenuItems=function(t,e,i){const n=this.getCardInstance();if(!t||!e){return}t.forEach((t,s)=>{const o=e[s];i.push(f(o,"enabled",t.enabled,n));i.push(f(o,"visible",t.visible,n));this._refreshRecursiveMenuItems(t.actions,o.getItems(),i)})};b.prototype._createActionMenuItem=function(t,e){var i=e?this._getActionConfig(t):t;const n=[];const s=e?i.actionDefinitions:i.actions;if(s){s.forEach(t=>{n.push(this._createActionMenuItem(t,e))})}var o=new p({icon:i.icon,text:i.text,tooltip:i.tooltip,startsSection:i.startsSection,visible:e?i.visible:false,items:n,press:function(i){var n=e?this._getActionConfig(t):t;if(n.actionDefinitions?.length>0||n.actions?.length>0){return}u.fireAction({card:this.getCardInstance(),host:this.getCardInstance().getHostInstance(),action:n,parameters:n.parameters,source:i.getSource()})}.bind(this)});if(e){o.setEnabled(i.enabled);t.setAssociation("_menuItem",o);this._attachObservers(t)}return o};b.prototype._updateVisibility=function(){var t=this.getAggregation("_actionsMenu").getItems().some(function(t){return t.getVisible()});this.setVisible(t)};b.prototype.updateVisibility=function(){this._updateVisibility()};b.prototype._getActionConfig=function(t){var i=["visible","enabled","icon","text","tooltip","parameters","type","actionDefinitions","startsSection"].reduce(function(i,n){i[n]=t["get"+e(n)]();return i},{});i.action=function(){t.firePress()};return i};b.prototype._observeActionsAggregation=function(t){const e=t.child,i=t.object;if(t.mutation==="insert"){const t=this._createActionMenuItem(e,true),n=i.indexOfActionDefinition(e);let o;if(i.isA("sap.ui.integration.ActionDefinition")){o=s.getElementById(i.getAssociation("_menuItem"))}else{o=this.getAggregation("_actionsMenu")}o.insertItem(t,n);this._updateVisibility()}else if(t.mutation==="remove"){s.getElementById(e.getAssociation("_menuItem")).destroy();this._detachObservers(e)}};b.prototype._attachObservers=function(t){this._oObserver.observe(t,{aggregations:["actionDefinitions"]});var e=new c(this._observeSingleAction.bind(this));e.observe(t,{properties:true,aggregations:["tooltip"]});this._mActionObservers.set(t.getId(),e)};b.prototype._detachObservers=function(t){this._oObserver.unobserve(t);this._mActionObservers.get(t.getId()).disconnect();this._mActionObservers.delete(t.getId())};b.prototype._observeSingleAction=function(t){var i=t.object,n=t.name,o=s.getElementById(i.getAssociation("_menuItem")),r=t.current;if(["type","parameters"].indexOf(n)!==-1){return}if(t.type==="aggregation"&&n!=="actionDefinitions"){r=t.child}o["set"+e(n)](r);this._updateVisibility()};b.prototype.setEnabled=function(t){var e=this._getToolbar();if(t){e.setEnabled(true)}else{this.getAggregation("_actionsMenu").close();e.setEnabled(false)}};b.prototype.getCardInstance=function(){return s.getElementById(this.getCard())};return b});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/ActionsToolbarRenderer", [],function(){"use strict";var n={apiVersion:2};n.render=function(n,e){n.openStart("div",e).class("sapUiIntActionsToolbar").openEnd();n.renderControl(e._getToolbar());n.close("div")};return n},true);
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/BlockingMessage", ["../library","sap/base/Log","sap/m/Bar","sap/m/Button","sap/m/Dialog","sap/m/IllustratedMessage","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/m/Title","sap/m/Text","sap/ui/Device","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/core/library","sap/ui/core/Supportability"],function(e,t,i,a,s,n,r,o,l,g,p,u,d,c,f){"use strict";var y=c.TitleLevel;var m=e.CardBlockingMessageType;var h=u.extend("sap.ui.integration.controls.BlockingMessage",{metadata:{library:"sap.ui.integration",properties:{type:{type:"sap.ui.integration.CardBlockingMessageType",defaultValue:m.Information},height:{type:"sap.ui.core.CSSSize",defaultValue:""},illustrationType:{type:"string",defaultValue:"ErrorScreen"},illustrationSize:{type:"sap.m.IllustratedMessageSize",defaultValue:o.Auto},title:{type:"string",defaultValue:""},description:{type:"string",defaultValue:""},details:{type:"string",defaultValue:""},httpResponse:{type:"object",defaultValue:null},imageSrc:{type:"string",defaultValue:""}},aggregations:{additionalContent:{type:"sap.m.Button",multiple:true,forwarding:{getter:"_getIllustratedMessage",aggregation:"additionalContent"}},_illustratedMessage:{type:"sap.m.IllustratedMessage",multiple:false}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}},renderer:{apiVersion:2,render:function(e,t){e.openStart("div",t).class("sapUiIntBlockingMsg");if(t.getHeight()){e.style("height",t.getHeight())}e.openEnd();e.renderControl(t.getAggregation("_illustratedMessage"));e.close("div")}}});h.create=function(e,i){var a=e.illustrationType,s=e.illustrationSize||o.Auto,n="100%",l=e.title,g=e.description,p=e.details;if(e.type===m.Error){a=a||r.ErrorScreen}else if(e.type===m.NoData){a=a||r.NoData}if(i.getCardContent()&&i.getCardContent().getDomRef()){n=i.getCardContent().getDomRef().offsetHeight+"px"}var u=new h({type:e.type,height:n,illustrationType:a,illustrationSize:s,title:l,description:g,httpResponse:e.httpResponse,details:p,additionalContent:h._createButtons(e.additionalContent)});if(e.imageSrc){u.setImageSrc(i.getRuntimeUrl(e.imageSrc))}if(p&&f.isDebugModeEnabled()){u.addAdditionalContent(h._createDetailsButton(p));t.error(p)}return u};h._createButtons=function(e){const t=e||[];return t.map(e=>new a({text:e.text,icon:e.icon,tooltip:e.tooltip,type:e.buttonType,ariaHasPopup:e.ariaHasPopup,press:e.press}))};h._createDetailsButton=function(e){var t=d.getResourceBundleFor("sap.ui.integration");return new a({text:t.getText("CARD_BUTTON_SHOW_MORE"),press:function(){var n=new g({renderWhitespace:true,text:e}).addStyleClass("sapUiSmallMargin");var r=new s({stretch:p.system.phone,customHeader:new i({contentMiddle:new l({text:t.getText("CARD_ERROR_DIALOG_TITLE"),level:y.H1}),contentRight:new a({icon:"sap-icon://copy",tooltip:t.getText("CARD_TEXT_COPY"),press:function(){var e=document.createRange(),t=n.getDomRef();e.selectNode(t);window.getSelection().removeAllRanges();window.getSelection().addRange(e);window.navigator.clipboard.writeText(t.textContent)}})}),content:[n],buttons:[new a({text:t.getText("CARD_DIALOG_CLOSE_BUTTON"),press:function(){r.close()}})],afterClose:function(){r.destroy()}});r.open()}})};h.prototype.onBeforeRendering=function(){var e=this._getIllustratedMessage();e.setIllustrationType(this.getIllustrationType()).setIllustrationSize(this.getIllustrationSize()).setTitle(this.getTitle()).setDescription(this.getDescription())};h.prototype._getIllustratedMessage=function(){let e=this.getAggregation("_illustratedMessage");if(!e){e=new n({enableDefaultTitleAndDescription:false,enableVerticalResponsiveness:true});e.addEventDelegate({onAfterRendering:this._illustrationAfterRendering.bind(this)});this.setAggregation("_illustratedMessage",e)}return e};h.prototype._illustrationAfterRendering=function(){const e=this.getImageSrc();if(!e){return}const t=this.getAggregation("_illustratedMessage").getDomRef().getElementsByClassName("sapMIllustratedMessageMainContent")[0];const i=t.getElementsByTagName("svg")[0];const a=i.getBoundingClientRect();const s=document.createElement("div");s.classList.add("sapUiIntCardCustomImage");t.append(s);s.style.backgroundImage="url("+e+")";s.style.width=a.width+"px";s.style.height=a.height+"px"};h.prototype.getStaticConfiguration=function(){return{type:this.getType()===m.NoData?"noData":"error",illustrationType:this.getIllustrationType(),illustrationSize:this.getIllustrationSize(),title:this.getTitle(),description:this.getDescription()?this.getDescription():undefined,imageSrc:this.getImageSrc()?this.getImageSrc():undefined,details:this.getDetails()?this.getDetails():undefined}};return h});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ComboBox", ["sap/m/ComboBox","sap/m/ComboBoxRenderer"],function(e,t){"use strict";var o=e.extend("sap.ui.integration.controls.ComboBox",{metadata:{library:"sap.ui.integration",properties:{customSelectedIndex:{type:"int",defaultValue:-1}}},renderer:t});return o});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/HeaderInfoSectionColumn", ["sap/ui/core/Control","./HeaderInfoSectionColumnRenderer"],function(e,r){"use strict";var t=e.extend("sap.ui.integration.controls.HeaderInfoSectionColumn",{metadata:{library:"sap.ui.integration",properties:{},defaultAggregation:"items",aggregations:{rows:{type:"sap.ui.core.Control",multiple:true},items:{type:"sap.ui.core.Control",multiple:true}}},renderer:r});return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/HeaderInfoSectionColumnRenderer", ["sap/ui/core/Renderer"],function(e){"use strict";var n={apiVersion:2};n.render=function(e,n){e.openStart("div",n).class("sapUiIntHeaderInfoSectionColumn").openEnd();n.getRows().forEach(n=>{e.renderControl(n)});const o=n.getItems();if(o.length){e.openStart("div",n).class("sapUiIntHeaderInfoSectionItemsGroup").openEnd();o.forEach(n=>{e.renderControl(n)});e.close("div")}e.close("div")};return n});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/HeaderInfoSectionRow", ["sap/ui/core/Control","sap/ui/integration/types/HeaderInfoSectionJustifyContent","./HeaderInfoSectionRowRenderer"],function(e,t,n){"use strict";var i=e.extend("sap.ui.integration.controls.HeaderInfoSectionRow",{metadata:{library:"sap.ui.integration",properties:{justifyContent:{type:"sap.ui.integration.types.HeaderInfoSectionJustifyContent",group:"Appearance",defaultValue:t.SpaceBetween}},defaultAggregation:"items",aggregations:{columns:{type:"sap.ui.core.Control",multiple:true},items:{type:"sap.ui.core.Control",multiple:true}}},renderer:n});return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/HeaderInfoSectionRowRenderer", ["sap/ui/core/Renderer"],function(e){"use strict";var n={apiVersion:2};n.render=function(e,n){e.openStart("div",n).class("sapUiIntHeaderInfoSectionRow").class(`sapUiIntHeaderInfoSectionItemJustify${n.getJustifyContent()}`).openEnd();n.getColumns().forEach(n=>{e.renderControl(n)});const t=n.getItems();if(t.length){e.openStart("div",n).class("sapUiIntHeaderInfoSectionItemsGroup").openEnd();t.forEach(n=>{e.renderControl(n)});e.close("div")}e.close("div")};return n});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ImageWithOverlay", ["./ImageWithOverlayRenderer","sap/ui/core/AnimationMode","sap/ui/core/ControlBehavior","sap/m/Text","sap/ui/core/Control","sap/m/VBox","sap/m/library"],function(t,e,i,s,a,o,r){"use strict";var l=r.FlexJustifyContent;var n=r.FlexAlignItems;var u=r.FlexDirection;var g=r.FlexRendertype;var p=a.extend("sap.ui.integration.controls.ImageWithOverlay",{metadata:{library:"sap.ui.integration",properties:{supertitle:{type:"string",group:"Misc",defaultValue:""},title:{type:"string",group:"Misc",defaultValue:""},subTitle:{type:"string",group:"Misc",defaultValue:""},verticalPosition:{type:"sap.m.FlexJustifyContent",group:"Appearance",defaultValue:l.Start},horizontalPosition:{type:"sap.m.FlexAlignItems",group:"Appearance",defaultValue:n.Start},textColor:{type:"string",group:"Misc",defaultValue:""},textFilter:{type:"string",group:"Misc",defaultValue:""},background:{type:"string",group:"Misc",defaultValue:""},padding:{type:"string",group:"Misc",defaultValue:""},animation:{type:"string",group:"Misc",defaultValue:"None"}},aggregations:{image:{type:"sap.m.Image",multiple:false},_textsLayout:{type:"sap.m.VBox",multiple:false,visibility:"hidden"}}},renderer:t});p.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);var t=i.getAnimationMode();this._getSupertitleText().setText(this.getSupertitle());this._getTitleText().setText(this.getTitle());this._getSubTitleText().setText(this.getSubTitle());this._getTextsLayout().setJustifyContent(this.getVerticalPosition()).setAlignItems(this.getHorizontalPosition());if(t===e.full&&this.getAnimation()==="FadeIn"){this.getImage()?.attachLoad(()=>{this.addStyleClass("sapUiIntImgWithOverlayLoaded")})}else{this.addStyleClass("sapUiIntImgWithOverlayNoAnimation")}};p.prototype.onAfterRendering=function(){a.prototype.onAfterRendering.apply(this,arguments);var t=this.getTextColor(),e=this.getTextFilter(),i=this.getBackground(),s;if(t||e){s=this.getDomRef().getElementsByClassName("sapMText");for(let i=0;i<s.length;i++){const a=s[i];if(t){a.style.color=t}if(e){a.style.filter=e}}}if(i){this.getDomRef().getElementsByClassName("sapUiIntImgWithOverlayLayout")[0].style.background=i}};p.prototype._getSupertitleText=function(){if(!this._oSupertitleText){this._oSupertitleText=new s({text:this.getSupertitle()})}return this._oSupertitleText};p.prototype._getTitleText=function(){if(!this._oTitleText){this._oTitleText=new s({text:this.getTitle()}).addStyleClass("sapUiIntImgWithOverlayTitle")}return this._oTitleText};p.prototype._getSubTitleText=function(){if(!this._oSubTitleText){this._oSubTitleText=new s({text:this.getSubTitle()})}return this._oSubTitleText};p.prototype._getTextsLayout=function(){var t=this.getAggregation("_textsLayout");if(!t){t=new o({direction:u.Column,renderType:g.Bare,justifyContent:this.getVerticalPosition(),alignItems:this.getHorizontalPosition(),items:[this._getSupertitleText(),this._getTitleText(),this._getSubTitleText()]}).addStyleClass("sapUiIntImgWithOverlayLayout");this.setAggregation("_textsLayout",t)}return t};return p});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/ImageWithOverlayRenderer", ["sap/ui/core/Renderer"],function(e){"use strict";var t={apiVersion:2};t.render=function(e,t){e.openStart("div",t).class("sapUiIntImageWithOverlay");if(t.getPadding()==="MediumStart"){e.class("sapUiIntImageWithOverlayPaddingMediumStart")}e.openEnd();e.renderControl(t.getAggregation("image"));e.renderControl(t._getTextsLayout());e.close("div")};return t});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ListContentItem", ["sap/ui/core/Lib","sap/ui/integration/library","./ListContentItemRenderer","./ActionsStrip","sap/ui/integration/controls/ObjectStatus","sap/m/library","sap/m/Avatar","sap/m/AvatarShape","sap/m/AvatarSize","sap/m/ListItemBase","sap/ui/core/library","sap/ui/integration/util/BindingResolver"],function(t,e,i,a,s,n,o,r,l,u,p,c){"use strict";var g=e.AttributesLayoutType;var h=p.ValueState;var f=n.AvatarImageFitType;var y=u.extend("sap.ui.integration.controls.ListContentItem",{metadata:{library:"sap.ui.integration",properties:{title:{type:"string",group:"Misc",defaultValue:null},description:{type:"string",group:"Misc",defaultValue:null},descriptionVisible:{type:"boolean",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconAlt:{type:"string",defaultValue:""},iconDisplayShape:{type:"sap.m.AvatarShape",defaultValue:r.Square},iconInitials:{type:"string",defaultValue:""},iconSize:{type:"sap.m.AvatarSize",defaultValue:l.XS},iconFitType:{type:"sap.m.AvatarImageFitType",defaultValue:f.Cover},iconBackgroundColor:{type:"sap.m.AvatarColor"},iconVisible:{type:"boolean",defaultValue:true},hasInfo:{type:"boolean",defaultValue:false},info:{type:"string",group:"Misc",defaultValue:null},infoVisible:{type:"boolean",defaultValue:true},infoState:{type:"sap.ui.core.ValueState",group:"Misc",defaultValue:h.None},showInfoStateIcon:{type:"boolean",defaultValue:false},infoStateInverted:{type:"boolean",defaultValue:false},customInfoStatusIcon:{type:"string",group:"Misc",defaultValue:null},attributesLayoutType:{type:"sap.ui.integration.AttributesLayoutType",defaultValue:g.TwoColumns}},aggregations:{microchart:{type:"sap.ui.integration.controls.Microchart",multiple:false},actionsStrip:{type:"sap.ui.integration.controls.ActionsStrip",multiple:false},attributes:{type:"sap.m.ObjectStatus",multiple:true},_avatar:{type:"sap.m.Avatar",multiple:false,visibility:"hidden"},_objectStatus:{type:"sap.m.ObjectStatus",multiple:false,visibility:"hidden"}}},renderer:i});y.getPlaceholderInfo=function(t,e){const i=t?.attributes?.filter(function(t){return t.hasOwnProperty("visible")?t.visible:true});const s=t?.icon?.hasOwnProperty("visible")?t?.icon.visible:!!t?.icon;const n=t?.actionsStrip?a.hasVisibleTemplateItems(t.actionsStrip,e):false;return{hasIcon:s,attributesLength:i?i.length:0,hasChart:!!t?.chart,hasActionsStrip:n,hasDescription:!!t?.description}};y.getLinesCount=function(t,e){let i=1;const a=c.resolveValue(t,e);const s=y.getPlaceholderInfo(a,e);const n=a.description?.hasOwnProperty("visible")?a.description?.visible:true;if(a.description&&n){i+=1}const o=s.attributesLength;if(a.attributesLayoutType===g.OneColumn){i+=o}else{i+=Math.ceil(o/2)}const r=a.chart?.hasOwnProperty("visible")?a.chart?.visible:true;if(a.chart&&r){i+=1}return i};y.prototype.onBeforeRendering=function(){u.prototype.onBeforeRendering.apply(this,arguments);if(this.isPropertyInitial("iconSize")){if(this.getLinesCount()===1){this._getAvatar().setDisplaySize(l.XS)}else{this._getAvatar().setDisplaySize(l.S)}}else{this._getAvatar().setDisplaySize(this.getIconSize())}};y.prototype.getLinesCount=function(){var t=1;if(this.getDescription()&&this.getDescriptionVisible()){t+=1}if(this.getAttributesLayoutType()===g.OneColumn){t+=this._getVisibleAttributes().length}else{t+=Math.ceil(this._getVisibleAttributes().length/2)}if(this.getMicrochart()&&this.getMicrochart().getVisible()){t+=1}return t};y.prototype.getContentAnnouncement=function(){var e=this.getInfoState(),i=this.getTitle(),a=this.getDescription(),s=[],n=this.getInfo(),o=t.getResourceBundleFor("sap.m"),r=this._getVisibleAttributes(),l=this.getMicrochart()?.getChart();if(i){s.push(i)}if(a){s.push(a)}if(n){s.push(n)}if(e!=h.None&&e!==this.getHighlight()){s.push(o.getText("LIST_ITEM_STATE_"+e.toUpperCase()))}if(r.length>0){r.forEach(function(t){s.push(t.getAccessibilityInfo().description)})}if(l){s.push(l.getTooltip_AsString())}return s.join(" . ").trim()};y.prototype._getAvatar=function(){var t=this.getAggregation("_avatar");if(!t){t=(new o).addStyleClass("sapFCardIcon");this.setAggregation("_avatar",t)}t.setSrc(this.getIcon()).setDisplayShape(this.getIconDisplayShape()).setTooltip(this.getIconAlt()).setInitials(this.getIconInitials()).setBackgroundColor(this.getIconBackgroundColor()).setVisible(this.getIconVisible()).setImageFitType(this.getIconFitType());return t};y.prototype._getObjectStatus=function(){var t=this.getAggregation("_objectStatus");if(!t){t=new s;this.setAggregation("_objectStatus",t)}t.setText(this.getInfo()).setState(this.getInfoState()).setShowStateIcon(this.getShowInfoStateIcon()).setCustomIcon(this.getCustomInfoStatusIcon()).setInverted(this.getInfoStateInverted());return t};y.prototype._getVisibleAttributes=function(){return this.getAttributes().filter(function(t){return t.getVisible()})};return y});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/ListContentItemRenderer", ["sap/ui/integration/library","sap/ui/core/Renderer","sap/ui/core/IconPool","sap/m/ListItemBaseRenderer"],function(e,t,n,i){"use strict";var s=t.extend(i);s.apiVersion=2;var r=e.AttributesLayoutType;s.renderLIAttributes=function(e,t){e.class("sapUiIntLCI");var i=t.getLinesCount(),s=t.getIcon(),r=t.getActionsStrip();if(i===1){e.class("sapUiIntLCIOneLine");if(s&&s.trim()&&!n.isIconURI(s)){e.class("sapUiIntLCIThumbnail")}}else if(i===2){e.class("sapUiIntLCITwoLines")}else{e.class("sapUiIntLCIMultipleLines")}if(r&&r.hasVisibleItems()){e.class("sapUiIntLCIWithActionsStrip")}};s.renderLIContent=function(e,t){var n=t.getMicrochart();var i=t.getActionsStrip();e.openStart("div").class("sapUiIntLCIContent").openEnd();e.openStart("div").class("sapUiIntLCIIconAndLines").openEnd();if(!t.isPropertyInitial("icon")||!t.isPropertyInitial("iconInitials")){e.renderControl(t._getAvatar())}e.openStart("div").class("sapUiIntLCILines").openEnd();this.renderTitle(e,t);if(t.getDescription()&&t.getDescriptionVisible()){this.renderDescription(e,t)}this.renderItemAttributes(e,t);if(n){e.renderControl(n)}e.close("div");e.close("div");if(i&&i.hasVisibleItems()){e.renderControl(i)}e.close("div")};s.renderTitle=function(e,t){var n=t.getTitle(),i=t.getHasInfo();e.openStart("div").class("sapUiIntLCITitleWrapper").openEnd();e.openStart("div").class("sapUiIntLCITitle").openEnd().text(n).close("div");if(i&&!t.getDescription()&&t.getInfoVisible()){this.renderInfo(e,t)}e.close("div")};s.renderDescription=function(e,t){var n=t.getDescription(),i=t.getHasInfo();e.openStart("div").class("sapUiIntLCIDescriptionWrapper").openEnd();e.openStart("div").class("sapUiIntLCIDescription").openEnd().text(n).close("div");if(i&&t.getInfoVisible()){this.renderInfo(e,t)}e.close("div")};s.renderInfo=function(e,t){var n=t._getObjectStatus();e.openStart("div").class("sapUiIntLCIInfo").openEnd();if(n){e.renderControl(n)}e.close("div")};s.renderItemAttributes=function(e,t){var n=t._getVisibleAttributes(),i=t.getAttributesLayoutType(),s=n.length,o;if(!s){return}for(o=0;o<s;o++){e.openStart("div").class("sapUiIntLCIAttrRow").openEnd();e.openStart("span").class("sapUiIntLCIAttrCell").openEnd();e.renderControl(n[o]);e.close("span");if(i===r.TwoColumns){o++;if(n[o]){e.openStart("span").class("sapUiIntLCIAttrCell").class("sapUiIntLCIAttrSecondCell").openEnd();e.renderControl(n[o]);e.close("span")}}e.close("div")}};return s},true);
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/Microchart", ["./MicrochartRenderer","sap/m/library","sap/ui/core/Control","sap/ui/core/Lib","sap/ui/base/DataType","sap/base/Log","sap/ui/integration/util/BindingHelper"],function(e,a,t,r,i,o,l){"use strict";var n,s,u,c,p,h,m,f,d,g,y,C,b;var v=a.ValueColor;var w=a.Size;function L(e){if(!e||typeof e!=="string"){return e}var a=i.getType("sap.m.ValueColor").isValid(e);if(!a){o.error("The value for stacked bar color must be a valid 'sap.m.ValueColor'. Given '"+e+"'.","sap.ui.integration.controls.Microchart");return null}return e}function V(e){if(!e){return w.Responsive}if(typeof e!=="string"){return l.reuse(e)}const a=e===w.S||e===w.Responsive;if(!a){o.error("The value for size is not correct. Only size 'S' and 'Responsive' are supported. Given '"+e+"'.","sap.ui.integration.controls.Microchart");return w.Responsive}return e}var B=t.extend("sap.ui.integration.controls.Microchart",{metadata:{library:"sap.ui.integration",properties:{displayValue:{type:"string"},valueColor:{type:"sap.m.ValueColor",defaultValue:v.Neutral},height:{type:"sap.ui.core.CSSSize",defaultValue:"1rem"},size:{type:"sap.m.Size",defaultValue:w.Responsive}},aggregations:{chart:{type:"sap.ui.core.Control",multiple:false}}},renderer:e});B.loadDependencies=function(){return new Promise(function(e,a){r.load({name:"sap.suite.ui.microchart"}).then(function(){sap.ui.require(["sap/suite/ui/microchart/BulletMicroChart","sap/suite/ui/microchart/BulletMicroChartData","sap/suite/ui/microchart/StackedBarMicroChart","sap/suite/ui/microchart/StackedBarMicroChartBar","sap/suite/ui/microchart/HarveyBallMicroChart","sap/suite/ui/microchart/HarveyBallMicroChartItem","sap/suite/ui/microchart/LineMicroChart","sap/suite/ui/microchart/LineMicroChartLine","sap/suite/ui/microchart/LineMicroChartPoint","sap/suite/ui/microchart/RadialMicroChart","sap/suite/ui/microchart/ColumnMicroChart","sap/suite/ui/microchart/ColumnMicroChartData","sap/suite/ui/microchart/ColumnMicroChartLabel"],function(){n=arguments[0];s=arguments[1];u=arguments[2];c=arguments[3];p=arguments[4];h=arguments[5];m=arguments[6];f=arguments[7];d=arguments[8];g=arguments[9];y=arguments[10];C=arguments[11];b=arguments[12];e()},function(e){a(e)})}).catch(function(){a("The usage of Microcharts is not available with this distribution.")})})};B.create=function(e,a){var t,r="1rem";if(e.type==="Bullet"){t=B._createBulletChart(e)}else if(e.type==="StackedBar"){t=B._createStackedBarChart(e)}else if(e.type==="HarveyBall"){t=B._createHarveyBallChart(e);r="3rem"}else if(e.type==="Line"){t=B._createLineChart(e);r="3rem"}else if(e.type==="Radial"){t=B._createRadialChart(e);r="2rem"}else if(e.type==="Column"){t=B._createColumnChart(e);r="3rem"}const i=new B({valueColor:l.reuse(e.color),size:V(e.size),displayValue:e.displayValue,chart:t,height:r,visible:e.visible});if(a){i.addStyleClass("sapUiIntMicrochartInHeader")}return i};B._createBulletChart=function(e){var a=[];if(e.thresholds){a=e.thresholds.map(function(e){return new s({value:e.value,color:e.color})})}return new n({size:V(e.size),minValue:e.minValue,maxValue:e.maxValue,targetValue:e.target,showTargetValue:!!e.target,scaleColor:"Light",scale:e.scale,actual:new s({value:e.value,color:l.reuse(e.color)}),thresholds:a})};B._createStackedBarChart=function(e){var a=e.bars.map(function(e){var a=L(e.color);return new c({value:e.value,displayValue:e.displayValue,valueColor:a})});return new u({size:V(e.size),bars:a,maxValue:e.maxValue,displayZeroValue:e.displayZeroValue})};B._createHarveyBallChart=function(e){var a=L(e.color);return new p({size:V(e.size),total:e.total,totalScale:e.totalScale,alignContent:"Right",items:[new h({fraction:e.fraction,fractionScale:e.fractionScale,color:l.reuse(a),fractionLabel:e.fractionLabel,formattedLabel:false})]})};B._createLineChart=function(e){var a=L(e.color);var t=new m({size:V(e.size),color:l.reuse(a),maxXValue:e.maxXValue,minXValue:e.minXValue,maxYValue:e.maxYValue,minYValue:e.minYValue,threshold:e.threshold,leftTopLabel:e.leftTopLabel,leftBottomLabel:e.leftBottomLabel,rightTopLabel:e.rightTopLabel,rightBottomLabel:e.rightBottomLabel});if(Array.isArray(e.points)){e.points.forEach(function(e){t.addPoint(new d({x:e.x,y:e.y}))})}else if(e.points?.path&&e.points?.template){t.bindAggregation("points",{path:e.points.path,template:new d(e.points.template),templateShareable:true})}if(Array.isArray(e.lines)){e.lines.forEach(function(e){var a=L(e.color);t.addLine(new f({color:a,showPoints:e.showPoints,type:e.lineType,points:e.points.map(function(e){return new d({x:e.x,y:e.y})})}))})}else if(e.lines?.path&&e.lines?.template){var r=e.lines.template;var i=new f({color:r.color,showPoints:r.showPoints,type:r.lineType});if(r.points?.path&&r.points?.template){i.bindAggregation("points",{path:r.points.path,template:new d(r.points.template),templateShareable:true})}t.bindAggregation("lines",{path:e.lines.path,template:i,templateShareable:true})}else{o.info("lines or points property is not properly configured for the LineMicroChart","sap.ui.integration.controls.Microchart")}return t};B._createRadialChart=function(e){var a=L(e.color);return new g({size:V(e.size),valueColor:l.reuse(a),total:e.total,showPercentageSymbol:e.showPercentageSymbol,percentage:e.percentage,fraction:e.fraction,alignContent:"Right"})};B._createColumnChart=function(e){var a={size:V(e.size),allowColumnLabels:e.allowColumnLabels,leftTopLabel:new b({label:e.leftTopLabel}),leftBottomLabel:new b({label:e.leftBottomLabel}),rightTopLabel:new b({label:e.rightTopLabel}),rightBottomLabel:new b({label:e.rightBottomLabel})};var t=new y(a);if(Array.isArray(e.columns)){e.columns.forEach(function(e){var a=L(e.color);t.addColumn(new C({color:a,label:e.label,displayValue:e.displayValue,value:e.value}))})}else if(e.columns?.path&&e.columns?.template){t.bindAggregation("columns",{path:e.columns.path,template:new C(e.columns.template),templateShareable:true})}else{o.info("Columns property is not properly configured for the ColumnMicroChart","sap.ui.integration.controls.Microchart")}return t};return B});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/MicrochartLegend", ["./MicrochartLegendRenderer","sap/m/Text","sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/theming/Parameters","sap/ui/integration/util/BindingHelper"],function(e,t,i,n,o,r){"use strict";var s=i.extend("sap.ui.integration.controls.MicrochartLegend",{metadata:{library:"sap.ui.integration",aggregations:{_titles:{type:"sap.m.Text",multiple:true,visibility:"hidden"}},associations:{chart:{type:"sap.ui.core.Control",multiple:false}},events:{colorsLoad:{}}},renderer:e});s.prototype.onBeforeRendering=function(){this._mLegendColors={};this._loadLegendColors()};s.prototype.onAfterRendering=function(){this._equalizeWidths()};s.prototype._equalizeWidths=function(){var e=this.$().children(".sapUiIntMicrochartLegendItem"),t=0;e.css("width","");e.each(function(){var e=this.getBoundingClientRect().width;if(e>t){t=e}});e.css("min-width",t+"px")};s.prototype.initItemsTitles=function(e,i){this.destroyAggregation("_titles");e.forEach(function(e,n){var o=r.prependRelativePaths(e.legendTitle,i+"/"+n);var s=new t({text:o});s.addEventDelegate({onAfterRendering:this._equalizeWidths},this);this.addAggregation("_titles",s)}.bind(this))};s.prototype._loadLegendColors=function(){var e=n.getElementById(this.getChart()),t=[],i;if(e){t=e._calculateChartData().filter(function(e){return e.color?.startsWith("sapUi")}).map(function(e){return e.color})}if(t.length>0){i=o.get({name:t,callback:function(e){this._handleColorsLoad(t,e)}.bind(this)})}if(this._mLegendColors!==undefined){this._handleColorsLoad(t,i)}};s.prototype._handleColorsLoad=function(e,t){if(typeof t==="string"){this._mLegendColors={};this._mLegendColors[e[0]]=t}else if(t){this._mLegendColors=t}this.fireColorsLoad()};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/MicrochartLegendRenderer", ["sap/m/library","sap/ui/core/Element"],function(e,r){"use strict";var t=e.ValueColor;var n={apiVersion:2};n.render=function(e,t){var a=r.getElementById(t.getChart()),o=[],i=t.getAggregation("_titles");if(a){o=a._calculateChartData().map(function(e){return e.color})}e.openStart("div",t).class("sapUiIntMicrochartLegend").openEnd();o.forEach(function(r,a){e.openStart("div").class("sapUiIntMicrochartLegendItem").openEnd();e.openStart("div");n.addColor(e,t,r);e.openEnd().close("div");e.renderControl(i[a]);e.close("div")});e.close("div")};n.addColor=function(e,r,n){if(t[n]){e.class("sapUiIntMicrochartLegendItem"+n)}else{var a=r._mLegendColors[n]||n;e.style("background",a)}};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/controls/MicrochartRenderer", ["sap/m/library"],function(t){"use strict";const e=t.Size;const i={apiVersion:2};i.render=function(t,i){const n="sapUiIntMicrochartValue"+i.getValueColor();t.openStart("div",i).class("sapUiIntMicrochartChartWrapper").openEnd();t.openStart("div").class("sapUiIntMicrochartChart").class("sapUiIntMicrochartSize"+i.getSize());if(i.getSize()===e.Responsive){t.style("height",i.getHeight())}t.openEnd();t.openStart("div").class("sapUiIntMicrochartChartInner").openEnd().renderControl(i.getChart()).close("div");t.close("div");const s=i.getDisplayValue();if(s){t.openStart("div").class("sapMSLIInfo").class(n).openEnd().text(s).close("div")}t.close("div")};return i},true);
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/controls/ObjectStatus", ["sap/m/library","sap/ui/core/library","sap/m/ObjectStatus","sap/m/ObjectStatusRenderer"],function(t,e,a,o){"use strict";var s=t.EmptyIndicatorMode;var n=e.ValueState;var r=a.extend("sap.ui.integration.controls.ObjectStatus",{metadata:{library:"sap.ui.integration",properties:{showStateIcon:{type:"boolean",defaultValue:false},customIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null}}},renderer:o});r.prototype._isEmpty=function(){return this.getEmptyIndicatorMode()===s.Off&&this._hasNoValue()};r.prototype._shouldRenderEmptyIndicator=function(){return this.getEmptyIndicatorMode()===s.On&&this._hasNoValue()};r.prototype._hasNoValue=function(){return!this.getText()&&(!this.getShowStateIcon()||this.getShowStateIcon()&&this.getState()===n.None&&!this.getIcon())};r.prototype.onBeforeRendering=function(){this.addStyleClass("sapUiIntObjStatus");if(!this.getShowStateIcon()){return}const t=this.getCustomIcon();if(t){this.setIcon(t)}else{let t="";switch(this.getState()){case n.Success:t="sap-icon://sys-enter-2";break;case n.Error:t="sap-icon://error";break;case n.Warning:t="sap-icon://warning";break;case n.Information:t="sap-icon://information";break}this.setIcon(t)}};return r});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/customElements/CustomElementBase", ["sap/ui/integration/util/Utils","sap/base/strings/hyphenate","sap/base/strings/camelize"],function(t,e,i){"use strict";function n(){if(this.constructor===n){throw new TypeError('Abstract class "CustomElementBase" cannot be instantiated directly.')}return Reflect.construct(HTMLElement,[],this.constructor)}n.prototype=Object.create(HTMLElement.prototype);n.prototype.constructor=n;n.prototype.connectedCallback=function(){this._init();this._upgradeAllProperties();this._oControlInstance.placeAt(this.firstElementChild);this._attachEventListeners()};n.prototype.disconnectedCallback=function(){if(this._oControlInstance){this._oControlInstance.destroy();delete this._oControlInstance}if(this.firstElementChild){this.removeChild(this.firstElementChild)}};n.prototype.attributeChangedCallback=function(e,o,s){this._init();var r=i(e);if(t.isJson(s)){s=JSON.parse(s)}if(this._mAllProperties[r]){this._mAllProperties[r].set(this._oControlInstance,s)}else if(this._mAllAssociations[r]){var a=document.getElementById(s);if(a instanceof n){s=document.getElementById(s)._getControl()}this._mAllAssociations[r].set(this._oControlInstance,s)}};n.prototype._init=function(){if(!this._oControlInstance){this._oControlInstance=new this._ControlClass}if(!this.firstElementChild){var t=document.createElement("div");this.appendChild(t)}};n.prototype._getControl=function(){this._init();return this._oControlInstance};n.prototype._attachEventListeners=function(){Object.keys(this._oMetadata.getEvents()).map(function(t){this._oControlInstance.attachEvent(t,function(e){this.dispatchEvent(new CustomEvent(t,{detail:e,bubbles:true}))},this)}.bind(this))};n.prototype._upgradeAllProperties=function(){this._aAllProperties.forEach(this._upgradeProperty.bind(this))};n.prototype._upgradeProperty=function(t){if(this[t]){var e=this[t];delete this[t];this[t]=e}};n.generateAccessors=function(t,i){i.forEach(function(i){Object.defineProperty(t,i,{get:function(){return this.getAttribute(e(i))},set:function(t){if(typeof t==="object"){t=JSON.stringify(t)}this.setAttribute(e(i),t)}})})};n.define=function(t,e,i){i=i||[];n.awaitDependencies(i).then(function(){window.customElements.define(t,e)})};n.awaitDependencies=function(t){var e=t.map(function(t){return window.customElements.whenDefined(t)});return Promise.all(e)};n.extend=function(t,i){function o(){return n.apply(this,arguments)}o.prototype=Object.create(n.prototype);o.prototype.constructor=o;var s=o.prototype,r="";s._ControlClass=t;s._oMetadata=t.getMetadata();s._mAllAssociations=s._oMetadata.getAllAssociations();s._mAllProperties=s._oMetadata.getAllProperties();s._aAllProperties=[];if(i&&i.customProperties){s._mAllProperties=Object.assign(s._mAllProperties,i.customProperties)}for(r in s._mAllProperties){if(i&&i.privateProperties&&i.privateProperties.indexOf(r)!==-1){continue}s._aAllProperties.push(r)}for(r in s._mAllAssociations){s._aAllProperties.push(r)}Object.defineProperty(o,"observedAttributes",{get:function(){var t=s._aAllProperties.map(e);return t}});n.generateAccessors(s,s._aAllProperties);return o};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/delegate/OverflowHandler", ["sap/ui/base/Object","sap/ui/integration/delegate/PreventKeyboardScrolling"],function(t,e){"use strict";const n=t.extend("sap.ui.integration.delegate.OverflowHandler",{constructor:function(e){t.call(this);this._oContent=e;this._bIsOverflowing=false;this._oDelegate={onAfterRendering:this._onAfterRendering.bind(this)}}});n.prototype.attach=function(){this._oContent.addEventDelegate(this._oDelegate)};n.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);if(this._oPreventKeyboardScrolling){this._oPreventKeyboardScrolling.destroy();this._oPreventKeyboardScrolling=null}if(this._oHeightObserver){this._oHeightObserver.disconnect();this._oHeightObserver=null}this._oContent.removeEventDelegate(this._oDelegate)};n.prototype._onAfterRendering=function(){const t=this._getContentSection();const e=this._getInnerContent();if(!t||!e){return}if(this._oHeightObserver){this._oHeightObserver.disconnect()}this._oHeightObserver=new ResizeObserver(()=>{this._resize()});this._oHeightObserver.observe(t);this._oHeightObserver.observe(e)};n.prototype._resize=function(){const t=this._isOverflowing();if(t===this._bIsOverflowing){return}this._bIsOverflowing=t;const n=this._oContent.getCardInstance();n.getCardFooter().setShowMoreButton(t);n.toggleStyleClass("sapUiIntCardIsOverflowing",t);if(t&&!this._oPreventKeyboardScrolling){this._oPreventKeyboardScrolling=new e(this._oContent)}this._oPreventKeyboardScrolling?.toggle(t)};n.prototype._getContentSection=function(){const t=this._oContent.getCardInstance();return t?.getDomRef("contentSection")};n.prototype._getInnerContent=function(){const t=this._oContent;let e=t.getAggregation("_content")?.getDomRef();if(!e){e=t.getDomRef()?.firstChild}return e};n.prototype._isOverflowing=function(){const t=this._getContentSection()?.getBoundingClientRect().height;const e=this._getInnerContent()?.getBoundingClientRect().height;return e>t};return n});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/delegate/Paginator", ["sap/ui/base/ManagedObject","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/openCardShowMore","sap/ui/integration/util/Utils","sap/m/BusyIndicator"],(t,e,i,a,o)=>{"use strict";const n=t.extend("sap.ui.integration.delegate.Paginator",{metadata:{library:"sap.ui.integration",properties:{active:{type:"boolean",defaultValue:false},card:{type:"object"},configuration:{type:"object"},paginatorModel:{type:"object"}}}});n.create=function(t){if(!t){return null}const e=new n(t);e._applySettings();e._updatePaginatorModel();return e};n.prototype.init=function(){this._iPageNumber=0;this._iPageCount=0};n.prototype._applySettings=function(){const t=this.getConfiguration();const i=this.getCard();let a=t.pageSize;if(i.isSkeleton()&&!t.totalCount){a=i.getModelSizeLimit()}let o=i;const n=i.getCardContent();if(n){o=i.getCardContent()}this._iTotalCount=e.resolveValue(t.totalCount,o);this._iPageSize=e.resolveValue(a,o)};n.prototype.exit=function(){this._oBusyIndicator?.destroy()};n.prototype.openDialog=function(){const t=this.getCard();return i(t)};n.prototype.isServerSide=function(){return this._iTotalCount>0};n.prototype.onDataChanged=function(t){if(!t.hasData()){this._iPageCount=0;this.fireEvent("_ready");return}this._applySettings();const e=this._iTotalCount||t.getDataLength();this._iPageCount=Math.ceil(e/this._iPageSize);this._iPageNumber=Math.min(Math.max(0,this._iPageNumber),this._getLastPageNumber());if(!this.getActive()){this.fireEvent("_ready");return}if(this.isServerSide()){this._onDataChangedServerSidePagination(t,e);if(this._bInitialLoadComplete){this.fireEvent("_ready")}}else{this.fireEvent("_ready")}};n.prototype.setModelData=function(t,e){const i=this.getCard();const o=i.getManifestEntry("/sap.card/content/data/path")||i.getManifestEntry("/sap.card/data/path")||"/";const n=e.getProperty(o);const r=a.getNestedPropertyValue(t,o);if(n&&r){e.setProperty(o,n.concat(r))}else{e.setData(t)}this._loadingMore=false;this.fireEvent("_loadMoreComplete")};n.prototype.isLoadingMore=function(){return this._loadingMore};n.prototype.reset=function(){this.getPaginatorModel().setData({skip:0,size:0,pageIndex:0});this._iPageNumber=0;this._loadingMore=false};n.prototype.render=function(t){if(this._oBusyIndicator&&this.isLoadingMore()){t.renderControl(this._oBusyIndicator)}};n.prototype.getStaticConfiguration=function(){return{pageCount:this._iPageCount,pageIndex:this._iPageNumber}};n.prototype.getPageCount=function(){return this._iPageCount};n.prototype.getPageSize=function(){return this._iPageSize};n.prototype._onDataChangedServerSidePagination=function(t,e){const i=t.getInnerList();this._oBusyIndicator=this._oBusyIndicator||(new o).addStyleClass("sapUiIntPaginatorBusyIndicator");if(!this._bInitialLoadComplete&&t.getDataLength()<e){this._loadMore();this.attachEventOnce("_loadMoreComplete",()=>{this._bInitialLoadComplete=true})}else{this._bInitialLoadComplete=true}const a=t=>{if(this.isLoadingMore()){return}const i=300;if(t.target.scrollHeight-t.target.scrollTop-t.target.clientHeight<i&&this.getCard().getCardContent().getDataLength()<e){this._loadMore()}};const n={onAfterRendering:()=>{i.removeEventDelegate(n);const o=i.getDomRef().closest(".sapFCardContent");o.removeEventListener("scroll",a);o.addEventListener("scroll",a);if(!this.isLoadingMore()&&t.hasData()&&o.clientHeight>=o.scrollHeight&&t.getDataLength()<e){this._loadMore()}}};i.addEventDelegate(n)};n.prototype._loadMore=function(){if(!this.isServerSide()){return}this._loadingMore=true;this.getCard().getCardContent().invalidate();this._iPageNumber=Math.min(this._getLastPageNumber(),this._iPageNumber+1);this._updatePaginatorModel()};n.prototype._updatePaginatorModel=function(){this.getPaginatorModel().setData({skip:this._iPageNumber*this._iPageSize,size:this._iPageSize,pageIndex:this._iPageNumber})};n.prototype._getLastPageNumber=function(){return Math.max(0,this._iPageCount-1)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/delegate/PreventKeyboardScrolling", ["sap/ui/base/Object"],function(t){"use strict";const e=t.extend("sap.ui.integration.delegate.PreventKeyboardScrolling",{constructor:function(e){t.call(this);this._oContent=e;this._cardKeydownBound=this._cardKeydown.bind(this);this._scrollBound=this._scroll.bind(this)}});e.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this.detach()};e.prototype.toggle=function(t){if(t){this.attach()}else{this.detach()}};e.prototype.attach=function(){const t=this._oContent.getCardInstance()?.getDomRef();const e=this._getContentSection();t.addEventListener("keydown",this._cardKeydownBound);e.addEventListener("scroll",this._scrollBound)};e.prototype.detach=function(){const t=this._oContent.getCardInstance()?.getDomRef();const e=this._getContentSection();t?.removeEventListener("keydown",this._cardKeydownBound);e?.removeEventListener("scroll",this._scrollBound)};e.prototype._getContentSection=function(){const t=this._oContent.getCardInstance();return t?.getDomRef("contentSection")};e.prototype._cardKeydown=function(){this._oLastFocusedElement=document.activeElement};e.prototype._scroll=function(){const t=this._oContent;const e=t.getCardInstance();const n=e.getDomRef();const o=this._getContentSection();o.scrollTop=0;const s=e.getCardFooter();if(!s||!s.getDomRef()){return}const c=s.getFirstFocusableItem();if(!c){return}c.focus();const i=c.getDomRef();const r=t=>{if(t.shiftKey&&t.keyCode==9){this._oLastFocusedElement?.focus();t.preventDefault();i?.removeEventListener("keydown",r);n?.addEventListener("keydown",this._cardKeydownBound)}};n.removeEventListener("keydown",this._cardKeydownBound);i.addEventListener("keydown",r)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Editor", ["sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/Core","sap/base/util/deepClone","sap/base/util/deepEqual","sap/base/util/merge","sap/ui/base/Interface","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/integration/Designtime","sap/ui/model/json/JSONModel","sap/ui/model/odata/v4/ODataModel","sap/ui/integration/util/Utils","sap/ui/integration/util/Destinations","sap/ui/integration/util/DataProviderFactory","sap/m/Label","sap/m/HBox","sap/m/VBox","sap/ui/core/Icon","sap/m/ResponsivePopover","sap/m/Popover","sap/m/Text","sap/base/Log","sap/ui/core/Popup","sap/base/i18n/ResourceBundle","sap/ui/integration/editor/EditorResourceBundles","sap/ui/dom/includeStylesheet","sap/base/util/LoaderExtensions","sap/ui/core/theming/Parameters","sap/base/util/ObjectPath","sap/m/FormattedText","sap/m/MessageStrip","sap/m/ToolbarSpacer","sap/ui/model/resource/ResourceModel","./Manifest","./Merger","./Settings","sap/m/FlexItemData","sap/m/FlexBox","sap/m/Button"],function(e,t,i,a,n,s,r,o,l,d,f,u,g,p,h,c,_,m,v,y,b,I,M,C,P,x,T,D,E,S,A,w,R,L,B,F,O,V,U,j){"use strict";var k=b.prototype.init;b.prototype.init=function(){k.apply(this,arguments);var e=this.oPopup._applyPosition,t=this;this.oPopup._applyPosition=function(){var i=t.close;t.close=function(){};e.apply(this,arguments);t.close=i}};function N(e){if(e&&e.nodeType!==1){return 0}var t=parseInt(window.getComputedStyle(e).getPropertyValue("z-index"));if(isNaN(t)){return N(e.parentNode)}return t+1}var W=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g,H=/\{\{parameters\.([^\}\}]+)/g,q=5e3,G="_strip",K="module:",z;var J=t.extend("sap.ui.integration.editor.Editor",{metadata:{library:"sap.ui.integration",properties:{mode:{type:"string",defaultValue:"admin"},language:{type:"string",defaultValue:""},allowDynamicValues:{type:"boolean",defaultValue:false},allowSettings:{type:"boolean",defaultValue:false},designtime:{type:"object"},section:{type:"string",defaultValue:"sap.card"},host:{type:"string",defaultValue:""},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},json:{type:"object"},previewPosition:{type:"string",defaultValue:"right"},width:{type:"sap.ui.core.CSSSize",defaultValue:""},height:{type:"sap.ui.core.CSSSize",defaultValue:""}},aggregations:{_formContent:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},_preview:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.editor.Extension",multiple:false,visibility:"hidden"}},events:{manifestReady:{},fieldReady:{},destinationReady:{},UIReady:{},ready:{}}},renderer:{apiVersion:2,render:function(e,t){var i=t.getAggregation("_preview");var a=t.getMode()!=="translation"&&t.hasPreview();var s=t.getPreviewPosition();if(a&&(s==="top"||s==="bottom")){e.openStart("div",t);e.openEnd();if(t.isFieldReady()&&s==="top"){e.renderControl(i)}}if(a&&s==="left"){e.openStart("div",t);e.class("sapUiIntegrationEditor");e.openEnd();if(t.isFieldReady()){e.renderControl(i)}}else if(a&&(s==="top"||s==="bottom")){e.openStart("div");e.class("sapUiIntegrationEditor");e.openEnd()}else{e.openStart("div",t);e.class("sapUiIntegrationEditor");e.openEnd()}if(t.isFieldReady()){e.openStart("div");e.class("sapUiIntegrationEditorForm");if(t.getMode()!=="translation"){e.class("settingsButtonSpace")}e.openEnd();if(t.getMode()!=="translation"){e.renderControl(t.getAggregation("_messageStrip"))}var r=t.getAggregation("_formContent");if(r){var l;var d;var f;var u;var g=[];var p=[];var h;var c=function(){if(g.length>0){var e=2-g.length;for(var t=0;t<e;t++){g.push(new m)}l.addContent(new U({alignItems:"Start",justifyContent:"SpaceBetween",items:g}));g=[]}};var v=function(){if(p.length>0){var e=2-p.length;for(var t=0;t<e;t++){p.push(new m)}d.addContent(new U({alignItems:"Start",justifyContent:"SpaceBetween",items:p}));p=[]}};var y=function(t){if(t.getContent().length>0){var i=t.getContent();if(i.length===1&&i[0].isA("sap.m.MessageStrip")){return}if(i[0].isA("sap.m.MessageStrip")){t.removeContent(0);t.addContent(i[0])}e.renderControl(t.getParent());if(t._messageStrip){e.renderControl(t._messageStrip)}}};var b=function(e,t){if(e&&t.getContent().length>0){var i=t.getContent();if(i[0].isA("sap.m.MessageStrip")){t.removeContent(0);t.addContent(i[0])}e.addContent(t.getParent());if(t._messageStrip){e.addContent(t._messageStrip)}}else{t=null}};var I=function(e,t){var i=e.getContent(),a;if(i.length>0){for(var n=0;n<i.length;n++){if(i[n].getAggregation("_field")&&i[n].getAggregation("_field").isA("sap.m.IconTabBar")){a=i[n].getAggregation("_field")}}}if(a&&t.getContent().length>0){a.addItem(t)}};for(var M=0;M<r.length;M++){var C=r[M];if(t.getMode()!=="translation"){if(C.isA("sap.ui.integration.editor.fields.GroupField")){var P=C.getAggregation("_field");if(!P){continue}if(d){v();if(P.isA("sap.m.Panel")&&d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}var x=0;if(P.isA("sap.m.Panel")){x=P._level}else if(P.isA("sap.m.IconTabBar")){x="1"}if(x==="1"){if(g.length>0){c()}if(P.isA("sap.m.IconTabBar")){var T=l.getContent(),D=false,E;if(T.length>0){for(var S=0;S<T.length;S++){if(T[S].getAggregation("_field")&&T[S].getAggregation("_field").isA("sap.m.IconTabBar")){D=true;E=T[S].getAggregation("_field")}}}d=P.getItems()[0];d._subItems=d._subItems||[];if(!D){P.removeItem(P.getItems()[0]);if(P._messageStrip){l.addContent(P._messageStrip)}P.addStyleClass("sapUiIntegrationEditorSubTab");l.addContent(C)}else{E.addItem(P.getItems()[0]);P.destroy()}}else{d=P;d._subItems=d._subItems||[]}}else{if(l){c();y(l);d=null}l=P;l._subItems=l._subItems||[];l.addStyleClass("sapUiIntegrationEditorItem")}if(M===r.length-1){c();y(l)}continue}if(C.isA("sap.m.FormattedText")){if(d){d.addContent(C.addStyleClass("sapUiIntegrationEditorHint"))}else{l.addContent(C.addStyleClass("sapUiIntegrationEditorHint"))}if(M===r.length-1){if(d){v();b(l,d)}c();y(l)}continue}var A=C._layout;if(C.isA("sap.m.Label")){C.addStyleClass("sapUiIntegrationEditorItemLabel");if(C.getRequired()){C.addStyleClass("sapUiIntegrationEditorItemLabelWithRequired")}if(A&&!n(A,{})){if(A.alignment&&A.alignment.label==="end"){C.setTextAlign("End")}u=C}else{if(C._cols===2){if(d){v()}else{c()}}else if(p.length===2){v()}else if(g.length===2){c()}if(d){d.addContent(C)}else{l.addContent(C)}}}else if(C.isA("sap.m.ToolbarSpacer")){if(C._hasLine){C.addStyleClass("sapUiIntegrationEditorSpacerWithLine")}else{C.addStyleClass("sapUiIntegrationEditorSpacerWithoutLine")}if(d){v();d.addContent(C)}else{c();l.addContent(C)}}else{var w=C.getConfiguration(),R=new _,L=.1,B=0,F;if(C._descriptionIcon){R.addItem(C._descriptionIcon);L+=.9}var O=o.getElementById(C.getAssociation("_messageIcon"));if(C.getAssociation("_messageIcon")&&O){R.addItem(O);L+=1.2}if(C._settingsButton){C._settingsButton.addStyleClass("sapUiIntegrationEditorSettingsButton");B=2}var j=new V({growFactor:10,maxWidth:"calc(100% - "+B+"rem)"});var k=new V({maxWidth:"calc(100% - "+L+"rem)"});if(u){var N,W,H="50%";if(A&&A["label-width"]){H=A["label-width"]}var q=parseInt(H);var G=100-q;if(C._cols===2){q=q-.5;G=G-.5}if(A.alignment&&A.alignment.field==="end"){C.addStyleClass("sapUiIntegrationEditorFieldAlignEnd")}if(A.alignment&&A.alignment.label==="end"){u.setLayoutData(new V({maxWidth:"calc(100% - "+L+"rem)",minWidth:"calc(100% - "+L+"rem)"}))}else{u.setLayoutData(k)}if(R.getItems().length>0){u.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");F=new _({items:[u,R]})}else{F=u}if(A&&A.position&&A.position==="field-label"){F.setLayoutData(j);W=new _({alignItems:"Start",justifyContent:"SpaceBetween",items:[F,C._settingsButton]});W.setLayoutData(new V({growFactor:q,maxWidth:q+"%"}));C.setLayoutData(new V({growFactor:G,maxWidth:G+"%"}));N=new _({alignItems:"Start",justifyContent:"SpaceBetween",items:[C,W]})}else{C.setLayoutData(j);W=new _({alignItems:"Start",justifyContent:"SpaceBetween",items:[C,C._settingsButton]});F.setLayoutData(new V({growFactor:q,maxWidth:q+"%"}));W.setLayoutData(new V({growFactor:G,maxWidth:G+"%"}));N=new _({alignItems:"Start",justifyContent:"SpaceBetween",items:[F,W]})}if(C._cols===1){if(d){if(p.length===2){v()}if(w.hint){var K=t._createHint(w.hint,C.getParameterId());var z=new m({items:[N,K.addStyleClass("sapUiIntegrationEditorHint")]});z.addStyleClass("col1");p.push(z)}else{N.addStyleClass("col1");p.push(N)}}else{if(g.length===2){c()}if(w.hint){var K=t._createHint(w.hint,C.getParameterId());var z=new m({items:[N,K.addStyleClass("sapUiIntegrationEditorHint")]});z.addStyleClass("col1");g.push(z)}else{N.addStyleClass("col1");g.push(N)}}}else if(d){v();d.addContent(N)}else{c();l.addContent(N)}u=null}else{var J;if(d){J=d.getContent().pop()}else{J=l.getContent().pop()}J.setLayoutData(k);if(R.getItems().length>0){J.addStyleClass("sapUiIntegrationEditorItemLabelWithInfo");F=new _({items:[J,R]})}else{F=J}F.setLayoutData(j);var X=new U({alignItems:"Start",justifyContent:"SpaceBetween",items:[F,C._settingsButton]});if(C._cols===1){var z=new m({items:[X,C]});if(w.hint){var K=t._createHint(w.hint,C.getParameterId());z.addItem(K.addStyleClass("sapUiIntegrationEditorHint"))}z.addStyleClass("col1");if(d){p.push(z)}else{g.push(z)}}else if(d){d.addContent(X);d.addContent(C)}else{l.addContent(X);l.addContent(C)}}if(d){d._subItems.push({settingspath:C.getConfiguration()._settingspath,itemId:C.getId()})}l._subItems.push({settingspath:C.getConfiguration()._settingspath,itemId:C.getId()})}if(M===r.length-1){if(d){v();if(d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}c();y(l)}}else{if(M===0){f=C.getAggregation("_field");e.renderControl(C);C.addStyleClass("sapUiIntegrationEditorTranslationPanel");continue}if(C.isA("sap.ui.integration.editor.fields.GroupField")){var P=C.getAggregation("_field");if(d){if(P.isA("sap.m.Panel")&&d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}var Y=0;if(P.isA("sap.m.Panel")){Y=P._level}else if(P.isA("sap.m.IconTabBar")){if(P.getItems().length>0&&P.getItems()[0]._level){Y=P.getItems()[0]._level}}if(Y==="1"){if(P.isA("sap.m.IconTabBar")){if(M!==r.length-1||M<r.length&&(r[M].isA("sap.m.IconTabBar")||r[M].isA("sap.m.Panel"))){var Z=l.getContent(),Q=false;if(Z.length>0){for(var $=0;$<Z.length;$++){if(Z[$].getAggregation("_field")&&Z[$].getAggregation("_field").isA("sap.m.IconTabBar")){Q=true}}}if(!Q){d=P.getItems()[0];P.removeItem(P.getItems()[0]);l.addContent(P.getParent())}else{d=P.getItems()[0]}}}else{d=P}}else{d=null;if(l&&l.getContent().length>0){f.addContent(l.getParent())}l=P}if(M===r.length-1){c();y(l)}continue}if(C.isA("sap.m.ToolbarSpacer")){continue}if(C.isA("sap.m.FormattedText")){continue}if(C.isA("sap.m.Label")){if(d){d.addContent(C)}else{l.addContent(C)}continue}if(C.isOrigLangField){h=C;continue}h.addStyleClass("sapUiIntegrationFieldTranslationText");var N=new _({items:[h,C]}).addStyleClass("notWrappingRow");if(d){d.addContent(N)}else{l.addContent(N)}if(M===r.length-1){if(d){if(d.isA("sap.m.Panel")){b(l,d)}else{I(l,d)}}f.addContent(l.getParent())}}}}e.close("div");if(a&&s==="right"){e.renderControl(i)}}e.close("div");if(a&&(s==="top"||s==="bottom")){if(s==="bottom"){e.renderControl(i)}e.close("div")}if(t.isFieldReady()&&!t.isReady()){t.fireUIReady();if(t._aFieldDataReadyPromise.length>0){Promise.all(t._aFieldDataReadyPromise).then(function(){t._aFieldDataReadyPromise=[];if(!t.isReady()){t._ready=true;t.fireReady()}})}else{t._ready=true;t.fireReady()}}}}});J.prototype.init=function(){if(J.oResourceBundle&&J.oResourceBundle.sLocale!==g._language){J.oResourceBundle=l.getResourceBundleFor("sap.ui.integration",g._language);this._applyLanguageChange()}this._fieldReady=false;this._ready=false;this._aFieldReadyPromise=[];this._aFieldDataReadyPromise=[];this._oResourceBundle=l.getResourceBundleFor("sap.ui.integration",g._language);this._appliedLayerManifestChanges=[];this._currentLayerManifestChanges={};this._mDestinationDataProviders={};var t=new w(this.getId()+G,{showIcon:false});t.addStyleClass("sapUiIntegrationEditorFieldMessageStrip");this.setAggregation("_messageStrip",t);G=t.getId();this.setLanguage(e.getLanguage());this._oLimitedInterface=new r(this,["getParameters","resolveDestination","request","getModel"])};J.prototype.getParameters=function(){if(!this._isManifestReady){M.error("sap.ui.integration.editor.Editor: the manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null}var e=this._oEditorManifest.getProcessedParameters(),t={},i;for(i in e){t[i]=e[i].value}return t};J.prototype.resolveDestination=function(e){return this._oDestinations.getUrl(e)};J.prototype.isReady=function(){return this._ready};J.prototype.isFieldReady=function(){return this._fieldReady};J.prototype.hasPreview=function(){var e=this.getAggregation("_preview");if(e&&e.visible!==false){return true}return false};J.prototype.getSeparatePreview=function(){var e=this.getPreviewPosition();if(!this.isFieldReady()||e!=="separate"){return null}if(!this._oPreview){this._oPreview=this.getAggregation("_preview")}return this._oPreview};J.prototype.flattenData=function(e,t,i,a){a=a||"";i=i||[];if(typeof e==="object"){if(!e[t]){for(var n in e){this.flattenData(e[n],t,i,a+"/"+n)}}else{if(e.type){i.push({path:e.pathvalue||a.substring(1),value:e.pathvalue||"{context>"+a.substring(1)+"/value}",object:e})}else{i.push({path:a.substring(1),object:e});for(var n in e){this.flattenData(e[n],t,i,a+"/"+n)}}}}return i};J.prototype.setJson=function(e,t){this._fieldReady=false;this._ready=false;if(n(e,this._preIdOrSettings)){return this}this._preIdOrSettings=a(e,500);if(typeof e==="string"){try{e=JSON.parse(e)}catch(e){}}if(typeof e==="object"){if(e.manifestChanges){g.mapLanguagesInManifestChanges(e.manifestChanges);this._filterManifestChangesByLayer(e)}if(this._manifestModel){return}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy()}if(e.host){this.setProperty("host",e.host)}if(e.baseUrl){this.setProperty("baseUrl",e.baseUrl)}this._appliedLayerManifestChanges=e.manifestChanges;this.createManifest(e,t)}};J.prototype.createManifest=function(e,t){var i=this.getBaseUrl();var a={},n=e.manifest;this._isManifestReady=false;if(typeof n==="string"){a.manifestUrl=n;n=null}if(this._oEditorManifest){this._oEditorManifest.destroy()}this.destroyAggregation("_extension");var r=F.layers[this.getMode()];this._oEditorManifest=new B(this.getSection(),n,i,e.manifestChanges);this._oEditorManifest.load(a).then(async function(){this._registerManifestModulePath();this._oInitialManifestModel=new f(this._oEditorManifest._oInitialJson);this.setProperty("json",this._oEditorManifest._oInitialJson,t);var e=this._oEditorManifest.oJson;var i=s({},e);this._beforeManifestModel=new f(i);if(r<F.layers["translation"]&&this._currentLayerManifestChanges){e=F.mergeDelta(e,[this._currentLayerManifestChanges],this.getSection())}this._manifestModel=new f(e);this._isManifestReady=true;this.fireManifestReady();this._initResourceBundlesForMultiTranslation();this._loadDefaultTranslations();if(this.getMode()==="translation"){await this._loadSpecialTranslations()}this._createContextModel();if(this._oEditorManifest.getResourceBundle()){this._enhanceI18nModel(this._oEditorManifest.getResourceBundle())}return this._loadExtension().then(function(){this._initInternal()}.bind(this))}.bind(this))};J.prototype._initResourceBundlesForMultiTranslation=function(){var e=this._oEditorManifest.get("/sap.app/i18n");var t;var i;if(typeof e==="string"){t=this.getBaseUrl()+e}else if(typeof e==="object"){if(e.bundleUrl){t=this.getBaseUrl()+e.bundleUrl}if(e.supportedLocales){i=e.supportedLocales}}this._oEditorResourceBundles=new x({url:t,languages:J._oLanguages,supportedLocales:i});this._oEditorResourceBundles.loadResourceBundles()};J.prototype._registerManifestModulePath=function(){if(!this._oEditorManifest){return}this._sAppId=this._oEditorManifest.get("/sap.app/id");if(this._sAppId){D.registerResourcePath(this._sAppId.replace(/\./g,"/"),this._oEditorManifest.getUrl()||"/")}else{M.error("sap.ui.integration.editor.Editor: sap.app/id entry in the manifest is mandatory")}};J.prototype._loadDefaultTranslations=async function(){if(this._defaultTranslationsLoaded){return}var e=new L({bundle:this._oResourceBundle});await e.getResourceBundle();this.setModel(e,"i18n");this._defaultTranslationsLoaded=true};J.prototype._enhanceI18nModel=async function(e){var t=this.getModel("i18n");if(t.getResourceBundle().oUrlInfo.url!==e.oUrlInfo.url){await t.enhance(e);this._oResourceBundle=await t.getResourceBundle()}};J.prototype._loadExtension=function(){var e=this._oEditorManifest.get(this.getConfigurationPath()+"/extension")||this._oEditorManifest.get("/"+this.getSection()+"/extension"),t;if(!e){M.info("sap.ui.integration.editor.Editor: extension is not defined in manifest, do not load it.");return new Promise(function(e,t){e()})}if(e.startsWith(K)){t=e.replace(K,"")}else{t=this._sAppId.replace(/\./g,"/")+"/"+e}return new Promise(function(i,a){sap.ui.require([t],function(e){var t=new e;if(t._setEditor){t._setEditor(this,this._oLimitedInterface);this.setAggregation("_extension",t)}i()}.bind(this),function(t){M.error("sap.ui.integration.editor.Editor: failed to load "+e+". Check if the path is correct. Reason: "+t);a(t)})}.bind(this))};J.prototype.request=function(e){var t=this._oDataProviderFactory.create({request:e}).setAllowCustomDataType(true);return t._waitDependencies().then(function(){return t.getData()})};J.prototype.initDestinations=function(e){this._destinationsModel=new f({});this.setModel(this._destinationsModel,"destinations");var t=this.getHostInstance();if(e&&!t){M.error("sap.ui.integration.editor.Editor: Host with id '"+e+"' is not available during editor initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the editor.","sap.ui.integration.editor.Editor")}if(this._oDestinations){this._oDestinations.setHost(t)}else{var i=this.getConfigurationPath();this._oDestinations=new p({host:t,manifestConfig:this._manifestModel.getProperty(i+"/destinations")})}};J.prototype.initDataProviderFactory=function(){if(this._oDataProviderFactory){this._oDataProviderFactory.destroy()}var e=this.getAggregation("_extension");this._oDataProviderFactory=new h({destinations:this._oDestinations,extension:e,csrfTokensConfig:this._oEditorManifest.get(this.getConfigurationPath()+"/csrfTokens"),editor:this})};J.prototype.getRuntimeUrl=function(e){var t=this._sAppId,i,a=e&&e.trim().replace(/^\//,"");if(t===null){M.error("sap.ui.integration.editor.Editor: manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.editor.Editor");return null}if(!t||e.startsWith("http://")||e.startsWith("https://")||e.startsWith("//")){return e}i=t.replace(/\./g,"/");return sap.ui.require.toUrl(i)+"/"+a};J.prototype.getBindingNamespaces=function(){var e={},t=this.getAggregation("_extension");if(t){e.extension={formatters:t.getFormatters()}}return e};J.prototype.getHostInstance=function(){var e=this.getHost();if(!e){return null}return o.getElementById(e)};J.prototype.setLanguage=function(e,t){if(!e||typeof e!=="string"){return this}this._language=e.replaceAll("_","-");if(this.getLanguage()!=e){this._loadDefaultTranslations()}this.setProperty("language",e,t);if(!J._oLanguages[this._language]){this._language=this._language.split("-")[0]}if(!J._oLanguages[this._language]){M.warning("sap.ui.integration.editor.Editor: language: "+e+" is currently unknown, some UI controls might show "+e+" instead of the language name.")}return this};J.prototype.onAfterRendering=function(){if(this.getDomRef()){this._iZIndex=N(this.getDomRef());C.setInitialZIndex(this._iZIndex)}};J.prototype._filterManifestChangesByLayer=function(t){var i=[],a=this,n={},r={":layer":F.layers[this.getMode()]},o=F.layers[a.getMode()];t.manifestChanges.forEach(function(t){var l=t.hasOwnProperty(":layer")?t[":layer"]:1e3;if(l===F.layers["translation"]){var d=a._language;if(d===""){d=e.getLanguage().replaceAll("_","-")}var f={texts:{}};delete t.texts;f.texts[d]={};Object.keys(t).forEach(function(e){if(e.charAt(0)==="/"){f.texts[d][e]=t[e]}else{f[e]=t[e]}});t=f}if(l<o){i.push(t);n=s(n,t)}else if(l===o){r=t}});t.manifestChanges=i;this._currentLayerManifestChanges=r;this._beforeLayerManifestChanges=n};J.prototype._initInternal=function(){var e=this;var t=e.getConfigurationPath();var i=e._oEditorManifest.get(t+"/editor");if(!i){i=e._oEditorManifest.get("/"+e.getSection()+"/designtime")}var a=e._manifestModel.getProperty(t),n,s=e.getDesigntime();if(s){if(typeof s==="function"){n=new Promise(function(t,i){var a=new s;e._applyDesigntimeDefaults(a.getSettings());t(a)})}else if(typeof s==="object"){n=new Promise(function(t,i){sap.ui.require(["sap/ui/integration/Designtime"],function(i){var a=i.extend("test.Designtime");a.prototype.create=function(){return s};var n=new a;e._applyDesigntimeDefaults(n.getSettings());t(n)})})}}else if(i){n=e.loadDesigntime().then(function(t){e._applyDesigntimeDefaults(t.getSettings());return t})}else{n=Promise.resolve(e._createParameterDesigntime(a))}n.then(function(t){e._oDesigntimeInstance=t;e.initDestinations();e.initDataProviderFactory();if(e.getMode()==="admin"||e.getMode()==="all"){e._addDestinationSettings(a)}else{e._deleleDestinationSettings()}e._settingsModel=new f(e._oDesigntimeInstance.getSettings());e.setModel(e._settingsModel,"currentSettings");e.setModel(e._settingsModel,"items");return e._loadValueContextInDesigntime()}).then(function(){e._applyDesigntimeLayers();return e._requestExtensionData()}).then(function(){e._requireFields().then(function(){e._startEditor()})})};J.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime)}if(!this._oEditorManifest){return new Promise(function(e,t){this.attachManifestReady(function(){this.loadDesigntime().then(e,t)}.bind(this))}.bind(this))}if(!this._sAppId){return Promise.reject("App id not maintained")}return new Promise(function(e,t){var i=this._oEditorManifest.get(this.getConfigurationPath()+"/editor");if(!i){i=this._oEditorManifest.get("/"+this.getSection()+"/designtime")}var a=this._sAppId.replace(/\./g,"/")+"/"+i;if(a){sap.ui.require([a],function(t){t=new t;t._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=t;e(t)}.bind(this))}.bind(this),function(){t({error:a+" not found"})})}else{t()}}.bind(this))};J.prototype.getConfigurationPath=function(){return"/"+this.getSection()+"/configuration"};J.prototype.getCurrentSettings=function(){var e=this._settingsModel.getProperty("/"),t={},i;if(e&&e.form&&e.form.items){for(var r in e.form.items){var o=e.form.items[r];if(o.editable&&o.visible){if(this.getMode()!=="translation"){if(o.translatable&&!o._changed&&o._translatedPlaceholder&&!this._currentLayerManifestChanges[o.manifestpath]){}else{if(o.valueItems&&!n(this._beforeLayerManifestChanges[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueItems"],o.valueItems)){t[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueItems"]=o.valueItems}if(o.valueTokens&&!n(this._beforeLayerManifestChanges[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueTokens"],o.valueTokens)){t[o.manifestpath.substring(0,o.manifestpath.lastIndexOf("/"))+"/valueTokens"]=o.valueTokens}var l=this._beforeLayerManifestChanges[o.manifestpath];if(typeof o.value!=="undefined"&&!n(l,o.value)){switch(o.type){case"string":if(!o.translatable){t[o.manifestpath]=o.value}else if(o._hasDynamicValue){t[o.manifestpath]=o.value;this.deleteAllTranslationValuesInTexts(o.manifestpath)}else if(o._beforeValue&&(o._beforeValue.indexOf("{context>")===0||o._beforeValue.indexOf("{{parameters")===0)){t[o.manifestpath]=o.value}break;case"group":break;case"date":case"datetime":if(l){if(o.value){var d=new Date(l);var f=new Date(o.value);if(d.getTime()!==f.getTime()){t[o.manifestpath]=o.value}}}else if(o.value){t[o.manifestpath]=o.value}break;case"object":if(o.value&&o.value!==""&&typeof o.value==="object"){t[o.manifestpath]=o.value}break;case"object[]":if(Array.isArray(o.value)){var u=a(o.value,500);u=u.sort(function(e,t){if(!e._dt||!e._dt._position||!t._dt||!t._dt._position){return 0}return e._dt._position-t._dt._position});for(var g=0;g<u.length;g++){var p=u[g];p._dt=p._dt||{};p._dt._position=g+1}t[o.manifestpath]=u}break;default:t[o.manifestpath]=o.value}}}}else if(o.translatable&&o.value){if(o._changed){t[o.manifestpath]=o.value}else if(this._currentLayerManifestChanges&&this._currentLayerManifestChanges.texts&&this._currentLayerManifestChanges.texts[this._language]&&this._currentLayerManifestChanges.texts[this._language][o.manifestpath]){t[o.manifestpath]=this._currentLayerManifestChanges.texts[this._language][o.manifestpath]}}if(o._next&&this.getAllowSettings()){if(o.type==="destination"){if(o._next.pageAdminNewDestinationParameter){i=i||{};i[o._settingspath+"/pageAdminNewDestinationParameter"]=o._next.pageAdminNewDestinationParameter}}else{var h=typeof o.visibleToUser==="undefined"?true:o.visibleToUser;var c=typeof o.editableToUser==="undefined"?true:o.editableToUser;var _=typeof o.allowDynamicValues==="undefined"?true:o.allowDynamicValues;if(o._next.visible===!h){i=i||{};i[o._settingspath+"/visible"]=o._next.visible}if(o._next.editable===!c){i=i||{};i[o._settingspath+"/editable"]=o._next.editable}if(o._next.allowDynamicValues===!_){i=i||{};i[o._settingspath+"/allowDynamicValues"]=o._next.allowDynamicValues}if(o._next.pageAdminValues){i=i||{};i[o._settingspath+"/pageAdminValues"]=o._next.pageAdminValues}}}}}}if(this.getMode()==="translation"){delete t.texts}else if(e.texts){t.texts=a(e.texts,500)||{};var m=s({},this._beforeLayerManifestChanges.texts);if(n(m,t.texts)){delete t.texts}else{for(var v in t.texts){if(n(m[v],t.texts[v])){delete t.texts[v]}else{for(var y in t.texts[v]){if(m[v]&&n(m[v][y],t.texts[v][y])){delete t.texts[v][y]}else if(typeof t.texts[v][y]==="object"){var b=t[y];if(!b||typeof b!=="object"||n(b,{})||n(b,[])){delete t.texts[v][y]}else if(Array.isArray(b)){var I=b.map(function(e){return e._dt?e._dt._uuid||"":""});for(var M in t.texts[v][y]){if(!I.includes(M)){delete t.texts[v][y][M]}}}else{var C=b._dt?b._dt._uuid||"":"";if(C!==""){var P=t.texts[v][y][C];if(!P){delete t.texts[v][y]}else{t.texts[v][y]={};t.texts[v][y][C]=P}}else{delete t.texts[v][y]}}}}if(n(t.texts[v],{})){delete t.texts[v]}}}if(n(t.texts,{})){delete t.texts}}}t[":layer"]=F.layers[this.getMode()];t[":errors"]=this.checkCurrentSettings()[":errors"];if(i){t[":designtime"]=i}if(e[":designtime"]){t[":designtime"]=s(t[":designtime"],e[":designtime"])}return t};J.prototype.checkCurrentSettings=function(){var e=this._settingsModel.getProperty("/"),t={};if(e&&e.form&&e.form.items){for(var i in e.form.items){var a=e.form.items[i];if(a.editable){if(a.validateCheck==="failed"){t[a.manifestpath]=false}else if((a.isValid||a.required)&&!(this.getMode()==="translation"&&a.translatable)){if(a.isValid){t[a.manifestpath]=a.isValid(a)}t[a.manifestpath]=true;var n=a.value;var s=a.type;if(s==="string"&&n===""){t[a.manifestpath]=n}if((s==="date"||s==="datetime")&&isNaN(Date.parse(n))){t[a.manifestpath]=n}if(s==="integer"){if(isNaN(parseInt(n))){t[a.manifestpath]=n}else if(n<a.min||n>a.max){t[a.manifestpath]=n}}if(s==="number"){if(isNaN(parseFloat(n))){t[a.manifestpath]=n}else if(n<a.min||n>a.max){t[a.manifestpath]=n}}}}}t[":layer"]=F.layers[this.getMode()]}t[":errors"]=Object.values(t).indexOf(false)>-1;return t};J.prototype._createContextModel=function(){var e=this.getHostInstance(),t=new f({}),i=new f([]);this.setModel(t,"context");this.setModel(i,"contextflat");t._aPendingPromises=[];i._getPathObject=function(e){var t=this.getData().filter(function(t){if(t.path===e){return true}});return t.length?t[0]:null};i._getValueObject=function(e){var t=this.getData()||[];t=t.filter(function(t){if(t.value===e||t.object.value===e){return true}});return t.length?t[0]:null};var a=new Promise(function(t,i){if(e&&e.getContext){var a=false;setTimeout(function(){if(a){return}M.error("sap.ui.integration.editor.Editor: context could not be determined with "+q+".");a=true;t({})},q);e.getContext().then(function(e){if(a){M.error("sap.ui.integration.editor.Editor: context returned after more than "+q+". Context is ignored.")}a=true;t(e||{})})}else{t({})}});a.then(function(e){var a=this._mergeContextData(e);t.setData(a);i.setData(this.flattenData(a,"label"))}.bind(this));t.getProperty=function(t,i){if(t&&!t.startsWith("/")&&!i){t="/"+t}var a=this.resolve(t,i),n;if(a.endsWith("/value")){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(a)){return this._mValues[a]}this._mValues[a]=undefined;n=g.timeoutPromise(e.getContextValue(a.substring(1)));n=n.then(function(e){this._mValues[a]=e;this.checkUpdate()}.bind(this)).catch(function(e){this._mValues[a]=null;this.checkUpdate();M.error("sap.ui.integration.editor.Editor: path "+a+" could not be resolved. Reason: "+e)}.bind(this));this._aPendingPromises.push(n);return undefined}else{return f.prototype.getProperty.apply(this,arguments)}}};J.prototype._mergeContextData=function(e){var t={};t["empty"]=z.empty;for(var i in e){t[i]=e[i]}t["editor.internal"]=z["editor.internal"];return t};J.prototype._loadValueContextInDesigntime=function(){var e=this.getModel("context");var t=this._oDesigntimeInstance.getSettings();var i;if(t&&t.form&&t.form.items){i=JSON.stringify(t.form.items)}if(i){var a=/\{context\>[\/?\w+.]+\}/g;var n=i.match(a);var s;if(n&&n.length>0){n=n.filter(function(e){return e.endsWith("value}")});s=n.map(function(e){return e.substring("{context>".length,e.length-1)});s.forEach(function(t){e.getProperty(t)});return Promise.all(e._aPendingPromises).then(function(){e._aPendingPromises=[]})}}return Promise.resolve()};J.fieldMap={string:"sap/ui/integration/editor/fields/StringField","string[]":"sap/ui/integration/editor/fields/StringListField",integer:"sap/ui/integration/editor/fields/IntegerField",number:"sap/ui/integration/editor/fields/NumberField",boolean:"sap/ui/integration/editor/fields/BooleanField",date:"sap/ui/integration/editor/fields/DateField",datetime:"sap/ui/integration/editor/fields/DateTimeField",object:"sap/ui/integration/editor/fields/ObjectField","object[]":"sap/ui/integration/editor/fields/ObjectListField",destination:"sap/ui/integration/editor/fields/DestinationField",group:"sap/ui/integration/editor/fields/GroupField"};J.Fields=null;J.prototype._requireFields=function(){if(J.Fields){return Promise.resolve()}return new Promise(function(e){sap.ui.require(Object.values(J.fieldMap),function(){J.Fields={};for(var t in J.fieldMap){J.Fields[t]=arguments[Object.keys(J.fieldMap).indexOf(t)]}e()})})};J.prototype._createDescription=function(e,t){var i=new v(this.getId()+"_"+t+"_description_icon",{src:"sap-icon://message-information",color:"Marker",size:"12px",useIconTooltip:false,visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});i.addStyleClass("sapUiIntegrationEditorDescriptionIcon");i.onmouseover=function(t){t.addDependent(this._getPopover());this._getPopover().getContent()[0].applySettings({text:e.description});this._getPopover().openBy(t)}.bind(this,i);i.onmouseout=function(e){this._getPopover().close();e.removeDependent(this._getPopover())}.bind(this,i);return i};J.prototype._createMessageIcon=function(e,t){var i=e.getConfiguration();var a=new v(this.getId()+"_"+t+"_message_icon",{src:"sap-icon://message-information",size:"12px",visible:typeof i.visible==="boolean"?"{currentSettings>visible}":i.visible,useIconTooltip:false,objectBindings:{currentSettings:{path:"currentSettings>"+i._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});a.onmouseover=function(e){e._showMessage()}.bind(this,e);a.onmouseout=function(e){e._hideMessage()}.bind(this,e);a.addStyleClass("sapUiIntegrationEditorMessageIcon");return a};J.prototype._createLabel=function(e,t){var i=new c(this.getId()+"_"+t+"_label",{text:e.label,tooltip:e.tooltip||e.label,required:e.required&&e.editable||false,visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});i._cols=e.cols||2;if(e.layout){i._layout=e.layout}i._sOriginalType=e.type;return i};J.prototype._createSettingsButton=function(e,t){var i=e.getConfiguration();var a=new j(this.getId()+"_"+t+"_settings_btn",{icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",type:"Transparent",tooltip:this._oResourceBundle.getText("EDITOR_FIELD_MORE_SETTINGS"),press:function(t){this._openSettingsDialog(200,t.oSource,e)}.bind(this),visible:typeof i.visible==="boolean"?"{currentSettings>visible}":i.visible,objectBindings:{currentSettings:{path:"currentSettings>"+i._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"}}});return a};J.prototype._getSettingsPanel=function(e){if(!e._oSettingsPanel){e._oSettingsPanel=new O}return e._oSettingsPanel};J.prototype._openSettingsDialog=function(e,t,i){var a=this._getSettingsPanel(i);window.setTimeout(function(){a.setConfiguration(i.getConfiguration());a.open(t,t,this,i.getHost(),i,i._applySettings.bind(i),i._cancelSettings.bind(i))}.bind(this),e||600)};J.prototype._getPopover=function(){if(this._oPopover){return this._oPopover}var e=new I({text:""});e.addStyleClass("sapUiTinyMargin sapUiIntegrationEditorDescriptionText");this._oPopover=new y(this.getId()+"_popover",{showHeader:false,content:[e]});this._oPopover.addStyleClass("sapUiIntegrationEditorPopover");return this._oPopover};J.prototype._createField=function(e,t){var i=new J.Fields[e.type](this.getId()+"_"+t+"_field",{configuration:e,mode:this.getMode(),host:this.getHostInstance(),parameterKey:t,objectBindings:{currentSettings:{path:"currentSettings>"+e._settingspath},items:{path:"items>/form/items"},context:{path:"context>/"},destinations:{path:"destinations>/"}},visible:typeof e.visible==="boolean"?"{currentSettings>visible}":e.visible});i.setAssociation("_editor",this);this._aFieldReadyPromise.push(i._readyPromise.then(function(){if(e.type!=="group"){if(e.require||e.validation||e.validations&&e.validations.length>0||e.values&&e.values.data&&!e.values.data.json){var a=this._createMessageIcon(i,t);i.setAssociation("_messageIcon",a)}if(e.description&&this.getMode()!=="translation"){i._descriptionIcon=this._createDescription(e,t)}if(e._changeDynamicValues){i._settingsButton=this._createSettingsButton(i,t);i._applyButtonStyles()}}}.bind(this)));if(e.type!=="group"){i._oValueBinding=this._settingsModel.bindProperty(e._settingspath+"/value");i._oValueBinding.attachChange(function(){if(!this._bIgnoreUpdates){e._changed=true;if(e._dependentFields&&e._dependentFields.length>0){this._updateEditor(e._dependentFields)}this._updatePreview()}}.bind(this));if(i.isFilterBackend()){var a=this._settingsModel.bindProperty(e._settingspath+"/suggestValue");a.attachChange(function(){var t=s({},e);t._cancel=false;this._addValueListModel(t,i)}.bind(this))}if(e.values){if(e.values.metadata){this._addMetadataModel(e,i)}if(e.type==="string[]"&&i.isFilterBackend()&&e.visualization&&e.visualization.type==="MultiInput"){i.setModel(new f({}),undefined)}else{var n=g.timeoutPromise(this._addValueListModel(e,i));n=n.catch(function(e){M.error("sap.ui.integration.editor.Editor: get data of field "+t+" could not be resolved. Reason: "+e)});this._aFieldDataReadyPromise.push(n)}}this._createDependentFields(e,i);i._oDataProviderFactory=this._oDataProviderFactory}i._cols=e.cols||2;if(e.layout){i._layout=e.layout}i._oEditorResourceBundles=this._oEditorResourceBundles;i.setAssociation("_messageStrip",G);return i};J.prototype._updateEditor=function(e){if(this._fieldReady){if(e.length===0){return}for(var t=0;t<e.length;t++){var i=e[t];i.config._cancel=true}if(!this._oDataProviderFactory){return}this._bIgnoreUpdates=true;for(var t=0;t<e.length;t++){var i=e[t];i.config._cancel=false;this._addValueListModel(i.config,i.field,500*t)}this._bIgnoreUpdates=false}};J.prototype._updatePreview=function(){var e=this.getAggregation("_preview")||this._oPreview;if(e&&e.update){e.update()}};J.prototype._requestData=function(e,t){var i=this._oDataProviderFactory.create(e.values.data);i.bindObject({path:"items>/form/items"});i.bindObject({path:"currentSettings>"+e._settingspath});i.bindObject({path:"context>/"});return i._waitDependencies().then(function(){return i.getData()}).then(function(i){if(e._cancel){e._values=[];this._settingsModel.setProperty(e._settingspath+"/_loading",false);return}var a=e.values.data.path,n,s=[];if(a&&a!=="/"){if(a.startsWith("/")){a=a.substring(1)}if(a.endsWith("/")){a=a.substring(0,a.length-1)}n=a.split("/");s=S.get(n,i)}else{s=i}if(e.type==="object"||e.type==="object[]"){s.forEach(function(e){e._dt={_editable:false}})}if(this.getMode()==="content"&&e.pageAdminValues&&e.pageAdminValues.length>0){var r=e.pageAdminValues,o=e.value,l=e.valueItems||[],d=[],f=[],u=[];this.prepareFieldsInKey(e);if(r.length>0){for(var g=0;g<r.length;g++){for(var p=0;p<s.length;p++){var h=this.getKeyFromItem(s[p]);if(r[g]===h){d.push(s[p])}}if(Array.isArray(o)){for(var c=0;c<o.length;c++){if(r[g]===o[c]){f.push(o[c])}}for(var _=0;_<l.length;_++){var m=this.getKeyFromItem(l[_]);if(r[g]===m){u.push(l[_])}}}}if(f.length>0){e.value=[];e.value=f}if(u.length>0){e.valueItems=[];e.valueItems=u}}if(e.values.data.path&&e.values.data.path!=="/"){delete i[n];S.set(n,d,i)}else{i=[];i=d}}var v=t.getConfiguration();if(e.type==="string[]"){var y=e.values.data.path;if(y&&y!=="/"){if(y.startsWith("/")){y=y.substring(1)}if(y.endsWith("/")){y=y.substring(0,y.length-1)}var n=y.split("/");var b=S.get(n,i);if(Array.isArray(b)){for(var I in b){var M=t.getKeyFromItem(b[I]);if(Array.isArray(v.value)&&v.value.length>0&&v.value.includes(M)){b[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED")}else{b[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED")}}S.set(n,b,i)}}else if(Array.isArray(i)){for(var I in i){var M=t.getKeyFromItem(i[I]);if(Array.isArray(v.value)&&v.value.length>0&&v.value.includes(M)){i[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_SELECTED")}else{i[I].Selected=this._oResourceBundle.getText("EDITOR_ITEM_UNSELECTED")}}}}e._values=i;var C=t.getModel();C.setData(i);C.checkUpdate(true);C.firePropertyChange();if(e.type==="object"||e.type==="object[]"){t.mergeValueWithRequestResult(s)}this._settingsModel.setProperty(e._settingspath+"/_loading",false);t._hideValueState(true,true)}.bind(this)).catch(function(i){var a=new Promise(function(e){var t=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(i)&&i.length>0){t=i[0];var a=i[1];if(a){var n;a.text().then(function(i){if(g.isJson(i)){n=JSON.parse(i).error}else{t=i}if(n){t=(n.code||n.errorCode||a.status)+": "+n.message}e(t)});return}else{e(t);return}}else if(typeof i==="string"){t=i;e(t);return}else{e(t);return}}.bind(this));return a.then(function(i){var a=t.getModel();a.firePropertyChange();if(e.type==="object"||e.type==="object[]"){t.mergeValueWithRequestResult()}this._settingsModel.setProperty(e._settingspath+"/_loading",false);t._showValueState("error",i,true)}.bind(this))}.bind(this))};J.prototype._requestExtensionData=function(){var e=this.getAggregation("_extension");if(!e){M.info("sap.ui.integration.editor.Editor: extension is not defined or created, do not load data of it.");return new Promise(function(e,t){e()})}var t=false;var i={};var a=this._oEditorManifest.get(this.getConfigurationPath()+"/data/extension");var n;if(a){t=true;n=this._oEditorManifest.get(this.getConfigurationPath()+"/data/path");i={extension:a};if(n){i.path=n}}else{a=this._oEditorManifest.get("/"+this.getSection()+"/data/extension");if(a){t=true;n=this._oEditorManifest.get("/"+this.getSection()+"/data/path");i={extension:a};if(n){i.path=n}}}if(!t){M.info("sap.ui.integration.editor.Editor: extension data is not defined in manifest, do not load data of it.");return new Promise(function(e,t){e()})}var s=this._oDataProviderFactory.create(i);return s._waitDependencies().then(function(){return s.getData()}).then(function(t){var i=e.getModel();if(!i){i=new f(t||{});e.setModel(i,undefined)}else{i.setData(t)}i.checkUpdate(true)}).catch(function(e){var t=this._oResourceBundle.getText("EDITOR_BAD_REQUEST");if(Array.isArray(e)&&e.length>0){t=e[0];var i=e[1];if(i){var a;i.text().then(function(e){if(g.isJson(e)){a=JSON.parse(e).error}else{t=e}if(a){t=(a.code||a.errorCode||i.status)+": "+a.message}M.error("sap.ui.integration.editor.Editor: request extension data failed, "+t)})}}else if(typeof e==="string"){t=e;M.error("sap.ui.integration.editor.Editor: request extension data failed, "+t)}}.bind(this))};J.prototype._addValueListModel=function(e,t,i){if(e.values){var a;if(e.values.data){t.bindObject({path:e.values.data.path||"/"});if(this._oDataProviderFactory){a=t.getModel();if(!a){a=new f({});t.setModel(a,undefined)}this._settingsModel.setProperty(e._settingspath+"/_loading",true);if(!i){return this._requestData(e,t)}else{setTimeout(function(){return this._requestData(e,t)}.bind(this),i)}}}else if(this.getAggregation("_extension")){a=this.getAggregation("_extension").getModel();if(a&&this.getMode()==="content"&&e.pageAdminValues&&e.pageAdminValues.length>0){this.prepareFieldsInKey(e);var n=e.values.path;if(n.length>1){n=n.substring(1)}var s=S.get([n],a.getData()),r=e.pageAdminValues,o=[];for(var l=0;l<r.length;l++){for(var d=0;d<s.length;d++){var u=this.getKeyFromItem(s[d]);if(r[l]===u){o.push(s[d])}}}delete s[n];S.set(n,o,s);a.setData(s)}t.bindObject({path:e.values.path||"/"});t.setModel(a,undefined);return Promise.resolve(null)}}};J.prototype._addMetadataModel=function(e,t){if(e.values&&e.values.metadata){var i=s({},e.values.metadata.request);var a={url:i.serviceUrl};var n=Promise.resolve(a);if(this._oDestinations){n=this._oDestinations.process(a)}n.then(function(e){if(!e.url.endsWith("/")){e.url=e.url+"/"}i.serviceUrl=e.url;var a=new u(i);a.oMetaModel.fetchData().then(function(e){t.setModel(new f(e),"meta")})})}};J.prototype._createDependentFields=function(e,t){if(e.values){var i=JSON.stringify(e.values.data);if(i){var a=/parameters\.([^\}\}]+)|destinations\.([^\}\}]+)|\{items\>[\/?\w+]+\}/g,n=i.match(a);if(n){for(var r=0;r<n.length;r++){var o="/value";var l=this.getConfigurationPath();if(n[r].indexOf("destinations.")===0||n[r].indexOf("parameters.")===0){if(n[r].indexOf("destinations.")===0){o="/name"}l=l+"/"+n[r].replace(".","/")+o}else if(n[r].indexOf("{items>")===0){l=l+"/parameters/"+n[r].slice(7,-1)}var d=this._mItemsByPaths[l];if(d){if(d._settingspath===e._settingspath){e=s({},e)}d._dependentFields=d._dependentFields||[];d._dependentFields.push({field:t,config:e})}}}}}};J.prototype.getBeforeLayerChange=function(e){if(!this._beforeLayerManifestChanges){this._beforeLayerManifestChanges={}}return this._beforeLayerManifestChanges[e]};J.prototype.getTranslationValueInTexts=function(e,t){var i="/texts/"+e;var a=this._settingsModel.getProperty(i)||{};return a[t]};J.prototype.deleteAllTranslationValuesInTexts=function(e){var t=this;var i=t._settingsModel.getData();if(!i||!i.texts){return}var n="/texts";var s=a(i.texts,500);for(var r in s){if(s[r][e]){delete s[r][e]}}this._settingsModel.setProperty(n,s)};J.prototype._addItem=function(e,t){var i=this.getMode();if(this.getAllowDynamicValues()===false||!e.allowDynamicValues){e.allowDynamicValues=false}if(this.getAllowSettings()===false){e.allowSettings=false}e.__cols=e.cols||2;if(e.visible===false||!e.translatable&&i==="translation"&&e.type!=="group"){return}if(e.type==="group"){e.expanded=e.expanded!==false;var n=this._createField(e,t);this.addAggregation("_formContent",n);if(e.hint){this._addHint(e.hint,this.getId()+"_"+t)}return}if(e.type==="separator"){var s=new R;this.addAggregation("_formContent",s);return}var r=null;var o=g._language;if(i==="translation"){if(e.type!=="string"){return}if(typeof e.value==="string"&&e.value.indexOf("{")===0||typeof e.values!=="undefined"){return}e._language={value:e.value};e.cols=1;delete e.values;var l=a(e,500);l._settingspath+="/_language";l.editable=false;l.required=false;if(!J._oLanguages[o]&&o.indexOf("-")>-1){o=o.substring(0,o.indexOf("-"))}if(J._oLanguages[o]){var d=this.getTranslationValueInTexts(o,e.manifestpath);if(d){l.value=d}}if(!l.value){l.value="-"}var f=this._createLabel(l,t);this.addAggregation("_formContent",f);var u=this._createField(l,t+"_ori");u.isOrigLangField=true;this.addAggregation("_formContent",u);e.editable=e.visible=e.translatable;o=this._language;if(!this.getBeforeLayerChange(e.manifestpath)){e.value=e._translatedValue||""}var d=this.getTranslationValueInTexts(o,e.manifestpath);if(d){e.value=d}e.label=e._translatedLabel||"";e.required=false;var p=this._createField(e,t+"_trans");var h={onAfterRendering:function(e){var t=document.getElementById(p.getId());t.setAttribute("aria-label",f)}};p.addEventDelegate(h);this.addAggregation("_formContent",p)}else{r=this._createLabel(e,t);this.addAggregation("_formContent",r);var c=this.getBeforeLayerChange(e.manifestpath);if(c){e._beforeLayerChange=c}if(this._currentLayerManifestChanges&&this._currentLayerManifestChanges[e.manifestpath]){e.value=this._currentLayerManifestChanges[e.manifestpath];e._beforeLayerChange=e.value}if(e.type==="string"){o=this._language;var d=this.getTranslationValueInTexts(o,e.manifestpath);if(d){e.value=d}}var n=this._createField(e,t);var _={onAfterRendering:function(e){var t=document.getElementById(n.getId());t.setAttribute("aria-label",r)}};n.addEventDelegate(_);this.addAggregation("_formContent",n)}if(e.hint&&(!e.cols||e.cols===2)){this._addHint(e.hint,this.getId()+"_"+t)}e.cols=e.__cols;delete e.__cols};J.prototype._createHint=function(e,t){e=e.replace(/<a href/g,"<a target='blank' href");var i=new A(t+"_hint",{htmlText:e});return i};J.prototype._addHint=function(e,t){var i=this._createHint(e,t);this.addAggregation("_formContent",i)};J.prototype._getCurrentLanguageSpecificText=function(e){if(this._oTranslationBundle){var t=this._oTranslationBundle.getText(e,[],true);if(t===undefined){return""}return t}return""};J.prototype._loadSpecialTranslations=async function(){if(this._oTranslationBundle){return}var e=this._language;if(!e){return}var t=this._oEditorManifest.get("/sap.app/i18n"),i,a;if(!t){return}if(typeof t==="string"){i=this.getBaseUrl()+t}else if(typeof t==="object"){if(t.bundleUrl){i=this.getBaseUrl()+t.bundleUrl}if(t.supportedLocales&&Array.isArray(t.supportedLocales)){a=t.supportedLocales;for(var n=0;n<a.length;n++){a[n]=a[n].replaceAll("_","-")}}}if(i){var s=[e];if(e.indexOf("-")>-1){s.push(e.substring(0,e.indexOf("-")))}if(!s.includes("en")){s.push("en")}s=this._filterSupportedFallbackLanguages(s,a);var r=await P.create({url:i,async:true,locale:s[0],supportedLocales:s,fallbackLocale:"en"});var o=new L({bundle:r});this._oTranslationBundle=await o.getResourceBundle()}};J.prototype._filterSupportedFallbackLanguages=function(e,t){if(Array.isArray(t)){var i=[];for(var a=0;a<e.length;a++){if(t.includes(e[a])){i.push(e[a])}}e=i}return e};J.prototype._startEditor=function(){var e=this.getAggregation("_formContent");if(e&&e.length>0){this.destroyAggregation("_formContent")}var t=this._settingsModel.getData();var i;if(t.form&&t.form.items){i=t.form.items;var a=false,n=this._destinationGroupAtTop?1:0,r=Object.keys(i),o=r.length,l=0;for(var d=n;d<o;d++){var f=i[r[d]];if(f.type==="destination"){if(!this._destinationGroupAtTop){break}l=d;continue}else if(f.type==="group"&&f.level!=="1"){break}else if(f.visible){a=true;break}}if(a){var u={type:"group",translatable:true,expanded:true,label:this._oResourceBundle.getText("EDITOR_PARAMETERS_GENERALSETTINGS"),_settingspath:"/form/items/generalPanel"};if(this._destinationGroupAtTop){var p={};var h=0;r.forEach(function(e){p[e]=i[e];if(h===l){p["generalPanel"]=u}h++});i=p}else{i=s({generalPanel:u},i)}t.form.items=i;this._settingsModel.setData(t)}}var c=this._settingsModel.getProperty("/");this._mItemsByPaths={};if(c.form&&c.form.items){i=c.form.items;var _=this._language||this.getLanguage()||g._language;if(this.getMode()==="translation"){this._addItem({type:"group",translatable:true,expandable:false,expanded:true,label:this._oResourceBundle.getText("EDITOR_ORIGINALLANG")+": "+J._oLanguages[_]},"translationTopPanel")}for(var m in i){var f=i[m];if(f){f.label=f.label||m;var v;if(f.manifestpath){this._mItemsByPaths[f.manifestpath]=f;if(this.getMode()!=="translation"){v=this._currentLayerManifestChanges[f.manifestpath]}}f._changed=v!==undefined&&this.getMode()!=="translation";if(f.values){f.translatable=false}f._beforeValue=this._getManifestBeforelValue(f.manifestpath);if(f.type==="string"){f._translatedDefaultPlaceholder=this._getManifestDefaultValue(f.manifestpath);var y=null,b=f._translatedDefaultPlaceholder;if(b){if(this._isValueWithParameterSyntax(b)){f.translatable=false}if(this._isValueWithHandlebarsTranslation(b)){y=b.substring(2,b.length-2)}else if(b.startsWith("{i18n>")){y=b.substring(6,b.length-1)}if(y){f.translatable=true}else if(f.translatable&&this.getMode()==="translation"&&!this.getBeforeLayerChange(f.manifestpath)){f._translatedValue=f._translatedDefaultPlaceholder;f.value=f._translatedValue}}f._translatedPlaceholder=f._beforeValue;b=f._translatedPlaceholder;if(b){if(this._isValueWithParameterSyntax(b)){f.translatable=false}if(this._isValueWithHandlebarsTranslation(b)){y=b.substring(2,b.length-2)}else if(b.startsWith("{i18n>")){y=b.substring(6,b.length-1)}}if(f.value&&(f.value.indexOf("{context>")===0||f.value.indexOf("{{parameters")===0)){this.deleteAllTranslationValuesInTexts(f.manifestpath);y=null}var I=this.getTranslationValueInTexts(_,f.manifestpath);if(y){f._translatedValue=this.getModel("i18n").getResourceBundle().getText(y);if(f._changed){f.value=v}else if(f.value===f._translatedDefaultPlaceholder){f.value=f._translatedValue}if(this.getMode()==="translation"){var M=this._getCurrentLanguageSpecificText(y);if(M!==""){f._translatedValue=M}}else if(I){f.value=I}}else if(this.getMode()!=="translation"&&f.translatable&&I){f.value=I}if(this.getMode()==="translation"){if(this._isValueWithHandlebarsTranslation(f.label)){f._translatedLabel=this._getCurrentLanguageSpecificText(f.label.substring(2,f.label.length-2),true)}else if(f.label&&f.label.startsWith("{i18n>")){f._translatedLabel=this._getCurrentLanguageSpecificText(f.label.substring(6,f.label.length-1),true)}}}else if(f.type==="string[]"){var C=f.manifestpath.substring(0,f.manifestpath.lastIndexOf("/"))+"/valueItems";var P=this._manifestModel.getProperty(C);if(P){f.valueItems=P}var x=f.manifestpath.substring(0,f.manifestpath.lastIndexOf("/"))+"/valueTokens";var T=this._manifestModel.getProperty(x);if(T){f.valueTokens=T}}else if(typeof f.value==="object"&&f.type==="object"){if(typeof f.value._editable==="boolean"){f.value._dt={_editable:f.value._editable};delete f.value._editable}}else if(Array.isArray(f.value)&&f.value.length>0&&f.type==="object[]"){f.value.forEach(function(e){if(typeof e._editable==="boolean"){e._dt={_editable:e._editable};delete e._editable}})}if(f.label&&this._isValueWithHandlebarsTranslation(f.label)){var D=f.label.substring(2,f.label.length-2);if(D){f.label=this.getModel("i18n").getResourceBundle().getText(D)}}}}}for(var m in i){var f=i[m];this._addItem(f,m)}var E=this._settingsModel.getProperty("/form/height")!==undefined?this._settingsModel.getProperty("/form/height"):"350px",S=this._settingsModel.getProperty("/form/width")!==undefined?this._settingsModel.getProperty("/form/width"):"100%";if(this.getProperty("height")===""){this.setProperty("height",E);document.body.style.setProperty("--sapUiIntegrationEditorFormHeight",E);document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight",E)}if(this.getProperty("width")===""){this.setProperty("width",S);document.body.style.setProperty("--sapUiIntegrationEditorFormWidth",S)}if(this.getMode()!=="translation"&&this.getPreviewPosition()!=="separate"){this._initPreview()}Promise.all(this._aFieldReadyPromise).then(function(){this._fieldReady=true;this.fireFieldReady();if(this.getMode()!=="admin"&&this.getMode()!=="all"){setTimeout(function(){this.fireDestinationReady()}.bind(this),100)}}.bind(this))};J.prototype.setHeight=function(e){if(e){this.setProperty("height",e);document.body.style.setProperty("--sapUiIntegrationEditorFormHeight",e);document.body.style.setProperty("--sapUiIntegrationEditorPreviewHeight",e)}};J.prototype.setWidth=function(e){if(e){this.setProperty("width",e);document.body.style.setProperty("--sapUiIntegrationEditorFormWidth",e)}};J.prototype.destroy=function(){if(this._oPopover){this._oPopover.destroy()}if(this._oDesigntimeInstance){this._oDesigntimeInstance.destroy()}var e=this.getAggregation("_preview");if(e&&e.destroy){e.destroy()}var i=o.getElementById(G);if(i){i.destroy()}this._manifestModel=null;this._beforeManifestModel=null;this._oInitialManifestModel=null;this._settingsModel=null;this._destinationsModel=null;this._oEditorResourceBundles=null;document.body.style.removeProperty("--sapUiIntegrationEditorFormWidth");document.body.style.removeProperty("--sapUiIntegrationEditorFormHeight");t.prototype.destroy.apply(this,arguments)};J.prototype._initPreview=function(){};J.prototype._applyDesigntimeDefaults=function(e){e=e||{};e.form=e.form||{};e.form.items=e.form.items||{};var t=e.form.items||e.form.items;for(var i in t){var a=t[i];if(a.type==="destination"){continue}if(a.manifestpath){a.value=this._manifestModel.getProperty(a.manifestpath)}if(a.visible===undefined||a.visible===null){a.visible=true}if(a.editable===undefined||a.editable===null){a.editable=true}if(this.getMode()!=="admin"){if(a.visibleToUser!==undefined){a.visible=a.visibleToUser}if(a.editableToUser!==undefined){a.editable=a.editableToUser}}if(typeof a.translatable!=="boolean"){a.translatable=false}if(!a.label){a.label=i}if(!a.type||a.type==="enum"){a.type="string"}if(a.value===undefined||a.value===null){switch(a.type){case"boolean":a.value=false;break;case"integer":case"number":a.value=0;break;case"string[]":a.value=[];break;case"object":a.value=undefined;break;case"object[]":a.value=undefined;break;default:a.value=""}}if(a.type==="group"){if(a.visible===undefined||a.value===null){a.visible=true}}a._settingspath="/form/items/"+i}};J.prototype._applyDesigntimeLayers=function(e){var t={};var i={};if(this._appliedLayerManifestChanges&&Array.isArray(this._appliedLayerManifestChanges)){for(var a=0;a<this._appliedLayerManifestChanges.length;a++){var r=this._appliedLayerManifestChanges[a][":designtime"];if(r){var o=Object.keys(r);for(var l=0;l<o.length;l++){var d=o[l],f=r[d];if(!d.endsWith("/pageAdminValues")&&typeof f==="object"){if(f.configuration&&f.configuration.parameterFromDestination){var u=f.configuration;delete u.parameterFromDestination;u.value=this._manifestModel.getProperty(u.manifestpath);u._settingspath="/form/items/"+f.parameter;this._settingsModel.setProperty(u._settingspath,u)}else{i[o[l]]=s(i[o[l]],f);continue}}else{this._settingsModel.setProperty(o[l],f)}}}var g=this._appliedLayerManifestChanges[a]["texts"];if(g){t=s(t,g)}}}if(this._currentLayerManifestChanges){var r=this._currentLayerManifestChanges[":designtime"];if(r){var o=Object.keys(r);for(var l=0;l<o.length;l++){var d=o[l],f=r[d];p=d.substring(0,d.lastIndexOf("/")+1)+"_next";if(!d.endsWith("/pageAdminValues")&&typeof f==="object"){if(!f.configuration||!f.configuration.parameterFromDestination){i[d]=s(i[d],f);continue}}if(!this._settingsModel.getProperty(p)){this._settingsModel.setProperty(p,{})}var p=d.substring(0,d.lastIndexOf("/")+1)+"_next",h=d.substring(d.lastIndexOf("/")+1);this._settingsModel.setProperty(p+"/"+h,f)}}var c=this._currentLayerManifestChanges["texts"];if(c){t=s(t,c)}}if(!n(t,{})){this._settingsModel.setProperty("/texts",t)}if(!n(i,{})){this._settingsModel.setProperty("/:designtime",i)}};J.prototype._createParameterDesigntime=function(e){var t={},i=this.getConfigurationPath()+"/parameters",a=this.getMode();if(e&&e.parameters){t.form=t.form||{};t.form.items=t.form.items||{};var n=t.form.items;Object.keys(e.parameters).forEach(function(t){n[t]=s({manifestpath:i+"/"+t+"/value",editable:a!=="translation",_settingspath:"/form/items/"+t},e.parameters[t]);var r=n[t];if(!r.type){r.type="string"}if(!r.hasOwnProperty("visible")){r.visible=true}})}return new d(t)};J.prototype._addDestinationSettings=function(e){var t=this._oDesigntimeInstance.getSettings(),i=this.getConfigurationPath()+"/destinations";t.form=t.form||{};t.form.items=t.form.items||{};if(t&&e&&e.destinations){this._destinationGroupAtTop=false;var a=t.form.items,n={},r=this.getHostInstance();var o={label:this._oResourceBundle.getText("EDITOR_DESTINATIONS")||"Destinations",type:"group",expanded:true,visible:true,_settingspath:"/form/items/destination.group"};if(a["destination.group"]){this._destinationGroupAtTop=Object.keys(a)[0]==="destination.group";o=s(o,a["destination.group"]);delete a["destination.group"]}n["destination.group"]=o;Object.keys(e.destinations).forEach(function(t){var r=s({manifestpath:i+"/"+t+"/name",visible:true,type:"destination",editable:true,allowDynamicValues:false,allowSettings:false,value:e.destinations[t].name,defaultValue:e.destinations[t].defaultUrl,_settingspath:"/form/items/"+[t+".destination"],_values:[],_destinationName:t},e.destinations[t]);if(typeof r.label==="undefined"){r.label=t}if(a[t+".destination"]){r=s(r,a[t+".destination"]);delete a[t+".destination"]}n[t+".destination"]=r});if(this._destinationGroupAtTop){t.form.items=s(n,a)}else{t.form.items=s(a,n)}var l=false;if(r){this._destinationsModel.setProperty("/_loading",true);this._destinationsModel.checkUpdate(true);this.getHostInstance().getDestinations().then(function(e){l=true;this._destinationsModel.setProperty("/_values",e);this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.setSizeLimit(e.length);this._destinationsModel.checkUpdate(true);setTimeout(function(){this.fireDestinationReady()}.bind(this),100)}.bind(this)).catch(function(){return this.getHostInstance().getDestinations()}.bind(this)).then(function(e){if(l){return}this._destinationsModel.setProperty("/_values",e);this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.setSizeLimit(e.length);this._destinationsModel.checkUpdate(true);setTimeout(function(){this.fireDestinationReady()}.bind(this),100)}.bind(this)).catch(function(e){this._destinationsModel.setProperty("/_loading",false);this._destinationsModel.checkUpdate(true);setTimeout(function(){this.fireDestinationReady()}.bind(this),100);M.error("sap.ui.integration.editor.Editor: can not get destinations list from '"+r.getId()+"'.")}.bind(this))}}};J.prototype._deleleDestinationSettings=function(){var e=this._oDesigntimeInstance.getSettings();e.form=e.form||{};e.form.items=e.form.items||{};delete e.form.items["destination.group"];for(var t in e.form.items){var i=e.form.items[t];if(i.type==="destination"){delete e.form.items[t]}}};J.prototype._getManifestDefaultValue=function(e){return this._oInitialManifestModel.getProperty(e)};J.prototype._getManifestBeforelValue=function(e){return this._beforeManifestModel.getProperty(e)};J.prototype._isValueWithHandlebarsTranslation=function(e){if(typeof e==="string"){return!!e.match(W)}return false};J.prototype._isValueWithParameterSyntax=function(e){if(typeof e==="string"){return!!e.match(H)}return false};J.prototype.prepareFieldsInKey=function(e){this._sKeySeparator=e.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#"}var t=e.values.item.key;this._aFields=t.split(this._sKeySeparator);for(var i in this._aFields){if(this._aFields[i].startsWith("{")){this._aFields[i]=this._aFields[i].substring(1)}if(this._aFields[i].endsWith("}")){this._aFields[i]=this._aFields[i].substring(0,this._aFields[i].length-1)}}};J.prototype.getKeyFromItem=function(e){var t="";this._aFields.forEach(function(i){t+=e[i].toString()+this._sKeySeparator}.bind(this));if(t.endsWith(this._sKeySeparator)){t=t.substring(0,t.length-this._sKeySeparator.length)}return t};J.oResourceBundle=l.getResourceBundleFor("sap.ui.integration",g._language);J.initContextEntries=function(){return{empty:{label:J.oResourceBundle.getText("EDITOR_CONTEXT_EMPTY_VAL"),type:"string",description:J.oResourceBundle.getText("EDITOR_CONTEXT_EMPTY_DESC"),placeholder:"",value:""},"editor.internal":{label:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_INTERNAL_VAL"),todayIso:{type:"string",label:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),description:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_TODAY_DESC"),tags:[],placeholder:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_TODAY_VAL"),customize:["format.dataTime"],value:"{{parameters.TODAY_ISO}}"},nowIso:{type:"string",label:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),description:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_NOW_DESC"),tags:[],placeholder:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_NOW_VAL"),customize:["dateFormatters"],value:"{{parameters.NOW_ISO}}"},currentLanguage:{type:"string",label:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),description:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),tags:["technical"],customize:["languageFormatters"],placeholder:J.oResourceBundle.getText("EDITOR_CONTEXT_EDITOR_LANG_VAL"),value:"{{parameters.LOCALE}}"}}}};z=J.initContextEntries();J.prototype._applyLanguageChange=function(){z=J.initContextEntries()};J._oLanguages={};J._appendThemeVars=function(){var e=["sapUiButtonHoverBackground","sapUiBaseBG","sapUiContentLabelColor","sapUiTileSeparatorColor","sapUiHighlight","sapUiListSelectionBackgroundColor","sapUiNegativeText","sapUiCriticalText","sapUiPositiveText","sapUiChartScrollbarBorderColor"];var t=E.get({name:e,callback:function(e){}});if(t){for(var i in t){document.body.style.setProperty("--"+i,t[i])}}};J.init=function(){this.init=function(){};J._appendThemeVars();var e=sap.ui.require.toUrl("sap.ui.integration.editor.css.Editor".replace(/\./g,"/")+".css");T(e);J._oLanguages=D.loadResource("sap/ui/integration/editor/languages.json",{dataType:"json",failOnError:false,async:false})};J.prototype.onThemeChanged=function(){J._appendThemeVars()};J.init();return J});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/EditorResourceBundles", ["sap/ui/base/ManagedObject","sap/base/i18n/ResourceBundle","sap/base/Log"],function(e,r,a){"use strict";var s=e.extend("sap.ui.integration.editor.EditorResourceBundles",{metadata:{library:"sap.ui.integration",properties:{url:{type:"string",defaultValue:""},languages:{type:"object"},supportedLocales:{type:"array"}}}});s.prototype.loadResourceBundles=function(){var e=this;var s=e.getUrl();var u=e.getSupportedLocales();var o=e.getLanguages();e._ready=false;e._aResourceBundles=[];e._aResourceBundleReadyPromise=[];Object.keys(o).forEach(function(a){if(s){var n=[a];if(a.indexOf("-")>-1){n.push(a.substring(0,a.indexOf("-")))}if(!n.includes("en")){n.push("en")}e._aResourceBundles[a]="";var t=r.create({url:s,async:true,locale:a,supportedLocales:n}).then(function(r){var s={language:o[a],resourceBundle:r,isSupportedLocale:true};if(Array.isArray(u)&&!u.includes(a)&&!u.includes(a.replace("-","_"))){s.isSupportedLocale=false}e._aResourceBundles[a]=s});e._aResourceBundleReadyPromise.push(t)}else{var i={language:o[a],isSupportedLocale:true};if(Array.isArray(u)&&!u.includes(a)&&!u.includes(a.replace("-","_"))){i.isSupportedLocale=false}e._aResourceBundles[a]=i}});if(e._aResourceBundleReadyPromise.length>0){Promise.all(e._aResourceBundleReadyPromise).then(function(){Object.keys(o).forEach(function(r){if(e._aResourceBundles[r]==""){var a={language:o[r],isSupportedLocale:true};if(Array.isArray(u)&&!u.includes(r)&&!u.includes(r.replace("-","_"))){a.isSupportedLocale=false}e._aResourceBundles[r]=a}});a.info("sap.ui.integration.editor.EditorResourceBundles: resource bundles loaded.");e._ready=true})}else{a.info("sap.ui.integration.editor.EditorResourceBundles: no resource bundles.");e._ready=true}};s.prototype.isReady=function(){return this._ready};s.prototype.getResourceBundles=function(){return this._aResourceBundles};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Extension", ["sap/ui/integration/Extension","sap/base/Log"],function(t,i){"use strict";var o=t.extend("sap.ui.integration.editor.Extension");o.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oEditorInterface=null;this._oEditor=null};o.prototype.exit=function(){t.prototype.exit.apply(this,arguments);this._oEditorInterface=null;this._oEditor=null};o.prototype.setFormatters=function(o){t.prototype.setFormatters.apply(this,arguments);if(!this._oEditor){return}if(this._oEditor.getAggregation("_extension")!==this){i.error("sap.ui.integration.editor.Extension: extension formatters must be set before the initialization of the editor. Do this inside Extension#init().")}};o.prototype.onEditorReady=function(){};o.prototype.getEditor=function(){return this._oEditorInterface};o.prototype._setEditor=function(t,i){this._oEditor=t;this._oEditorInterface=i};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Manifest", ["sap/ui/integration/util/Manifest","./Merger"],function(e,t){"use strict";var i=e.extend("sap.ui.integration.editor.Manifest");i.prototype.mergeDeltaChanges=function(e){return t.mergeDelta(e,this._aChanges,this._sSection)};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Merger", ["sap/base/util/merge","sap/ui/model/json/JSONModel"],function(e,t){"use strict";var a={layers:{admin:0,content:5,translation:10,all:20},mergeManifestPathChanges:function(e,t){Object.keys(t).forEach(function(a){if(a.charAt(0)==="/"){var r=t[a];e.setProperty(a,r)}})},mergeDelta:function(r,n,i){var o=e({},r);if(typeof i==="undefined"){i="sap.card"}if(Array.isArray(n)&&n.length>0){var s;n.forEach(function(r){if(r.content){e(o[i],r.content)}else{s=s||new t(o);a.mergeManifestPathChanges(s,r)}})}return o},mergeDesigntimeMetadata:function(t,a){var r=e({},t);a.forEach(function(e){var t=e.content.entityPropertyChange||[];t.forEach(function(e){var t=e.propertyPath;switch(e.operation){case"UPDATE":if(r.hasOwnProperty(t)){r[t]=e.propertyValue}break;case"DELETE":delete r[t];break;case"INSERT":if(!r.hasOwnProperty(t)){r[t]=e.propertyValue}break;default:break}})});return r}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/Settings", ["sap/ui/core/Control","sap/m/Popover","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/model/json/JSONModel","sap/m/Button","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/VBox","sap/m/HBox","sap/m/Select","sap/ui/core/ListItem","sap/m/Label","sap/m/Text","sap/m/Title","sap/m/CheckBox","sap/m/Menu","sap/m/MenuItem","sap/m/Input","sap/ui/integration/util/ParameterMap","sap/base/util/merge","sap/m/Table","sap/m/Column","sap/m/ColumnListItem","sap/m/ScrollContainer","sap/base/util/ObjectPath","sap/ui/integration/util/BindingHelper","sap/ui/integration/editor/fields/ObjectListField","sap/ui/layout/form/SimpleForm","sap/ui/integration/util/Utils","sap/base/util/deepClone","sap/base/util/deepEqual"],function(e,t,a,n,s,i,l,r,o,d,u,p,_,g,c,m,f,v,y,b,S,h,T,w,I,x,P,E,D,V,M,C,O,A){"use strict";var R=e.extend("sap.ui.integration.editor.Settings",{metadata:{library:"sap.ui.integration"},renderer:null});var N=n.getResourceBundleFor("sap.ui.integration",C._language),L,B,j=null,U,F,$,K,k,H,G,W,Y,z,Z,q,X,J=450,Q=360;R.prototype.setConfiguration=function(e){this._originalConfig=e;e=T({},e);var t=new s(e);this.setModel(t,"currentSettings");this.bindElement({path:"currentSettings>/"})};R.prototype.open=function(e,t,s,i,l,r,o){if(N&&N.sLocale!==C._language){N=n.getResourceBundleFor("sap.ui.integration",C._language)}var d=this.getModel("currentSettings").getData(),u=l.getParameterId();if(d.values&&d.values.item){this.prepareFieldsInKey(d)}j=this;X=ee(d,l);this.addDependent(X);this.oHost=i;this.fnApply=r;this.fnCancel=o;this._oOpener=l;B=true;e.addDependent(this);if(!d.allowDynamicValues&&d.values&&d.values.item){a.getElementById(u+"_settings_popover_scroll_container").setHeight("155px")}this.getModel("currentSettings").checkUpdate(true,true);ye(N.getText("EDITOR_SELECT_FROM_LIST"),[]);if(t){var p=s.getDomRef().offsetHeight;p=p>J?J:p;X.setContentHeight(p-50+"px");var _;var g="Right";var c=s.getDomRef().getBoundingClientRect();var m=e.getDomRef().getBoundingClientRect();var f=m.x+m.width/2-c.x;var v=c.width;if(2*f>v){g="Left";_=f-m.width*1.5}else{_=v-f-m.width}_=_>Q?Q:_;X.setContentWidth(_+"px");X.setPlacement(g);k.setValue(e._label);X.openBy(e)}else{X.open()}L=this.getModel("currentSettings");if(L.getProperty("/type")==="destination"){le(u)}else if(L.getProperty("/_hasDynamicValue")){re(u)}else if(L.getProperty("/_hasSettings")){ie(u)}else if(L.getProperty("/allowDynamicValues")){re(u)}else if(L.getProperty("/allowSettings")){ie(u)}};R.prototype._applyCurrentSettings=function(){this.fnApply(L.getData())};R.prototype._cancelCurrentSettings=function(){this.fnCancel(this._originalConfig)};R.prototype.destroy=function(){this.removeDependent(X);return e.prototype.destroy.apply(this,arguments)};function ee(e,n){var s=n.getParameterId(),l=ne(e,s),r=se(e,s,n),u=pe(s),p=_e(s),_=ge(e,n),g=ce(e,n),c=new t({id:s+"_settings_popover",showArrow:true,contentWidth:"400px",showHeader:false,horizontalScrolling:false,verticalScrolling:false,modal:false,footer:new o({content:[r,new d,new i(s+"_settings_popover_ok_btn",{text:N.getText("EDITOR_MORE_OK"),type:"Emphasized",press:function(){if(e.type==="destination"){if(n._oNewParameter){var t=Object.assign({},n._oNewParameter);var i=O(Object.assign([],n._oValue.value));i=i.sort(function(e,t){if(!e._dt||!e._dt._position||!t._dt||!t._dt._position){return 0}return e._dt._position-t._dt._position});i.forEach(function(e){delete e._dt});t.configuration.values.data.json={values:i};oe("pageAdminNewDestinationParameter",t)}}else{if(e.values&&e.values.item){var l=a.getElementById(s+"_settings_popover_pav_table"),r=l.getSelectedContexts(),o=[];if(L.getProperty("/selectedValues")==="Partion"){for(var d=0;d<r.length;d++){var u=j.getKeyFromItem(r[d].getObject());o.push(u)}oe("pageAdminValues",o)}else{oe("pageAdminValues",[])}}}j._applyCurrentSettings();B=false;c.close()}}),new i(s+"_settings_popover_cancel_btn",{text:N.getText("EDITOR_MORE_CANCEL"),press:function(){c.close()}})]}),afterClose:function(){if(B){j._cancelCurrentSettings()}B=true;c.destroy()},afterOpen:function(){window.requestAnimationFrame(function(){c.getDomRef()&&(c.getDomRef().style.opacity="1")});if(e.values&&e.values.item){var t=a.getElementById(s+"_settings_popover_pav_table"),i=L.getProperty("/_next/pageAdminValues");if(i!==undefined&&i.length>0){t.removeSelections();L.setProperty("/selectedValues","None");var l=L.getProperty("/_next/pageAdminValues"),r=t.getItems();for(var o=0;o<l.length;o++){for(var d=0;d<r.length;d++){var u=j.getKeyFromItem(r[d].getBindingContext().getObject());if(l[o]===u){t.setSelectedItem(r[d])}}}L.setProperty("/selectedValues","Partion")}else{t.selectAll();L.setProperty("/selectedValues","All")}}n.fireSettingsPanelOpened()}});c.setCustomHeader(l);c.addContent(u);c.addContent(p);c.addContent(_);c.addContent(g);c.addStyleClass("sapUiIntegrationFieldSettings");return c}function te(e){z=new r({text:N.getText("EDITOR_MORE_SETTINGS"),tooltip:N.getText("EDITOR_MORE_SETTINGS"),key:"settings",icon:"sap-icon://action-settings",width:"50%",press:function(t){ie(e)}}).addStyleClass("setbtn");return z}function ae(e){z=te(e);Z=new l(e+"_settings_popover_segmented_btn",{width:"100%",visible:"{= ${currentSettings>allowDynamicValues} && ${currentSettings>allowSettings}}",items:[new r({text:N.getText("EDITOR_MORE_DYNAMICVALUES"),tooltip:N.getText("EDITOR_MORE_DYNAMICVALUES"),key:"dynamic",icon:"{= ${currentSettings>_hasDynamicValue} ? 'sap-icon://display-more' : 'sap-icon://enter-more'}",width:"50%",press:function(t){re(e)}}).addStyleClass("dynbtn sel"),z]});return Z}function ne(e,t){Z=ae(t);var a=new m(t+"_settings_popover_dynamicvalue_txt",{text:N.getText("EDITOR_MORE_DYNAMICVALUES"),tooltip:N.getText("EDITOR_MORE_DYNAMICVALUES"),visible:e.type!=="destination"&&e.allowDynamicValues&&!e.allowSettings}).addStyleClass("sapUiTinyMagin");var n=new m(t+"_settings_popover_settings_txt",{text:N.getText("EDITOR_MORE_SETTINGS"),visible:e.type!=="destination"&&!e.allowDynamicValues&&e.allowSettings}).addStyleClass("sapUiTinyMagin");var s=new m(t+"_settings_popover_transform_txt",{text:N.getText("EDITOR_MORE_TRANSFORM"),visible:e.type==="destination"}).addStyleClass("sapUiTinyMagin");var i=new o({content:[Z,a,n,s]}).addStyleClass("headertitle");return i}function se(e,t,n){q=new i(t+"_settings_popover_reset_btn",{type:"Transparent",text:N.getText("EDITOR_MORE_RESET"),enabled:"{= ${currentSettings>_next/visible} === (typeof(${currentSettings>visibleToUser}) === 'undefined' ? false : !${currentSettings>visibleToUser}) || ${currentSettings>_next/editable} === (typeof(${currentSettings>editableToUser}) === 'undefined' ? false : !${currentSettings>editableToUser}) || ${currentSettings>_next/allowDynamicValues} === (typeof(${currentSettings>allowDynamicValues}) === 'undefined' ? false : !${currentSettings>allowDynamicValues}) || ${currentSettings>_beforeValue} !== ${currentSettings>value} || ${currentSettings>type} === 'destination'}",tooltip:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_RESET"),press:function(){if(e.type==="destination"){oe("pageAdminNewDestinationParameter",undefined);n._oValue=undefined;n._oNewParameter=undefined}else{var s=typeof L.getProperty("/visibleToUser")==="undefined"?true:L.getProperty("/visibleToUser");var i=typeof L.getProperty("/editableToUser")==="undefined"?true:L.getProperty("/editableToUser");var l=typeof L.getProperty("/allowDynamicValues")==="undefined"?true:L.getProperty("/allowDynamicValues");oe("visible",s);oe("editable",i);oe("allowDynamicValues",l);if(L.getProperty("/translatable")){if(L.getProperty("/_translatedDefaultValue")&&L.getProperty("/_translatedDefaultValue")!==""){L.setProperty("/value",L.getProperty("/_translatedDefaultValue"))}else if(L.getProperty("/_translatedDefaultPlaceholder")&&L.getProperty("/_translatedDefaultPlaceholder")!==""){L.setProperty("/value",L.getProperty("/_translatedDefaultPlaceholder"))}L.setProperty("/_changed",false)}else{L.setProperty("/value",L.getProperty("/_beforeValue"));if(e.type.indexOf("object")>-1){n.setValue(L.getProperty("/_beforeValue"));n.resetControl()}}if(e.values&&e.values.item){var r=a.getElementById(t+"_settings_popover_pav_table"),o=L.getProperty("/_next/pageAdminValues"),d=r.getItems();if(o!==undefined&&o.length>0&&o.length<d.length){r.removeSelections();for(var u=0;u<o.length;u++){for(var p=0;p<d.length;p++){var _=j.getKeyFromItem(d[p].getBindingContext().getObject());if(o[u]===_){r.setSelectedItem(d[p])}}}L.setProperty("/selectedValues","Partion")}else{r.selectAll();L.setProperty("/selectedValues","All")}}}var g=a.getElementById(t+"_settings_popover");g.getFooter().getContent()[2].firePress()}}).addStyleClass("resetbutton");return q}function ie(e){F.setVisible(true);U.setVisible(false);$.setVisible(false);a.getElementById(e+"_settings_popover_segmented_btn").setSelectedKey("settings");var t=a.getElementById(e+"_settings_popover_currentvalue");t.setVisible(false)}function le(e){$.setVisible(true);F.setVisible(false);U.setVisible(false);var t=a.getElementById(e+"_settings_popover_currentvalue");t.setVisible(false)}function re(e){F.setVisible(false);$.setVisible(false);U.setVisible(true);a.getElementById(e+"_settings_popover_segmented_btn").setSelectedKey("dynamic");var t=j.getModel("contextflat"),n=t._getValueObject(L.getProperty("/value"));if(n&&n.object.label){k.setValue(n.object.label);ye(n.object.description,n.object.tags);if(n.path==="empty"){k.setValue(n.object.label)}Se(n)}var s=a.getElementById(e+"_settings_popover_currentvalue");s.setVisible(true)}function oe(e,t){if(!L.getProperty("/_next")){L.setProperty("/_next",{})}L.setProperty("/_next/"+e,t)}function de(e,t){var a=[];for(var n in e){if(e[n]&&e[n].label){var s=new b({text:e[n].label});s.__data=e[n];e[n].pathvalue=(t+"/"+n).substring(1);a.push(s);var i=de(e[n],t+"/"+n);for(var l=0;l<i.length;l++){s.addItem(i[l])}}}return a}var ue=[{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Relative date/datetime text of the value",description:"Should be applied to dynamic values of type date or datetime or string values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss'",example:"4 weeks ago",syntax:"handlebars",binding:"{= format.dateTime('__|VALUE|__',{relative:true})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Short date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddZhh:mm:ss.sss'",example:"9/18/20, 2:09 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'short'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Medium date/datetime text of the value",description:"Should be applied to dynamic values of type date, date-time or text values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'medium'})}"},{formatMethod:"format.DateTime",sourceTypes:["datetime","date"],label:"Long date, date-time text of the value",description:"Should be applied to dynamic values of type date or date-time or string values that represent a datetime in the format 'yyyy-MM-ddThh:mm:ss.sssZ'",example:"Sep 18, 2020, 2:09:04 PM",binding:"{= format.dateTime('__|VALUE|__',{style:'long'})}"}];function pe(e){U=new u({visible:true});U.addStyleClass("sapUiSmallMargin");k=new S(e+"_settings_popover_dynamicvalue_input",{width:"100%",showValueHelp:true,valueHelpOnly:true,valueHelpRequest:function(){if(H){H.destroy()}H=new y({});G=de(U.getModel("context").getData(),"");for(var e=0;e<G.length;e++){H.addItem(G[e])}H.attachItemSelected(function(e){var t=e.getParameter("item").__data;ye(t.description||"",t.tags||[]);k.setValue(t.placeholder||t.label);var a=j.getModel("contextflat");Se(a._getPathObject(t.pathvalue))});k.addDependent(H);H.addStyleClass("sapUiIntegrationFieldSettingsMenu");H.openBy(k,false,null,null,"1 0")}});k.addStyleClass("selectvariable");var t=new c(e+"_settings_popover_dynamicvalue_label",{text:N.getText("EDITOR_MORE_DYNAMICVALUES_SELECT_DYNAMIC_VALUE")});k.addAriaLabelledBy(t);var a=new u({items:[t,k]});U.addItem(a);K=new m(e+"_settings_popover_dynamicvalue_desc_txt",{text:"",maxLines:6,renderWhitespace:true});a=new u({width:"100%",items:[K]});K.addStyleClass("description");U.addItem(a);if(ue.length===-1){W=new _(e+"_settings_popover_dynamicvalue_format_select",{width:"100%",enabled:true,change:function(){Y.setText(W.getSelectedItem()._data.description)}});a=new u({visible:false,items:[new c({text:"Customize the value..."}),W]});U.addItem(a);Y=new m(e+"_settings_popover_dynamicvalue_format_label",{text:"",maxLines:4,renderWhitespace:true});Y.addStyleClass("description");a=new u({width:"100%",items:[Y]});U.addItem(a);U.getItems()[2].getItems()[0].addStyleClass("sapUiTinyMarginTop")}U.getItems()[0].getItems()[0].addStyleClass("sapUiTinyMarginTop");return U}function _e(e){var t=new m(e+"_settings_popover_actualvalue_label",{text:N.getText("EDITOR_ACTUAL_VALUE")});var a=new S(e+"_settings_popover_actualvalue_input",{value:{path:"currentSettings>_currentContextValue"},editable:false});a.addAriaLabelledBy(t);var n=new u(e+"_settings_popover_currentvalue",{width:"100%",items:[t,a]});n.addStyleClass("currentval");return n}function ge(e,t){var a=t.getParameterId();F=new u({visible:false});if(e.type==="destination"){return F}var n=(new u).addStyleClass("commonSettings");F.addItem(n);n.addItem(new m({text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN"),wrapping:true}).addStyleClass("stitle"));var l=new c(a+"_settings_popover_adminvisible_label",{text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VISIBLE"),wrapping:true});var r=new v(a+"_settings_popover_adminvisible_checkbox",{selected:"{= ${currentSettings>_next/visible} !== false}",select:function(e){oe("visible",e.getParameter("selected"))}});r.addAriaLabelledBy(l);n.addItem(new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[l,r]}).addStyleClass("cbrow"));var o=new c(a+"_settings_popover_admineditable_label",{text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_EDIT"),wrapping:true});var d=new v(a+"_settings_popover_admineditable_checkbox",{selected:"{= ${currentSettings>_next/editable} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false}",select:function(e){oe("editable",e.getParameter("selected"))}});d.addAriaLabelledBy(o);n.addItem(new p({alignItems:"Start",justifyContent:"SpaceBetween",items:[o,d]}).addStyleClass("cbrow"));var _=new c(a+"_settings_popover_allowdynamicvalues_label",{text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_DYN"),wrapping:true});var g=new v(a+"_settings_popover_allowdynamicvalues_checkbox",{selected:"{= ${currentSettings>_next/allowDynamicValues} !== false}",enabled:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",select:function(e){oe("allowDynamicValues",e.getParameter("selected"))}});g.addAriaLabelledBy(_);n.addItem(new p({alignItems:"Start",justifyContent:"SpaceBetween",visible:"{= ${currentSettings>allowDynamicValues}!== false}",items:[_,g]}).addStyleClass("cbrow"));if(e.values&&e.values.item){var f;if(e.values.data){var y=e.values.data.path,b;if(y&&y!=="/"){if(y.startsWith("/")){y=y.substring(1)}if(y.endsWith("/")){y=y.substring(0,y.length-1)}b=y.split("/");f=E.get(["_values",b],e)}else{f=E.get(["_values"],e)}}else if(t.getParent().getParent().getAggregation("_extension")){var S=e.values.path;if(S.length>1){S=S.substring(1)}f=E.get([S],t.getModel().getData())}n.addItem(new p({alignItems:"Start",justifyContent:"SpaceBetween",visible:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",items:[new c(a+"_settings_popover_allowselectedvalues_label",{text:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VALUES_LIST"),tooltip:N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_VALUES_LIST_TOOLTIPS"),wrapping:false}),new i(a+"_settings_popover_allowselectedvalues_all_btn",{type:"Transparent",enabled:f!==undefined,icon:{path:"currentSettings>selectedValues",formatter:function(e){if(e==="All"){return"sap-icon://multiselect-all"}else if(e==="Partion"){return"sap-icon://multi-select"}else if(e==="None"){return"sap-icon://multiselect-none"}}},tooltip:{path:"currentSettings>selectedValues",formatter:function(e){if(e==="All"){return N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_DESELECT_ALL")}else{return N.getText("EDITOR_MORE_SETTINGS_P_ADMIN_SELECT_ALL")}}},press:function(){me(a)}})]}).addStyleClass("cbrow"));var h=new w({id:a+"_settings_popover_pav_table",mode:"MultiSelect",select:function(e){fe(e,a)},columns:[new I]}).addStyleClass("tableHdr");var T=e.values.item.text,V=new s(f);h.setModel(V);var M=(new x).addStyleClass("pavlistItem");if(f){for(var C=0;C<f.length;C++){M.addCell(new p({items:[new m({text:D.createBindingInfos(T)}).addStyleClass("pavTblCellText")]})).addStyleClass("pavlistItem")}}h.bindItems("/",M);var O=new P({id:a+"_settings_popover_scroll_container",height:"125px",vertical:true,horizontal:false,visible:"{= ${currentSettings>_next/visible} !== false && ${currentSettings>_next/editable} !== false}",content:[h]}).addStyleClass("SettingsPAVTable");F.addItem(O)}return F}function ce(e,t){$=new u({visible:false});if(e.type!=="destination"){return $}var a=new c({text:N.getText("EDITOR_MORE_TRANSFORM_P_ADMIN_LABEL"),wrapping:true});var n=new S({id:t.getAssociation("_editor")+"_"+t.getParameterKey()+".toParameter_label",value:"{/configuration/label}"});n.addAriaLabelledBy(a);var i=new c({text:N.getText("EDITOR_MORE_TRANSFORM_P_ADMIN_MAPPINGS"),wrapping:true});var l=1,r=O(t.getModel("destinations").getData()._values),o=e._next?e._next.pageAdminNewDestinationParameter:undefined;if(!t._oValue){var d=o?o.configuration.values.data.json.values:[];if(Array.isArray(d)&&d.length>0){d.forEach(function(e){e.label=e.label||e.name;e._dt={_uuid:C.generateUuidV4(),_position:l};l++})}else{var p=t.getAggregation("_field").getSelectedItem();var _=p?p.getBindingContext("destinations").getPath():undefined;if(_){var g=O(p.getModel("destinations").getProperty(_));g.label=g.label||g.name;g._dt={_uuid:C.generateUuidV4(),_position:l};d=[g]}}t._oValue={value:d}}else{t._oValue.value.forEach(function(e){e._dt=e._dt||{};var t=O(e);delete t._dt;if(typeof t==="object"&&!A(t,{})){e.label=t.label||t.name}})}var m=new s(t._oValue);t._oDestinationValueObjectConfig={label:"Destination Mappings",type:"object[]",values:{data:{path:"/value"},allowAdd:true},showSelectionColumn:false,properties:{label:{label:"Label",column:{width:"50%"},cell:{text:"{label}",editable:true}},name:{label:"Name",column:{width:"50%"},cell:{type:"string",editable:true,values:{data:{json:r,path:"/"},item:{text:"{settings>name}",key:"{settings>name}"},sorter:"name"},change:function(e){var t=e.getSource();var a=t.getBindingContext().getObject();if(a&&!a.label&&a.name){a.label=a.name}}}}},value:t._oValue.value};var f=new V(t.getAssociation("_editor")+"_"+t.getParameterKey()+".toParameter_field",{configuration:t._oDestinationValueObjectConfig,allowPopover:false,parameterKey:t.getParameterKey()+".toParameter",objectBindings:{currentSettings:{path:"currentSettings>/"}}});f.setAssociation("_editor",t.getAssociation("_editor"));f.setModel(m);f.setModel(new s(t._oDestinationValueObjectConfig),"currentSettings");var v=new M({layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,content:[a,n,i,f]});if(!t._oNewParameter){t._oNewParameter={parameter:t.getParameterKey()+".toParameter",configuration:{label:e.label,manifestpath:e.manifestpath,type:"string",visible:true,editable:true,values:{data:{path:"/values"},item:{text:"{label}",key:"{name}"}},parameterFromDestination:true}};if(o){delete o.configuration.values.data.json;t._oNewParameter=Object.assign(t._oNewParameter,o)}}var y=new s(t._oNewParameter);v.setModel(y);$.addItem(v);return $}function me(e){var t=a.getElementById(e+"_settings_popover_pav_table"),n=a.getElementById(e+"_settings_popover_reset_btn"),s=L.getProperty("/selectedValues");if(s==="All"){t.removeSelections();L.setProperty("/selectedValues","None")}else{t.selectAll();L.setProperty("/selectedValues","All")}if(!n.getEnabled()){n.setEnabled(true)}}function fe(e,t){var n=e.getSource(),s=n.getSelectedItems(),i=n.getItems(),l=a.getElementById(t+"_settings_popover_reset_btn");if(s.length===i.length){L.setProperty("/selectedValues","All")}else if(s.length<i.length&&s.length>0){L.setProperty("/selectedValues","Partion")}else{L.setProperty("/selectedValues","None")}if(!l.getEnabled()){l.setEnabled(true)}}function ve(e,t){e=e||[];W.removeAllItems();var a=[];W.addItem(new g({text:"No customizing needed",key:""}));for(var n=0;n<ue.length;n++){var s=ue[n],i=new g({text:s.label,key:"key"+n});i._data=s;if(s.sourceTypes.indexOf(t)>-1||e.indexOf(s.formatMethod)>-1){W.addItem(i)}else{a.push(i)}}for(var n=0;n<a.length;n++){W.addItem(a[n])}}function ye(e,t){t=t||[];if(t.indexOf("technical")>-1){e=e+"\n"+N.getText("EDITOR_MORE_DYNAMICVALUES_TECHHINT")}K.setText(e)}function be(e){if(ue.length===-1){if(!e){W.removeAllItems();W.addItem(new g({text:"No customizing available for this value"}));Y.setText("");W.setEnabled(false)}else{ve(e.customize,e.type);W.setEnabled(true)}}}function Se(e){if(e){L.setProperty("/_hasDynamicValue",true);var t=e.value;L.setProperty("/value",t);L.setProperty("/_contextpath",e.path);if(e.object&&e.object.value&&e.object.value.indexOf("{{")===0){L.setProperty("/_currentContextValue",h.processPredefinedParameter(e.object.value));be(e.object)}else{if(e.path==="empty"){L.setProperty("/value","");L.setProperty("/_currentContextValue","");L.setProperty("/_hasDynamicValue",false);be()}else{be(e.object);if(e.object&&e.object.hasOwnProperty("value")){L.setProperty("/_currentContextValue",e.object.value)}else{j.oHost.getContextValue(e.path+"/value").then(function(t){if(t===null){L.setProperty("/_currentContextValue","(not available)")}else{L.setProperty("/_currentContextValue",t)}e.object&&(e.object.value=t)})}}}}}R._private=function(){return{oPopover:X,oSegmentedButton:Z,oSettingsButton:z,oDynamicPanel:U,oSettingsPanel:F,oTransformPanel:$,oCurrentModel:L,updateCurrentValue:Se,oCurrentInstance:j,oDynamicValueField:k,oResetToDefaultButton:q,getMenuItems:function(){return G},getMenu:function(){return H}}};R.prototype.prepareFieldsInKey=function(e){this._sKeySeparator=e.values.keySeparator;if(!this._sKeySeparator){this._sKeySeparator="#"}var t=e.values.item.key;this._aFields=t.split(this._sKeySeparator);for(var a in this._aFields){if(this._aFields[a].startsWith("{")){this._aFields[a]=this._aFields[a].substring(1)}if(this._aFields[a].endsWith("}")){this._aFields[a]=this._aFields[a].substring(0,this._aFields[a].length-1)}}};R.prototype.getKeyFromItem=function(e){var t="";this._aFields.forEach(function(a){t+=e[a].toString()+this._sKeySeparator}.bind(this));if(t.endsWith(this._sKeySeparator)){t=t.substring(0,t.length-this._sKeySeparator.length)}return t};return R});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/BaseField", ["sap/ui/core/Control","sap/m/Text","sap/m/Input","sap/m/MultiInput","sap/m/Token","sap/ui/core/Element","sap/ui/integration/util/BindingHelper","sap/ui/core/ListItem","sap/base/util/ObjectPath","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/core/Fragment","sap/ui/integration/util/Validators","sap/ui/model/json/JSONModel","sap/m/List","sap/m/CustomListItem","sap/m/VBox","sap/ui/core/CustomData","sap/ui/model/Sorter"],function(e,t,i,s,a,n,r,o,l,u,g,d,f,h,p,y,c,v,m){"use strict";var _="sap/ui/integration/editor/fields/viz";var b=e.extend("sap.ui.integration.editor.fields.BaseField",{metadata:{library:"sap.ui.integration",properties:{configuration:{type:"object"},specialButton:{type:"object"},mode:{type:"string"},host:{type:"object"},visible:{type:"boolean",defaultValue:true},parameterKey:{type:"string"},allowPopover:{type:"boolean",defaultValue:true}},aggregations:{_field:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_dynamicField:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{_messageIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_messageStrip:{type:"sap.m.MessageStrip",multiple:false,visibility:"hidden"},_editor:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{afterInit:{},validateFailed:{},settingsPanelOpened:{}}},renderer:{apiVersion:2,render:function(e,t){var i=t.getAggregation("_field"),s=t._getDynamicField();e.openStart("div",t);e.class("sapUiIntegrationEditorItemField");if(i&&i.getWidth){}if(!t.getVisible()){e.style("display","none")}e.openEnd();if(t.getVisible()){e.openStart("span");e.class("sapUiIntegrationEditorEditor");if(t._hasDynamicValue()){e.style("width","1px");e.style("opacity","0")}else{e.style("width","100%")}e.openEnd();e.renderControl(i);e.close("span");if(t._hasDynamicValue()){e.openStart("span");e.class("sapUiIntegrationEditorSettings");e.openEnd();e.openStart("span");e.class("sapUiIntegrationEditorSettingsField");e.style("width","100%");e.style("opacity","1");e.openEnd();e.renderControl(s);e.close("span");e.close("span")}e.openStart("div",t.getId()+"-ms");e.style("height","0");e.openEnd();e.close("div")}e.close("div")}}});b.prototype.init=function(){this._readyPromise=new Promise(function(e){this._fieldResolver=e}.bind(this))};b.prototype.getMessagestrip=function(){var e=this.getAssociation("_messageStrip");return n.getElementById(e)};b.prototype.getMessageIcon=function(){var e=this.getAssociation("_messageIcon");return n.getElementById(e)};b.prototype._removeValidationMessage=function(){var e=this.control,t=e.getParent().getMessageIcon();if(t){t.setVisible(false)}if(e.getEnabled()){e.setEnabled(false)}};b.prototype.getResourceBundle=function(){return this.getModel("i18n").getResourceBundle()};b.prototype.setConfiguration=function(e,t){if(e!==this.getConfiguration()){this._sanitizeValidationSettings(e);this.setProperty("configuration",e,t);if(e){Promise.resolve().then(function(){this.initEditor(e)}.bind(this))}}return this};b.prototype._sanitizeValidationSettings=function(e){e.validations=e.validations||[];if(e.validation&&e.validations&&Array.isArray(e.validations)){e.validations.push(e.validation);delete e.validation}if(e.validation&&!e.validations){e.validations=[e.validation];delete e.validation}if(e.required){e.validations.unshift({required:true,type:"error"})}};b.prototype.deleteTranslationValuesInTexts=function(e){var t=this;var i=t.getConfiguration();var s="/texts";var a=this._settingsModel.getData();if(!a||!a.texts){return}var n=g(a.texts,500);if(e){if(n[e]){delete n[e][i.manifestpath];if(u(n[e],{})){delete n[e]}if(u(n,{})){delete a.texts;this._settingsModel.setData(a)}else{this._settingsModel.setProperty(s,n)}}}else{for(var r in n){t.deleteTranslationValuesInTexts(r)}}};b.prototype._triggerValidation=function(e){if(u(e,this._preChangedValue)&&this._messageFrom==="validation"){return}this._preChangedValue=e;var t=this.getConfiguration();var i=false;if(t.required){i=true}else if(t.type==="string"&&e){i=true}else if((t.type==="integer"||t.type==="number")&&!isNaN(e)){if(e!==""){i=true}}else if(t.type==="boolean"){i=true}else if(t.type==="string[]"&&Array.isArray(e)){i=true}if(t.validations&&Array.isArray(t.validations)&&i){delete t.validateCheck;for(var s=0;s<t.validations.length;s++){var a=this._handleValidation(t.validations[s],e);if(typeof a==="boolean"&&!a){this.fireValidateFailed();t.validateCheck="failed";return}else if(typeof a.then==="function"){a.then(function(e){if(!e){this.fireValidateFailed();t.validateCheck="failed"}}.bind(this))}}this._hideValueState()}};b.prototype._requestData=function(e){var t=this.control.getParent();var i=t.getConfiguration();var s=t._oDataProviderFactory.create(e.data);t.getModel("currentSettings").setProperty(i._settingspath+"/_loading",true);var a=s.getData();return a.then(function(s){t.getModel("currentSettings").setProperty(i._settingspath+"/_loading",false);var a=e.data.path||"/";if(a.startsWith("/")){a=a.substring(1)}if(a.endsWith("/")){a=a.substring(0,a.length-1)}var n=a.split("/");var r=l.get(n,s);return r})};b.prototype._handleValidation=function(e,t){var i=this.getConfiguration(),s=f[i.type];var a=function(a,n){var r;if(typeof e.message==="function"){r=e.message(t,i,n)}else{r=e.message}if(!r){if(e._txt){r=this.getResourceBundle().getText(s[e._txt],[e[a]])}else{r=this.getResourceBundle().getText(s[a+"Txt"],[e[a]])}}this._showValueState(e.type||"error",r)}.bind(this);if(e["validate"]){var n={control:this.getAggregation("_field"),requestData:this._requestData,removeValidationMessage:this._removeValidationMessage};var r=e["validate"];return Promise.resolve(r(t,i,n)).then(function(e){var t=e.isValid;if(typeof t==="undefined"){t=e}var i=e.data?e.data:undefined;if(!t){a("validate",i);return false}else{this._hideValueState(true,false);return true}}.bind(this))}else{for(var o in e){if(s){var l=s[o];e._txt="";if(l){if(!l(t,e[o],e)){a(o);return false}}}}}return true};b.prototype.onAfterRendering=function(){this._applyMessage();var e=this.getMessagestrip();if(e&&e.getDomRef()){e.getDomRef().style.opacity="0"}};b.prototype._applyMessage=function(){var e=n.getElementById(this.getAssociation("_messageIcon"));if(this.getAssociation("_messageIcon")&&e){var t=e.getDomRef();if(t){t.classList.remove("error");t.classList.remove("warning");t.classList.remove("success");if(this._message){t.classList.add(this._message.type)}}}if(this._message&&(this._message.type==="error"||this._message.type==="warning")){var i=this._message.type==="error"?"Error":"Warning";this._setCurrentProperty("hasError",true);this._setCurrentProperty("errorType",i)}else{this._setCurrentProperty("hasError",false);this._setCurrentProperty("errorType","None")}};b.prototype._showValueState=function(e,t,i){var s=this.getAggregation("_field"),a=e.substring(0,1).toUpperCase()+e.substring(1);this._message={enum:a,type:e,message:t,atControl:false};this._messageFrom="validation";if(i){this._messageFrom="request"}var n=this.getMessagestrip();if(s&&s.setValueState){this._message.atControl=true;if(s.setShowValueStateMessage){s.setShowValueStateMessage(false)}s.setValueState(a);s.setValueStateText(t)}else if(n&&n.getVisible()&&s.getMetadata().getName()!=="sap.m.Switch"){this._showMessage()}this._applyMessage()};b.prototype._hideValueState=function(e,t){if(!this.getParent()){return}var i=this.getMessagestrip();if(this._message){if(e&&this._messageFrom==="request"||!e&&this._messageFrom==="validation"){var s=this.getAggregation("_field");this._message={enum:"Success",type:"success",message:"Corrected",atControl:this._message.atControl};this._messageFrom="validation";if(e){this._messageFrom="request"}if(this._messageto){clearTimeout(this._messageto)}this._messageto=setTimeout(function(){this._messageto=null;this._applyMessage();if(!this._message&&s.setValueState){s.setValueState("None")}}.bind(this),1500);this._applyMessage();if(i){if(i.getDomRef()){i.getDomRef().style.opacity="0"}i.onAfterRendering=null}if(s.setValueState){s.setValueState("Success")}if(s.setValueStateText){s.setValueStateText("")}this._message=null}if(!this._message&&e&&t){this._triggerValidation(this.getConfiguration().value)}}};b.prototype.onfocusin=function(e){if(e&&e.target.classList.contains("sapMBtn")){return}this._showMessage()};b.prototype.onfocusout=function(e){this._hideMessage()};b.prototype._showMessage=function(){if(!this.getParent()){return}var e=this.getMessagestrip();if(this._message&&e){e.applySettings({type:this._message.enum,text:this._message.message});var t=this;e.onAfterRendering=function(){e.getDomRef().style.zIndex="1";e.getDomRef().style.opacity="1";t.getDomRef("ms")&&t.getDomRef("ms").appendChild(e.getDomRef());var i=t.getAggregation("_field");if(t._message&&!t._message.atControl){e.getDomRef().style.marginTop="0";e.getDomRef().style.marginLeft="0"}var s=i.getDomRef()?i.getDomRef().offsetWidth-5:100;if(s<=100){s=i.getParent().getDomRef()?i.getParent().getDomRef().offsetWidth-35:100}e.getDomRef().style.width=s+"px"};e.invalidate()}};b.prototype._hideMessage=function(){var e=this.getMessagestrip();var t=this.getAggregation("_field"),i=t.getDomRef()&&t.getDomRef().contains(window.document.activeElement);if(e){if(!i&&e.getDomRef()){e.getDomRef().style.opacity="0";e.getDomRef().style.zIndex="-1"}e.onAfterRendering=null}};b.prototype.getParameterId=function(){return this.getAssociation("_editor")+"_"+this.getParameterKey()};b.prototype.initEditor=function(t){var i;this._settingsModel=this.getModel("currentSettings");this.initVisualization&&this.initVisualization(t);if(this._visualization.editor){i=this._visualization.editor}else if(this._visualization.type){if(typeof this._visualization.type==="string"){if(this._visualization.type.indexOf("/")===-1){this._visualization.type=_+"/"+this._visualization.type;this._visualization.settings=this._visualization.settings||{value:"{currentSettings>value}",editable:t.editable}}sap.ui.require([this._visualization.type],function(e){this._visualization.type=e;this.initEditor(t)}.bind(this));return}i=new this._visualization.type(this.getParameterId()+"_control",this._visualization.settings||{})}else if(this._visualization.fragment){if(typeof this._visualization.fragment==="string"){if(!this._visualization.controller){this._visualization.controller=this._visualization.fragment+".controller"}if(typeof this._visualization.controller==="string"){sap.ui.require([this._visualization.controller],function(e){this._visualization.controller=new e;this._visualization.controller.init();this._visualization.controller.setField(this);this.initEditor(t)}.bind(this))}else if(typeof this._visualization.controller==="object"){d.load({name:this._visualization.fragment,controller:this._visualization.controller}).then(function(e){this._visualization.fragment=e;this.initEditor(t)}.bind(this))}else{d.load({name:this._visualization.fragment}).then(function(e){this._visualization.fragment=e;this.initEditor(t)}.bind(this))}return}i=this._visualization.fragment}if(i instanceof e){this.setAggregation("_field",i);if(i.attachChange){i.attachChange(function(e){if(e.mParameters.value===""){var t=this.getConfiguration();if(t.type==="string[]"){this._triggerValidation(t.value)}else{this._triggerValidation(e.getParameter("value"))}}}.bind(this))}var s=this._settingsModel.bindProperty("value",this.getBindingContext("currentSettings"));s.attachChange(function(){this._triggerValidation(t.value)}.bind(this));this._triggerValidation(t.value)}var a=this.getMode();t.allowSettings=t.allowSettings||t.allowSettings!==false&&a==="admin";t.allowDynamicValues=t.allowDynamicValues||t.allowDynamicValues!==false;t._changeDynamicValues=t.visible&&t.editable&&(t.allowDynamicValues||t.allowSettings)&&a!=="translation";if(t._changeDynamicValues){this._getDynamicField()}this._applySettings(t);this.fireAfterInit()};b.prototype.initVisualization=function(){};b.prototype._hasDynamicValue=function(){var e=this._getCurrentProperty("value");var t=typeof e==="string"&&(e.indexOf("{context>")===0||e.indexOf("{{parameters")===0);this._setCurrentProperty("_hasDynamicValue",t);return t};b.prototype._hasSettings=function(){var e=this.getConfiguration();if(e._next){var t=e.hasOwnProperty("visibleToUser")?e.visibleToUser:true;var i=e.hasOwnProperty("editableToUser")?e.editableToUser:true;var s=e._next.visible===false?false:e._next.editable;var a=e.hasOwnProperty("allowDynamicValues")?e.allowDynamicValues:true;e._hasSettings=e._next.visible===!t||s===!i||e._next.allowDynamicValues===!a||typeof e._next.pageAdminNewDestinationParameter!=="undefined"}else{e._hasSettings=false;if(e.hasOwnProperty("editableToUser")||e.hasOwnProperty("visibleToUser")){e._next={}}if(e.hasOwnProperty("editableToUser")){e._next.editable=e.editableToUser}if(e.hasOwnProperty("visibleToUser")){e._next.visible=e.visibleToUser}}return e._hasSettings};b.prototype._getDynamicField=function(){var e=this.getAggregation("_dynamicField");if(!e){var e=new s(this.getParameterId()+"_dynamic_control",{showValueHelp:false});this.setAggregation("_dynamicField",e)}return e};b.prototype._hideDynamicField=function(){var e=this._getDynamicField(),t=this.getAggregation("_field");if(e.getDomRef()){var i=e.getDomRef().parentNode.style;i.width="1px";i.opacity=0;i=t.getDomRef().parentNode.style;t.getDomRef().style.visibility="visible";i.width="100%";i.opacity=1}};b.prototype._showDynamicField=function(){var e=this._getDynamicField(),t=this.getAggregation("_field");if(e.getDomRef()){var i=e.getDomRef().parentNode.style;i.width="100%";i.opacity=1;i=t.getDomRef().parentNode.style;t.getDomRef().style.visibility="hidden";i.width="1px";i.opacity=0}};b.prototype._setCurrentProperty=function(e,t){if(this._getCurrentProperty(e)!==t){this._settingsModel.setProperty(e,t,this.getBindingContext("currentSettings"))}};b.prototype._getCurrentProperty=function(e){return this._settingsModel.getProperty(e,this.getBindingContext("currentSettings"))};b.prototype._applySettings=function(e){var t=this._getDynamicField(),i=this.getModel("contextflat")._getValueObject(e.value);t.removeAllTokens();if(!this._getCurrentProperty("_changeDynamicValues")){t.setEnabled(false)}if(i&&i.path!=="empty"){if(i.object.value&&i.object.value.indexOf("{{")==0){this._setCurrentProperty("value",i.object.value)}else{this._setCurrentProperty("value",i.value)}t.addToken(new a({text:i.object.label,delete:function(){this._setCurrentProperty("value","");var e=this.getAggregation("_field");e.setValue("");e.fireChange();if(!this._hasDynamicValue()){this._hideDynamicField()}this._applyButtonStyles();window.setTimeout(function(){this.getAggregation("_field").focus()}.bind(this),100)}.bind(this)}));var s=this.getConfiguration();if(s.type==="string"&&s.translatable){this.deleteTranslationValuesInTexts()}}else{this._setCurrentProperty("value",e.value);this._setCurrentProperty("_changed",e._changed);this._hideDynamicField()}this._setCurrentProperty("_next",e._next);this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField()}else{this._showDynamicField()}this._fieldResolver&&this._fieldResolver();this._fieldResolver=null};b.prototype._cancelSettings=function(){this._applyButtonStyles();if(!this._hasDynamicValue()){this._hideDynamicField()}};b.prototype._applyButtonStyles=function(){if(!this._settingsButton){return}if(!this._hasDynamicValue()){this._settingsButton.removeStyleClass("dynamicvalue")}else{this._settingsButton.addStyleClass("dynamicvalue")}if(!this._hasSettings()){this._settingsButton.removeStyleClass("settings")}else{this._settingsButton.addStyleClass("settings")}};b.prototype.isFilterBackend=function(){var e=this.getConfiguration();var t=false;if(e&&e.values&&e.values.data){if(e.values.data.request&&e.values.data.request.parameters&&e.values.data.request.parameters.$filter&&e.values.data.request.parameters.$filter.indexOf("{currentSettings>suggestValue}")>-1){t=true}else if(e.values.data.request&&e.values.data.request.url&&e.values.data.request.url.indexOf("{currentSettings>suggestValue}")>-1){t=true}}return t};b.prototype.formatListItem=function(e){var t=new o;for(var i in e){t.bindProperty(i,r.createBindingInfos(e[i]))}return t};b.prototype.addModelPrefix=function(e,t){for(var i in e){var s=e[i];s="{"+t+">"+s.substring(1);e[i]=s}return e};b.prototype.getPopoverPlacement=function(e){var t="Right";var i=e.getDomRef().getBoundingClientRect().x;var s=document.body.offsetWidth;if(2*i>s){t="Left"}return t};b.prototype.buildTranslationsList=function(e){return new p(e+"",{items:{path:"languages>/translatedLanguages",key:"key",template:new y({content:[new c({items:[new t({text:"{languages>description}"}),new i({value:"{languages>value}",editable:"{languages>editable}",valueState:"{= ${languages>updated} === true ? 'Information' : 'None' }",showValueStateMessage:false})]})],customData:[new v({key:"{languages>key}",value:"{languages>description}"})]}),sorter:[new m({path:"updated",descending:true})]}})};b.prototype.buildTranslationsModel=function(e){var t=new h(e);t.attachPropertyChange(function(e){var i=e.getParameter("context");t.setProperty(i.getPath("updated"),true);t.setProperty("/isUpdated",true)});return t};return b});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/BooleanField", ["sap/ui/integration/editor/fields/BaseField","sap/m/CheckBox"],function(e,t){"use strict";var i=e.extend("sap.ui.integration.editor.fields.BooleanField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});i.prototype.initVisualization=function(e){var i=e.visualization;if(!i){i={type:t,settings:{selected:{path:"currentSettings>value"},editable:e.editable}};e.withLabel=true}else if(i.type==="Switch"){i.type="sap/m/Switch"}this._visualization=i};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/DateField", ["sap/ui/integration/editor/fields/BaseField","sap/m/DatePicker","sap/ui/core/date/UI5Date","sap/ui/model/type/Date"],function(e,t,a,i){"use strict";var n=e.extend("sap.ui.integration.editor.fields.DateField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});n.prototype.initVisualization=function(e){var n=e.visualization;var r=e.formatter;if(e.value!==""){e.value=a.getInstance(e.value)}if(!n){n={type:t,settings:{value:{path:"currentSettings>value",type:new i(r)},editable:e.editable,width:"100%",change:function(e){if(e.getParameters().valid){var t=e.getSource();t.getBinding("value").setValue(t.getDateValue());t.getBinding("value").checkUpdate()}else{var t=e.getSource();t.getBinding("value").setValue("")}}}}}this._visualization=n};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/DateTimeField", ["sap/ui/integration/editor/fields/BaseField","sap/m/DateTimePicker","sap/ui/core/date/UI5Date","sap/ui/model/type/DateTime"],function(e,t,a,i){"use strict";var n=e.extend("sap.ui.integration.editor.fields.DateTimeField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});n.prototype.initVisualization=function(e){var n=e.visualization;var r=e.formatter;if(e.value!==""){e.value=a.getInstance(e.value)}if(!n){n={type:t,settings:{value:{path:"currentSettings>value",type:new i(r)},editable:e.editable,width:"100%",change:function(e){if(e.getParameters().valid){var t=e.getSource();t.getBinding("value").setValue(t.getDateValue().toISOString());t.getBinding("value").checkUpdate()}else{var t=e.getSource();t.getBinding("value").setValue("");t.getBinding("value").checkUpdate(true)}}}}}this._visualization=n};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/DestinationField", ["sap/ui/integration/editor/fields/BaseField","sap/ui/core/ListItem","sap/m/ComboBox","sap/ui/model/Sorter","sap/ui/model/Filter"],function(e,t,i,a,n){"use strict";var r=e.extend("sap.ui.integration.editor.fields.DestinationField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});r.prototype.initVisualization=function(e){var r=this;var s=e.visualization;if(!s){s={type:i,settings:{busy:{path:"destinations>_loading",formatter:function(t){if(!t&&e.filter){var i;if(Array.isArray(e.filter.filters)){var a=[];e.filter.filters.forEach(function(e){a.push(new n(e))});var s=typeof e.filter.and==="boolean"?e.filter.and:false;i=new n({filters:a,and:s})}else{i=new n(e.filter)}var o=r.getAggregation("_field").getBinding("items");if(!o){r.attachEventOnce("afterInit",function(){o=r.getAggregation("_field").getBinding("items");o.filter([i])})}else{o.filter([i])}}return t}},selectedKey:{path:"currentSettings>value"},width:"100%",editable:{path:"currentSettings>editable"},items:{path:"destinations>_values",template:new t({text:"{destinations>name}",key:"{destinations>name}"})}}};s.settings.items.sorter=[];var o=e.sorter||[{path:"name"}];o.forEach(function(e){s.settings.items.sorter.push(new a(e))})}this._visualization=s};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/GroupField", ["sap/ui/core/Element","sap/ui/integration/editor/fields/BaseField","sap/m/Panel","sap/m/IconTabBar","sap/m/IconTabFilter","sap/m/MessageStrip"],function(e,t,r,i,n,a){"use strict";var s=t.extend("sap.ui.integration.editor.fields.GroupField",{metadata:{library:"sap.ui.integration"},renderer:t.getMetadata().getRenderer()});s.prototype.initVisualization=function(t){var n=t.visualization;if(!n||n.type==="Panel"){n={type:r,settings:{headerText:t.label,visible:t.visible,expandable:t.expandable!==false,expanded:"{currentSettings>expanded}",width:"auto",backgroundDesign:"Transparent",objectBindings:{currentSettings:{path:"currentSettings>"+(t._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}},expand:function(t){var r=t.getParameter("expand");if(r){var i=t.getSource();var n=this.getConfiguration();if(!i._level){i._level=n.level||0}var a=i._level==="1"&&this.getParent().getParent()?this.getParent().getParent().getAggregation("_messageStrip"):this.getParent().getAggregation("_messageStrip");if(a===null){a=e.getElementById(this.getAssociation("_messageStrip"))}i.addContent(a);i.focus()}}.bind(this)}}}else if(n.type==="Tab"){n={type:i,settings:{expandable:t.expandable!==false,visible:t.visible,expanded:"{currentSettings>expanded}",objectBindings:{currentSettings:{path:"currentSettings>"+(t._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}},select:this.checkErrorsInIconTabBar.bind(this)}}}this._visualization=n;this.attachAfterInit(this._afterInit)};s.prototype._afterInit=function(){var e=this.getConfiguration();var t=this.getAggregation("_field");if(t instanceof r){if(this.getMode()!=="translation"){var s=this.getResourceBundle();var o=new a({id:this.getParameterId()+"_strip",showIcon:false,visible:"{= !${currentSettings>expanded} && ${currentSettings>hasError} === true}",text:{path:"currentSettings>errorType",formatter:function(e){var t="";switch(e){case"Error":t=s.getText("EDITOR_GROUP_ERRORS");break;case"Warning":t=s.getText("EDITOR_GROUP_WARNINGS");break;default:}return t}},type:"{currentSettings>errorType}",objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")}}});if(e.level!=="1"){o.setModel(this._settingsModel,"currentSettings")}o.addStyleClass("sapUiIntegrationEditorPanelMessageStrip");t._messageStrip=o}t._cols=e.cols||2;t._level=e.level||0;var l={onAfterRendering:function(t){var n=t.srcControl;var a=document.getElementById(n.getId());a.setAttribute("aria-label",e.label);if(n._subItems&&n._subItems.length>0){this.checkErrorsInSubItems(this._settingsModel,n)}var s=n._messageStrip;if(n._level!=="1"&&s){s.invalidate()}if(n.getExpanded()){var o=n.getContent();o.forEach(function(e){if(e.isA("sap.ui.integration.editor.fields.GroupField")){var t=e.getAggregation("_field");if(t instanceof r&&t._subItems&&t._subItems.length>0){e.checkErrorsInSubItems(e._settingsModel,t)}else if(t instanceof i&&t.getItems().length>0){e.checkErrorsInIconTabBar()}}})}}.bind(this)};t.addEventDelegate(l)}else if(t instanceof i){var g=new n(this.getParameterId()+"_control_icontabfilter",{text:e.label,visible:e.visible,objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")},items:{path:"items>/form/items"},context:{path:"context>/"}}});t.addItem(g);t.setBackgroundDesign("Transparent");t.setHeaderBackgroundDesign("Transparent");if(this.getMode()!=="translation"){var d=new a({id:this.getParameterId()+"_strip",showIcon:false,visible:false,objectBindings:{currentSettings:{path:"currentSettings>"+(e._settingspath||"/form/items")}}});d.addStyleClass("sapUiIntegrationEditorTabMessageStrip");t._messageStrip=d}g._level=e.level||0}};s.prototype.checkErrorsInIconTabBar=function(t){var r=this.getAggregation("_field"),i=r.getSelectedKey(),a=r.getItems(),s=r.getExpanded(),o=false;for(var l=0;l<a.length;l++){if(!s){o=true}else if(a[l].getId()!==i){o=true}else if(a[l].getId()===i){o=false}if(o){var g=false,d="None";if(a[l]._subItems&&a[l]._subItems.length>0){var c=a[l].getModel("currentSettings");var u=this.checkErrorsInSubItems(c,a[l]);g=u.hasError;d=u.errorType}if(g){var p=new n,f=a[l];if(f.getItems().length>0){f.removeAllItems()}f.addItem(p);this._handleITBValidation(f,d);if(f._oExpandButton===undefined){this._delayHandleITBValidation(f,d)}else{this._handleITBValidation(f,d)}}}else if(a[l].getItems().length>0){a[l].removeItem(a[l].getItems()[0]);if(a[l]._oExpandButton){a[l]._oExpandButton.visible=false}var h=this.getParent().getParent().getAggregation("_messageStrip");if(h===null){h=e.getElementById(this.getAssociation("_messageStrip"))}a[l].addContent(h)}}};s.prototype.checkErrorsInSubItems=function(t,r){var i=false;var n="None";for(var a=0;a<r._subItems.length;a++){var s=r._subItems[a].settingspath;var o=e.getElementById(r._subItems[a].itemId);if(t.getProperty(s+"/hasError")===true&&o.getVisible()){i=true;var l=t.getProperty(s+"/errorType");if(l==="Error"){n="Error";break}else if(l==="Warning"&&n!=="Error"){n="Warning"}}}t.setProperty("hasError",i,this.getBindingContext("currentSettings"));t.setProperty("errorType",n,this.getBindingContext("currentSettings"));return{hasError:i,errorType:n}};s.prototype._handleITBValidation=function(t,r){var i=this.getResourceBundle();if(t.getItems().length>0&&t._oExpandButton){var n=t._oExpandButton;var a=null;if(r==="Error"){a=i.getText("EDITOR_GROUP_ERRORS");n.setIcon("sap-icon://message-error");n.addStyleClass("errorBTNImage")}else if(r==="Warning"){a=i.getText("EDITOR_GROUP_WARNINGS");n.setIcon("sap-icon://message-warning");n.addStyleClass("warningBTNImage")}n.setTooltip(null);n.addEventDelegate({onAfterRendering:function(e){var t=document.getElementById(n.getId());t.setAttribute("aria-label","With validation errors");t.setAttribute("title","")}});n.setEnabled(false);n.addStyleClass("errorBTN").addStyleClass("errorBTNDisabled");var s=e.getElementById(this.getParameterId()+"_strip");n.addEventDelegate({onmouseover:function(){s.setVisible(true);s.setType(r);s.setText(a)},onmouseout:function(){s.setVisible(false)}},this)}};s.prototype._delayHandleITBValidation=function(e,t){var r=this;var i=setInterval(function(){if(e._oExpandButton){r._handleITBValidation(e,t);clearInterval(i)}},50)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/IntegerField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/ui/model/type/Integer"],function(e,t,a){"use strict";var i=e.extend("sap.ui.integration.editor.fields.IntegerField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});i.prototype.initVisualization=function(e){var i=e.visualization;var r=e.formatter;if(!i){i={type:t,settings:{value:{path:"currentSettings>value",type:new a(r)},editable:e.editable,type:"Number",parseError:function(e){var t=e.getSource(),a=null;if(t.getValue()!==""){if(e.getParameters()&&e.getParameters().exception&&e.getParameters().exception.message){a=e.getParameters().exception.message}else{a=e.getId()}t.getParent()._showValueState("error",a)}else{t.getParent()._showValueState("none","")}}}}}else if(i.type==="Slider"){i.type="sap/m/Slider"}this._visualization=i};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/NumberField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/ui/model/type/Float"],function(e,t,i){"use strict";var a=e.extend("sap.ui.integration.editor.fields.NumberField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});a.prototype.initVisualization=function(e){var a=e.visualization;var r=e.formatter;if(!a){a={type:t,settings:{value:{path:"currentSettings>value",type:new i(r)},editable:e.editable,type:"Number"}}}this._visualization=a};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/ObjectField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Text","sap/m/TextArea","sap/m/Input","sap/m/NavContainer","sap/m/Page","sap/m/Popover","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Button","sap/ui/model/json/JSONModel","sap/ui/table/Table","sap/ui/table/Column","sap/ui/table/rowmodes/Fixed","sap/m/Label","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/base/util/deepEqual","sap/ui/core/Icon","sap/m/Switch","sap/m/CheckBox","sap/m/MessageBox","sap/m/MessageToast","sap/base/util/deepClone","sap/m/Link","sap/ui/layout/form/SimpleForm","sap/base/util/merge","sap/ui/model/Sorter","sap/ui/integration/util/Utils","sap/m/table/columnmenu/Menu","sap/m/ComboBox","sap/ui/core/ListItem","sap/ui/model/type/Integer","sap/ui/model/type/Float","sap/m/HBox","sap/ui/core/CustomData","sap/ui/integration/editor/fields/viz/IconSelect","sap/m/Image"],function(e,t,a,r,o,n,l,i,s,d,u,p,_,c,g,v,f,T,b,h,y,O,P,m,E,I,S,D,w,C,L,x,V,B,A,M,R,j){"use strict";var U=/\{\{(?!parameters.)(?!destinations.)([^\}\}]+)\}\}/g;var N=e.extend("sap.ui.integration.editor.fields.ObjectField",{metadata:{library:"sap.ui.integration",events:{tableUpdated:{},translationPopoverOpened:{}}},renderer:e.getMetadata().getRenderer()});N.prototype.initVisualization=function(e){var t=this;t._newObjectTemplate={_dt:{_selected:true,_uuid:""}};var a=e.visualization;if(!a){if(e.value&&!e.properties&&(!e.values||e.values&&!e.values.metadata)){t.parseValueProperties()}if(e.values){a=t.createTableVisualization(e)}else if(e.properties){a=t.createSimpleFormVisualization(e)}else{a=t.createTextAreaVisualization(e)}e.withLabel=true}this._visualization=a;this.attachAfterInit(this._afterInit)};N.prototype._afterInit=function(){var e=this;var t=this.getAggregation("_field");if(t instanceof I){t.addStyleClass("sapUiIntegrationEditorItemObjectFieldForm");var a=m(e.getConfiguration().value,500)||{};t.setModel(new u({value:a,editMode:"Properties"}))}else if(t instanceof p){t.addStyleClass("sapUiIntegrationEditorItemObjectFieldTable");e._oMenu=new C;var r=t.getColumns();for(var o=0;o<r.length;o++){if(r[o].getFilterProperty()||r[o].getSortProperty()){r[o].setHeaderMenu(e._oMenu.getId())}}}};N.prototype.parseValueProperties=function(){var e=this;var t=e.getConfiguration();if(typeof t.value==="object"&&!T(t.value,{})&&!Array.isArray(t.value)&&!t.properties){var a={};for(var r in t.value){if(r!=="_dt"){var o=typeof t.value[r];var n=o==="string"?{}:{type:o};a[r]=n}}if(!T(a,{})){t.properties=a;t._propertiesParsedFromValue=true}}};N.prototype.createTableVisualization=function(e){var t=this;var a=t.createTableToolbar(e);var r=[];var o=e.values?e.values.data.path||"/":"/value";if(e.values&&e.values.metadata){r={path:"meta>/"+e.values.metadata.namespace+"."+e.values.metadata.entityTypeName,filters:new v({path:"$kind",operator:f.EQ,value1:"Property"}),factory:t.columnFactory.bind(t)}}else{r=t.buildTableColumns()}var n={type:p,settings:{rowMode:new c({rowCount:5}),busy:"{currentSettings>_loading}",busyIndicatorDelay:200,columns:r,selectionBehavior:"RowOnly",rowSelectionChange:t.onTableSelectionChange.bind(t),extension:a,filter:t.onFilter.bind(t)}};if(e.type==="object"){n.settings.rows="{"+o+"}"}else{n.settings.rows="{path: '"+o+"', sorter: {path: '_dt/_position', descending: false}}"}return n};N.prototype.createSimpleFormVisualization=function(e){var t=this;var a=t.getParameterId();var r=t.getResourceBundle();var o=function(){var e=this.getAggregation("_field").getModel();e.checkUpdate(true);var t=e.getProperty("/value")||{};if(!t._dt){t._dt={_uuid:w.generateUuidV4()}}else if(!t._dt._uuid){t._dt._uuid=w.generateUuidV4()}t=m(t,500);this.setValue(t)}.bind(t);var n=t.createFormContents(o,"/value/",false,t.openTranslationPopup);var l=new d(a+"_control_form_editmode_btn",{icon:{path:"/editMode",formatter:function(e){if(e==="Properties"){return"sap-icon://syntax"}else{return"sap-icon://form"}}},tooltip:{path:"/editMode",formatter:function(e){if(e==="Properties"){return r.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_JSON")}else{return r.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_PROPERTIES")}}},press:function(){var e=t.getAggregation("_field").getModel();var a=e.getProperty("/editMode");if(a==="Properties"){e.setProperty("/editMode","Json")}else{e.setProperty("/editMode","Properties")}}});var u=new d(a+"_control_form_delete_btn",{icon:"sap-icon://delete",tooltip:r.getText("EDITOR_FIELD_OBJECT_DELETE"),visible:e.enabled,enabled:{path:"currentSettings>value",formatter:function(e){if(!e||e===""){return false}return true}},press:function(e){t.setValue(undefined);var a=t.getAggregation("_field").getModel();var r=a.getProperty("/value");if(r&&r._dt&&r._dt._uuid){t.deleteTranslationValueInTexts(undefined,r._dt._uuid)}a.setProperty("/value",{});a.checkUpdate(true)}});var p={type:I,settings:{layout:"ResponsiveGridLayout",visible:e.visible,labelSpanXL:2,labelSpanL:2,labelSpanM:2,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,toolbar:new i({content:[new s,l,u]}).addStyleClass("sapMTB"),content:n}};return p};N.prototype.createTextAreaVisualization=function(e){var t=this;var r={type:a,settings:{value:{path:"currentSettings>value",formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:"{config/editable}",width:"100%",enabled:"{config/enabled}",placeholder:"{config/placeholder}",visible:e.visible,change:this.onChangeOfTextArea.bind(t),rows:7}};return r};N.prototype.buildSelectionColumnLabels=function(){var e=this;var t=e.getConfiguration();var a=e.getResourceBundle();return new d(e.getParameterId()+"_control_table_column_selection_label_clearall_btn",{icon:"sap-icon://clear-all",type:"Transparent",enabled:typeof t.values==="undefined"?false:"{/_hasSelected}",tooltip:a.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_TOOLTIP_REMOVE"),press:e.onUnSelectAll.bind(e)})};N.prototype.buildTableColumns=function(){var e=this;var o=e.getParameterId();var n=e.getConfiguration();var p=[];var c=Object.keys(n.properties);if(c.length>0){var v=e.getResourceBundle();var f=typeof n.values==="undefined"?false:true;if(f){f=typeof n.showSelectionColumn==="undefined"?true:n.showSelectionColumn}var T=e.buildSelectionColumnLabels();var O=new _(o+"_control_table_column_selection",{width:"3.2rem",hAlign:"Center",visible:f,multiLabels:[T],template:new y({selected:"{_dt/_selected}",enabled:typeof n.values==="undefined"?false:true,tooltip:{path:"_dt/_selected",formatter:function(e){if(e){if(n.type==="object"){return v.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_UNSELECT")}else{return v.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_REMOVE")}}else if(n.type==="object"){return v.getText("EDITOR_FIELD_OBJECT_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_SELECT")}else{return v.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_CELL_TOOLTIP_ADD")}}},select:e.onSelectionChange.bind(e)})});p.push(O);for(var P in n.properties){var C=o+"_control_table_column_property_"+P;var V=n.properties[P];var B=V.label||P;var R="{"+P+"}";if(V.defaultValue){e._newObjectTemplate[P]=V.defaultValue}var N={width:"7rem",label:B};if(V.column){N=S(N,V.column)}if(N.label.match(U)){N.label="{i18n>"+N.label.substring(2,N.label.length-1)}N.tooltip=N.label;N.label=new g({text:N.label});var F=V.cell&&V.cell.type?V.cell.type:V.type||"Text";var k;var J;var $=m(V.cell)||{};if(!$.values&&V.values){$.values=V.values}delete $.type;if(F==="string"&&$.values){F="ComboBox"}if(F==="Text"&&$.editable){F="Input"}F=F.toLowerCase();switch(F){case"int":case"number":J={text:R,wrapping:false};J=S(J,$);k=new t(J);break;case"string":case"text":J={text:R,wrapping:false};J=S(J,$);var H=J.text;var z=new u({translatable:V.translatable||false,property:P});if(typeof H==="string"){var K=e.getTranslationKey(H);if(K){J.text=v.getText(K)}else if(H.startsWith("{")&&H.endsWith("}")){J.text={path:H.substring(1,H.length-1),formatter:function(t){var a=this.getBindingContext(),r,o=this.getModel("settings").getData(),n=e.getTranslationKey(t);if(o.translatable||n){if(a&&a.getObject()&&a.getObject()._dt){r=e.getTranslationValueInTexts(w._language,a.getObject()._dt._uuid,o.property);if(r){return r}}if(n){t=v.getText(n);return t}}return t}}}}J.tooltip=$.tooltip||J.text;k=new t(J);k.setModel(z,"settings");break;case"icon":var W={src:R,visible:"{= $"+R+".indexOf('data:image/') === 0}",press:function(e){var t=e.getSource();if(!t._oImagePopover){t._oImagePopover=new l(t.getId()+"-imagePopover",{placement:"Right",showHeader:false}).addStyleClass("sapUiIntegrationImageSelect")}t._oImagePopover.destroyContent();t._oImagePopover.addContent(new j(t.getId()+"-imagePopover-image",{src:t.getSrc()}).addStyleClass("image"));t._oImagePopover.openBy(t)}};var G={src:R,visible:"{= $"+R+".indexOf('data:image/') === -1}"};W=S(W,j.getMetadata().removeUnknownSettings($));G=S(G,b.getMetadata().removeUnknownSettings($));k=new A({alignItems:"Center",justifyContent:"Center",items:[new j(W).addStyleClass("imageCell"),new b(G)]});break;case"boolean":J={selected:R,enabled:false};J=S(J,$);k=new y(J);break;case"switch":J={state:R,enabled:false};J=S(J,$);k=new h(J);break;case"link":J={text:R,target:"_blank",href:R};J=S(J,$);k=new E(J);break;case"combobox":var X=this.addModelPrefix($.values.item,"settings");J={width:"100%",selectedKey:R,editable:false,items:{path:"settings>"+$.values.data.path,template:new x(X),templateShareable:false}};if($.values.sorter){J.items.sorter=[new D({path:$.values.sorter})];delete $.values.sorter}J=S(J,$);var q=new u($.values.data.json);delete J.values;k=new L(J);k.setModel(q,"settings");break;case"input":J={value:R};if($.text){J.value=$.text}J.tooltip=$.tooltip||J.text;k=new r(J);break;case"object":J={value:{path:P,formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:false};J=S(J,$);k=new A({items:[new r(J),new d({icon:"sap-icon://display",customData:[new M({key:"value",value:R})],press:function(t){var r=t.getSource();if(!e._oObjectPropertyDetailsPopover){var n=new a(o+"_control_objectproperty_details_popover_textarea",{editable:false,rows:9});var u=new d(o+"_control_objectproperty_details_popover_close_btn",{text:v.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CLOSE"),press:function(){e._oObjectPropertyDetailsPopover.close()}});e._oObjectPropertyDetailsPopover=new l(o+"_control_objectproperty_details_popover",{placement:"Right",contentWidth:"200px",contentHeight:"240px",modal:true,title:v.getText("EDITOR_FIELD_OBJECT_PROPERTY_POPOVER_TITLE"),content:[new I({layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,content:[n]})],footer:new i({content:[new s,u]})}).addStyleClass("sapUiIntegrationEditorItemObjectFieldDetailsPopover");e._oObjectPropertyDetailsPopover._oTextArea=n;e._oObjectPropertyDetailsPopover._oCloseButton=u}var p=r.getCustomData()[0];var _=p.getValue();if(_){_=JSON.stringify(_,null,"\t");if(typeof _==="object"&&!_.length){_=_.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}}e._oObjectPropertyDetailsPopover._oTextArea.setValue(_);e._oObjectPropertyDetailsPopover.openBy(r)}})]});break;default:k=new t({text:R,wrapping:false});break}N.template=k;var Z=new _(C,N);p.push(Z)}}return p};N.prototype.checkHasFilterDefined=function(e){var t=true;if(e._propertiesParsedFromValue===true){t=false}else{var a=JSON.stringify(e.properties,null,"\t");t=a.indexOf("filterProperty")>-1?true:false}return t};N.prototype.createTableToolbar=function(e){var t=this;var a=t.getParameterId();var r=t.getResourceBundle();var o=t.checkHasFilterDefined(e);var n=e.enabled!==false;var l=e.addButtonText||r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_ADD_TOOLTIP");if(n&&e.values){n=e.values.allowAdd===true}var u=[new s,new d(a+"_control_table_add_btn",{icon:"sap-icon://add",visible:n,tooltip:l,press:t.addNewObject.bind(t)}),new d(a+"_control_table_edit_btn",{icon:"sap-icon://edit",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_EDIT_TOOLTIP"),enabled:"{= !!${/_hasTableSelected}}",visible:t.getAllowPopover(),press:t.onEditOrViewDetail.bind(t)}),new d(a+"_control_table_delete_btn",{icon:"sap-icon://delete",tooltip:r.getText("EDITOR_FIELD_OBJECT_DELETE"),enabled:"{= !!${/_canDelete}}",press:t.onDelete.bind(t)}),new d(a+"_control_table_filter_btn",{icon:"sap-icon://clear-filter",visible:o,enabled:"{= !!${/_hasFilter}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_CLEAR_ALL_FILTERS_TOOLTIP"),press:t.clearAllFilters.bind(t)}),new d(a+"_control_table_multiselect_all_btn",{icon:"sap-icon://multiselect-all",visible:false,enabled:"{= !${/_hasTableAllSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_SELECT_ALL_SELETIONS_TOOLTIP"),press:t.selectAllTableSelections.bind(t)}),new d(a+"_control_table_multiselect_none_btn",{icon:"sap-icon://multiselect-none",visible:false,enabled:"{= !!${/_hasTableSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_CLEAR_ALL_SELETIONS_TOOLTIP"),press:t.clearAllTableSelections.bind(t)})];if(e.type==="object[]"){u=u.concat([new d(a+"_control_table_navigationup_btn",{icon:"sap-icon://navigation-up-arrow",enabled:"{= !!${/_hasOnlyOneRowSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_MOVE_UP_TOOLTIP"),press:t.moveRowUp.bind(t)}),new d(a+"_control_table_navigationdown_btn",{icon:"sap-icon://navigation-down-arrow",enabled:"{= !!${/_hasOnlyOneRowSelected}}",tooltip:r.getText("EDITOR_FIELD_OBJECT_TABLE_BUTTON_MOVE_DOWN_TOOLTIP"),press:t.moveRowDown.bind(t)})])}return new i({content:u})};N.prototype.onUnSelectAll=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getBindingContext().getPath();var o=a.getModel();var n=o.getProperty(r);n.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false});o.setProperty("/_hasSelected",false);o.checkUpdate(true);t.setValue(undefined)};N.prototype.onEditOrViewDetail=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getSelectedIndices()[0];var o=a.getBinding("rows").getContexts();var n=o[r].getObject();var l=a.getFirstVisibleRow();var i=a.getRows()[r-l];var s=i.getCells()[0];t.openObjectDetailsPopover(n,s,!n._dt||n._dt._editable!==false?"update":"view")};N.prototype.onFilter=function(e){var t=this;var a=t.getAggregation("_field");a.detachEvent("rowsUpdated",t.updateTable,t);a.attachEventOnce("rowsUpdated",t.updateTable,t)};N.prototype.updateTable=function(e){var t=this;t.updateSelectionColumn();t.updateToolbar();t.fireTableUpdated()};N.prototype.updateSelectionColumn=function(){var e=this;var t=e.getAggregation("_field");var a=t.getBinding("rows").getContexts();var r=false;for(var o=0;o<a.length;o++){var n=a[o].getObject();if(n._dt&&n._dt._selected){r=true;break}}t.getModel().setProperty("/_hasSelected",r)};N.prototype.updateToolbar=function(){var e=this;var t=e.getAggregation("_field");var a=t.getColumns();var r=false;for(var o=0;o<a.length;o++){if(a[o].getFiltered()){r=true;break}}t.getModel().setProperty("/_hasFilter",r)};N.prototype.columnFactory=function(e,a){var r=a.getPath();var o=r.substring(a.getPath().lastIndexOf("/")+1);var n=a.getProperty("$Type");var l=a.getProperty("$MaxLength");var i="7rem";l=l?parseInt(l):10;l=l<7?7:l;if(l>50){i="15rem"}else if(l>9){i="10rem"}return new _(e,{visible:true,filterProperty:n&&n.indexOf("String")>=0?o:null,width:i,label:new g({text:o}),hAlign:n&&n.indexOf("Decimal")>=0?"End":"Begin",template:new t({text:{path:o},wrapping:false})})};N.prototype.onTableSelectionChange=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=a.getSelectedIndices();if(o.length>0){r.setProperty("/_hasTableSelected",true);if(o.length===1){r.setProperty("/_hasOnlyOneRowSelected",true)}else{r.setProperty("/_hasOnlyOneRowSelected",false)}}else{r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.setProperty("/_canDelete",false);return}if(o.length===a.getBinding("rows").getContexts().length){r.setProperty("/_hasTableAllSelected",true)}else{r.setProperty("/_hasTableAllSelected",false)}var n=[];var l=a.getBinding("rows").getContexts();o.forEach(function(e){var t=l[e].getObject();if(t._dt&&t._dt._editable!==false){var a=l[e].getPath();n.push(a)}});if(n.length===0){r.setProperty("/_canDelete",false)}else{r.setProperty("/_canDelete",true)}};N.prototype.selectAllTableSelections=function(e){var t=this;var a=t.getAggregation("_field");a.selectAll();a.getModel().setProperty("/_hasTableAllSelected",true)};N.prototype.clearAllTableSelections=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();a.clearSelection();r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.setProperty("/_canDelete",false);r.setProperty("/_hasTableAllSelected",false)};N.prototype.moveRowUp=function(e){this.moveSelectedRow("Up")};N.prototype.moveRowDown=function(e){this.moveSelectedRow("Down")};N.prototype.moveSelectedRow=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=a.getSelectedIndices()[0];var n=a.getContextByIndex(o);var l=o+(e==="Up"?-1:1);var i=a.getContextByIndex(l);if(!i){return}var s=i.getProperty("_dt/_position");var d=n.getProperty("_dt/_position");r.setProperty("_dt/_position",s,n);r.setProperty("_dt/_position",d,i);r.refresh(true);a.setSelectedIndex(l);t.refreshValue();t.updateTable()};N.prototype.onSelectionChange=function(e){var t=this;var a=e.getSource();var r=e.getParameter("selected");var o=t.getAggregation("_field");var n=o.getBindingContext().getPath();var l=o.getModel();if(r){var i=l.getProperty(n);i.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false});var s=a.getBindingContext().getObject();s._dt._selected=true;var d=m(s);l.setProperty("/_hasSelected",true);t.setValue(d)}else{l.setProperty("/_hasSelected",false);t.setValue(undefined)}};N.prototype.addNewObject=function(e){var t=this;var a=e.getSource();t._newObjectTemplate._dt._uuid=w.generateUuidV4();if(t.getAllowPopover()){t.openObjectDetailsPopover(t._newObjectTemplate,a,"add")}else{t.onAddDirectly(t._newObjectTemplate)}};N.prototype.mergeValueWithRequestResult=function(e){var t=this;var a=t.getConfiguration();var r=t.getAggregation("_field");var o=r.getModel();var n=r.getBinding("rows").getPath();if(a.value&&typeof a.value==="object"&&!T(a.value,{})){var l=m(a.value,500);if(Array.isArray(e)&&e.length>0){if(l._dt&&l._dt._editable===false){var i=l._dt._uuid||w.generateUuidV4();delete l._dt._uuid;e.forEach(function(e){if(T(e,l)){e._dt._selected=true;e._dt._uuid=i}else{e._dt._uuid=w.generateUuidV4()}})}else{e.forEach(function(e){e._dt._uuid=w.generateUuidV4()});l._dt=l._dt||{};l._dt._selected=true;l._dt._uuid=l._dt._uuid||w.generateUuidV4();e.unshift(l)}}else{l._dt=l._dt||{};l._dt._selected=true;l._dt._uuid=l._dt._uuid||w.generateUuidV4();e=[l]}o.setProperty("/_hasSelected",true);o.setProperty(n,e)}else{if(Array.isArray(e)&&e.length>0){e.forEach(function(e){e._dt._uuid=w.generateUuidV4()})}else{o.setProperty(n,{})}o.setProperty("/_hasSelected",false)}o.checkUpdate();t.updateTable()};N.prototype.onChangeOfTextArea=function(e){var t=this;var a=t.getResourceBundle();var r=e.getSource();var o=r.getValue();if(!o||o===""){t.saveValue(undefined,r)}else{try{var n=JSON.parse(o);if(n instanceof Array){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_SINGLE_JSONOBJECT"));return}t.saveValue(n,r)}catch(e){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};N.prototype.onChangeOfTextAreaInPopover=function(e){var t=this;var a=t.getResourceBundle();var r=e.getSource();var o=r.getValue();if(!o||o===""){t.saveValue(undefined,r,true)}else{try{var n=JSON.parse(o);if(n instanceof Array){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_SINGLE_JSONOBJECT"));return}t.saveValue(n,r,true)}catch(e){r.setValueState("Error");r.setValueStateText(a.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};N.prototype.createFormContents=function(e,t,r,o){var n=this;var l=n.getConfiguration();var i=n.createPropertyContents(e,t,r,o);i.push(new g({visible:false}).addStyleClass("sapFormLabel"));var s=r?n.getParameterId()+"_control_objectdetails_popover_form_textarea":n.getParameterId()+"_control_form_textarea";i.push(new a(s,{value:{path:t,formatter:function(e){if(!e||e===""){return undefined}if(T(e,{})&&!r&&!n._getCurrentProperty("value")){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},editable:l.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",width:"100%",placeholder:"{config/placeholder}",visible:"{= ${/editMode} === 'Json'}",change:r===true?this.onChangeOfTextAreaInPopover.bind(n):this.onChangeOfTextArea.bind(n),rows:r===true?11:7}));return i};N.prototype.createPropertyContents=function(e,t,o,n){var l=this;var i=l.getParameterId();var s=o?i+"_control_objectdetails_popover_form_property_":i+"_control_form_property_";var d=l.getConfiguration();var p=[];if(!t){t="currentSettings>value/"}var _={};if(d.values&&d.values.metadata){var c=l.getModel("meta");var v="/"+d.values.metadata.namespace+"."+d.values.metadata.entityTypeName;var f=c.getProperty(v);for(var b in f){var O=f[b];var P=O["$Type"];if(O["$kind"]==="Property"&&P){if(P.indexOf("Int")>=0){_[b]={type:"int"}}else if(P.indexOf("Boolean")>=0){_[b]={type:"boolean"}}else if(P.indexOf("Decimal")>=0){_[b]={type:"number"}}else{_[b]={type:"string"}}}}}if(T(_,{})){_=d.properties}for(var E in _){var I=_[E];var D=I.label||E;if(D.match(U)){var w=D.substring(2,D.length-2);D="{i18n>"+w+"}"}var C=s+E+"_label";var A=s+E+"_control";var M=new g(C,{text:D,visible:"{= ${/editMode} === 'Properties'}",required:I.required||false}).addStyleClass("propertyLabel");p.push(M);var j;I.values=I.values||I.cell&&I.cell.values;if(I.type==="string"&&I.values){I.type="ComboBox"}var N=m(I,500);delete N.type;delete N.label;delete N.translatable;delete N.defaultValue;delete N.formatter;delete N.column;delete N.cell;delete N.values;var F;if(I.type){I.type=I.type.toLowerCase()}switch(I.type){case"boolean":if(I.cell&&I.cell.type==="Switch"){F={state:"{"+t+E+"}",visible:"{= ${/editMode} === 'Properties'}",enabled:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:e};if(I.cell.customTextOn){F.customTextOn=I.cell.customTextOn}if(I.cell.customTextOff){F.customTextOff=I.cell.customTextOff}F=S(F,N);j=new h(A,F)}else{F={selected:"{"+t+E+"}",visible:"{= ${/editMode} === 'Properties'}",enabled:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",select:e};F=S(F,N);j=new y(A,F)}break;case"int":case"integer":F={value:{path:t+E,type:new V(I.formatter)},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",type:"Number",change:e};F=S(F,N);j=new r(A,F);break;case"number":F={value:{path:t+E,type:new B(I.formatter)},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",type:"Number",change:e};F=S(F,N);j=new r(A,F);break;case"combobox":var k=this.addModelPrefix(I.values.item,"settings");F={width:"100%",selectedKey:"{"+t+E+"}",visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",items:{path:"settings>"+I.values.data.path,template:new x(k),templateShareable:false},change:e};F=S(F,N);j=new L(A,F);var J=new u(I.values.data.json);j.setModel(J,"settings");break;case"object":F={value:{path:t+E,formatter:function(e){if(!e||e===""){return undefined}e=JSON.stringify(e,null,"\t");if(typeof e==="object"&&!e.length){e=e.replace(/\"\$\$([a-zA-Z]*)\$\$\"/g,function(e){return e.substring(3,e.length-3)})}return e}},visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:function(t){var a=t.getSource();var r=t.getParameter("value");var o=a.getModel();if(!r||r===""){o.setProperty(a.getBindingPath("value"),undefined);o.checkUpdate(true);a.setValueState("None");a.setValueStateText("");e(t)}else{try{var n=JSON.parse(r);o.setProperty(a.getBindingPath("value"),n);o.checkUpdate(true);a.setValueState("None");a.setValueStateText("");e(t)}catch(e){var i=l.getResourceBundle();a.setValueState("Error");a.setValueStateText(i.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}},rows:3};F=S(F,N);j=new a(A,F);break;case"icon":var $=new u({uuidPath:t+"_dt/_uuid",property:E});F={value:"{"+t+E+"}",allowNone:!I.required&&I.allowNone!==false,allowFile:I.allowFile!==false,visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:e};j=new R(A,F);j.setModel($,"settings");break;default:var H=new u({translatable:I.translatable||false,uuidPath:t+"_dt/_uuid",property:E});F={value:"{"+t+E+"}",visible:"{= ${/editMode} === 'Properties'}",editable:d.editable===false?false:"{= ${"+t+"_dt/_editable} !== false}",change:function(t){var a=t.getSource();var r=t.getParameter("value");if(r&&r.match(U)){var o=r.substring(2,r.length-2);r="{i18n>"+o+"}";a.setValue(r);a.fireChange()}else if(e){e(t)}}};F=S(F,N);if(n){F.valueHelpIconSrc="sap-icon://translate";F.valueHelpRequest=n.bind(l,E);if(I.translatable){F.showValueHelp=true}else{F.showValueHelp={path:t+E,formatter:function(e){var t=this.getModel("settings").getData();var a=this.getModel().getProperty(t.uuidPath);var r="translatable";if(l.getTranslationKey(e)){if(!this.getShowValueHelp()&&l.getObjectPropertyConfigValueInDesigntime(a,t.property,r)===false){l.setObjectPropertyConfigValueInDesigntime(a,t.property,r,true)}return true}if(this.getShowValueHelp()){l.deleteTranslationValueInTexts(undefined,a,t.property);l.setObjectPropertyConfigValueInDesigntime(a,t.property,r,false);l._oUpdatedTranslations={}}return false}}}}j=new r(A,F);j.setModel(H,"settings")}p.push(j)}return p};N.prototype.saveValue=function(e,t,a){var r=this;var o;if(!a){r.setValue(e);o=r.getAggregation("_field").getModel();if(o){e=m(e,500);o.setProperty("/value",e||{})}t.setValueState("None");t.setValueStateText("");if(r.getConfiguration()._propertiesParsedFromValue){r.refreshSimpleForm()}}else{o=t.getModel();o.setProperty("/value",e);t.setValueState("None");t.setValueStateText("")}};N.prototype.refreshSimpleForm=function(){var e=this;var t=e.getConfiguration();var a=e.getAggregation("_field");var r=a.removeAllContent();for(var o=0;o<r.length-2;o++){r[o].destroy()}r=r.slice(-2);delete t.properties;e.parseValueProperties();var n=function(){var t=a.getModel();t.checkUpdate(true);var r=t.getProperty("/value");r=m(r,500);e.setValue(r)};var l=e.createPropertyContents(n,"/value/");l=l.concat(r);l.forEach(function(e){a.addContent(e)})};N.prototype.getOriginTranslatedValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();for(var r in a){var o=a[r];var n="";var l="";if(e&&o){var i=o.resourceBundle&&o.resourceBundle.getText(e);n=i;l=i}else{n="";l=""}var s={key:r,description:o.language,value:n,originValue:l,editable:true};t.push(s)}return t};N.prototype.buildPropertyTranslationValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();for(var r in a){t.push({key:r,description:a[r].language,value:e,originValue:e,editable:true})}return t};N.prototype.openObjectDetailsPopover=function(e,t,a){var r=this;var p=r.getParameterId();var _=r.getResourceBundle();var c=m(e,500);var g;var v="Right";if(a==="add"){v=this.getPopoverPlacement(t)}if(!r._oObjectDetailsPopover){var f=new d(p+"_control_objectdetails_popover_add_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_ADD"),visible:a==="add",enabled:{path:"/value",formatter:function(e){if(typeof e!=="object"||T(e,{})){return false}else{var t=m(e);delete t._dt;if(T(t,{})){return false}}return true}},press:r.onAdd.bind(r)});var b=new d(p+"_control_objectdetails_popover_update_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_UPDATE"),visible:a==="update",enabled:{path:"/value",formatter:function(e){if(!e||e===""||T(e,{})){return false}return true}},press:r.onUpdate.bind(r)});var h=new d(p+"_control_objectdetails_popover_cancel_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CANCEL"),visible:a!=="view",press:function(){if(a==="add"){var e=r._oObjectDetailsPopover.getModel().getProperty("/value");r.deleteTranslationValueInTexts(undefined,e._dt._uuid)}r._oObjectDetailsPopover.close()}});var y=new d(p+"_control_objectdetails_popover_close_btn",{text:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_CLOSE"),visible:a==="view",press:function(){r._oObjectDetailsPopover.close()}});var O=new d(p+"_control_objectdetails_popover_editmode_btn",{icon:{path:"/editMode",formatter:function(e){if(e==="Properties"){return"sap-icon://syntax"}else{return"sap-icon://form"}}},tooltip:{path:"/editMode",formatter:function(e){if(e==="Properties"){return _.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_JSON")}else{return _.getText("EDITOR_FIELD_OBJECT_FORM_EDITMODE_PROPERTIES")}}},press:function(e){var t=e.getSource();var a=t.getModel();var r=a.getProperty("/editMode");if(r==="Properties"){a.setProperty("/editMode","Json")}else{a.setProperty("/editMode","Properties")}}});var P;r._oNavContainer=new o;r._oObjectDetailsPage=new n({title:_.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_TITLE"),headerContent:O,footer:new i({content:[new s,f,b,h,y]})});var E=function(e){r._oNavContainer.back();r._oObjectDetailsPage.focus()};var S=r.buildTranslationsList(p+"_control_objectdetails_popover_translation_page_value_list");var D=r.buildTranslationsFooter(S,false);r._oTranslationListPage=new n({title:_.getText("EDITOR_FIELD_OBJECT_TRANSLATION_LIST_TITLE",["{languages>/property}"]),showNavButton:true,navButtonPress:E,content:S,footer:D});var w=function(e){var t=r._oObjectDetailsPopover.getModel();t.checkUpdate(true);var a=t.getProperty("/value");if(a&&a!==""&&typeof a==="object"&&!T(a,{})){f.setEnabled(true)}else{f.setEnabled(false)}};var C=function(){};if(e._dt&&e._dt._editable===false){P=r.createFormContents(C,"/value/",true,r.navToTranslationPage)}else{P=r.createFormContents(w,"/value/",true,r.navToTranslationPage)}var L=new I({layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:12,emptySpanXL:1,emptySpanL:1,emptySpanM:1,emptySpanS:0,columnsXL:1,columnsL:1,columnsM:1,content:P});r._oObjectDetailsPage.addContent(L);r._oNavContainer.addPage(r._oObjectDetailsPage);r._oNavContainer.addPage(r._oTranslationListPage);r._oObjectDetailsPopover=new l(p+"_control_objectdetails_popover",{placement:v,showHeader:false,contentWidth:"300px",contentHeight:"345px",modal:true,content:r._oNavContainer}).addStyleClass("sapUiIntegrationEditorItemObjectFieldDetailsPopover");g=new u({value:c,editMode:"Properties"});r._oObjectDetailsPopover.setModel(g);r._oObjectDetailsPopover.setModel(r.getModel("i18n"),"i18n");r._oObjectDetailsPopover._oAddButton=f;r._oObjectDetailsPopover._oUpdateButton=b;r._oObjectDetailsPopover._oCancelButton=h;r._oObjectDetailsPopover._oCloseButton=y;r._oObjectDetailsPopover._openBy=t}else{g=r._oObjectDetailsPopover.getModel();g.setProperty("/value",c);g.checkUpdate(true);if(a==="add"){r._oObjectDetailsPopover._oAddButton.setVisible(true);r._oObjectDetailsPopover._oUpdateButton.setVisible(false);r._oObjectDetailsPopover._oCancelButton.setVisible(true);r._oObjectDetailsPopover._oCloseButton.setVisible(false)}else if(a==="update"){r._oObjectDetailsPopover._oAddButton.setVisible(false);r._oObjectDetailsPopover._oUpdateButton.setVisible(true);r._oObjectDetailsPopover._oCancelButton.setVisible(true);r._oObjectDetailsPopover._oCloseButton.setVisible(false)}else{r._oObjectDetailsPopover._oAddButton.setVisible(false);r._oObjectDetailsPopover._oUpdateButton.setVisible(false);r._oObjectDetailsPopover._oCancelButton.setVisible(false);r._oObjectDetailsPopover._oCloseButton.setVisible(true)}r._oObjectDetailsPopover._openBy=t;r._oObjectDetailsPopover.setPlacement(v);r._oNavContainer.back()}r._oObjectDetailsPopover.openBy(t)};N.prototype.buildTranslationsData=function(e,t,a,r){var o=this;var n=o.getResourceBundle();o._oOriginTranslatedValues=o._oOriginTranslatedValues||{};o._oUpdatedTranslations=o._oUpdatedTranslations||{};var l=a+"_"+r;var i=e;if(t==="key"){if(!o._oOriginTranslatedValues[e]){o._oOriginTranslatedValues[e]=o.getOriginTranslatedValues(e)}}else if(t==="property"){i=l;o._oOriginTranslatedValues[i]=o.buildPropertyTranslationValues(e)}var s=[];o._oOriginTranslatedValues[i].forEach(function(e){var t=m(e,500);t.updated=false;var l=o.getTranslationValueInTexts(t.key,a,r);if(l){t.value=l;if(Array.isArray(o._oUpdatedTranslations[i])){if(o._oUpdatedTranslations[i].includes(t.key)){t.value=o.getTranslationValueInTexts(t.key,a,r);t.updated=true}else{t.originValue=t.value}}}if(t.key===w._language){t.description+=" ("+n.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")+")";s.unshift(t)}else{s.push(t)}});var d={isUpdated:false,key:e,translationKey:i,translationType:t,uuid:a,property:r,translatedLanguages:s};return d};N.prototype.getTranslationKey=function(e){var t;if(e&&e.match(U)){t=e.substring(2,e.length-2)}else if(e&&e.startsWith("{i18n>")&&e.endsWith("}")){t=e.substring(6,e.length-1)}return t};N.prototype.buildTranslationsFooter=function(e,t){var a=this;var r=a.getParameterId();var o=a.getResourceBundle();var n=t?r+"_control_translation_popover":r+"_control_objectdetails_popover_translation_page";var l=new d(n+"_save_btn",{type:"Emphasized",text:o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var r=e.getModel("languages");var o=r.getData();var n=[];var l=o.key;var i=o.translationKey;var s=o.translationType;var d=o.uuid;var u=o.property;o.translatedLanguages.forEach(function(e){if(e.value!==e.originValue){if(e.updated){a.setTranslationValueInTexts(e.key,d,u,e.value);n.push(e.key)}}else if(e.updated){a.deleteTranslationValueInTexts(e.key,d,u)}});var p=false;if(n.length>0){a._oUpdatedTranslations=a._oUpdatedTranslations||{};a._oUpdatedTranslations[i]=n;if(n.includes(w._language)){p=true}}else if(a._oUpdatedTranslations){delete a._oUpdatedTranslations[i]}o=a.buildTranslationsData(l,s,d,u);r.setData(o);r.checkUpdate(true);if(a.getModel()){a.getModel().checkUpdate(true)}if(p&&a._oValueBinding){a._oValueBinding.fireEvent("change")}if(t){a._oTranslationPopover.close()}}});var u=new d(n+"_reset_btn",{text:o.getText("EDITOR_FIELD_OBJECT_DETAILS_POPOVER_BUTTON_RESET"),enabled:"{languages>/isUpdated}",press:function(t){var a=e.getModel("languages");var r=a.getData();r.translatedLanguages.forEach(function(e){e.value=e.originValue;e.updated=false});r.isUpdated=false;a.setData(r);a.checkUpdate(true)}});var p=new d(n+"_cancel_btn",{text:o.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),visible:t,press:function(){a._oTranslationPopover.close()}});return new i({content:[new s,l,u,p]})};N.prototype.openTranslationPopup=function(e,t){var a=this;if(!a._oEditorResourceBundles.isReady()){setTimeout(function(){a.openTranslationPopup(e,t)},100);return}var r=t.getSource();var o=a.getResourceBundle();var n=r.getModel().getProperty("/value");if(!n._dt){n._dt={_uuid:w.generateUuidV4()}}else if(!n._dt._uuid){n._dt._uuid=w.generateUuidV4()}var i=r.getValue();var s=a.getTranslationKey(i);var d="property";if(s&&s!==""){d="key"}else{s=i}var u=a.buildTranslationsData(s,d,n._dt._uuid,e);var p;var _=this.getPopoverPlacement(r._oValueHelpIcon);if(!a._oTranslationPopover){var c=a.getParameterId();var g=a.buildTranslationsList(c+"_control_translation_popover_value_list");var v=a.buildTranslationsFooter(g,true);a._oTranslationPopover=new l(c+"_control_translation_popover",{placement:_,contentWidth:"300px",contentHeight:"345px",title:o.getText("EDITOR_FIELD_OBJECT_TRANSLATION_LIST_TITLE",["{languages>/property}"]),content:g,afterOpen:function(){a.fireTranslationPopoverOpened()},footer:v}).addStyleClass("sapUiIntegrationFieldTranslation");p=a.buildTranslationsModel(u);a._oTranslationPopover.setModel(p,"languages")}else{a._oTranslationPopover.setPlacement(_);p=a._oTranslationPopover.getModel("languages");p.setData(u);p.checkUpdate(true)}a._oTranslationPopover.openBy(r._oValueHelpIcon)};N.prototype.navToTranslationPage=function(e,t){var a=this;if(!a._oEditorResourceBundles.isReady()){setTimeout(function(){a.navToTranslationPage(e,t)},100);return}var r=a._oObjectDetailsPopover.getModel().getProperty("/value");var o=r[e];var n=a.getTranslationKey(o);var l="property";if(n&&n!==""){l="key"}else{n=o}var i=a.buildTranslationsData(n,l,r._dt._uuid,e);var s=a._oTranslationListPage.getModel("languages");if(!s){s=a.buildTranslationsModel(i);a._oTranslationListPage.setModel(s,"languages")}else{s.setData(i)}a._oNavContainer.to(a._oTranslationListPage);a._oTranslationListPage.focus()};N.prototype.onAdd=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getModel();var o=t._oObjectDetailsPopover.getModel().getProperty("/value");var n=a.getBinding("rows").getPath();var l=r.getProperty(n);l.forEach(function(e){if(e._dt._selected){e._dt._selected=false}});l.push(o);r.setProperty("/_hasSelected",true);r.setProperty("/_hasTableAllSelected",false);r.setProperty("/_hasTableSelected",false);r.setProperty("/_hasOnlyOneRowSelected",false);r.checkUpdate();t.refreshValue();t.updateTable();t._oObjectDetailsPopover.close()};N.prototype.onAddDirectly=function(e){var t=this;var a=m(e,500);var r=t.getAggregation("_field");var o=r.getModel();var n=r.getBinding("rows").getPath();var l=o.getProperty(n);var i=1;l.unshift(a);l.forEach(function(e){e._dt=e._dt||{};e._dt._selected=false;e._dt._position=i;i++});o.checkUpdate();t.refreshValue();t.updateTable()};N.prototype.onUpdate=function(e){var t=this;var a=t.getAggregation("_field");var r=t._oObjectDetailsPopover.getModel().getProperty("/value");var o=a.getModel();var n=t._oObjectDetailsPopover._openBy.getParent();var l=n.getIndex();var i=a.getBinding("rows").getContexts();var s=i[l].getPath();o.setProperty(s,m(r,500));o.checkUpdate();if(r._dt&&r._dt._selected){t.refreshValue()}t.updateTable();t._oObjectDetailsPopover.close()};N.prototype.onDelete=function(e){var t=this;var a=t.getAggregation("_field");var r=t.getResourceBundle();var o=a.getSelectedIndices();var n=[];var l=a.getBinding("rows").getContexts();o.forEach(function(e){var t=l[e].getObject();if(t._dt&&t._dt._editable!==false){var a=l[e].getPath();var r=a.substring(a.lastIndexOf("/")+1);n.push(r)}});if(n.length===0){O.error(r.getText("EDITOR_FIELD_OBJECT_DELETE_ERROR_MSG"));return}if(t.getAllowPopover()){O.confirm(r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_MSG"),{title:r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_TITLE"),onClose:function(e){if(e===O.Action.OK){var o=a.getBindingContext().getPath();var l=a.getModel();var i=l.getProperty(o);var s=[];for(var d=0;d<i.length;d++){if(n.includes(d+"")){t.deleteTranslationValueInTexts(undefined,i[d]._dt._uuid)}else{s.push(i[d])}}l.setProperty(o,s);l.checkUpdate(true);t.refreshValue();t.updateTable()}else{P.show(r.getText("EDITOR_FIELD_OBJECT_DELETE_CONFIRM_CANCLE"))}}})}else{var i=a.getBinding("rows").getPath();var s=a.getModel();var d=s.getProperty(i);var u=[];for(var p=0;p<d.length;p++){if(n.includes(p+"")){t.deleteTranslationValueInTexts(undefined,d[p]._dt._uuid)}else{u.push(d[p])}}s.setProperty(i,u);s.checkUpdate(true);t.refreshValue();t.updateTable()}};N.prototype.refreshValue=function(){var e=this;var t=e.getAggregation("_field");var a=t.getModel();var r=t.getBinding("rows").getPath();var o=a.getProperty(r);var n;for(var l=0;l<o.length;l++){var i=o[l];if(i._dt._selected){n=m(i);break}}e.setValue(n)};N.prototype.resetControl=function(){var e=this;var t=e.getAggregation("_field");var a=e._getCurrentProperty("value");var r=t.getModel();if(t instanceof I){var o=r.getProperty("/value");if(o&&o._dt&&o._dt._uuid){e.deleteTranslationValueInTexts(undefined,o._dt._uuid)}a=a||{};r.setProperty("/value",a);r.checkUpdate(true)}else if(t instanceof p){var n=e.getConfiguration();var l;if(n.values){var i=t.getBinding("rows").getPath();l=r.getProperty(i);l.forEach(function(e){delete e._dt._selected})}e.mergeValueWithRequestResult(l)}};N.prototype.clearAllFilters=function(e){var t=this;var a=t.getAggregation("_field");var r=a.getColumns();for(var o=0;o<r.length;o++){var n=r[o];if(o<r.length-1){n._applySelection=false}a.filter(n,undefined)}};N.prototype.setValue=function(e){var t=this;t.cleanDT(e);t._setCurrentProperty("value",e)};N.prototype.cleanDT=function(e){if(e&&e._dt&&e._dt._selected){delete e._dt._selected}if(e&&e._dt&&T(e._dt,{})){delete e._dt}};N.prototype.getTranslationValueInTexts=function(e,t,a){var r=this;var o=r.getConfiguration();var n="/texts/"+e;var l=this._settingsModel.getProperty(n)||{};var i=l[o.manifestpath];var s;if(i&&i[t]){s=i[t][a]}return s};N.prototype.setObjectPropertyConfigValueInDesigntime=function(e,t,a,r){var o=this;var n=o.getConfiguration();var l="/:designtime";var i=this._settingsModel.getData();if(!i){return}var s;if(!i.hasOwnProperty(":designtime")){s={}}else{s=m(i[":designtime"],500)}if(!s.hasOwnProperty(n.manifestpath)){s[n.manifestpath]={}}if(!s[n.manifestpath].hasOwnProperty(e)){s[n.manifestpath][e]={}}if(!s[n.manifestpath][e].hasOwnProperty(t)){s[n.manifestpath][e][t]={}}s[n.manifestpath][e][t][a]=r;this._settingsModel.setProperty(l,s)};N.prototype.getObjectPropertyConfigValueInDesigntime=function(e,t,a){var r=this;var o;var n=r.getConfiguration();var l=this._settingsModel.getData();if(l&&l[":designtime"]&&l[":designtime"][n.manifestpath]&&l[":designtime"][n.manifestpath][e]&&l[":designtime"][n.manifestpath][e][t]&&l[":designtime"][n.manifestpath][e][t].hasOwnProperty(a)){o=l[":designtime"][n.manifestpath][e][t][a]}return o};N.prototype.setTranslationValueInTexts=function(e,t,a,r){var o=this;var n=o.getConfiguration();var l="/texts";var i=this._settingsModel.getData();if(!i){return}var s;if(!i.hasOwnProperty("texts")){s={}}else{s=m(i.texts,500)}if(!s.hasOwnProperty(e)){s[e]={}}if(!s[e].hasOwnProperty(n.manifestpath)){s[e][n.manifestpath]={}}if(!s[e][n.manifestpath].hasOwnProperty(t)){s[e][n.manifestpath][t]={}}s[e][n.manifestpath][t][a]=r;this._settingsModel.setProperty(l,s)};N.prototype.deleteTranslationValueInTexts=function(e,t,a){var r=this;var o=r._settingsModel.getData();if(!o||!o.texts||!t){return}var n=r.getConfiguration();var l="/texts";var i=m(o.texts,500);if(e){if(i[e]&&i[e][n.manifestpath]&&i[e][n.manifestpath][t]){if(a){if(i[e][n.manifestpath][t].hasOwnProperty(a)){delete i[e][n.manifestpath][t][a];if(T(i[e][n.manifestpath][t],{})){delete i[e][n.manifestpath][t]}this._settingsModel.setProperty(l,i)}}else{delete i[e][n.manifestpath][t];if(T(i[e][n.manifestpath],{})){delete i[e][n.manifestpath];if(T(i[e],{})){delete i[e]}}this._settingsModel.setProperty(l,i)}}}else{for(var s in i){r.deleteTranslationValueInTexts(s,t,a)}}};return N});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/ObjectListField", ["sap/ui/integration/editor/fields/ObjectField","sap/ui/model/json/JSONModel","sap/ui/table/Table","sap/m/CheckBox","sap/base/util/deepEqual","sap/base/util/deepClone","sap/ui/integration/util/Utils","sap/m/table/columnmenu/Menu"],function(e,t,r,a,i,o,n,l){"use strict";var s=e.extend("sap.ui.integration.editor.fields.ObjectListField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});s.prototype.initVisualization=function(e){var t=this;t._positionCount=1;t._newObjectTemplate={_dt:{_selected:true,_uuid:""}};var r=e.visualization;if(!r){if(e.value&&!e.properties&&(!e.values||e.values&&!e.values.metadata)){t.parseValueProperties()}if(e.values||e.properties){r=t.createTableVisualization(e)}else{r=t.createTextAreaVisualization(e)}e.withLabel=true}this._visualization=r;this.attachAfterInit(this._afterInit)};s.prototype._afterInit=function(){var e=this;var a=e.getAggregation("_field");if(a instanceof r){a.addStyleClass("sapUiIntegrationEditorItemObjectListFieldTable");e._oMenu=new l;var i=a.getColumns();for(var s=0;s<i.length;s++){if(i[s].getFilterProperty()||i[s].getSortProperty()){i[s].setHeaderMenu(e._oMenu.getId())}}var u=e.getConfiguration();if(!u.values){var d=[];if(Array.isArray(u.value)){d=o(u.value,500);d.forEach(function(t){t._dt=t._dt||{};t._dt._selected=true;t._dt._uuid=t._dt._uuid||n.generateUuidV4();t._dt._position=e._positionCount;e._positionCount++})}e.setModel(new t({value:d,_allSelected:true}));e.bindObject({path:"/value"})}}};s.prototype.parseValueProperties=function(){var e=this;var t=e.getConfiguration();if(Array.isArray(t.value)&&t.value.length>0&&!t.properties){var r={};t.value.forEach(function(e){for(var t in e){if(!r[t]&&t!=="_dt"){var a=typeof e[t];var i=a==="string"?{}:{type:a};r[t]=i}}});if(!i(r,{})){t.properties=r;t._propertiesParsedFromValue=true}}};s.prototype.buildSelectionColumnLabels=function(){var e=this;var t=e.getConfiguration();var r=e.getResourceBundle();return new a(e.getParameterId()+"_control_table_column_selection_label_all_checkbox",{selected:"{/_allSelected}",visible:typeof t.values!=="undefined",tooltip:{path:"/_allSelected",formatter:function(e){if(!e){return r.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_TOOLTIP_ADDALL")}else{return r.getText("EDITOR_FIELD_OBJECT_LIST_TABLE_COLUMN_SELECTION_TOOLTIP_REMOVEALL")}}},select:e.onSelectionColumnClick.bind(e)})};s.prototype.onSelectionColumnClick=function(e){var t=this;var r=e.getParameter("selected");var a=t.getAggregation("_field");var i=a.getBinding("rows").getContexts();i.forEach(function(e){var t=e.getObject();t._dt=t._dt||{};t._dt._selected=r});var n=a.getModel();var l=a.getBinding("rows").getPath();var s=n.getProperty(l);var u;s.forEach(function(e){if(e._dt&&e._dt._selected){var t=o(e,500);u=u||[];u.push(t)}});n.checkUpdate(true);t.setValue(u)};s.prototype.updateSelectionColumn=function(){var e=this;var t=e.getAggregation("_field");var r=t.getBinding("rows").getContexts();var a=true;if(r.length===0){a=false}else{for(var i=0;i<r.length;i++){var o=r[i].getObject();if(!o._dt||o._dt._selected!==true){a=false;break}}}t.getModel().setProperty("/_allSelected",a)};s.prototype.onAdd=function(e){var t=this;var r=t.getAggregation("_field");var a=t._oObjectDetailsPopover.getModel().getProperty("/value");a._dt._position=t._positionCount;var i=r.getBinding("rows").getPath();var o=r.getModel();var n=o.getProperty(i);n.push(a);o.setProperty("/_hasTableAllSelected",false);o.setProperty("/_hasTableSelected",false);o.checkUpdate();t.refreshValue();t._oObjectDetailsPopover.close();t._positionCount++;t.updateTable()};s.prototype.refreshValue=function(){var e=this;var t=e.getAggregation("_field");var r=t.getModel();var a=t.getBinding("rows").getPath();var i=r.getProperty(a);var n=[];i.forEach(function(e){if(e._dt._selected){var t=o(e);n.push(t)}});e.setValue(n)};s.prototype.onSelectionChange=function(e){var t=this;var r=e.getParameter("selected");var a=this._getCurrentProperty("value");var i=t.getAggregation("_field");var o=i.getModel();if(r||a.length>1){t.refreshValue();t.updateSelectionColumn()}else{o.setProperty("/_allSelected",false);t.setValue(undefined)}};s.prototype.mergeValueWithRequestResult=function(e){var t=this;var r=t.getConfiguration();var a=t.getAggregation("_field");var l=a.getModel();var s=a.getBinding("rows").getPath();if(Array.isArray(r.value)&&r.value.length>0){var u=o(r.value,500);if(Array.isArray(e)&&e.length>0){t._positionCount=r.value.length+1;var d=[];u.forEach(function(e){var t;if(!e._dt){t=n.generateUuidV4()}else{t=e._dt._uuid||n.generateUuidV4();delete e._dt._uuid;delete e._dt._position}d.push(t)});var _=[];for(var g=0;g<e.length;g++){var p=e[g];var f=false;for(var c=0;c<u.length;c++){if(i(p,u[c])){f=true;break}}if(!f){p._dt._uuid=n.generateUuidV4();p._dt._position=t._positionCount;t._positionCount++;_.push(p)}}for(var v=0;v<u.length;v++){var h=u[v];h._dt=h._dt||{};h._dt._selected=true;h._dt._uuid=d[v];h._dt._position=v+1}if(_.length>0){l.setProperty("/_allSelected",false);u=u.concat(_)}else{l.setProperty("/_allSelected",true)}}else{u.forEach(function(e){e._dt=e._dt||{};e._dt._selected=true;e._dt._uuid=e._dt._uuid||n.generateUuidV4();e._dt._position=t._positionCount;t._positionCount++});l.setProperty("/_allSelected",true)}l.setProperty(s,u)}else{if(Array.isArray(e)&&e.length>0){e.forEach(function(e){e._dt._uuid=n.generateUuidV4();e._dt._position=t._positionCount;t._positionCount++})}else{l.setProperty(s,[])}l.setProperty("/_allSelected",false)}l.checkUpdate();t.updateTable()};s.prototype.onChangeOfTextArea=function(e){var t=this;var r=t.getResourceBundle();var a=e.getSource();var i=a.getValue();if(!i||i===""){t.saveValue(undefined,a)}else{try{var o=JSON.parse(i);if(!(o instanceof Array)){a.setValueState("Error");a.setValueStateText(r.getText("EDITOR_VAL_NOT_AN_ARRAY_OF_JSONOBJECTS"));return}t.saveValue(o,a)}catch(e){a.setValueState("Error");a.setValueStateText(r.getText("EDITOR_VAL_NOT_A_JSONOBJECT"))}}};s.prototype.saveValue=function(e,t,r){var a=this;var i;if(!r){a.setValue(e)}else{i=t.getModel();i.setProperty("/value",e)}t.setValueState("None");t.setValueStateText("")};s.prototype.cleanDT=function(e){if(e){e.forEach(function(e){if(e&&e._dt&&e._dt._selected){delete e._dt._selected}if(e&&e._dt&&i(e._dt,{})){delete e._dt}})}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/StringField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/Text","sap/m/Title","sap/m/Select","sap/m/ComboBox","sap/m/Popover","sap/m/Button","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/ui/core/ListItem","sap/m/VBox","sap/base/util/each","sap/base/util/restricted/_debounce","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/integration/util/Utils"],function(e,t,a,n,s,i,r,l,o,u,g,d,p,c,v,h,f){"use strict";var _=/parameters\.([^\}\}]+)/g;var T=["TODAY_ISO","NOW_ISO","LOCALE"];var y=e.extend("sap.ui.integration.editor.fields.StringField",{metadata:{library:"sap.ui.integration",events:{translationPopoverOpened:{}}},renderer:e.getMetadata().getRenderer()});y.prototype.initVisualization=function(e){var n=e.visualization;var r;if(!n){var l=e.value?e.value.match(_):undefined;var o,u,d;if(l&&l.length>0){l=l.filter(function(e){var t=e.substring(11);return!T.includes(t)})}if(l&&l.length>0){o=l.map(function(e){if(this.isOrigLangField){return"items>"+e.substring(11)+"/_language/value"}return"items>"+e.substring(11)+"/value"}.bind(this));o.unshift("currentSettings>value");u={parts:o,formatter:function(e){var t=Array.prototype.slice.call(arguments,1);for(var a=0;a<t.length;a++){if(t[a]){e=e.replaceAll("{{"+l[a]+"}}",t[a])}}return e}};d=function(e){var t=e.getSource().getValue();var a=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(a+"/value",t);var n=this._settingsModel.getBindings();var s=a.substring(a.lastIndexOf("/")+1);p(n,function(e,t){if(t.sPath==="/form/items/"+s+"/value"){t.checkUpdate(true)}})}.bind(this)}if(this.getMode()==="translation"){if(e.editable){n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder}}}else{n={type:a,settings:{text:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},visible:e.visible,wrapping:false}}}}else if(e.enum){r=new g({key:{path:"currentSettings>"},text:{path:"currentSettings>"}});n={type:s,settings:{selectedKey:{path:"currentSettings>value"},forceSelection:false,editable:e.editable,visible:e.visible,showSecondaryValues:false,width:"100%",items:{path:"currentSettings>enum",template:r}}}}else if(e.values){r=this.formatListItem(e.values.item);if(!e.values.item.key){e.values.item.key=e.values.item.text}n={type:i,settings:{busy:{path:"currentSettings>_loading"},selectedKey:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:r}}};if(this.isFilterBackend()){n.settings.selectedKey={parts:["currentSettings>value","currentSettings>suggestValue"],formatter:function(e,t){if((!e||e==="")&&t){return t.replaceAll("''","'")}else{return e}}}}}else if(this.getMode()!=="translation"&&e.translatable){n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder,valueHelpIconSrc:"sap-icon://translate",showValueHelp:true,valueHelpRequest:this.openTranslationListPopup.bind(this),change:function(e){var t=e.getSource();var a=t.getValue();var n=f._language;t.getParent().setTranslationValueInTexts(n,a)}}};if(o){delete n.settings.tooltip;n.settings.value=u;n.settings.change=d;n.settings.showValueHelp=false;delete n.settings.valueHelpRequest}}else{n={type:t,settings:{value:{path:"currentSettings>value"},tooltip:{path:"currentSettings>value"},editable:e.editable,visible:e.visible,maxLength:e.maxLength,placeholder:e.placeholder}};if(o){delete n.settings.tooltip;n.settings.value=u;n.settings.change=d}}}else if(n.type==="TextArea"){n.type="sap/m/TextArea"}else if(n.type==="Select"&&e.values){r=this.formatListItem(e.values.item);var c=Object.assign({selectedKey:{path:"currentSettings>value"},forceSelection:false,editable:e.editable,visible:e.visible,showSecondaryValues:false,width:"100%",items:{path:"",template:r}},n.settings||{});n={type:s,settings:c}}this._visualization=n;this.attachAfterInit(this._afterInit)};y.prototype._afterInit=function(){var e=this.getAggregation("_field");if(e instanceof i){if(this.isFilterBackend()){this.onInput=c(this.onInput,500);e.oninput=this.onInput.bind(this);e.attachSelectionChange(this.onSelectionChange.bind(this))}}};y.prototype.onSelectionChange=function(e){var t=e.getParameter("selectedItem")||{};var a=t.getKey();var n=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(n+"/value",a)};y.prototype.onInput=function(e){var t=e.target.value;var a=this.getBindingContext("currentSettings").sPath;this._settingsModel.setProperty(a+"/suggestValue",t.replaceAll("'","''"));this._settingsModel.setProperty(a+"/_loading",true);this._settingsModel.setProperty(a+"/value","");var n=this._settingsModel.getBindings();var s=a.substring(a.lastIndexOf("/")+1);p(n,function(e,t){if(t.sPath==="/form/items/"+s+"/value"){t.checkUpdate(true)}});var i=e.srcControl;i.open();i.setValue(t);i.setSelection(null)};y.prototype.getOriginTranslatedValues=function(e){var t=[];var a=this._oEditorResourceBundles.getResourceBundles();var n;if(e._translatedDefaultPlaceholder&&e._translatedDefaultPlaceholder.startsWith("{i18n>")&&e._translatedDefaultPlaceholder.endsWith("}")){n=e._translatedDefaultPlaceholder.substring(6,e._translatedDefaultPlaceholder.length-1)}else if(e._translatedDefaultPlaceholder&&e._translatedDefaultPlaceholder.startsWith("{{")&&e._translatedDefaultPlaceholder.endsWith("}}")){n=e._translatedDefaultPlaceholder.substring(2,e._translatedDefaultPlaceholder.length-2)}for(var s in a){var i=a[s];var r="";var l="";if(n&&i){var o=i.resourceBundle&&i.resourceBundle.getText(n,[],true);if(o!==undefined){r=o;l=o}else{r=e._translatedValue||"";l=e._translatedValue||""}}else{r=e._translatedDefaultPlaceholder||"";l=e._translatedDefaultPlaceholder||""}var u={key:s,description:i.language,value:r,originValue:l,editable:true};t.push(u)}return t};y.prototype.getTranslationValueInTexts=function(e,t){var a="/texts/"+e;var n=this._settingsModel.getProperty(a)||{};return n[t]};y.prototype.setTranslationValueInTexts=function(e,t){var a=this.getConfiguration().manifestpath;var n="/texts";var s=this._settingsModel.getData();if(!s){return}if(!s.hasOwnProperty("texts")){var i={};i[e]={};i[e][a]=t;this._settingsModel.setProperty(n,i)}else{n="/texts/"+e;var r;if(!s.texts.hasOwnProperty(e)){r={}}else{r=s.texts[e]}r[a]=t;this._settingsModel.setProperty(n,r)}};y.prototype.deleteTranslationValueInTexts=function(e){var t=this.getConfiguration().manifestpath;var a=this._settingsModel.getData();if(a&&a.texts&&a.texts[e]){delete a.texts[e][t]}if(h(a.texts[e],{})){delete a.texts[e]}if(h(a.texts,{})){delete a.texts}this._settingsModel.setData(a)};y.prototype.openTranslationListPopup=function(e){var s=this;if(!s._oEditorResourceBundles.isReady()){setTimeout(function(){s.openTranslationListPopup(e)},100);return}var i=e.getSource();var g=s.getParameterId();var p=s.getResourceBundle();var c=s.buildTranslationsData(i);var v;var h=s.getPopoverPlacement(i._oValueHelpIcon);if(!s._oTranslationPopover){var f=s.buildTranslationsList(g+"_translation_popover_value_list");s._oTranslationPopover=new r(g+"_translation_popover",{placement:h,contentWidth:"300px",contentHeight:"345px",customHeader:new d({items:[new n({text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_TITLE")}).addStyleClass("sapMPopoverTitle"),new n({text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_CURRENTLANGUAGE")}).addStyleClass("sapMHeaderTitle"),new d({items:[new a(g+"_translation_popover_currentlanguage_description_label",{text:"{languages>/currentLanguage/description}"}),new t(g+"_translation_popover_currentlanguage_value_input",{value:"{languages>/currentLanguage/value}",editable:false})]}).addStyleClass("sapMCurrentLanguageVBox"),new n({text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_OTHERLANGUAGES")}).addStyleClass("sapMHeaderTitle")]}),content:f,afterOpen:function(){s.fireTranslationPopoverOpened()},footer:new o({content:[new u,new l(g+"_translation_popover_save_btn",{type:"Emphasized",text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_SAVE"),enabled:"{languages>/isUpdated}",press:function(){var e=s._oTranslationPopover.getModel("languages").getData();var t=[];e.translatedLanguages.forEach(function(e){if(e.value!==e.originValue){if(e.updated){s.setTranslationValueInTexts(e.key,e.value);t.push(e.key)}}else if(e.updated){s.deleteTranslationValueInTexts(e.key)}});if(t.length>0){s._aUpdatedLanguages=t}else{s._aUpdatedLanguages=undefined}s._oTranslationPopover.close()}}),new l(g+"_translation_popover_cancel_btn",{text:p.getText("EDITOR_FIELD_TRANSLATION_LIST_POPOVER_BUTTON_CANCEL"),press:function(){s._oTranslationPopover.close()}})]})}).addStyleClass("sapUiIntegrationFieldTranslation");v=s.buildTranslationsModel(c);s._oTranslationPopover.setModel(v,"languages")}else{s._oTranslationPopover.setPlacement(h);v=s._oTranslationPopover.getModel("languages");v.setData(c);v.checkUpdate(true)}s._oTranslationPopover.openBy(i._oValueHelpIcon)};y.prototype.buildTranslationsData=function(e){var t=this;var a=t.getConfiguration();if(!t._aOriginTranslatedValues){t._aOriginTranslatedValues=t.getOriginTranslatedValues(a)}var n=v(t._aOriginTranslatedValues,500);n.forEach(function(e){var n=t.getTranslationValueInTexts(e.key,a.manifestpath);if(n){e.value=n;if(Array.isArray(t._aUpdatedLanguages)&&!t._aUpdatedLanguages.includes(e.key)){e.originValue=e.value}}else if(a._beforeLayerChange){e.value=a._beforeLayerChange;if(Array.isArray(t._aUpdatedLanguages)&&!t._aUpdatedLanguages.includes(e.key)){e.originValue=e.value}}e.updated=false;if(e.key===f._language){e.editable=false}});var s={currentLanguage:{},isUpdated:false,translatedLanguages:[]};if(n){n.forEach(function(n){if(Array.isArray(t._aUpdatedLanguages)&&t._aUpdatedLanguages.includes(n.key)){n.value=t.getTranslationValueInTexts(n.key,a.manifestpath);n.updated=true}if(n.key===f._language){n.value=e.getValue();s.currentLanguage=n}else{s.translatedLanguages.push(n)}})}return s};return y});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/StringListField", ["sap/ui/integration/editor/fields/BaseField","sap/m/Input","sap/m/MultiComboBox","sap/m/MultiInput","sap/base/util/restricted/_debounce","sap/base/util/restricted/_isEqual","sap/base/util/ObjectPath","sap/base/util/merge","sap/ui/core/SeparatorItem","sap/ui/model/Sorter","sap/m/Token","sap/m/Tokenizer","sap/base/util/deepClone","sap/ui/model/json/JSONModel","sap/ui/integration/util/BindingResolver"],function(e,t,r,a,i,n,s,o,u,l,g,v,c,h,p){"use strict";var d=e.extend("sap.ui.integration.editor.fields.StringListField",{metadata:{library:"sap.ui.integration"},renderer:e.getMetadata().getRenderer()});d.prototype.initVisualization=function(e){var i=this,n;var s=e.visualization;if(!s){if(e.values){n=this.formatListItem(e.values.item);s={type:r,settings:{selectedKeys:{path:"currentSettings>value"},busy:{path:"currentSettings>_loading"},editable:e.editable,visible:e.visible,showSecondaryValues:true,width:"100%",items:{path:"",template:n,sorter:[new l({path:"Selected",descending:false,group:true})],groupHeaderFactory:i.getGroupHeader}}};if(this.isFilterBackend()){s.settings.selectedKeys={parts:["currentSettings>value","currentSettings>suggestValue"],formatter:function(e,t){if(t){i.setSuggestValue()}return e}}}}else{s={type:t,settings:{value:{path:"currentSettings>value",formatter:function(e){e=e||[];return e.join(",")}},change:function(e){var t=e.getSource();t.getBinding("value").setRawValue(t.getValue().split(","))},editable:e.editable,visible:e.visible,placeholder:e.placeholder}}}}else if(e.values&&this.isFilterBackend()&&s.type==="MultiInput"){n=this.formatListItem(e.values.item);var u={busy:{path:"currentSettings>_loading"},placeholder:e.placeholder,editable:e.editable,visible:e.visible,showSuggestion:true,autocomplete:false,showValueHelp:false,filterSuggests:false,width:"100%",suggestionItems:{path:"",template:n,sorter:[new l({path:"Selected",descending:false,group:true})],groupHeaderFactory:i.getGroupHeader}};if(s.settings){u=o(u,s.settings)}s={type:a,settings:u}}this._visualization=s;this.attachAfterInit(this._afterInit)};d.prototype._afterInit=function(){var e=this.getAggregation("_field");var t=this.getModel();if(e instanceof r){if(this.isFilterBackend()){this.onInputForMultiComboBox=i(this.onInputForMultiComboBox,500);e.oninput=this.onInputForMultiComboBox;e.attachSelectionChange(this.onSelectionChangeForFilterBackend);e.attachSelectionFinish(this.onSelectionFinishForFilterBackend);t.attachPropertyChange(this.onPropertyChangeForFilterBackend,this)}else{e.attachSelectionChange(this.onSelectionChange);t.attachPropertyChange(this.onPropertyChange,this)}}else if(e instanceof a){this.initTokens();this.onInputForMultiInput=i(this.onInputForMultiInput,500);e.oninput=this.onInputForMultiInput;t.attachPropertyChange(this.onPropertyChangeForFilterBackend,this);t.attachPropertyChange(this.initTokens,this);e.attachTokenChange(this.onTokenChange)}};d.prototype.initTokens=function(){var e=this.getAggregation("_field");var t=this.getConfiguration();var r=[];if(Array.isArray(t.valueTokens)&&t.valueTokens.length>0){t.valueTokens.forEach(function(e){var t=new g(e);r.push(t)})}else if(Array.isArray(t.value)&&t.value.length>0&&Array.isArray(t.valueItems)&&t.valueItems.length>0){t.valueTokens=[];t.valueItems.forEach(function(e){var a=new h;a.setData(e);var i=p.resolveValue(t.values.item.key,a);if(t.value.includes(i)){var n=p.resolveValue(t.values.item.text,a);var s={key:i,text:n};var o=new g(s);r.push(o);t.valueTokens.push(s)}})}e.setTokens(r)};d.prototype.getKeyFromItem=function(e){var t=this.getConfiguration();var r=new h;r.setData(e);return p.resolveValue(t.values.item.key,r)};d.prototype.onPropertyChangeForFilterBackend=function(e){var t=this.getConfiguration();if(!t.valueItems){t.valueItems=[]}var r=t.values.data.path||"/";var a=this.getModel();var i=a.getData();if(r!=="/"){if(r.startsWith("/")){r=r.substring(1)}if(r.endsWith("/")){r=r.substring(0,r.length-1)}var n=r.split("/");var o=s.get(n,i);o=this.mergeSelectedItems(t,o);s.set(n,o,i)}else{i=this.mergeSelectedItems(t,i)}a.setData(i);this.setSuggestValue()};d.prototype.onPropertyChange=function(e){var t=this.getAggregation("_field");var r=t.getSelectedItems().map(function(e){return e.getKey()});var a=this.getBindingContext("currentSettings").sPath;var i=this.getModel("currentSettings");i.setProperty(a+"/value",r)};d.prototype.mergeSelectedItems=function(e,t){var r=this;var a=r.getResourceBundle();if(Array.isArray(t)){var i=e.valueItems.map(function(e){return this.getKeyFromItem(e)}.bind(this));var s=t.filter(function(e){var t=this.getKeyFromItem(e);return!i.includes(t)}.bind(this));var o=s.filter(function(e){return e.Selected===a.getText("EDITOR_ITEM_SELECTED")});e.valueItems=e.valueItems.concat(o);var u=s.filter(function(e){return e.Selected!==a.getText("EDITOR_ITEM_SELECTED")});t=e.valueItems.concat(u);var l=this.getAggregation("_field");if(l.isOpen&&l.isOpen()){i=e.valueItems.map(function(e){return this.getKeyFromItem(e)}.bind(this));var g=l.getSelectedKeys();if(!n(i,g)){l.setSelectedKeys(i)}}}else{t=e.valueItems}return t};d.prototype.setSuggestValue=function(){var e=this.getAggregation("_field");var t=this.getBindingContext("currentSettings").sPath;var r=this.getModel("currentSettings");var a=r.getProperty(t+"/suggestValue");if(a&&a!==""){e.setValue(a.replaceAll("''","'"))}};d.prototype.getSuggestValue=function(){var e=this.getBindingContext("currentSettings").sPath;var t=this.getModel("currentSettings");return t.getProperty(e+"/suggestValue")};d.prototype.getGroupHeader=function(e){return new u({text:e.key})};d.prototype.onSelectionChangeForFilterBackend=function(e){var t=e.getSource().getParent();var r=t.getConfiguration();var a=t.getResourceBundle();var i=e.getParameter("changedItem");var n=i.getKey();var o=e.getParameter("selected");var u=this.getModel().getData();var l=r.values.data.path||"/";var g,v;if(l!=="/"){if(l.startsWith("/")){l=l.substring(1)}if(l.endsWith("/")){l=l.substring(0,l.length-1)}g=l.split("/");v=s.get(g,u)}else{v=u}if(v){if(!r.valueItems){r.valueItems=[]}var h=[];v.forEach(function(e){var i=c(e,500);var s=t.getKeyFromItem(i);if(s===n){if(o){i.Selected=a.getText("EDITOR_ITEM_SELECTED");r.valueItems=r.valueItems.concat([i])}else{i.Selected=a.getText("EDITOR_ITEM_UNSELECTED");r.valueItems=r.valueItems.filter(function(e){var r=t.getKeyFromItem(e);return r!==n})}}h.push(i)});if(g!==undefined){s.set(g,h,u);this.getModel().checkUpdate(true)}else{this.getModel().setData(h)}}};d.prototype.onTokenChange=function(e){var t=this.getParent();var r=t.getConfiguration();var a=t.getResourceBundle();var i=t.getModel("currentSettings");var n=t.getBindingContext("currentSettings").sPath;var o=i.getProperty(n+"/value");var u=e.getParameter("token");if(u){var l=u.getKey();if(!r.valueTokens){r.valueTokens=[]}if(!o){o=[]}var g=e.getParameter("type");switch(g){case v.TokenChangeType.Removed:o=o.filter(function(e){return e!==l});r.value=o;r.valueTokens=r.valueTokens.filter(function(e){return e.key!==l});break;case v.TokenChangeType.Added:if(!o.includes(l)){o=o.concat([l]);r.value=o}var h=r.valueTokens.map(function(e){return e.key});if(!h.includes(l)){r.valueTokens=r.valueTokens.concat([{key:l,text:u.getText()}])}break;case v.TokenChangeType.RemovedAll:r.value=[];r.valueItems=[];r.valueTokens=[];break;default:break}var p=t.getModel().getData();var d;var f=r.values.data.path||"/";var m;if(f!=="/"){if(f.startsWith("/")){f=f.substring(1)}if(f.endsWith("/")){f=f.substring(0,f.length-1)}m=f.split("/");d=c(s.get(m,p),10)}else{d=c(p,10)}if(Array.isArray(d)){r.valueItems=[];d.forEach(function(e){var i=t.getKeyFromItem(e);if(r.value.includes(i)){e.Selected=a.getText("EDITOR_ITEM_SELECTED");r.valueItems.push(e)}else{e.Selected=a.getText("EDITOR_ITEM_UNSELECTED")}});if(f!=="/"){s.set(m,d,p)}else{p=d}t.getModel().setData(p);t.getModel().checkUpdate(true)}i.setProperty(n+"/value",r.value);i.setProperty(n+"/valueItems",r.valueItems);i.setProperty(n+"/valueTokens",r.valueTokens)}};d.prototype.onSelectionChange=function(e){var t=e.oSource.getParent();var r=t.getConfiguration();var a=t.getResourceBundle();var i=e.getParameter("changedItem");var n=i.getKey();var o=e.getParameter("selected");var u=this.getModel().getData();var l=r.values.data.path||"/";if(l!=="/"){if(l.startsWith("/")){l=l.substring(1)}if(l.endsWith("/")){l=l.substring(0,l.length-1)}var g=l.split("/");var v=s.get(g,u);if(Array.isArray(v)){for(var c in v){var h=t.getKeyFromItem(v[c]);if(h===n){if(o){v[c].Selected=a.getText("EDITOR_ITEM_SELECTED")}else{v[c].Selected=a.getText("EDITOR_ITEM_UNSELECTED")}}}s.set(g,v,u)}}else if(Array.isArray(u)){for(var c in u){var h=t.getKeyFromItem(u[c]);if(h===n){if(o){u[c].Selected=a.getText("EDITOR_ITEM_SELECTED")}else{u[c].Selected=a.getText("EDITOR_ITEM_UNSELECTED")}}}}this.getModel().setData(u);this.getModel().checkUpdate(true)};d.prototype.onSelectionFinishForFilterBackend=function(e){var t=this.getParent();var r=t.getConfiguration();var a=e.getParameter("selectedItems").map(function(e){return e.getKey()});var i=this.getModel().getData();var n=r.values.data.path||"/";if(n!=="/"){if(n.startsWith("/")){n=n.substring(1)}if(n.endsWith("/")){n=n.substring(0,n.length-1)}var o=n.split("/");i=s.get(o,i)}if(i){r.valueItems=i.filter(function(e){var r=t.getKeyFromItem(e);return a.includes(r)})}var u=this.getBindingContext("currentSettings").sPath;var l=this.getModel("currentSettings");l.setProperty(u+"/value",a);var g=t.getSuggestValue();if(g&&g!==""){l.setProperty(u+"/suggestValue","")}};d.prototype.onInputForMultiComboBox=function(e){var t=e.target.value;var r=this.getBindingContext("currentSettings").sPath;var a=this.getModel("currentSettings");a.setProperty(r+"/suggestValue",t.replaceAll("'","''"));a.setProperty(r+"/_loading",true);e.srcControl.open();e.srcControl._getSuggestionsPopover()._sTypedInValue=t};d.prototype.onInputForMultiInput=function(e){var t=e.srcControl;a.prototype.oninput.apply(t,arguments);var r=e.target.value;if(r===""){return}var i=this.getBindingContext("currentSettings").sPath;var n=this.getModel("currentSettings");var s=n.getProperty(i+"/suggestValue");if(s!==r.replaceAll("'","''")){n.setProperty(i+"/suggestValue",r.replaceAll("'","''"));n.setProperty(i+"/_loading",true)}};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/fragment/Controller", ["sap/ui/core/mvc/Controller","sap/ui/integration/util/Utils"],function(t,e){"use strict";var i=t.extend("sap.ui.integration.editor.fields.fragment.Controller",{});i.prototype.init=function(){};i.prototype.setField=function(t){this._oField=t};i.prototype.saveValue=function(t){var i=e._language;var n=this._oField.getConfiguration();if(n.type==="string"&&n.translatable){this._oField.setTranslationValueInTexts(i,t)}else{this._oField._settingsModel.setProperty(n.manifestpath,t)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/ColorSelect", ["sap/ui/integration/editor/fields/viz/VizBase","sap/m/ColorPalettePopover","sap/m/Button","sap/ui/core/Core","sap/base/util/merge","sap/ui/core/theming/Parameters"],function(e,t,o,a,n,l){"use strict";var r=e.extend("sap.ui.integration.editor.fields.viz.ColorSelect",{metadata:{library:"sap.ui.integration",properties:{enumValue:{type:"string",defaultValue:""},colorValue:{type:"string",defaultValue:""},colorEnum:{type:"string",defaultValue:"sap.m.AvatarColor"},background:{type:"boolean",defaultValue:true},allowCustomColors:{type:"boolean",defaultValue:false}},aggregations:{_colorpalette:{type:"sap.m.ColorPalettePopover",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:2}});var c={};function i(){var e=["sapUiAccent1","sapUiAccent2","sapUiAccent3","sapUiAccent4","sapUiAccent5","sapUiAccent6","sapUiAccent7","sapUiAccent8","sapUiAccent9","sapUiAccent10","sapUiTileIconColor","sapUiContentImagePlaceholderBackground"];var t=l.get({name:e,callback:function(e){}});if(t){c={"sap.m.AvatarColor":{Accent1:t["sapUiAccent1"],Accent2:t["sapUiAccent2"],Accent3:t["sapUiAccent3"],Accent4:t["sapUiAccent4"],Accent5:t["sapUiAccent5"],Accent6:t["sapUiAccent6"],Accent7:t["sapUiAccent7"],Accent8:t["sapUiAccent8"],Accent9:t["sapUiAccent9"],Accent10:t["sapUiAccent10"],TileIcon:t["sapUiTileIconColor"],Transparent:"transparent",Placeholder:t["sapUiContentImagePlaceholderBackground"]}}}}i();var s,p=new t("oColorPalettePopoverFull",{colorSelect:function(e){var t=e.getParameter("value"),o=c[s.getColorEnum()],a=Object.values(o).indexOf(t);s.setEnumValue(Object.keys(o)[a]);s.setColorValue(t);s._colorValue=t}});r.prototype.onInit=function(){this._oControl=new o({icon:"sap-icon://color-fill",press:function(){this._openPalette()}.bind(this)});this._colorValue="transparent"};r.prototype.onThemeChanged=function(){i()};r.prototype.applyStyle=function(e){e.class("sapUiIntegrationColorSelect");if(!this._colorValue||this._colorValue==="transparent"){e.class("noColorValueOrTransparentValue")}else{e.class("hasColorValue")}if(this._colorValue){e.style("--colorValue",this._colorValue)}};r.prototype._openPalette=function(){s=this;p.setShowDefaultColorButton(true);p.setShowMoreColorsButton(false);p.setDefaultColor("");var e=c[this.getColorEnum()];if(e){var t=[];for(var o in e){t.push(e[o])}p.setColors(t)}p.openBy(this._oControl)};r.prototype.setEnumValue=function(e){this.setProperty("enumValue",e);this._colorValue=c[this.getColorEnum()][e]};r.prototype.bindPropertyToControl=function(e,t){if(e==="editable"){var o=n({},t);this._oControl.bindProperty("enabled",o)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/IconSelect", ["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/integration/editor/fields/viz/VizBase","sap/m/Select","sap/ui/core/ListItem","sap/ui/model/json/JSONModel","sap/ui/core/IconPool","sap/ui/core/_IconRegistry","sap/base/util/merge","sap/base/util/deepClone","sap/base/util/deepEqual","sap/ui/integration/formatters/IconFormatter","sap/m/Popover","sap/m/Image","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/Text","sap/m/CheckBox","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/ui/integration/util/Utils"],function(e,t,o,i,n,s,l,a,r,c,p,d,u,h,f,g,_,I,y,S,C){"use strict";var m=t.getResourceBundleFor("sap.ui.integration",C._language),b,v,T=false;var P=o.extend("sap.ui.integration.editor.fields.viz.IconSelect",{metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:""},allowFile:{type:"boolean",defaultValue:true},allowNone:{type:"boolean",defaultValue:true},allowDefaultIcons:{type:"boolean",defaultValue:true}},events:{change:{}}},renderer:{apiVersion:2}});P.prototype._initDefaultIcons=function(){b=[];var e=l.getIconNames();e=e.sort(function(e,t){return e.toLowerCase().localeCompare(t.toLowerCase())});e.filter(function(e){var t=l.getIconInfo(e).text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);b.push({icon:"sap-icon://"+e,key:"sap-icon://"+e,text:t,additionalText:"sap-icon://"+e,tooltip:t,enabled:true,type:"UI5"})});if(!T){return}var t=a.getFontRegistry();if(!t["SAP-icons-TNT"]){l.registerFont({fontFamily:"SAP-icons-TNT",collectionName:"SAP-icons-TNT",fontURI:sap.ui.require.toUrl("sap/tnt/themes/base/fonts")})}if(!t["BusinessSuiteInAppSymbols"]){l.registerFont({fontFamily:"BusinessSuiteInAppSymbols",collectionName:"BusinessSuiteInAppSymbols",fontURI:sap.ui.require.toUrl("sap/ushell/themes/base/fonts/")})}v=Promise.all([l.fontLoaded("SAP-icons-TNT"),l.fontLoaded("BusinessSuiteInAppSymbols")]).then(function(){e=l.getIconNames("SAP-icons-TNT");e=e.filter(function(e){var t=e.substring(0,1).charCodeAt();return e.indexOf(" ")<0&&t>=97&&t<=122});e.sort();e.filter(function(e){var t=l.getIconInfo(e,"SAP-icons-TNT").text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);b.push({icon:"sap-icon://SAP-icons-TNT/"+e,key:"sap-icon://SAP-icons-TNT/"+e,text:t,additionalText:"sap-icon://SAP-icons-TNT/"+e,tooltip:t,enabled:true,type:"SAP-icons-TNT"})});e=l.getIconNames("BusinessSuiteInAppSymbols");e.sort();e.filter(function(e){var t=l.getIconInfo(e,"BusinessSuiteInAppSymbols").text||("-"+e).replace(/-(.)/gi,function(e,t){return" "+t.toUpperCase()}).substring(1);b.push({icon:"sap-icon://BusinessSuiteInAppSymbols/"+e,key:"sap-icon://BusinessSuiteInAppSymbols/"+e,text:t,additionalText:"sap-icon://BusinessSuiteInAppSymbols/"+e,tooltip:t,enabled:true,type:"BusinessSuiteInAppSymbols"})})})};P.prototype._initIconModel=function(){var e=[{icon:"",text:m.getText("EDITOR_ICON_NONE"),tooltip:"",key:d.SRC_FOR_HIDDEN_ICON,enabled:true,type:"Action"},{icon:"sap-icon://upload",text:m.getText("EDITOR_ICON_CHOOSE"),tooltip:"",key:"file",enabled:true,type:"Action"},{icon:"sap-icon://download",text:m.getText("EDITOR_ICON_SELECTED"),tooltip:"",key:"selected",enabled:false,type:"Action"}];this._oIconModel=new s(e);this._oIconModel.setSizeLimit(e.length)};P.prototype._initConfigModel=function(){var e={icons:{layout:"Grid",types:{Action:true,UI5:true,"SAP-icons-TNT":true,BusinessSuiteInAppSymbols:true}}};this._oConfigModel=new s(e)};P.prototype.onInit=function(){if(m&&m.sLocale!==C._language){m=t.getResourceBundleFor("sap.ui.integration",C._language)}if(!this._oIconModel){this._initIconModel()}if(!b){this._initDefaultIcons()}if(v){v.then(function(){if(this.getAllowDefaultIcons()){var e=this._oIconModel.getData();e=e.concat(c(b,500));this._oIconModel.setData(e);this._oIconModel.setSizeLimit(e.length);this._oIconModel.checkUpdate(true);this._oControl&&this._oControl.setSelectedKey(this.getValue())}v=undefined}.bind(this))}else if(this.getAllowDefaultIcons()){var e=this._oIconModel.getData();e=e.concat(c(b,500));this._oIconModel.setData(e);this._oIconModel.setSizeLimit(e.length)}if(!this._oConfigModel){this._initConfigModel()}var o=new n({icon:"{iconlist>icon}",text:"{iconlist>text}",tooltip:"{iconlist>tooltip}",key:"{iconlist>key}",additionalText:"{iconlist>additionalText}",enabled:{parts:["config>/icons/types","iconlist>type","iconlist>enabled"],formatter:function(e,t,o){return o&&e[t]}}});this._oFileUpload=document.createElement("INPUT");this._oFileUpload.type="file";this._oFileUpload.accept=".png,.jpg,.jpeg,.svg";this._boundFileUploadChange=this._fileUploadChange.bind(this);this._oFileUpload.addEventListener("change",this._boundFileUploadChange);this._oControl=new i({width:"100%",items:{path:"iconlist>/",template:o},change:function(e){var t=e.getSource(),o=e.getSource().getSelectedKey();if(o==="file"){t._customImage=null;this._oFileUpload.click();this._boundFocusBack=this._focusBack.bind(this);t.getDomRef("hiddenSelect").addEventListener("focus",this._boundFocusBack)}else{this.setValue(o);this.fireChange(e)}}.bind(this)});this._oControl.setModel(this._oIconModel,"iconlist");this._oControl.setModel(this._oConfigModel,"config");this._oControl._fnOpen=this._oControl.open;if(this.getAllowDefaultIcons()){var s=this;this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);s._oPicker=this.getPicker();var e=false;if(!s._oPicker.getFooter()&&e){var t=new f({content:[new y({selectedKey:"{config>/icons/layout}",items:[new S({icon:"sap-icon://grid",tooltip:"Grid View",key:"Grid"}),new S({icon:"sap-icon://list",tooltip:"Details View",key:"Details"})],select:function(e){var t=e.getSource();var o=t.getSelectedKey();if(o==="Grid"){this._oPicker.addStyleClass("sapUiIntegrationIconSelectList");this._oControl.setShowSecondaryValues(false)}else if(o==="Details"){this._oPicker.removeStyleClass("sapUiIntegrationIconSelectList");this._oControl.setShowSecondaryValues(true)}}.bind(s)}),new g,new _({text:"Icon Types:"}),new I({selected:"{config>/icons/types/UI5}",text:"UI5",select:s.onIconTypeChanged.bind(s)}),new I({selected:"{config>/icons/types/SAP-icons-TNT}",text:"Fiori",select:s.onIconTypeChanged.bind(s)}),new I({selected:"{config>/icons/types/BusinessSuiteInAppSymbols}",text:"Business Suite",select:s.onIconTypeChanged.bind(s)})]});s._oPicker.setFooter(t)}if(!p(s._oConfigModel.getProperty("/icons/types"),{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){s._oPicker.addStyleClass("sapUiIntegrationIconSelectList");s._oPicker.setContentHeight("400px")}}}this._oControl.addDelegate({onAfterRendering:this.onAfterRenderingSelect.bind(this)});this._oControl.addDelegate({onsappageup:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();this._oControl.setSelectedIndex(e-50)}}.bind(this),onsappagedown:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();if(e<3){this._oControl.setSelectedIndex(29)}else{this._oControl.setSelectedIndex(e+50)}}}.bind(this),onsapup:function(){if(this._oControl.isOpen()){var e=this.getAllowFile();var t=this.getAllowNone();var o=this._oIconModel.getProperty("/2/enabled");var i=this._oControl.getSelectedIndex();if(i>11+2){this._oControl.setSelectedIndex(i-11)}else if(i>=3){if(t&&!e){this._oControl.setSelectedIndex(0)}else if(o){this._oControl.setSelectedIndex(2)}else{this._oControl.setSelectedIndex(3)}}}}.bind(this),onsapdown:function(){if(this._oControl.isOpen()){var e=this._oControl.getSelectedIndex();if(e>1){this._oControl.setSelectedIndex(e+11)}}}.bind(this),onsapleft:function(){if(this._oControl.isOpen()){this._oControl.onsapup.apply(this._oControl,arguments)}}.bind(this),onsapright:function(){if(this._oControl.isOpen()){this._oControl.onsapdown.apply(this._oControl,arguments)}}.bind(this)},true)};P.prototype.applyStyle=function(e){e.class("sapUiIntegrationIconSelect");if(this._oControl&&this._oControl.getWidth){e.style("width",this._oControl.getWidth())}};P.prototype.onIconTypeChanged=function(e){this._oConfigModel.checkUpdate(true);var t=this._oConfigModel.getProperty("/icons/types");if(p(t,{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){this._oPicker.setContentHeight("")}else{this._oPicker.setContentHeight("400px")}var o=this.getValue();if(o&&o.indexOf("data:image/")===0){this._oControl._customImage=o;this._oIconModel.setProperty("/2/enabled",true);this._oControl.setSelectedKey("selected")}else{this._oControl.setSelectedKey(o)}};P.prototype._fileUploadChange=function(){var e=new window.FileReader;e.onload=function(){this.setValue(e.result);this._oControl.invalidate()}.bind(this);if(this._oFileUpload.files.length===1){e.readAsDataURL(this._oFileUpload.files[0])}};P.prototype._focusBack=function(){this._oControl.getDomRef("hiddenSelect").removeEventListener("focus",this._boundFocusBack);setTimeout(function(){this.setValue(this.getValue())}.bind(this),150)};P.prototype.bindPropertyToControl=function(e,t){if(e==="editable"){var o=r({},t);this._oControl.bindProperty("editable",o)}};P.prototype.setValue=function(e){this.setProperty("value",e,true);if(e&&e.indexOf("data:image/")===0){this._oControl._customImage=e;this._oIconModel.setProperty("/2/enabled",true);this._oControl.setSelectedKey("selected")}else{this._oControl._customImage=null;this._oIconModel.setProperty("/2/enabled",false);this._oControl.setSelectedKey(e)}this._oControl.invalidate();return this};P.prototype.setAllowFile=function(e){this.setProperty("allowFile",e,true);e=this.getAllowFile();this._oIconModel.setProperty("/1/enabled",e);return this};P.prototype.setAllowNone=function(e){this.setProperty("allowNone",e,true);e=this.getAllowNone();this._oIconModel.setProperty("/0/enabled",e);return this};P.prototype.onAfterRenderingSelect=function(){var t=this._oControl.getDomRef("labelIcon");if(t){var o=this._oControl._customImage;var i=e.getElementById(t.id);if(o){t.style.backgroundImage="url('"+o+"')";t.classList.add("sapMSelectListItemIconCustom");t.children[0].title=m.getText("EDITOR_IMAGE_CUSTOMICON_TOOLTIP");i.onclick=function(e){e.stopImmediatePropagation();if(!i._oImagePopover){i._oImagePopover=new u(i.getId()+"-imagePopover",{placement:"Right",showHeader:false}).addStyleClass("sapUiIntegrationImageSelect")}i._oImagePopover.destroyContent();i._oImagePopover.addContent(new h(i.getId()+"-imagePopover-image",{src:o}).addStyleClass("image"));i._oImagePopover.openBy(i)}}else{t.style.backgroundImage="unset";t.classList.remove("sapMSelectListItemIconCustom");i.onclick=undefined}}};P.prototype.setAllowDefaultIcons=function(e){if(typeof e==="boolean"&&this.getAllowDefaultIcons()!==e){var t=this._oIconModel.getData();if(e){t=t.concat(c(b,500));var o=this._oConfigModel.getProperty("/icons/types");this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);if(!p(o,{Action:true,UI5:false,"SAP-icons-TNT":false,BusinessSuiteInAppSymbols:false})){this._oPicker.addStyleClass("sapUiIntegrationIconSelectList");this._oPicker.setContentHeight("400px")}}}else{t=t.slice(0,3);this._oControl.open=function(){this._fnOpen&&this._fnOpen.apply(this,arguments);this.getPicker().removeStyleClass("sapUiIntegrationIconSelectList")}}this._oIconModel.setData(t);this._oIconModel.setSizeLimit(t.length)}};return P});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/ImageSelect", ["sap/ui/integration/editor/fields/viz/IconSelect"],function(e){"use strict";var i=e.extend("sap.ui.integration.editor.fields.viz.ImageSelect",{metadata:{library:"sap.ui.integration",properties:{allowDefaultIcons:{type:"boolean",defaultValue:false}}},renderer:{apiVersion:2}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/ShapeSelect", ["sap/ui/integration/editor/fields/viz/VizBase","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/base/util/merge"],function(e,t,i,n){"use strict";var o=e.extend("sap.ui.integration.editor.fields.viz.ShapeSelect",{metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:"Circle"}}},renderer:{apiVersion:2}});o.prototype.onInit=function(){this._oControl=new t({items:[new i({icon:"sap-icon://circle-task",key:"Circle"}),new i({icon:"sap-icon://border",key:"Square"})]})};o.prototype.applyStyle=function(e){e.class("sapUiIntegrationShapeSelect")};o.prototype.bindPropertyToControl=function(e,t){if(e==="editable"){var i=n({},t);this._oControl.bindProperty("enabled",i)}if(e==="value"){var i=n({},t);this._oControl.bindProperty("selectedKey",i)}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/editor/fields/viz/VizBase", ["sap/ui/core/Control","sap/m/SegmentedButton","sap/m/SegmentedButtonItem","sap/base/util/merge"],function(t,e,o,n){"use strict";var i=t.extend("sap.ui.integration.editor.fields.viz.VizBase",{metadata:{library:"sap.ui.integration",properties:{value:{type:"string",defaultValue:""},editable:{type:"boolean",defaultValue:true}},aggregations:{_control:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}},renderer:{apiVersion:1,render:function(t,e){var o=e.getAggregation("_control");t.openStart("div",e);e.applyStyle(t);t.openEnd();t.renderControl(o);t.close("div")}}});i.prototype.init=function(){this.onInit();this.setAggregation("_control",this._oControl)};i.prototype.bindProperty=function(e,o){t.prototype.bindProperty.apply(this,arguments);this.bindPropertyToControl(e,o);return this};i.prototype.onInit=function(){};i.prototype.applyStyle=function(t){};i.prototype.bindPropertyToControl=function(t,e){};return i});
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.predefine("sap/ui/integration/extensions/OAuth3LO", ["sap/ui/integration/Extension","sap/ui/integration/util/OAuth3LOHelper","sap/ui/integration/util/Utils","sap/m/IllustratedMessageType","sap/ui/integration/library","sap/ui/core/library","sap/m/library","sap/base/Log"],function(t,e,n,o,s,i,r,a){"use strict";const l=i.aria.HasPopup;const p=s.CardBlockingMessageType;const u=r.ButtonType;const c=t.extend("sap.ui.integration.extensions.OAuth3LO");c.prototype.overrideBlockingMessage=function(t){if(!t){return null}if(!e.needsConsent(t)){return null}if(e.hasConsentError(t)){return this._createConsentErrorMessage(t)}return this._createConsentMessage(t)};c.prototype.fetch=async function(n,o,s){const i=await t.prototype.fetch.apply(this,arguments);if(e.needsConsent(i)){this._aPollingRequest=[n,o,s]}return i};c.prototype.exit=function(){t.prototype.exit.apply(this,arguments);if(this._sConsentId){e.unregisterCard(this._sConsentId,this.getCard())}if(this._oPolling){this._oPolling.stop();this._oPolling=null}};c.prototype._createConsentMessage=function(t){const n=this.getCard();const s=e.readHeader(t);this._sConsentId=s.consent.id;e.registerCard(this._sConsentId,n);const i=new URL(s.consent.url,window.location.href);return{type:p.Information,illustrationType:o.Connection,imageSrc:s.imageSrc,title:s.title||n.getTranslatedText("CARD_OAUTH3LO_FALLBACK_TITLE"),description:s.description||n.getTranslatedText("CARD_OAUTH3LO_FALLBACK_DESCRIPTION",[i.origin]),additionalContent:[{text:s.buttonText||n.getTranslatedText("CARD_OAUTH3LO_FALLBACK_BUTTON_TEXT"),buttonType:u.Accept,ariaHasPopup:l.Dialog,press:()=>{this._triggerConsent(s)}}]}};c.prototype._createConsentErrorMessage=function(t){const n=this.getCard();const s=e.readHeader(t);a.error(s.message,this);return{type:p.Error,illustrationType:o.ErrorScreen,title:n.getTranslatedText("CARD_ERROR_CONFIGURATION_TITLE"),description:n.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION")}};c.prototype._triggerConsent=function(t){const n=t.consent.url;if(!n){a.error("Consent url for OAuth3LO is empty.",this);return}e.openConsentWindow(n,t.popupWindow);window.addEventListener("focus",()=>{this._startPolling(t)},{once:true})};c.prototype._startPolling=function(o){const s=o.polling;if(this._oPolling){this._oPolling.stop()}this._oPolling=n.polling(async()=>{a.info("Polling for 3LO consent.",this);const n=await t.prototype.fetch.apply(this,this._aPollingRequest);if(e.hasConsentError(n)){this.getCard().showBlockingMessage(this._createConsentErrorMessage(n));return true}if(e.needsConsent(n)){return false}if(n.ok){e.handleConsent(o.consent.id)}return true},s.frequency,s.maximum)};return c});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/DateTimeFormatter", ["sap/ui/core/format/DateFormat","sap/ui/core/date/UniversalDate","sap/ui/integration/util/Utils"],function(e,t,a){"use strict";const r={dateTime(r,n,s){const i=a.processFormatArguments(n,s);const o=e.getDateTimeInstance(i.formatOptions,i.locale);let m;if(Array.isArray(r)){m=r.map(e=>new t(a.parseJsonDateTime(e)))}else if(r!==undefined){m=new t(a.parseJsonDateTime(r))}if(m){return o.format(m)}return""},date(r,n,s){const i=a.processFormatArguments(n,s);const o=e.getDateInstance(i.formatOptions,i.locale);let m;if(Array.isArray(r)){m=r.map(e=>new t(a.parseJsonDateTime(e)))}else if(r!==undefined){m=new t(a.parseJsonDateTime(r))}if(m){return o.format(m)}return""}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/IconFormatter", ["sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/core/IconPool"],function(t,e,r){"use strict";var a=t.extend("sap.ui.integration.formatters.IconFormatter",{metadata:{library:"sap.ui.integration",associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}}});a.SRC_FOR_HIDDEN_ICON="SRC_FOR_HIDDEN_ICON";a.prototype.formatSrc=function(t){if(!t||!t.trim()){return t}if(t===a.SRC_FOR_HIDDEN_ICON){return a.SRC_FOR_HIDDEN_ICON}if(t.startsWith("data:")||r.isIconURI(t)){return t}return this._format(t)};a.prototype._format=function(t){return this._getCardInstance().getRuntimeUrl(t)};a.prototype._getCardInstance=function(){return e.getElementById(this.getCard())};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/InitialsFormatter", [],function(){"use strict";var t={initials:function(t,n){var r=t.split(" "),n=!n?2:n,i="";r.forEach(function(t){i+=t.substring(0,1)});i=n===2?i.charAt(0)+i.charAt(i.length-1):i.substring(0,n);return i.toUpperCase()}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/NumberFormatter", ["sap/ui/core/format/NumberFormat","sap/ui/integration/util/Utils"],function(t,r){"use strict";var n={currency:function(n,e,o,a){var s=r.processFormatArguments(o,a),c=t.getCurrencyInstance(s.formatOptions,s.locale);return c.format(n,e)},float:function(n,e,o){var a=r.processFormatArguments(e,o),s=t.getFloatInstance(a.formatOptions,a.locale);return s.format(n)},integer:function(n,e,o){var a=r.processFormatArguments(e,o),s=t.getIntegerInstance(a.formatOptions,a.locale);return s.format(n)},percent:function(n,e,o){var a=r.processFormatArguments(e,o),s=t.getPercentInstance(a.formatOptions,a.locale);return s.format(n)},unit:function(n,e,o,a){var s=r.processFormatArguments(o,a),c=t.getUnitInstance(s.formatOptions,s.locale);return c.format(n,e)}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/formatters/TextFormatter", ["sap/base/strings/formatMessage"],function(t){"use strict";var e={text:function(e,s){return t(e,s)}};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/library", ["sap/ui/base/DataType","sap/ui/core/Lib","sap/ui/core/library","sap/m/library","sap/f/library","sap/ui/unified/library","sap/ui/layout/library","sap/ui/table/library"],function(a,e){"use strict";var t=e.init({apiVersion:2,name:"sap.ui.integration",version:"1.136.0",dependencies:["sap.ui.core","sap.f","sap.m","sap.ui.unified","sap.ui.layout","sap.ui.table"],types:["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction","sap.ui.integration.CardDesign","sap.ui.integration.CardDisplayVariant","sap.ui.integration.CardBlockingMessageType","sap.ui.integration.CardPreviewMode","sap.ui.integration.CardOverflow","sap.ui.integration.AttributesLayoutType"],controls:["sap.ui.integration.widgets.Card","sap.ui.integration.cards.filters.FilterBar","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem","sap.ui.integration.controls.BlockingMessage","sap.ui.integration.controls.ImageWithOverlay"],elements:["sap.ui.integration.ActionDefinition","sap.ui.integration.Host","sap.ui.integration.Extension"],extensions:{"sap.ui.integration":{customElements:{card:"sap/ui/integration/customElements/CustomElementCard"}}}});t.CardActionType={Navigation:"Navigation",Submit:"Submit",Custom:"Custom",DateChange:"DateChange",MonthChange:"MonthChange",ShowCard:"ShowCard",HideCard:"HideCard"};t.CardDataMode={Active:"Active",Inactive:"Inactive",Auto:"Auto"};t.CardDesign={Solid:"Solid",Transparent:"Transparent"};t.CardDisplayVariant={CompactHeader:"CompactHeader",SmallHeader:"SmallHeader",StandardHeader:"StandardHeader",Small:"Small",Standard:"Standard",Large:"Large",TileStandard:"TileStandard",TileStandardWide:"TileStandardWide",TileFlat:"TileFlat",TileFlatWide:"TileFlatWide"};t.CardActionArea={None:"None",Content:"Content",ContentItem:"ContentItem",ActionsStrip:"ActionsStrip",ContentItemDetail:"ContentItemDetail",Header:"Header",Card:"Card"};t.CardMessageType={Information:"Information",Warning:"Warning",Error:"Error",None:"None",Success:"Success",Toast:"Toast",Loading:"Loading"};t.CardBlockingMessageType={Error:"Error",NoData:"NoData",Information:"Information"};t.CardArea={Header:"Header",Filters:"Filters",Content:"Content"};t.CardPreviewMode={Off:"Off",MockData:"MockData",Abstract:"Abstract"};t.CardOverflow={Default:"Default",ShowMore:"ShowMore"};t.AttributesLayoutType={OneColumn:"OneColumn",TwoColumns:"TwoColumns"};t.CardMenuAction=a.createType("sap.ui.integration.CardMenuAction",{isValid:function(a){var e=["type","text","icon","tooltip","buttonType","enabled","visible","action","parameters","startsSection","actions","target","url"];return Object.keys(a).every(function(a){return e.indexOf(a)!==-1})}},"object");a.registerEnum("sap.ui.integration.CardActionType",t.CardActionType);a.registerEnum("sap.ui.integration.CardDataMode",t.CardDataMode);a.registerEnum("sap.ui.integration.CardDesign",t.CardDesign);a.registerEnum("sap.ui.integration.CardDisplayVariant",t.CardDisplayVariant);a.registerEnum("sap.ui.integration.CardMessageType",t.CardMessageType);a.registerEnum("sap.ui.integration.CardBlockingMessageType",t.CardBlockingMessageType);a.registerEnum("sap.ui.integration.CardPreviewMode",t.CardPreviewMode);a.registerEnum("sap.ui.integration.CardOverflow",t.CardOverflow);a.registerEnum("sap.ui.integration.AttributesLayoutType",t.AttributesLayoutType);return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/model/ContextModel", ["sap/ui/model/json/JSONModel","sap/base/Log","sap/ui/integration/util/Utils"],function(t,e,s){"use strict";var i=t.extend("sap.ui.integration.model.ContextModel",{constructor:function(e,s){t.apply(this,arguments);this._aPendingPromises=[]}});i.prototype.setHost=function(t){this._oHost=t;this.resetHostProperties()};i.prototype.getProperty=function(i,o){if(i&&!i.startsWith("/")&&!o){i="/"+i}var n=this._oHost,r=this.resolve(i,o),a,u=n&&n.getContextValue;if(u){this._mValues=this._mValues||{};if(this._mValues.hasOwnProperty(r)){return this._mValues[r]}a=s.timeoutPromise(n.getContextValue(r.substring(1)));a=a.then(function(t){this._mValues[r]=t;this.checkUpdate()}.bind(this)).catch(function(t){this._mValues[r]=null;this.checkUpdate();e.error("Path "+r+" could not be resolved. Reason: "+t)}.bind(this));this._aPendingPromises.push(a);return null}else{return t.prototype.getProperty.apply(this,arguments)}};i.prototype.resetHostProperties=function(){this._mValues={}};i.prototype.waitForPendingProperties=function(){var t=Promise.all(this._aPendingPromises);this._aPendingPromises=[];return t};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/model/ObservableModel", ["sap/ui/model/json/JSONModel","sap/ui/model/ClientPropertyBinding"],function(e,i){"use strict";var t=e.extend("sap.ui.integration.model.ObservableModel",{constructor:function(t,n){e.apply(this,arguments);this._observedBinding=new i(this,"/",this.getContext("/"));this._observedBinding.attachChange(this._handleChange.bind(this));this._fireChangeBound=this._fireChange.bind(this)}});t.prototype.destroy=function(){this._observedBinding.destroy();this._observedBinding=null;clearTimeout(this._iFireChangeCallId)};t.prototype._handleChange=function(){this._scheduleFireChange()};t.prototype._scheduleFireChange=function(){if(this._iFireChangeCallId){clearTimeout(this._iFireChangeCallId)}this._iFireChangeCallId=setTimeout(this._fireChangeBound,0)};t.prototype._fireChange=function(){this.fireEvent("change")};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/services/Data", ["./Service"],function(t){"use strict";var e=t.extend();e.prototype.attachDataChanged=function(t,e){};e.prototype.detachDataChanged=function(t){};e.prototype.getData=function(t){return Promise.resolve(false)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/services/Navigation", ["./Service"],function(e){"use strict";var t=e.extend();t.prototype.navigate=function(e){};t.prototype.enabled=function(e){return Promise.resolve(false)};t.prototype.hidden=function(e){return Promise.resolve(false)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/services/Service", [],function(){"use strict";var t=function(){};t.extend=function(t){if(!t){var e=this;t=function(){e.apply(this,arguments)}}t.prototype=Object.create(this.prototype);t.prototype.constructor=t;t.extend=this.extend.bind(t);return t};t.prototype.getInterface=function(){return this};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/types/HeaderInfoSectionJustifyContent", ["sap/ui/base/DataType"],function(e){"use strict";var t={SpaceBetween:"SpaceBetween",End:"End",Start:"Start"};e.registerEnum("sap.ui.integration.types.HeaderInfoSectionJustifyContent",t);return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/AnalyticsCloudHelper", ["sap/base/i18n/Localization","sap/ui/core/Locale","sap/ui/core/Theming","sap/ui/dom/includeScript"],function(e,t,i,a){"use strict";const n={};n.WIDGET_SCRIPT_SRC="https://assets.sapanalytics.cloud/production/api/widget/sac-widget-embed.js";n.loadWidget=function(e){if(sap?.sac?.api?.widget){return Promise.resolve()}if(n._pInitialize){return n._pInitialize}let t=n.WIDGET_SCRIPT_SRC;if(e&&e.getAnalyticsCloudWidgetSrc){t=e.getAnalyticsCloudWidgetSrc()||t}const i=n._includeScript(t).then(()=>{if(!sap?.sac?.api?.widget){return Promise.reject("Object sap.sac.api.widget is undefined after the script was loaded.")}sap.sac.api.widget.setup(n._getSettings());return Promise.resolve()},()=>Promise.reject(`There was a problem loading the widget from '${t}'`));n._pInitialize=i;return i};n._getSettings=function(){const a=new t(e.getLanguageTag());const n={language:a.toString(),dataAccessLanguage:a.toString(),theme:i.getTheme()};return n};n._includeScript=function(e){return a({url:e})};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/BaseFactory", ["./BindingHelper","sap/base/util/merge","sap/ui/base/Object"],function(t,e,a){"use strict";var i=a.extend("sap.ui.integration.util.BaseFactory",{constructor:function(t){a.call(this);this._oCard=t}});i.prototype.createBindingInfos=function(a){var i=e({},a),n=i.data;delete i.data;i=t.createBindingInfos(i,this._oCard.getBindingNamespaces());if(n){i.data=n}return i};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/BindingHelper", ["sap/ui/base/BindingParser","sap/base/util/extend","sap/base/util/isPlainObject","sap/ui/integration/formatters/DateTimeFormatter","sap/ui/integration/formatters/NumberFormatter","sap/ui/integration/formatters/TextFormatter","sap/ui/integration/bindingFeatures/DateRange","sap/ui/integration/formatters/InitialsFormatter"],function(e,r,t,n,a,i,s,f){"use strict";function o(e){if(typeof e!=="string"){return false}return/\Wsize\(/.test(e)}var u=/\{\{([^}]+)\}\}/g,p=/\{\{(parameters\.[^}]+)\}\}/g,c=/\{\{(dataSources\.[^}]+)\}\}/g;var d={};var l={date:n.date,dateTime:n.dateTime,currency:a.currency,float:a.float,integer:a.integer,percent:a.percent,text:i.text,unit:a.unit,initials:f.initials};d.mLocals={format:l,dateRange:s};d.extractBindingInfo=function(t,n){t=d.escapeCardPlaceholders(t);let a=e.complexParser(t,undefined,true,undefined,undefined,undefined,r({},d.mLocals,n));if(o(t)){const e=a;if(e==="true"){a=true}else if(e==="false"){a=false}else if(e==="null"){a=null}else if(e==="undefined"){a=undefined}else if(!Number.isNaN(Number(e))){a=Number(e)}}return a};d.createBindingInfos=function(e,r){if(!e){return e}if(Array.isArray(e)){return e.map(function(e){return d.createBindingInfos(e,r)})}if(t(e)){var n={};for(var a in e){n[a]=d.createBindingInfos(e[a],r)}return n}if(typeof e==="string"){var i=d.extractBindingInfo(e,r);if(o(e)){return i}return d.escapeParametersAndDataSources(i||e)}return e};d.formattedProperty=function(e,t){if(e===undefined){return e}var n={};if(Array.isArray(e)){n.parts=e.map(function(e){return typeof e==="object"?r({},e):{value:e}});n.formatter=t}else if(typeof e==="object"){n=r({},e);if(e.formatter){var a=n.formatter;n.formatter=function(){var e=a.apply(this,arguments);return t(e)}}else{n.formatter=t}}else{n={value:e,formatter:t}}return n};d.escapeCardPlaceholders=function(e){if(typeof e!=="string"){return e}return e.replace(u,"\\{\\{$1\\}\\}")};d.escapeParametersAndDataSources=function(e){if(typeof e!=="string"){return e}return e.replace(p,"\\{\\{$1\\}\\}").replace(c,"\\{\\{$1\\}\\}")};d.isAbsolutePath=function(e){return e.startsWith("/")};d.prependRelativePaths=function(e,t){if(!e){return e}if(d.isBindingInfo(e)){var n=r({},e);if(n.path&&!this.isAbsolutePath(n.path)){n.path=t+"/"+n.path}if(n.parts){n.parts=n.parts.map(function(e){return d.prependRelativePaths(e,t)})}return n}if(Array.isArray(e)){return e.map(function(e){return d.prependRelativePaths(e,t)})}if(typeof e==="object"){var a={};for(var i in e){a[i]=d.prependRelativePaths(e[i],t)}return a}return e};d.propagateModels=function(e,t){var n=r({},e.oPropagatedProperties.oModels,e.oModels),a=Object.keys(n),i=e.getModel();if(i){t.setModel(i)}a.forEach(function(r){if(r==="undefined"){return}var n=e.getModel(r);if(n){t.setModel(n,r)}})};d.reuse=function(e){if(typeof e==="object"){return r({},e)}return e};d.isBindingInfo=function(e){if(!e){return false}return e.hasOwnProperty("path")||e.hasOwnProperty("parts")&&(e.hasOwnProperty("formatter")||e.hasOwnProperty("binding"))};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/BindingResolver", ["sap/ui/base/ManagedObject","sap/base/Log","sap/ui/model/Model","sap/ui/integration/util/BindingHelper","sap/base/util/extend","sap/base/util/isPlainObject"],function(e,r,n,i,t,a){"use strict";var s=e.extend("sap.ui.integration.util.SimpleControl",{metadata:{library:"sap.ui.integration",properties:{resolved:{type:"any"}}}});var o=new s;var u={};function l(e,n,t,s,o,u){if(s===o){r.warning("BindingResolver maximum level processing reached. Please check for circular dependencies.");return e}if(Array.isArray(e)){return e.map(function(e){return l(e,n,t,s+1,o,u)})}if(e&&a(e)&&!i.isBindingInfo(e)){var f={};for(var p in e){f[p]=l(e[p],n,t,s+1,o,u)}return f}if(typeof e==="string"&&!u){return d(e,n,t)}if(typeof e==="object"&&i.isBindingInfo(e)){return d(e,n,t)}return e}function d(r,a,s){if(!r){return r}var u=typeof r==="string"?e.bindingParser(r):t({},r);if(!u){return r}if(!s){s="/"}o.unbindProperty("resolved");o.unbindObject();o.setModel(null);if(a instanceof n){o.setModel(a)}else{i.propagateModels(a,o)}o.bindObject(s);o.bindProperty("resolved",u);var l=o.getResolved();return l}u.resolveValue=function(e,r,n,i){var t=0,a=30;if(r){return l(e,r,n,t,a,i)}else{return e}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/CacheAndRequestDataProvider", ["sap/ui/core/Element","sap/ui/integration/util/RequestDataProvider","sap/base/Log","sap/base/util/deepExtend","sap/ui/core/date/UI5Date"],function(e,t,a,i,s){"use strict";var r=31536e3;function n(e){var t=e.url,a=e.data,i,s;if(e.method!=="GET"){return e.url}i=new URL(t,window.location.href);for(s in a){i.searchParams.set(s,a[s])}return i.href}var o=t.extend("sap.ui.integration.util.CacheAndRequestDataProvider");o.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oRefreshWithoutCacheBound=this.refreshWithoutCache.bind(this)};o.prototype.destroy=function(){this._unsubscribeFromHostMessages();this._detachTimestampPress();t.prototype.destroy.apply(this,arguments)};o.prototype.getHostInstance=function(){return e.getElementById(this.getHost())};o.prototype.getCardInstanceHeader=function(){var e=this.getCardInstance();if(!e){return null}return e.getCardHeader()};o.prototype.onDataRequestComplete=function(){const e=this.getResolvedConfiguration();if(this._iUpdateIntervalTimeout){clearTimeout(this._iUpdateIntervalTimeout);this._iUpdateIntervalTimeout=null}if(!e||!e.updateInterval){return}const t=parseInt(e.updateInterval);if(isNaN(t)){return}this._iUpdateIntervalTimeout=setTimeout(function(){this.refreshWithoutCache()}.bind(this),t*1e3)};o.prototype._request=function(e){var a,i=this.getCardInstanceHeader();this._sCurrentRequestFullUrl=n(e.url);this._subscribeToHostMessages();a=t.prototype._request.apply(this,arguments);a.then(function(e){var t=e[1],a=t.headers.get("Date");if(a&&i){this._attachTimestampPress();i.setDataTimestamp(s.getInstance(a).toISOString())}}.bind(this));return a};o.prototype.refreshWithoutCache=function(){var e=this.getCardInstanceHeader();if(e){e.setDataTimestampUpdating(true)}setTimeout(function(){this._bCacheOnly=false;this._bNoCache=true;this._triggerDataUpdate()}.bind(this),200)};o.prototype.refreshFromCache=function(){var e=this.getCardInstanceHeader();if(e){e.setDataTimestampUpdating(true)}setTimeout(function(){this._bCacheOnly=true;this._bNoCache=false;this._triggerDataUpdate()}.bind(this),200)};o.prototype._modifyRequestBeforeSent=function(e,a){a.request=this._addCacheConfiguration(a.request);return t.prototype._modifyRequestBeforeSent.call(this,e,a)};o.prototype._addCacheConfiguration=function(e){var t={cache:{enabled:true,maxAge:0,staleWhileRevalidate:true}},a=i(t,e),s=a.cache;if(s.noStore){s.enabled=false}if(s.enabled){if(this._bCacheOnly){s.maxAge=r;s.staleWhileRevalidate=false}else if(this._bNoCache){s.maxAge=0;s.staleWhileRevalidate=false}}return a};o.prototype._getResolvedRequestConfiguration=function(){return this._addCacheConfiguration(this.getResolvedConfiguration().request)};o.prototype._subscribeToHostMessages=function(){var e=this.getHostInstance();if(this._bIsSubscribed){return}if(!e){return}e.attachMessage(this._handleHostMessage,this);this._bIsSubscribed=true};o.prototype._unsubscribeFromHostMessages=function(){var e=this.getHostInstance();if(!e){return}e.detachMessage(this._handleHostMessage,this);this._bIsSubscribed=false};o.prototype._handleHostMessage=function(e){var t=e.getParameter("data");if(t.type!=="ui-integration-card-update"){return}if(t.url!==this._sCurrentRequestFullUrl){return}a.info("[CARDS CACHE] message ui-integration-card-update received for "+t.url);this.refreshFromCache()};o.prototype._attachTimestampPress=function(e){var t=this.getCardInstance(),a=this.getCardInstanceHeader();if(this._oHeaderDelegate){return}if(!a){return}this._oHeaderDelegate={onBeforeRendering:function(){var e=t.$().find(".sapFCardDataTimestamp");e.off("click",this._oRefreshWithoutCacheBound)}.bind(this),onAfterRendering:function(){var e=t.$().find(".sapFCardDataTimestamp");e.on("click",this._oRefreshWithoutCacheBound)}.bind(this)};a.addEventDelegate(this._oHeaderDelegate)};o.prototype._detachTimestampPress=function(e){var t=this.getCardInstance(),a=this.getCardInstanceHeader(),i=t&&t.$().find(".sapFCardDataTimestamp");if(!a){return}i.off("click",this._oRefreshWithoutCacheBound);a.removeEventDelegate(this._oHeaderDelegate);this._oHeaderDelegate=null};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/CardMerger", ["sap/base/util/merge","sap/ui/model/json/JSONModel","sap/base/util/deepClone","sap/ui/integration/util/Utils"],function(e,t,r,a){"use strict";var n={layers:{admin:0,content:5,translation:10,all:20},mergeManifestPathChanges:function(e,t){Object.keys(t).forEach(function(r){if(r.charAt(0)==="/"){var a=t[r];n.updateManifestProperty(e,r,a)}})},updateManifestProperty:function(e,t,r){var a=e.setProperty(t,r);if(!a){var i=t.lastIndexOf("/");var s=t.substring(0,i||1);var f=t.substring(i+1);var o={};o[f]=r;n.updateManifestProperty(e,s,o)}},mergeTextsChanges:function(e,t,r){var i=a._language;if(t&&t.hasOwnProperty(i)){var s=t[i];for(var f in s){var o=s[f];if(typeof o==="object"){n.translateObject(e,f,o,r)}else{var u=e.getProperty(f);var l=true;if(u&&typeof u==="string"&&(u.indexOf("{context>")===0||u.indexOf("{{parameters")===0)){l=false}if(l){e.setProperty(f,o)}}}}},mergeCardDelta:function(r,i,s){var f=e({},r);if(typeof s==="undefined"){s="sap.card"}if(Array.isArray(i)&&i.length>0){var o,u,l;a.mapLanguagesInManifestChanges(i);i.forEach(function(r){if(r.content){e(f[s],r.content)}else{var i=r.hasOwnProperty(":layer")?r[":layer"]:1e3;if(i===n.layers["translation"]){var c=a._language;var p={texts:{}};p.texts[c]={};delete r.texts;Object.keys(r).forEach(function(e){if(e.charAt(0)==="/"){p.texts[c][e]=r[e]}else{p[e]=r[e]}});r=p}u=e(u,r.texts);l=e(l,r[":designtime"]);o=o||new t(f);n.mergeManifestPathChanges(o,r)}});n.mergeTextsChanges(o,u,l)}return f},mergeCardDesigntimeMetadata:function(t,r){var a=e({},t);r.forEach(function(e){var t=e.content.entityPropertyChange||[];t.forEach(function(e){var t=e.propertyPath;switch(e.operation){case"UPDATE":if(a.hasOwnProperty(t)){a[t]=e.propertyValue}break;case"DELETE":delete a[t];break;case"INSERT":if(!a.hasOwnProperty(t)){a[t]=e.propertyValue}break;default:break}})});return a},translateObject:function(t,a,n,i){var s=t.getProperty(a);if(!s||typeof s!=="object"){return}s=r(s,500);if(!Array.isArray(s)){var f=(s._dt||{})._uuid;if(f&&n[f]){if(i&&i[a]&&i[a][f]){for(var o in i[a][f]){if(i[a][f][o].translatable===false){delete n[f][o]}}}e(s,n[f]);t.setProperty(a,s)}}else{s.forEach(function(t){var r=(t._dt||{})._uuid;if(r&&n[r]){if(i&&i[a]&&i[a][r]){for(var s in i[a][r]){if(i[a][r][s].translatable===false){delete n[r][s]}}}e(t,n[r])}});t.setProperty(a,s);return}}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/CardObserver", ["sap/ui/base/Object"],function(e){"use strict";var t=e.extend("sap.ui.integration.util.CardObserver",{constructor:function(t){e.call(this);this._oCard=t;this._oObservedDomRef=null}});t.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);this._oCard=null;if(this._oObserver){this._oObserver.disconnect();this._oObserver=null}};t.prototype._createObserver=function(){if(!this._oObserver){this._oObserver=new window.IntersectionObserver(function(e){e.forEach(function(e){if(e.isIntersecting){this._bIsIntersected=true;this.loadManifest()}}.bind(this),{threshold:[.1]})}.bind(this))}};t.prototype.observe=function(e){if(!this._oObserver){this._createObserver()}if(e!==this._oObservedDomRef){if(this._oObservedDomRef){this._oObserver.unobserve(this._oObservedDomRef)}this._oObserver.observe(e);this._oObservedDomRef=e;this._bIsIntersected=false}};t.prototype.unobserve=function(e){if(this._oObserver&&this._oObservedDomRef===e){this._oObserver.unobserve(e);this._oObservedDomRef=null}};t.prototype.loadManifest=function(){var e=this._oCard.getDomRef();this.unobserve(e);this._oCard.refresh()};t.prototype.isIntersected=function(){return this._bIsIntersected};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ComboBoxHelper", [],function(){"use strict";const e={};e.setValueAndKey=function(e,t,n){if(t){e.setSelectedKey(t);const n=e.getItems().find(e=>e.getKey()===t);e.setValue(n?n.getText():"");return}if(n){const t=e.getItems().find(e=>e.getText()===n);if(t){e.setSelectedItem(t)}else{e.setSelectedKey(null);e.setValue(n)}return}e.setSelectedKey(null);e.setValue(null)};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ContentFactory", ["./BaseFactory","sap/base/Log","sap/m/IllustratedMessageType","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/cards/AdaptiveContent","sap/ui/integration/cards/AnalyticalContent","sap/ui/integration/cards/AnalyticsCloudContent","sap/ui/integration/cards/CalendarContent","sap/ui/integration/cards/ComponentContent","sap/ui/integration/cards/ListContent","sap/ui/integration/cards/ObjectContent","sap/ui/integration/cards/TableContent","sap/ui/integration/cards/TimelineContent","sap/ui/integration/cards/WebPageContent","sap/ui/integration/cards/BaseListContent"],function(t,e,a,n,r,i,o,s,c,d,u,p,l,g,C){"use strict";var f=t.extend("sap.ui.integration.util.ContentFactory");f.prototype.create=function(t){var i=this._oCard,o=t.cardType,s=i.getAggregation("_extension");var c=this.getClass(o);if(!c){throw new Error(o.toUpperCase()+" content type is not supported.")}var d=new c({card:i,overflowWithShowMore:t.overflowWithShowMore});if(d instanceof r){d.setCardDataProvider(i._oDataProvider)}d.setServiceManager(t.serviceManager);d.setDataProviderFactory(t.dataProviderFactory);d.setIconFormatter(t.iconFormatter);d.setActions(new n({card:i}));d.setConfiguration(t.contentManifest);d.setNoDataConfiguration(t.noDataConfiguration);if(!(d instanceof r)){d.setDataConfiguration(t.contentManifest.data)}if(d instanceof C){d.setPaginator(t.paginator)}d.setLoadDependenciesPromise(Promise.all([d.loadDependencies(t.cardManifest),s?s.loadDependencies():Promise.resolve()]).then(function(){return true}).catch(function(t){if(t){e.error(t,"sap.ui.integration.util.ContentFactory");i._handleError({type:a.ErrorScreen,title:i.getTranslatedText("CARD_DATA_LOAD_DEPENDENCIES_ERROR"),description:i.getTranslatedText("CARD_ERROR_REQUEST_DESCRIPTION"),details:t})}return false}));d.getLoadDependenciesPromise().then(function(t){if(t&&!d.isDestroyed()){d.applyConfiguration()}});return d};f.prototype.getClass=function(t){switch(t.toLowerCase()){case"adaptivecard":return r;case"analytical":return i;case"analyticscloud":return o;case"calendar":return s;case"component":return c;case"list":return d;case"object":return u;case"table":return p;case"timeline":return l;case"webpage":return g;default:return null}};return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/CsrfTokenHandler", ["sap/ui/base/Object","sap/base/util/isPlainObject","sap/base/util/merge","sap/ui/model/json/JSONModel","../cards/data/CsrfToken"],function(t,e,o,r,n){"use strict";var i=/\{\{csrfTokens.([^\}]+)\}\}/;var s="X-CSRF-Token";var a=t.extend("sap.ui.integration.util.CsrfTokenHandler",{metadata:{library:"sap.ui.integration"},constructor:function(e){t.call(this);e=e||{};this._mTokens=new Map;this._oModel=e.model;this._oHost=e.host;this._oConfiguration=e.configuration;this._oDataProviderFactory=e.dataProviderFactory;for(const[t,o]of Object.entries(e.configuration)){this._mTokens.set(t,new n(t,o,this))}}});a.prototype.getUsedToken=function(t){const e=this._findTokenName(t);return this._mTokens.get(e)};a.prototype.fetchValue=function(t){t=o({},t);return this._requestToken(t.data)};a.prototype.fetchValueByHost=function(t){if(this._oHost){t=o({},t);return this._oHost.getCsrfToken(t)}return Promise.resolve()};a.prototype.onTokenFetched=function(t,e){this._setCsrfModelValue(t,e)};a.prototype.setHost=function(t){this._oHost=t};a.prototype.isExpiredToken=function(t){if(!t){return false}var e=t.headers.get(s);return e&&e.toLowerCase()==="required"&&t.status===403};a.prototype.replacePlaceholders=function(t){if(!t){return t}if(Array.isArray(t)){return t.map(t=>this.replacePlaceholders(t))}if(e(t)){const e={};for(const o in t){e[o]=this.replacePlaceholders(t[o])}return e}if(typeof t==="string"){const e=this._mTokens.get(this._getTokenName(t));if(e){return t.replace(i,e.value)}}return t};a.prototype._requestToken=function(t){if(!t){return Promise.reject("CSRF definition is incorrect")}const e=this._oDataProviderFactory.create(t);const o=e.getData().then(o=>{var n,i;if(t.path){i=new r(o);n=i.getProperty(t.path);i.destroy()}else{n=e.getLastResponse().headers.get(s)}return n}).catch(function(){throw"CSRF token cannot be resolved"});if(this._oHost){this._oHost.csrfTokenFetched(t,o)}return o};a.prototype.markExpiredTokenByRequest=function(t){const e=this._findTokenName(t);if(!e){return}this._mTokens.get(e).markExpired();if(this._oHost){this._oHost.csrfTokenExpired(this._getTokenConfig(e))}};a.prototype._getTokenConfig=function(t){return this._oConfiguration[t]};a.prototype._setCsrfModelValue=function(t,e){this._oModel.setProperty(`/${t}`,{value:e})};a.prototype._findTokenName=function(t){var o,r,n;for(r in t){o=t[r];if(typeof o==="string"){n=this._getTokenName(o);if(n){return n}}if(e(o)){o=this._findTokenName(o);if(o){return o}}}return null};a.prototype._getTokenName=function(t){const e=/\{csrfTokens\>\/([^\/]*).*}/;let o=t.match(e);if(!o){o=t.match(i);if(!o){return""}}return o[1]};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/DataProvider", ["sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/Measurement"],function(t,e,i,a,n,r){"use strict";var s=e.extend("sap.ui.integration.util.DataProvider",{metadata:{library:"sap.ui.integration",properties:{configuration:{type:"object"},configurationJson:{type:"string"},baseRuntimeUrl:{type:"string"}},events:{dataRequested:{parameters:{}},dataChanged:{parameters:{data:{type:"object"}}},error:{parameters:{message:{type:"string"}}}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}}});s.prototype.init=function(){this._iCurrentRequestNumber=0;this._oDependencies=new Set};s.prototype.setDestinations=function(t){this._oDestinations=t};s.prototype.setCsrfTokenHandler=function(t){this._oCsrfTokenHandler=t};s.prototype.addDependency=function(t){this._oDependencies.add(t)};s.prototype.setConfigurationJson=function(t){this.setProperty("configurationJson",t);if(this._bActive){this._scheduleDataUpdate(0)}};s.prototype.getResolvedConfiguration=function(){if(this.getConfigurationJson()){return JSON.parse(this.getConfigurationJson())}return this.getConfiguration()};s.prototype._getRuntimeUrl=function(t){if(t.startsWith("http://")||t.startsWith("https://")||t.startsWith("//")){return t}var e=t&&t.trim().replace(/^\//,"");return this.getBaseRuntimeUrl()+e};s.prototype.triggerDataUpdate=function(){var t,e;this.fireDataRequested();t=this._waitDependencies();e=t.then(this._triggerDataUpdate.bind(this));if(!this._pInitialRequestPromise){this._pInitialRequestPromise=e}e.catch(t=>{this.fireError({message:t})});return e};s.prototype._triggerDataUpdate=function(){var t=this.getCard(),e;this._bActive=true;this._iCurrentRequestNumber++;const i=this._iCurrentRequestNumber;if(t){e="UI5 Integration Cards "+t+" "+this.getId()+" getData#"+this._iCurrentRequestNumber;r.start(e,this.getDetails())}return this.getData().then(function(a){if(t){r.end(e)}if(i===this._iCurrentRequestNumber){this.fireDataChanged({data:a});this.onDataRequestComplete()}}.bind(this)).catch(function(i){if(t){r.end(e)}if(Array.isArray(i)&&i.length>0){this.fireError({message:i[0],response:i[1],responseText:i[2],settings:i[3]})}else{this.fireError({message:i})}this.onDataRequestComplete()}.bind(this))};s.prototype.getData=function(){const t=this.getResolvedConfiguration();return new Promise(function(e,i){if(t.json){e(t.json)}else{i("Could not get card data.")}})};s.prototype.destroy=function(){if(this._iIntervalId){clearInterval(this._iIntervalId);this._iIntervalId=null}if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId);this._iDataUpdateCallId=null}e.prototype.destroy.apply(this,arguments)};s.prototype.load=function(){return this._pInitialRequestPromise};s.prototype.onDataRequestComplete=function(){var t;var e=this.getResolvedConfiguration();if(!e||!e.updateInterval){return}t=parseInt(e.updateInterval);if(isNaN(t)){return}this._scheduleDataUpdate(t*1e3)};s.prototype.getCardInstance=function(){return i.getElementById(this.getCard())};s.prototype._scheduleDataUpdate=function(t){if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId)}this._iDataUpdateCallId=setTimeout(this.triggerDataUpdate.bind(this),t)};s.prototype._waitDependencies=function(){const t=[];this._oDependencies.forEach(e=>{if(e instanceof Promise){t.push(e)}else{t.push(e.load())}});return Promise.all(t)};s.prototype.getDetails=function(){return"Static JSON data provided in the manifest."};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/DataProviderFactory", ["sap/ui/base/EventProvider","sap/base/Log","sap/ui/integration/library","sap/ui/integration/util/ServiceDataProvider","sap/ui/integration/util/RequestDataProvider","sap/ui/integration/util/CacheAndRequestDataProvider","sap/ui/integration/util/DataProvider","sap/ui/integration/util/ExtensionDataProvider","sap/ui/integration/util/JSONBindingHelper","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/CsrfTokenHandler","sap/ui/model/json/JSONModel"],function(e,t,i,s,o,n,r,a,d,l,u,f){"use strict";var c=i.CardPreviewMode;var h=e.extend("sap.ui.integration.util.DataProviderFactory",{constructor:function(t){e.call(this);t=t||{};this._oDestinations=t.destinations;this._oExtension=t.extension;this._oCard=t.card;this._oEditor=t.editor;this._oHost=t.host;if(t.csrfTokensConfig){this._oCsrfTokensModel=new f;this._oCsrfTokenHandler=new u({host:t.host,configuration:t.csrfTokensConfig,model:this._oCsrfTokensModel,dataProviderFactory:this})}this._aDataProviders=[];this._aFiltersProviders=[];this._pFilterBarReady=new Promise(e=>{this._oCard?.attachEventOnce("_filterBarReady",e)})}});h.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);if(this._aDataProviders){this._aDataProviders.forEach(function(e){if(!e.bIsDestroyed){e.destroy()}});this._aDataProviders=null;this._aFiltersProviders=null}if(this._oCsrfTokenHandler){this._oCsrfTokenHandler.destroy();this._oCsrfTokenHandler=null}this._oCard=null;this._oExtension=null;this._bIsDestroyed=true};h.prototype.isDestroyed=function(){return this._bIsDestroyed};h.prototype.create=function(e,t,i,d,u){var f=this._oCard;if(!h.isProvidingConfiguration(e)||f&&f.getPreviewMode()===c.Abstract){return null}if(f&&f.getPreviewMode()===c.MockData){e=this._applyMockDataConfiguration(e)}var g=this._oEditor,p=this._oHost||f&&f.getHostInstance()||g&&g.getHostInstance(),_=p&&p.bUseExperimentalCaching,v=this._createDataProviderSettings(e,d),C;if(e.request&&_){C=new n(v);C.setHost(p)}else if(e.request){C=new o(v);if(p){C.setHost(p)}}else if(e.service){C=new s(v)}else if(e.json){C=new r(v)}else if(e.extension){C=new a(v,this._oExtension)}C.setConfiguration(e);if(f){l.propagateModels(f,C)}else if(g){l.propagateModels(g,C)}C.bindObject("/");C.setDestinations(this._oDestinations);if(C.isA("sap.ui.integration.util.IServiceDataProvider")){C.createServiceInstances(t)}this._aDataProviders.push(C);if(this._oCsrfTokenHandler){const t=this._oCsrfTokenHandler.getUsedToken(e);if(t){C.setCsrfTokenHandler(this._oCsrfTokenHandler);C.addDependency(t);C.setModel(this._oCsrfTokensModel,"csrfTokens")}}if(i){this._aFiltersProviders.push(C)}else if(!u&&this._oCard&&this._oCard.getAggregation("_filterBar")){C.addDependency(this._pFilterBarReady)}return C};h.prototype.remove=function(e){var t=this._aDataProviders.indexOf(e);if(t>-1){this._aDataProviders.splice(t,1)}if(e&&!e.bDestroyed&&e._bIsDestroyed){e.destroy()}};h.prototype.setHost=function(e){this._oHost=e;if(this._oCsrfTokenHandler){this._oCsrfTokenHandler.setHost(e)}};h.prototype._createDataProviderSettings=function(e,t){const i={};const s=this._oCard;const o=this._oEditor;if(s){i.baseRuntimeUrl=s.getRuntimeUrl("/");i.card=s;if(!t){i.configurationJson=d.createJsonWithBindingInfos(e,s.getBindingNamespaces())}}else if(o){i.baseRuntimeUrl=o.getRuntimeUrl("/");i.configurationJson=d.createJsonWithBindingInfos(e,o.getBindingNamespaces())}else{i.configurationJson=d.createJsonWithBindingInfos(e,{})}return i};h.prototype._applyMockDataConfiguration=function(e){if(!e.mockData||!h.isProvidingConfiguration(e.mockData)){t.error("There is no mock data configured.","sap.ui.integration.widgets.Card");return null}var i=Object.assign({},e);delete i.request;delete i.service;delete i.json;delete i.extension;return Object.assign(i,e.mockData)};h.isProvidingConfiguration=function(e){return e&&(e.request||e.service||e.json||e.extension)};return h});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/DateRangeHelper", ["sap/m/DynamicDateRange","sap/m/DatePicker","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/BindingHelper","sap/ui/core/date/UI5Date"],function(t,e,a,r,n){"use strict";var o=n.getInstance(-864e13);var s=n.getInstance("1753-01-01");var i=n.getInstance(864e13);var T=n.getInstance("9999-12-31");var l={DATE:"date",TODAY:"today",YESTERDAY:"yesterday",TOMORROW:"tomorrow",DATERANGE:"dateRange",DATETIMERANGE:"dateTimeRange",FROM:"from",TO:"to",FROMDATETIME:"fromDateTime",TODATETIME:"toDateTime",YEARTODATE:"yearToDate",LASTDAYS:"lastDays",LASTWEEKS:"lastWeeks",LASTMONTHS:"lastMonths",LASTQUARTERS:"lastQuarters",LASTYEARS:"lastYears",NEXTDAYS:"nextDays",NEXTWEEKS:"nextWeeks",NEXTMONTHS:"nextMonths",NEXTQUARTERS:"nextQuarters",NEXTYEARS:"nextYears",TODAYFROMTO:"todayFromTo",THISWEEK:"thisWeek",LASTWEEK:"lastWeek",NEXTWEEK:"nextWeek",SPECIFICMONTH:"specificMonth",THISMONTH:"thisMonth",LASTMONTH:"lastMonth",NEXTMONTH:"nextMonth",THISQUARTER:"thisQuarter",LASTQUARTER:"lastQuarter",NEXTQUARTER:"nextQuarter",QUARTER1:"quarter1",QUARTER2:"quarter2",QUARTER3:"quarter3",QUARTER4:"quarter4",THISYEAR:"thisYear",LASTYEAR:"lastYear",NEXTYEAR:"nextYear",DATETIME:"dateTime"};function u(t){return l[t]}function E(t){return t.getFullYear().toString().padStart(4,"0")+"-"+(t.getMonth()+1).toString().padStart(2,"0")+"-"+t.getDate().toString().padStart(2,"0")}var S={};S.createInput=function(a,r,n){var o;var s=a.options.map(function(t){return t.toUpperCase()});if(s.length===1&&s[0]==="DATE"&&n){o=new e({placeholder:a.placeholder})}else{o=new t({standardOptions:s,placeholder:a.placeholder})}S.setValue(o,a.value,r);return o};S.setValue=function(t,e,r){if(!e){return}if(t.isA("sap.m.DatePicker")){if(e.values){e=e.values}t.applySettings({value:e})}else{var o=a.resolveValue(e,r);var s=o.option.toUpperCase();var i=t.getOption(s).getValueTypes();t.setValue({operator:s,values:o.values.map(function(t,e){if(i[e]==="date"||i[e]==="datetime"){return n.getInstance(t)}return t})})}};S.getValueForModel=function(e){var a;var r;var l;var S;if(e.isA("sap.m.DatePicker")&&e.getValue()&&e.isValidValue()){S={operator:"DATE",values:[n.getInstance(e.getValue())]}}else if(e.isA("sap.m.DynamicDateRange")){S=e.getValue()}if(S){a={option:u(S.operator),values:S.values.slice()};var A=t.toDates(S),p=A[0],D=S.operator==="TO"||S.operator==="TODATETIME",g=S.operator==="FROM"||S.operator==="FROMDATETIME",R=D||g?0:1,c=A[R];r={start:p.toISOString(),end:c.toISOString(),startLocalDate:E(p),endLocalDate:E(c)};l={start:p.toISOString(),end:c.toISOString(),startLocalDate:E(p),endLocalDate:E(c)};if(D){r.start=o.toISOString();l.start=s.toISOString();r.startLocalDate=E(o);l.startLocalDate=E(s)}if(g){r.end=i.toISOString();l.end=T.toISOString();r.endLocalDate=E(i);l.endLocalDate=E(T)}}return{value:a,range:r,rangeOData:l}};S.getAllOptions=function(){return l};return S});
/* !
 * ${ copyright }
 */
sap.ui.predefine("sap/ui/integration/util/DelayedLoadingProvider", ["sap/ui/core/Element","sap/ui/base/ManagedObject","sap/ui/integration/util/LoadingProvider"],function(e,a,i){"use strict";var t=i.extend("sap.ui.integration.util.DelayedLoadingProvider",{metadata:{library:"sap.ui.integration",properties:{delayed:{type:"boolean",defaultValue:false}}}});t.prototype.destroy=function(){if(this._iLoadingDelayHandler){clearTimeout(this._iLoadingDelayHandler);this._iLoadingDelayHandler=null}a.prototype.destroy.apply(this,arguments)};t.prototype.applyDelay=function(e){if(!e){return}this.setDelayed(true);this._iLoadingDelayHandler=setTimeout(()=>{this.setDelayed(false)},e)};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Destinations", ["sap/ui/base/Object","sap/base/Log","sap/base/util/isPlainObject","sap/ui/integration/util/Utils"],function(t,e,i,r){"use strict";var n=/\{\{destinations.([^\}]+)/;var o=t.extend("sap.ui.integration.util.Destinations",{metadata:{library:"sap.ui.integration"},constructor:function(e){t.call(this);this._oHost=e.host;this._oCard=e.card;this._oConfiguration=e.manifestConfig;this._mResolved=new Map}});o.prototype.setHost=function(t){this._oHost=t;this._mResolved.clear()};o.prototype.process=function(t){var i=[];this._processObject(t,undefined,i);return Promise.all(i).then(function(){return t}).catch(function(i){e.error(i,"sap.ui.integration.util.Destinations");return t})};o.prototype._processObject=function(t,r,n){if(!t){return Promise.resolve(t)}var o=t.hasOwnProperty(r)?t[r]:t;if(typeof o==="string"){n.push(this.processString(o).then(function(e){if(r!==undefined){t[r]=e}}).catch(function(i){e.error(i,"sap.ui.integration.util.Destinations");if(r!==undefined){t[r]=""}}))}if(i(o)){Object.keys(o).forEach(function(t){this._processObject(o,t,n)}.bind(this))}if(Array.isArray(o)){o.forEach(function(t,e){this._processObject(o,e,n)}.bind(this))}};o.prototype.getUrl=function(t){var e;if(this._mResolved.has(t)){return this._mResolved.get(t)}e=this._resolveUrl(t);this._mResolved.set(t,e);return e};o.prototype._resolveUrl=function(t){var i=this._oConfiguration?this._oConfiguration[t]:null,n,o,s;if(!i){return Promise.reject("Configuration for destination '"+t+"' was not found in the manifest.")}n=i.name;o=i.defaultUrl;if(!n&&!o){return Promise.reject("Can not resolve destination '"+t+"'. Neither 'name' nor 'defaultUrl' is configured.")}if(!n&&o){return Promise.resolve(o)}if(!this._oHost&&!o){return Promise.reject("Can not resolve destination '"+t+"'. There is no 'host' and no defaultUrl specified.")}if(!this._oHost&&o){return Promise.resolve(o)}s=r.timeoutPromise(this._oHost.getDestination(n,this._oCard));if(o){return s.catch(function(t){e.info(t+" Fallback to default url.","sap.ui.integration.util.Destinations");return o})}return s};o.prototype.hasDestination=function(t){return!!t.match(n)};o.prototype.processString=function(t){var e=t.match(n),i;if(!e){return Promise.resolve(t)}i=e[1];return this.getUrl(i).then(function(e){return this._replaceUrl(t,i,e)}.bind(this))};o.prototype._replaceUrl=function(t,e,i){var r=i.trim().replace(/\/$/,"");return t.replace("{{destinations."+e+"}}",r)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/DisplayVariants", ["sap/ui/integration/library","sap/ui/base/Object","sap/ui/model/json/JSONModel","sap/base/util/deepEqual"],function(e,t,r,a){"use strict";const i=16*11;const n=["large","standard","small","standardHeader","smallHeader","compactHeader","extraWide","wide","regular","narrow","tiny"];const s={tiny:[20,1*i],narrow:[1*i,2*i],regular:[2*i,4*i],wide:[4*i,6*i],extraWide:[6*i,1e4]};const o=e.CardDisplayVariant;const d=t.extend("sap.ui.integration.util.DisplayVariants",{metadata:{library:"sap.ui.integration"},constructor:function(e){t.call(this);this._oCard=e;e.addEventDelegate({onAfterRendering:this._observeWidth},this)}});d.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this._oWidthObserver=null};d.prototype.updateSizeModel=function(e){const t=this._oCard;if(!t.getDomRef()){return}const r=t.getModel("size");const i=t.getDisplayVariant();e=e||t.getDomRef().offsetWidth;const n=r.getData();const s={tiny:true,narrow:d.determineSize("narrow",e),regular:d.determineSize("regular",e),wide:d.determineSize("wide",e),extraWide:d.determineSize("extraWide",e),compactHeader:i===o.CompactHeader,smallHeader:i===o.SmallHeader,standardHeader:i===o.StandardHeader,small:i===o.Small,standard:i===o.Standard,large:i===o.Large,variant:i};r.setData(s);if(!a(s,n)&&t.getUseProgressiveDisclosure()){t.refresh()}};d.prototype.getInitialSizeModel=function(){return new r({tiny:true,narrow:true,regular:true,wide:false,extraWide:false,compactHeader:false,smallHeader:false,standardHeader:false,small:false,standard:true,large:false,variant:o.Standard})};d.prototype.sizeFormatter=function(e){const t=this._oCard;const r=t.getModel("size");if(!e){return e}if(typeof e==="string"){return r.getProperty("/"+e)}if(typeof e==="object"){let t=null;n.some(a=>{if(r.getProperty("/"+a)&&e[a]!==undefined){t=e[a];return true}return false});return t}return null};d.prototype._observeWidth=function(){const e=this._oCard;const t=e.getDomRef();if(!t){return}if(this._oWidthObserver){this._oWidthObserver.unobserve(t)}this._oWidthObserver=new ResizeObserver(e=>{const t=e[0];const r=t.contentRect.width;this.updateSizeModel(r)});this._oWidthObserver.observe(t)};d.determineSize=function(e,t){if(t>=s[e][0]){return true}return false};return d});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Duration", ["sap/base/Log","sap/base/strings/formatMessage"],function(r,a){"use strict";var t=/(\d+Y)?(\d+M)?(\d+W)?(\d+D)?/;var e=/(?:T(?=.)(\d+H)?(\d+M)?(\d+S)?)?/;var n=new RegExp("^P(?=.)"+t.source+e.source+"$");var i={};i._INVALID_DURATION="Invalid duration: {0}";i._UNSUPPORTED_DATE="Duration {0} contains unsupported date part";i._UNSUPPORTED_SECONDS="Duration {0} contains unsupported seconds part";i._MINUTES_OUT_OF_RANGE="Minutes of duration {0} are out of supported range [0-59]";i._HOURS_OUT_OF_RANGE="Hours of duration {0} are out of supported range [0-24]";i.fromISO=function(t){if(!t){return""}var e=n.exec(t);if(!e){r.error(a(i._INVALID_DURATION,t),"sap.ui.integration.widgets.Card");return""}var o=e[1];var s=e[2];var u=e[3];var d=e[4];var _=e[5];var p=e[6];var O=e[7];if(o||s||u||d){r.error(a(i._UNSUPPORTED_DATE,t),"sap.ui.integration.widgets.Card");return""}if(O){r.error(a(i._UNSUPPORTED_SECONDS,t),"sap.ui.integration.widgets.Card");return""}var f=_?parseInt(_):0;var v=p?parseInt(p):0;if(f>24){r.error(a(i._HOURS_OUT_OF_RANGE,t),"sap.ui.integration.widgets.Card");return""}if(v>59){r.error(a(i._MINUTES_OUT_OF_RANGE,t),"sap.ui.integration.widgets.Card");return""}return f+":"+v.toString().padStart(2,"0")};i.toISO=function(r){var a=r.split(":");var t=parseInt(a[0]);var e=parseInt(a[1]);var n="PT";if(t){n+=t+"H"}if(e){n+=e+"M"}if(!t&&!e){n+="0S"}return n};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ErrorHandler", ["./Utils","../library","sap/m/IllustratedMessageType","sap/ui/base/BindingParser"],function(e,t,r,a){"use strict";var s=t.CardBlockingMessageType;function n(e){return a.complexParser.escape(JSON.stringify(e,null,4))}function T(e){if(e.options){e.options.body=e.body&&e.body.toString();e.options.headers=Object.fromEntries(e.options.headers)}return n(e)}var R={};R.configureDataRequestErrorInfo=function(t,R){var E=t.requestErrorParams.response,o=t.requestErrorParams.responseText,i=r.ErrorScreen,_=R.getTranslatedText("CARD_ERROR_CONFIGURATION_TITLE"),l=R.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION"),d=t.requestSettings,u=d.request?d.request.url:"",S=R.getTranslatedText("CARD_ERROR_REQUEST_DETAILS",[u]);if(E){_=E.status+" "+E.statusText;l=R.getTranslatedText("CARD_ERROR_REQUEST_DESCRIPTION");switch(E.status){case 0:switch(E.statusText){case"timeout":i=r.ReloadScreen;_="408 "+R.getTranslatedText("CARD_ERROR_REQUEST_TIMEOUT_TITLE");S=R.getTranslatedText("CARD_ERROR_REQUEST_TIMEOUT_DETAILS",[u]);break;default:i=r.PageNotFound;_="404 "+R.getTranslatedText("CARD_ERROR_REQUEST_NOTFOUND_TITLE");break}break;case 404:i=r.PageNotFound;if(!E.statusText){_="404 "+R.getTranslatedText("CARD_ERROR_REQUEST_NOTFOUND_TITLE")}break;case 408:i=r.ReloadScreen;S=R.getTranslatedText("CARD_ERROR_REQUEST_TIMEOUT_DETAILS",[u]);break;case 401:case 403:case 511:l=R.getTranslatedText("CARD_ERROR_REQUEST_ACCESS_DENIED_DESCRIPTION");break;default:break}}S=_+"\n"+l+"\n"+S+"\n\n";S+=R.getTranslatedText("CARD_LOG_MSG")+"\n"+(E?E.statusText:t.requestErrorParams.message)+"\n\n";S+=R.getTranslatedText("CARD_REQUEST_SETTINGS")+"\n"+n(d)+"\n\n";if(E){S+=R.getTranslatedText("CARD_REQUEST")+"\n"+T(t.requestErrorParams.settings)+"\n\n"+R.getTranslatedText("CARD_RESPONSE_HEADERS")+"\n"+n(Object.fromEntries(E.headers))+"\n\n"}if(E&&o){S+=R.getTranslatedText("CARD_RESPONSE")+"\n";if(e.isJson(o)){S+=n(JSON.parse(o))}else{S+=a.complexParser.escape(o)}S+="\n\n"}S+=R.getTranslatedText("CARD_MANIFEST")+"\n"+n(R._oCardManifest.getJson())+"\n\n";S+=R.getTranslatedText("CARD_STACK_TRACE")+"\n"+(new Error).stack;return{type:s.Error,illustrationType:i,title:_,description:l,details:S,httpResponse:E}};R.configureErrorInfo=function(e,t){var r=t.getTranslatedText("CARD_MANIFEST")+"\n"+n(t._oCardManifest.getJson())+"\n\n"+t.getTranslatedText("CARD_STACK_TRACE")+"\n"+(e.originalError?e.originalError.stack:(new Error).stack);return{type:s.Error,illustrationType:e.illustrationType,title:e.title,description:e.description,details:r}};return R});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ExtensionDataProvider", ["sap/ui/integration/util/DataProvider"],function(t){"use strict";var e=t.extend("sap.ui.integration.util.ExtensionDataProvider",{metadata:{library:"sap.ui.integration"},constructor:function(e,o){t.call(this,e);this._oExtension=o}});e.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this._oExtension=null};e.prototype.getData=function(){const t=this.getResolvedConfiguration().extension;if(!this._oExtension){return Promise.reject("The extension module is not loaded properly or doesn't export a correct value.")}if(!this._oExtension[t.method]){return Promise.reject("Extension doesn't implement "+t.method+" method.")}return this._oExtension[t.method].apply(this._oExtension,t.args)};e.prototype.getDetails=function(){return"Load data from Extension. Method: "+this.getResolvedConfiguration().extension.method};return e});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Form", ["sap/ui/base/ManagedObject","sap/ui/core/Lib","sap/ui/core/library","sap/base/Log","sap/base/util/deepExtend","./Validators","./BindingHelper","./BindingResolver","./DateRangeHelper","./Duration","./ComboBoxHelper"],function(e,t,r,o,i,a,n,s,l,u,d){"use strict";var p=r.ValueState;var f=e.extend("sap.ui.integration.util.Form",{constructor:function(t){e.apply(this);this._oCard=t},metadata:{library:"sap.ui.integration"}});f.prototype.init=function(){this._mControls=new Map};f.prototype.exit=function(){this._mControls.clear();delete this._mControls;delete this._oCard};f.prototype.addControl=function(e,t,r,o){if(!this._isValidControlId(r.id)){return}this._syncToFormModelOn(e,t,r,o)};f.prototype.validate=function(e,t){var r=false;this._mControls.forEach(function(t){if(this._validateControl(t,e)){r=true}}.bind(this));if(r&&!t){this._oCard.scheduleFireStateChanged()}};f.prototype.resolveControl=function(e){var t={},r=this.getModel("form").getProperty("/"+e.id),o=this.getModel("messages").getProperty("/records"),i=o.find(function(t){return t.bindingPath==="/"+e.id}),a=this._mControls.get(e.id);if(i&&(a&&a._bShowValueState)){t.valueState={message:i.message,type:i.type}}switch(e.type){case"ComboBox":t.selectedKey=r.key;r=r.value;break;case"DateRange":r=r.value;break;default:break}t.value=r;return t};f.prototype.setControlValue=function(e){if(!this._isControlDataValid(e)){return}var t=e.id,r=this._mControls.get(t),o=e.value;if(r.isA("sap.m.ComboBox")){d.setValueAndKey(r,e.key,e.value)}else if(o){if(r.isA("sap.m.DatePicker")||r.isA("sap.m.DynamicDateRange")){l.setValue(r,o,this._oCard)}else if(r.isA("sap.m.TimePicker")){r.setValue(u.fromISO(o))}else{r.setValue(o)}}this._validateAndUpdate(r)};f.prototype.updateModel=function(){this._mControls.forEach(this._updateModel.bind(this))};f.prototype._isValidControlId=function(e){if(!e){o.error("Each input control must have an ID.","sap.ui.integration.widgets.Card");return false}if(this._mControls.has(e)){o.error("Duplicate form control ID - '"+e+"'","sap.ui.integration.widgets.Card");return false}return true};f.prototype._syncToFormModelOn=function(e,t,r,o){this._prepareValidationForControl(t,r,o);t.attachEvent(e,this._validateAndUpdate,this);if(r.value&&!n.isBindingInfo(r.value)){this._updateModel(t)}this._mControls.set(r.id,t)};f.prototype._updateModel=function(e){this.getModel("form").setProperty("/"+e._oItem.id,c(e))};f.prototype._validateAndUpdate=function(e){var t=e.getSource?e.getSource():e;this._validateControl(t,true);this._updateModel(t);this._oCard.scheduleFireStateChanged()};f.prototype._isControlDataValid=function(e){if(!e){return false}var t=e.id;if(!t){o.error("Form control data is missing property 'id'.","sap.ui.integration.widgets.Card");return false}var r=this._mControls.get(t);if(!r){o.error("Form control with ID - '"+t+"' does not exist.","sap.ui.integration.widgets.Card");return false}if(r.isA(["sap.m.TextArea","sap.m.Input"])&&!("value"in e)){o.error("Form data for control ID - '"+t+"' is missing property 'value'.","sap.ui.integration.widgets.Card");return false}if(r.isA("sap.m.ComboBox")){if("value"in e||"key"in e){return true}o.error("Form data for control ID - '"+t+"' requires properties 'key' or 'value'.","sap.ui.integration.widgets.Card");return false}return true};f.prototype._prepareValidationForControl=function(e,t,r){var o=i({},t);if(o.validations){o.validations.forEach(function(e,t){if(e.pattern){e.pattern=this._oCard.getManifestEntry(r+"/validations/"+t)["pattern"]}}.bind(this))}e._oItem=o};f.prototype._validateControl=function(e,t){var r=this._oCard.getAggregation("_extension"),o=e._oItem,i=e.getBindingContext(),a=i?i.getPath():"",n=false,l;this._removeMessageFromControl(e);if(!o){return n}n=!this._checkBuiltInValidations(e,o,t);if(!n&&o.validations){l=s.resolveValue(o.validations,e,a);n=!l.every(function(i){return this._checkValidationItem(i,e,o,t,r)}.bind(this))}this._updateMessageModel();return n};f.prototype._checkValidationItem=function(e,t,r,o,i){var n=a[this._getFormControlType(r)],s,l,u,d,f=true;for(var g in e){s=e[g];if(g==="validate"){u=this._getExtensionFunctionName(s,i);if(u){d=i[u]}}else{d=n[g]}if(typeof d!=="function"){continue}l=d(c(t),s);if(!l){this._addMessageToControl(t,o,{type:e.type||p.Error,message:e.message||this._oCard.getTranslatedText(n[g+"Txt"],[s]),bindingPath:"/"+r.id});f=false;break}}return f};f.prototype._checkBuiltInValidations=function(e,r,o){var i=true;if(e.isA("sap.m.DatePicker")&&!e.isValidValue()){this._addMessageToControl(e,o,{type:p.Error,message:t.getResourceBundleFor("sap.ui.core").getText("VALUE_STATE_ERROR"),bindingPath:"/"+r.id});i=false}return i};f.prototype._addMessageToControl=function(e,t,r){var o=this.getModel("messages"),i=o.getData();i.records.push(r);o.setData(i);if(t||e._bShowValueState){e._bShowValueState=true;e.setValueState(r.type);e.setValueStateText(r.message)}this._updateMessageModel()};f.prototype._removeMessageFromControl=function(e){var t=this.getModel("messages"),r="/"+e._oItem.id,o=t.getData(),i=false;e.setValueState(p.None);for(var a=0;a<o.records.length;a++){if(o.records[a].bindingPath===r){o.records.splice(a,1);i=true;break}}if(i){t.setData(o)}this._updateMessageModel()};f.prototype._updateMessageModel=function(){var e=this.getModel("messages"),t=e.getProperty("/records");e.setProperty("/hasErrors",t.some(function(e){return e.type===p.Error}));e.setProperty("/hasWarnings",t.some(function(e){return e.type===p.Warning}))};f.prototype.getRequiredValidationValue=function(e){var t=e.validations||[],r,o,i;for(o=0;o<t.length;o++){r=t[o];for(i in r){if(i==="required"){return r[i]}}}return false};f.prototype._getExtensionFunctionName=function(e,t){if(!e.startsWith("extension.")){o.error("Validation function should start with 'extension'.");return false}if(!t){o.error("Extension is not defined.");return false}var r=e.replace("extension.","");if(!t[r]){o.error("No such function.",r,"sap.ui.integration.widgets.Card");return false}return r};f.prototype._getFormControlType=function(e){switch(e.type){case"ComboBox":return"keyValuePair";case"DateRange":return"dateRange";default:return"string"}};function c(e){if(e.isA("sap.m.ComboBox")){e.synchronizeSelection();return{key:e.getSelectedKey(),value:e.getValue()}}else if(e.isA("sap.m.DynamicDateRange")||e.isA("sap.m.DatePicker")){return l.getValueForModel(e)}else if(e.isA("sap.m.TimePicker")){return u.toISO(e.getValue())}else{return e.getValue()}}return f});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/HeaderFactory", ["./BaseFactory","sap/base/Log","sap/base/util/isEmptyObject","sap/ui/core/Lib","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/cards/actions/NavigationAction","sap/ui/integration/library","sap/m/library","sap/ui/integration/cards/NumericHeader","sap/ui/integration/cards/Header","sap/ui/integration/controls/HeaderInfoSectionRow","sap/ui/integration/controls/HeaderInfoSectionColumn","sap/ui/integration/util/Utils","sap/m/Button","./ObjectStatusFactory","sap/m/AvatarImageFitType","sap/f/library"],function(t,e,a,i,s,r,n,o,c,u,p,l,f,d,y,m,g){"use strict";var S=n.CardActionArea;var h=n.CardActionType;var T=n.CardDisplayVariant;var b=g.cards.SemanticRole;var _=t.extend("sap.ui.integration.util.HeaderFactory");_.prototype.create=function(t,i){if(a(t)){e.warning("Card sap.card/header entry in the manifest is mandatory","sap.ui.integration.widgets.Card");return null}var r=this._oCard,n=r.getId()+"-header",o=r.getOpener(),p,l;t=this.createBindingInfos(t,r.getBindingNamespaces());if(r.isCompactHeader()){t.type=""}switch(t.type){case"Numeric":l=c.create(n,t,i,r._oIconFormatter);break;default:l=u.create(n,t,i,r._oIconFormatter);break}l.setCard(r);if(t.status&&t.status.text&&t.status.text.format){p=f.getStatusTextBindingInfo(t.status.text.format,l);if(p){l.bindProperty("statusText",p)}}l.setServiceManager(r._oServiceManager);l.setDataProviderFactory(r._oDataProviderFactory);l._setDataConfiguration(t.data);if(r.isTileDisplayVariant()){this._setTileDisplayDefaults(l,t)}else if(r.isHeaderDisplayVariant()){this._setHeaderDisplayDefaults(l,t)}var d=new s({card:r});d.attach({area:S.Header,enabledPropertyName:"interactive",actions:t.actions,control:l});l._oActions=d;if(o){l.setProperty("focusable",false);l.setProperty("headingLevel","1")}if(r.getSemanticRole()===b.ListItem&&!l.isInteractive()){l.setProperty("focusable",false)}l.applySettings({infoSection:_._createInfoSection(t)});return l};_.prototype._setTileDisplayDefaults=function(t,e){t.setProperty("useTileLayout",true);t.setProperty("useTooltips",true);const a=this._oCard;const i=[T.TileFlat,T.TileFlatWide].indexOf(a.getDisplayVariant())>-1;if(!e.titleMaxLines){t.setTitleMaxLines(i?1:2)}if(!e.icon?.fitType){t.setIconFitType(m.Contain)}if(i){t.setIconSize("XS");if(t.isA("sap.f.cards.NumericHeader")){t.setNumberSize("S")}if(!e.subtitleMaxLines){t.setSubtitleMaxLines(1)}}if(t.isA("sap.f.cards.NumericHeader")){t.getSideIndicators().forEach(t=>{t.setProperty("useTooltips",true)})}const s=e.actions&&e.actions[0];const n=s?.parameters?.url;const o=s?.parameters?.target;if(s?.type===h.Navigation&&n){t.applySettings({href:n,target:o||r.DEFAULT_TARGET,interactive:true})}};_.prototype._setHeaderDisplayDefaults=function(t,e){const a=this._oCard;t.setProperty("useTooltips",true);if(a.isCompactHeader()){t.setProperty("useTooltips",true);t.setIconSize("XS");t.setTitleMaxLines(1);t.setSubtitleMaxLines(1);t.setStatusVisible(false);return}const i=a.isSmallHeader();if(!e.titleMaxLines){t.setTitleMaxLines(i?1:2)}if(i){if(t.isA("sap.f.cards.NumericHeader")){t.setIconSize("XS");t.setNumberSize("S")}if(!e.subtitleMaxLines){t.setSubtitleMaxLines(1)}}if(t.isA("sap.f.cards.NumericHeader")){t.getSideIndicators().forEach(t=>{t.setProperty("useTooltips",true)})}};_._createInfoSection=function(t){const e=[];const a=t.infoSection;(a?.rows||[]).forEach(t=>{e.push(_._createRow(t))});return e};_._createRow=function(t){const e=[];const a=[];(t.items||[]).forEach(t=>{e.push(y.createStatusItem(t))});(t.columns||[]).forEach(t=>{a.push(_._createColumn(t))});return new p({justifyContent:t.justifyContent,columns:a,items:e})};_._createColumn=function(t){const e=[];const a=[];(t.items||[]).forEach(t=>{e.push(y.createStatusItem(t))});(t.rows||[]).forEach(t=>{a.push(_._createRow(t))});return new l({rows:a,items:e})};return _});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/JSONBindingHelper", ["sap/ui/base/BindingParser","sap/ui/integration/util/BindingHelper"],function(n,i){"use strict";var e=[["ESCAPED_BINDING_START",/\\{/g,"\\{"],["ESCAPED_BINDING_END",/\\}/g,"\\}"],["BINDING_START",/{/g,"{"],["BINDING_END",/}/g,"}"]];var r={};r.createJsonWithBindingInfos=function(n,e){if(!n){return n}var r=this._createBindableJson(n),t=i.createBindingInfos(r,e);if(typeof t==="string"){t=this._escape(t)}return t};r._createBindableJson=function(n){var i;i=JSON.stringify(n,function(n,i){if(typeof i==="string"){return this._encodeBindingString(i)}return i}.bind(this));i=this._escape(i);i=this._decodeBindingString(i);return i};r._escape=function(i){return n.complexParser.escape(i)};r._encodeBindingString=function(n){e.forEach(function(i){var e=i[0],r=i[1];n=n.replace(r,e)});return n};r._decodeBindingString=function(n){e.forEach(function(i){var e=i[0],r=i[2];n=n.replace(new RegExp(e,"g"),r)});return n};return r});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/LoadingProvider", ["sap/ui/core/Element"],function(t){"use strict";var i=t.extend("sap.ui.integration.util.LoadingProvider",{metadata:{library:"sap.ui.integration",properties:{loading:{type:"boolean",defaultValue:false}}}});i.prototype.setLoading=function(t){if(this._bAwaitPagination&&!t){return this}return this.setProperty("loading",t)};i.prototype.setAwaitPagination=function(t){this._bAwaitPagination=t};i.prototype.getAwaitPagination=function(){return this._bAwaitPagination};return i});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Manifest", ["sap/ui/base/Object","sap/base/util/LoaderExtensions","sap/ui/core/Manifest","sap/base/util/deepClone","sap/base/util/deepExtend","sap/base/util/each","sap/base/util/isPlainObject","sap/base/util/isEmptyObject","sap/base/util/merge","sap/base/Log","./ParameterMap","sap/ui/integration/util/CardMerger"],function(e,t,s,i,r,n,o,a,f,u,c,p){"use strict";var h="/{SECTION}/configuration/parameters",l="/{SECTION}/configuration/filters",d="/{SECTION}",g="/sap.app/dataSources",y=/\{\{(?!parameters.)(?!destinations.)(?!csrfTokens.)([^\}\}]+)\}\}|\{i18n>([^\}]+)\}/g;var b=e.extend("sap.ui.integration.util.Manifest",{constructor:function(t,r,n,o){e.call(this);this._sBaseUrl=n;this._aChanges=o;this._sSection=t;this.PARAMETERS=h.replace("{SECTION}",t);this.FILTERS=l.replace("{SECTION}",t);this.CONFIGURATION=d.replace("{SECTION}",t);if(r){var a={},f;a.process=false;this._oInitialJson=i(r,500);if(n){a.baseUrl=n}else{a.baseUrl="/";u.info("Property baseUrl is not provided and manifest URL is unknown. Relative resources may not be loaded correctly.","sap.ui.integration.widgets.Card")}this._registerManifestModulePath(r,n||"/");if(this._aChanges){f=this.mergeDeltaChanges(r)}else{f=r}this._oManifest=new s(f,a);this.oJson=this._oManifest.getRawJson()}}});b.prototype.mergeDeltaChanges=function(e){return p.mergeCardDelta(e,this._aChanges,this._sSection)};b.prototype.getJson=function(){return this._unfreeze(this.oJson)};b.prototype.getProcessableJson=function(){const e=r({},this._oManifest.getRawJson());if(e["sap.card"]?.type==="AdaptiveCard"){delete e["sap.card"].content}return this._unfreeze(e)};b.prototype.setJson=function(e){_(e);this.oJson=e};b.prototype.getInitialJson=function(){return this._oInitialJson};b.prototype.get=function(e){return this._unfreeze(O(this.oJson,e))};b.prototype.getUrl=function(){return this._oManifest.resolveUri("./","manifest")};b.prototype.getResourceBundle=function(){return this.oResourceBundle};b.prototype._unfreeze=function(e){if(typeof e==="object"){return JSON.parse(JSON.stringify(e))}return e};b.prototype.destroy=function(){this.oJson=null;this.oResourceBundle=null;if(this._oManifest){this._oManifest.destroy()}this._bIsDestroyed=true};b.prototype.isDestroyed=function(){return this._bIsDestroyed};b.prototype.load=function(e){if(!e||!e.manifestUrl){if(this._oManifest){return this.loadI18n().then(function(){this.processManifest()}.bind(this))}return new Promise(function(e){e()})}return s.load({manifestUrl:e.manifestUrl,async:true,processJson:function(t){var s=this._sBaseUrl||e.manifestUrl.replace(/\/+[^\/]*$/,"")||"/";this._registerManifestModulePath(t,s);this._oInitialJson=i(t,500);if(this._aChanges){return this.mergeDeltaChanges(t)}return t}.bind(this)}).then(function(e){this._oManifest=e;this.oJson=this._oManifest.getRawJson();return this.loadI18n().then(function(){this.processManifest()}.bind(this))}.bind(this))};b.prototype.loadDependenciesAndIncludes=function(){return this._oManifest.loadDependenciesAndIncludes(true)};b.prototype.loadI18n=function(){var e=false;s.processObject(this.getProcessableJson(),function(t,s,i){if(!e&&i.match(y)){e=true}});if(this.get("/sap.app/i18n")){e=true}if(!e){return Promise.resolve()}return this._oManifest._loadI18n(true).then(function(e){this.oResourceBundle=e}.bind(this))};b.prototype.processManifest=function(){var e=0,t=15,s=this.getProcessableJson(),i=this.get(g);M(s,this.oResourceBundle,e,t,this._oCombinedParams,i,this._oCombinedFilters);this.setJson(f(this.getJson(),s))};function _(e){if(e&&typeof e==="object"&&!Object.isFrozen(e)){Object.freeze(e);for(var t in e){if(e.hasOwnProperty(t)){_(e[t])}}}}function m(e){return typeof e==="string"&&e.match(y)&&e.indexOf("{{")===0&&e.indexOf("}}")===e.length-2}function P(e){return typeof e==="string"&&(e.indexOf("{{parameters.")>-1||e.indexOf("{{dataSources")>-1||e.indexOf("{{filters.")>-1)}b._processPlaceholder=function(e,t,s,i){var r=c.processPredefinedParameter(e),n,o;if(!a(t)){for(var f in t){n=t[f].value;o="{{parameters."+f;r=v(r,n,o)}}if(s){r=v(r,s,"{{dataSources")}if(i){r=v(r,i,"{{filters")}return r};function v(e,t,s){if(o(t)||Array.isArray(t)){for(var i in t){e=v(e,t[i],s+"."+i)}}else if(e.includes(s+"}}")){e=e.replace(new RegExp(s+"}}","g"),t)}return e}function M(e,t,s,i,r,n,o){if(s===i){return}if(Array.isArray(e)){e.forEach(function(e,a,f){if(typeof e==="object"){M(e,t,s+1,i,r,n,o)}else if(P(e)){f[a]=b._processPlaceholder(e,r,n,o)}else if(m(e)&&t){f[a]=t.getText(e.substring(2,e.length-2))}},this)}else{for(var a in e){if(typeof e[a]==="object"){M(e[a],t,s+1,i,r,n,o)}else if(P(e[a])){e[a]=b._processPlaceholder(e[a],r,n,o)}else if(m(e[a])&&t){e[a]=t.getText(e[a].substring(2,e[a].length-2))}}}}function O(e,t){if(t==="/"){return e}if(e&&t&&typeof t==="string"&&t[0]==="/"){var s=t.substring(1).split("/"),i;for(var r=0,n=s.length;r<n;r++){i=s[r];e=e.hasOwnProperty(i)?e[i]:undefined;if(e===null||typeof e!=="object"){if(r+1<n&&e!==undefined){e=undefined}break}}return e}return e&&e[t]}b.prototype.processFilters=function(e){if(!this._oManifest){return}var t=this.get(this.FILTERS),s={};if(e.size&&!t){u.error("If runtime filters are set, they have to be defined in the manifest configuration as well.");return}n(t,function(t,i){var r=e.get(t)||i.value;s[t]=r});this._oCombinedFilters=s;this.processManifest()};b.prototype.processParameters=function(e){if(!this._oManifest){return}var t=this.get(this.PARAMETERS);if(!a(e)&&!t){u.error("If parameters property is set, parameters should be described in the manifest");return}this._oCombinedParams=this._syncParameters(e,t);this.processManifest()};b.prototype.getProcessedParameters=function(e){var t=this.get(this.PARAMETERS),s=this._syncParameters(e,t);M(s,this.oResourceBundle,0,15,e);return s};b.prototype._syncParameters=function(e,t){if(a(e)){return t}var s=i(t||{},500),r=Object.getOwnPropertyNames(e),n=Object.getOwnPropertyNames(s);for(var o=0;o<n.length;o++){for(var f=0;f<r.length;f++){if(n[o]===r[f]){s[n[o]].value=e[r[f]]}}}return s};b.prototype.findDataSections=function(e){var t=[],s;if(!e){e=this.get(this.CONFIGURATION)}if(!o(e)){return[]}if(e.data){t.push(e.data)}for(s in e){if(e[s]){t=t.concat(this.findDataSections(e[s]))}}return t};b.prototype._registerManifestModulePath=function(e,s){var i=e&&e["sap.app"]&&e["sap.app"].id;if(!i){return}t.registerResourcePath(i.replace(/\./g,"/"),s)};return b});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ManifestResolver", ["sap/ui/core/Lib","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/Utils","sap/m/IllustratedMessageType","sap/m/IllustratedMessageSize","sap/base/Log"],function(e,t,r,n,a,i,o){"use strict";var s={};s.resolveCard=function(e){e.startManifestProcessing();return s._awaitReadyEvent(e).then(function(){return e.getModel("context").waitForPendingProperties()}).then(function(){return s._handleCardReady(e)}).catch(function(t){return s._handleCardSevereError(e,t)})};s._awaitReadyEvent=function(e){if(e.isReady()){return Promise.resolve(e)}return new Promise(function(t,r){e.attachEvent("_ready",function(r){t(e)})})};s._handleCardReady=function(e){var a=e.getManifestEntry("/"),i=[],o=e.getSevereErrors(),u=e.getContentMessage();if(o.length){return Promise.reject(o.join(" "))}try{a=t.createBindingInfos(a,e.getBindingNamespaces());if(e.getAggregation("_filterBar")){i=e.getAggregation("_filterBar")._getFilters().map(function(e){return["/sap.card/configuration/filters/"+e.getKey(),e]})}i.concat([["/sap.card/content",e.getCardContent()],["/sap.card/header",e.getCardHeader()],["/sap.card/footer",e.getCardFooter()],["/sap.card",e]]).filter(function(t){return!!e.getManifestEntry(t[0])}).forEach(function(e){var t=e[0];var i=e[1];var o;var s;if(u&&t==="/sap.card/content"){o={message:u}}else if(i.getStaticConfiguration){o=i.getStaticConfiguration(n.getNestedPropertyValue(a,t))}else{o=n.getNestedPropertyValue(a,t)}if(i.extendStaticConfiguration){i.extendStaticConfiguration(o)}if(o.data){s=o.data.path;delete o.data}o=r.resolveValue(o,i,s,true);n.setNestedPropertyValue(a,t,o)});s._makeEnabledAndVisibleBooleans(a);return Promise.resolve(JSON.parse(JSON.stringify(a)))}catch(e){return Promise.reject(e)}};s._makeEnabledAndVisibleBooleans=function(e){for(const t in e){if(!e.hasOwnProperty(t)){continue}const r=e[t];if(r&&typeof r==="object"){s._makeEnabledAndVisibleBooleans(r)}else if(t==="enabled"||t==="visible"){e[t]=!!r}}};s._handleCardSevereError=function(t,r){var n=t.getManifestEntry("/"),s=e.getResourceBundleFor("sap.ui.integration");o.error(r,"sap.ui.integration.util.ManifestResolver");if(n===null){n={}}n["sap.card"]={content:{message:{type:"error",title:s.getText("CARD_ERROR_CONFIGURATION_TITLE"),description:s.getText("CARD_ERROR_CONFIGURATION_DESCRIPTION"),details:r.toString(),illustrationType:a.SimpleError,illustrationSize:i.Spot}}};return JSON.parse(JSON.stringify(n))};return s});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Measurement", ["sap/base/config"],function(e){"use strict";var r=performance&&performance.mark;var t=performance&&performance.measure;var a={start:function(e,r){if(!this.getActive()){return null}return performance.mark(e+"-start",{detail:r})},end:function(e){if(!this.getActive()){return null}var r=performance.getEntriesByName(e+"-start")[0],t,a="";if(r){a=r.detail}t=performance.mark(e+"-end",{start:e,detail:a});performance.measure(e,{start:e+"-start",end:e+"-end",detail:a});return t},hasEnded:function(e){if(!this.getActive()){return false}var r=performance.getEntriesByName(e+"-end")[0];return!!r},getActive:function(){var a=e.get({name:"sapUiXxMeasureCards",type:e.Type.Boolean,external:true});return a&&r&&t}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/OAuth3LOHelper", [],function(){"use strict";const e=new Map;const n={};n.openConsentWindow=function(e,n){const t=n?.width||400;const o=n?.height||400;const r=screen.width/2-t/2;const s=screen.height/2-o/2;const i=`noopener, noreferrer, popup, toolbar=no, location=no, directories=no, status=no, menubar=no, scrollbars=no, resizable=no, copyhistory=no, width=${t}, height=${o}, top=${s}, left=${r}`;window.open(e,"_blank",i)};n.needsConsent=function(e){return e.status===502&&e.headers.get("sap-3lo-flow")};n.hasConsentError=function(e){if(!n.needsConsent(e)){return false}const t=n.readHeader(e);return t.status==="error"};n.readHeader=function(e){let n=e.headers.get("sap-3lo-flow");if(!n){return null}n=atob(n);return JSON.parse(n)};n.registerCard=function(n,t){let o=e.get(n);if(!o){o=new Set;e.set(n,o)}o.add(t)};n.unregisterCard=function(n,t){const o=e.get(n);o?.delete(t)};n.handleConsent=function(n){const t=e.get(n);if(!t){return}for(const e of t){e.refreshData()}e.delete(n)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ObjectStatusFactory", ["sap/ui/integration/util/Utils","sap/ui/integration/util/BindingHelper","sap/ui/integration/controls/ObjectStatus"],function(t,e,i){"use strict";var n={};n._getVisible=function(i){let n=i.visible;if(typeof i.visible==="string"){n=!t.hasFalsyValueAsString(n)}return e.reuse(n)};n.createStatusItem=function(t){return new i({text:t.value,visible:n._getVisible(t),state:t.state,showStateIcon:t.showStateIcon,customIcon:t.customStateIcon,inverted:t.inverted})};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ParameterMap", ["sap/base/i18n/Localization","sap/ui/core/Locale","sap/ui/core/date/UI5Date"],function(e,r,n){"use strict";var t={};var a={"{{parameters.NOW_ISO}}":i,"{{parameters.TODAY_ISO}}":o,"{{parameters.LOCALE}}":c};function i(){return n.getInstance().toISOString()}function o(){return n.getInstance().toISOString().slice(0,10)}function c(){return new r(e.getLanguageTag()).toString()}t.processPredefinedParameter=function(e){var r;Object.keys(a).forEach(function(n){r=new RegExp(n,"g");if(e.indexOf(n)>-1){e=e.replace(r,a[n]())}});return e};t.getParamsForModel=function(){var e={};for(var r in a){var n=r.indexOf("."),t=r.indexOf("}");e[r.substring(n+1,t)]=a[r]()}return e};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/RequestDataProvider", ["sap/ui/core/Element","sap/ui/integration/util/DataProvider","sap/base/Log","sap/ui/model/odata/v4/ODataUtils","sap/base/util/fetch","sap/base/util/deepClone"],function(e,t,r,i,s,n){"use strict";var o=[429,503];var a=["no-cors","same-origin","cors"];var u=["GET","POST","HEAD","PUT","PATCH","DELETE","OPTIONS"];var f={json:"application/json, */*",xml:"application/xml, text/xml, */*"};function p(e,t){var r=Object.entries(t).map(function(e){return encodeURIComponent(e[0])+"="+encodeURIComponent(e[1])});return e+(e.indexOf("?")!==-1?"&":"?")+r.join("&")}function d(e){var t=e.headers.get("Content-Type");if(!t){return false}return t.indexOf("application/json")!==-1}function h(e){var t=e.headers.get("Content-Type");if(!t){return false}return t.indexOf("application/xml")!==-1||t.indexOf("text/xml")!==-1}var l=t.extend("sap.ui.integration.util.RequestDataProvider",{metadata:{library:"sap.ui.integration",properties:{allowCustomDataType:{type:"boolean",defaultValue:false}},associations:{host:{type:"sap.ui.integration.Host",multiple:false}}}});l.prototype.init=function(){t.prototype.init.apply(this,arguments);this._retryDueExpiredToken=false};l.prototype.destroy=function(){if(this._iRetryAfterTimeout){clearTimeout(this._iRetryAfterTimeout)}t.prototype.destroy.apply(this,arguments)};l.prototype.getLastResponse=function(){return this._lastResponse};l.prototype.getData=function(){const e=this._getResolvedRequestConfiguration();let t=Promise.resolve(e);if(this._oDestinations){t=this._oDestinations.process(e)}if(this._oCsrfTokenHandler){t=t.then(this._oCsrfTokenHandler.replacePlaceholders.bind(this._oCsrfTokenHandler))}t=t.then(this._fetch.bind(this));if(this._oCsrfTokenHandler){t=t.catch(this._handleExpiredToken.bind(this))}return t};l.prototype.triggerDataUpdate=function(){this._retryDueExpiredToken=false;return t.prototype.triggerDataUpdate.apply(this,arguments)};l.prototype.getResolvedConfiguration=function(){const e=t.prototype.getResolvedConfiguration.apply(this,arguments);this._reviveFormData(e);return e};l.prototype._reviveFormData=function(e){const t=this.getConfiguration();if(t?.request?.parameters instanceof FormData){e.request.parameters=t.request.parameters}};l.prototype._handleExpiredToken=function(e){if(!this._oCsrfTokenHandler.isExpiredToken(this.getLastResponse())){throw e}this._oCsrfTokenHandler.markExpiredTokenByRequest(this.getConfiguration().request);if(this._retryDueExpiredToken){this._retryDueExpiredToken=false;throw e}this._retryDueExpiredToken=true;this._bActive=false;return this._waitDependencies().then(this.getData.bind(this))};l.prototype._fetch=function(e){var t="Invalid request";if(!e||!e.url){r.error(t);return Promise.reject(t)}if(!this.getAllowCustomDataType()&&e.dataType){r.error("To specify dataType property in the Request Configuration, first set allowCustomDataType to 'true'.")}var s=e.url,n=e.parameters,o=this.getAllowCustomDataType()&&e.dataType||"json",a=e.headers||{},u=e.batch,d,h,l,c=e.method&&e.method.toUpperCase()||"GET",y=this._hasHeader(e,"Content-Type","application/json"),m=["GET","HEAD"].includes(c);if(!s.startsWith("/")){s=this._getRuntimeUrl(e.url)}if(n){if(y){l=JSON.stringify(n)}else if(m){s=p(s,n)}else if(n instanceof FormData){l=n}else{l=new URLSearchParams(n)}}if(u){d=i.serializeBatchRequest(Object.values(u));l=d.body;a=Object.assign({},a,d.headers)}h={url:s,options:{mode:e.mode||"cors",method:c,headers:new Headers(a)}};if(l){h.options.body=l}if(e.withCredentials){h.options.credentials="include"}if(!h.options.headers.get("Accept")&&f[o]){h.options.headers.set("Accept",f[o])}h=this._modifyRequestBeforeSent(h,this.getResolvedConfiguration());if(!this._isValidRequest(h)){r.error(t);return Promise.reject(t)}return this._request(h).then(function(e){var t=e[0];if(u){return this._deserializeBatchResponse(u,t)}return t}.bind(this))};l.prototype._request=function(e,t){var r=this._getFetchMethod(this._getResolvedRequestConfiguration());return r(e.url,e.options).then(function(r){if(this.bIsDestroyed){return Promise.reject("RequestDataProvider is already destroyed before the response is received.")}this._lastResponse=r;if(!r.ok){return r.text().then(function(i){var s=[r.status+" "+r.statusText,r,i,e];if(t){return Promise.reject(s)}return this._retryRequest(s)}.bind(this))}return r.text().then(function(t){if(d(r)){try{t=JSON.parse(t)}catch(t){return Promise.reject([t.toString(),null,null,e])}}else if(h(r)){t=(new window.DOMParser).parseFromString(t,"text/xml")}return[t,r]})}.bind(this),function(t){return Promise.reject([t.toString(),null,null,e])})};l.prototype._retryRequest=function(e){var t=e[1],i=e[3],s=this._getRetryAfter(t);if(!o.includes(t.status)){return Promise.reject(e)}if(!s){r.warning("Request could be retried, but Retry-After header or configuration parameter retryAfter are missing.");return Promise.reject(e)}if(this._iRetryAfterTimeout){e[0]="The retry was already scheduled.";return Promise.reject(e)}return new Promise(function(e,t){this._iRetryAfterTimeout=setTimeout(function(){this._request(i,true).then(e,t);this._iRetryAfterTimeout=null}.bind(this),s*1e3)}.bind(this))};l.prototype._getRetryAfter=function(e){const t=this._getResolvedRequestConfiguration(),i=e.headers.get("Retry-After")||t.retryAfter;if(!i){return 0}if(Number.isInteger(i)){return i}if(!i.match(/^\d+$/)){r.error("Only number of seconds is supported as value of retry-after. Given '"+i+"'.");return 0}return parseInt(i)};l.prototype._getFetchMethod=function(t){var r=this.getCardInstance(),i=r&&r.getAggregation("_extension"),n=e.getElementById(this.getHost());if(i){return(e,r)=>i.fetch(e,r,this._cloneRequestConfiguration(t))}if(n){return(e,i)=>n.fetch(e,i,this._cloneRequestConfiguration(t),r)}return s};l.prototype._getResolvedRequestConfiguration=function(){return this.getResolvedConfiguration().request};l.prototype._cloneRequestConfiguration=function(e){let t;if(e?.parameters instanceof FormData){t=e.parameters;delete e.parameters}const r=n(e,1e3);if(t){r.parameters=t}return r};l.prototype._hasHeader=function(e,t,r){if(!e.headers){return false}for(var i in e.headers){if(i.toLowerCase()===t.toLowerCase()&&e.headers[i]===r){return true}}return false};l.prototype._isValidRequest=function(e){if(!e){r.error("Request is not valid. Request object is missing.");return false}if(!e.url){r.error("Request is not valid. URL is missing.");return false}if(!e.options){r.error("Request is not valid. Options are missing.");return false}if(a.indexOf(e.options.mode)===-1){r.error("Request is not valid. Mode is not among "+a.toString());return false}if(u.indexOf(e.options.method)===-1){r.error("Request is not valid. Method is not among "+u.toString());return false}if(e.options.headers&&!(e.options.headers instanceof Headers)){r.error("Request is not valid. The headers option is not instance of Headers interface.");return false}if(typeof e.url!=="string"){return false}return true};l.prototype._deserializeBatchResponse=function(e,t){return new Promise(function(r,s){var n=this.getLastResponse().headers.get("Content-Type"),o=i.deserializeBatchResponse(n,t,false),a=Object.keys(e),u={};a.forEach(function(e,t){var r=o[t],i;if(!r){s("Batch responses do not match the batch requests.");return}i=new Response(r.responseText,r);if(!i.ok){s("One of batch requests fails with '"+i.status+" "+i.statusText+"'");return}u[e]=r.responseText?JSON.parse(r.responseText):{}});r(u)}.bind(this))};l.prototype._modifyRequestBeforeSent=function(t,r){var i=this.getCardInstance(),s=e.getElementById(this.getHost());if(!s){return t}if(s.modifyRequestHeaders){t.options.headers=new Headers(s.modifyRequestHeaders(Object.fromEntries(t.options.headers),r,i))}if(s.modifyRequest){t=s.modifyRequest(t,r,i)}return t};l.prototype.getDetails=function(){return"Backend interaction - load data from URL: "+this._getResolvedRequestConfiguration().url};return l});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ServiceDataProvider", ["sap/ui/integration/util/DataProvider"],function(e){"use strict";var t=e.extend("sap.ui.integration.util.ServiceDataProvider",{metadata:{library:"sap.ui.integration",interfaces:["sap.ui.integration.util.IServiceDataProvider"]}});t.prototype.destroy=function(){this._oDataServicePromise=null;if(this._oServiceManager){this._oServiceManager=null}e.prototype.destroy.apply(this,arguments)};t.prototype.createServiceInstances=function(e){this._oServiceManager=e;const t=this.getResolvedConfiguration();if(!t||!t.service){return}let i=t.service;if(i&&typeof i==="object"){i=i.name}this._createServiceInstance(i)};t.prototype._createServiceInstance=function(e){const t=this.getResolvedConfiguration();this._oDataServicePromise=this._oServiceManager.getService(e).then(function(e){e.attachDataChanged(function(e){this.fireDataChanged({data:e.data})}.bind(this),t.service.parameters);return e}.bind(this))};t.prototype.getData=function(){const e=this.getResolvedConfiguration();const t=e.service;return new Promise(function(e,i){if(t&&this._oDataServicePromise){this._oDataServicePromise.then(function(t){t.getData().then(function(t){e(t)}).catch(function(){i("Card data service failed to get data.")})}).catch(function(){i("Card data service unavailable.")})}else{i("Could not get card data.")}}.bind(this))};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/ServiceManager", ["sap/ui/base/EventProvider","sap/base/Log"],function(e,r){"use strict";var t=e.extend("sap.ui.integration.util.ServiceManager",{constructor:function(r,t){if(!r){throw new Error("Missing manifest services reference!")}if(!t){throw new Error("Missing context object")}e.call(this);this._mServiceFactoryReferences=r;this._mServices={};this._oServiceContext=t;this._initAllServices()}});t.prototype._initAllServices=function(){for(var e in this._mServiceFactoryReferences){this._initService(e)}};t.prototype._initService=function(e){var i=this._mServices[e]||{};i.promise=t._getService(this._oServiceContext,e,this._mServiceFactoryReferences).then(function(e){i.instance=e}).catch(function(e){r.error(e.message)});this._mServices[e]=i};t.prototype.getService=function(e){var r="Invalid service";return new Promise(function(t,i){if(!e||!this._mServices[e]||!Object.keys(this._mServices[e])){i(r);return}this._mServices[e].promise.then(function(){if(this._mServices[e].instance){t(this._mServices[e].instance)}else{i(r)}}.bind(this)).catch(i)}.bind(this))};t.prototype.destroy=function(){this._mServices=null};t._getService=function(e,r,t){return new Promise(function(i,n){var c,s;if(e.bIsDestroyed){n(new Error("Service "+r+" could not be loaded as the requestor "+e.getMetadata().getName()+" was destroyed."));return}if(!t){n(new Error("No Services declared"));return}else{c=t[r]}if(!c||!c.factoryName){n(new Error("No Service '"+r+"' declared or factoryName missing"));return}else{s=c.factoryName}sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(t){var o=t.get(s);if(o){o.createInstance({scopeObject:e,scopeType:"component",settings:c.settings||{}}).then(function(e){if(e.getInterface){i(e.getInterface())}else{i(e)}}).catch(n)}else{var a=new Error("ServiceFactory '"+s+"' for Service '"+r+"' not found in ServiceFactoryRegistry");a._optional=c.optional;n(a)}})})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/SkeletonCard", ["sap/ui/integration/library","sap/ui/integration/widgets/Card","sap/ui/integration/util/ManifestResolver"],function(t,e,r){"use strict";var i=t.CardDataMode;var n=e.extend("sap.ui.integration.util.SkeletonCard",{metadata:{library:"sap.ui.integration"},renderer:null});n.prototype.init=function(){e.prototype.init.apply(this,arguments);this.setDataMode(i.Active)};n.prototype.resolveManifest=function(){return r.resolveCard(this)};n.prototype.isSkeleton=function(){return true};n.prototype.refresh=function(){e.prototype.refresh.apply(this);this.startManifestProcessing()};n.prototype._createCard=function(t){return new n(t)};return n});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/SorterHelper", ["sap/ui/integration/util/BindingResolver","sap/ui/model/Sorter"],function(e,r){"use strict";const t={};t.getGroupSorter=function(t){var i=false;if(t.order.dir&&t.order.dir==="DESC"){i=true}var n=new r(t.order.path,i,function(r){return e.resolveValue(t.title,r.getModel(),r.getPath())});return n};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Utils", ["sap/ui/core/getCompatibilityVersion","sap/ui/core/Locale","sap/base/strings/formatMessage","sap/base/util/isPlainObject","sap/base/Log","sap/ui/core/date/UI5Date","sap/base/i18n/Localization","sap/base/util/deepClone"],function(e,t,n,a,r,i,s,o){"use strict";var u={};u.languageMapping={"da-DK":"da","en-US":"en","hi-IN":"hi","hu-HU":"hu","id-ID":"id","ms-MY":"ms","nl-NL":"nl","pl-PL":"pl","ro-RO":"ro","th-TH":"th"};u.getLocalizationLanguage=function(){var e=s.getLanguage().replaceAll("_","-");return u.languageMapping[e]||e};u.formatLanguageCodesInTranslationTexts=function(e){var t;if(e){t={};Object.keys(e).forEach(function(n){var a=n.replaceAll("_","-");t[a]=e[n]})}return t};u.mapLanguagesInManifestChanges=function(e){if(typeof e==="object"){e.forEach(function(e){if(e.texts){e.texts=u.formatLanguageCodesInTranslationTexts(e.texts);for(var[t,n]of Object.entries(u.languageMapping)){if(e.texts[t]){var a=o(e.texts[t],500);delete e.texts[t];a=Object.assign(a,e.texts[n]);e.texts[n]=a}}}})}};u._language=u.getLocalizationLanguage();u.refreshLocalizationLanguage=function(){u._language=u.getLocalizationLanguage()};s.attachChange(u.refreshLocalizationLanguage);u.isJson=function(e){if(typeof e!=="string"){return false}try{JSON.parse(e);return true}catch(e){return false}};u.processFormatArguments=function(e,n){var r=a(e)?e:{},i=typeof e==="string"?new t(e):n&&new t(n);return{formatOptions:r,locale:i}};u.parseJsonDateTime=function(e){var t=1,n=2,a=3;var s=/^\/Date\((-?\d+)(\+|-)?(\d+)?\)\/$/,o;if(typeof e==="string"){o=s.exec(e)}if(o){var u=i.getInstance(parseInt(o[t]));if(o[n]){var f=parseInt(o[a]);if(o[n]==="-"){f=-f}var l=u.getUTCMinutes();u.setUTCMinutes(l-f)}if(isNaN(u.valueOf())){r.error("Invalid JSON Date format - "+e)}else{e=u}}return e};u.DEFAULT_PROMISE_TIMEOUT=5e3;u.timeoutPromise=function(e,t){var n;if(t===undefined){t=u.DEFAULT_PROMISE_TIMEOUT}n=new Promise(function(e,n){setTimeout(function(){n("The promise was not resolved after "+t+" ms so it timed out.")},t)});return Promise.race([e,n])};u.hasFalsyValueAsString=function(e){return typeof e=="string"&&["null","false","undefined",""].indexOf(e.trim())>-1};u.setNestedPropertyValue=function(e,t,n){var a=t.substring(1).split("/"),r;for(var i=0;i<a.length-1;i++){r=a[i];e=e.hasOwnProperty(r)?e[r]:undefined;if(e===null||typeof e!=="object"){break}}e[a[a.length-1]]=n};u.getNestedPropertyValue=function(e,t){var n=t.substring(1).split("/"),a;for(var r=0;r<n.length;r++){a=n[r];e=e.hasOwnProperty(a)?e[a]:undefined;if(e===null||typeof e!=="object"){break}}return e};u.makeUndefinedValuesNull=function(e){if(Array.isArray(e)){return e.map(function(e){if(e===undefined){return null}if(typeof e==="object"){return u.makeUndefinedValuesNull(e)}return e})}for(var t in e){if(e.hasOwnProperty(t)){if(e[t]===undefined){e[t]=null}else if(typeof e[t]==="object"){e[t]=u.makeUndefinedValuesNull(e[t])}}}return e};u.isBindingSyntaxComplex=function(){if(u._isBindingSyntaxComplex===undefined){u._isBindingSyntaxComplex=e("sapCoreBindingSyntax").compareTo("1.26")>=0}return u._isBindingSyntaxComplex};u.generateUuidV4=function(){var e="xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var t=Math.random()*16|0;if(e==="y"){t=t&3|8}return t.toString(16)});return e};u.getStatusTextBindingInfo=function(e){var t;if(e.parts&&e.translationKey&&e.parts.length===2){t={parts:[e.translationKey,e.parts[0].toString(),e.parts[1].toString()],formatter:function(t,a,r){var i=a||e.parts[0];var s=r||e.parts[1];if(Array.isArray(a)){i=a.length}if(Array.isArray(r)){s=r.length}var o=parseFloat(i)||0;var u=parseFloat(s)||0;return n(t,[o,u])}}}return t};u.polling=function(e,t=3e3,n=6e5){let a=0;let r;let i=false;const s=async()=>{if(n&&a>=n){return}const o=await e();if(o||i){return}a+=t;r=setTimeout(s,t)};s();return{stop:()=>{clearTimeout(r);i=true}}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/Validators", [],function(){"use strict";var t={string:{maxLength:function(t,e){return t.length<=e},maxLengthTxt:"EDITOR_VAL_MAXLENGTH",minLength:function(t,e){return t.length>=e},minLengthTxt:"EDITOR_VAL_MINLENGTH",pattern:function(t,e){var i=new RegExp(e);return i.test(t)},patternTxt:"EDITOR_VAL_NOMATCH",required:function(t,e){return!e||!!t},requiredTxt:"EDITOR_VAL_TEXTREQ",validateTxt:"EDITOR_VAL_NOMATCH"},"string[]":{maxLength:function(t,e){return Array.isArray(t)&&t.length<=e},maxLengthTxt:"EDITOR_VAL_LISTMAXLENGTH",minLength:function(t,e){return Array.isArray(t)&&t.length>=e},minLengthTxt:"EDITOR_VAL_LISTMINLENGTH",required:function(t,e){return Array.isArray(t)&&t.length>0},requiredTxt:"EDITOR_VAL_LISTREQ"},integer:{maximum:function(t,e,i){if(i.exclusiveMaximum){i._txt="maximumExclusiveTxt";return t<e}return t<=e},maximumTxt:"EDITOR_VAL_MAX",maximumExclusiveTxt:"EDITOR_VAL_MAX_E",minimum:function(t,e,i){if(i.exclusiveMinimum){i._txt="minimumExclusiveTxt";return t>e}return t>=e},minimumTxt:"EDITOR_VAL_MIN",minimumExclusiveTxt:"EDITOR_VAL_MIN_E",multipleOf:function(t,e){return t%e===0},multipleOfTxt:"EDITOR_VAL_MULTIPLE",required:function(t,e){return!isNaN(t)&&t!==""},requiredTxt:"EDITOR_VAL_NUMBERREQ",validateTxt:"EDITOR_VAL_NOMATCH"},number:{maximum:function(t,e,i){if(i.exclusiveMaximum){i._txt="maximumExclusiveTxt";return t<e}return t<=e},maximumTxt:"EDITOR_VAL_MAX",maximumExclusiveTxt:"EDITOR_VAL_MAX_E",minimum:function(t,e,i){if(i.exclusiveMinimum){i._txt="minimumExclusiveTxt";return t>e}return t>=e},minimumTxt:"EDITOR_VAL_MIN",minimumExclusiveTxt:"EDITOR_VAL_MAX_E",multipleOf:function(t,e){return t%e===0},multipleOfTxt:"EDITOR_VAL_MULTIPLE",required:function(t,e){return!isNaN(t)&&t!==""},requiredTxt:"EDITOR_VAL_NUMBERREQ",validateTxt:"EDITOR_VAL_NOMATCH"},keyValuePair:{required:function(t,e){return!e||!!t.value},requiredTxt:"EDITOR_VAL_FIELDREQ",restrictToPredefinedOptions:function(t,e){return e&&!t.value&&!t.key||e&&!!t.key},restrictToPredefinedOptionsTxt:"EDITOR_ONLY_LISTED_VALUES_ALLOWED"},dateRange:{required:function(t,e){return!e||!!t.value},requiredTxt:"EDITOR_VAL_FIELDREQ"}};return t});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/loadCardEditor", ["sap/ui/dom/includeScript"],function(i){"use strict";function n(){return new Promise(function(i,n){sap.ui.require(["sap/ui/integration/designtime/cardEditor/BASEditor"],i,n)})}return function(){return i({url:"sap-ui-integration-cardEditor.js"}).then(n).catch(n)}});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/openCardDialog", ["sap/m/Dialog","sap/ui/Device","sap/ui/core/Element","sap/ui/integration/library","sap/ui/integration/util/BindingHelper","sap/ui/dom/jquery/Focusable"],(e,t,a,n,i)=>{"use strict";const o=n.CardDataMode;function r(e,t){const a=t.getDomRef().getBoundingClientRect();const n={top:Math.round(a.top)+window.scrollX,left:Math.round(a.left)+window.scrollX,width:Math.round(a.width),height:Math.round(a.height)};e.attachBeforeClose(()=>{const t=e.getDomRef();t.classList.add("sapUiIntCardDialogAnimate");t.style.top=n.top+"px";t.style.left=n.left+"px"});e.addEventDelegate({onAfterRendering:()=>{const t=e.getDomRef();if(!e.isOpen()){t.classList.add("sapUiIntCardDialogAnimate");t.style.top=n.top+"px";t.style.left=n.left+"px"}const a=e=>{if(["left","right"].includes(e.propertyName)){t.classList.remove("sapUiIntCardDialogAnimate");t.removeEventListener("transitionend",a)}};t.addEventListener("transitionend",a)}})}function s(e,t){const a=t.getCardHeader();if(!a){return}i.propagateModels(a,a);e.setCustomHeader(a);t.setAssociation("dialogHeader",a);a.setProperty("headingLevel","1");a.setProperty("focusable",false);a.setVisible(true)}function l(e,t){t.addEventDelegate({onAfterRendering:()=>{t.getDomRef().removeAttribute("role");t.getDomRef().removeAttribute("aria-labelledby")}});e.addEventDelegate({onAfterRendering:()=>{const t=e.getCustomHeader();if(!t){return}e.getDomRef().setAttribute("aria-labelledby",t.getTitleId())}})}function d(a,n,i){a.setDisplayVariant("Large");a.setDataMode(o.Active);a.addStyleClass("sapUiIntCardDialogCard");n.setBusy(true).setBusyIndicatorDelay(750);const d=new e({content:[a],contentWidth:i.width,verticalScrolling:false,horizontalScrolling:false,draggable:true,resizable:true,escapeHandler:function(e){a.hide();e.resolve()},afterOpen:()=>{n.setBusy(false)},afterClose:()=>{d.destroy()}});d.addStyleClass("sapUiIntCardDialog");n.addDependent(d);a.attachEvent("_ready",()=>{s(d,a);l(d,a);if(!a._isComponentCard()){d.open()}f(a,d)});if(!t.system.phone){r(d,n)}a.attachManifestReady(()=>{if(a._isComponentCard()){d.open()}});a.startManifestProcessing();return d}function f(e,t){var a=e.getAggregation("_filter"),n=e.getAggregation("_content"),i=e.getAggregation("_footer"),o;o=a&&a.$().firstFocusableDomRef()||n&&n.$().firstFocusableDomRef()||i&&i.$().firstFocusableDomRef();if(o){t.setInitialFocus(o.id);o.focus()}}function g(e,t){let n;if(t._cardId){n=a.getElementById(t._cardId)}else{n=e._createChildCard(t)}return d(n,e,t)}return g});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/util/openCardShowMore", ["sap/base/util/uid","sap/ui/integration/util/openCardDialog"],(t,e)=>{"use strict";function i(e){const i=e.getManifestEntry("/");i["sap.app"].id=i["sap.app"].id+t();e.getAggregation("_filterBar")?._getFilters().forEach(t=>{t.writeValueToConfiguration(i["sap.card"].configuration.filters[t.getKey()])});return i}function a(t){return e(t,{manifest:i(t),baseUrl:t.getBaseUrl(),showCloseButton:true})}return a});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/widgets/Card", ["./CardRenderer","../cards/Footer","../controls/ActionsToolbar","../controls/BlockingMessage","../delegate/Paginator","sap/ui/base/Interface","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/thirdparty/jquery","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/base/util/each","sap/ui/integration/util/DataProviderFactory","sap/ui/model/json/JSONModel","sap/ui/integration/model/ObservableModel","sap/ui/model/resource/ResourceModel","sap/ui/integration/model/ContextModel","sap/f/CardBase","sap/f/library","sap/ui/integration/library","sap/ui/integration/util/Destinations","sap/ui/integration/util/DelayedLoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/ErrorHandler","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/cards/filters/FilterBarFactory","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/util/CardObserver","sap/m/IllustratedMessageType","sap/ui/integration/util/Utils","sap/ui/integration/util/ParameterMap","sap/ui/integration/util/Measurement","sap/ui/integration/util/DisplayVariants"],function(t,e,i,a,r,s,n,o,jQuery,d,h,g,f,l,c,p,u,_,y,C,v,M,m,P,A,D,b,R,E,S,I,w,T,F,L,O,B,x){"use strict";const H={TYPE:"/sap.card/type",ACTIONS:"/sap.card/actions",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",FOOTER:"/sap.card/footer",PAGINATOR:"/sap.card/footer/paginator",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations",CSRF_TOKENS:"/sap.card/configuration/csrfTokens",FILTERS:"/sap.card/configuration/filters",NO_DATA_MESSAGES:"/sap.card/configuration/messages/noData",MODEL_SIZE_LIMIT:"/sap.card/configuration/modelSizeLimit"};const V=["visibleItems","allItems"];const N=M.cards.HeaderPosition;const k=M.cards.SemanticRole;const z=m.CardActionArea;const U=m.CardArea;const q=m.CardDataMode;const W=m.CardDesign;const j=m.CardDisplayVariant;const J=m.CardPreviewMode;const G=m.CardOverflow;const Y=m.CardBlockingMessageType;const K="Card is destroyed!";const Z="module:";const Q=1e3;var $=v.extend("sap.ui.integration.widgets.Card",{metadata:{library:"sap.ui.integration",properties:{referenceId:{type:"string",defaultValue:""},manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:q.Auto},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]",defaultValue:[]},useMockData:{type:"boolean",defaultValue:false,visibility:"hidden"},design:{type:"sap.ui.integration.CardDesign",group:"Appearance",defaultValue:W.Solid},displayVariant:{type:"sap.ui.integration.CardDisplayVariant",group:"Appearance",defaultValue:j.Standard},previewMode:{type:"sap.ui.integration.CardPreviewMode",group:"Behavior",defaultValue:J.Off},useProgressiveDisclosure:{type:"boolean",group:"Behavior",defaultValue:false},overflow:{type:"sap.ui.integration.CardOverflow",group:"Behavior",defaultValue:G.Default},showCloseButton:{type:"boolean",group:"Behavior",defaultValue:false,visibility:"hidden"},interactive:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true,forwarding:{getter:"_getActionsToolbar",aggregation:"actionDefinitions"}},_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.integration.cards.filters.FilterBar",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_footer:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},formData:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},configurationChange:{parameters:{changes:{type:"object"}}},manifestReady:{},manifestApplied:{},stateChanged:{}},associations:{host:{},openerReference:{visibility:"hidden"},dialogHeader:{visibility:"hidden"}}},renderer:t});$.prototype.init=function(){v.prototype.init.call(this);this.setAggregation("_loadingProvider",new A);this._oIntegrationRb=o.getResourceBundleFor("sap.ui.integration");this._iModelSizeLimit=Q;this._oDisplayVariants=new x(this);this._initModels();this._oContentFactory=new b(this);this._oCardObserver=new T(this);this._aSevereErrors=[];this._sPerformanceId="UI5 Integration Cards "+this.getId()+" ";this._aActiveLoadingProviders=[];this._fnOnDataReady=function(){this._bDataReady=true}.bind(this);this._fireStateChangedBound=this._fireStateChanged.bind(this);this._sizeFormatterBound=this._oDisplayVariants.sizeFormatter.bind(this._oDisplayVariants);this._oLimitedInterface=new s(this,["getId","getDomRef","setVisible","getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","refresh","refreshData","showMessage","getBaseUrl","getRuntimeUrl","getTranslatedText","getModel","triggerAction","addActionDefinition","removeActionDefinition","insertActionDefinition","getActionDefinition","indexOfActionDefinition","destroyActionDefinition","showLoadingPlaceholders","hideLoadingPlaceholders","showCard","hide","getOpener","validateControls","showBlockingMessage","hideBlockingMessage","getBlockingMessage"])};$.prototype._initModels=function(){this._INTERNAL_MODELS={default:{init:()=>this.setModel(new u),reset:()=>this.getModel().setData({})},parameters:{init:()=>this.setModel(new u(O.getParamsForModel()),"parameters")},filters:{init:()=>this.setModel(new u,"filters"),reset:()=>this.getModel("filters").setData({})},paginator:{init:()=>this.setModel(new u({skip:0,pageIndex:0}),"paginator"),reset:()=>this.getModel("paginator").setData({skip:0,pageIndex:0})},form:{init:()=>this.setModel(new u,"form")},messages:{init:()=>this.setModel(new u({hasErrors:false,hasWarnings:false,records:[]}),"messages")},context:{init:()=>this.setModel(new C,"context")},i18n:{init:()=>{this.setModel(new y({bundle:this._oIntegrationRb,async:true}),"i18n");this._oActiveRb=this._oIntegrationRb},reset:()=>{this._oActiveRb=this._oIntegrationRb}},size:{init:()=>this.setModel(this._oDisplayVariants.getInitialSizeModel(),"size")},widgetInfo:{init:()=>this.setModel(new u,"widgetInfo")}};for(const t in this._INTERNAL_MODELS){this._INTERNAL_MODELS[t].init()}};$.prototype.clone=function(){var t=v.prototype.clone.apply(this,arguments);t._initModels();return t};$.prototype._initReadyState=function(){this._aReadyPromises=[];const t=this._aReadyPromises;this._awaitEvent("_dataReady");this._awaitEvent("_dataPassedToContent");this._awaitEvent("_headerReady");this._awaitEvent("_filterBarReady");this._awaitEvent("_contentReady");this._awaitEvent("_paginatorReady");Promise.all(this._aReadyPromises).then(function(){if(t===this._aReadyPromises){this._onReady()}}.bind(this));this.attachEventOnce("_dataReady",this._fnOnDataReady)};$.prototype._clearReadyState=function(){this._bReady=false;this._bDataReady=false;this._aReadyPromises=[];this.detachEvent("_dataReady",this._fnOnDataReady)};$.prototype.onBeforeRendering=function(){const t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.setDesign(this.getDesign());t.setOverflowWithShowMore(this.getOverflow()===G.ShowMore)}const e=this.getCardFooter();if(e){e.setDetectVisibility(this.getOverflow()===G.ShowMore)}if(this._getActualDataMode()!==q.Active){return}this.startManifestProcessing()};$.prototype.onAfterRendering=function(){if(this._isManifestReady){if(!B.hasEnded(this._sPerformanceId+"firstRenderingWithStaticData")){B.end(this._sPerformanceId+"firstRenderingWithStaticData")}if(this._bDataReady&&!B.hasEnded(this._sPerformanceId+"firstRenderingWithDynamicData")){B.end(this._sPerformanceId+"firstRenderingWithDynamicData")}}var t=this.getDomRef();if(this._getActualDataMode()===q.Auto){this._oCardObserver.observe(t)}else{this._oCardObserver.unobserve(t)}};$.prototype.startManifestProcessing=function(){if(!L.isBindingSyntaxComplex()){this._logSevereError("Cannot parse manifest. Complex binding syntax is not enabled - "+"To enable it, set the 'compatVersion' configuration option to 'edge', e.g.: data-sap-ui-compatVersion='edge' - "+"sap.ui.integration.widgets.Card")}if(this._bApplyManifest||this._bApplyParameters){this._clearReadyState();this._initReadyState()}var t=this.getManifest();if(t&&this._bApplyManifest){this._cleanupOldManifest();this.createManifest(t,this.getBaseUrl())}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this._getContextAndRuntimeParams());this.processDestinations(this._oCardManifest.getJson()).then(t=>{this._oCardManifest.setJson(t);this._applyManifestSettings()})}this._bApplyManifest=false;this._bApplyParameters=false;this._refreshActionsMenu()};$.prototype.setManifest=function(t){if(!l(this.getProperty("manifest"),t)){this.destroyActionDefinitions()}if(!t){this._destroyManifest()}this._bApplyManifest=true;this.setProperty("manifest",t);return this};$.prototype.setManifestChanges=function(t){this.setProperty("manifestChanges",t);this._bApplyManifest=true;return this};$.prototype.setParameters=function(t){this.setProperty("parameters",t);this._bApplyParameters=true;return this};$.prototype.setParameter=function(t,e){var i=this.getParameters()||{};i[t]=e;this.setParameters(i);return this};$.prototype.setHost=function(t){this.setAssociation("host",t);var e=this.getHostInstance();if(t&&!e){g.error("Host with id '"+t+"' is not available during card initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the card.","sap.ui.integration.widgets.Card");return this}this.getModel("context").setHost(e);if(this._oDestinations){this._oDestinations.setHost(e)}if(this._oDataProviderFactory){this._oDataProviderFactory.setHost(e)}if(e&&e.bUseExperimentalCaching){this.addStyleClass("sapFCardExperimentalCaching")}else{this.removeStyleClass("sapFCardExperimentalCaching")}return this};$.prototype.createManifest=function(t,e){var i={};this._isManifestReady=false;if(typeof t==="string"){i.manifestUrl=t;t=null}if(this._oCardManifest){this._oCardManifest.destroy()}B.start(this._sPerformanceId+"initManifest","Load and initialize manifest.");B.start(this._sPerformanceId+"firstRenderingWithStaticData","First rendering with static data (includes initManifest).");B.start(this._sPerformanceId+"firstRenderingWithDynamicData","First rendering with dynamic card level data (includes firstRenderingWithStaticData).");this._oCardManifest=new d("sap.card",t,e,this.getManifestChanges());this._oCardManifest.load(i).then(function(){if(this.isDestroyed()){throw new Error(K)}if(!this._oCardManifest.get("/sap.app/id")){this._logSevereError("Card sap.app/id entry in the manifest is mandatory")}return this._oCardManifest.loadDependenciesAndIncludes()}.bind(this)).then(function(){if(this.isDestroyed()){throw new Error(K)}B.end(this._sPerformanceId+"initManifest");this._isManifestReady=true;this.fireManifestReady();return this._loadExtension()}.bind(this)).then(this._applyManifest.bind(this)).catch(function(t){if(t.message===K){return}this._logSevereError(t.message);this._applyManifest()}.bind(this))};$.prototype._loadExtension=function(){var t=this._oCardManifest.get("/sap.card/extension"),e;if(!t){return null}if(t.startsWith(Z)){e=t.replace(Z,"")}else{e=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+t}return new Promise(function(t,i){sap.ui.require([e],function(e){var i=new e;i._setCard(this,this._oLimitedInterface);this.setAggregation("_extension",i);t()}.bind(this),function(t){this._logSevereError("Failed to load "+e+". Check if the path is correct. Reason: "+t);i(t)}.bind(this))}.bind(this))};$.prototype._logSevereError=function(t){g.error(t);this._aSevereErrors.push(t)};$.prototype.getSevereErrors=function(){return this._aSevereErrors};$.prototype.validateControls=function(){this._validateContentControls(true);return!this.getModel("messages").getProperty("/hasErrors")};$.prototype.getModelSizeLimit=function(){return this._iModelSizeLimit};$.prototype._validateContentControls=function(t,e){var i=this.getCardContent();if(i&&i.isA("sap.ui.integration.cards.BaseContent")){i.validateControls(t,e)}};$.prototype._applyManifest=async function(){var t=this._oCardManifest;if(!t.get("/sap.card")){this._logSevereError("There must be a 'sap.card' section in the manifest.")}if(t&&t.getResourceBundle()){this._oActiveRb=await this._enhanceI18nModel(t.getResourceBundle())}this.getModel("context").resetHostProperties();if(this._hasContextParams()){this._oContextParameters=await this._resolveContextParams()}t.processParameters(this._getContextAndRuntimeParams());await this._prepareToApplyManifestSettings();this._applyManifestSettings()};$.prototype._enhanceI18nModel=function(t){var e=this.getModel("i18n"),i;i=new y({async:true,bundle:t,enhanceWith:[this._oIntegrationRb]});this.setModel(i,"i18n");e.destroy();return i.getResourceBundle()};$.prototype._hasContextParams=function(){var t=this._oCardManifest.get(H.PARAMS),e,i;for(e in t){i=t[e].value;if(typeof i==="string"&&i.indexOf("{context>")!==-1){return true}}return false};$.prototype._resolveContextParams=function(){var t=this.getModel("context"),e=this._oCardManifest.get(H.PARAMS),i={},a,r;for(a in e){r=e[a].value;if(typeof r==="string"&&r.indexOf("{context>")!==-1){i[a]=r}}R.resolveValue(i,this,"/");return t.waitForPendingProperties().then(function(){return R.resolveValue(i,this,"/")}.bind(this))};$.prototype._getContextAndRuntimeParams=function(){var t=this._oContextParameters||{},e=this.getParameters()||{};return f(t,e)};$.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(e){this.attachEventOnce(t,function(){e()})}.bind(this)))};$.prototype.isReady=function(){return this._bReady};$.prototype.refresh=function(){if(this._getActualDataMode()===q.Active){this._bApplyManifest=true;this.invalidate()}};$.prototype.setFilterValue=function(t,e){var i=this._oCardManifest.get(H.FILTERS);if(!i.hasOwnProperty(t)){g.error("Filter with key '"+t+"' does not exist in the manifest section 'filters'.","sap.ui.integration.widgets.Card");return}var a=this.getAggregation("_filterBar");if(!a){return}var r=a._getFilters().find(function(e){return e.getKey()===t});r.setValueFromOutside(e)};$.prototype.setFormValues=function(t){var e=this.getCardContent();if(e&&!e.isA("sap.ui.integration.cards.ObjectContent")){g.error("Setting form element values is available only on an Object card","sap.ui.integration.widgets.Card");return}t.forEach(function(t){e.setFormFieldValue(t)})};$.prototype.refreshData=function(){if(!this.isReady()){return}this.refreshAllData();this.resetPaginator()};$.prototype.refreshAllData=function(){var t=this.getCardHeader(),e=this.getCardContent(),i=this.getAggregation("_filterBar");if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}if(t){t.refreshData()}if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.refreshData()}else{this._applyContentManifestSettings()}if(i){i.refreshData()}};$.prototype._refreshActionsMenu=function(){var t=this.getCardHeader(),e=this.getHostInstance(),i=this.getAggregation("_extension"),a=[];if(!t){return}if(e){a=a.concat(e.getActions()||[])}if(i){a=a.concat(i.getActions()||[])}if(l(a,this._getActionsToolbar()._aActions)){return}this._getActionsToolbar().initializeContent(this)};$.prototype.exit=function(){v.prototype.exit.call(this);this._destroyManifest();this._oCardObserver.destroy();this._oCardObserver=null;this._oDisplayVariants=null;this._oContentFactory=null;this._oIntegrationRb=null;this._aActiveLoadingProviders=null;this._oMessage=null;clearTimeout(this._iFireStateChangedCallId);if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null}if(this._oActions){this._oActions.destroy();this._oActions=null}};$.prototype._destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null}if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null}this.destroyAggregation("_header");this.destroyAggregation("_content");this.destroyAggregation("_filterBar");this.destroyAggregation("_footer");this._cleanupOldManifest()};$.prototype._cleanupOldManifest=function(){if(this._fnOnModelChange){this.getModel().detachEvent("change",this._fnOnModelChange,this);delete this._fnOnModelChange}for(const t in this._INTERNAL_MODELS){if(this._INTERNAL_MODELS[t].reset){this._INTERNAL_MODELS[t].reset()}}this._oContextParameters=null;this._deregisterCustomModels();this.destroyAggregation("_extension");if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null}if(this._oPaginator){this._oPaginator.destroy();this._oPaginator=null}this._setLoadingProviderState(false)};$.prototype.getManifest=function(){var t=this.getProperty("manifest");if(t&&typeof t==="object"){return jQuery.extend(true,{},t)}return t};$.prototype.getParameters=function(){var t=this.getProperty("parameters");if(t&&typeof t==="object"){return jQuery.extend(true,{},t)}return t};$.prototype.getCombinedParameters=function(){if(!this._isManifestReady){g.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}var t=this._oCardManifest.getProcessedParameters(this._getContextAndRuntimeParams()),e={},i;for(i in t){e[i]=t[i].value}return e};$.prototype.getManifestEntry=function(t){if(!this._isManifestReady){g.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}return this._oCardManifest.get(t)};$.prototype.getManifestRawJson=function(){if(!this._oCardManifest||!this._oCardManifest){g.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{}}return this._oCardManifest.getInitialJson()};$.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){g.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{}}return jQuery.extend(true,{},this._oCardManifest._oManifest.getRawJson())};$.prototype.extendStaticConfiguration=function(t){if(this._oMessage){t.messageStrip=R.resolveValue(this._oMessage,this)}};$.prototype.resolveDestination=function(t){return this._oDestinations.getUrl(t)};$.prototype.processDestinations=function(t){return this._oDestinations.process(t)};$.prototype.showMessage=function(t,e,i){var a=this.getCardContent();if(a&&a.isA("sap.ui.integration.cards.BaseContent")){a.showMessage(t,e,i);this._oMessage={text:t,type:e,autoClose:i};this.scheduleFireStateChanged()}else{g.error("'showMessage' cannot be used before the card instance is ready. Consider using the event 'manifestApplied' event.","sap.ui.integration.widgets.Card")}};$.prototype.hideMessage=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.hideMessage();this._oMessage=null;this.scheduleFireStateChanged()}else{g.error("'showMessage' cannot be used before the card instance is ready. Consider using the event 'manifestApplied' event.","sap.ui.integration.widgets.Card")}};$.prototype.showBlockingMessage=function(t){var e=this.getCardContent();if(e){e.showBlockingMessage(t);this.scheduleFireStateChanged()}};$.prototype.getBlockingMessage=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){return t.getBlockingMessage()}else if(t&&t.isA("sap.ui.integration.controls.BlockingMessage")){return{type:t.getType(),illustrationType:t.getIllustrationType(),illustrationSize:t.getIllustrationSize(),title:t.getTitle(),description:t.getDescription(),imageSrc:t.getImageSrc()}}return null};$.prototype.hideBlockingMessage=function(){var t=this.getCardContent();if(t){t.hideBlockingMessage()}};$.prototype.getTranslatedText=function(t,e,i){var a=this.getModel("i18n");if(!a||!this._oActiveRb){g.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null}return this._oActiveRb.getText(t,e,i)};$.prototype.getDataProviderFactory=function(){if(!this._oDataProviderFactory){g.error("The DataProviderFactory instance is not ready yet. Consider using the event 'manifestApplied'.","sap.ui.integration.widgets.Card");return null}return this._oDataProviderFactory};$.prototype.getRuntimeUrl=function(t){var e=this._oCardManifest?this._oCardManifest.get("/sap.app/id"):null,i,a=t&&t.trim().replace(/^\//,"");if(e===null){g.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}if(!e||t.startsWith("http://")||t.startsWith("https://")||t.startsWith("//")){return t}i=e.replace(/\./g,"/");return sap.ui.require.toUrl(i)+"/"+a};$.prototype.sizeQuery=function(t){return this._oDisplayVariants.sizeFormatter(t)};$.prototype._prepareToApplyManifestSettings=function(){var t=this._oCardManifest.get(H.APP_TYPE),e=this.getAggregation("_extension");if(t&&t!=="card"){g.error("sap.app/type entry in manifest is not 'card'")}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy()}this._oDestinations=new P({host:this.getHostInstance(),card:this,manifestConfig:this._oCardManifest.get(H.DESTINATIONS)});this._oIconFormatter=new S({card:this});return this.processDestinations(this._oCardManifest.getJson()).then(function(t){this._oCardManifest.setJson(t);this._oDataProviderFactory=new p({host:this.getHostInstance(),extension:e,csrfTokensConfig:this._oCardManifest.get(H.CSRF_TOKENS),card:this});this._registerCustomModels();if(e){e.onCardReady()}}.bind(this))};$.prototype._applyManifestSettings=function(){this._setParametersModelData();this._checkMockPreviewMode();this._applyModelSizeLimit();this._applyLoadingDelay();this._applyServiceManifestSettings();this._applyFilterBarManifestSettings();this._applyDataManifestSettings();this._applyActionManifestSettings();this._applyHeaderManifestSettings();this._applyPaginatorManifestSettings();this._applyFooterManifestSettings();this._applyContentManifestSettings();this.fireManifestApplied()};$.prototype._setParametersModelData=function(){var t=O.getParamsForModel(),e={},i=this.getCombinedParameters(),a;for(a in i){if(V.indexOf(a)>=0){g.warning("The parameter name '"+a+"' is reserved for cards. Can not be used for creating custom parameter.")}else{e[a]={value:i[a]}}}this.getModel("parameters").setData(f(t,e))};$.prototype._applyDataManifestSettings=function(){var t=this._oCardManifest.get(H.DATA),e;if(!t){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");return}this.bindObject(R.resolveValue(t.path||"/",this));if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t.name){e=this.getModel(t.name)}else if(this._oDataProvider){e=new _;e.setSizeLimit(this.getModelSizeLimit());this.setModel(e)}if(!e){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");return}this._fnOnModelChange=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.onCardDataChanged()}if(this.getCardFooter()){this.getCardFooter().onDataChanged()}this.fireEvent("_dataPassedToContent");this.onDataRequestComplete()};e.attachEvent("change",this._fnOnModelChange,this);if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this._setLoadingProviderState(true)}.bind(this));this._oDataProvider.attachDataChanged(function(t){this.fireEvent("_dataReady");this._setModelData(t.getParameter("data"),e)}.bind(this));this._oDataProvider.attachError(function(t){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getResolvedConfiguration()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent")}};$.prototype._setModelData=function(t,e){if(this._oPaginator?.isLoadingMore()){this._oPaginator.setModelData(t,e)}else{e.setData(t)}};$.prototype._applyActionManifestSettings=function(){var t=this._oCardManifest.get(H.ACTIONS);if(!t){return}var e=new w({card:this});e.attach({area:z.Card,enabledPropertyName:"interactive",actions:t,control:this});this._oActions=e};$.prototype._applyServiceManifestSettings=function(){var t=this._oCardManifest.get(H.SERVICES);if(!t){return}if(!this._oServiceManager){this._oServiceManager=new h(t,this)}};$.prototype._applyModelSizeLimit=function(){var t=this._oCardManifest.get(H.MODEL_SIZE_LIMIT);this._iModelSizeLimit=t!==undefined?t:Q};$.prototype.getCardHeader=function(){let t=this.getAggregation("_header");if(!t&&this.getAssociation("dialogHeader")){t=n.getElementById(this.getAssociation("dialogHeader"))}return t};$.prototype._getHeaderAggregation=function(){return this.getAggregation("_header")};$.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top"}return this._oCardManifest.get(H.HEADER_POSITION)||N.Top};$.prototype.getCardContent=function(){return this.getAggregation("_content")};$.prototype.getCardFooter=function(){return this.getAggregation("_footer")};$.prototype._getActionsToolbar=function(){if(!this._oActionsToolbar){this._oActionsToolbar=new i;this._oActionsToolbar.setCard(this);this._oActionsToolbar.setEnabled(false)}return this._oActionsToolbar};$.prototype._applyHeaderManifestSettings=function(){var t=this.getCardHeader();if(t){t.setToolbar(null);t.destroy();this._bMimicPressAttached=false}var e=this.createHeader();if(!e){this.fireEvent("_headerReady");return}e.attachEvent("_error",function(t){this._handleError(t.getParameter("errorInfo"))}.bind(this));this.setAggregation("_header",e);if(e.isReady()){this.fireEvent("_headerReady")}else{e.attachEvent("_ready",function(){this.fireEvent("_headerReady")}.bind(this))}if(this._shouldMimicHeaderAction()){this._mimicHeaderAction(e)}};$.prototype._applyFilterBarManifestSettings=function(){var t=this.createFilterBar();this.destroyAggregation("_filterBar");if(!t){this.fireEvent("_filterBarReady");return}t.attachEventOnce("_filterBarDataReady",function(){this.fireEvent("_filterBarReady")}.bind(this));this.setAggregation("_filterBar",t)};$.prototype._applyFooterManifestSettings=function(){this.destroyAggregation("_footer");if(this._shouldIgnoreFooter()){return}var t=this.createFooter();if(t){this.setAggregation("_footer",t)}this.fireEvent("_footerReady")};$.prototype._applyLoadingDelay=function(){const t=parseInt(this.getManifestEntry("/sap.card/configuration/loadingPlaceholders/delay"));if(!t){return}this.getAggregation("_loadingProvider").applyDelay(t)};$.prototype.getHostInstance=function(){var t=this.getHost();if(!t){return null}return n.getElementById(t)};$.prototype._applyContentManifestSettings=function(){var t=this._oCardManifest.get(H.TYPE),e=this.getContentManifest(),i,a;if(t){i=this._oIntegrationRb.getText("ARIA_DESCRIPTION_CARD_TYPE_"+t.toUpperCase())}else{i=this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD")}this.destroyAggregation("_content");this._ariaText.setText(i);this._describedByCardTypeText.setText(i);if(this._shouldIgnoreContent()){this.fireEvent("_contentReady");return}try{a=this.createContent({cardType:t,contentManifest:e,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,noDataConfiguration:this._oCardManifest.get(H.NO_DATA_MESSAGES),paginator:this._oPaginator,overflowWithShowMore:this.getOverflow()===G.ShowMore})}catch(t){this._handleError({illustrationType:F.ErrorScreen,title:this.getTranslatedText("CARD_ERROR_CONFIGURATION_TITLE"),description:this.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION"),details:t.message,originalError:t});return}this._setCardContent(a)};$.prototype._applyPaginatorManifestSettings=function(){const t=this._oCardManifest.get(H.PAGINATOR);if(!t){this.fireEvent("_paginatorReady");return}this._oPaginator=r.create({card:this,configuration:t,paginatorModel:this.getModel("paginator"),active:!!this.getAssociation("openerReference")});if(this._oPaginator.getActive()){this._oPaginator.attachEventOnce("_ready",()=>{this.fireEvent("_paginatorReady")})}else{this.fireEvent("_paginatorReady")}};$.prototype.isTileDisplayVariant=function(){const t=[j.TileStandard,j.TileStandardWide,j.TileFlat,j.TileFlatWide];return t.indexOf(this.getDisplayVariant())>-1};$.prototype.isCompactHeader=function(){return this.getDisplayVariant()===j.CompactHeader};$.prototype.isSmallHeader=function(){return this.getDisplayVariant()===j.SmallHeader};$.prototype.isHeaderDisplayVariant=function(){const t=[j.SmallHeader,j.StandardHeader,j.CompactHeader];return t.indexOf(this.getDisplayVariant())>-1};$.prototype._isComponentCard=function(){const t=this._oCardManifest.get(H.TYPE);return t?.toLowerCase()==="component"};$.prototype._shouldIgnoreContent=function(){if(this._isComponentCard()){return false}const t=this.isTileDisplayVariant();const e=this.isHeaderDisplayVariant();const i=!this._oCardManifest.get(H.CONTENT);return t||i||e};$.prototype._shouldIgnoreFooter=function(){const t=this.isTileDisplayVariant();const e=this.isHeaderDisplayVariant();return t||e};$.prototype.createHeader=function(){var t=this._oCardManifest.get(H.HEADER),e=new D(this);return e.create(t,this._getActionsToolbar())};$.prototype.createFilterBar=function(){var t=this._oCardManifest.get(H.FILTERS),e=new I(this);return e.create(t,this.getModel("filters"),t=>{this._fireConfigurationChange({[`/sap.card/configuration/filters/${t.getParameter("key")}/value`]:t.getParameter("value")});this.resetPaginator()})};$.prototype.createFooter=function(){var t=this._oCardManifest.get(H.FOOTER);return e.create({card:this,configuration:t,showCloseButton:this.getProperty("showCloseButton"),detectVisibility:this.getOverflow()===G.ShowMore,paginator:this._oPaginator})};$.prototype.getContentManifest=function(){var t=this._oCardManifest.get(H.TYPE),e=this._isComponentCard(),i=this._oCardManifest.get(H.CONTENT),a=!!i;if(a&&!t){this._logSevereError("Card type property is mandatory!");return null}if(!a&&!e){return null}if(e){i=f(i,{componentManifest:this._oCardManifest.getJson()})}return i};$.prototype.createContent=function(t){t.cardManifest=this._oCardManifest;return this._oContentFactory.create(t)};$.prototype._setCardContent=function(t){t.attachEvent("_error",function(t){this._handleError(t.getParameter("errorInfo"))}.bind(this));this.setAggregation("_content",t);if(t.isReady()){this.fireEvent("_contentReady")}else{t.attachReady(function(){this.fireEvent("_contentReady")}.bind(this))}};$.prototype._handleError=function(t){const e=this._extensionErrorOverride(t);if(e){this.showBlockingMessage(e);return}const i=t.requestErrorParams?t.requestErrorParams.message:t.title,r=this.getCardContent();let s;g.error(i,t.originalError,"sap.ui.integration.widgets.Card");this.fireEvent("_error",{message:i});if(t.requestErrorParams){s=E.configureDataRequestErrorInfo(t,this)}else{s=E.configureErrorInfo(t,this)}if(!this._shouldIgnoreContent()){if(r&&r.isA("sap.ui.integration.cards.BaseContent")){this.showBlockingMessage(s)}else{this.destroyAggregation("_content");this.setAggregation("_content",a.create(s,this));this.fireEvent("_contentReady")}}else{this.getCardHeader().setAggregation("_error",a.create(s,this))}};$.prototype._extensionErrorOverride=function(t){const e=this.getAggregation("_extension");if(!e||!e.overrideBlockingMessage){return null}const i=t?.requestErrorParams?.response;return e.overrideBlockingMessage(i)};$.prototype.getContentMessage=function(){return this.getCardContent()?.getBlockingMessageStaticConfiguration()};$.prototype.setDataMode=function(t){if(this._oDataProviderFactory&&t===q.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null}this.setProperty("dataMode",t);if(this.getProperty("dataMode")===q.Active){this.refresh()}return this};$.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime)}if(!this._oCardManifest){return new Promise(function(t,e){this.attachManifestReady(function(){this.loadDesigntime().then(t,e)}.bind(this))}.bind(this))}var t=this._oCardManifest.get("/sap.app/id");if(!t){return Promise.reject("App id not maintained")}return new Promise(function(t,e){var i=this._oCardManifest.get("/sap.card/configuration/editor");if(i===undefined){i=this._oCardManifest.get("/sap.card/designtime")}var a=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+i;if(a){sap.ui.require([a],function(e){e=new e;e._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=e;t(e)}.bind(this))}.bind(this),function(){e({error:a+" not found"})})}else{e()}}.bind(this))};$.prototype.showLoadingPlaceholders=function(t){var e;switch(t){case U.Header:e=this.getCardHeader();if(e){e.showLoadingPlaceholders()}break;case U.Filters:e=this.getAggregation("_filterBar");if(e){e.showLoadingPlaceholders()}break;case U.Content:e=this.getCardContent();if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.showLoadingPlaceholders()}break;default:this.showLoadingPlaceholders(U.Header);this.showLoadingPlaceholders(U.Filters);this.showLoadingPlaceholders(U.Content);this._setLoadingProviderState(true)}return this};$.prototype.hideLoadingPlaceholders=function(t){var e;switch(t){case U.Header:e=this.getCardHeader();if(e){e.hideLoadingPlaceholders()}break;case U.Filters:e=this.getAggregation("_filterBar");if(e){e.hideLoadingPlaceholders()}break;case U.Content:e=this.getCardContent();if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.hideLoadingPlaceholders()}break;default:this.hideLoadingPlaceholders(U.Header);this.hideLoadingPlaceholders(U.Filters);this.hideLoadingPlaceholders(U.Content);this._setLoadingProviderState(false)}return this};$.prototype.isLoading=function(){return this.getAggregation("_loadingProvider").getLoading()};$.prototype.getFocusDomRef=function(){if(this.getGridItemRole()){return this.getDomRef()}if(this.isInteractive()&&this.getSemanticRole()===k.ListItem){return this.getDomRef()}var t=this.getCardHeader();if(t&&t.getFocusDomRef()){return t.getFocusDomRef()}return this.getDomRef()};$.prototype.onDataRequestComplete=function(){var t=this.getCardContent();this.hideLoadingPlaceholders(U.Header);this.hideLoadingPlaceholders(U.Filters);if(t&&t.isA("sap.ui.integration.cards.BaseContent")&&t.isReady()){this.hideLoadingPlaceholders(U.Content)}this._setLoadingProviderState(false)};$.prototype.request=function(t){return this.processDestinations(t).then(t=>new Promise((e,i)=>{this._oDataProviderFactory.create({request:t},undefined,undefined,undefined,true).setAllowCustomDataType(true).attachDataChanged(t=>{e(t.getParameter("data"))}).attachError(t=>{i([t.getParameter("message"),t.getParameter("response"),t.getParameter("responseText"),t.getParameter("settings")])}).triggerDataUpdate()}))};$.prototype.triggerAction=function(t){w.fireAction({card:this,host:this.getHostInstance(),action:t,parameters:t.parameters,source:this})};$.prototype.hasNoData=function(){return this.getBlockingMessage()&&this.getBlockingMessage().type===Y.NoData};$.prototype.showNoData=function(t){this.showBlockingMessage({type:Y.NoData,illustrationType:t.type,illustrationSize:t.size,title:t.title,description:t.description})};$.prototype._setPreviewMode=function(t){if(t){this.setPreviewMode(J.Abstract)}else{this.setPreviewMode(J.Off)}};$.prototype.setPreviewMode=function(t){var e=this.getPreviewMode();this.setProperty("previewMode",t);if(e!==this.getPreviewMode()){this._bApplyManifest=true}return this};$.prototype.getBindingNamespaces=function(){var t={},e=this.getAggregation("_extension");if(e){t.extension={formatters:e.getFormatters()}}t.size=this._sizeFormatterBound;return t};$.prototype._registerCustomModels=function(){var t=this._oCardManifest.findDataSections();if(!this._aCustomModels){this._aCustomModels=[]}this._deregisterCustomModels();t.forEach(function(t){var e=t&&t.name;if(!e){return}if(this._INTERNAL_MODELS[e]){g.error("The model name (data section name) '"+e+"' is reserved for cards. Can not be used for creating a custom model.");return}if(this._aCustomModels.indexOf(e)>-1){g.error("The model name (data section name) '"+e+"' is already used.");return}var i=new _;i.setSizeLimit(this.getModelSizeLimit());this.setModel(i,e);this._aCustomModels.push(e)}.bind(this))};$.prototype._deregisterCustomModels=function(){if(!this._aCustomModels){return}this._aCustomModels.forEach(function(t){this.getModel(t).destroy();this.setModel(null,t)}.bind(this));this._aCustomModels=[]};$.prototype._fireConfigurationChange=function(t){var e=this.getHostInstance();if(!this.isReady()){return}this.fireConfigurationChange({changes:t});if(e){e.fireCardConfigurationChange({card:this,changes:t})}};$.prototype.scheduleFireStateChanged=function(){if(this._iFireStateChangedCallId){clearTimeout(this._iFireStateChangedCallId)}this._iFireStateChangedCallId=setTimeout(this._fireStateChangedBound,0)};$.prototype._fireStateChanged=function(){var t=this.getHostInstance();if(!this.isReady()){return}this.fireStateChanged();if(t){t.fireCardStateChanged({card:this})}};$.prototype._fireInitialized=function(){if(this._bInitializedFired){return}var t=this.getHostInstance();this.fireEvent("_initialized");this._bInitializedFired=true;if(t){t.fireCardInitialized({card:this})}};$.prototype._fireDataChange=function(){this.fireEvent("_dataChange");this.scheduleFireStateChanged()};$.prototype._fireContentDataChange=function(){this._fireDataChange()};$.prototype._onReady=function(){this._bReady=true;this._setActionButtonsEnabled(true);this._validateContentControls(false,true);this.fireEvent("_ready");this._fireInitialized();this.scheduleFireStateChanged()};$.prototype._setLoadingProviderState=function(t){var e=this.getAggregation("_loadingProvider");if(this._isDataProviderJson()){return}e.setLoading(t);if(t){this.addActiveLoadingProvider(e)}else{this.removeActiveLoadingProvider(e)}};$.prototype.addActiveLoadingProvider=function(t){if(!this.isReady()){return}if(!this.hasActiveLoadingProvider()){this._setActionButtonsEnabled(false)}if(this._aActiveLoadingProviders.indexOf(t)===-1){this._aActiveLoadingProviders.push(t)}};$.prototype.removeActiveLoadingProvider=function(t){if(!this.isReady()){return}var e=this._aActiveLoadingProviders,i=e.indexOf(t);e.splice(i,1);if(!this.hasActiveLoadingProvider()){this._setActionButtonsEnabled(true)}};$.prototype._setActionButtonsEnabled=function(t){var e=this.getAggregation("_footer");if(e){e.setEnabled(t)}if(this._oActionsToolbar){this._oActionsToolbar.setEnabled(t)}};$.prototype.hasActiveLoadingProvider=function(){return this._aActiveLoadingProviders.length>0};$.prototype.isSkeleton=function(){return false};$.prototype.getContentPageSize=function(t){var e,i;if(this._oPaginator?.getActive()){return this._oPaginator.getPageSize()}e=R.resolveValue(t.maxItems,this);i=parseInt(e);if(!isNaN(i)&&i){return i}if(this._oPaginator){return this._oPaginator.getPageSize()}return null};$.prototype.getContentMinItems=function(t){var e=R.resolveValue(t.minItems,this),i;if(e==null){return this.getContentPageSize(t)}i=parseInt(e);if(isNaN(i)){g.error("Value for minItems must be integer.");return null}return i};$.prototype.hasPaginator=function(){return!!this._oCardManifest.get(H.PAGINATOR)};$.prototype.resetPaginator=function(){if(this._oPaginator){this._oPaginator.reset()}};$.prototype.showCard=function(t){var e=this._createChildCard(t);t._cardId=e.getId();this.triggerAction({type:"ShowCard",parameters:t});return Promise.resolve(e)};$.prototype.hide=function(){this.triggerAction({type:"HideCard"})};$.prototype.getOpener=function(){var t=n.getElementById(this.getAssociation("openerReference"));if(!t){return null}return t._oLimitedInterface};$.prototype._createChildCard=function(t){var e=t.manifest,i=t.baseUrl,a=t.data,r=this._createCard({host:this.getHostInstance(),parameters:t.parameters,referenceId:this.getReferenceId()});r.setAssociation("openerReference",this);r.setProperty("showCloseButton",!!t.showCloseButton);if(a){c(a,function(t,e){var i=new u(e);i.setSizeLimit(this.getModelSizeLimit());r.setModel(i,t)}.bind(this))}if(typeof e==="string"){r.setManifest(this.getRuntimeUrl(e));if(i){r.setBaseUrl(i)}}else{r.setManifest(e);r.setBaseUrl(i||this.getRuntimeUrl("/"))}return r};$.prototype._createCard=function(t){return new $(t)};$.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};$.prototype._checkMockPreviewMode=function(){if(this.getPreviewMode()!==J.MockData){return}var t=this._oCardManifest.findDataSections(),e;e=t.some(function(t){if(!p.isProvidingConfiguration(t)){return false}return!(t.mockData&&p.isProvidingConfiguration(t.mockData))});if(e){g.info("'mockData' configuration is missing, but the card 'previewMode' is 'MockData'. Abstract mode will be used instead.",this);this.setProperty("previewMode",J.Abstract)}};$.prototype._getActualDataMode=function(){var t=this.getDataMode();if(t===q.Auto&&this._oCardObserver.isIntersected()){return q.Active}return t};$.prototype.setDisplayVariant=function(t,e){this.setProperty("displayVariant",t,e);this._oDisplayVariants.updateSizeModel();return this};$.prototype.isInteractive=function(){const t=v.prototype.isInteractive.apply(this,arguments);return t&&this.getProperty("interactive")};$.prototype.isMouseInteractionDisabled=function(){return this._shouldMimicHeaderAction()};$.prototype._shouldMimicHeaderAction=function(){if(!this._isManifestReady){return false}const t=this.getManifestEntry("/sap.card/actions");const e=this.getManifestEntry("/sap.card/header/actions");const i=this.isRoleListItem();if(i&&!t&&e){return true}return false};$.prototype._mimicHeaderAction=function(t){t.setProperty("focusable",false);this.invalidate();t.addEventDelegate({onAfterRendering:()=>{this.setProperty("interactive",t.getInteractive());if(!t.getInteractive()){return}if(!this._bMimicPressAttached){this.attachPress(e=>{t.firePress({originalEvent:e.getParameter("originalEvent")})});this._bMimicPressAttached=true}}})};$.prototype.isDataReady=function(){return!!this._bDataReady};return $});
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/integration/widgets/CardRenderer", ["sap/f/CardRenderer","sap/ui/integration/library"],function(e,t){"use strict";const a={TYPE:"/sap.card/type",APP_ID:"/sap.app/id",CONFIG_HELP_ID:"/sap.card/configuration/helpId"};const r=t.CardDesign;const n=t.CardPreviewMode;const i=t.CardDataMode;return e.extend("sap.ui.integration.widgets.CardRenderer",{apiVersion:2,renderContainerAttributes:function(t,s){e.renderContainerAttributes.apply(this,arguments);t.class("sapUiIntCard");const d=s._oCardManifest;if(d&&d.get(a.TYPE)&&d.get(a.TYPE).toLowerCase()==="analytical"){t.class("sapUiIntCardAnalytical")}if(s.getCardFooter()&&s.getCardFooter().getVisible()){t.class("sapUiIntCardWithFooter")}if(s.getDesign()===r.Transparent){t.class("sapFCardTransparent")}if(s.getPreviewMode()===n.Abstract){t.class("sapFCardPreview")}t.class("sapUiIntCard"+s.getDisplayVariant());this.renderCardAppId(t,s);this.renderHelpId(t,s);if(s.getManifest()&&(!s.getCardHeader()||s._getActualDataMode()!==i.Active)){t.attr("tabindex","0")}const o=s.getAggregation("_loadingProvider");if(o.getDelayed()){t.class("sapFCardLoadingDelayed")}},renderCardAppId:function(e,t){const r=t._oCardManifest;const n=r&&r.get(a.APP_ID);if(n){e.attr("data-sap-ui-card-id",n)}},renderHelpId:function(e,t){if(t.data("help-id")){return}const r=t._oCardManifest;if(!r){return}const n=r.get(a.CONFIG_HELP_ID);const i=r.get(a.APP_ID);const s=n||i;if(s){e.attr("data-help-id",s)}},renderContentSection:function(t,a){var r=a.getAggregation("_filterBar");if(r){t.renderControl(r)}e.renderContentSection.apply(this,arguments)},renderFooterSection:function(e,t){var a=t.getAggregation("_footer");if(a){e.renderControl(a)}}})});
sap.ui.require.preload({
	"sap/ui/integration/customElements/CustomElementCard.js":function(){
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.require(["sap/ui/integration/widgets/Card","sap/ui/integration/customElements/CustomElementBase","sap/f/cards/CardBadgeCustomData"],function(t,e,a){"use strict";var s=e.extend(t,{privateProperties:["width","height"],customProperties:{badge:{set:function(t,e){t.getCustomData().forEach(e=>{if(e.isA("sap.m.BadgeCustomData")||e.isA("sap.f.cards.CardBadgeCustomData")){t.removeCustomData(e)}});t.addCustomData(new a({value:e}))}}}});s.prototype.refresh=function(){this._getControl().refresh()};s.prototype.loadDesigntime=function(){return this._getControl().loadDesigntime()};e.define("ui-integration-card",s)});
},
	"sap/ui/integration/customElements/CustomElementCardEditor.js":function(){
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.require(["sap/ui/integration/designtime/editor/CardEditor","sap/ui/integration/customElements/CustomElementBase"],function(t,e){"use strict";var r=e.extend(t,{});r.prototype.getCurrentSettings=function(){return this._getControl().getCurrentSettings()};r.prototype.getSeparatePreview=function(){return this._getControl().getSeparatePreview()};var i=["ui-integration-card"];e.define("ui-integration-card-editor",r,i)});
},
	"sap/ui/integration/customElements/CustomElementEditor.js":function(){
/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.require(["sap/ui/integration/editor/Editor","sap/ui/integration/customElements/CustomElementBase"],function(t,e){"use strict";var r=e.extend(t,{});r.prototype.getCurrentSettings=function(){return this._getControl().getCurrentSettings()};r.prototype.getSeparatePreview=function(){return this._getControl().getSeparatePreview()};e.define("ui-integration-editor",r)});
},
	"sap/ui/integration/library-bootstrap.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(i){"use strict";var e;var r;function u(){if(i.sap.ui.require("sap/ui/core/Core")&&i.sap.ui.require("sap/ui/core/Lib")){e=i.sap.ui.require("sap/ui/core/Core");r=i.sap.ui.require("sap/ui/core/Lib");o();return}i.sap.ui.require(["sap/ui/core/Core","sap/ui/core/Lib"],function(i,u){e=i;r=u;e.boot();e.ready().then(o)})}function n(e){var r=e.extensions["sap.ui.integration"].customElements,u=Object.keys(r);i.sap.ui.require(u.map(function(i,e){return r[u[e]]}))}function o(){r.load({name:"sap.ui.integration"}).then(function(i){n(i)})}u()})(window);
},
	"sap/ui/integration/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.integration","type":"library","embeds":[],"applicationVersion":{"version":"1.136.0"},"title":"SAPUI5 library with integration-related controls.","description":"SAPUI5 library with integration-related controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"ui5-web-components","packagedWithMySelf":true,"version":"1.7.0"},{"name":"adaptive-cards","packagedWithMySelf":true,"version":"2.9.0"},{"name":"adaptive-cards-templating","packagedWithMySelf":true,"version":"2.2.0"},{"name":"adaptive-expressions","packagedWithMySelf":true,"version":"4.15.0"},{"name":"markdown-it","packagedWithMySelf":true,"version":"12.3.2"},{"name":"@cfworker/json-schema","packagedWithMySelf":true,"version":"1.6.8"}]},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.136","libs":{"sap.ui.core":{"minVersion":"1.136.0"},"sap.f":{"minVersion":"1.136.0"},"sap.m":{"minVersion":"1.136.0"},"sap.ui.unified":{"minVersion":"1.136.0"},"sap.ui.layout":{"minVersion":"1.136.0"},"sap.ui.table":{}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.integration.widgets.Card","sap.ui.integration.cards.filters.FilterBar","sap.ui.integration.cards.Header","sap.ui.integration.cards.NumericHeader","sap.ui.integration.controls.ListContentItem","sap.ui.integration.controls.BlockingMessage","sap.ui.integration.controls.ImageWithOverlay"],"elements":["sap.ui.integration.ActionDefinition","sap.ui.integration.Host","sap.ui.integration.Extension"],"types":["sap.ui.integration.CardActionType","sap.ui.integration.CardDataMode","sap.ui.integration.CardMenuAction","sap.ui.integration.CardDesign","sap.ui.integration.CardDisplayVariant","sap.ui.integration.CardBlockingMessageType","sap.ui.integration.CardPreviewMode","sap.ui.integration.CardOverflow","sap.ui.integration.AttributesLayoutType"],"interfaces":[]}}}}',
	"sap/ui/integration/sap-ui-integration-config.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
window["sap-ui-config"]=window["sap-ui-config"]||{};window["sap-ui-config"].bindingSyntax="complex";window["sap-ui-config"].compatVersion="edge";window["sap-ui-config"].async=true;window["sap-ui-config"]["xx-waitForTheme"]=true;
},
	"sap/ui/integration/sap-ui-integration-define-nojQuery.js":function(){
/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(){"use strict";var e={"sap/ui/thirdparty/jquery":"jQuery","sap/ui/thirdparty/jqueryui/jquery-ui-core":"jQuery.ui","sap/ui/thirdparty/jqueryui/jquery-ui-widget":"jQuery.widget","sap/ui/thirdparty/jqueryui/jquery-ui-mouse":"jQuery.ui.mouse","sap/ui/thirdparty/jqueryui/jquery-ui-datepicker":"jQuery.ui.datepicker","sap/ui/thirdparty/jqueryui/jquery-ui-draggable":"jQuery.ui.draggable","sap/ui/thirdparty/jqueryui/jquery-ui-droppable":"jQuery.ui.droppable","sap/ui/thirdparty/jqueryui/jquery-ui-position":"jQuery.ui.position","sap/ui/thirdparty/jqueryui/jquery-ui-resizable":"jQuery.ui.resizable","sap/ui/thirdparty/jqueryui/jquery-ui-selectable":"jQuery.ui.selectable","sap/ui/thirdparty/jqueryui/jquery-ui-sortable":"jQuery.ui.sortable","sap/ui/thirdparty/jqueryui/jquery-ui-effect":"jQuery.effects.effect","sap/ui/thirdparty/jqueryui/jquery-ui-effect-blind":"jQuery.effects.effect.blind","sap/ui/thirdparty/jqueryui/jquery-ui-effect-bounce":"jQuery.effects.effect.bounce","sap/ui/thirdparty/jqueryui/jquery-ui-effect-clip":"jQuery.effects.effect.clip","sap/ui/thirdparty/jqueryui/jquery-ui-effect-drop":"jQuery.effects.effect.drop","sap/ui/thirdparty/jqueryui/jquery-ui-effect-explode":"jQuery.effects.effect.explode","sap/ui/thirdparty/jqueryui/jquery-ui-effect-fade":"jQuery.effects.effect.fade","sap/ui/thirdparty/jqueryui/jquery-ui-effect-fold":"jQuery.effects.effect.fold","sap/ui/thirdparty/jqueryui/jquery-ui-effect-highlight":"jQuery.effects.effect.highlight","sap/ui/thirdparty/jqueryui/jquery-ui-effect-pulsate":"jQuery.effects.effect.pulsate","sap/ui/thirdparty/jqueryui/jquery-ui-effect-scale":"jQuery.effects.effect.scale","sap/ui/thirdparty/jqueryui/jquery-ui-effect-shake":"jQuery.effects.effect.shake","sap/ui/thirdparty/jqueryui/jquery-ui-effect-slide":"jQuery.effects.effect.slide","sap/ui/thirdparty/jqueryui/jquery-ui-effect-transfer":"jQuery.effects.effect.transfer"};for(var u in e){r(u,e[u])}function r(e,u){if(!i(u)){return}sap.ui.define(e,function(){return jQuery})}function i(e){var u=e.split("."),r=window,i;i=u.some(function(e){r=r[e];return r===undefined});return!i}})();
}
});
//# sourceMappingURL=library-preload.js.map
