/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/integration/util/RequestDataProvider","sap/base/Log","sap/base/util/deepExtend","sap/ui/core/date/UI5Date"],function(e,t,a,i,s){"use strict";var r=31536e3;function n(e){var t=e.url,a=e.data,i,s;if(e.method!=="GET"){return e.url}i=new URL(t,window.location.href);for(s in a){i.searchParams.set(s,a[s])}return i.href}var o=t.extend("sap.ui.integration.util.CacheAndRequestDataProvider");o.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oRefreshWithoutCacheBound=this.refreshWithoutCache.bind(this)};o.prototype.destroy=function(){this._unsubscribeFromHostMessages();this._detachTimestampPress();t.prototype.destroy.apply(this,arguments)};o.prototype.getHostInstance=function(){return e.getElementById(this.getHost())};o.prototype.getCardInstanceHeader=function(){var e=this.getCardInstance();if(!e){return null}return e.getCardHeader()};o.prototype.onDataRequestComplete=function(){const e=this.getResolvedConfiguration();if(this._iUpdateIntervalTimeout){clearTimeout(this._iUpdateIntervalTimeout);this._iUpdateIntervalTimeout=null}if(!e||!e.updateInterval){return}const t=parseInt(e.updateInterval);if(isNaN(t)){return}this._iUpdateIntervalTimeout=setTimeout(function(){this.refreshWithoutCache()}.bind(this),t*1e3)};o.prototype._request=function(e){var a,i=this.getCardInstanceHeader();this._sCurrentRequestFullUrl=n(e.url);this._subscribeToHostMessages();a=t.prototype._request.apply(this,arguments);a.then(function(e){var t=e[1],a=t.headers.get("Date");if(a&&i){this._attachTimestampPress();i.setDataTimestamp(s.getInstance(a).toISOString())}}.bind(this));return a};o.prototype.refreshWithoutCache=function(){var e=this.getCardInstanceHeader();if(e){e.setDataTimestampUpdating(true)}setTimeout(function(){this._bCacheOnly=false;this._bNoCache=true;this._triggerDataUpdate()}.bind(this),200)};o.prototype.refreshFromCache=function(){var e=this.getCardInstanceHeader();if(e){e.setDataTimestampUpdating(true)}setTimeout(function(){this._bCacheOnly=true;this._bNoCache=false;this._triggerDataUpdate()}.bind(this),200)};o.prototype._modifyRequestBeforeSent=function(e,a){a.request=this._addCacheConfiguration(a.request);return t.prototype._modifyRequestBeforeSent.call(this,e,a)};o.prototype._addCacheConfiguration=function(e){var t={cache:{enabled:true,maxAge:0,staleWhileRevalidate:true}},a=i(t,e),s=a.cache;if(s.noStore){s.enabled=false}if(s.enabled){if(this._bCacheOnly){s.maxAge=r;s.staleWhileRevalidate=false}else if(this._bNoCache){s.maxAge=0;s.staleWhileRevalidate=false}}return a};o.prototype._getResolvedRequestConfiguration=function(){return this._addCacheConfiguration(this.getResolvedConfiguration().request)};o.prototype._subscribeToHostMessages=function(){var e=this.getHostInstance();if(this._bIsSubscribed){return}if(!e){return}e.attachMessage(this._handleHostMessage,this);this._bIsSubscribed=true};o.prototype._unsubscribeFromHostMessages=function(){var e=this.getHostInstance();if(!e){return}e.detachMessage(this._handleHostMessage,this);this._bIsSubscribed=false};o.prototype._handleHostMessage=function(e){var t=e.getParameter("data");if(t.type!=="ui-integration-card-update"){return}if(t.url!==this._sCurrentRequestFullUrl){return}a.info("[CARDS CACHE] message ui-integration-card-update received for "+t.url);this.refreshFromCache()};o.prototype._attachTimestampPress=function(e){var t=this.getCardInstance(),a=this.getCardInstanceHeader();if(this._oHeaderDelegate){return}if(!a){return}this._oHeaderDelegate={onBeforeRendering:function(){var e=t.$().find(".sapFCardDataTimestamp");e.off("click",this._oRefreshWithoutCacheBound)}.bind(this),onAfterRendering:function(){var e=t.$().find(".sapFCardDataTimestamp");e.on("click",this._oRefreshWithoutCacheBound)}.bind(this)};a.addEventDelegate(this._oHeaderDelegate)};o.prototype._detachTimestampPress=function(e){var t=this.getCardInstance(),a=this.getCardInstanceHeader(),i=t&&t.$().find(".sapFCardDataTimestamp");if(!a){return}i.off("click",this._oRefreshWithoutCacheBound);a.removeEventDelegate(this._oHeaderDelegate);this._oHeaderDelegate=null};return o});
//# sourceMappingURL=CacheAndRequestDataProvider.js.map