/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/merge","sap/ui/base/ManagedObject","sap/ui/core/Element","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/Measurement"],function(t,e,i,a,n,r){"use strict";var s=e.extend("sap.ui.integration.util.DataProvider",{metadata:{library:"sap.ui.integration",properties:{configuration:{type:"object"},configurationJson:{type:"string"},baseRuntimeUrl:{type:"string"}},events:{dataRequested:{parameters:{}},dataChanged:{parameters:{data:{type:"object"}}},error:{parameters:{message:{type:"string"}}}},associations:{card:{type:"sap.ui.integration.widgets.Card",multiple:false}}}});s.prototype.init=function(){this._iCurrentRequestNumber=0;this._oDependencies=new Set};s.prototype.setDestinations=function(t){this._oDestinations=t};s.prototype.setCsrfTokenHandler=function(t){this._oCsrfTokenHandler=t};s.prototype.addDependency=function(t){this._oDependencies.add(t)};s.prototype.setConfigurationJson=function(t){this.setProperty("configurationJson",t);if(this._bActive){this._scheduleDataUpdate(0)}};s.prototype.getResolvedConfiguration=function(){if(this.getConfigurationJson()){return JSON.parse(this.getConfigurationJson())}return this.getConfiguration()};s.prototype._getRuntimeUrl=function(t){if(t.startsWith("http://")||t.startsWith("https://")||t.startsWith("//")){return t}var e=t&&t.trim().replace(/^\//,"");return this.getBaseRuntimeUrl()+e};s.prototype.triggerDataUpdate=function(){var t,e;this.fireDataRequested();t=this._waitDependencies();e=t.then(this._triggerDataUpdate.bind(this));if(!this._pInitialRequestPromise){this._pInitialRequestPromise=e}e.catch(t=>{this.fireError({message:t})});return e};s.prototype._triggerDataUpdate=function(){var t=this.getCard(),e;this._bActive=true;this._iCurrentRequestNumber++;const i=this._iCurrentRequestNumber;if(t){e="UI5 Integration Cards "+t+" "+this.getId()+" getData#"+this._iCurrentRequestNumber;r.start(e,this.getDetails())}return this.getData().then(function(a){if(t){r.end(e)}if(i===this._iCurrentRequestNumber){this.fireDataChanged({data:a});this.onDataRequestComplete()}}.bind(this)).catch(function(i){if(t){r.end(e)}if(Array.isArray(i)&&i.length>0){this.fireError({message:i[0],response:i[1],responseText:i[2],settings:i[3]})}else{this.fireError({message:i})}this.onDataRequestComplete()}.bind(this))};s.prototype.getData=function(){const t=this.getResolvedConfiguration();return new Promise(function(e,i){if(t.json){e(t.json)}else{i("Could not get card data.")}})};s.prototype.destroy=function(){if(this._iIntervalId){clearInterval(this._iIntervalId);this._iIntervalId=null}if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId);this._iDataUpdateCallId=null}e.prototype.destroy.apply(this,arguments)};s.prototype.load=function(){return this._pInitialRequestPromise};s.prototype.onDataRequestComplete=function(){var t;var e=this.getResolvedConfiguration();if(!e||!e.updateInterval){return}t=parseInt(e.updateInterval);if(isNaN(t)){return}this._scheduleDataUpdate(t*1e3)};s.prototype.getCardInstance=function(){return i.getElementById(this.getCard())};s.prototype._scheduleDataUpdate=function(t){if(this._iDataUpdateCallId){clearTimeout(this._iDataUpdateCallId)}this._iDataUpdateCallId=setTimeout(this.triggerDataUpdate.bind(this),t)};s.prototype._waitDependencies=function(){const t=[];this._oDependencies.forEach(e=>{if(e instanceof Promise){t.push(e)}else{t.push(e.load())}});return Promise.all(t)};s.prototype.getDetails=function(){return"Static JSON data provided in the manifest."};return s});
//# sourceMappingURL=DataProvider.js.map