/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/EventProvider","sap/base/Log","sap/ui/integration/library","sap/ui/integration/util/ServiceDataProvider","sap/ui/integration/util/RequestDataProvider","sap/ui/integration/util/CacheAndRequestDataProvider","sap/ui/integration/util/DataProvider","sap/ui/integration/util/ExtensionDataProvider","sap/ui/integration/util/JSONBindingHelper","sap/ui/integration/util/BindingHelper","sap/ui/integration/util/CsrfTokenHandler","sap/ui/model/json/JSONModel"],function(e,t,i,s,o,n,r,a,d,l,u,f){"use strict";var c=i.CardPreviewMode;var h=e.extend("sap.ui.integration.util.DataProviderFactory",{constructor:function(t){e.call(this);t=t||{};this._oDestinations=t.destinations;this._oExtension=t.extension;this._oCard=t.card;this._oEditor=t.editor;this._oHost=t.host;if(t.csrfTokensConfig){this._oCsrfTokensModel=new f;this._oCsrfTokenHandler=new u({host:t.host,configuration:t.csrfTokensConfig,model:this._oCsrfTokensModel,dataProviderFactory:this})}this._aDataProviders=[];this._aFiltersProviders=[];this._pFilterBarReady=new Promise(e=>{this._oCard?.attachEventOnce("_filterBarReady",e)})}});h.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments);if(this._aDataProviders){this._aDataProviders.forEach(function(e){if(!e.bIsDestroyed){e.destroy()}});this._aDataProviders=null;this._aFiltersProviders=null}if(this._oCsrfTokenHandler){this._oCsrfTokenHandler.destroy();this._oCsrfTokenHandler=null}this._oCard=null;this._oExtension=null;this._bIsDestroyed=true};h.prototype.isDestroyed=function(){return this._bIsDestroyed};h.prototype.create=function(e,t,i,d,u){var f=this._oCard;if(!h.isProvidingConfiguration(e)||f&&f.getPreviewMode()===c.Abstract){return null}if(f&&f.getPreviewMode()===c.MockData){e=this._applyMockDataConfiguration(e)}var g=this._oEditor,p=this._oHost||f&&f.getHostInstance()||g&&g.getHostInstance(),_=p&&p.bUseExperimentalCaching,v=this._createDataProviderSettings(e,d),C;if(e.request&&_){C=new n(v);C.setHost(p)}else if(e.request){C=new o(v);if(p){C.setHost(p)}}else if(e.service){C=new s(v)}else if(e.json){C=new r(v)}else if(e.extension){C=new a(v,this._oExtension)}C.setConfiguration(e);if(f){l.propagateModels(f,C)}else if(g){l.propagateModels(g,C)}C.bindObject("/");C.setDestinations(this._oDestinations);if(C.isA("sap.ui.integration.util.IServiceDataProvider")){C.createServiceInstances(t)}this._aDataProviders.push(C);if(this._oCsrfTokenHandler){const t=this._oCsrfTokenHandler.getUsedToken(e);if(t){C.setCsrfTokenHandler(this._oCsrfTokenHandler);C.addDependency(t);C.setModel(this._oCsrfTokensModel,"csrfTokens")}}if(i){this._aFiltersProviders.push(C)}else if(!u&&this._oCard&&this._oCard.getAggregation("_filterBar")){C.addDependency(this._pFilterBarReady)}return C};h.prototype.remove=function(e){var t=this._aDataProviders.indexOf(e);if(t>-1){this._aDataProviders.splice(t,1)}if(e&&!e.bDestroyed&&e._bIsDestroyed){e.destroy()}};h.prototype.setHost=function(e){this._oHost=e;if(this._oCsrfTokenHandler){this._oCsrfTokenHandler.setHost(e)}};h.prototype._createDataProviderSettings=function(e,t){const i={};const s=this._oCard;const o=this._oEditor;if(s){i.baseRuntimeUrl=s.getRuntimeUrl("/");i.card=s;if(!t){i.configurationJson=d.createJsonWithBindingInfos(e,s.getBindingNamespaces())}}else if(o){i.baseRuntimeUrl=o.getRuntimeUrl("/");i.configurationJson=d.createJsonWithBindingInfos(e,o.getBindingNamespaces())}else{i.configurationJson=d.createJsonWithBindingInfos(e,{})}return i};h.prototype._applyMockDataConfiguration=function(e){if(!e.mockData||!h.isProvidingConfiguration(e.mockData)){t.error("There is no mock data configured.","sap.ui.integration.widgets.Card");return null}var i=Object.assign({},e);delete i.request;delete i.service;delete i.json;delete i.extension;return Object.assign(i,e.mockData)};h.isProvidingConfiguration=function(e){return e&&(e.request||e.service||e.json||e.extension)};return h});
//# sourceMappingURL=DataProviderFactory.js.map