/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/core/Lib","sap/ui/core/library","sap/base/Log","sap/base/util/deepExtend","./Validators","./BindingHelper","./BindingResolver","./DateRangeHelper","./Duration","./ComboBoxHelper"],function(e,t,r,o,i,a,n,s,l,u,d){"use strict";var p=r.ValueState;var f=e.extend("sap.ui.integration.util.Form",{constructor:function(t){e.apply(this);this._oCard=t},metadata:{library:"sap.ui.integration"}});f.prototype.init=function(){this._mControls=new Map};f.prototype.exit=function(){this._mControls.clear();delete this._mControls;delete this._oCard};f.prototype.addControl=function(e,t,r,o){if(!this._isValidControlId(r.id)){return}this._syncToFormModelOn(e,t,r,o)};f.prototype.validate=function(e,t){var r=false;this._mControls.forEach(function(t){if(this._validateControl(t,e)){r=true}}.bind(this));if(r&&!t){this._oCard.scheduleFireStateChanged()}};f.prototype.resolveControl=function(e){var t={},r=this.getModel("form").getProperty("/"+e.id),o=this.getModel("messages").getProperty("/records"),i=o.find(function(t){return t.bindingPath==="/"+e.id}),a=this._mControls.get(e.id);if(i&&(a&&a._bShowValueState)){t.valueState={message:i.message,type:i.type}}switch(e.type){case"ComboBox":t.selectedKey=r.key;r=r.value;break;case"DateRange":r=r.value;break;default:break}t.value=r;return t};f.prototype.setControlValue=function(e){if(!this._isControlDataValid(e)){return}var t=e.id,r=this._mControls.get(t),o=e.value;if(r.isA("sap.m.ComboBox")){d.setValueAndKey(r,e.key,e.value)}else if(o){if(r.isA("sap.m.DatePicker")||r.isA("sap.m.DynamicDateRange")){l.setValue(r,o,this._oCard)}else if(r.isA("sap.m.TimePicker")){r.setValue(u.fromISO(o))}else{r.setValue(o)}}this._validateAndUpdate(r)};f.prototype.updateModel=function(){this._mControls.forEach(this._updateModel.bind(this))};f.prototype._isValidControlId=function(e){if(!e){o.error("Each input control must have an ID.","sap.ui.integration.widgets.Card");return false}if(this._mControls.has(e)){o.error("Duplicate form control ID - '"+e+"'","sap.ui.integration.widgets.Card");return false}return true};f.prototype._syncToFormModelOn=function(e,t,r,o){this._prepareValidationForControl(t,r,o);t.attachEvent(e,this._validateAndUpdate,this);if(r.value&&!n.isBindingInfo(r.value)){this._updateModel(t)}this._mControls.set(r.id,t)};f.prototype._updateModel=function(e){this.getModel("form").setProperty("/"+e._oItem.id,c(e))};f.prototype._validateAndUpdate=function(e){var t=e.getSource?e.getSource():e;this._validateControl(t,true);this._updateModel(t);this._oCard.scheduleFireStateChanged()};f.prototype._isControlDataValid=function(e){if(!e){return false}var t=e.id;if(!t){o.error("Form control data is missing property 'id'.","sap.ui.integration.widgets.Card");return false}var r=this._mControls.get(t);if(!r){o.error("Form control with ID - '"+t+"' does not exist.","sap.ui.integration.widgets.Card");return false}if(r.isA(["sap.m.TextArea","sap.m.Input"])&&!("value"in e)){o.error("Form data for control ID - '"+t+"' is missing property 'value'.","sap.ui.integration.widgets.Card");return false}if(r.isA("sap.m.ComboBox")){if("value"in e||"key"in e){return true}o.error("Form data for control ID - '"+t+"' requires properties 'key' or 'value'.","sap.ui.integration.widgets.Card");return false}return true};f.prototype._prepareValidationForControl=function(e,t,r){var o=i({},t);if(o.validations){o.validations.forEach(function(e,t){if(e.pattern){e.pattern=this._oCard.getManifestEntry(r+"/validations/"+t)["pattern"]}}.bind(this))}e._oItem=o};f.prototype._validateControl=function(e,t){var r=this._oCard.getAggregation("_extension"),o=e._oItem,i=e.getBindingContext(),a=i?i.getPath():"",n=false,l;this._removeMessageFromControl(e);if(!o){return n}n=!this._checkBuiltInValidations(e,o,t);if(!n&&o.validations){l=s.resolveValue(o.validations,e,a);n=!l.every(function(i){return this._checkValidationItem(i,e,o,t,r)}.bind(this))}this._updateMessageModel();return n};f.prototype._checkValidationItem=function(e,t,r,o,i){var n=a[this._getFormControlType(r)],s,l,u,d,f=true;for(var g in e){s=e[g];if(g==="validate"){u=this._getExtensionFunctionName(s,i);if(u){d=i[u]}}else{d=n[g]}if(typeof d!=="function"){continue}l=d(c(t),s);if(!l){this._addMessageToControl(t,o,{type:e.type||p.Error,message:e.message||this._oCard.getTranslatedText(n[g+"Txt"],[s]),bindingPath:"/"+r.id});f=false;break}}return f};f.prototype._checkBuiltInValidations=function(e,r,o){var i=true;if(e.isA("sap.m.DatePicker")&&!e.isValidValue()){this._addMessageToControl(e,o,{type:p.Error,message:t.getResourceBundleFor("sap.ui.core").getText("VALUE_STATE_ERROR"),bindingPath:"/"+r.id});i=false}return i};f.prototype._addMessageToControl=function(e,t,r){var o=this.getModel("messages"),i=o.getData();i.records.push(r);o.setData(i);if(t||e._bShowValueState){e._bShowValueState=true;e.setValueState(r.type);e.setValueStateText(r.message)}this._updateMessageModel()};f.prototype._removeMessageFromControl=function(e){var t=this.getModel("messages"),r="/"+e._oItem.id,o=t.getData(),i=false;e.setValueState(p.None);for(var a=0;a<o.records.length;a++){if(o.records[a].bindingPath===r){o.records.splice(a,1);i=true;break}}if(i){t.setData(o)}this._updateMessageModel()};f.prototype._updateMessageModel=function(){var e=this.getModel("messages"),t=e.getProperty("/records");e.setProperty("/hasErrors",t.some(function(e){return e.type===p.Error}));e.setProperty("/hasWarnings",t.some(function(e){return e.type===p.Warning}))};f.prototype.getRequiredValidationValue=function(e){var t=e.validations||[],r,o,i;for(o=0;o<t.length;o++){r=t[o];for(i in r){if(i==="required"){return r[i]}}}return false};f.prototype._getExtensionFunctionName=function(e,t){if(!e.startsWith("extension.")){o.error("Validation function should start with 'extension'.");return false}if(!t){o.error("Extension is not defined.");return false}var r=e.replace("extension.","");if(!t[r]){o.error("No such function.",r,"sap.ui.integration.widgets.Card");return false}return r};f.prototype._getFormControlType=function(e){switch(e.type){case"ComboBox":return"keyValuePair";case"DateRange":return"dateRange";default:return"string"}};function c(e){if(e.isA("sap.m.ComboBox")){e.synchronizeSelection();return{key:e.getSelectedKey(),value:e.getValue()}}else if(e.isA("sap.m.DynamicDateRange")||e.isA("sap.m.DatePicker")){return l.getValueForModel(e)}else if(e.isA("sap.m.TimePicker")){return u.toISO(e.getValue())}else{return e.getValue()}}return f});
//# sourceMappingURL=Form.js.map