/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./BaseFactory","sap/base/Log","sap/base/util/isEmptyObject","sap/ui/core/Lib","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/cards/actions/NavigationAction","sap/ui/integration/library","sap/m/library","sap/ui/integration/cards/NumericHeader","sap/ui/integration/cards/Header","sap/ui/integration/controls/HeaderInfoSectionRow","sap/ui/integration/controls/HeaderInfoSectionColumn","sap/ui/integration/util/Utils","sap/m/Button","./ObjectStatusFactory","sap/m/AvatarImageFitType","sap/f/library"],function(t,e,a,i,s,r,n,o,c,u,p,l,f,d,y,m,g){"use strict";var S=n.CardActionArea;var h=n.CardActionType;var T=n.CardDisplayVariant;var b=g.cards.SemanticRole;var _=t.extend("sap.ui.integration.util.HeaderFactory");_.prototype.create=function(t,i){if(a(t)){e.warning("Card sap.card/header entry in the manifest is mandatory","sap.ui.integration.widgets.Card");return null}var r=this._oCard,n=r.getId()+"-header",o=r.getOpener(),p,l;t=this.createBindingInfos(t,r.getBindingNamespaces());if(r.isCompactHeader()){t.type=""}switch(t.type){case"Numeric":l=c.create(n,t,i,r._oIconFormatter);break;default:l=u.create(n,t,i,r._oIconFormatter);break}l.setCard(r);if(t.status&&t.status.text&&t.status.text.format){p=f.getStatusTextBindingInfo(t.status.text.format,l);if(p){l.bindProperty("statusText",p)}}l.setServiceManager(r._oServiceManager);l.setDataProviderFactory(r._oDataProviderFactory);l._setDataConfiguration(t.data);if(r.isTileDisplayVariant()){this._setTileDisplayDefaults(l,t)}else if(r.isHeaderDisplayVariant()){this._setHeaderDisplayDefaults(l,t)}var d=new s({card:r});d.attach({area:S.Header,enabledPropertyName:"interactive",actions:t.actions,control:l});l._oActions=d;if(o){l.setProperty("focusable",false);l.setProperty("headingLevel","1")}if(r.getSemanticRole()===b.ListItem&&!l.isInteractive()){l.setProperty("focusable",false)}l.applySettings({infoSection:_._createInfoSection(t)});return l};_.prototype._setTileDisplayDefaults=function(t,e){t.setProperty("useTileLayout",true);t.setProperty("useTooltips",true);const a=this._oCard;const i=[T.TileFlat,T.TileFlatWide].indexOf(a.getDisplayVariant())>-1;if(!e.titleMaxLines){t.setTitleMaxLines(i?1:2)}if(!e.icon?.fitType){t.setIconFitType(m.Contain)}if(i){t.setIconSize("XS");if(t.isA("sap.f.cards.NumericHeader")){t.setNumberSize("S")}if(!e.subtitleMaxLines){t.setSubtitleMaxLines(1)}}if(t.isA("sap.f.cards.NumericHeader")){t.getSideIndicators().forEach(t=>{t.setProperty("useTooltips",true)})}const s=e.actions&&e.actions[0];const n=s?.parameters?.url;const o=s?.parameters?.target;if(s?.type===h.Navigation&&n){t.applySettings({href:n,target:o||r.DEFAULT_TARGET,interactive:true})}};_.prototype._setHeaderDisplayDefaults=function(t,e){const a=this._oCard;t.setProperty("useTooltips",true);if(a.isCompactHeader()){t.setProperty("useTooltips",true);t.setIconSize("XS");t.setTitleMaxLines(1);t.setSubtitleMaxLines(1);t.setStatusVisible(false);return}const i=a.isSmallHeader();if(!e.titleMaxLines){t.setTitleMaxLines(i?1:2)}if(i){if(t.isA("sap.f.cards.NumericHeader")){t.setIconSize("XS");t.setNumberSize("S")}if(!e.subtitleMaxLines){t.setSubtitleMaxLines(1)}}if(t.isA("sap.f.cards.NumericHeader")){t.getSideIndicators().forEach(t=>{t.setProperty("useTooltips",true)})}};_._createInfoSection=function(t){const e=[];const a=t.infoSection;(a?.rows||[]).forEach(t=>{e.push(_._createRow(t))});return e};_._createRow=function(t){const e=[];const a=[];(t.items||[]).forEach(t=>{e.push(y.createStatusItem(t))});(t.columns||[]).forEach(t=>{a.push(_._createColumn(t))});return new p({justifyContent:t.justifyContent,columns:a,items:e})};_._createColumn=function(t){const e=[];const a=[];(t.items||[]).forEach(t=>{e.push(y.createStatusItem(t))});(t.rows||[]).forEach(t=>{a.push(_._createRow(t))});return new l({rows:a,items:e})};return _});
//# sourceMappingURL=HeaderFactory.js.map