/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/integration/util/DataProvider","sap/base/Log","sap/ui/model/odata/v4/ODataUtils","sap/base/util/fetch","sap/base/util/deepClone"],function(e,t,r,i,s,n){"use strict";var o=[429,503];var a=["no-cors","same-origin","cors"];var u=["GET","POST","HEAD","PUT","PATCH","DELETE","OPTIONS"];var f={json:"application/json, */*",xml:"application/xml, text/xml, */*"};function p(e,t){var r=Object.entries(t).map(function(e){return encodeURIComponent(e[0])+"="+encodeURIComponent(e[1])});return e+(e.indexOf("?")!==-1?"&":"?")+r.join("&")}function d(e){var t=e.headers.get("Content-Type");if(!t){return false}return t.indexOf("application/json")!==-1}function h(e){var t=e.headers.get("Content-Type");if(!t){return false}return t.indexOf("application/xml")!==-1||t.indexOf("text/xml")!==-1}var l=t.extend("sap.ui.integration.util.RequestDataProvider",{metadata:{library:"sap.ui.integration",properties:{allowCustomDataType:{type:"boolean",defaultValue:false}},associations:{host:{type:"sap.ui.integration.Host",multiple:false}}}});l.prototype.init=function(){t.prototype.init.apply(this,arguments);this._retryDueExpiredToken=false};l.prototype.destroy=function(){if(this._iRetryAfterTimeout){clearTimeout(this._iRetryAfterTimeout)}t.prototype.destroy.apply(this,arguments)};l.prototype.getLastResponse=function(){return this._lastResponse};l.prototype.getData=function(){const e=this._getResolvedRequestConfiguration();let t=Promise.resolve(e);if(this._oDestinations){t=this._oDestinations.process(e)}if(this._oCsrfTokenHandler){t=t.then(this._oCsrfTokenHandler.replacePlaceholders.bind(this._oCsrfTokenHandler))}t=t.then(this._fetch.bind(this));if(this._oCsrfTokenHandler){t=t.catch(this._handleExpiredToken.bind(this))}return t};l.prototype.triggerDataUpdate=function(){this._retryDueExpiredToken=false;return t.prototype.triggerDataUpdate.apply(this,arguments)};l.prototype.getResolvedConfiguration=function(){const e=t.prototype.getResolvedConfiguration.apply(this,arguments);this._reviveFormData(e);return e};l.prototype._reviveFormData=function(e){const t=this.getConfiguration();if(t?.request?.parameters instanceof FormData){e.request.parameters=t.request.parameters}};l.prototype._handleExpiredToken=function(e){if(!this._oCsrfTokenHandler.isExpiredToken(this.getLastResponse())){throw e}this._oCsrfTokenHandler.markExpiredTokenByRequest(this.getConfiguration().request);if(this._retryDueExpiredToken){this._retryDueExpiredToken=false;throw e}this._retryDueExpiredToken=true;this._bActive=false;return this._waitDependencies().then(this.getData.bind(this))};l.prototype._fetch=function(e){var t="Invalid request";if(!e||!e.url){r.error(t);return Promise.reject(t)}if(!this.getAllowCustomDataType()&&e.dataType){r.error("To specify dataType property in the Request Configuration, first set allowCustomDataType to 'true'.")}var s=e.url,n=e.parameters,o=this.getAllowCustomDataType()&&e.dataType||"json",a=e.headers||{},u=e.batch,d,h,l,c=e.method&&e.method.toUpperCase()||"GET",y=this._hasHeader(e,"Content-Type","application/json"),m=["GET","HEAD"].includes(c);if(!s.startsWith("/")){s=this._getRuntimeUrl(e.url)}if(n){if(y){l=JSON.stringify(n)}else if(m){s=p(s,n)}else if(n instanceof FormData){l=n}else{l=new URLSearchParams(n)}}if(u){d=i.serializeBatchRequest(Object.values(u));l=d.body;a=Object.assign({},a,d.headers)}h={url:s,options:{mode:e.mode||"cors",method:c,headers:new Headers(a)}};if(l){h.options.body=l}if(e.withCredentials){h.options.credentials="include"}if(!h.options.headers.get("Accept")&&f[o]){h.options.headers.set("Accept",f[o])}h=this._modifyRequestBeforeSent(h,this.getResolvedConfiguration());if(!this._isValidRequest(h)){r.error(t);return Promise.reject(t)}return this._request(h).then(function(e){var t=e[0];if(u){return this._deserializeBatchResponse(u,t)}return t}.bind(this))};l.prototype._request=function(e,t){var r=this._getFetchMethod(this._getResolvedRequestConfiguration());return r(e.url,e.options).then(function(r){if(this.bIsDestroyed){return Promise.reject("RequestDataProvider is already destroyed before the response is received.")}this._lastResponse=r;if(!r.ok){return r.text().then(function(i){var s=[r.status+" "+r.statusText,r,i,e];if(t){return Promise.reject(s)}return this._retryRequest(s)}.bind(this))}return r.text().then(function(t){if(d(r)){try{t=JSON.parse(t)}catch(t){return Promise.reject([t.toString(),null,null,e])}}else if(h(r)){t=(new window.DOMParser).parseFromString(t,"text/xml")}return[t,r]})}.bind(this),function(t){return Promise.reject([t.toString(),null,null,e])})};l.prototype._retryRequest=function(e){var t=e[1],i=e[3],s=this._getRetryAfter(t);if(!o.includes(t.status)){return Promise.reject(e)}if(!s){r.warning("Request could be retried, but Retry-After header or configuration parameter retryAfter are missing.");return Promise.reject(e)}if(this._iRetryAfterTimeout){e[0]="The retry was already scheduled.";return Promise.reject(e)}return new Promise(function(e,t){this._iRetryAfterTimeout=setTimeout(function(){this._request(i,true).then(e,t);this._iRetryAfterTimeout=null}.bind(this),s*1e3)}.bind(this))};l.prototype._getRetryAfter=function(e){const t=this._getResolvedRequestConfiguration(),i=e.headers.get("Retry-After")||t.retryAfter;if(!i){return 0}if(Number.isInteger(i)){return i}if(!i.match(/^\d+$/)){r.error("Only number of seconds is supported as value of retry-after. Given '"+i+"'.");return 0}return parseInt(i)};l.prototype._getFetchMethod=function(t){var r=this.getCardInstance(),i=r&&r.getAggregation("_extension"),n=e.getElementById(this.getHost());if(i){return(e,r)=>i.fetch(e,r,this._cloneRequestConfiguration(t))}if(n){return(e,i)=>n.fetch(e,i,this._cloneRequestConfiguration(t),r)}return s};l.prototype._getResolvedRequestConfiguration=function(){return this.getResolvedConfiguration().request};l.prototype._cloneRequestConfiguration=function(e){let t;if(e?.parameters instanceof FormData){t=e.parameters;delete e.parameters}const r=n(e,1e3);if(t){r.parameters=t}return r};l.prototype._hasHeader=function(e,t,r){if(!e.headers){return false}for(var i in e.headers){if(i.toLowerCase()===t.toLowerCase()&&e.headers[i]===r){return true}}return false};l.prototype._isValidRequest=function(e){if(!e){r.error("Request is not valid. Request object is missing.");return false}if(!e.url){r.error("Request is not valid. URL is missing.");return false}if(!e.options){r.error("Request is not valid. Options are missing.");return false}if(a.indexOf(e.options.mode)===-1){r.error("Request is not valid. Mode is not among "+a.toString());return false}if(u.indexOf(e.options.method)===-1){r.error("Request is not valid. Method is not among "+u.toString());return false}if(e.options.headers&&!(e.options.headers instanceof Headers)){r.error("Request is not valid. The headers option is not instance of Headers interface.");return false}if(typeof e.url!=="string"){return false}return true};l.prototype._deserializeBatchResponse=function(e,t){return new Promise(function(r,s){var n=this.getLastResponse().headers.get("Content-Type"),o=i.deserializeBatchResponse(n,t,false),a=Object.keys(e),u={};a.forEach(function(e,t){var r=o[t],i;if(!r){s("Batch responses do not match the batch requests.");return}i=new Response(r.responseText,r);if(!i.ok){s("One of batch requests fails with '"+i.status+" "+i.statusText+"'");return}u[e]=r.responseText?JSON.parse(r.responseText):{}});r(u)}.bind(this))};l.prototype._modifyRequestBeforeSent=function(t,r){var i=this.getCardInstance(),s=e.getElementById(this.getHost());if(!s){return t}if(s.modifyRequestHeaders){t.options.headers=new Headers(s.modifyRequestHeaders(Object.fromEntries(t.options.headers),r,i))}if(s.modifyRequest){t=s.modifyRequest(t,r,i)}return t};l.prototype.getDetails=function(){return"Backend interaction - load data from URL: "+this._getResolvedRequestConfiguration().url};return l});
//# sourceMappingURL=RequestDataProvider.js.map