/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./CardRenderer","../cards/Footer","../controls/ActionsToolbar","../controls/BlockingMessage","../delegate/Paginator","sap/ui/base/Interface","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/thirdparty/jquery","sap/ui/integration/util/Manifest","sap/ui/integration/util/ServiceManager","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/base/util/each","sap/ui/integration/util/DataProviderFactory","sap/ui/model/json/JSONModel","sap/ui/integration/model/ObservableModel","sap/ui/model/resource/ResourceModel","sap/ui/integration/model/ContextModel","sap/f/CardBase","sap/f/library","sap/ui/integration/library","sap/ui/integration/util/Destinations","sap/ui/integration/util/DelayedLoadingProvider","sap/ui/integration/util/HeaderFactory","sap/ui/integration/util/ContentFactory","sap/ui/integration/util/BindingResolver","sap/ui/integration/util/ErrorHandler","sap/ui/integration/formatters/IconFormatter","sap/ui/integration/cards/filters/FilterBarFactory","sap/ui/integration/cards/actions/CardActions","sap/ui/integration/util/CardObserver","sap/m/IllustratedMessageType","sap/ui/integration/util/Utils","sap/ui/integration/util/ParameterMap","sap/ui/integration/util/Measurement","sap/ui/integration/util/DisplayVariants"],function(t,e,i,a,r,s,n,o,jQuery,d,h,g,f,l,c,p,u,_,y,C,v,M,m,P,A,D,b,R,E,S,I,w,T,F,L,O,B,x){"use strict";const H={TYPE:"/sap.card/type",ACTIONS:"/sap.card/actions",DATA:"/sap.card/data",HEADER:"/sap.card/header",HEADER_POSITION:"/sap.card/headerPosition",CONTENT:"/sap.card/content",FOOTER:"/sap.card/footer",PAGINATOR:"/sap.card/footer/paginator",SERVICES:"/sap.ui5/services",APP_TYPE:"/sap.app/type",PARAMS:"/sap.card/configuration/parameters",DESTINATIONS:"/sap.card/configuration/destinations",CSRF_TOKENS:"/sap.card/configuration/csrfTokens",FILTERS:"/sap.card/configuration/filters",NO_DATA_MESSAGES:"/sap.card/configuration/messages/noData",MODEL_SIZE_LIMIT:"/sap.card/configuration/modelSizeLimit"};const V=["visibleItems","allItems"];const N=M.cards.HeaderPosition;const k=M.cards.SemanticRole;const z=m.CardActionArea;const U=m.CardArea;const q=m.CardDataMode;const W=m.CardDesign;const j=m.CardDisplayVariant;const J=m.CardPreviewMode;const G=m.CardOverflow;const Y=m.CardBlockingMessageType;const K="Card is destroyed!";const Z="module:";const Q=1e3;var $=v.extend("sap.ui.integration.widgets.Card",{metadata:{library:"sap.ui.integration",properties:{referenceId:{type:"string",defaultValue:""},manifest:{type:"any",defaultValue:""},parameters:{type:"object",defaultValue:null},dataMode:{type:"sap.ui.integration.CardDataMode",group:"Behavior",defaultValue:q.Auto},baseUrl:{type:"sap.ui.core.URI",defaultValue:null},manifestChanges:{type:"object[]",defaultValue:[]},useMockData:{type:"boolean",defaultValue:false,visibility:"hidden"},design:{type:"sap.ui.integration.CardDesign",group:"Appearance",defaultValue:W.Solid},displayVariant:{type:"sap.ui.integration.CardDisplayVariant",group:"Appearance",defaultValue:j.Standard},previewMode:{type:"sap.ui.integration.CardPreviewMode",group:"Behavior",defaultValue:J.Off},useProgressiveDisclosure:{type:"boolean",group:"Behavior",defaultValue:false},overflow:{type:"sap.ui.integration.CardOverflow",group:"Behavior",defaultValue:G.Default},showCloseButton:{type:"boolean",group:"Behavior",defaultValue:false,visibility:"hidden"},interactive:{type:"boolean",defaultValue:false,visibility:"hidden"}},aggregations:{actionDefinitions:{type:"sap.ui.integration.ActionDefinition",multiple:true,forwarding:{getter:"_getActionsToolbar",aggregation:"actionDefinitions"}},_header:{type:"sap.f.cards.IHeader",multiple:false,visibility:"hidden"},_filterBar:{type:"sap.ui.integration.cards.filters.FilterBar",multiple:false,visibility:"hidden"},_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_footer:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_extension:{type:"sap.ui.integration.Extension",multiple:false,visibility:"hidden"},_loadingProvider:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},events:{action:{allowPreventDefault:true,parameters:{actionSource:{type:"sap.ui.core.Control"},manifestParameters:{type:"object"},parameters:{type:"object"},formData:{type:"object"},type:{type:"sap.ui.integration.CardActionType"}}},configurationChange:{parameters:{changes:{type:"object"}}},manifestReady:{},manifestApplied:{},stateChanged:{}},associations:{host:{},openerReference:{visibility:"hidden"},dialogHeader:{visibility:"hidden"}}},renderer:t});$.prototype.init=function(){v.prototype.init.call(this);this.setAggregation("_loadingProvider",new A);this._oIntegrationRb=o.getResourceBundleFor("sap.ui.integration");this._iModelSizeLimit=Q;this._oDisplayVariants=new x(this);this._initModels();this._oContentFactory=new b(this);this._oCardObserver=new T(this);this._aSevereErrors=[];this._sPerformanceId="UI5 Integration Cards "+this.getId()+" ";this._aActiveLoadingProviders=[];this._fnOnDataReady=function(){this._bDataReady=true}.bind(this);this._fireStateChangedBound=this._fireStateChanged.bind(this);this._sizeFormatterBound=this._oDisplayVariants.sizeFormatter.bind(this._oDisplayVariants);this._oLimitedInterface=new s(this,["getId","getDomRef","setVisible","getParameters","getCombinedParameters","getManifestEntry","resolveDestination","request","refresh","refreshData","showMessage","getBaseUrl","getRuntimeUrl","getTranslatedText","getModel","triggerAction","addActionDefinition","removeActionDefinition","insertActionDefinition","getActionDefinition","indexOfActionDefinition","destroyActionDefinition","showLoadingPlaceholders","hideLoadingPlaceholders","showCard","hide","getOpener","validateControls","showBlockingMessage","hideBlockingMessage","getBlockingMessage"])};$.prototype._initModels=function(){this._INTERNAL_MODELS={default:{init:()=>this.setModel(new u),reset:()=>this.getModel().setData({})},parameters:{init:()=>this.setModel(new u(O.getParamsForModel()),"parameters")},filters:{init:()=>this.setModel(new u,"filters"),reset:()=>this.getModel("filters").setData({})},paginator:{init:()=>this.setModel(new u({skip:0,pageIndex:0}),"paginator"),reset:()=>this.getModel("paginator").setData({skip:0,pageIndex:0})},form:{init:()=>this.setModel(new u,"form")},messages:{init:()=>this.setModel(new u({hasErrors:false,hasWarnings:false,records:[]}),"messages")},context:{init:()=>this.setModel(new C,"context")},i18n:{init:()=>{this.setModel(new y({bundle:this._oIntegrationRb,async:true}),"i18n");this._oActiveRb=this._oIntegrationRb},reset:()=>{this._oActiveRb=this._oIntegrationRb}},size:{init:()=>this.setModel(this._oDisplayVariants.getInitialSizeModel(),"size")},widgetInfo:{init:()=>this.setModel(new u,"widgetInfo")}};for(const t in this._INTERNAL_MODELS){this._INTERNAL_MODELS[t].init()}};$.prototype.clone=function(){var t=v.prototype.clone.apply(this,arguments);t._initModels();return t};$.prototype._initReadyState=function(){this._aReadyPromises=[];const t=this._aReadyPromises;this._awaitEvent("_dataReady");this._awaitEvent("_dataPassedToContent");this._awaitEvent("_headerReady");this._awaitEvent("_filterBarReady");this._awaitEvent("_contentReady");this._awaitEvent("_paginatorReady");Promise.all(this._aReadyPromises).then(function(){if(t===this._aReadyPromises){this._onReady()}}.bind(this));this.attachEventOnce("_dataReady",this._fnOnDataReady)};$.prototype._clearReadyState=function(){this._bReady=false;this._bDataReady=false;this._aReadyPromises=[];this.detachEvent("_dataReady",this._fnOnDataReady)};$.prototype.onBeforeRendering=function(){const t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.setDesign(this.getDesign());t.setOverflowWithShowMore(this.getOverflow()===G.ShowMore)}const e=this.getCardFooter();if(e){e.setDetectVisibility(this.getOverflow()===G.ShowMore)}if(this._getActualDataMode()!==q.Active){return}this.startManifestProcessing()};$.prototype.onAfterRendering=function(){if(this._isManifestReady){if(!B.hasEnded(this._sPerformanceId+"firstRenderingWithStaticData")){B.end(this._sPerformanceId+"firstRenderingWithStaticData")}if(this._bDataReady&&!B.hasEnded(this._sPerformanceId+"firstRenderingWithDynamicData")){B.end(this._sPerformanceId+"firstRenderingWithDynamicData")}}var t=this.getDomRef();if(this._getActualDataMode()===q.Auto){this._oCardObserver.observe(t)}else{this._oCardObserver.unobserve(t)}};$.prototype.startManifestProcessing=function(){if(!L.isBindingSyntaxComplex()){this._logSevereError("Cannot parse manifest. Complex binding syntax is not enabled - "+"To enable it, set the 'compatVersion' configuration option to 'edge', e.g.: data-sap-ui-compatVersion='edge' - "+"sap.ui.integration.widgets.Card")}if(this._bApplyManifest||this._bApplyParameters){this._clearReadyState();this._initReadyState()}var t=this.getManifest();if(t&&this._bApplyManifest){this._cleanupOldManifest();this.createManifest(t,this.getBaseUrl())}if(!this._bApplyManifest&&this._bApplyParameters){this._oCardManifest.processParameters(this._getContextAndRuntimeParams());this.processDestinations(this._oCardManifest.getJson()).then(t=>{this._oCardManifest.setJson(t);this._applyManifestSettings()})}this._bApplyManifest=false;this._bApplyParameters=false;this._refreshActionsMenu()};$.prototype.setManifest=function(t){if(!l(this.getProperty("manifest"),t)){this.destroyActionDefinitions()}if(!t){this._destroyManifest()}this._bApplyManifest=true;this.setProperty("manifest",t);return this};$.prototype.setManifestChanges=function(t){this.setProperty("manifestChanges",t);this._bApplyManifest=true;return this};$.prototype.setParameters=function(t){this.setProperty("parameters",t);this._bApplyParameters=true;return this};$.prototype.setParameter=function(t,e){var i=this.getParameters()||{};i[t]=e;this.setParameters(i);return this};$.prototype.setHost=function(t){this.setAssociation("host",t);var e=this.getHostInstance();if(t&&!e){g.error("Host with id '"+t+"' is not available during card initialization. It must be available for host specific features to work.","Make sure that the host already exists, before assigning it to the card.","sap.ui.integration.widgets.Card");return this}this.getModel("context").setHost(e);if(this._oDestinations){this._oDestinations.setHost(e)}if(this._oDataProviderFactory){this._oDataProviderFactory.setHost(e)}if(e&&e.bUseExperimentalCaching){this.addStyleClass("sapFCardExperimentalCaching")}else{this.removeStyleClass("sapFCardExperimentalCaching")}return this};$.prototype.createManifest=function(t,e){var i={};this._isManifestReady=false;if(typeof t==="string"){i.manifestUrl=t;t=null}if(this._oCardManifest){this._oCardManifest.destroy()}B.start(this._sPerformanceId+"initManifest","Load and initialize manifest.");B.start(this._sPerformanceId+"firstRenderingWithStaticData","First rendering with static data (includes initManifest).");B.start(this._sPerformanceId+"firstRenderingWithDynamicData","First rendering with dynamic card level data (includes firstRenderingWithStaticData).");this._oCardManifest=new d("sap.card",t,e,this.getManifestChanges());this._oCardManifest.load(i).then(function(){if(this.isDestroyed()){throw new Error(K)}if(!this._oCardManifest.get("/sap.app/id")){this._logSevereError("Card sap.app/id entry in the manifest is mandatory")}return this._oCardManifest.loadDependenciesAndIncludes()}.bind(this)).then(function(){if(this.isDestroyed()){throw new Error(K)}B.end(this._sPerformanceId+"initManifest");this._isManifestReady=true;this.fireManifestReady();return this._loadExtension()}.bind(this)).then(this._applyManifest.bind(this)).catch(function(t){if(t.message===K){return}this._logSevereError(t.message);this._applyManifest()}.bind(this))};$.prototype._loadExtension=function(){var t=this._oCardManifest.get("/sap.card/extension"),e;if(!t){return null}if(t.startsWith(Z)){e=t.replace(Z,"")}else{e=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+t}return new Promise(function(t,i){sap.ui.require([e],function(e){var i=new e;i._setCard(this,this._oLimitedInterface);this.setAggregation("_extension",i);t()}.bind(this),function(t){this._logSevereError("Failed to load "+e+". Check if the path is correct. Reason: "+t);i(t)}.bind(this))}.bind(this))};$.prototype._logSevereError=function(t){g.error(t);this._aSevereErrors.push(t)};$.prototype.getSevereErrors=function(){return this._aSevereErrors};$.prototype.validateControls=function(){this._validateContentControls(true);return!this.getModel("messages").getProperty("/hasErrors")};$.prototype.getModelSizeLimit=function(){return this._iModelSizeLimit};$.prototype._validateContentControls=function(t,e){var i=this.getCardContent();if(i&&i.isA("sap.ui.integration.cards.BaseContent")){i.validateControls(t,e)}};$.prototype._applyManifest=async function(){var t=this._oCardManifest;if(!t.get("/sap.card")){this._logSevereError("There must be a 'sap.card' section in the manifest.")}if(t&&t.getResourceBundle()){this._oActiveRb=await this._enhanceI18nModel(t.getResourceBundle())}this.getModel("context").resetHostProperties();if(this._hasContextParams()){this._oContextParameters=await this._resolveContextParams()}t.processParameters(this._getContextAndRuntimeParams());await this._prepareToApplyManifestSettings();this._applyManifestSettings()};$.prototype._enhanceI18nModel=function(t){var e=this.getModel("i18n"),i;i=new y({async:true,bundle:t,enhanceWith:[this._oIntegrationRb]});this.setModel(i,"i18n");e.destroy();return i.getResourceBundle()};$.prototype._hasContextParams=function(){var t=this._oCardManifest.get(H.PARAMS),e,i;for(e in t){i=t[e].value;if(typeof i==="string"&&i.indexOf("{context>")!==-1){return true}}return false};$.prototype._resolveContextParams=function(){var t=this.getModel("context"),e=this._oCardManifest.get(H.PARAMS),i={},a,r;for(a in e){r=e[a].value;if(typeof r==="string"&&r.indexOf("{context>")!==-1){i[a]=r}}R.resolveValue(i,this,"/");return t.waitForPendingProperties().then(function(){return R.resolveValue(i,this,"/")}.bind(this))};$.prototype._getContextAndRuntimeParams=function(){var t=this._oContextParameters||{},e=this.getParameters()||{};return f(t,e)};$.prototype._awaitEvent=function(t){this._aReadyPromises.push(new Promise(function(e){this.attachEventOnce(t,function(){e()})}.bind(this)))};$.prototype.isReady=function(){return this._bReady};$.prototype.refresh=function(){if(this._getActualDataMode()===q.Active){this._bApplyManifest=true;this.invalidate()}};$.prototype.setFilterValue=function(t,e){var i=this._oCardManifest.get(H.FILTERS);if(!i.hasOwnProperty(t)){g.error("Filter with key '"+t+"' does not exist in the manifest section 'filters'.","sap.ui.integration.widgets.Card");return}var a=this.getAggregation("_filterBar");if(!a){return}var r=a._getFilters().find(function(e){return e.getKey()===t});r.setValueFromOutside(e)};$.prototype.setFormValues=function(t){var e=this.getCardContent();if(e&&!e.isA("sap.ui.integration.cards.ObjectContent")){g.error("Setting form element values is available only on an Object card","sap.ui.integration.widgets.Card");return}t.forEach(function(t){e.setFormFieldValue(t)})};$.prototype.refreshData=function(){if(!this.isReady()){return}this.refreshAllData();this.resetPaginator()};$.prototype.refreshAllData=function(){var t=this.getCardHeader(),e=this.getCardContent(),i=this.getAggregation("_filterBar");if(this._oDataProvider){this._oDataProvider.triggerDataUpdate()}if(t){t.refreshData()}if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.refreshData()}else{this._applyContentManifestSettings()}if(i){i.refreshData()}};$.prototype._refreshActionsMenu=function(){var t=this.getCardHeader(),e=this.getHostInstance(),i=this.getAggregation("_extension"),a=[];if(!t){return}if(e){a=a.concat(e.getActions()||[])}if(i){a=a.concat(i.getActions()||[])}if(l(a,this._getActionsToolbar()._aActions)){return}this._getActionsToolbar().initializeContent(this)};$.prototype.exit=function(){v.prototype.exit.call(this);this._destroyManifest();this._oCardObserver.destroy();this._oCardObserver=null;this._oDisplayVariants=null;this._oContentFactory=null;this._oIntegrationRb=null;this._aActiveLoadingProviders=null;this._oMessage=null;clearTimeout(this._iFireStateChangedCallId);if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null}if(this._oActions){this._oActions.destroy();this._oActions=null}};$.prototype._destroyManifest=function(){if(this._oCardManifest){this._oCardManifest.destroy();this._oCardManifest=null}if(this._oServiceManager){this._oServiceManager.destroy();this._oServiceManager=null}if(this._oDestinations){this._oDestinations.destroy();this._oDestinations=null}if(this._oIconFormatter){this._oIconFormatter.destroy();this._oIconFormatter=null}if(this._oActionsToolbar){this._oActionsToolbar.destroy();this._oActionsToolbar=null}this.destroyAggregation("_header");this.destroyAggregation("_content");this.destroyAggregation("_filterBar");this.destroyAggregation("_footer");this._cleanupOldManifest()};$.prototype._cleanupOldManifest=function(){if(this._fnOnModelChange){this.getModel().detachEvent("change",this._fnOnModelChange,this);delete this._fnOnModelChange}for(const t in this._INTERNAL_MODELS){if(this._INTERNAL_MODELS[t].reset){this._INTERNAL_MODELS[t].reset()}}this._oContextParameters=null;this._deregisterCustomModels();this.destroyAggregation("_extension");if(this._oDataProviderFactory){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null;this._oDataProvider=null}if(this._oPaginator){this._oPaginator.destroy();this._oPaginator=null}this._setLoadingProviderState(false)};$.prototype.getManifest=function(){var t=this.getProperty("manifest");if(t&&typeof t==="object"){return jQuery.extend(true,{},t)}return t};$.prototype.getParameters=function(){var t=this.getProperty("parameters");if(t&&typeof t==="object"){return jQuery.extend(true,{},t)}return t};$.prototype.getCombinedParameters=function(){if(!this._isManifestReady){g.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}var t=this._oCardManifest.getProcessedParameters(this._getContextAndRuntimeParams()),e={},i;for(i in t){e[i]=t[i].value}return e};$.prototype.getManifestEntry=function(t){if(!this._isManifestReady){g.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}return this._oCardManifest.get(t)};$.prototype.getManifestRawJson=function(){if(!this._oCardManifest||!this._oCardManifest){g.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{}}return this._oCardManifest.getInitialJson()};$.prototype.getManifestWithMergedChanges=function(){if(!this._oCardManifest||!this._oCardManifest._oManifest){g.error("The manifest is not ready. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return{}}return jQuery.extend(true,{},this._oCardManifest._oManifest.getRawJson())};$.prototype.extendStaticConfiguration=function(t){if(this._oMessage){t.messageStrip=R.resolveValue(this._oMessage,this)}};$.prototype.resolveDestination=function(t){return this._oDestinations.getUrl(t)};$.prototype.processDestinations=function(t){return this._oDestinations.process(t)};$.prototype.showMessage=function(t,e,i){var a=this.getCardContent();if(a&&a.isA("sap.ui.integration.cards.BaseContent")){a.showMessage(t,e,i);this._oMessage={text:t,type:e,autoClose:i};this.scheduleFireStateChanged()}else{g.error("'showMessage' cannot be used before the card instance is ready. Consider using the event 'manifestApplied' event.","sap.ui.integration.widgets.Card")}};$.prototype.hideMessage=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.hideMessage();this._oMessage=null;this.scheduleFireStateChanged()}else{g.error("'showMessage' cannot be used before the card instance is ready. Consider using the event 'manifestApplied' event.","sap.ui.integration.widgets.Card")}};$.prototype.showBlockingMessage=function(t){var e=this.getCardContent();if(e){e.showBlockingMessage(t);this.scheduleFireStateChanged()}};$.prototype.getBlockingMessage=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){return t.getBlockingMessage()}else if(t&&t.isA("sap.ui.integration.controls.BlockingMessage")){return{type:t.getType(),illustrationType:t.getIllustrationType(),illustrationSize:t.getIllustrationSize(),title:t.getTitle(),description:t.getDescription(),imageSrc:t.getImageSrc()}}return null};$.prototype.hideBlockingMessage=function(){var t=this.getCardContent();if(t){t.hideBlockingMessage()}};$.prototype.getTranslatedText=function(t,e,i){var a=this.getModel("i18n");if(!a||!this._oActiveRb){g.warning("There are no translations available. Either the i18n configuration is missing or the method is called too early.");return null}return this._oActiveRb.getText(t,e,i)};$.prototype.getDataProviderFactory=function(){if(!this._oDataProviderFactory){g.error("The DataProviderFactory instance is not ready yet. Consider using the event 'manifestApplied'.","sap.ui.integration.widgets.Card");return null}return this._oDataProviderFactory};$.prototype.getRuntimeUrl=function(t){var e=this._oCardManifest?this._oCardManifest.get("/sap.app/id"):null,i,a=t&&t.trim().replace(/^\//,"");if(e===null){g.error("The manifest is not ready so the URL can not be resolved. Consider using the 'manifestReady' event.","sap.ui.integration.widgets.Card");return null}if(!e||t.startsWith("http://")||t.startsWith("https://")||t.startsWith("//")){return t}i=e.replace(/\./g,"/");return sap.ui.require.toUrl(i)+"/"+a};$.prototype.sizeQuery=function(t){return this._oDisplayVariants.sizeFormatter(t)};$.prototype._prepareToApplyManifestSettings=function(){var t=this._oCardManifest.get(H.APP_TYPE),e=this.getAggregation("_extension");if(t&&t!=="card"){g.error("sap.app/type entry in manifest is not 'card'")}if(this._oDataProviderFactory){this._oDataProviderFactory.destroy()}this._oDestinations=new P({host:this.getHostInstance(),card:this,manifestConfig:this._oCardManifest.get(H.DESTINATIONS)});this._oIconFormatter=new S({card:this});return this.processDestinations(this._oCardManifest.getJson()).then(function(t){this._oCardManifest.setJson(t);this._oDataProviderFactory=new p({host:this.getHostInstance(),extension:e,csrfTokensConfig:this._oCardManifest.get(H.CSRF_TOKENS),card:this});this._registerCustomModels();if(e){e.onCardReady()}}.bind(this))};$.prototype._applyManifestSettings=function(){this._setParametersModelData();this._checkMockPreviewMode();this._applyModelSizeLimit();this._applyLoadingDelay();this._applyServiceManifestSettings();this._applyFilterBarManifestSettings();this._applyDataManifestSettings();this._applyActionManifestSettings();this._applyHeaderManifestSettings();this._applyPaginatorManifestSettings();this._applyFooterManifestSettings();this._applyContentManifestSettings();this.fireManifestApplied()};$.prototype._setParametersModelData=function(){var t=O.getParamsForModel(),e={},i=this.getCombinedParameters(),a;for(a in i){if(V.indexOf(a)>=0){g.warning("The parameter name '"+a+"' is reserved for cards. Can not be used for creating custom parameter.")}else{e[a]={value:i[a]}}}this.getModel("parameters").setData(f(t,e))};$.prototype._applyDataManifestSettings=function(){var t=this._oCardManifest.get(H.DATA),e;if(!t){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");return}this.bindObject(R.resolveValue(t.path||"/",this));if(this._oDataProvider){this._oDataProvider.destroy()}this._oDataProvider=this._oDataProviderFactory.create(t,this._oServiceManager);if(t.name){e=this.getModel(t.name)}else if(this._oDataProvider){e=new _;e.setSizeLimit(this.getModelSizeLimit());this.setModel(e)}if(!e){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");return}this._fnOnModelChange=function(){var t=this.getCardContent();if(t&&t.isA("sap.ui.integration.cards.BaseContent")){t.onCardDataChanged()}if(this.getCardFooter()){this.getCardFooter().onDataChanged()}this.fireEvent("_dataPassedToContent");this.onDataRequestComplete()};e.attachEvent("change",this._fnOnModelChange,this);if(this._oDataProvider){this._oDataProvider.attachDataRequested(function(){this._setLoadingProviderState(true)}.bind(this));this._oDataProvider.attachDataChanged(function(t){this.fireEvent("_dataReady");this._setModelData(t.getParameter("data"),e)}.bind(this));this._oDataProvider.attachError(function(t){this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent");this._handleError({requestErrorParams:t.getParameters(),requestSettings:this._oDataProvider.getResolvedConfiguration()});this.onDataRequestComplete()}.bind(this));this._oDataProvider.triggerDataUpdate()}else{this.fireEvent("_dataReady");this.fireEvent("_dataPassedToContent")}};$.prototype._setModelData=function(t,e){if(this._oPaginator?.isLoadingMore()){this._oPaginator.setModelData(t,e)}else{e.setData(t)}};$.prototype._applyActionManifestSettings=function(){var t=this._oCardManifest.get(H.ACTIONS);if(!t){return}var e=new w({card:this});e.attach({area:z.Card,enabledPropertyName:"interactive",actions:t,control:this});this._oActions=e};$.prototype._applyServiceManifestSettings=function(){var t=this._oCardManifest.get(H.SERVICES);if(!t){return}if(!this._oServiceManager){this._oServiceManager=new h(t,this)}};$.prototype._applyModelSizeLimit=function(){var t=this._oCardManifest.get(H.MODEL_SIZE_LIMIT);this._iModelSizeLimit=t!==undefined?t:Q};$.prototype.getCardHeader=function(){let t=this.getAggregation("_header");if(!t&&this.getAssociation("dialogHeader")){t=n.getElementById(this.getAssociation("dialogHeader"))}return t};$.prototype._getHeaderAggregation=function(){return this.getAggregation("_header")};$.prototype.getCardHeaderPosition=function(){if(!this._oCardManifest){return"Top"}return this._oCardManifest.get(H.HEADER_POSITION)||N.Top};$.prototype.getCardContent=function(){return this.getAggregation("_content")};$.prototype.getCardFooter=function(){return this.getAggregation("_footer")};$.prototype._getActionsToolbar=function(){if(!this._oActionsToolbar){this._oActionsToolbar=new i;this._oActionsToolbar.setCard(this);this._oActionsToolbar.setEnabled(false)}return this._oActionsToolbar};$.prototype._applyHeaderManifestSettings=function(){var t=this.getCardHeader();if(t){t.setToolbar(null);t.destroy();this._bMimicPressAttached=false}var e=this.createHeader();if(!e){this.fireEvent("_headerReady");return}e.attachEvent("_error",function(t){this._handleError(t.getParameter("errorInfo"))}.bind(this));this.setAggregation("_header",e);if(e.isReady()){this.fireEvent("_headerReady")}else{e.attachEvent("_ready",function(){this.fireEvent("_headerReady")}.bind(this))}if(this._shouldMimicHeaderAction()){this._mimicHeaderAction(e)}};$.prototype._applyFilterBarManifestSettings=function(){var t=this.createFilterBar();this.destroyAggregation("_filterBar");if(!t){this.fireEvent("_filterBarReady");return}t.attachEventOnce("_filterBarDataReady",function(){this.fireEvent("_filterBarReady")}.bind(this));this.setAggregation("_filterBar",t)};$.prototype._applyFooterManifestSettings=function(){this.destroyAggregation("_footer");if(this._shouldIgnoreFooter()){return}var t=this.createFooter();if(t){this.setAggregation("_footer",t)}this.fireEvent("_footerReady")};$.prototype._applyLoadingDelay=function(){const t=parseInt(this.getManifestEntry("/sap.card/configuration/loadingPlaceholders/delay"));if(!t){return}this.getAggregation("_loadingProvider").applyDelay(t)};$.prototype.getHostInstance=function(){var t=this.getHost();if(!t){return null}return n.getElementById(t)};$.prototype._applyContentManifestSettings=function(){var t=this._oCardManifest.get(H.TYPE),e=this.getContentManifest(),i,a;if(t){i=this._oIntegrationRb.getText("ARIA_DESCRIPTION_CARD_TYPE_"+t.toUpperCase())}else{i=this._oRb.getText("ARIA_ROLEDESCRIPTION_CARD")}this.destroyAggregation("_content");this._ariaText.setText(i);this._describedByCardTypeText.setText(i);if(this._shouldIgnoreContent()){this.fireEvent("_contentReady");return}try{a=this.createContent({cardType:t,contentManifest:e,serviceManager:this._oServiceManager,dataProviderFactory:this._oDataProviderFactory,iconFormatter:this._oIconFormatter,noDataConfiguration:this._oCardManifest.get(H.NO_DATA_MESSAGES),paginator:this._oPaginator,overflowWithShowMore:this.getOverflow()===G.ShowMore})}catch(t){this._handleError({illustrationType:F.ErrorScreen,title:this.getTranslatedText("CARD_ERROR_CONFIGURATION_TITLE"),description:this.getTranslatedText("CARD_ERROR_CONFIGURATION_DESCRIPTION"),details:t.message,originalError:t});return}this._setCardContent(a)};$.prototype._applyPaginatorManifestSettings=function(){const t=this._oCardManifest.get(H.PAGINATOR);if(!t){this.fireEvent("_paginatorReady");return}this._oPaginator=r.create({card:this,configuration:t,paginatorModel:this.getModel("paginator"),active:!!this.getAssociation("openerReference")});if(this._oPaginator.getActive()){this._oPaginator.attachEventOnce("_ready",()=>{this.fireEvent("_paginatorReady")})}else{this.fireEvent("_paginatorReady")}};$.prototype.isTileDisplayVariant=function(){const t=[j.TileStandard,j.TileStandardWide,j.TileFlat,j.TileFlatWide];return t.indexOf(this.getDisplayVariant())>-1};$.prototype.isCompactHeader=function(){return this.getDisplayVariant()===j.CompactHeader};$.prototype.isSmallHeader=function(){return this.getDisplayVariant()===j.SmallHeader};$.prototype.isHeaderDisplayVariant=function(){const t=[j.SmallHeader,j.StandardHeader,j.CompactHeader];return t.indexOf(this.getDisplayVariant())>-1};$.prototype._isComponentCard=function(){const t=this._oCardManifest.get(H.TYPE);return t?.toLowerCase()==="component"};$.prototype._shouldIgnoreContent=function(){if(this._isComponentCard()){return false}const t=this.isTileDisplayVariant();const e=this.isHeaderDisplayVariant();const i=!this._oCardManifest.get(H.CONTENT);return t||i||e};$.prototype._shouldIgnoreFooter=function(){const t=this.isTileDisplayVariant();const e=this.isHeaderDisplayVariant();return t||e};$.prototype.createHeader=function(){var t=this._oCardManifest.get(H.HEADER),e=new D(this);return e.create(t,this._getActionsToolbar())};$.prototype.createFilterBar=function(){var t=this._oCardManifest.get(H.FILTERS),e=new I(this);return e.create(t,this.getModel("filters"),t=>{this._fireConfigurationChange({[`/sap.card/configuration/filters/${t.getParameter("key")}/value`]:t.getParameter("value")});this.resetPaginator()})};$.prototype.createFooter=function(){var t=this._oCardManifest.get(H.FOOTER);return e.create({card:this,configuration:t,showCloseButton:this.getProperty("showCloseButton"),detectVisibility:this.getOverflow()===G.ShowMore,paginator:this._oPaginator})};$.prototype.getContentManifest=function(){var t=this._oCardManifest.get(H.TYPE),e=this._isComponentCard(),i=this._oCardManifest.get(H.CONTENT),a=!!i;if(a&&!t){this._logSevereError("Card type property is mandatory!");return null}if(!a&&!e){return null}if(e){i=f(i,{componentManifest:this._oCardManifest.getJson()})}return i};$.prototype.createContent=function(t){t.cardManifest=this._oCardManifest;return this._oContentFactory.create(t)};$.prototype._setCardContent=function(t){t.attachEvent("_error",function(t){this._handleError(t.getParameter("errorInfo"))}.bind(this));this.setAggregation("_content",t);if(t.isReady()){this.fireEvent("_contentReady")}else{t.attachReady(function(){this.fireEvent("_contentReady")}.bind(this))}};$.prototype._handleError=function(t){const e=this._extensionErrorOverride(t);if(e){this.showBlockingMessage(e);return}const i=t.requestErrorParams?t.requestErrorParams.message:t.title,r=this.getCardContent();let s;g.error(i,t.originalError,"sap.ui.integration.widgets.Card");this.fireEvent("_error",{message:i});if(t.requestErrorParams){s=E.configureDataRequestErrorInfo(t,this)}else{s=E.configureErrorInfo(t,this)}if(!this._shouldIgnoreContent()){if(r&&r.isA("sap.ui.integration.cards.BaseContent")){this.showBlockingMessage(s)}else{this.destroyAggregation("_content");this.setAggregation("_content",a.create(s,this));this.fireEvent("_contentReady")}}else{this.getCardHeader().setAggregation("_error",a.create(s,this))}};$.prototype._extensionErrorOverride=function(t){const e=this.getAggregation("_extension");if(!e||!e.overrideBlockingMessage){return null}const i=t?.requestErrorParams?.response;return e.overrideBlockingMessage(i)};$.prototype.getContentMessage=function(){return this.getCardContent()?.getBlockingMessageStaticConfiguration()};$.prototype.setDataMode=function(t){if(this._oDataProviderFactory&&t===q.Inactive){this._oDataProviderFactory.destroy();this._oDataProviderFactory=null}this.setProperty("dataMode",t);if(this.getProperty("dataMode")===q.Active){this.refresh()}return this};$.prototype.loadDesigntime=function(){if(this._oDesigntime){return Promise.resolve(this._oDesigntime)}if(!this._oCardManifest){return new Promise(function(t,e){this.attachManifestReady(function(){this.loadDesigntime().then(t,e)}.bind(this))}.bind(this))}var t=this._oCardManifest.get("/sap.app/id");if(!t){return Promise.reject("App id not maintained")}return new Promise(function(t,e){var i=this._oCardManifest.get("/sap.card/configuration/editor");if(i===undefined){i=this._oCardManifest.get("/sap.card/designtime")}var a=this._oCardManifest.get("/sap.app/id").replace(/\./g,"/")+"/"+i;if(a){sap.ui.require([a],function(e){e=new e;e._readyPromise(this._oLimitedInterface,this).then(function(){this._oDesigntime=e;t(e)}.bind(this))}.bind(this),function(){e({error:a+" not found"})})}else{e()}}.bind(this))};$.prototype.showLoadingPlaceholders=function(t){var e;switch(t){case U.Header:e=this.getCardHeader();if(e){e.showLoadingPlaceholders()}break;case U.Filters:e=this.getAggregation("_filterBar");if(e){e.showLoadingPlaceholders()}break;case U.Content:e=this.getCardContent();if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.showLoadingPlaceholders()}break;default:this.showLoadingPlaceholders(U.Header);this.showLoadingPlaceholders(U.Filters);this.showLoadingPlaceholders(U.Content);this._setLoadingProviderState(true)}return this};$.prototype.hideLoadingPlaceholders=function(t){var e;switch(t){case U.Header:e=this.getCardHeader();if(e){e.hideLoadingPlaceholders()}break;case U.Filters:e=this.getAggregation("_filterBar");if(e){e.hideLoadingPlaceholders()}break;case U.Content:e=this.getCardContent();if(e&&e.isA("sap.ui.integration.cards.BaseContent")){e.hideLoadingPlaceholders()}break;default:this.hideLoadingPlaceholders(U.Header);this.hideLoadingPlaceholders(U.Filters);this.hideLoadingPlaceholders(U.Content);this._setLoadingProviderState(false)}return this};$.prototype.isLoading=function(){return this.getAggregation("_loadingProvider").getLoading()};$.prototype.getFocusDomRef=function(){if(this.getGridItemRole()){return this.getDomRef()}if(this.isInteractive()&&this.getSemanticRole()===k.ListItem){return this.getDomRef()}var t=this.getCardHeader();if(t&&t.getFocusDomRef()){return t.getFocusDomRef()}return this.getDomRef()};$.prototype.onDataRequestComplete=function(){var t=this.getCardContent();this.hideLoadingPlaceholders(U.Header);this.hideLoadingPlaceholders(U.Filters);if(t&&t.isA("sap.ui.integration.cards.BaseContent")&&t.isReady()){this.hideLoadingPlaceholders(U.Content)}this._setLoadingProviderState(false)};$.prototype.request=function(t){return this.processDestinations(t).then(t=>new Promise((e,i)=>{this._oDataProviderFactory.create({request:t},undefined,undefined,undefined,true).setAllowCustomDataType(true).attachDataChanged(t=>{e(t.getParameter("data"))}).attachError(t=>{i([t.getParameter("message"),t.getParameter("response"),t.getParameter("responseText"),t.getParameter("settings")])}).triggerDataUpdate()}))};$.prototype.triggerAction=function(t){w.fireAction({card:this,host:this.getHostInstance(),action:t,parameters:t.parameters,source:this})};$.prototype.hasNoData=function(){return this.getBlockingMessage()&&this.getBlockingMessage().type===Y.NoData};$.prototype.showNoData=function(t){this.showBlockingMessage({type:Y.NoData,illustrationType:t.type,illustrationSize:t.size,title:t.title,description:t.description})};$.prototype._setPreviewMode=function(t){if(t){this.setPreviewMode(J.Abstract)}else{this.setPreviewMode(J.Off)}};$.prototype.setPreviewMode=function(t){var e=this.getPreviewMode();this.setProperty("previewMode",t);if(e!==this.getPreviewMode()){this._bApplyManifest=true}return this};$.prototype.getBindingNamespaces=function(){var t={},e=this.getAggregation("_extension");if(e){t.extension={formatters:e.getFormatters()}}t.size=this._sizeFormatterBound;return t};$.prototype._registerCustomModels=function(){var t=this._oCardManifest.findDataSections();if(!this._aCustomModels){this._aCustomModels=[]}this._deregisterCustomModels();t.forEach(function(t){var e=t&&t.name;if(!e){return}if(this._INTERNAL_MODELS[e]){g.error("The model name (data section name) '"+e+"' is reserved for cards. Can not be used for creating a custom model.");return}if(this._aCustomModels.indexOf(e)>-1){g.error("The model name (data section name) '"+e+"' is already used.");return}var i=new _;i.setSizeLimit(this.getModelSizeLimit());this.setModel(i,e);this._aCustomModels.push(e)}.bind(this))};$.prototype._deregisterCustomModels=function(){if(!this._aCustomModels){return}this._aCustomModels.forEach(function(t){this.getModel(t).destroy();this.setModel(null,t)}.bind(this));this._aCustomModels=[]};$.prototype._fireConfigurationChange=function(t){var e=this.getHostInstance();if(!this.isReady()){return}this.fireConfigurationChange({changes:t});if(e){e.fireCardConfigurationChange({card:this,changes:t})}};$.prototype.scheduleFireStateChanged=function(){if(this._iFireStateChangedCallId){clearTimeout(this._iFireStateChangedCallId)}this._iFireStateChangedCallId=setTimeout(this._fireStateChangedBound,0)};$.prototype._fireStateChanged=function(){var t=this.getHostInstance();if(!this.isReady()){return}this.fireStateChanged();if(t){t.fireCardStateChanged({card:this})}};$.prototype._fireInitialized=function(){if(this._bInitializedFired){return}var t=this.getHostInstance();this.fireEvent("_initialized");this._bInitializedFired=true;if(t){t.fireCardInitialized({card:this})}};$.prototype._fireDataChange=function(){this.fireEvent("_dataChange");this.scheduleFireStateChanged()};$.prototype._fireContentDataChange=function(){this._fireDataChange()};$.prototype._onReady=function(){this._bReady=true;this._setActionButtonsEnabled(true);this._validateContentControls(false,true);this.fireEvent("_ready");this._fireInitialized();this.scheduleFireStateChanged()};$.prototype._setLoadingProviderState=function(t){var e=this.getAggregation("_loadingProvider");if(this._isDataProviderJson()){return}e.setLoading(t);if(t){this.addActiveLoadingProvider(e)}else{this.removeActiveLoadingProvider(e)}};$.prototype.addActiveLoadingProvider=function(t){if(!this.isReady()){return}if(!this.hasActiveLoadingProvider()){this._setActionButtonsEnabled(false)}if(this._aActiveLoadingProviders.indexOf(t)===-1){this._aActiveLoadingProviders.push(t)}};$.prototype.removeActiveLoadingProvider=function(t){if(!this.isReady()){return}var e=this._aActiveLoadingProviders,i=e.indexOf(t);e.splice(i,1);if(!this.hasActiveLoadingProvider()){this._setActionButtonsEnabled(true)}};$.prototype._setActionButtonsEnabled=function(t){var e=this.getAggregation("_footer");if(e){e.setEnabled(t)}if(this._oActionsToolbar){this._oActionsToolbar.setEnabled(t)}};$.prototype.hasActiveLoadingProvider=function(){return this._aActiveLoadingProviders.length>0};$.prototype.isSkeleton=function(){return false};$.prototype.getContentPageSize=function(t){var e,i;if(this._oPaginator?.getActive()){return this._oPaginator.getPageSize()}e=R.resolveValue(t.maxItems,this);i=parseInt(e);if(!isNaN(i)&&i){return i}if(this._oPaginator){return this._oPaginator.getPageSize()}return null};$.prototype.getContentMinItems=function(t){var e=R.resolveValue(t.minItems,this),i;if(e==null){return this.getContentPageSize(t)}i=parseInt(e);if(isNaN(i)){g.error("Value for minItems must be integer.");return null}return i};$.prototype.hasPaginator=function(){return!!this._oCardManifest.get(H.PAGINATOR)};$.prototype.resetPaginator=function(){if(this._oPaginator){this._oPaginator.reset()}};$.prototype.showCard=function(t){var e=this._createChildCard(t);t._cardId=e.getId();this.triggerAction({type:"ShowCard",parameters:t});return Promise.resolve(e)};$.prototype.hide=function(){this.triggerAction({type:"HideCard"})};$.prototype.getOpener=function(){var t=n.getElementById(this.getAssociation("openerReference"));if(!t){return null}return t._oLimitedInterface};$.prototype._createChildCard=function(t){var e=t.manifest,i=t.baseUrl,a=t.data,r=this._createCard({host:this.getHostInstance(),parameters:t.parameters,referenceId:this.getReferenceId()});r.setAssociation("openerReference",this);r.setProperty("showCloseButton",!!t.showCloseButton);if(a){c(a,function(t,e){var i=new u(e);i.setSizeLimit(this.getModelSizeLimit());r.setModel(i,t)}.bind(this))}if(typeof e==="string"){r.setManifest(this.getRuntimeUrl(e));if(i){r.setBaseUrl(i)}}else{r.setManifest(e);r.setBaseUrl(i||this.getRuntimeUrl("/"))}return r};$.prototype._createCard=function(t){return new $(t)};$.prototype._isDataProviderJson=function(){return!!this._oDataProvider?.getConfiguration()?.json};$.prototype._checkMockPreviewMode=function(){if(this.getPreviewMode()!==J.MockData){return}var t=this._oCardManifest.findDataSections(),e;e=t.some(function(t){if(!p.isProvidingConfiguration(t)){return false}return!(t.mockData&&p.isProvidingConfiguration(t.mockData))});if(e){g.info("'mockData' configuration is missing, but the card 'previewMode' is 'MockData'. Abstract mode will be used instead.",this);this.setProperty("previewMode",J.Abstract)}};$.prototype._getActualDataMode=function(){var t=this.getDataMode();if(t===q.Auto&&this._oCardObserver.isIntersected()){return q.Active}return t};$.prototype.setDisplayVariant=function(t,e){this.setProperty("displayVariant",t,e);this._oDisplayVariants.updateSizeModel();return this};$.prototype.isInteractive=function(){const t=v.prototype.isInteractive.apply(this,arguments);return t&&this.getProperty("interactive")};$.prototype.isMouseInteractionDisabled=function(){return this._shouldMimicHeaderAction()};$.prototype._shouldMimicHeaderAction=function(){if(!this._isManifestReady){return false}const t=this.getManifestEntry("/sap.card/actions");const e=this.getManifestEntry("/sap.card/header/actions");const i=this.isRoleListItem();if(i&&!t&&e){return true}return false};$.prototype._mimicHeaderAction=function(t){t.setProperty("focusable",false);this.invalidate();t.addEventDelegate({onAfterRendering:()=>{this.setProperty("interactive",t.getInteractive());if(!t.getInteractive()){return}if(!this._bMimicPressAttached){this.attachPress(e=>{t.firePress({originalEvent:e.getParameter("originalEvent")})});this._bMimicPressAttached=true}}})};$.prototype.isDataReady=function(){return!!this._bDataReady};return $});
//# sourceMappingURL=Card.js.map