/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/RenderManager","sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/library","./DynamicSideContentRenderer"],function(t,jQuery,e,i,n,s,r){"use strict";var o=s.SideContentPosition;var a=s.SideContentFallDown;var h=s.SideContentVisibility;var l=e.extend("sap.ui.layout.DynamicSideContent",{metadata:{library:"sap.ui.layout",properties:{showSideContent:{type:"boolean",group:"Appearance",defaultValue:true},showMainContent:{type:"boolean",group:"Appearance",defaultValue:true},sideContentVisibility:{type:"sap.ui.layout.SideContentVisibility",group:"Appearance",defaultValue:h.ShowAboveS},sideContentFallDown:{type:"sap.ui.layout.SideContentFallDown",group:"Appearance",defaultValue:a.OnMinimumWidth},sideContentWidthM:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},sideContentWidthL:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},sideContentWidthXL:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},equalSplit:{type:"boolean",group:"Appearance",defaultValue:false},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},sideContentPosition:{type:"sap.ui.layout.SideContentPosition",group:"Appearance",defaultValue:o.End},mcSpan:{type:"int",defaultValue:0,visibility:"hidden"},scSpan:{type:"int",defaultValue:0,visibility:"hidden"}},defaultAggregation:"mainContent",events:{breakpointChanged:{parameters:{currentBreakpoint:{type:"string"}}}},aggregations:{mainContent:{type:"sap.ui.core.Control",multiple:true},sideContent:{type:"sap.ui.core.Control",multiple:true}},designTime:"sap/ui/layout/designtime/DynamicSideContent.designtime",dnd:{draggable:false,droppable:true}},renderer:r});var d="S",u="M",p="L",C="XL",S="sapUiHidden",_="sapUiDSCSpan12",g="sapUiDSCMCFixed",c="sapUiDSCSCFixed",f=3,y=4,b=6,w=8,V=9,M=12,m="Invalid Breakpoint. Expected: S, M, L or XL",k="SCGridCell",v="MCGridCell",P=720,z=1024,B=1440;l.prototype.setSideContentVisibility=function(t,e){this.setProperty("sideContentVisibility",t,true);if(!e&&this.$().length){this._setResizeData(this.getCurrentBreakpoint());this._changeGridState()}return this};l.prototype.setShowSideContent=function(t,e){if(t===this.getShowSideContent()){return this}this.setProperty("showSideContent",t,true);this._SCVisible=t;if(!e&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===d){this._MCVisible=true}this._changeGridState()}return this};l.prototype.setShowMainContent=function(t,e){if(t===this.getShowMainContent()){return this}this.setProperty("showMainContent",t,true);this._MCVisible=t;if(!e&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===d){this._SCVisible=true}this._changeGridState()}return this};l.prototype.isSideContentVisible=function(){if(this._currentBreakpoint===d){return this._SCVisible&&this.getProperty("showSideContent")}else{return this.getProperty("showSideContent")}};l.prototype.isMainContentVisible=function(){if(this._currentBreakpoint===d){return this._MCVisible&&this.getProperty("showMainContent")}else{return this.getProperty("showMainContent")}};l.prototype.setEqualSplit=function(t){this._MCVisible=true;this._SCVisible=true;this.setProperty("equalSplit",t,true);if(this._currentBreakpoint){this._setResizeData(this._currentBreakpoint,t);this._changeGridState()}return this};l.prototype.addSideContent=function(t){this.addAggregation("sideContent",t,true);this._rerenderControl(this.getAggregation("sideContent"),this.$(k));return this};l.prototype.addMainContent=function(t){this.addAggregation("mainContent",t,true);this._rerenderControl(this.getAggregation("mainContent"),this.$(v));return this};l.prototype.toggle=function(){if(this._currentBreakpoint===d){if(!this.getProperty("showMainContent")){this.setShowMainContent(true,true);this._MCVisible=false}if(!this.getProperty("showSideContent")){this.setShowSideContent(true,true);this._SCVisible=false}if(this._MCVisible&&!this._SCVisible){this._SCVisible=true;this._MCVisible=false}else if(!this._MCVisible&&this._SCVisible){this._MCVisible=true;this._SCVisible=false}this._changeGridState()}return this};l.prototype.getCurrentBreakpoint=function(){return this._currentBreakpoint};l.prototype.onBeforeRendering=function(){this._detachContainerResizeListener();this._SCVisible=this._SCVisible===undefined?this.getProperty("showSideContent"):this._SCVisible;this._MCVisible=this._MCVisible===undefined?this.getProperty("showMainContent"):this._MCVisible;if(!this.getContainerQuery()){this._iWindowWidth=jQuery(window).width();this._setBreakpointFromWidth(this._iWindowWidth);this._setResizeData(this._currentBreakpoint,this.getEqualSplit())}};l.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._attachContainerResizeListener();this._adjustToScreenSize()}else{var t=this;jQuery(window).on("resize",function(){t._adjustToScreenSize()})}this._changeGridState();this._initScrolling()};l.prototype.onThemeChanged=function(){if(this.getContainerQuery()){this._adjustToScreenSize()}};l.prototype.exit=function(){this._detachContainerResizeListener();if(this._oSCScroller){this._oSCScroller.destroy();this._oSCScroller=null}if(this._oMCScroller){this._oMCScroller.destroy();this._oMCScroller=null}};l.prototype.getScrollDelegate=function(t){var e=this.getParent(),i=t.getParent(),n=t.sParentAggregationName,s=this.getShowMainContent()&&this._MCVisible,r=this.getShowSideContent()&&this._SCVisible;while(i&&i.getId()!==this.getId()){n=i.sParentAggregationName;i=i.getParent()}if(!t){return}else if(n==="sideContent"&&!r||n==="mainContent"&&!s){return}else if(!this._isContentOnFullHeight(n)){while(e&&(!e.getScrollDelegate||!e.getScrollDelegate())){e=e.getParent()}if(e){return e.getScrollDelegate()}}this._initScrolling();if(this._oMCScroller&&this._oSCScroller){while(t&&t.getId()!==this.getId()){if(t.sParentAggregationName==="mainContent"&&s){return this._oMCScroller}if(t.sParentAggregationName==="sideContent"&&r){return this._oSCScroller}t=t.getParent()}}return};l.prototype._isContentOnFullHeight=function(t){var e=this.getShowMainContent()&&this._MCVisible,i=this.getShowSideContent()&&this._SCVisible,n=this.getProperty("mcSpan"),s=this.getProperty("scSpan"),r=t==="mainContent"&&e&&(n===M&&!i||n!==M),o=t==="sideContent"&&i&&(s===M&&!e||s!==M);return r||o};l.prototype._rerenderControl=function(e,i){if(this.getDomRef()){var n=(new t).getInterface();this.getRenderer().renderControls(n,e);n.flush(i[0]);n.destroy()}return this};l.prototype._initScrolling=function(){var t=this.getId(),e=t+"-"+k,i=t+"-"+v;if(!this._oSCScroller&&!this._oMCScroller){this._oSCScroller=new n(this,null,{scrollContainerId:e,horizontal:false,vertical:true});this._oMCScroller=new n(this,null,{scrollContainerId:i,horizontal:false,vertical:true})}};l.prototype._attachContainerResizeListener=function(){setTimeout(function(){this._sContainerResizeListener=i.register(this,this._adjustToScreenSize.bind(this))}.bind(this),0)};l.prototype._detachContainerResizeListener=function(){if(this._sContainerResizeListener){i.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null}};l.prototype._getBreakPointFromWidth=function(t){if(t<=P&&this._currentBreakpoint!==d){return d}else if(t>P&&t<=z&&this._currentBreakpoint!==u){return u}else if(t>z&&t<=B&&this._currentBreakpoint!==p){return p}else if(t>B&&this._currentBreakpoint!==C){return C}return this._currentBreakpoint};l.prototype._setBreakpointFromWidth=function(t){var e=this._getBreakPointFromWidth(t),i=this.getCurrentBreakpoint();this._currentBreakpoint=e;if(i!==undefined){e!==i&&this.fireBreakpointChanged({currentBreakpoint:this._currentBreakpoint})}};l.prototype._adjustToScreenSize=function(){if(this.getContainerQuery()){this._iWindowWidth=this.$().parent().width()}else{this._iWindowWidth=jQuery(window).width()}this._setResizeData(this._getBreakPointFromWidth(this._iWindowWidth),this.getEqualSplit());this._changeGridState();this._setBreakpointFromWidth(this._iWindowWidth)};l.prototype._setResizeData=function(t,e){var i=this.getSideContentVisibility(),n=this.getSideContentFallDown();if(!e){switch(t){case d:this._setSpanSize(M,M);if(this.getProperty("showSideContent")&&this.getProperty("showMainContent")&&this._MCVisible){this._SCVisible=i===h.AlwaysShow}this._bFixedSideContent=false;break;case u:var s=Math.ceil(33.333/100*this._iWindowWidth);if(n===a.BelowL||n===a.BelowXL||s<=320&&n===a.OnMinimumWidth){this._setSpanSize(M,M);this._bFixedSideContent=false}else{this._setSpanSize(y,w);this._bFixedSideContent=true}this._SCVisible=i===h.ShowAboveS||i===h.AlwaysShow;this._MCVisible=true;break;case p:if(n===a.BelowXL){this._setSpanSize(M,M)}else{this._setSpanSize(y,w)}this._SCVisible=i===h.ShowAboveS||i===h.ShowAboveM||i===h.AlwaysShow;this._MCVisible=true;this._bFixedSideContent=false;break;case C:this._setSpanSize(f,V);this._SCVisible=i!==h.NeverShow;this._MCVisible=true;this._bFixedSideContent=false;break;default:throw new Error(m)}}else{switch(t){case d:this._setSpanSize(M,M);this._SCVisible=false;break;default:this._setSpanSize(b,b);this._SCVisible=true;this._MCVisible=true}this._bFixedSideContent=false}return this};l.prototype._shouldSetHeight=function(){var t,e,i,n,s,r,o;t=this.getProperty("scSpan")+this.getProperty("mcSpan")===M;e=this._MCVisible&&this._SCVisible;i=!this._MCVisible&&this._SCVisible;n=this._MCVisible&&!this._SCVisible;s=i||n;r=this._fixedSideContent;o=this.getSideContentVisibility()===h.NeverShow;return t&&e||s||r||o};l.prototype._getSideContentWidth=function(){var t,e=this.getCurrentBreakpoint();switch(e){case u:t=this.getSideContentWidthM();break;case p:t=this.getSideContentWidthL();break;case C:t=this.getSideContentWidthXL();break;default:t=""}return t};l.prototype._changeGridState=function(){var t=this.$(k),e=this.$(v),i=this.getProperty("showMainContent"),n=this.getProperty("showSideContent"),s=this._shouldSetHeight(),r=this._getSideContentWidth();if(this._bFixedSideContent&&!r){t.removeClass().addClass(c);e.removeClass().addClass(g)}else{t.removeClass(c);e.removeClass(g)}if(this._SCVisible&&this._MCVisible&&n&&i){if(!this._bFixedSideContent&&(!r||this.getEqualSplit())){e.removeClass().addClass("sapUiDSCSpan"+this.getProperty("mcSpan"));t.removeClass().addClass("sapUiDSCSpan"+this.getProperty("scSpan"))}e.removeClass(S);t.removeClass(S);t.css(this._getSideContentStyles(s));e.css(this._getMainContentStyles(s))}else if(!this._SCVisible&&!this._MCVisible){e.addClass(S);t.addClass(S)}else if(this._MCVisible&&i||!i&&!n){e.removeClass().addClass(_).css("width","");t.addClass(S)}else if(this._SCVisible&&n){t.removeClass().addClass(_).css("width","");e.addClass(S)}e.addClass("sapUiDSCM");t.addClass("sapUiDSCS")};l.prototype._getMainContentStyles=function(t){var e=this._getSideContentWidth();return{width:e&&t&&!this.getEqualSplit()?"calc(100% - "+e+")":"",float:t?"left":"none",height:t?"100%":"auto"}};l.prototype._getSideContentStyles=function(t){var e=this._getSideContentWidth();return{width:e&&t&&!this.getEqualSplit()?e:"",float:t?"left":"none",height:t?"100%":"auto"}};l.prototype._setSpanSize=function(t,e){this.setProperty("scSpan",t);this.setProperty("mcSpan",e)};return l});
//# sourceMappingURL=DynamicSideContent.js.map