/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_SplitterRegistry","./SplitterRenderer","./SplitterLayoutData","./library","sap/base/i18n/Localization","sap/ui/core/Control","sap/ui/core/Core","sap/ui/core/CustomData","sap/ui/core/library","sap/ui/core/ResizeHandler","sap/ui/core/RenderManager","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/core/Theming"],function(e,t,i,r,s,a,n,o,h,l,u,d,jQuery,c){"use strict";var p=h.Orientation;var _=16;var v=a.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:p.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}},designtime:"sap/ui/layout/designtime/Splitter.designtime"},renderer:t});v.prototype.init=function(){this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=function(e){this._delayedResize(0)}.bind(this);this._resizeHandlerId=null;this._autoResize=true;this._enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._initOrientationProperties();this._bRtl=s.getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",20),decrease:this._onKeyboardResize.bind(this,"dec",20),increaseMore:this._onKeyboardResize.bind(this,"incMore",20),decreaseMore:this._onKeyboardResize.bind(this,"decMore",20),max:this._onKeyboardResize.bind(this,"max",20),min:this._onKeyboardResize.bind(this,"min",20)};this._enableKeyboardListeners();this._handleThemeAppliedBound=this._handleThemeApplied.bind(this)};v.prototype.exit=function(){e.removeInstance(this);this._disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar};v.prototype.onBeforeRendering=function(){e.removeInstance(this);this._initOrientationProperties()};v.prototype.onAfterRendering=function(){e.addInstance(this);this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");if(!this._bThemeApplied){c.attachApplied(this._handleThemeAppliedBound)}this._resize()};v.prototype.triggerResize=function(e){if(e){this._resize()}else{this._delayedResize()}};v.prototype.resetContentAreasSizes=function(){var e=this._getContentAreas();for(var t=0;t<e.length;t++){e[t].getLayoutData().setSize("auto")}};v.prototype.getCalculatedSizes=function(){return this._calculatedSizes};v.prototype.enableAutoResize=function(e){this._enableAutoResize(e)};v.prototype._enableAutoResize=function(e){if(e&&!this._autoResize){return}this._autoResize=true;var t=this;n.ready(function(){t._resizeHandlerId=l.register(t,t._resizeCallback)});this._delayedResize()};v.prototype.disableAutoResize=function(e){this._disableAutoResize(e)};v.prototype._disableAutoResize=function(e){l.deregister(this._resizeHandlerId);if(!e){this._autoResize=false}};v.prototype.enableLiveResize=function(){this._liveResize=true;this.removeStyleClass("sapUiLoSplitterAnimated")};v.prototype.disableLiveResize=function(){this._liveResize=false;this.addStyleClass("sapUiLoSplitterAnimated")};v.prototype.enableKeyboardSupport=function(){var e=this.$().find(".sapUiLoSplitterBar");e.attr("tabindex","0");this._enableKeyboardListeners()};v.prototype.disableKeyboardSupport=function(){var e=this.$().find(".sapUiLoSplitterBar");e.attr("tabindex","-1");this._disableKeyboardListeners()};v.prototype.onLayoutDataChange=function(){this._delayedResize()};v.prototype.ontouchstart=function(e){if(this._ignoreTouch){return}var t=this._getBar(e.target);if(!t){return}if(!e.changedTouches||!e.changedTouches[0]){return}this._ignoreMouse=true;this._onBarMoveStart(e.changedTouches[0],t,true)};v.prototype.onmousedown=function(e){if(this._ignoreMouse){return}var t=this._getBar(e.target);if(!t){return}this._ignoreTouch=true;this._onBarMoveStart(e,t);this._oLastDOMclicked=t};v.prototype._onBarMoveStart=function(e,t,i){var r=this.getId();this._disableAutoResize(true);var s=e[this._moveCord];var a=parseInt(t.id.substr((r+"-splitbar-").length));var n=jQuery(t);var o=this._calculatedSizes;var h=this._bHorizontal?n.outerWidth():n.outerHeight();var l=this._getContentAreas();var u=l[a].getLayoutData();var d=l[a+1].getLayoutData();if(!u.getResizable()||!d.getResizable()){z(i);return}var c=0-h;for(var p=0;p<=a;++p){c+=o[p]+h}this._move={start:s,relStart:c,barNum:a,$bar:n,c1Size:o[a],c1MinSize:u.getMinSize(),c2Size:o[a+1],c2MinSize:d.getMinSize()};if(i){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove)}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove)}this._$SplitterOverlay.css("display","block");this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move.$bar.css("visibility","hidden");this._onBarMove(e)};v.prototype._onBarMove=function(e){if(e.preventDefault&&!e.changedTouches){e.preventDefault()}var t=e;if(e.changedTouches&&e.changedTouches[0]){t=t.changedTouches[0]}var i=t[this._moveCord];var r=i-this._move.start;if(this.getOrientation()==p.Horizontal&&this._bRtl){r=-r}var s=this._move.c1Size+r;var a=this._move.c2Size-r;var n=s>=0&&a>=0&&s>=this._move.c1MinSize&&a>=this._move.c2MinSize;if(n){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+r);if(!this._liveResize){return}var o=this._move["start"]-t[this._moveCord];if(this.getOrientation()==p.Horizontal&&this._bRtl){o=-o}this._resizeContents(this._move["barNum"],-o,false)}};v.prototype._onBarMoveEnd=function(e){this._ignoreMouse=false;this._ignoreTouch=false;var t=e;if(e.changedTouches&&e.changedTouches[0]){t=t.changedTouches[0]}var i=t[this._moveCord];var r=this._move["start"]-i;if(this.getOrientation()==p.Horizontal&&this._bRtl){r=-r}this._resizeContents(this._move["barNum"],-r,true);this._move.$bar.css("visibility","");this._$SplitterOverlay.css("display","");document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this._enableAutoResize(true);if(this._move.$bar){this._move.$bar.trigger("focus")}};v.prototype._resizeContents=function(e,t,i){if(isNaN(t)){d.warning("Splitter: Received invalid resizing values - resize aborted.");return}var r=this._getContentAreas();var s=r[e].getLayoutData();var a=r[e+1].getLayoutData();var n=s.getSize();var o=a.getSize();var h=this.$("content-"+e);var l=this.$("content-"+(e+1));var u=parseFloat(this._move.c1Size).toFixed(5);var c=parseFloat(this._move.c2Size).toFixed(5);var p=parseFloat(u)+t;var _=parseFloat(c)-t;var v=parseInt(s.getMinSize());var f=parseInt(a.getMinSize());var z,g;var y;if(p<v){y=v-p;t+=y;p=v;_-=y}else if(_<f){y=f-_;t-=y;_=f;p-=y}if(i){var b=this._calcAvailableContentSize();if(n==="auto"&&o!=="auto"){g=this._calcAreaSizeWithUnit(_,b,a._getSizeUnit());a.setSize(g);a._markModified()}else if(n!=="auto"&&o==="auto"){z=this._calcAreaSizeWithUnit(p,b,s._getSizeUnit());s.setSize(z);s._markModified()}else{z=this._calcAreaSizeWithUnit(p,b,s._getSizeUnit());g=this._calcAreaSizeWithUnit(_,b,a._getSizeUnit());s.setSize(z);a.setSize(g);s._markModified();a._markModified()}this._delayedResize()}else{var m=this._getTotalSize();z=this._pxToPercent(p,m);g=this._pxToPercent(_,m);h.css(this._sizeType,z);l.css(this._sizeType,g)}};v.prototype._calcAreaSizeWithUnit=function(e,t,i){if(i==="px"){return e+"px"}if(i==="rem"){return e/_+"rem"}return this._pxToPercent(e,t)};v.prototype._pxToPercent=function(e,t){return e*100/t+"%"};v.prototype._handleThemeApplied=function(){c.detachApplied(this._handleThemeAppliedBound);this._bThemeApplied=true;this._resize()};v.prototype._delayedResize=function(e){if(e===undefined){e=0}if(this.getDomRef()){clearTimeout(this._resizeTimeout);this._resizeTimeout=setTimeout(this._resize.bind(this),e)}};v.prototype._resizeBars=function(e){var t,i,r=this._bHorizontal?this.$().innerHeight():this.$().innerWidth();for(t=0;t<e.length-1;++t){i=this.$("splitbar-"+t);i.css(this._sizeTypeNot,"")}for(t=0;t<e.length-1;++t){i=this.$("splitbar-"+t);i.css(this._sizeType,"");i.css(this._sizeTypeNot,r+"px")}};v.prototype._resize=function(){if(!this._bThemeApplied){return}var e=this.getDomRef();if(!e||u.getPreserveAreaRef().contains(e)||e.scrollHeight===0||e.scrollWidth===0){return}var t=0,i;var r=this._getContentAreas();this._resizeBars(r);var s=this._calculatedSizes;this._recalculateSizes();var a=this._calculatedSizes;var n=false;for(t=0;t<a.length;++t){if(a[t]!==0){n=true;break}}if(!n){this._delayedResize(100);return}var o=true;for(t=0;t<r.length;++t){var h=this.$("content-"+t);var l=r[t];h.css(this._sizeType,a[t]+"px");h.css(this._sizeTypeNot,"");var d=l.getLayoutData();var c=d&&d.getResizable();if(t>0){var p=c&&o;i=this.$("splitbar-"+(t-1));i.toggleClass("sapUiLoSplitterNoResize",!p);i.attr("tabindex",p&&this._keyboardEnabled?"0":"-1")}o=c}this._resizeBars(r);if(f(s,a)){this.fireResize({oldSizes:s,newSizes:a})}};v.prototype._getTotalSize=function(){return this._bHorizontal?this.$().innerWidth():this.$().innerHeight()};v.prototype._calcAvailableContentSize=function(){return this._getTotalSize()-this._calcBarsSize()};v.prototype._calcBarsSize=function(){var e=0,t=this._getContentAreas().length-1;for(var i=0;i<t;i++){e+=this._bHorizontal?this.$("splitbar-"+i).outerWidth():this.$("splitbar-"+i).outerHeight()}return e};v.prototype._recalculateSizes=function(){var e,t,i,r;var s=[];var a=this._getContentAreas();var n=this._calcAvailableContentSize();var o=[];var h=[];var l=[];this._calculatedSizes=[];for(e=0;e<a.length;++e){s.push(a[e].getLayoutData().getSize())}for(e=0;e<s.length;++e){var u=s[e];var c;if(u.indexOf("rem")>-1){c=parseFloat(u)*_;n-=c;this._calculatedSizes[e]=c}else if(u.indexOf("px")>-1){c=parseInt(u);n-=c;this._calculatedSizes[e]=c}else if(u.indexOf("%")>-1){l.push(e)}else if(u==="auto"){if(a[e].getLayoutData().getMinSize()!==0){h.push(e)}else{o.push(e)}}else{d.error("Illegal size value: "+s[e])}}var p=false;if(n<0){p=true;n=0}n=this._calcPercentBasedSizes(l,n);if(n<0){p=true;n=0}var v=Math.floor(n/(h.length+o.length),0);for(e=0;e<h.length;++e){t=v;i=h[e];r=a[i].getLayoutData().getMinSize();if(t>n){t=n}if(t<r){t=r}this._calculatedSizes[i]=t;n-=t}if(n<0){p=true;n=0}var f=o.length;v=Math.floor(n/f,0);for(e=0;e<f;++e){i=o[e];this._calculatedSizes[i]=v;n-=v}if(p){this._logConstraintsViolated()}};v.prototype._calcPercentBasedSizes=function(e,t){var i=this._getContentAreas(),r=this._calcAvailableContentSize();for(let o=0;o<e.length;++o){var s=e[o];var a=parseFloat(i[s].getLayoutData().getSize())/100*r;var n=i[s].getLayoutData().getMinSize();if(a<n){a=n}this._calculatedSizes[s]=a;t-=a}var o=i.filter(function(e){return e.getLayoutData().getSize()==="auto"}).reduce(function(e,t){return e+t.getLayoutData().getMinSize()},0);if(t<o){var h=Math.abs(t-o);for(var l=e.length-1;l>=0;l--){var u=e[l],d=i[u],c=this._calculatedSizes[u],p=d.getLayoutData();if(p._isMarked()){var _=c-h;if(_<p.getMinSize()){_=p.getMinSize()}this._calculatedSizes[u]=_;var v=c-_;h-=v;t+=v}if(h<=0){break}}}return t};v.prototype._logConstraintsViolated=function(){d.warning("The set sizes and minimal sizes of the splitter contents are bigger than the available space in the UI.",null,"sap.ui.layout.Splitter")};v.prototype._initOrientationProperties=function(){this._bHorizontal=this.getOrientation()===p.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right"}else{this._sizeDir="left"}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left"}};v.prototype._onKeyboardResize=function(e,t,i){var r=this.getId()+"-splitbar-";if(!i||!i.target||!i.target.id||i.target.id.indexOf(r)!==0){return}var s=999999;var a=parseInt(i.target.id.substr(r.length));var n=this._calculatedSizes;this._move.c1Size=n[a];this._move.c2Size=n[a+1];var o=0;switch(e){case"inc":o=t;break;case"incMore":o=t*10;break;case"dec":o=0-t;break;case"decMore":o=0-t*10;break;case"max":o=s;break;case"min":o=0-s;break;default:d.warn("[Splitter] Invalid keyboard resize type");break}this._resizeContents(a,o,true)};v.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true};v.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false};v.prototype._getBar=function(e){var t=e,i=this.getId();if(t.classList.contains("sapUiLoSplitterBarGripIcon")){t=e.parentElement}if(t.classList.contains("sapUiLoSplitterBarDecorationBefore")||t.classList.contains("sapUiLoSplitterBarDecorationAfter")||t.classList.contains("sapUiLoSplitterBarGrip")){t=t.parentElement}if(!t.id||t.id.indexOf(i+"-splitbar")!==0){return null}return t};function f(e,t){if(e===t){return false}if(!e||!t||e.length===undefined||t.length===undefined){return true}if(e.length!=t.length){return true}for(var i=0;i<e.length;++i){if(e[i]!==t[i]){return true}}return false}function z(e){var t=function(t){if(!e){t.preventDefault()}};var i=null;i=function(){document.removeEventListener("touchend",i);document.removeEventListener("touchmove",t);document.removeEventListener("mouseup",i);document.removeEventListener("mousemove",t)};if(e){this._ignoreMouse=true;document.addEventListener("touchend",i);document.addEventListener("touchmove",t)}else{document.addEventListener("mouseup",i);document.addEventListener("mousemove",t)}}v.prototype._ensureLayoutData=function(e){var t=e.getLayoutData();if(t&&(!t.getResizable||!t.getSize||!t.getMinSize)){d.warning('Content "'+e.getId()+'" for the Splitter contained wrong LayoutData. '+"The LayoutData has been replaced with default values.");t=null}if(!t){e.setLayoutData(new i)}};v.prototype.getFocusDomRef=function(){return this.getDomRef("splitbar-0")||this.getDomRef()};v.prototype.invalidate=function(e){var t=e&&this.indexOfContentArea(e)!=-1||e&&e instanceof o&&e.getWriteToDom()||e===undefined;if(t){a.prototype.invalidate.apply(this,arguments)}};v.prototype.addContentArea=function(e){this._ensureLayoutData(e);return this.addAggregation("contentAreas",e)};v.prototype.insertContentArea=function(e,t){this._ensureLayoutData(e);return this.insertAggregation("contentAreas",e,t)};v.prototype._getContentAreas=function(){return this.getContentAreas()};return v});
//# sourceMappingURL=Splitter.js.map