/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","./FormHelper","sap/base/Log"],function(e,t,i,s,a){"use strict";var r=e.extend("sap.ui.layout.form.FormElement",{metadata:{library:"sap.ui.layout",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true},_editable:{type:"boolean",group:"Misc",defaultValue:false,visibility:"hidden"}},defaultAggregation:"fields",aggregations:{label:{type:"sap.ui.core.Label",altTypes:["string"],multiple:false},_label:{type:"sap.ui.core.Label",multiple:false,visibility:"hidden"},fields:{type:"sap.ui.core.Control",multiple:true,singularName:"field"}},designtime:"sap/ui/layout/designtime/form/FormElement.designtime"}});r.prototype.init=function(){this._oInitPromise=s.init();this._oFieldDelegate={oElement:this,onAfterRendering:f};this._oObserver=new i(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["fields"]})};r.prototype.exit=function(){if(this._oLabel){delete this._oLabel}this._oFieldDelegate=undefined;this._oObserver.disconnect();this._oObserver=undefined};r.prototype.setLabel=function(e){if(!this._oLabel){var t=this.getLabel();if(t){if(t.setAlternativeLabelFor){t.setAlternativeLabelFor(null)}if(t.isRequired){t.isRequired=t._sapuiIsRequired;t._sapuiIsRequired=undefined;t.disableRequiredChangeCheck(false)}if(t.isDisplayOnly){t.isDisplayOnly=t._sapuiIsDisplayOnly;t._sapuiIsDisplayOnly=undefined}if(t.isWrapping){t.isWrapping=t._sapuiIsWrapping;t._sapuiIsWrapping=undefined}}}this.setAggregation("label",e);var i=e;if(typeof i==="string"){if(this._oInitPromise){this._oInitPromise.then(function(){delete this._oInitPromise;var e=this.getLabel();if(typeof e==="string"){this._setInternalLabel(e)}}.bind(this))}else{this._setInternalLabel(i)}}else{if(this._oLabel){this._oLabel.destroy();delete this._oLabel}if(i&&i.isRequired){i._sapuiIsRequired=i.isRequired;i.isRequired=o;i.disableRequiredChangeCheck(true)}if(i&&i.isDisplayOnly){i._sapuiIsDisplayOnly=i.isDisplayOnly;i.isDisplayOnly=u}if(i&&i.isWrapping){i._sapuiIsWrapping=i.isWrapping;i.isWrapping=p}h.call(this)}return this};r.prototype._setInternalLabel=function(e){if(!this._oLabel){this._oLabel=s.createLabel(e,this.getId()+"-label");this.setAggregation("_label",this._oLabel);this._oLabel.disableRequiredChangeCheck(true);if(this._oLabel.isRequired){this._oLabel.isRequired=o}if(this._oLabel.isDisplayOnly){this._oLabel.isDisplayOnly=u}if(this._oLabel.setWrapping){this._oLabel.setWrapping(true)}}else{this._oLabel.setText(e)}h.call(this)};r.prototype.destroyLabel=function(){this.destroyAggregation("label");if(this._oLabel){this._oLabel.destroy();delete this._oLabel}return this};r.prototype.getLabelControl=function(){if(this._oLabel){return this._oLabel}else{var e=this.getLabel();if(typeof e==="string"){e=null}return e}};r.prototype.updateFields=function(){var e=this.getFields();var t;var i=0;for(i=0;i<e.length;i++){t=e[i];g.call(this,t)}this.updateAggregation("fields");e=this.getFields();for(i=0;i<e.length;i++){t=e[i];d.call(this,t)}h.call(this);return this};r.prototype.enhanceAccessibilityState=function(e,t){var i=this.getLabelControl();if(i&&i!=e&&e.getMetadata().getAllAssociations().ariaLabelledBy){var s=t["labelledby"];if(!s){s=i.getId()}else{var a=s.split(" ");if(a.indexOf(i.getId())<0){a.splice(0,0,i.getId());s=a.join(" ")}}t["labelledby"]=s}};r.prototype.onLayoutDataChange=function(e){var t=this.getParent();if(t&&t.onLayoutDataChange){t.onLayoutDataChange(e)}};r.prototype.getRenderedDomRef=function(){var e=this;var t=this.getParent();if(t&&t.getElementRenderedDomRef){return t.getElementRenderedDomRef(e)}else{return null}};r.prototype._setEditable=function(e){var t=this._getEditable();this.setProperty("_editable",e,true);if(e!==t){this.invalidateLabel()}};r.prototype._getEditable=function(){return this.getProperty("_editable")};r.prototype.invalidateLabel=function(){var e=this.getLabelControl();if(e&&e.getDomRef()){e.invalidate()}};r.prototype.isVisible=function(){return this.getVisible()};r.prototype.getFieldsForRendering=function(){return this.getFields()};r.prototype._observeChanges=function(e){if(e.object==this){if(e.name=="fields"){l.call(this,e.child,e.mutation)}}else{n.call(this,e)}};function l(e,t){if(t=="insert"){if(!e.isA("sap.ui.core.IFormContent")){a.warning(e+" is not valid Form content",this)}d.call(this,e)}else{g.call(this,e)}h.call(this)}function n(e){if(e.name=="required"||e.name=="editable"){this.invalidateLabel()}}function o(){if(this.getRequired&&this.getRequired()){return true}var e=this.getParent();var t=e.getFields();for(var i=0;i<t.length;i++){var s=t[i];if(s.getRequired&&s.getRequired()===true&&(!s.getEditable||s.getEditable())){return true}}return false}function u(){if(this.getDisplayOnly){if(!this.isPropertyInitial("displayOnly")){return this.getDisplayOnly()}var e=this.getParent();return!e._getEditable()}return false}function p(){if(this.getWrapping&&!this.isPropertyInitial("wrapping")){return this.getWrapping()}return true}function h(){var e=this.getFields();var i=e.length>0?e[0]:null;var s=this._oLabel;if(s){s.setLabelFor(i)}else{s=this.getLabel();if(s instanceof t){s.setAlternativeLabelFor(i)}}}function d(e){e.addDelegate(this._oFieldDelegate);if(!this._bNoObserverChange){if(e.getMetadata().getProperty("required")){this._oObserver.observe(e,{properties:["required"]})}if(e.getMetadata().getProperty("editable")){this._oObserver.observe(e,{properties:["editable"]})}}}function g(e){e.removeDelegate(this._oFieldDelegate);if(!this._bNoObserverChange){this._oObserver.unobserve(e)}}function f(e){var t=this.oElement.getParent();if(t&&t.contentOnAfterRendering){t.contentOnAfterRendering(this.oElement,e.srcControl)}}return r});
//# sourceMappingURL=FormElement.js.map