/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/Element","sap/ui/core/ResizeHandler","sap/ui/layout/library","sap/ui/layout/Grid","sap/ui/layout/GridData","./Form","./FormContainer","./FormElement","./FormLayout","./ResponsiveGridLayoutRenderer","sap/ui/thirdparty/jquery"],function(e,t,a,i,n,r,s,o,l,f,u,jQuery){"use strict";var d=f.extend("sap.ui.layout.form.ResponsiveGridLayout",{metadata:{library:"sap.ui.layout",properties:{labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600}}},renderer:u});var p=e.extend("sap.ui.layout.form.ResponsiveGridLayoutPanel",{metadata:{library:"sap.ui.layout",aggregations:{content:{type:"sap.ui.layout.Grid",multiple:false}},associations:{container:{type:"sap.ui.layout.form.FormContainer",multiple:false},layout:{type:"sap.ui.layout.form.ResponsiveGridLayout",multiple:false}}},getLayoutData:function(){var e=t.getElementById(this.getContainer());var a=t.getElementById(this.getLayout());var i;if(a&&e){i=a.getLayoutDataForElement(e,"sap.ui.layout.GridData")}if(i){return i}else{return this.getAggregation("layoutData")}},getCustomData:function(){var e=t.getElementById(this.getContainer());if(e){return e.getCustomData()}},refreshExpanded:function(){var e=t.getElementById(this.getContainer());if(e){if(e.getExpanded()){this.$().removeClass("sapUiRGLContainerColl")}else{this.$().addClass("sapUiRGLContainerColl")}}},renderer:{apiVersion:2,render:function(e,a){var i=t.getElementById(a.getContainer());var n=t.getElementById(a.getLayout());var r=a.getContent();var s=i.getExpandable();var o=i.getTooltip_AsString();var l=i.getToolbar();var f=i.getTitle();e.openStart("div",a);e.class("sapUiRGLContainer");if(s&&!i.getExpanded()){e.class("sapUiRGLContainerColl")}if(l){e.class("sapUiFormContainerToolbar")}else if(f){e.class("sapUiFormContainerTitle")}if(o){e.attr("title",o)}n.getRenderer().writeAccessibilityStateContainer(e,i,"form");e.openEnd();n.getRenderer().renderHeader(e,l,f,i._oExpandButton,s,n._sFormSubTitleSize,i.getId());if(r){e.openStart("div");e.class("sapUiRGLContainerCont");e.openEnd();e.renderControl(r);e.close("div")}e.close("div")}}});d.prototype.init=function(){f.prototype.init.apply(this,arguments);this.mContainers={};this.oDummyLayoutData=new r(this.getId()+"--Dummy")};d.prototype.exit=function(){for(var e in this.mContainers){_.call(this,e,true)}if(this._mainGrid){this._mainGrid.destroy();delete this._mainGrid}this.oDummyLayoutData.destroy();this.oDummyLayoutData=undefined};d.prototype.onBeforeRendering=function(e){f.prototype.onBeforeRendering.apply(this,arguments);var t=this.getParent();if(!t||!(t instanceof s)){return}t._bNoInvalidate=true;g.call(this,t);c.call(this,t);t._bNoInvalidate=false};d.prototype.onAfterRendering=function(e){if(this._mainGrid&&this._mainGrid.__bIsUsed){for(var t in this.mContainers){if(this.mContainers[t][1]._sContainerResizeListener){a.deregister(this.mContainers[t][1]._sContainerResizeListener);this.mContainers[t][1]._sContainerResizeListener=null}}}};d.prototype.toggleContainerExpanded=function(e){var t=e.getId();if(this.mContainers[t]&&this.mContainers[t][0]){var a=this.mContainers[t][0];a.refreshExpanded()}};d.prototype.onLayoutDataChange=function(e){var t=e.srcControl;if(t instanceof o){if(this._mainGrid){this._mainGrid.onLayoutDataChange(e);this.invalidate()}}else if(!(t instanceof l)){var a=t.getParent();if(a instanceof l){var i=a.getParent();var n=i.getId();if(this.mContainers[n]&&this.mContainers[n][1]){this.mContainers[n][1].onLayoutDataChange(e)}}}};d.prototype.onsapup=function(e){this.onsapleft(e)};d.prototype.onsapdown=function(e){this.onsapright(e)};d.prototype.getContainerRenderedDomRef=function(e){if(this.getDomRef()){var t=e.getId();if(this.mContainers[t]){if(this.mContainers[t][0]){var a=this.mContainers[t][0];return a.getDomRef()}else if(this.mContainers[t][1]){var i=this.mContainers[t][1];return i.getDomRef()}}}return null};d.prototype.getElementRenderedDomRef=function(e){return null};function g(e){var t=e.getVisibleFormContainers();var a=t.length;var i=0;var n;var r;var s;var o;var l=0;for(l=0;l<a;l++){s=t[l];s._checkProperties();if(s.isVisible()){i++;o=s.getId();n=undefined;r=undefined;var f=t[l+1];if(this.mContainers[o]&&this.mContainers[o][1]){r=this.mContainers[o][1]}else{r=h.call(this,s)}var u=s.getTitle();var d=s.getToolbar();if(d||u||s.getExpandable()){if(this.mContainers[o]&&this.mContainers[o][0]){n=this.mContainers[o][0]}else{n=m.call(this,s,r);v(r,true)}C(n,s,i,f,a)}else{if(this.mContainers[o]&&this.mContainers[o][0]){y(this.mContainers[o][0])}v(r,false);C(r,s,i,f,a)}this.mContainers[o]=[n,r]}}var p=Object.keys(this.mContainers).length;if(a<p){for(o in this.mContainers){var g=false;for(l=0;l<a;l++){s=t[l];if(o==s.getId()){g=true;break}}if(!g){_.call(this,o)}}}}function m(e,t){var a=e.getId();var i=new p(a+"---Panel",{container:e,layout:this,content:t});return i}function y(e,t){e.setLayout(null);e.setContainer(null);if(!t||!e.getParent()){e.setContent(null);e.destroy()}}function h(e){var a=e.getId()+"--Grid";var i=new n(a,{vSpacing:0,hSpacing:0,containerQuery:true});i.__myParentLayout=this;i.__myParentContainerId=e.getId();i.addStyleClass("sapUiFormResGridCont").addStyleClass("sapUiRespGridOverflowHidden");i.getContent=function(){var e=t.getElementById(this.__myParentContainerId);if(e){var a=[];var i=e.getVisibleFormElements();var n;var r;for(var s=0;s<i.length;s++){var o=i[s];r=o.getLabelControl();if(r){a.push(r)}n=o.getFieldsForRendering();for(var l=0;l<n.length;l++){a.push(n[l])}}return a}else{return false}};i.getAriaLabelledBy=function(){var e=t.getElementById(this.__myParentContainerId);if(e&&!e.getToolbar()&&!e.getTitle()&&!e.getExpandable()){return e.getAriaLabelledBy()}return[]};var r={labelSpan:0,span:0,firstField:false,defaultFields:0,row:0,myRow:false,freeFields:0,finished:false};var s={id:"XL",getEffectiveSpan:function(e){var t=e._getEffectiveSpanXLarge();if(!t){t=e._getEffectiveSpanLarge()}return t},getEmptySpan:function(e){var t=e.getEmptySpanXL();if(t<0){t=e.getEmptySpanL()}return t},getLabelSpan:function(e){return e.getLabelSpanXL()},setIndent:function(e,t){e.setIndentXL(t)},setLinebreak:function(e,t){e.setLinebreakXL(t)}};jQuery.extend(s,r);var o={id:"L",getEffectiveSpan:function(e){return e._getEffectiveSpanLarge()},getEmptySpan:function(e){return e.getEmptySpanL()},getLabelSpan:function(e){return e.getLabelSpanL()},setIndent:function(e,t){e.setIndentL(t)},setLinebreak:function(e,t){e.setLinebreakL(t)}};jQuery.extend(o,r);var l={id:"M",getEffectiveSpan:function(e){return e._getEffectiveSpanMedium()},getEmptySpan:function(e){return e.getEmptySpanM()},getLabelSpan:function(e){return e.getLabelSpanM()},setIndent:function(e,t){e.setIndentM(t)},setLinebreak:function(e,t){e.setLinebreakM(t)}};jQuery.extend(l,r);var f={id:"S",getEffectiveSpan:function(e){return e._getEffectiveSpanSmall()},getEmptySpan:function(e){return e.getEmptySpanS()},getLabelSpan:function(e){return e.getLabelSpanS()},setIndent:function(e,t){e.setIndentS(t)},setLinebreak:function(e,t){e.setLinebreakS(t)}};jQuery.extend(f,r);var u=[s,o,l,f];i._getLayoutDataForControl=function(e){var a=this.__myParentLayout;var i=a.getLayoutDataForElement(e,"sap.ui.layout.GridData");var n=e.getParent();var d=n.getLabelControl();if(i){if(d==e){i._setStylesInternal("sapUiFormElementLbl")}return i}else{var p=t.getElementById(this.__myParentContainerId);var g=a.getLayoutDataForElement(p,"sap.ui.layout.GridData");var m=p.getParent();var y;var h=0;for(h=0;h<u.length;h++){y=u[h];jQuery.extend(y,r);y.labelSpan=y.getLabelSpan(a)}if(a.getAdjustLabelSpan()){if(m.getVisibleFormContainers().length>=1&&a.getColumnsM()>1){l.labelSpan=a.getLabelSpanL()}if(g){if(g._getEffectiveSpanLarge()==12){o.labelSpan=a.getLabelSpanM();l.labelSpan=a.getLabelSpanM()}}if(m.getVisibleFormContainers().length==1||a.getColumnsL()==1){o.labelSpan=a.getLabelSpanM();l.labelSpan=a.getLabelSpanM()}}if(s.labelSpan<0){s.labelSpan=o.labelSpan}if(d==e){a.oDummyLayoutData.setSpan("XL"+s.labelSpan+" L"+o.labelSpan+" M"+l.labelSpan+" S"+f.labelSpan);a.oDummyLayoutData.setLinebreak(true);a.oDummyLayoutData.setIndentXL(0).setIndentL(0).setIndentM(0).setIndentS(0);a.oDummyLayoutData._setStylesInternal("sapUiFormElementLbl");return a.oDummyLayoutData}else{var L;if(d){L=a.getLayoutDataForElement(d,"sap.ui.layout.GridData")}var v=n.getFieldsForRendering();var C=v.length;var _;var c;var b=1;var S=false;var D;var F=0;for(h=0;h<u.length;h++){y=u[h];y.span=12-y.getEmptySpan(a);if(d){if(L){D=y.getEffectiveSpan(L);if(D){y.labelSpan=D}}if(y.labelSpan<12){y.span=y.span-y.labelSpan}}y.spanFields=y.span}for(F=0;F<C;F++){_=v[F];if(_!=e){c=a.getLayoutDataForElement(_,"sap.ui.layout.GridData");if(c){for(h=0;h<u.length;h++){y=u[h];D=y.getEffectiveSpan(c);if(D&&D<y.span){y.span=y.span-D}}}else{b++}}else{if(b==1){S=true}}}var G=[];for(h=0;h<u.length;h++){y=u[h];y.firstField=S;y.defaultFields=b;if(y.span<b){y.defaultFields=0;y.row=0;y.myRow=false;y.freeFields=y.spanFields;y.span=y.spanFields;y.finished=false;G.push(y)}}if(G.length>0){for(F=0;F<C;F++){_=v[F];c=undefined;if(_!=e){c=a.getLayoutDataForElement(_,"sap.ui.layout.GridData")}for(h=0;h<G.length;h++){y=G[h];if(y.finished){continue}if(c){D=y.getEffectiveSpan(c);y.span=y.span-D}else{D=1}if(y.freeFields>=D){y.freeFields=y.freeFields-D;if(!c){y.defaultFields++}}else{if(y.myRow){y.finished=true}else{y.freeFields=y.spanFields-D;y.row++;if(c){y.defaultFields=0;y.span=y.spanFields-D}else{y.defaultFields=1;y.span=y.spanFields}if(_==e){y.firstField=true}}}if(_==e){y.myRow=true}}}}var I=0;var R="";var E;for(h=0;h<u.length;h++){y=u[h];if(y.id!="S"||y.labelSpan<12){if(y.firstField){I=y.span-Math.floor(y.span/y.defaultFields)*y.defaultFields;E=Math.floor(y.span/y.defaultFields)+I}else{E=Math.floor(y.span/y.defaultFields)}}else{E=12}if(R){R=R+" "}R=R+y.id+E;y.setLinebreak(a.oDummyLayoutData,y.firstField&&y.row>0);y.setIndent(a.oDummyLayoutData,y.firstField&&y.row>0?y.labelSpan:0)}a.oDummyLayoutData.setSpan(R);a.oDummyLayoutData.setLinebreak(S&&!d);a.oDummyLayoutData._setStylesInternal(undefined);return a.oDummyLayoutData}}};i._onParentResizeOrig=i._onParentResize;i._onParentResize=function(){if(!this.getDomRef()){this._cleanup();return}if(!jQuery(this.getDomRef()).is(":visible")){return}var e=this.__myParentLayout;if(!e._mainGrid||!e._mainGrid.__bIsUsed){var t=e.getParent().getVisibleFormContainers()[0];if(!t||!e.mContainers[t.getId()]||t.getId()!=this.__myParentContainerId){return}if(e.mContainers[this.__myParentContainerId][0]){var a=e.mContainers[this.__myParentContainerId][0].getDomRef();var i=a.clientWidth;if(i<=e.getBreakpointM()){this._toggleClass("Phone")}else if(i>e.getBreakpointM()&&i<=e.getBreakpointL()){this._toggleClass("Tablet")}else if(i>e.getBreakpointL()&&i<=e.getBreakpointXL()){this._toggleClass("Desktop")}else{this._toggleClass("LargeDesktop")}}else{this._setBreakPointTablet(e.getBreakpointM());this._setBreakPointDesktop(e.getBreakpointL());this._setBreakPointLargeDesktop(e.getBreakpointXL());this._onParentResizeOrig()}}else{var n=e._mainGrid.$();if(n.hasClass("sapUiRespGridMedia-Std-Phone")){this._toggleClass("Phone")}else if(n.hasClass("sapUiRespGridMedia-Std-Tablet")){this._toggleClass("Tablet")}else if(n.hasClass("sapUiRespGridMedia-Std-Desktop")){this._toggleClass("Desktop")}else{this._toggleClass("LargeDesktop")}}};i._getAccessibleRole=function(){var e=t.getElementById(this.__myParentContainerId);var a=this.__myParentLayout;if(a._mainGrid&&a._mainGrid.__bIsUsed&&!e.getToolbar()&&!e.getTitle()&&!e.getExpandable()&&e.getAriaLabelledBy().length>0){return"form"}};i.getUIArea=function(){var e=this.__myParentLayout;if(e){return e.getUIArea()}else{return null}};return i}function L(e,t){if(e.__myParentContainerId){e.__myParentContainerId=undefined}e.__myParentLayout=undefined;if(!t||!e.getParent()){e.destroy()}}function v(e,a){if(a){if(e.__originalGetLayoutData){e.getLayoutData=e.__originalGetLayoutData;delete e.__originalGetLayoutData}}else if(!e.__originalGetLayoutData){e.__originalGetLayoutData=e.getLayoutData;e.getLayoutData=function(){var e=this.__myParentLayout;var a=t.getElementById(this.__myParentContainerId);var i;if(a){i=e.getLayoutDataForElement(a,"sap.ui.layout.GridData")}if(i){return i}else{return this.getAggregation("layoutData")}}}}function C(e,a,i,n,s){var o;if(e instanceof p){o=t.getElementById(e.getLayout())}else{o=e.__myParentLayout}var l=o.getLayoutDataForElement(a,"sap.ui.layout.GridData");if(!l){var f=o.getColumnsM();var u=o.getColumnsL();var d=o.getColumnsXL();var g=i%u==1;var m=i%u==0;var y=i>u*(Math.ceil(s/u)-1);var h=i<=u;var L=i%f==1;var v=i%f==0;var C=i>f*(Math.ceil(s/f)-1);var _=i<=f;var c=false;var b=m;var S=y;var D=h;if(d>0){c=i%d==1;b=i%d==0;S=i>d*(Math.ceil(s/d)-1);D=i<=d}if(n){var F=o.getLayoutDataForElement(n,"sap.ui.layout.GridData");if(F&&(F.getLinebreak()||F.getLinebreakXL())){b=true;S=false}if(F&&(F.getLinebreak()||F.getLinebreakL())){m=true;y=false}if(F&&(F.getLinebreak()||F.getLinebreakM())){v=true;C=false}}var G="";if(b){G="sapUiFormResGridLastContXL"}if(m){if(G){G=G+" "}G=G+"sapUiFormResGridLastContL"}if(v){if(G){G=G+" "}G=G+"sapUiFormResGridLastContM"}if(S){if(G){G=G+" "}G=G+"sapUiFormResGridLastRowXL"}if(y){if(G){G=G+" "}G=G+"sapUiFormResGridLastRowL"}if(C){if(G){G=G+" "}G=G+"sapUiFormResGridLastRowM"}if(D){if(G){G=G+" "}G=G+"sapUiFormResGridFirstRowXL"}if(h){if(G){G=G+" "}G=G+"sapUiFormResGridFirstRowL"}if(_){if(G){G=G+" "}G=G+"sapUiFormResGridFirstRowM"}l=e.getLayoutData();if(!l){l=new r(e.getId()+"--LD",{linebreakL:g,linebreakM:L});e.setLayoutData(l)}else{l.setLinebreakL(g);l.setLinebreakM(L)}if(d>0){l.setLinebreakXL(c)}l._setStylesInternal(G)}}function _(e,t){var a=this.mContainers[e];var i=a[1];if(i){L(i,t)}var n=a[0];if(n){y(n,t)}delete this.mContainers[e]}function c(e){var a=e.getVisibleFormContainers();var i;var r;var s=a.length;var o=0;var l=0;var f=0;if(s>1||!this.getSingleContainerFullSize()){var u=Math.floor(12/this.getColumnsM());var d=Math.floor(12/this.getColumnsL());var p;var g="";var m=this.getColumnsXL();if(m>=0){p=Math.floor(12/m);g=g+"XL"+p+" "}g=g+"L"+d+" M"+u+" S12";if(!this._mainGrid){this._mainGrid=new n(e.getId()+"--Grid",{defaultSpan:g,hSpacing:0,vSpacing:0,containerQuery:true}).setParent(this);this._mainGrid.addStyleClass("sapUiFormResGridMain").addStyleClass("sapUiRespGridOverflowHidden");this._mainGrid._onParentResizeOrig=this._mainGrid._onParentResize;this._mainGrid._onParentResize=function(){this._onParentResizeOrig();var e=this.getParent();for(var t in e.mContainers){e.mContainers[t][1]._onParentResize()}}}else{this._mainGrid.setDefaultSpan(g);var y=this._mainGrid.getContent();o=y.length;var h=false;for(l=0;l<o;l++){var L=y[l];i=undefined;if(L.getContainer){i=t.getElementById(L.getContainer())}else{i=t.getElementById(L.__myParentContainerId)}if(i&&i.isVisible()){var v=a[f];if(i!=v){h=true;break}var C=this.mContainers[i.getId()];if(C[0]&&C[0]!=L){h=true;break}if(!C[0]&&C[1]&&C[1]!=L){h=true;break}f++}else{this._mainGrid.removeContent(L)}}if(h){this._mainGrid.removeAllContent();o=0}}this._mainGrid._setBreakPointTablet(this.getBreakpointM());this._mainGrid._setBreakPointDesktop(this.getBreakpointL());this._mainGrid._setBreakPointLargeDesktop(this.getBreakpointXL());this._mainGrid.__bIsUsed=true;if(o<s){var _=0;if(o>0){_=o--}for(l=_;l<s;l++){i=a[l];r=i.getId();if(this.mContainers[r]){if(this.mContainers[r][0]){this._mainGrid.addContent(this.mContainers[r][0])}else if(this.mContainers[r][1]){this._mainGrid.addContent(this.mContainers[r][1])}}}}}else{if(this._mainGrid){this._mainGrid.__bIsUsed=false}for(l=0;l<s;l++){i=a[l];r=i.getId();if(this.mContainers[r]){if(this.mContainers[r][0]){if(this.mContainers[r][0].getParent()!==this){this.addDependent(this.mContainers[r][0])}}else if(this.mContainers[r][1]){if(this.mContainers[r][1].getParent()!==this){this.addDependent(this.mContainers[r][1])}}}}}}d.prototype.getLayoutDataForDelimiter=function(){return new r({spanS:1,spanM:1,spanL:1,spanXL:1})};d.prototype.getLayoutDataForSemanticField=function(e,t,a){var i=8-(e-1);i=Math.floor(i/e);if(e===t){i=i+8-(e-1+e*i)}if(a){if(a.isA("sap.ui.layout.GridData")){a.setSpanS(11).setSpanM(i).setSpanL(i).setSpanXL(i);return a}else{a.destroy()}}return new r({spanS:11,spanM:i,spanL:i,spanXL:i})};return d});
//# sourceMappingURL=ResponsiveGridLayout.js.map