/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/m/OverflowToolbar","sap/m/OverflowToolbarRenderer","sap/m/ToolbarSpacer","sap/m/ToolbarSeparator","sap/m/library","sap/ui/mdc/enums/ActionToolbarActionAlignment","sap/ui/mdc/p13n/subcontroller/ActionToolbarController","sap/m/p13n/Engine","sap/ui/mdc/mixin/AdaptationMixin"],(t,e,o,n,i,r,s,a,g,p)=>{"use strict";const{OverflowToolbarPriority:l}=r;const c=e.extend("sap.ui.mdc.ActionToolbar",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/actiontoolbar/ActionToolbar.designtime",defaultAggregation:"actions",properties:{useAsHeader:{type:"boolean",group:"Behavior",defaultValue:true},_endOrder:{type:"string[]",defaultValue:[],visibility:"hidden"}},aggregations:{begin:{type:"sap.ui.core.Control",multiple:true},between:{type:"sap.ui.core.Control",multiple:true},actions:{type:"sap.ui.mdc.actiontoolbar.ActionToolbarAction",multiple:true},end:{type:"sap.ui.core.Control",multiple:true}}},renderer:o});const d=["begin","between","actions","end"];const u=function(){const t={canOverflow:true,getCustomImportance:function(){return l.NeverOverflow}};return t};c.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oBeginSeparator=new i({visible:false});this._oBeginSeparator.getOverflowToolbarConfig=u;this._oEndActionsBeginSeparator=new i({visible:false});this._oEndActionsBeginSeparator.getOverflowToolbarConfig=u;this._oEndActionsEndSeparator=new i({visible:false});this._oEndActionsEndSeparator.getOverflowToolbarConfig=u;this._oSpacer=new n;this.setUseAsHeader(true);g.getInstance().register(this,{controller:{actionsKey:new a({control:this})}})};c.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._oBeginSeparator){this._oBeginSeparator.destroy()}if(this._oEndActionsBeginSeparator){this._oEndActionsBeginSeparator.destroy()}if(this._oEndActionsEndSeparator){this._oEndActionsEndSeparator.destroy()}if(this._oSpacer){this._oSpacer.destroy()}};c.prototype.setProperty=function(t){if(t==="_endOrder"){this._bEnforceEndOrder=true}return e.prototype.setProperty.apply(this,arguments)};c.prototype.addAggregation=function(t,o){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(t==="end"){this._bEnforceEndOrder=true}const n=arguments;if(d.includes(t)){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o))}this._informNewFlexibleContentAdded(o);const t=this._callToolbarMethod("addAggregation",n);this._updateSeparators();return t}return e.prototype.addAggregation.apply(this,arguments)};c.prototype.destroyAggregation=function(t){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(d.includes(t)){const e=this.removeAllAggregation(t);for(let t=0;t<e.length;t++){e[t].destroy()}this._updateSeparators();return this}return e.prototype.destroyAggregation.apply(this,arguments)};c.prototype.insertAggregation=function(t,o,n){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(t==="end"){this._bEnforceEndOrder=true}if(d.includes(t)){this._registerControlListener(o);this._resetAndInvalidateToolbar(false);if(o){this._moveControlInSuitableCollection(o,this._getControlPriority(o))}this._informNewFlexibleContentAdded(o);const t=this._callToolbarMethod("insertAggregation",arguments);this._updateSeparators();return t}return e.prototype.insertAggregation.apply(this,arguments)};c.prototype.removeAllAggregation=function(t){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}return e.prototype.removeAllAggregation.apply(this,arguments)};c.prototype.removeAggregation=function(t,o){if(t==="content"){throw new Error("Mutator functions of the content aggregation of the ActionToolbar '"+this.getId()+"' must not be used.")}if(d.includes(t)){const t=this._callToolbarMethod("removeAggregation",arguments);if(t){this._getPopover().removeAssociatedContent(t.getId())}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(t);this._removeContentFromControlsCollections(t);this._updateSeparators();return t}return e.prototype.removeAggregation.apply(this,arguments)};c.prototype.setUseAsHeader=function(t){this.setProperty("useAsHeader",t,true);this.toggleStyleClass("sapMTBHeader-CTX",!!t);return this};c.prototype.getEndActionsBegin=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:s.Begin})};c.prototype.getEndActionsEnd=function(){return this.getActionsWithLayoutInformation({aggregationName:"end",alignment:s.End})};c.prototype.getActionsWithLayoutInformation=function(t){return this.getActions().filter(e=>{const o=e.getLayoutInformation();return o.aggregationName===t.aggregationName&&o.alignment===t.alignment})};c.prototype.onBeforeRendering=function(){e.prototype.onBeforeRendering.apply(this,arguments);if(this._bEnforceEndOrder){this.getProperty("_endOrder").reduce((e,o)=>{const n=t.getElementById(o);if(!n){return e}const i=this.indexOfEnd(n);if(i!=e){this.insertEnd(this.removeEnd(n),e)}return e+1},0);this._bEnforceEndOrder=false}};c.prototype.onAfterRendering=function(){e.prototype.onAfterRendering.apply(this,arguments);this._updateSeparators()};c.prototype._onContentPropertyChangedOverflowToolbar=function(t){if(this._bIsBeingDestroyed){return}e.prototype._onContentPropertyChangedOverflowToolbar.apply(this,arguments);if(t.getParameter("name")==="visible"||t.getParameter("name")==="width"&&t.getSource()!=this._oBeginSeparator){this._updateSeparators()}};c.prototype._hasVisible=function(t){const e=this.getAggregation("_popover")?this.getAggregation("_popover")._getAllContent():[];const o=t.filter(t=>e.indexOf(t)===-1);return o.some(t=>{const e=t.getWidth?t.getWidth()!=="0px":true;if(t.isA("sap.ui.mdc.actiontoolbar.ActionToolbarAction")){return t.getVisible()&&e&&t.getAction()?.getVisible()}return t.getVisible()&&e})};c.prototype._updateSeparators=function(){const t=this._hasVisible(this.getEnd());const e=(t,e)=>{if(t.getVisible()!==e){t.setVisible(e);t.invalidate()}};if(this._oBeginSeparator){const t=this._hasVisible(this.getBegin());const o=this._hasVisible(this.getBetween());e(this._oBeginSeparator,t&&o)}if(this._oEndActionsBeginSeparator){const o=this._hasVisible(this.getEndActionsBegin());e(this._oEndActionsBeginSeparator,t&&o)}if(this._oEndActionsEndSeparator){const o=this._hasVisible(this.getEndActionsEnd());e(this._oEndActionsEndSeparator,t&&o)}};c.prototype.indexOfContent=function(t){return this.getContent().indexOf(t)};c.prototype.getContent=function(){let t=this.getBegin();t.push(this._oBeginSeparator);t=t.concat(this.getBetween());t.push(this._oSpacer);t=t.concat(this.getEndActionsBegin());t.push(this._oEndActionsBeginSeparator);t=t.concat(this.getEnd());t.push(this._oEndActionsEndSeparator);t=t.concat(this.getEndActionsEnd());return t};c.prototype.getCurrentState=function(){const t=[];let e;this.getActions().forEach((o,n)=>{e=o&&o.getId();if(o.getVisible()){t.push({key:e,name:e,alignment:o.getLayoutInformation().alignment})}});return{items:t}};c.prototype.initPropertyHelper=async function(){const t=await Promise.all(this.getActions().map(async t=>{const e=await t.getAction().getMetadata().loadDesignTime(t);const o=this._getEnabledFromDesignTime(e);return{name:t.getId(),alignment:t.getLayoutInformation().alignment,label:t.getLabel(),visible:true,enabled:o}}));return Promise.resolve({getProperties:()=>t})};c.prototype._getEnabledFromDesignTime=function(t){if(!t||!("actions"in t)){return true}if(t.actions==="not-adaptable"){return false}if(t.actions.reveal===null){return false}if(t.actions.remove===null){return false}return true};p.call(c.prototype);return c});
//# sourceMappingURL=ActionToolbar.js.map