/*!
* OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["sap/ui/core/Lib","sap/ui/mdc/Control","./ChartRenderer","sap/base/Log","./chart/ToolbarControlFactory","sap/ui/mdc/ActionToolbar","./chart/PropertyHelper","sap/ui/mdc/mixin/FilterIntegrationMixin","sap/ui/model/base/ManagedObjectModel","sap/ui/mdc/p13n/subcontroller/ChartItemController","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/SortController","sap/ui/mdc/p13n/subcontroller/ChartTypeController","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/actiontoolbar/ActionToolbarAction","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/mdc/util/InfoBar","sap/ui/core/format/ListFormat","sap/ui/mdc/enums/ProcessingStrategy","sap/ui/mdc/enums/ChartP13nMode","sap/ui/mdc/enums/ChartToolbarActionType","sap/ui/mdc/chart/SelectionButtonItem","sap/ui/core/InvisibleMessage","sap/m/library","sap/ui/core/theming/Parameters"],(t,e,i,o,n,r,s,a,l,h,c,p,g,d,u,f,y,m,b,C,_,I,T,D,S,A)=>{"use strict";const{TitleLevel:v}=f;const B=e.extend("sap.ui.mdc.Chart",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/chart/Chart.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"items",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%",invalidate:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ChartDelegate",payload:{}}},header:{type:"string",group:"Misc",defaultValue:null},noDataText:{type:"string",defaultValue:"No data"},p13nMode:{type:"sap.ui.mdc.enums.ChartP13nMode[]",defaultValue:[]},legendVisible:{type:"boolean",group:"Misc",defaultValue:true},ignoreToolbarActions:{type:"sap.ui.mdc.enums.ChartToolbarActionType[]",defaultValue:[]},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"240px",invalidate:true},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"400px",invalidate:true},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},showChartTooltip:{type:"boolean",group:"Misc",defaultValue:true},autoBindOnInit:{type:"boolean",group:"Misc",defaultValue:true},chartType:{type:"string",group:"Misc",defaultValue:"column"},showSelectionDetails:{type:"boolean",group:"Misc",defaultValue:true},propertyInfo:{type:"object",defaultValue:[]},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:v.Auto},headerStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance"},headerVisible:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{items:{type:"sap.ui.mdc.chart.Item",multiple:true},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getToolbar",aggregation:"actions"}},selectionDetailsActions:{type:"sap.ui.mdc.chart.SelectionDetailsActions",multiple:false},_toolbar:{type:"sap.ui.mdc.ActionToolbar",multiple:false,visibility:"hidden"},_breadcrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},_innerChart:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_infoToolbar:{type:"sap.ui.mdc.util.InfoBar",multiple:false,visibility:"hidden"},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},noData:{type:"sap.ui.core.Control",multiple:false}},associations:{filter:{type:"sap.ui.mdc.IFilter",multiple:false}},events:{selectionDetailsActionPressed:{parameters:{action:{type:"sap.ui.core.Item"},itemContexts:{type:"sap.ui.model.Context"},level:{type:"sap.m.SelectionDetailsActionLevel"}}}}},renderer:i});const P=t.getResourceBundleFor("sap.ui.mdc");const{ToolbarDesign:M}=S;a.call(B.prototype);B.prototype.init=function(){this._oManagedObjectModel=new l(this);this.setModel(this._oManagedObjectModel,"$mdcChart");e.prototype.init.apply(this,arguments);this._setPropertyHelperClass(s);this._setupPropertyInfoStore("propertyInfo")};B.prototype.setP13nMode=function(t){let e=null;if(t&&t.length>=1){e=[];const i=t.reduce((t,e,i)=>{t[e]=true;return t},{});if(i.Item){e.push(_.Item)}if(i.Sort){e.push(_.Sort)}if(i.Filter){e.push(_.Filter)}if(i.Type){this._typeBtnActive=true;e.push(_.Type)}else{this._typeBtnActive=false}}else{e=t}this.setProperty("p13nMode",e,true);this._updateAdaptation(this.getP13nMode());return this};B.prototype._updateAdaptation=function(t){const e={controller:{}};const i={Item:new h({control:this}),Sort:new p({control:this}),Filter:new c({control:this}),Type:new g({control:this})};if(t&&t.length>0){t.forEach(t=>{const o=t;const n=i[t];if(n){e.controller[o]=n}});this.getEngine().register(this,e)}};B.prototype.setFilterConditions=function(t){this.setProperty("filterConditions",t,true);const e=this.getInbuiltFilter();if(e){e.setFilterConditions(t)}this._updateInfoToolbar();return this};B.prototype.getConditions=function(){return this.getInbuiltFilter()?this.getInbuiltFilter().getConditions():[]};B.prototype._registerInnerFilter=function(t){t.attachSearch(function(){this._rebind()},this)};B.prototype.applySettings=function(t,i){e.prototype.applySettings.apply(this,arguments);this.initializedPromise=new Promise((t,e)=>{this._fnResolveInitialized=t;this._fnRejectInitialized=e});this.innerChartBoundPromise=new Promise((t,e)=>{this._fnResolveInnerChartBound=t;this._fnRejectInnerChartBound=e});const o=this.initControlDelegate();const n=[o];if(this.isFilteringEnabled()){n.push(this.retrieveInbuiltFilter())}Promise.all(n).then(()=>{if(!this.isDestroyed()){this._initInnerControls()}})};B.prototype._initInnerControls=function(){this.getControlDelegate().initializeInnerChart(this).then(t=>{this.setBusyIndicatorDelay(0);this.getControlDelegate().createInitialChartContent(this);this._renderOverlay(true);if(this.getAutoBindOnInit()){this.setBusy(true);this._createContentfromPropertyInfos(t)}this.setAggregation("_innerChart",t);if(this.getP13nMode().includes("Filter")){this._initInfoToolbar()}this._bInnerChartReady=true;this._fnResolveInitialized();this.invalidate()}).catch(t=>{this._fnRejectInitialized(t)});this._createToolbarContent()};B.prototype._createToolbarContent=function(){const t=this.getP13nMode()||[];const e=this.getIgnoreToolbarActions();const i=this.getShowSelectionDetails();const o=t.includes("Item")&&!(e.length&&e.includes(I.DrillDownUp));const r=!(e.length&&e.includes(I.Legend));const s=!(e.length&&e.includes(I.ZoomInOut));const a=t.includes("Sort")||t.includes("Item")||t.includes("Filter");const l=this._getTypeBtnActive();const h=this.getHeader();const c=this.getHeaderStyle();const p=this.getHeaderLevel();const g=this.getHeaderVisible();const d=function(t){const e=t.getSource();e.removeAllItems();e.setSelectedItemKey("");const i=function(t){const e=t.getControlDelegate().getDrillStack(t);const i=[];e.forEach(t=>{t.dimension.forEach(t=>{if(t!=null&&t!=""&&i.indexOf(t)==-1){i.push(t)}})});return i};const o=this.getControlDelegate().getSortedDimensions(this);return o.then(t=>{const o=i(this);t=t.filter(t=>o.indexOf(t.key)<0);t.forEach(t=>{e.addItem(new T({key:t.key,text:t.label}))});e.setSearchEnabled(t.length>=7);e._openPopover()})}.bind(this);const u=function(t){const e=t.getParameter("item").key;this._bDrillDown=true;this.getEngine().createChanges({control:this,key:"Item",state:[{name:e,position:this.getItems().length}]})}.bind(this);const f=function(){const t=this.getP13nMode();const e=t.indexOf("Type");if(e>-1){t.splice(e,1)}if(this.isPropertyHelperFinal()){this.getEngine().show(this,t)}else{this.finalizePropertyHelper().then(()=>{this.getEngine().show(this,t)})}}.bind(this);const y=this.getChartType();const m=function(t){const e=t.getSource();const i=this.getAvailableChartTypes();e.removeAllItems();i.forEach(t=>{e.addItem(new T({key:t.key,text:t.text,icon:t.icon}))});e.setSearchEnabled(i.length>=7)}.bind(this);const b=function(t){const e=t.getSource();const i=t.getParameter("item").key;const o=this.getChartTypeInfo();const n=this.getAvailableChartTypes();const[r]=n.filter(t=>t.key===i);e.setText(r.text);e.setTooltip(o.text);e.setIcon(r.icon);sap.ui.require(["sap/ui/mdc/flexibility/Chart.flexibility"],t=>{this.getEngine().createChanges({control:this,key:"Type",state:{properties:{chartType:i}}}).then(t=>{if(this.getControlDelegate().requestToolbarUpdate){this.getControlDelegate().requestToolbarUpdate(this)}else{this._updateToolbar()}})})}.bind(this);const C=this.getId();const _=this._getToolbar();this._oTitle=n.createTitle(C,{header:h,headerStyle:c,headerLevel:p,headerVisible:g},_);_.addBegin(this._oTitle);const D=this.getAggregation("variant");if(D&&_){const t=this.getVariant();if(t){_.removeBetween(t)}_.addBetween(D);this._updateVariantManagementStyle()}if(i){this._oSelectionDetailsBtn=this._createSelectionDetails(C);_.addEnd(this._oSelectionDetailsBtn)}if(o){this._oDrillDownBtn=n.createDrillDownBtn(C,{beforeOpen:d,itemSelected:u});_.addEnd(this._oDrillDownBtn)}if(r){this._oLegendBtn=n.createLegendBtn(C,{pressed:"{$mdcChart>/legendVisible}"});_.addEnd(this._oLegendBtn)}if(s){this._oZoomInBtn=n.createZoomInBtn(C,{press:this.zoomIn.bind(this)});_.addEnd(this._oZoomInBtn);this._oZoomOutBtn=n.createZoomOutBtn(C,{press:this.zoomOut.bind(this)});_.addEnd(this._oZoomOutBtn)}if(a){this._oSettingsBtn=n.createSettingsBtn(C,{press:f});_.addEnd(this._oSettingsBtn)}if(l){this._oChartTypeBtn=n.createChartTypeBtn(C,{selectedItemKey:y,beforeOpen:m,itemSelected:b});_.addEnd(this._oChartTypeBtn)}this._updateVariantManagementStyle()};B.prototype._createSelectionDetails=function(t){const e=function(t){const e=[];t.getParameter("items").forEach(t=>{e.push(t.getBindingContext())});this.fireSelectionDetailsActionPressed({id:t.getParameter("id"),action:t.getParameter("action"),itemContexts:e,level:t.getParameter("level")})}.bind(this);const i=n.createSelectionDetailsBtn(t,{actionPress:e,getSelectionDetailsActions:this.getSelectionDetailsActions.bind(this),enableNavCallback:(t,e)=>this.getControlDelegate().determineEnableNavForDetailsItem(this,t,e),fetchFieldInfosCallback:(t,e)=>this.getControlDelegate().fetchFieldInfos(this,t,e)});return i};B.prototype._initInfoToolbar=function(){this.setAggregation("_infoToolbar",new m(this.getId()+"--infoToolbar",{infoText:this._getFilterInfoText(),press:function(){this.finalizePropertyHelper().then(()=>this.getEngine().show(this,"Filter")).then(t=>{t.attachEventOnce("close",()=>{const t=this.getFilterConditions();const e=!Object.keys(t).find(e=>t[e]&&t[e].length>0);if(e&&this.getAggregation("_toolbar")){}})})}.bind(this),removeAllFilters:function(t){this.getEngine().createChanges({control:this,key:"Filter",state:{},applyAbsolute:C.FullReplace})}.bind(this)}));if(this.getDomRef()){this.getDomRef().setAttribute("aria-labelledby",this.getAggregation("_infoToolbar").getACCTextId())}};B.prototype._updateInfoToolbar=function(){if(this.getP13nMode().includes("Filter")&&this.getAggregation("_infoToolbar")){this.getAggregation("_infoToolbar").setInfoText(this._getFilterInfoText())}};B.prototype._getFilterInfoText=function(){if(this.getInbuiltFilter()){let t;const e=this._getLabelsFromFilterConditions();const i=b.getInstance();if(e.length>0){if(e.length>1){t=P.getText("chart.MULTIPLE_FILTERS_ACTIVE",[e.length,i.format(e)])}else{t=P.getText("chart.ONE_FILTER_ACTIVE",[e[0]])}}return t}return undefined};B.prototype.checkAndUpdateItems=function(){return new Promise((t,e)=>{const i=[];const n=function(t,e,i,n){const r=t.getProperty(i);if(!r||r!==e){if(r!==e){o.error("sap.ui.mdc.Chart",`the propertyInfo.${i} for Item '${t.getId()}' has a different value! new value = ${e||n}`)}t.setProperty(i,e||n)}};this.getItems().forEach(t=>{i.push(this._getPropertyByNameAsync(t.getPropertyKey()).then(e=>{if(e){n(t,e.label,"label");n(t,e.groupable?"groupable":"aggregatable","type");n(t,e.role,"role",e.groupable?"category":"axis1")}}))});Promise.all(i).then(()=>{t()})})};B.prototype._createContentfromPropertyInfos=function(t){this.checkAndUpdateItems().then(()=>{if(!this._oInnerChartContentPromise){this._oInnerChartContentPromise=this.getControlDelegate().createInnerChartContent(this,this._innerChartDataLoadComplete.bind(this));this._oInnerChartContentPromise.then(()=>{this._createBreadcrumbs();this._oObserver?.disconnect();this._oObserver?.destroy();this._oObserver=new d(this._propagateItemChangeToInnerChart.bind(this));this._oObserver.observe(this,{aggregations:["items"]});this._propagatePropertiesToInnerChart();this._fnResolveInnerChartBound()})}})};B.prototype._createBreadcrumbs=function(){let t=this.getAggregation("_breadcrumbs");if(!t&&!this._bIsDestroyed){t=n.createDrillBreadcrumbs(this.getId(),{linkPressed:function(t){const e=t.getParameter("index")+1;const i=this.getControlDelegate().getDrillableItems(this);const o=i.slice(e);const n=o.map(t=>({name:t.getPropertyKey(),visible:false}));this._iDrillUpIndex=e;this.getEngine().createChanges({control:this,key:"Item",state:n})}.bind(this)});const e=this.getControlDelegate().getDrillableItems(this).map(t=>({key:t.getPropertyKey(),text:t.getLabel()}));t.update(e);this.setAggregation("_breadcrumbs",t)}};B.prototype._loadDelegate=function(){return new Promise(t=>{const e=[this.getDelegate().name];function i(e){t(e)}sap.ui.require(e,i)})};B.prototype.isFilteringEnabled=function(){return this.getP13nMode().indexOf("Filter")>-1};B.prototype.getAdaptationUI=function(){return this.getControlDelegate().getAdaptionUI(this)};B.prototype._propagateItemChangeToInnerChart=function(t){if(this._bIsDestroyed){return}this.setBusy(true);let e;switch(t.mutation){case"insert":if(t.child&&t.child.getType()){e=this.getItems().filter(e=>e.getType()===t.child.getType()).indexOf(t.child)}else{e=this.getItems().indexOf(t.child)}this.getControlDelegate().insertItemToInnerChart(this,t.child,e);break;case"remove":this.getControlDelegate().removeItemFromInnerChart(this,t.child);break;default:o.error("Unknown mutation on MDC Chart Item Aggregation. This will not sync to inner chart!");break}const i=this.getControlDelegate().getDrillableItems(this).map(t=>({key:t.getPropertyKey(),text:t.getLabel()}));this.getAggregation("_breadcrumbs").update(i)};B.prototype._rebind=async function(t){if(!this._bInnerChartReady){await this.initialized()}this.setBusy(true);if(!this.getControlDelegate().getInnerChartBound(this)){this._createContentfromPropertyInfos();return}const e=this.getControlDelegate();let i;if(e._getBindingInfo){i=e._getBindingInfo(this);o.warning("mdc Chart","calling the private delegate._getBindingInfo. Please make the function public!")}else{i=e.getBindingInfo(this)}e.updateBindingInfo(this,i);e.rebind(this,i)};B.prototype._onFilterSearch=function(t){this._bAnnounceUpdate=true};B.prototype._announceUpdate=function(t,e,i,o){if(!this._bAnnounceUpdate){return}this._bAnnounceUpdate=false;const n=D.getInstance();if(n){const r=P;const s=this.getAvailableChartTypes();const[a]=s.filter(e=>e.key===t);t=a?.text||t;let l=r.getText("chart.ANNOUNCEMENT_UPDATED",[e,t]);let h;if(i&&o){if(i===1&&o===1){h="chart.ANNOUNCEMENT_DIMMEA_11_UPDATED"}else if(i>1&&o===1){h="chart.ANNOUNCEMENT_DIMMEA_N1_UPDATED"}else if(i===1&&o>1){h="chart.ANNOUNCEMENT_DIMMEA_1N_UPDATED"}else{h="chart.ANNOUNCEMENT_DIMMEA_NN_UPDATED"}l+=" "+r.getText(h,[i,o])}n.announce(l)}};B.prototype._getToolbar=function(){if(this.getAggregation("_toolbar")){return this.getAggregation("_toolbar")}else if(!this._bIsDestroyed){const t=new r(this.getId()+"--toolbar",{design:M[A.get({name:"_sap_ui_mdc_Chart_ToolbarDesign"})],enabled:false});this.setAggregation("_toolbar",t);return t}};B.prototype.onThemeChanged=function(){const t=this._getToolbar();if(t){const e=M[A.get({name:"_sap_ui_mdc_Chart_ToolbarDesign"})];t.setDesign(e)}};B.prototype._updateToolbar=function(){const t=this.getAggregation("_toolbar");if(t){if(!t.getEnabled()){t.setEnabled(true)}this._updateZoomButtons();this._initSelectionDetails()}else{o.warning("Trying to update Chart Toolbar, but toolbar is not yet initialized. This will not work!")}};B.prototype._updateZoomButtons=function(){const t=this._oZoomInBtn;const e=this._oZoomOutBtn;if(!t||!e){return}const i=this.getControlDelegate().getZoomState(this);if(i?.enabled){const o=document.activeElement===t.getDomRef();const n=document.activeElement===e.getDomRef();t.setEnabled(i.enabledZoomIn);e.setEnabled(i.enabledZoomOut);if(!i.enabledZoomIn&&o){e.focus()}if(!i.enabledZoomOut&&n){t.focus()}}else{t.setEnabled(false);e.setEnabled(false)}};B.prototype._initSelectionDetails=function(){const t=this._oSelectionDetailsBtn;if(t&&!t._oChangeHandler){const e=this.getSelectionHandler();if(e){t.attachSelectionHandler(e.eventId,e.listener)}}};B.prototype._getInnerChart=function(){if(this._bInnerChartReady){return this.getControlDelegate().getInnerChart(this)}else{o.error("Trying to acces inner chart while inner chart is not yet initialized!")}};B.prototype.initialized=function(){return this.initializedPromise};B.prototype.innerChartBound=function(){return this.innerChartBoundPromise};B.prototype.zoomIn=function(){this.getControlDelegate().zoomIn(this);this._updateZoomButtons()};B.prototype.zoomOut=function(){this.getControlDelegate().zoomOut(this);this._updateZoomButtons()};B.prototype.getSelectionHandler=function(){return this.getControlDelegate().getInnerChartSelectionHandler(this)};B.prototype.getChartTypeLayoutConfig=function(){return this.getControlDelegate().getChartTypeLayoutConfig()};B.prototype.getAllowedRolesForKinds=function(){return this.getControlDelegate().getAllowedRolesForKinds()};B.prototype.setLegendVisible=function(t){this.setProperty("legendVisible",t);try{this.getControlDelegate().setLegendVisible(this,t)}catch(t){o.info("Trying to set legend visiblity for Chart before delegate was initialized")}return this};B.prototype.setShowChartTooltip=function(t){this.setProperty("showChartTooltip",t);try{this.getControlDelegate().setChartTooltipVisibility(this,t)}catch(t){o.info("Trying to set tooltip visibility before delegate was initialized")}return this};B.prototype.destroy=function(){this._bIsDestroyed=true;e.prototype.destroy.apply(this,arguments)};B.prototype._propagatePropertiesToInnerChart=function(){this.setLegendVisible(this.getLegendVisible());this.setShowChartTooltip(this.getShowChartTooltip());this.setChartType(this.getChartType())};B.prototype.getChartTypeInfo=function(){return this.getControlDelegate().getChartTypeInfo(this)};B.prototype.getAvailableChartTypes=function(){return this.getControlDelegate().getAvailableChartTypes(this)};B.prototype.setChartType=function(t){this.setProperty("chartType",t);const e=this._oChartTypeBtn;if(e){e.setSelectedItemKey(t);const i=this.getChartTypeInfo();e.setTooltip(i.text);e.setIcon(i.icon)}try{this.getControlDelegate().setChartType(this,t)}catch(t){o.info("Trying to set chart type for Chart before delegate was initialized")}return this};B.prototype.setNoData=function(t){this.setAggregation("noData",t);try{this.getControlDelegate().changedNoDataStruct(this,t)}catch(t){}return this};B.prototype.getManagedObjectModel=function(){return this._oManagedObjectModel};B.prototype._innerChartDataLoadComplete=function(){this._checkStyleClassesForDimensions();this.setBusy(false);this._renderOverlay(false);if(this.getControlDelegate().requestToolbarUpdate){this.getControlDelegate().requestToolbarUpdate(this)}else{this._updateToolbar()}};B.prototype._checkStyleClassesForDimensions=function(){const t=this.getAggregation("_breadcrumbs");const e=t?.getVisible()&&this.getItems().some(t=>t.getType()==="groupable");if(!e&&this.hasStyleClass("sapUiMDCChartGrid")){this.removeStyleClass("sapUiMDCChartGrid");this.addStyleClass("sapUiMDCChartGridNoBreadcrumbs")}else if(e&&this.hasStyleClass("sapUiMDCChartGridNoBreadcrumbs")){this.removeStyleClass("sapUiMDCChartGridNoBreadcrumbs");this.addStyleClass("sapUiMDCChartGrid")}};B.prototype.getCurrentState=function(){const t={};const e=this.getP13nMode();if(e){if(e.indexOf("Item")>-1){t.items=this._getVisibleProperties()}if(e.indexOf("Sort")>-1){t.sorters=this._getSortedProperties()}if(e.indexOf("Filter")>-1){t.filter=this.getFilterConditions()}if(e.indexOf("Type")>-1){t.chartType=this.getChartType()}}return t};B.prototype._getVisibleProperties=function(){const t=[];this.getItems().forEach(e=>{const i=e.getPropertyKey();t.push({key:i,name:i,role:e.getRole()})});return t};B.prototype._getSortedProperties=function(){const t=this.getSortConditions();return t?t.sorters:[]};B.prototype._getTypeBtnActive=function(){return!!this._typeBtnActive};B.prototype.setNoDataText=function(t){this.setProperty("noDataText",t);try{this.getControlDelegate().setNoDataText(this,t)}catch(t){}return this};B.prototype._onFiltersChanged=function(t){if(this._bInnerChartReady&&this.getControlDelegate()&&this.getControlDelegate().getInnerChartBound(this)&&t.getParameter("conditionsBased")){this._renderOverlay(true)}};const E=function(t){let e=false;if(t&&(t.indexOf("Sort")>-1||t.indexOf("Item")>-1||t.indexOf("Filter")>-1)){e=true}return e};B.prototype._onModifications=async function(t){if(E(t)){await this.rebind()}};B.prototype.setVariant=function(t){this.setAggregation("variant",t);const e=this.getAggregation("_toolbar");if(t&&e){const i=this.getVariant();if(i){e.removeBetween(i)}e.addBetween(t);this._updateVariantManagementStyle()}return this};B.prototype.getVariant=function(){let t;const e=this.getAggregation("_toolbar");if(e){[t]=e.getBetween().filter(t=>t.isA("sap.ui.fl.variants.VariantManagement"))}else{t=this.getAggregation("variant")}return t};B.prototype._renderOverlay=function(t){try{this.getControlDelegate().showOverlay(this,t)}catch(t){o.error("sap.ui.mdc.Chart: Tried to render overlay on not initiailized chart. This will not work!")}};B.prototype.addAction=function(t){if(t.getMetadata().getName()!=="sap.ui.mdc.actiontoolbar.ActionToolbarAction"){t=new u(t.getId()+"-action",{action:t})}return e.prototype.addAggregation.apply(this,["actions",t])};B.prototype.setHeader=function(t){this.setProperty("header",t);const e=this.getAggregation("_toolbar");this._oTitle?.setText(t);e?._oInvTitle?.setText(t);return this};B.prototype.setHeaderLevel=function(t){this.setProperty("headerLevel",t);this._oTitle?.setLevel(t);this._updateVariantManagementStyle();return this};B.prototype.setHeaderStyle=function(t){this.setProperty("headerStyle",t);this._oTitle?.setTitleStyle(t);this._updateVariantManagementStyle();return this};B.prototype.setHeaderVisible=function(t){this.setProperty("headerVisible",t,true);this._oTitle?.setVisible(t);this._updateVariantManagementStyle();return this};B.prototype._updateVariantManagementStyle=function(){const t=this.getVariant();if(t){t.setShowAsText(this.getHeaderVisible());t.setTitleStyle(this.getHeaderStyle());t.setHeaderLevel(this.getHeaderLevel())}};B.prototype.onkeydown=function(t){if(t.isMarked()){return}if((t.metaKey||t.ctrlKey)&&t.which===y.COMMA){const e=this._oSettingsBtn;if(e&&e.getVisible()&&e.getEnabled()){e.firePress();t.setMarked();t.preventDefault()}}};B.prototype.exit=function(){delete this._oTitle;delete this._oSelectionDetailsBtn;delete this._oDrillDownBtn;delete this._oLegendBtn;delete this._oZoomInBtn;delete this._oZoomOutBtn;delete this._oSettingsBtn;delete this._oChartTypeBtn;delete this.innerChartBoundPromise;delete this._fnResolveInnerChartBound;delete this._fnRejectInnerChartBound;delete this.initializedPromise;delete this._fnResolveInitialized;delete this._fnRejectInitialized;delete this._oInnerChartContentPromise;const t=this.getAggregation("_toolbar");t?._oInvTitle?.destroy();e.prototype.exit.apply(this,arguments);this._oObserver?.destroy();delete this._oObserver};return B});
//# sourceMappingURL=Chart.js.map