/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/AdaptFiltersController","sap/ui/mdc/filterbar/aligned/FilterContainer","sap/ui/mdc/filterbar/aligned/FilterItemLayout","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/m/library","sap/m/Button","sap/base/util/merge","sap/base/Log","sap/ui/mdc/enums/FilterBarP13nMode"],(t,e,i,r,s,o,n,l,d,a,h)=>{"use strict";const p=s.extend("sap.ui.mdc.FilterBar",{metadata:{designtime:"sap/ui/mdc/designtime/filterbar/FilterBar.designtime",properties:{showAdaptFiltersButton:{type:"boolean",defaultValue:true},showClearButton:{type:"boolean",defaultValue:false},p13nMode:{type:"sap.ui.mdc.enums.FilterBarP13nMode[]"},_p13nModeItem:{type:"boolean",visibility:"hidden",defaultValue:false}}},renderer:o});const{ButtonType:u}=n;p.prototype._createInnerLayout=function(){this._cLayoutItem=r;this._oFilterBarLayout=new i;this._oFilterBarLayout.getInner().setParent(this);this._oFilterBarLayout.getInner().addStyleClass("sapUiMdcFilterBarBaseAFLayout");this.setAggregation("layout",this._oFilterBarLayout,true);this._addButtons()};p.prototype.setP13nMode=function(i){this.setProperty("p13nMode",i||[],false);const r={helper:this.getPropertyHelper(),controller:{}};let s=false;i&&i.forEach(t=>{if(t=="Item"){s=true;r.controller["Item"]=new e({control:this})}});this._setP13nModeItem(s);r.controller["Filter"]=new t({control:this});this.getEngine().register(this,r);return this};p.prototype.setFilterConditions=function(e,i){t.checkConditionOperatorSanity(e);if(this._oP13nFB){this._oP13nFB.setFilterConditions(d({},e))}this.setProperty("filterConditions",e,i);return this};p.prototype._getP13nModeItem=function(){return this._oModel.getProperty("/_p13nModeItem")};p.prototype._setP13nModeItem=function(t){this._oModel.setProperty("/_p13nModeItem",t,true)};p.prototype._addButtons=function(){if(this._oFilterBarLayout){this.setProperty("_filterCount",this._oRb.getText("filterbar.ADAPT"),false);this._btnAdapt=new l(this.getId()+"-btnAdapt",{type:u.Transparent,text:"{"+s.INNER_MODEL_NAME+">/_filterCount}",press:this.onAdaptFilters.bind(this)});this._btnAdapt.setModel(this._oModel,s.INNER_MODEL_NAME);this._btnAdapt.bindProperty("visible",{parts:[{path:"/showAdaptFiltersButton",model:s.INNER_MODEL_NAME},{path:"/_p13nModeItem",model:s.INNER_MODEL_NAME}],formatter:function(t,e){return t&&e}});this._btnSearch=this._getSearchButton();this._btnSearch.setModel(this._oModel,s.INNER_MODEL_NAME);this._btnSearch.bindProperty("visible",{parts:[{path:"/showGoButton",model:s.INNER_MODEL_NAME},{path:"/liveMode",model:s.INNER_MODEL_NAME}],formatter:function(t,e){return t&&(this._isPhone()?true:!e)}.bind(this)});this._btnSearch.addStyleClass("sapUiMdcFilterBarBaseButtonPaddingRight");this._btnClear=new l(this.getId()+"-btnClear",{type:u.Transparent,visible:"{"+s.INNER_MODEL_NAME+">/showClearButton}",text:this._oRb.getText("filterbar.CLEAR"),press:function(t){this.onClear()}.bind(this)});this._btnClear.setModel(this._oModel,s.INNER_MODEL_NAME);this._oFilterBarLayout.addButton(this._btnSearch);this._oFilterBarLayout.addButton(this._btnClear);this._oFilterBarLayout.addButton(this._btnAdapt)}};p.prototype.onClear=function(){this._btnClear.setEnabled(false);this.awaitControlDelegate().then(t=>{t.clearFilters(this).catch(t=>{a.error(t)}).finally(()=>{this._btnClear.setEnabled(true)})})};p.prototype.retrieveInbuiltFilter=function(){const t=s.prototype.retrieveInbuiltFilter.apply(this,arguments);return t.then(t=>t)};p.prototype.onAdaptFilters=function(t){return this._retrieveMetadata().then(()=>this.getEngine().show(this,"Item",{reset:function(){this.getEngine().reset(this);this._getConditionModel().checkUpdate(true)}.bind(this)}).then(t=>{this._aAddedFilterFields=[];this._aRemovedFilterFields=[];t.attachEventOnce("close",this._determineFilterFieldOnFocus.bind(this));return t}))};p.prototype._determineFilterFieldOnFocus=function(){let t=null;const e=this.getFilterItems();if(this._aAddedFilterFields&&this._aAddedFilterFields.length>0){[t]=this._aAddedFilterFields;for(let i=1;i<this._aAddedFilterFields.length;i++){if(e.indexOf(t)>e.indexOf(this._aAddedFilterFields[i])){t=this._aAddedFilterFields[i]}}}else if(this._aRemovedFilterFields&&this._aRemovedFilterFields.length>0){[t]=e}if(t){this._setFocusOnFilterField(t)}this._aAddedFilterFields=undefined;this._aRemovedFilterFields=undefined};p.prototype._handleAddedFilterField=function(t){if(this._aAddedFilterFields&&this._aRemovedFilterFields){const e=this._aRemovedFilterFields.indexOf(t);if(e<0){this._aAddedFilterFields.push(t)}else{this._aRemovedFilterFields.splice(e,1)}}};p.prototype._handleRemovedFilterField=function(t){if(this._aRemovedFilterFields){this._aRemovedFilterFields.push(t)}};p.prototype._setFocusOnFilterField=function(t){if(t){t.focus()}};p.prototype.getCurrentState=function(){const t=s.prototype.getCurrentState.apply(this,arguments);if(!this.getProperty("_p13nModeItem")){delete t.items}return t};p.prototype.exit=function(){s.prototype.exit.apply(this,arguments);this._btnClear=undefined};return p});
//# sourceMappingURL=FilterBar.js.map