/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/enums/FieldDisplay","sap/base/util/merge","sap/base/util/deepEqual"],(t,e,i,r,o,s)=>{"use strict";const n=e.extend("sap.ui.mdc.FilterField",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/FilterField.designtime",properties:{operators:{type:"string[]",group:"Data",defaultValue:[]},defaultOperator:{type:"string",group:"Data",defaultValue:null},propertyKey:{type:"string",group:"Data",defaultValue:""},additionalDataType:{type:"object",group:"Data",defaultValue:null}},events:{change:{parameters:{value:{type:"string"},valid:{type:"boolean"},conditions:{type:"object[]"},promise:{type:"boolean"}}}}},renderer:i});n.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver.observe(this,{properties:["operators","propertyKey","additionalDataType"]});this._mDescriptionPromises=new Map;this._mDescriptions=new Map};n.prototype.exit=function(){this._mDescriptionPromises=null;this._mDescriptions=null;e.prototype.exit.apply(this,arguments)};(()=>{n.prototype.getPropertyKey=function(){let t=this.getProperty("propertyKey");if(!t){t=this.getFieldPath()}return t}})();n.prototype.setProperty=function(t,i,r){if(t==="conditions"&&this.isInvalidInput()&&s(this.getConditions(),this.validateProperty(t,i))){if(this._oManagedObjectModel){this._oManagedObjectModel.checkUpdate(true,true)}this.resetInvalidInput()}return e.prototype.setProperty.apply(this,arguments)};n.prototype.observeChanges=function(t){e.prototype.observeChanges.apply(this,arguments);if(t.name==="operators"){if(t.current.length===0){e.prototype.getSupportedOperators.apply(this,[])}else{this.setProperty("_operators",t.current,true)}this.updateInternalContent()}else if(t.name==="propertyKey"){this.updateInternalContent()}else if(t.name==="additionalDataType"){p.call(this,t.current)}};n.prototype.fireChangeEvent=function(t,e,i,r){let s;if(t){if(e){if(t.length==1){s=t[0].values[0]}}else{s=i}}this.fireChange({value:s,valid:e,conditions:o([],t),promise:r})};n.prototype.getSupportedOperators=function(){let t=this.getOperators();if(t.length===0){t=e.prototype.getSupportedOperators.apply(this,arguments)}else{this.setProperty("_operators",t,true)}return t};n.prototype.setOperators=function(t){const e=[];if(!Array.isArray(t)){t=t.split(",")}t.forEach(t=>{if(typeof t==="string"){e.push(t)}else{e.push(t.name)}});this.setProperty("operators",e);return this};n.prototype.addOperator=function(t){const e=this.getSupportedOperators();let i=t;if(typeof t!=="string"){i=t.name}if(e.indexOf(i)<0){e.push(i);this.setOperators(e)}return this};n.prototype.addOperators=function(t){if(!Array.isArray(t)){t=[t]}t.forEach(t=>{this.addOperator(t)});return this};n.prototype.removeOperator=function(t){const e=this.getSupportedOperators();let i=t;if(typeof t!=="string"){i=t.name}if(e.indexOf(i)>-1){e.splice(e.indexOf(i),1);this.setOperators(e)}};n.prototype.removeOperators=function(t){if(!Array.isArray(t)){t=[t]}t.forEach(t=>{this.removeOperator(t)})};n.prototype.removeAllOperators=function(){this.setOperators([])};n.prototype.setDefaultOperator=function(t){let e=t;if(t&&typeof t!=="string"){e=t.name}this.setProperty("defaultOperator",e);return this};n.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&!this.isPropertyInitial("dataType")){const i=this._getValueHelp();const o=t.getElementById(i);const s=this.getBindingInfo("conditions");const n=this.getBinding("conditions");if(this.getDisplay()!==r.Value&&i&&(!o||s&&!n)){return}e.prototype.checkCreateInternalContent.apply(this,arguments)}};n.prototype.handleModelContextChange=function(t){e.prototype.handleModelContextChange.apply(this,arguments);if(this.getCurrentContent().length===0){this.triggerCheckCreateInternalContent()}};n.prototype.isSearchField=function(){if(this.isPropertyInitial("propertyKey")){return e.prototype.isSearchField.apply(this,arguments)}else{const t=this.getPropertyKey();const e=new RegExp("^\\*(.*)\\*|\\$search$");return e.test(t)&&this.getMaxConditions()===1}};function p(t){if(!t){this.getContentFactory().setAdditionalDataType()}else if(t.isA&&t.isA("sap.ui.model.Type")){this.getContentFactory().setAdditionalDataType(t)}else if(t.name){this.getContentFactory().setAdditionalDataType()}else{throw new Error("invalid type configuration")}}n.prototype.getAdditionalDataTypeConfiguration=function(){return this.getAdditionalDataType()};const a=(t,e)=>[...t.entries()].find(t=>s(t[0],e));n.prototype.getFormattingPromise=function(){if(this._mDescriptionPromises){const t=[...this._mDescriptionPromises.values()];if(t?.length){return Promise.allSettled(t)}}return undefined};n.prototype._persistFormatConditions=function(){if(!this.getFormattingPromise()){const t=this.getConditions();const e=t.map(t=>{const e=a(this._mDescriptions,t);return e?e[1]:t});this.setProperty("conditions",e,true);this._mDescriptionPromises.clear();this._mDescriptions.clear()}};n.prototype.getFormatOptions=function(){const t=this;return{...e.prototype.getFormatOptions.apply(this,arguments),awaitFormatCondition:function(e,i){const r=i.then(i=>{if(i){t._mDescriptions.set(e,i)}return i}).finally(()=>{t._mDescriptionPromises.delete(e);t._persistFormatConditions()});t._mDescriptionPromises.set(e,r);return r}}};return n});
//# sourceMappingURL=FilterField.js.map