/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/field/FieldInfoBase","sap/ui/thirdparty/jquery","sap/ui/model/BindingMode","sap/ui/model/json/JSONModel","sap/ui/mdc/link/Log","sap/base/Log","sap/ui/mdc/link/Panel","sap/ui/mdc/link/PanelItem","sap/ui/layout/form/SimpleForm","sap/ui/core/Title","sap/ui/layout/library","sap/ui/mdc/enums/LinkType"],(e,t,i,jQuery,n,o,r,s,a,l,d,c,p,u)=>{"use strict";const{ResponsiveGridLayout:g}=p.form.SimpleFormLayout;const h=i.extend("sap.ui.mdc.Link",{metadata:{library:"sap.ui.mdc",properties:{enablePersonalization:{type:"boolean",defaultValue:true},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/LinkDelegate",payload:{}}}},associations:{sourceControl:{type:"sap.ui.core.Control",multiple:false}}}});h.prototype.applySettings=function(){i.prototype.applySettings.apply(this,arguments);this.initControlDelegate()};h.prototype.init=function(){const e=new o({contentTitle:undefined,linkItems:[]});e.setDefaultBindingMode(n.TwoWay);e.setSizeLimit(1e3);this.setModel(e,"$sapuimdcLink");this.attachEvent("modelContextChange",this.fireDataUpdate,this);this._oLinkType=null;this._bLinkItemsFetched=false;this._aLinkItems=[];i.prototype.init.apply(this,arguments)};h.prototype.exit=function(){this._bLinkItemsFetched=undefined;this._oLinkType=undefined;this._oUseDelegateItemsPromise=undefined;this._oUseDelegateAdditionalContentPromise=undefined;const e=t=>{if(Array.isArray(t)){t.forEach(e)}else{t.destroy()}};if(this._aLinkItems){this._aLinkItems.forEach(e);this._aLinkItems=undefined}if(this._aAdditionalContent){this._aAdditionalContent.forEach(e);this._aAdditionalContent=undefined}i.prototype.exit.apply(this,arguments)};h.prototype.isTriggerable=function(){return this.retrieveLinkType().then(e=>{if(!e){return false}const t=e.runtimeType;const i=e.initialType?e.initialType:e;if(t&&t instanceof Promise){t.then(e=>{if(!this._oLinkType||e.type!==this._oLinkType.type){this._oLinkType=e;this.fireDataUpdate()}})}return this._oLinkType?this._oLinkType.type===u.DirectLink||this._oLinkType.type===u.Popover:i.type===u.DirectLink||i.type===u.Popover})};h.prototype.getTriggerHref=function(){return this.getDirectLinkHrefAndTarget().then(e=>e?e.href:null)};h.prototype.getDirectLinkHrefAndTarget=function(){return this._retrieveDirectLinkItem().then(e=>{if(this.isDestroyed()){return null}this.addDependent(e);return e?{target:e.getTarget(),href:e.getHref()}:null})};h.prototype._retrieveDirectLinkItem=function(){return this.retrieveLinkType().then(e=>{if(!e){return null}if(this._linkTypeHasDirectLink(this._oLinkType)){return this._oLinkType.directLink}const t=e.initialType?e.initialType:e;if(this._linkTypeHasDirectLink(t)){return t.directLink}return null})};h.prototype._linkTypeHasDirectLink=function(e){return e&&e.type===u.DirectLink&&e.directLink};h.prototype.getContent=async function(e){const t=this.retrieveLinkItems();const i=this.retrieveAdditionalContent();const[n,o]=await Promise.all([t,i]);this._setConvertedLinkItems(n);const r=this._getInternalModel().getProperty("/linkItems");const s=!o.length&&!r.length?this._getNoContent():o;return this._getContent(n,s,e,a)};h.prototype._getContent=async function(t,i,n,r){const s=await this.retrievePanelId();const a=this._getInternalModel().getProperty("/baselineLinkItems");const d=e.getElementById(s);if(d){if(d.getParent()&&d.getParent().close){d.getParent().close()}d.destroy()}const c=new r(s,{enablePersonalization:this.getEnablePersonalization(),items:a.map(e=>{const t=new l(e.key,{text:e.text,description:e.description,href:e.href,internalHref:e.internalHref,target:e.target,icon:e.icon,visible:true});t.setText(e.text);return t}),additionalContent:i,beforeSelectionDialogOpen:function(){if(n&&n()){n().setModal(true)}},afterSelectionDialogClose:function(){if(n&&n()){n().setModal(false)}},beforeNavigationCallback:this._beforeNavigationCallback.bind(this),metadataHelperPath:"sap/ui/mdc/Link"});c.setModel(new o({metadata:jQuery.extend(true,[],this._getInternalModel().getProperty("/linkItems")),baseline:jQuery.extend(true,[],this._getInternalModel().getProperty("/baselineLinkItems"))}),"$sapuimdcLink");this._setAdditionalContent(undefined);return c};h.prototype.checkDirectNavigation=async function(e){const t=this.retrieveLinkItems();const i=this.retrieveAdditionalContent();const[n,o]=await Promise.all([t,i]);this._setConvertedLinkItems(n);const r=this._getInternalModel().getProperty("/linkItems");const s=r.length===1&&!o.length;if(s){const t=await this._beforeNavigationCallback(e);if(t){a.navigate(r[0].href)}}return s};h.prototype._setConvertedLinkItems=function(e){const t=this._getInternalModel();const i=e.map(e=>{if(!e.getKey()){s.error("sap.ui.mdc.Link: undefined 'key' property of the LinkItem "+e.getId()+". The mandatory 'key' property should be defined due to personalization reasons.")}return{key:e.getKey(),text:e.getText(),description:e.getDescription(),href:e.getHref(),internalHref:e.getInternalHref(),target:e.getTarget(),icon:e.getIcon(),initiallyVisible:e.getInitiallyVisible(),visible:false}});t.setProperty("/linkItems/",i);const n=i.filter(e=>e.initiallyVisible);t.setProperty("/baselineLinkItems/",n)};h.prototype._getNoContent=function(){const e=new d({layout:g,content:[new c({text:t.getResourceBundleFor("sap.ui.mdc").getText("info.POPOVER_MSG_NO_CONTENT")})]});e.addStyleClass("mdcbaseinfoPanelDefaultAdditionalContent");return e};h.retrieveAllMetadata=function(e){if(!e.getModel||!e.getModel("$sapuimdcLink")){return[]}const t=e.getModel("$sapuimdcLink");return t.getProperty("/metadata").map(e=>({id:e.key,text:e.text,description:e.description,href:e.href,internalHref:e.internalHref,target:e.target,visible:e.visible}))};h.retrieveBaseline=function(e){if(!e.getModel||!e.getModel("$sapuimdcLink")){return[]}const t=e.getModel("$sapuimdcLink");return t.getProperty("/baseline").map(e=>({id:e.key,visible:true}))};h.prototype._getInfoLog=function(){if(this.getPayload()&&this.getPayload().semanticObjects){if(this._oInfoLog){return this._oInfoLog}if(s.getLevel()>=s.Level.INFO){this._oInfoLog=new r;this._oInfoLog.initialize(this.getPayload().semanticObjects,this._getContextObject(this._getControlBindingContext()));return this._oInfoLog}}return undefined};h.prototype._getContextObject=function(e){return e?e.getObject(e.getPath()):undefined};h.prototype.retrievePopoverTitle=async function(e){const t=await this.awaitControlDelegate();return t.fetchPopoverTitle(this,e)};h.prototype.retrievePanelId=async function(){if(this.awaitControlDelegate()){await this.awaitControlDelegate();return this.getControlDelegate().getPanelId(this)}s.error("mdc.Link retrieveAdditionalContent: control delegate is not set - could not load AdditionalContent from delegate.");return Promise.resolve("idInfoPanel")};h.prototype.retrieveAdditionalContent=function(){if(this._aAdditionalContent){return Promise.resolve(this._aAdditionalContent)}else{this._oUseDelegateAdditionalContentPromise=this._useDelegateAdditionalContent();return this._oUseDelegateAdditionalContentPromise.then(()=>Promise.resolve(this._aAdditionalContent))}};h.prototype._useDelegateAdditionalContent=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(()=>new Promise(e=>{this.getControlDelegate().fetchAdditionalContent(this,this).then(t=>{this._setAdditionalContent(t===null?[]:t);e()})}))}s.error("mdc.Link retrieveAdditionalContent: control delegate is not set - could not load AdditionalContent from delegate.");return Promise.resolve([])};h.prototype._setAdditionalContent=function(e){this._aAdditionalContent=e};h.prototype.retrieveLinkType=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(()=>this._bIsBeingDestroyed?Promise.resolve():this.getControlDelegate().fetchLinkType(this))}s.error("mdc.Link retrieveLinkType: control delegate is not set - could not load LinkType from delegate.");return Promise.resolve(null)};h.prototype.retrieveLinkItems=function(){const e=this._getControlBindingContext();return this._retrieveUnmodifiedLinkItems().then(t=>this.getControlDelegate().modifyLinkItems(this,e,t).then(e=>e))};h.prototype._retrieveUnmodifiedLinkItems=function(){if(this._bLinkItemsFetched){return Promise.resolve(this._aLinkItems)}else{this._oUseDelegateItemsPromise=this._useDelegateItems();return this._oUseDelegateItemsPromise.then(()=>Promise.resolve(this._aLinkItems))}};h.prototype._useDelegateItems=function(){if(this.awaitControlDelegate()){return this.awaitControlDelegate().then(()=>{const e=this._getControlBindingContext();const t=this._getInfoLog();return new Promise(i=>{this.getControlDelegate().fetchLinkItems(this,e,t).then(e=>{this._setLinkItems(e===null?[]:e);this._bLinkItemsFetched=e!==null;i()})})})}s.error("mdc.Link _useDelegateItems: control delegate is not set - could not load LinkItems from delegate.");return Promise.resolve()};h.prototype._setLinkItems=function(e){const t=e.filter(e=>e.getParent()===null);t.forEach(e=>{this.addDependent(e)});this._aLinkItems=e};h.prototype._beforeNavigationCallback=function(e){if(this.awaitControlDelegate()){return this.getControlDelegate().beforeNavigationCallback(this,e)}s.error("mdc.Link _beforeNavigationCallback: control delegate is not set - could not load beforeNavigationCallback from delegate.");return Promise.resolve()};h.prototype._getControlBindingContext=function(){const e=this._getSourceControl();return e&&e.getBindingContext()||this.getBindingContext()};h.prototype._getInternalModel=function(){return this.getModel("$sapuimdcLink")};h.prototype._getSourceControl=function(){const t=this.getAssociation("sourceControl");const i=t&&typeof t==="string"?e.getElementById(t):t;return i??this.getSourceControl()};return h});
//# sourceMappingURL=Link.js.map