/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/library","sap/ui/mdc/field/FieldBase","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName"],(t,e,i,n,o,s)=>{"use strict";const a=e.extend("sap.ui.mdc.MultiValueField",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/field/MultiValueField.designtime",properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/MultiValueFieldDelegate",payload:{}}}},aggregations:{items:{type:"sap.ui.mdc.field.MultiValueFieldItem",multiple:true,singularName:"item",bindable:"bindable"}},defaultAggregation:"items",events:{change:{parameters:{items:{type:"sap.ui.mdc.field.MultiValueFieldItem[]"},valid:{type:"boolean"},promise:{type:"Promise"}}}}},renderer:i});a.prototype.init=function(){e.prototype.init.apply(this,arguments);this.setProperty("_operators",[s.EQ],true);this._oObserver.observe(this,{aggregations:["items"]})};a.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this._iConditionUpdateTimer){clearTimeout(this._iConditionUpdateTimer);delete this._iConditionUpdateTimer}};a.prototype.bindAggregation=function(t,i){if(t==="items"&&!i.formatter){r.call(this,i)}e.prototype.bindAggregation.apply(this,arguments)};function r(t){if(t.template){let e;if(t.template.mBindingInfos.key){const i=t.template.mBindingInfos.key;e=this.getContentFactory().getDataType();if(i.type&&(!e||e.getMetadata().getName()!==i.type.getMetadata().getName())){this._oContentFactory.setDataType(i.type);this.invalidate()}}if(t.template.mBindingInfos.description){const i=t.template.mBindingInfos.description;e=this.getContentFactory().getAdditionalDataType();if(i.type&&(!e||e.getMetadata().getName()!==i.type.getMetadata().getName())){this._oContentFactory.setAdditionalDataType(i.type);this.invalidate()}}}}a.prototype.handleModelContextChange=function(t){e.prototype.handleModelContextChange.apply(this,arguments);if(!this._oDataType){const t=this.getBinding("items");if(t){r.call(this,t)}}};a.prototype.initDataType=function(){e.prototype.initDataType.apply(this,arguments);const t=this.getBindingInfo("items");if(t){r.call(this,t)}};a.prototype.setMaxConditions=function(t){if(t===1){throw new Error("Multiple Conditions needed on MultiValueField "+this)}return this.setProperty("maxConditions",t,true)};a.prototype.observeChanges=function(t){e.prototype.observeChanges.apply(this,arguments);if(t.name==="items"){p.call(this,t.child,t.mutation)}if(t.name==="key"){l.call(this)}if(t.name==="description"){l.call(this)}if(t.name==="conditions"){d.call(this,t.current)}};function p(t,e){if(e==="insert"){this._oObserver.observe(t,{properties:true})}else{this._oObserver.unobserve(t)}if(!this._bMyItemUpdate){l.call(this)}}function d(t){if(this._bConditionsUpdateFromItems){return}if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{if(!this.bIsDestroyed){d.call(this.getConditions())}});return}this.getControlDelegate().updateItems(this.getPayload(),t,this)}function l(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{if(!this.bIsDestroyed){l.call(this)}});return}if(!this._iConditionUpdateTimer){this._iConditionUpdateTimer=setTimeout(()=>{h.call(this);this._iConditionUpdateTimer=undefined},0)}}function h(){const t=this.getItems();const e=[];const i=this.getConditions();const o=this.getControlDelegate();let s=0;let a=t.length!==i.length;for(const r of t){const t=i[s];const p=o.createCondition(this,this,[m(r,"key"),m(r,"description")],t);e.push(p);if(!t||!n.compareConditions(t,p)){a=true}s++}if(a){this._bConditionsUpdateFromItems=true;this.setConditions(e);this._bConditionsUpdateFromItems=false}}function m(t,e){const i=t.getBinding(e);if(i){return i.getInternalValue()}else{return t.getProperty(e)}}a.prototype.fireChangeEvent=function(t,e,i,n){this.fireChange({items:this.getItems(),valid:e,promise:n})};a.prototype.getResultForChangePromise=function(t){return this.getItems()};a.prototype.getSupportedOperators=function(){return this.getProperty("_operators",[])};a.prototype.checkCreateInternalContent=function(){if(!this.bIsDestroyed&&this._oContentFactory.getDataType()&&!this.isFieldPropertyInitial("editMode")){e.prototype.checkCreateInternalContent.apply(this,arguments)}};a.prototype.isSearchField=function(){return false};return a});
//# sourceMappingURL=MultiValueField.js.map