/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Control","./ActionToolbar","./table/TableSettings","./table/GridTableType","./table/TreeTableType","./table/ResponsiveTableType","./table/PropertyHelper","./table/utils/Personalization","./mixin/FilterIntegrationMixin","sap/m/Text","sap/m/ToolbarSpacer","sap/m/Button","sap/m/Title","sap/m/OverflowToolbar","sap/m/library","sap/m/table/Util","sap/m/table/columnmenu/Menu","sap/m/MessageBox","sap/ui/core/Element","sap/ui/core/Lib","sap/ui/core/format/NumberFormat","sap/ui/core/format/ListFormat","sap/ui/core/library","sap/ui/events/KeyCodes","sap/ui/model/base/ManagedObjectModel","sap/ui/model/BindingMode","sap/base/strings/capitalize","sap/base/util/deepEqual","sap/base/util/Deferred","sap/ui/core/InvisibleText","sap/ui/mdc/p13n/subcontroller/ColumnController","sap/ui/mdc/p13n/subcontroller/SortController","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/GroupController","sap/ui/mdc/p13n/subcontroller/AggregateController","sap/m/table/ColumnWidthController","sap/ui/mdc/p13n/subcontroller/ShowDetailsController","sap/ui/mdc/p13n/subcontroller/ColumnFreezeController","sap/ui/mdc/actiontoolbar/ActionToolbarAction","sap/ui/mdc/table/menu/QuickActionContainer","sap/ui/core/theming/Parameters","sap/base/Log","sap/ui/performance/trace/FESRHelper","sap/ui/mdc/enums/TableMultiSelectMode","sap/ui/mdc/enums/TableSelectionMode","sap/ui/mdc/enums/TableP13nMode","sap/ui/mdc/enums/TableType","sap/ui/mdc/enums/TableGrowingMode","sap/ui/mdc/enums/TableRowCountMode"],(t,e,o,i,n,s,r,a,l,u,p,h,d,c,g,f,_,y,b,T,m,C,x,E,B,A,I,P,S,w,D,v,M,R,F,N,H,z,O,V,L,j,k,G,U,W,K)=>{"use strict";const{ToolbarDesign:q}=g;const{ToolbarStyle:Q}=g;const{IllustratedMessageType:X}=g;const{TitleLevel:$}=x;const{SortOrder:Y}=x;const J=new window.WeakMap;const Z=function(t){if(!J.has(t)){J.set(t,{oFilterInfoBar:null})}return J.get(t)};const tt={Table:i,TreeTable:n,ResponsiveTable:s,null:i};const et=t.extend("sap.ui.mdc.Table",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/table/Table.designtime",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IxState"],defaultAggregation:"columns",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},p13nMode:{type:"sap.ui.mdc.enums.TableP13nMode[]",group:"Behavior",defaultValue:[]},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/TableDelegate",payload:{}}},headerLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:$.Auto},headerStyle:{type:"sap.ui.core.TitleLevel",group:"Appearance"},autoBindOnInit:{type:"boolean",group:"Behavior",defaultValue:true},header:{type:"string",group:"Appearance",defaultValue:null},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true},useColumnLabelsAsTooltips:{type:"boolean",defaultValue:false},selectionMode:{type:"sap.ui.mdc.enums.TableSelectionMode",group:"Behavior",defaultValue:U.None},showRowCount:{type:"boolean",group:"Appearance",defaultValue:true},threshold:{type:"int",group:"Behavior",defaultValue:-1},sortConditions:{type:"object"},filterConditions:{type:"object",defaultValue:{}},groupConditions:{type:"object"},aggregateConditions:{type:"object"},enableExport:{type:"boolean",group:"Behavior",defaultValue:false},busyIndicatorDelay:{type:"int",defaultValue:100},enableColumnResize:{type:"boolean",group:"Behavior",defaultValue:true},showPasteButton:{type:"boolean",group:"Appearance",defaultValue:false},enablePaste:{type:"boolean",group:"Behavior",defaultValue:true},multiSelectMode:{type:"sap.ui.mdc.enums.TableMultiSelectMode",group:"Behavior",defaultValue:G.Default},enableAutoColumnWidth:{type:"boolean",group:"Behavior",defaultValue:false},propertyInfo:{type:"object",defaultValue:[]},hideToolbar:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{_content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},type:{type:"sap.ui.mdc.table.TableTypeBase",altTypes:["sap.ui.mdc.enums.TableType"],multiple:false},columns:{type:"sap.ui.mdc.table.Column",multiple:true},creationRow:{type:"sap.ui.mdc.table.CreationRow",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_createToolbar",aggregation:"actions"}},variant:{type:"sap.ui.fl.variants.VariantManagement",multiple:false},quickFilter:{type:"sap.ui.core.Control",multiple:false},rowSettings:{type:"sap.ui.mdc.table.RowSettings",multiple:false},dataStateIndicator:{type:"sap.m.plugins.DataStateIndicator",multiple:false},noData:{type:"sap.ui.core.Control",multiple:false,altTypes:["string"]},copyProvider:{type:"sap.m.plugins.CopyProvider",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false},cellSelector:{type:"sap.m.plugins.CellSelector",multiple:false}},associations:{filter:{type:"sap.ui.mdc.IFilter",multiple:false}},events:{rowPress:{parameters:{bindingContext:{type:"sap.ui.model.Context"}}},selectionChange:{parameters:{selectAll:{type:"boolean"}}},beforeExport:{allowPreventDefault:true,parameters:{exportSettings:{type:"object"},userExportSettings:{type:"object"},filterSettings:{type:"object[]"}}},paste:{parameters:{data:{type:"string[][]"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{bindingContext:{type:"sap.ui.model.Context"},column:{type:"sap.ui.mdc.table.Column"}}}}},constructor:function(){this._createInitPromises();t.apply(this,arguments);this.bCreated=true;this._updateAdaptation();this._initializeContent()},renderer:{apiVersion:2,render:function(t,e){t.openStart("div",e);t.class("sapUiMdcTable");t.style("width",e.getWidth());e._getType().getTableStyleClasses().forEach(e=>{t.class(e)});t.openEnd();t.renderControl(e.getAggregation("_content"));t.close("div")}}});l.call(et.prototype);const ot=["variant","quickFilter"];ot.forEach(t=>{const e=I(t),o="_o"+e,i="get"+e,n="set"+e,s="destroy"+e;et.prototype[i]=function(){return this[o]};et.prototype[s]=function(){const t=this[o];this[n]();if(t){t.destroy()}return this};et.prototype[n]=function(e){this.validateAggregation(t,e,false);const n=this._createToolbar(),s=e!==this[o];if(!e||s){n.removeBetween(this[i]());this[o]=e}if(s&&e){this._setToolbarBetween(n)}if(t==="variant"){this._updateVariantManagementStyle()}return this}});et.prototype.init=function(){t.prototype.init.apply(this,arguments);this.mSkipPropagation={rowSettings:true};this._bForceRebind=true;this._setPropertyHelperClass(r);this._setupPropertyInfoStore("propertyInfo");this._oManagedObjectModel=new B(this,{hasGrandTotal:false,activeP13nModes:ft(this)});this._oManagedObjectModel.setDefaultBindingMode(A.OneWay);this.setModel(this._oManagedObjectModel,"$sap.ui.mdc.Table")};et.prototype.applySettings=function(e,o){if(e&&"type"in e){const i={type:e.type};if("delegate"in e){i.delegate=e.delegate;delete e.delegate}delete e.type;t.prototype.applySettings.call(this,i,o)}t.prototype.applySettings.call(this,e,o);this.initControlDelegate()};et.prototype._setToolbarBetween=function(t){[this._oVariant,this._oQuickFilter].forEach(e=>{if(e){t.addBetween(e)}})};et.prototype.initialized=function(){return this._oTableReady.promise};et.prototype._fullyInitialized=function(){return this._oFullInitialize.promise};["CopyProvider","CellSelector","DataStateIndicator","ContextMenuSetting"].forEach(t=>{et.prototype[`get${t}PluginOwner`]=function(){return this._oTable||this._oFullInitialize?.promise}});et.prototype.setCopyProvider=function(t){this.setAggregation("copyProvider",t,true);if(window.isSecureContext&&t&&!b.getElementById(this.getId()+"-copy")){this._oToolbar?.insertEnd(this._getCopyButton(),0)}return this};et.prototype.attachEvent=function(e){t.prototype.attachEvent.apply(this,arguments);if(e=="rowPress"){this._getType().prepareRowPress()}return this};et.prototype.detachEvent=function(e){t.prototype.detachEvent.apply(this,arguments);if(e=="rowPress"){this._getType().cleanupRowPress()}return this};et.prototype.getColumnClipboardSettings=function(t){return this.getPropertyHelper().getColumnClipboardSettings(t)};et.prototype.setDataStateIndicator=function(t){this._handleDataStateEvents(this.getDataStateIndicator(),"detach");this.setAggregation("dataStateIndicator",t,true);this._handleDataStateEvents(this.getDataStateIndicator(),"attach");return this};et.prototype._handleDataStateEvents=function(t,e){if(t){t[e+"ApplyFilter"](this._onApplyMessageFilter,this);t[e+"ClearFilter"](this._onClearMessageFilter,this);t[e+"Event"]("filterInfoPress",function(){a.openFilterDialog(this)},this)}};et.prototype._onApplyMessageFilter=function(t){this._oMessageFilter=t.getParameter("filter");t.preventDefault();if(this.isTableBound()){this.rebind()}};et.prototype._onClearMessageFilter=function(t){this._oMessageFilter=null;t.preventDefault();if(this.isTableBound()){this.rebind()}};et.prototype._isOfType=function(t,e){const o=this._getType();if(e){return o.isA(tt[t].getMetadata().getName())}else{return o.constructor===tt[t]}};et.prototype.setContextMenu=function(t){this._oContextMenu=this.validateAggregation("contextMenu",t,false);this._oTable?.setAggregation("contextMenu",t,true);return this};et.prototype.getContextMenu=function(){return this._oContextMenu&&!this._oContextMenu.isDestroyed()?this._oContextMenu:null};et.prototype.destroyContextMenu=function(){if(this._oTable){this._oTable.destroyContextMenu()}else if(this._oContextMenu){this._oContextMenu.destroy()}this._oContextMenu=null;return this};et.prototype._onBeforeOpenContextMenu=function(t){const e=t.contextMenu;let o=true;if(e.isA("sap.ui.mdc.table.menu.GroupHeaderRowContextMenu")){e.initContent(this,{groupLevel:t.groupLevel});o=e.isEmpty()}else{o=!this.fireBeforeOpenContextMenu({bindingContext:t.bindingContext,column:t.column})}if(o){t.event.preventDefault()}};et.prototype.scrollToIndex=function(t){if(typeof t!=="number"){return Promise.reject("The iIndex parameter has to be a number")}return this._getType().scrollToIndex(t)};et.prototype.focusRow=function(t,e){return this.scrollToIndex(t).then(()=>this._oTable._setFocus(t,e))};et.prototype.setType=function(t){if(!this.bCreated){return this.setAggregation("type",t,true)}this._resetContent();this.setAggregation("type",t);this._initializeContent();this._updateAdaptation();return this};et.prototype.destroyType=function(){if(!this.getType()){return this.destroyAggregation("type",true)}this._resetContent();this.destroyAggregation("type");this._initializeContent();return this};et.prototype._resetContent=function(){if(this._oTable){if(this._oToolbar){this._getType().removeToolbar()}const t=this.getNoData();this.setNoData();this._vNoData=t;const e=this.getContextMenu();this.setContextMenu();this._oContextMenu=e;this._oTable.destroy("KeepDom");this._oTable=null}else{this._onAfterInitialization("Type changed");this._onAfterFullInitialization("Type changed")}if(this._oRowTemplate){this._oRowTemplate.destroy();this._oRowTemplate=null}this._destroyDefaultType();this._createInitPromises()};et.prototype._getType=function(){const t=this.getType();if(!this._oDefaultType&&(typeof t==="string"||t===null)){this._oDefaultType=new tt[t];this.addDependent(this._oDefaultType)}return this._oDefaultType||this.getType()};et.prototype._destroyDefaultType=function(){if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}};et.prototype.setRowSettings=function(t){this.setAggregation("rowSettings",t,true);this._getType().updateRowSettings();if(this.isTableBound()){this._bForceRebind=true;this.rebind()}return this};et.prototype.setHeaderLevel=function(t){if(this.getHeaderLevel()===t){return this}this.setProperty("headerLevel",t,true);this._oTitle?.setLevel(t);this._updateVariantManagementStyle();return this};et.prototype.setHeaderStyle=function(t){if(this.getHeaderStyle()===t){return this}this.setProperty("headerStyle",t,true);const e=this.getHeaderStyle()||$[L.get({name:"_sap_ui_mdc_Table_HeaderStyle"})];this._oTitle?.setTitleStyle(e);this._updateVariantManagementStyle();return this};et.prototype.focus=function(t){if(this._oTable){this._oTable.focus(t)}};et.prototype.setBusy=function(t){this.setProperty("busy",t,true);if(this._oTable){this._oTable.setBusy(t)}return this};et.prototype.setBusyIndicatorDelay=function(t){this.setProperty("busyIndicatorDelay",t,true);if(this._oTable){this._oTable.setBusyIndicatorDelay(t)}return this};et.prototype.setCreationRow=function(t){this.setAggregation("creationRow",t,true);if(t){t.update()}return this};et.prototype.setEnableColumnResize=function(t){const e=this.getEnableColumnResize();this.setProperty("enableColumnResize",t,true);if(this.getEnableColumnResize()!==e){this._updateColumnResize();this._updateAdaptation()}return this};const it=function(t){let e=false;if(t&&(t.indexOf("Sort")>-1||t.indexOf("Column")>-1||t.indexOf("Group")>-1||t.indexOf("Aggregate")>-1||t.indexOf("Filter")>-1)){e=true}return e};et.prototype._onModifications=async function(t){this.getColumns().forEach(t=>{t._onModifications()});this._getType().onModifications(t);if(it(t)&&this.isTableBound()){await this.finalizePropertyHelper();await this.rebind()}};et.prototype.setP13nMode=function(t){const e=this.getP13nMode();let o=[];if(t&&t.length>1){const e=t.reduce((t,e,o)=>{t[e]=true;return t},{});if(e.Column){o.push("Column")}if(e.Sort){o.push("Sort")}if(e.Filter){o.push("Filter")}if(e.Group){o.push("Group")}if(e.Aggregate){o.push("Aggregate")}}else{o=t}this.setProperty("p13nMode",o,true);this._updateAdaptation();this._oManagedObjectModel.setProperty("/@custom/activeP13nModes",ft(this));if(!P(e.sort(),this.getP13nMode().sort())){nt(this)}return this};et.prototype._updateAdaptation=function(){const t={controller:{}};const e=[];if(this.getColumns().length>0&&this._isOfType(K.TreeTable)){e.push(this.getColumns()[0].getPropertyKey())}const o={Column:new D({control:this,stableKeys:e}),Sort:new v({control:this}),Group:new R({control:this}),Filter:new M({control:this}),Aggregate:new F({control:this}),ColumnWidth:new N({control:this,exposeXConfig:true})};this.getActiveP13nModes().forEach(e=>{t.controller[e]=o[e]});if(this.getEnableColumnResize()){t.controller["ColumnWidth"]=o["ColumnWidth"]}if(this._isOfType(K.Table,true)&&this._getType().getEnableColumnFreeze()){o["ColumnFreeze"]=new z({control:this});t.controller["ColumnFreeze"]=o["ColumnFreeze"]}if(this._isOfType(K.ResponsiveTable)&&this._getType().getShowDetailsButton()){o["ShowDetails"]=new H({control:this});t.controller["ShowDetails"]=o["ShowDetails"]}this.getEngine().register(this,t)};function nt(t){t._updateP13nButton();if(t._oTable){const e=t._oTable.getDragDropConfig()[0];if(e){e.setEnabled(t.getActiveP13nModes().indexOf("Column")>-1)}}if(t.isFilteringEnabled()){rt(t)}st(t)}et.prototype.setFilterConditions=function(t){this.setProperty("filterConditions",t,true);this.getInbuiltFilter()?.setFilterConditions(t);st(this);return this};function st(t){const e=ut(t);const o=pt(t);const i=ht(t);if(!e){return}if(i.length===0){const o=e.getDomRef();if(o&&o.contains(document.activeElement)){t.focus()}e.setVisible(false);at(t).setText("");return}t._fullyInitialized().then(()=>{const n=t.getPropertyHelper();const s=i.map(t=>n.hasProperty(t)?n.getProperty(t).label:"");const r=T.getResourceBundleFor("sap.ui.mdc");const a=C.getInstance();let l;if(s.length>1){l=r.getText("table.MULTIPLE_FILTERS_ACTIVE",[s.length,a.format(s)])}else{l=r.getText("table.ONE_FILTER_ACTIVE",s)}if(!e.getVisible()){e.setVisible(true)}o.setText(l);at(t).setText(l)})}function rt(t){if(!t._oTable){return}let e=ut(t);const o=at(t);if(!e){e=lt(t)}t._getType().insertFilterInfoBar(e,o.getId())}function at(t){if(!t._oFilterInfoBarInvisibleText){t._oFilterInfoBarInvisibleText=(new w).toStatic()}return t._oFilterInfoBarInvisibleText}function lt(t){const e=t.getId()+"-filterInfoBar";let o=Z(t).oFilterInfoBar;const i=T.getResourceBundleFor("sap.ui.mdc");if(o&&!o.isDestroyed()){o.destroy()}o=new c({id:e,active:true,design:q.Info,visible:false,ariaLabelledBy:e+"-text",content:[new u({id:e+"-text",wrapping:false}),new p,new h({type:g.ButtonType.Transparent,tooltip:i.getText("infobar.REMOVEALLFILTERS"),icon:"sap-icon://decline",press:function(){a.createClearFiltersChange(t);t.focus()}})],press:function(){a.openFilterDialog(t,()=>{if(ht(t).length===0){t.focus()}})}});Z(t).oFilterInfoBar=o;st(t);return o}function ut(t){const{oFilterInfoBar:e}=Z(t);if(e?.isDestroyStarted()){return null}return e}function pt(t){const e=ut(t);return e?e.getContent()[0]:null}et.prototype.setThreshold=function(t){return this.setProperty("threshold",t,true)};et.prototype._onFilterProvided=function(t){this._updateInnerTableNoData()};et.prototype._onFilterRemoved=function(t){this._updateInnerTableNoData()};et.prototype._onFiltersChanged=function(t){if(this.isTableBound()&&t.getParameter("conditionsBased")){this._oTable.setShowOverlay(true)}};et.prototype._onFilterSearch=function(t){this._bAnnounceTableUpdate=true};et.prototype.setNoData=function(t){this._vNoData=this.validateAggregation("noData",t,false);if(!this._oTable){return this}if(t&&t.isA&&t.isA("sap.m.IllustratedMessage")){this._sLastNoDataTitle="";t.setEnableVerticalResponsiveness(!this._isOfType(K.ResponsiveTable));let e=this._oTable.getAggregation("_noColumnsMessage");if(!e){e=f.getNoColumnsIllustratedMessage(()=>{a.openSettingsDialog(this)});e.setEnableVerticalResponsiveness(!this._isOfType(K.ResponsiveTable));this._oTable.setAggregation("_noColumnsMessage",e)}}this._oTable.setNoData(t);this._updateInnerTableNoData();return this};et.prototype.getNoData=function(){return this._vNoData&&!this._vNoData.isDestroyed?.()?this._vNoData:null};et.prototype.destroyNoData=function(){if(this._oTable){this._oTable.destroyNoData(true)}else if(this._vNoData){this._vNoData.destroy?.()}this._vNoData=null;return this};et.prototype._updateInnerTableNoData=function(){const t=this.getNoData();if(!t||typeof t=="string"){return this._updateInnerTableNoDataText()}if(!t.isA("sap.m.IllustratedMessage")||this._sLastNoDataTitle!=t.getTitle()){return}const e=T.getResourceBundleFor("sap.ui.mdc");if(!this.isTableBound()){t.setDescription(" ");if(this.getFilter()){t.setTitle(e.getText("table.NO_DATA_WITH_FILTERBAR"));t.setIllustrationType(X.BeforeSearch)}else{t.setIllustrationType(X.NoEntries);t.setTitle(e.getText("table.NO_DATA"))}}else if(ct(this)){t.setTitle(e.getText("table.NO_RESULTS_TITLE"));t.setDescription(e.getText("table.NO_RESULTS_DESCRIPTION"));t.setIllustrationType(X.NoFilterResults)}else{t.setTitle(e.getText("table.NO_DATA")).setDescription(" ");t.setIllustrationType(X.NoEntries)}this._sLastNoDataTitle=t.getTitle()};et.prototype._updateInnerTableNoDataText=function(){if(this._oTable){this._oTable.setNoData(this._getNoDataText())}};et.prototype._getNoDataText=function(){const t=this.getNoData();if(t&&typeof t=="string"){return t}const e=T.getResourceBundleFor("sap.ui.mdc");if(!this.isTableBound()){return e.getText(this.getFilter()?"table.NO_DATA_WITH_FILTERBAR":"table.NO_DATA")}if(ct(this)){return e.getText("table.NO_RESULTS")}return e.getText("table.NO_DATA")};et.prototype._updateRowActions=function(){this._getType().updateRowActions()};et.prototype._initializeContent=function(){const t=this._getType();const e=[this.awaitControlDelegate(),t.loadModules()];if(this.isFilteringEnabled()){e.push(this.retrieveInbuiltFilter())}Promise.all(e).then(()=>{if(this.isDestroyed()){return Promise.reject("Destroyed")}this._oManagedObjectModel.setProperty("/@custom/activeP13nModes",ft(this));this._updateAdaptation();if(this.getControlDelegate().preInit){this.getControlDelegate().preInit(this)}if(!this._oTable&&t.constructor===this._getType().constructor){return this._createContent()}else{return Promise.resolve()}}).catch(t=>{this._onAfterInitialization(t||"");this._onAfterFullInitialization(t||"")})};et.prototype._createInitPromises=function(){this._oTableReady=new S;this._oFullInitialize=new S;this._oFullInitialize.promise.catch(()=>{})};et.prototype._onAfterInitialization=function(t){if(this._oTableReady){if(t!=null){this._oTableReady.reject(t)}else{this._oTableReady.resolve(this)}}};et.prototype._onAfterFullInitialization=function(t){if(this._oFullInitialize){if(t!=null){this._oFullInitialize.reject(t)}else{this._oFullInitialize.resolve(this)}}};et.prototype._createContent=function(){this._createToolbar();this._createTable();this._updateColumnResize();this._updateRowActions();this._updateExpandAllButton();this._updateCollapseAllButton();this._updateExportButton();this.getColumns().forEach(this._insertInnerColumn,this);return this.getControlDelegate().initializeContent(this).then(()=>{if(this.isDestroyed()){return Promise.reject("Destroyed")}this.setAggregation("_content",this._oTable);this._onAfterInitialization();return Promise.all([this.getPropertyInfo().length===0?this.finalizePropertyHelper():this.awaitPropertyHelper(),this.initialized()])}).then(()=>{if(this.isDestroyed()){return Promise.reject("Destroyed")}const t=this.getCreationRow();if(t){t.update()}if(this.getAutoBindOnInit()){const t=this.getEngine();t.isModificationSupported(this).then(e=>{if(e){t.waitForChanges(this).then(()=>{this.rebind()})}else{this.rebind()}})}this._onAfterFullInitialization()})};et.prototype.setHeader=function(t){this.setProperty("header",t,true);this._updateHeaderText();return this};et.prototype.setHeaderVisible=function(t){this.setProperty("headerVisible",t,true);if(this._oTitle){this._oTitle.setWidth(this.getHeaderVisible()?undefined:"0px")}this._updateInvisibleTitle();this._updateVariantManagementStyle();return this};et.prototype._updateInvisibleTitle=function(){if(this._oInvisibleTitle&&!this.getHideToolbar()){this._oInvisibleTitle.destroy();this._oInvisibleTitle=null;this._oTable.removeAriaLabelledBy(this.getId()+"-invisibleTitle")}else if(this._oTable&&!this._oInvisibleTitle&&this.getHideToolbar()){this._oInvisibleTitle=new w(this.getId()+"-invisibleTitle",{text:"{$sap.ui.mdc.Table>/header}"}).toStatic();this._oTable.addAriaLabelledBy(this.getId()+"-invisibleTitle")}else if(this._oInvisibleTitle&&!this._oTable.getAriaLabelledBy().includes(this.getId()+"-invisibleTitle")){this._oTable.addAriaLabelledBy(this.getId()+"-invisibleTitle")}};et.prototype.setShowRowCount=function(t){this.setProperty("showRowCount",t,true);this._updateHeaderText();return this};et.prototype.setEnableExport=function(t){this.setProperty("enableExport",t,true);this._updateExportButton();return this};et.prototype.setShowPasteButton=function(t){if((t=!!t)==this.getShowPasteButton()){return this}this.setProperty("showPasteButton",t,true);if(t&&!this._oPasteButton&&this._oToolbar){this._oToolbar.insertEnd(this._getPasteButton(),0);this._oPasteButton.setEnabled(this.getEnablePaste())}else if(this._oPasteButton){this._oPasteButton.setVisible(t);this._oPasteButton.setEnabled(this.getEnablePaste())}return this};et.prototype.setEnablePaste=function(t){this.setProperty("enablePaste",t,true);if(this._oPasteButton){this._oPasteButton.setEnabled(this.getEnablePaste())}return this};et.prototype._setShowP13nButton=function(t){this._bHideP13nButton=!t;this._updateP13nButton()};et.prototype._isP13nButtonHidden=function(){return this._bHideP13nButton};et.prototype._createToolbar=function(){if(this.isDestroyStarted()){return}if(!this._oToolbar){this._oTitle=new d(this.getId()+"-title",{text:this.getHeader(),width:this.getHeaderVisible()?undefined:"0px",level:this.getHeaderLevel(),titleStyle:this.getHeaderStyle()||$[L.get({name:"_sap_ui_mdc_Table_HeaderStyle"})]});this._oToolbar=new e(this.getId()+"-toolbar",{design:q[L.get({name:"_sap_ui_mdc_Table_ToolbarDesign"})],begin:[this._oTitle],end:[this._getCopyButton(),this._getPasteButton(),this._getP13nButton()],visible:"{= !${$sap.ui.mdc.Table>/hideToolbar} }"});this._oToolbar.setProperty("_endOrder",["copy","paste","showHideDetails","collapseAll","expandAll","settings","export"].map(t=>this.getId()+"-"+t));this._updateInvisibleTitle()}this._oToolbar.setStyle(this._isOfType(K.ResponsiveTable)?Q.Standard:Q.Clear);return this._oToolbar};et.prototype._getVisibleProperties=function(){const t=[];let e;this.getColumns().forEach((o,i)=>{e=o&&o.getPropertyKey();if(e){t.push({key:e,name:e})}});return t};et.prototype.getConditions=function(){return this.getInbuiltFilter()?this.getInbuiltFilter().getConditions():[]};et.prototype._getSortedProperties=function(){return this.getSortConditions()?this.getSortConditions().sorters:[]};et.prototype._getGroupedProperties=function(){return this.getGroupConditions()?this.getGroupConditions().groupLevels:[]};et.prototype._getAggregatedProperties=function(){return this.getAggregateConditions()?this.getAggregateConditions():{}};et.prototype._getXConfig=function(){return this.getEngine().readXConfig(this)};function ht(t){return t.isFilteringEnabled()?gt(t.getFilterConditions()):[]}function dt(t){const e=b.getElementById(t.getFilter());return e?gt(e.getConditions()):[]}function ct(t){const e=b.getElementById(t.getFilter());return ht(t).length>0||dt(t).length>0||e&&e.getSearch()!==""}function gt(t){return Object.keys(t||{}).filter(e=>t[e].length>0)}et.prototype.getCurrentState=function(){const t={};const e=this.getActiveP13nModes();if(e.indexOf("Column")>-1){t.items=this._getVisibleProperties()}if(this.isSortingEnabled()){t.sorters=this._getSortedProperties()}if(this.isFilteringEnabled()){t.filter=this.getFilterConditions()}if(this.isGroupingEnabled()){t.groupLevels=this._getGroupedProperties()}if(this.isAggregationEnabled()){t.aggregations=this._getAggregatedProperties()}if(this.getEnableColumnResize()||this._getType().showXConfigState()){t.xConfig=this._getXConfig()}return t};et.prototype.isFilteringEnabled=function(){return this.getActiveP13nModes().includes(W.Filter)};et.prototype.isSortingEnabled=function(){return this.getActiveP13nModes().includes(W.Sort)};et.prototype.isGroupingEnabled=function(){return this.getActiveP13nModes().includes(W.Group)};et.prototype.isAggregationEnabled=function(){return this.getActiveP13nModes().includes(W.Aggregate)};et.prototype.getSupportedP13nModes=function(){let t=Object.keys(W);if(this.isControlDelegateInitialized()){t=_t(t,this.getControlDelegate().getSupportedFeatures(this).p13nModes)}return t};function ft(t){const e=new Set(Object.keys(W));const o=new Set(t.getP13nMode());const i=new Set(t.isControlDelegateInitialized()?t.getControlDelegate().getSupportedFeatures(t).p13nModes:[]);const n=o.intersection(i);return Array.from(e).reduce((t,e)=>{t[e]=n.has(e);return t},{})}et.prototype.getActiveP13nModes=function(){return _t(this.getP13nMode(),this.getSupportedP13nModes())};function _t(t,e){return t.filter(t=>e.includes(t))}et.prototype._getP13nButton=function(){if(!this._oP13nButton){this._oP13nButton=o.createSettingsButton(this.getId(),[function(){a.openSettingsDialog(this)},this])}this._updateP13nButton();return this._oP13nButton};et.prototype._updateP13nButton=function(){if(this._oP13nButton){const t=this.getActiveP13nModes();const e=t.length===1&&t[0]==="Aggregate";this._oP13nButton.setVisible(t.length>0&&!e&&!this._bHideP13nButton)}};et.prototype._getCopyButton=function(){if(window.isSecureContext){return this.getCopyProvider()?.getCopyButton({id:this.getId()+"-copy"})}};et.prototype._getPasteButton=function(){if(this.getShowPasteButton()){if(!this._oPasteButton){this._oPasteButton=o.createPasteButton(this.getId())}return this._oPasteButton}};et.prototype._isExportEnabled=function(){return this.getEnableExport()&&this.isControlDelegateInitialized()&&this.getControlDelegate().getSupportedFeatures(this).export};et.prototype._updateExportButton=function(){const t=this._oToolbar!=null&&this._isExportEnabled();if(t&&!this._oExportButton){this._oExportButton=this._createExportButton()}if(!this._oExportButton){return}if(this._oToolbar&&!this._oToolbar.getEnd().includes(this._oExportButton)){this._oToolbar.addEnd(this._oExportButton)}this._oExportButton.setEnabled(f.isExportable(this.getRowBinding()));this._oExportButton.setVisible(this._isExportEnabled())};et.prototype._createExportButton=function(){return o.createExportButton(this.getId(),{default:[function(){this._onExport()},this],exportAs:[function(){this._onExport(true)},this]})};et.prototype._createExportColumnConfiguration=function(){const t=this.getColumns();return this._fullyInitialized().then(()=>this.finalizePropertyHelper()).then(()=>{const e=this.getPropertyHelper();let o=[];t.forEach(t=>{const i=e.getColumnExportSettings(t);o=o.concat(i)},this);return o})};et.prototype.setSelectionMode=function(t){const e=this.getSelectionMode();this.setProperty("selectionMode",t,true);if(e!==t){this._updateExpandAllButton(true);this._updateCollapseAllButton(true)}return this};et.prototype._isCollapseEnabled=async function(){if(!this.isControlDelegateInitialized()){return false}const t=await this.getControlDelegate().fetchExpandAndCollapseConfiguration(this);let e=false;if("collapseAll"in t){if(typeof t.collapseAll!=="function"){throw new Error("TableDelegate#collapseAll: collapseAll needs to be a function")}e=true}if("collapseAllFromNode"in t&&"isNodeExpanded"in t){if(typeof t.collapseAllFromNode!=="function"){throw new Error("TableDelegate#fetchExpandAndCollapseConfiguration: collapseAllFromNode needs to be a function")}if(typeof t.isNodeExpanded!=="function"){throw new Error("TableDelegate#isNodeExpanded: isNodeExpanded needs to be a function")}e=true}return e};et.prototype._updateCollapseAllButton=async function(t){const e=await this._isCollapseEnabled();const o=this._oToolbar!=null&&e;if(o&&(!this._oCollapseAllButton||t)){if(this._oCollapseAllButton){if(this._oToolbar&&this._oToolbar.getEnd().includes(this._oCollapseAllButton)){this._oToolbar.removeEnd(this._oCollapseAllButton)}this._oCollapseAllButton.destroy();this._oCollapseAllButton=null}this._oCollapseAllButton=await this._createCollapseButton()}if(!this._oCollapseAllButton){return}if(this._oToolbar&&!this._oToolbar.getEnd().includes(this._oCollapseAllButton)){this._oToolbar.insertEnd(this._oCollapseAllButton,0)}this._oCollapseAllButton.setEnabled(!f.isEmpty(this.getRowBinding()));this._oCollapseAllButton.setVisible(e)};et.prototype._isExpandEnabled=async function(){if(!this.isControlDelegateInitialized()){return false}const t=await this.getControlDelegate().fetchExpandAndCollapseConfiguration(this);let e=false;if("expandAll"in t){if(typeof t.expandAll!=="function"){throw new Error("TableDelegate#expandAll: expandAll needs to be a function")}e=true}if("expandAllFromNode"in t&&"isNodeExpanded"in t){if(typeof t.expandAllFromNode!=="function"){throw new Error("TableDelegate#fetchExpandAndCollapseConfiguration: expandAllFromNode needs to be a function")}if(typeof t.isNodeExpanded!=="function"){throw new Error("TableDelegate#isNodeExpanded: isNodeExpanded needs to be a function")}e=true}return e};et.prototype._updateExpandAllButton=async function(t){const e=await this._isExpandEnabled();const o=this._oToolbar!=null&&e;if(o&&(!this._oExpandAllButton||t)){if(this._oExpandAllButton){if(this._oToolbar&&this._oToolbar.getEnd().includes(this._oExpandAllButton)){this._oToolbar.removeEnd(this._oExpandAllButton)}this._oExpandAllButton.destroy();this._oExpandAllButton=null}this._oExpandAllButton=await this._createExpandButton()}if(!this._oExpandAllButton){return}if(this._oToolbar&&!this._oToolbar.getEnd().includes(this._oExpandAllButton)){this._oToolbar.insertEnd(this._oExpandAllButton,0)}this._oExpandAllButton.setEnabled(!f.isEmpty(this.getRowBinding()));this._oExpandAllButton.setVisible(e)};et.prototype._createExpandButton=async function(){const t=await this.getControlDelegate().fetchExpandAndCollapseConfiguration(this);return this._createExpandCollapseButton(true,{tree:t.expandAll,node:t.expandAllFromNode,isExpanded:t.isNodeExpanded})};et.prototype._createCollapseButton=async function(){const t=await this.getControlDelegate().fetchExpandAndCollapseConfiguration(this);return this._createExpandCollapseButton(false,{tree:t.collapseAll,node:t.collapseAllFromNode,isExpanded:t.isNodeExpanded})};et.prototype._createExpandCollapseButton=function(t,e){const{tree:i,node:n,isExpanded:s}=e;if(this.getSelectionMode()==="None"||typeof n!=="function"||typeof s!=="function"){return o.createExpandCollapseButton(this.getId(),t,()=>i(this))}const r=o.createExpandCollapseMenuButton(this.getId(),t,{tree:()=>i(this),node:()=>{const t=this.getSelectedContexts();return t.length===1&&n(this,t[0])}});r.attachBeforeMenuOpen(()=>{const e=this.getSelectedContexts();const o=e.length===1&&s(this,e[0])===!t;r.getMenu().getItems()[0].setEnabled(i!=undefined);r.getMenu().getItems()[1].setEnabled(o)});return r};et.prototype._getColumnLabel=function(t){const e=this.getPropertyHelper();const o=e.getProperty(t);return o&&o.label};et.prototype.triggerExport=function(){if(!this._isExportEnabled()){return Promise.reject("Export is not enabled for this table.")}return this._onExport()};et.prototype._onExport=function(t){const e=this;return this._createExportColumnConfiguration().then(o=>{if(!o||!o.length){const t=T.getResourceBundleFor("sap.ui.mdc").getText("table.NO_COLS_EXPORT");sap.ui.require(["sap/m/MessageBox"],function(e){e.error(t,{styleClass:this.$()&&this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""})}.bind(e));throw new Error(t)}const i=e.getRowBinding();const n=e._getColumnLabel.bind(e);const s=t?"exportAs":"export";const r={workbook:{columns:o,context:{title:e.getHeader()}},dataSource:i,fileName:e.getHeader()};return e._getExportHandler().then(t=>{t[s](r,n)})})};et.prototype._getExportHandler=function(){const t=this;if(this._oExportHandler){return Promise.resolve(this._oExportHandler)}return new Promise((e,o)=>{Promise.all([t.getControlDelegate().fetchExportCapabilities(t),T.load({name:"sap.ui.export"})]).then(o=>{const[i]=o;sap.ui.require(["sap/ui/export/ExportHandler"],o=>{t._oExportHandler=new o(i);t._oExportHandler.attachBeforeExport(t._onBeforeExport,t);e(t._oExportHandler)})}).catch(t=>{if(!T.all().hasOwnProperty("sap.ui.export")){y.error(T.getResourceBundleFor("sap.ui.mdc").getText("ERROR_MISSING_EXPORT_LIBRARY"))}o(t)})})};et.prototype._onBeforeExport=function(t){const e=t.getParameter("filterSettings");const o=this.getPropertyHelper();e.forEach(t=>{const e=o.getProperties().find(e=>e.path===t.getProperty());if(e){t.setLabel(e.label);t.setType(e.typeConfig.typeInstance)}});const i=this.fireBeforeExport({exportSettings:t.getParameter("exportSettings"),userExportSettings:t.getParameter("userExportSettings"),filterSettings:e});if(!i){t.preventDefault()}};et.prototype.onkeydown=function(t){if(t.isMarked()){return}if((t.metaKey||t.ctrlKey)&&t.shiftKey&&t.which===E.E){if(this._oExportButton&&this._oExportButton.getEnabled()&&this._isExportEnabled()){this._onExport(true);t.setMarked();t.preventDefault()}}if((t.metaKey||t.ctrlKey)&&t.which===E.COMMA){if(this._oP13nButton&&this._oP13nButton.getVisible()){this._oP13nButton.firePress();t.setMarked();t.preventDefault()}}};et.prototype._createTable=function(){const t=this._getType();this._oTable=t.createTable(this.getId()+"-innerTable");this._oRowTemplate=t.createRowTemplate(this.getId()+"-innerTableRow");t.updateTable();if(this.getNoData()){this.setNoData(this.getNoData())}if(this.getContextMenu()){this.setContextMenu(this.getContextMenu())}if(this.isFilteringEnabled()){rt(this)}if(!this._oColumnHeaderMenu){this._oQuickActionContainer=new V({table:this});this._oColumnHeaderMenu=new _({id:this.getId()+"-columnHeaderMenu",showTableSettingsButton:true});this._oColumnHeaderMenu.addAggregation("_quickActions",this._oQuickActionContainer);this.addDependent(this._oColumnHeaderMenu);k.setSemanticStepname(this._oColumnHeaderMenu,"beforeOpen","mdc:tbl:p13n:col");this._oColumnHeaderMenu.attachBeforeOpen(this._createColumnMenuContent,this)}this._updateInvisibleTitle()};et.prototype._createColumnMenuContent=function(t){const e=t.getParameter("openBy");const o=this.getColumns()[e.getParent().indexOfColumn(e)];t.preventDefault();this._oQuickActionContainer.setColumn(o);this._fullyInitialized().then(()=>this.finalizePropertyHelper()).then(()=>{this._oQuickActionContainer.initializeQuickActions();this._oColumnHeaderMenu.detachTableSettingsPressed(this._showTableP13nDialog,this);this._oColumnHeaderMenu.attachTableSettingsPressed(o,this._showTableP13nDialog,this);this._oColumnHeaderMenu.openBy(e,true);a.detectUserPersonalizationCompletion(this,this._oColumnHeaderMenu)})};et.prototype._showTableP13nDialog=function(t,e){a.openSettingsDialog(this,e)};et.prototype._updateColumnResize=function(){const t=this._getType();if(this.getEnableColumnResize()){t.enableColumnResize()}else{t.disableColumnResize()}};et.prototype._onColumnMove=function(t){a.createColumnReorderChange(this,{column:t.column,index:t.newIndex})};et.prototype._onRowPress=function(t){if(this.getSelectionMode()!==U.SingleMaster){this.fireRowPress({bindingContext:t.bindingContext})}};et.prototype._onSelectionChange=function(t){if(!this._bSelectionChangedByAPI){this.fireSelectionChange({selectAll:t.selectAll})}};et.prototype._onColumnResize=function(t){a.createColumnWidthChange(this,{column:t.column,width:t.width})};et.prototype._insertInnerColumn=function(t,e){if(!this._oTable){return}const o=t.getInnerColumn();this._setMobileColumnTemplate(t,e);this._bForceRebind=true;if(e===undefined){this._oTable.addColumn(o)}else{this._oTable.insertColumn(o,e)}this._getType()._onColumnInsert(t)};et.prototype.moveColumn=function(t,e){t._bIsBeingMoved=true;this.removeAggregation("columns",t,true);this.insertAggregation("columns",t,e,true);delete t._bIsBeingMoved;if(this._oTable){const o=t.getInnerColumn();this._oTable.removeColumn(o);this._oTable.insertColumn(o,e);this._updateMobileColumnTemplate(t,e)}};et.prototype.removeColumn=function(t){t=this.removeAggregation("columns",t,true);this._updateMobileColumnTemplate(t,-1);return t};et.prototype.addColumn=function(t){this.addAggregation("columns",t,true);this._insertInnerColumn(t);return this};et.prototype.insertColumn=function(t,e){this.insertAggregation("columns",t,e,true);this._insertInnerColumn(t,e);return this};et.prototype._setMobileColumnTemplate=function(t,e){if(!this._oRowTemplate){return}const o=t.getTemplateClone();if(e>=0){this._oRowTemplate.insertCell(o,e);this._oTable.getItems().forEach(t=>{if(t.isA("sap.m.GroupHeaderListItem")){return}t.insertAggregation("cells",new w,e,true)})}else{this._oRowTemplate.addCell(o)}};et.prototype._updateMobileColumnTemplate=function(t,e){if(!this._oRowTemplate){return}let o,i;if(this._oRowTemplate){o=t.getTemplateClone();i=this._oRowTemplate.indexOfCell(o);yt(this._oRowTemplate,i,e)}if(i>-1){this._oTable.getItems().forEach(t=>{if(t.removeCell){yt(t,i,e)}})}};function yt(t,e,o){const i=t.removeCell(e);if(i){if(o>-1){t.insertCell(i,o)}else{i.destroy()}}}et.prototype.getSelectedContexts=function(){if(this.isControlDelegateInitialized()){return this.getControlDelegate().getSelectedContexts(this)}return[]};et.prototype.clearSelection=function(){if(this.isControlDelegateInitialized()){this._bSelectionChangedByAPI=true;this.getControlDelegate().clearSelection(this);this._bSelectionChangedByAPI=false}};et.prototype._registerInnerFilter=function(t){t.attachSearch(this._rebind,this)};et.prototype.isTableBound=function(){return this._getType().isTableBound()};et.prototype._onDataRequested=function(){this._bIgnoreChange=true};et.prototype._onDataReceived=function(){this._bIgnoreChange=false;this._updateTableHeaderState()};et.prototype._onCreateActivate=function(){Promise.resolve().then(()=>{this._updateTableHeaderState()})};et.prototype._onBindingChange=function(){this.fireEvent("_bindingChange");this._updateExpandAllButton();this._updateCollapseAllButton();this._updateExportButton();if(this._bIgnoreChange){return}this._updateTableHeaderState()};et.prototype._updateTableHeaderState=function(){this._updateHeaderText()};et.prototype._updateHeaderText=function(){let t,e;if(!this._oNumberFormatInstance){this._oNumberFormatInstance=m.getFloatInstance()}if(this._oTitle&&this.getHeader()){t=this.getHeader();if(this.getShowRowCount()){e=this.getRowBinding()?this.getRowBinding().getCount():0;if(e>0){const o=this._oNumberFormatInstance.format(e);t+=" ("+o+")"}}this._oTitle.setText(t)}if(!this._bIgnoreChange&&this._bAnnounceTableUpdate){this._bAnnounceTableUpdate=false;f.announceTableUpdate(this.getHeader(),e)}};et.prototype._updateColumnsBeforeBinding=function(){const t=this.getColumns();const e=this.getPropertyHelper();t.forEach(function(t){const o=e.getProperty(t.getPropertyKey());const i=o?.getSortableProperties().map(t=>t.name)??[];const n=this._getSortedProperties().find(t=>i.includes(t.name));let s=Y.None;if(n){s=n.descending?Y.Descending:Y.Ascending}this._getType().updateSortIndicator(t,s)},this)};et.prototype.getRowBinding=function(){return this._getType().getRowBinding()};et.prototype._getRowBinding=function(){j.error(this+": The method '_getRowBinding' must not be used will be deleted soon. Use 'getRowBinding' instead.");return this.getRowBinding()};et._addBindingListener=function(t,e,o){if(!t.events){t.events={}}if(!t.events[e]){t.events[e]=o}else{const i=t.events[e];t.events[e]=function(){o.apply(this,arguments);i.apply(this,arguments)}}};et.prototype._rebind=async function(t=false){const e={};await this._fullyInitialized();this.getControlDelegate().updateBindingInfo(this,e);this._finalizeBindingInfo(e);this._oTable.setShowOverlay(false);this._updateColumnsBeforeBinding();this.getControlDelegate().updateBinding(this,e,this._bForceRebind?null:this.getRowBinding(),{forceRefresh:t});this._updateInnerTableNoData();this._bForceRebind=false};et.prototype._finalizeBindingInfo=function(t){if(this._oRowTemplate){t.template=this._oRowTemplate;t.templateShareable=true}else{delete t.template}et._addBindingListener(t,"dataRequested",this._onDataRequested.bind(this));et._addBindingListener(t,"dataReceived",this._onDataReceived.bind(this));et._addBindingListener(t,"createActivate",this._onCreateActivate.bind(this));et._addBindingListener(t,"change",this._onBindingChange.bind(this))};et.prototype._onPaste=function(t){if(this.getEnablePaste()){this.firePaste({data:t.data})}};et.prototype.exit=function(){this._onAfterInitialization("Destroyed");this._onAfterFullInitialization("Destroyed");["_oTable","_oTitle","_vNoData","_oContextMenu","_oNumberFormatInstance","_oTableReady","_oFullInitialize","_oPasteButton","_oP13nButton","_oRowTemplate","_oToolbar","_oFilterInfoBarInvisibleText","_oColumnHeaderMenu","_oManagedObjectModel","_oDefaultType","_oInvisibleTitle"].concat((()=>ot.map(t=>"_o"+I(t)))()).forEach(t=>{this[t]?.destroy?.();delete this[t]});t.prototype.exit.apply(this,arguments)};et.prototype.addAction=function(e){if(e.getMetadata().getName()!=="sap.ui.mdc.actiontoolbar.ActionToolbarAction"){e=new O(e.getId()+"-action",{action:e})}return t.prototype.addAggregation.apply(this,["actions",e])};et.prototype.onThemeChanged=function(){if(this._oExportButton){const t=g.ButtonType[L.get({name:"_sap_ui_mdc_Table_ExportButtonType"})];this._oExportButton.setType(t)}if(this._oToolbar){const t=q[L.get({name:"_sap_ui_mdc_Table_ToolbarDesign"})];this._oToolbar.setDesign(t)}if(!this.getHeaderStyle()){const t=$[L.get({name:"_sap_ui_mdc_Table_HeaderStyle"})];this._oTitle?.setTitleStyle(t);this.getVariant()?.setTitleStyle(t)}};et.prototype._setSelectedContexts=function(t){this.getControlDelegate().setSelectedContexts(this,t)};et.prototype._updateVariantManagementStyle=function(){const t=this.getVariant();if(t){t.setShowAsText(this.getHeaderVisible());t.setHeaderLevel(this.getHeaderLevel());t.setTitleStyle(this.getHeaderStyle()||$[L.get({name:"_sap_ui_mdc_Table_HeaderStyle"})])}};return et});
//# sourceMappingURL=Table.js.map