/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/Element","sap/ui/mdc/mixin/PromiseMixin","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/ValueHelpSelectionType","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/enums/ValueHelpPropagationReason","sap/ui/mdc/enums/RequestShowContainerReason","sap/ui/Device","sap/ui/mdc/enums/FieldDisplay"],(e,t,i,o,n,s,a,r,l,c,p)=>{"use strict";const u=e.extend("sap.ui.mdc.ValueHelp",{metadata:{library:"sap.ui.mdc",properties:{conditions:{type:"object[]",defaultValue:[],byValue:true},delegate:{type:"object",group:"Data",defaultValue:{name:"sap/ui/mdc/ValueHelpDelegate",payload:{}}},filterValue:{type:"string",defaultValue:""},validateInput:{type:"boolean",defaultValue:true},_config:{type:"object",defaultValue:{},visibility:"hidden"},_valid:{type:"boolean",group:"Appearance",defaultValue:true,visibility:"hidden"}},aggregations:{dialog:{type:"sap.ui.mdc.valuehelp.base.IDialogContainer",multiple:false},typeahead:{type:"sap.ui.mdc.valuehelp.base.ITypeaheadContainer",multiple:false}},events:{select:{parameters:{conditions:{type:"object[]"},add:{type:"boolean"},close:{type:"boolean"}}},disconnect:{},closed:{},open:{parameters:{container:{type:"sap.ui.mdc.valuehelp.base.Container"}}},opened:{parameters:{container:{type:"sap.ui.mdc.valuehelp.base.Container"},itemId:{type:"string"},items:{type:"int"}}},navigated:{parameters:{leaveFocus:{type:"boolean"},condition:{type:"object"},itemId:{type:"string"},caseSensitive:{type:"boolean"}}},switchToValueHelp:{},typeaheadSuggested:{parameters:{condition:{type:"object"},filterValue:{type:"string"},itemId:{type:"string"},items:{type:"int"},caseSensitive:{type:"boolean"}}},visualFocusSet:{}},defaultProperty:"filterValue"}});u.prototype.init=function(){e.prototype.init.apply(this,arguments);this._oObserver=new a(P.bind(this));this._oObserver.observe(this,{aggregations:["typeahead","dialog"]});this.setBindingContext(null);this._oConditions={}};u.prototype.exit=function(){delete this._oConditions;this._oObserver.disconnect();this._oObserver.destroy();delete this._oObserver;if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}};u.prototype.invalidate=function(e){return};u.prototype.connect=function(e,t){const i=this.getTypeahead();const o=this.getDialog();if(this._oControl&&this._oControl!==e){this.close(true);this.setFilterValue("");this.setConditions([]);if(i){i.onConnectionChange()}if(o){o.onConnectionChange()}this.fireDisconnect()}this._oControl=e;this.setProperty("_config",t,true);S.call(this);if(i){D.call(this,i,!!this._oControl)}if(o){D.call(this,o,!!this._oControl)}this._getControlDelegatePromise().then(i=>{i.onControlConnect(this,e,t)});return this};u.prototype.getControl=function(){return this._oControl};u.prototype.getDomRef=function(){const e=this.getTypeahead();const t=this.getDialog();if((e?.isOpen()||e?.isOpening())&&!e?.isClosing()){return e.getDomRef()}else if((t?.isOpen()||t?.isOpening())&&!t?.isClosing()){return t.getDomRef()}};u.prototype.getAriaAttributes=function(e){const t=this.getTypeahead();let i=this.getDialog();if(!i&&t&&t.getUseAsValueHelp()){i=t}const o=t&&t.isOpen();const n=i&&i.isOpen();const s=t&&t.getAriaAttributes(e);const a=i&&i.getAriaAttributes(e);let r;if(o){r=s.contentId}else if(n){r=a.contentId}const l=t&&s.ariaHasPopup||i&&a.ariaHasPopup;const c=t&&s.role||i&&a.role;const p=t&&s.roleDescription||i&&a.roleDescription;const u=!!i&&a.valueHelpEnabled;const h=t&&s.autocomplete||i&&a.autocomplete;return{contentId:r,ariaHasPopup:l,role:c,roleDescription:p,valueHelpEnabled:u,autocomplete:h}};u.prototype.retrieveDelegateContent=function(e,t){let i;if(!t){const i=e.getSelectedContent();t=i&&i.getId()}i=this._retrievePromise("delegateContent");const o=this.isOpen();if(!i||i&&o||i&&i.aggregation!==e.sParentAggregationName){const o=function(){return this._getControlDelegatePromise().then(i=>i.retrieveContent(this,e,t))}.bind(this);const n=i&&i.isPending();i=this._addPromise("delegateContent",n?i.getInternalPromise().then(o):o);i.aggregation=e.sParentAggregationName}return i.getInternalPromise()};u.prototype._getControlDelegatePromise=function(e){return this._retrievePromise("delegate",this.initControlDelegate.bind(this))};u.prototype.open=function(e){const t=e?this.getTypeahead():V.call(this);const i=e?this.getDialog():this.getTypeahead();if(i&&t!==i&&(i.isOpen()||i.isOpening())){i.close()}if(t&&!t.isOpen()&&!t.isOpening()){t.open(this.retrieveDelegateContent(t),e);this.fireOpen({container:t})}};function h(e){const t=e.getSource();this.retrieveDelegateContent(t,e.getParameter("contentId"))}function g(e){this.fireSwitchToValueHelp()}u.prototype.close=function(e){const t=this.getTypeahead();const i=this.getDialog();if(t&&t.isOpen()){t.close(e)}if(i&&i.isOpen()){i.close(e)}};u.prototype.toggleOpen=function(e){const t=this.getTypeahead();let i=this.getDialog();if(!e&&!i&&t&&t.getUseAsValueHelp()){i=t}const o=t&&t.isOpen();const n=i&&i.isOpen();if(e&&o||!e&&n){this.close()}else if(e&&t||!e&&i){this.open(e)}};u.prototype.isOpen=function(){const e=this.getTypeahead();const t=this.getDialog();const i=e?.isOpen()||e?.isOpening();const o=t?.isOpen()||t?.isOpening();return i||o};u.prototype.skipOpening=function(){const e=this.getTypeahead();const t=this.getDialog();if(e&&e.isOpening()){e.close()}if(t&&t.isOpening()){t.close()}};u.prototype.isTypeaheadSupported=function(){const e=this.getTypeahead();if(e){return this.retrieveDelegateContent(e).then(()=>!!e&&e.isTypeaheadSupported())}else{return Promise.resolve(false)}};u.prototype.requestShowTypeahead=async function(e){const t=this.getTypeahead();if(t){return await this._requestShowContainer(t,e)}return false};u.prototype.requestShowValueHelp=async function(){const e=V.call(this);if(e){return await this._requestShowContainer(e,l.ValueHelpRequest)}return false};u.prototype._requestShowContainer=async function(e,t){const i=await this._getControlDelegatePromise();return i.requestShowContainer(this,e,t)};u.prototype.shouldOpenOnFocus=function(){const e=V.call(this,true);return this._getControlDelegatePromise().then(t=>e?e.shouldOpenOnFocus():Promise.resolve(false))};u.prototype.shouldOpenOnClick=function(){const e=V.call(this,true);return this._getControlDelegatePromise().then(t=>e?e.shouldOpenOnClick():Promise.resolve(false))};u.prototype.isFocusInHelp=function(){const e=V.call(this);return e&&e.isFocusInHelp()};u.prototype.removeVisualFocus=function(){const e=this.getTypeahead();if(e){e.removeVisualFocus()}};u.prototype.setVisualFocus=function(){const e=this.getTypeahead();if(e){e.setVisualFocus()}};u.prototype.navigate=function(e){const t=this.getTypeahead();if(t){const t=()=>{const t=this.getTypeahead();return t?.navigate(e)};const i=this._retrievePromise("navigate");const o=i&&!i.isSettled()&&i.getInternalPromise();this._addPromise("navigate",o?o.then(t):t)}};u.prototype.isNavigationEnabled=function(e){const t=this.getTypeahead();if(t){const i=this.getDialog();const o=t.isOpen();if(o||!i){return t.isNavigationEnabled(e)}}return false};u.prototype.getItemForValue=function(e){const t=this.getTypeahead();if(t){return this.retrieveDelegateContent(t).then(()=>{e.caseSensitive=e.hasOwnProperty("caseSensitive")?e.caseSensitive:false;const i=t.getItemForValue(e);return i})}else{return Promise.reject("No Typeahead")}};u.prototype.isValidationSupported=function(){const e=this.getTypeahead();return e&&e.isValidationSupported()};u.prototype.onControlChange=function(){if(this.isDestroyed()){return}d.call(this,r.ControlChange);S.call(this)};u.prototype.getIcon=function(){const e=this.getTypeahead();const t=this.getDialog();if(t){return t.getValueHelpIcon()}else if(e){return e.getValueHelpIcon()}};u.prototype.getMaxConditions=function(){const e=this.getProperty("_config");return e&&e.maxConditions||-1};u.prototype.getDisplay=function(){return this.getProperty("_config")?.display||p.Value};u.prototype.getDataType=function(){};function d(e,t){const i=this.bDelegateInitialized&&this.getControlDelegate();if(i){i.onConditionPropagation(this,e,t||this.getProperty("_config"))}}function f(e){const t=e.getParameter("condition");this.fireNavigated({condition:t,itemId:e.getParameter("itemId"),leaveFocus:e.getParameter("leaveFocus"),caseSensitive:e.getParameter("caseSensitive")})}function y(e){this.fireVisualFocusSet()}function m(e){const t=e.getParameter("condition");const i=e.getParameter("filterValue");const o=e.getParameter("itemId");const n=e.getParameter("items");const s=e.getParameter("caseSensitive");this.fireTypeaheadSuggested({condition:t,filterValue:i,itemId:o,items:n,caseSensitive:s})}function C(e){const t=e.getParameter("type");const i=e.getParameter("conditions")||[];const o=this.getControlDelegate();const s=(e,t)=>t.findIndex(t=>o.compareConditions(this,e,t));let a;const r=this.getMaxConditions()===1;if(r){a=t===n.Remove?[]:i.slice(0,1)}if(t===n.Set){a=[].concat(r?i.slice(0,1):i)}if(t===n.Add){if(r){a=i.slice(0,1)}else{a=this.getConditions();for(let e=0;e<i.length;e++){if(s(i[e],a)===-1){a.push(i[e])}}}}if(t===n.Remove){if(r){a=[]}else{a=this.getConditions();for(let e=0;e<i.length;e++){const t=s(i[e],a);if(t!==-1){a.splice(t,1)}}}}if(a){this.setProperty("conditions",a,true)}}function v(e){if(this.getProperty("_valid")){const t=this.getMaxConditions()===1;const n=e.getParameter("close");const s=typeof n!=="undefined"?n:t;let a=this.getConditions();const l=!t&&!e.getSource().isMultiSelect();if(s){this.close()}a=i._removeEmptyConditions(a);a=i._removeInitialFlags(a);o.updateConditionsValues(a);this.fireSelect({conditions:a,add:l,close:s});d.call(this,r.Select)}}function b(e){this.close()}function O(e){this.fireOpened({container:e.getSource(),itemId:e.getParameter("itemId"),items:e.getParameter("items")})}function _(e){this._removePromise("delegateContent");this._removePromise("navigate");if(!this.isOpen()){this.fireClosed()}}function P(e){if(["typeahead","dialog"].indexOf(e.name)!==-1){const t=e.child;const i=e.mutation==="insert";if(this._oControl||!i){D.call(this,t,i)}if(i){if(!this._oManagedObjectModel){this._oManagedObjectModel=new s(this)}t.setModel(this._oManagedObjectModel,"$valueHelp")}}}function D(e,t){if(e._bAttached===t){return}const i=t?e.attachEvent.bind(e):e.detachEvent.bind(e);i("select",C,this);i("requestDelegateContent",h,this);i("confirm",v,this);i("cancel",b,this);i("opened",O,this);i("closed",_,this);if(e.attachRequestSwitchToDialog){i("requestSwitchToDialog",g,this)}if(e.attachNavigated){i("navigated",f,this)}if(e.attachVisualFocusSet){i("visualFocusSet",y,this)}if(e.attachTypeaheadSuggested){i("typeaheadSuggested",m,this)}e._bAttached=t}function S(){const e=this._oControl?this._oControl.getBindingContext():null;this.setBindingContext(e)}function V(e){const t=this.getTypeahead();const i=!!t&&t.getUseAsValueHelp();const o=this.getDialog();if(e){return(i||o||c.system.phone)&&t||o}else{return o||i&&t}}u.prototype._getFieldGroupIds=function(){const t=this.getControl();if(t){return t.getFieldGroupIds()}else{return e.prototype._getFieldGroupIds.apply(this,arguments)}};u.prototype.setHighlightId=function(e){this.getTypeahead()?.setHighlightId(e)};u.prototype.clone=function(t,i){const o=this.getTypeahead();const n=o?._bAttached;const s=this.getDialog();const a=s?._bAttached;if(n){D.call(this,o,false)}if(a){D.call(this,s,false)}const r=e.prototype.clone.apply(this,arguments);if(n){D.call(this,o,true)}if(a){D.call(this,s,true)}return r};t.call(u.prototype);return u});
//# sourceMappingURL=ValueHelp.js.map