/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/OverflowToolbarButton","sap/m/Button","sap/m/ButtonRenderer","sap/m/library","sap/m/IllustratedMessage","sap/ui/core/Lib","sap/ui/model/Filter","sap/ui/model/Sorter","sap/ui/model/json/JSONModel","sap/ui/Device","sap/ui/mdc/chart/SelectionButtonDisplay"],(e,t,o,i,s,n,r,a,p,l,c)=>{"use strict";const{PlacementType:d}=i;let h,u,g,m,y,f,b,v;const S=e.extend("sap.ui.mdc.chart.SelectionButton",{metadata:{library:"sap.ui.mdc",properties:{display:{type:"sap.ui.mdc.enums.SelectionButtonDisplay",defaultValue:c.Icon},canOverflow:{type:"boolean",defaultValue:true},selectedItemKey:{type:"string"},title:{type:"string"},searchPlaceholder:{type:"string"},searchEnabled:{type:"boolean"},sortEnabled:{type:"boolean",defaultValue:false},sorted:{type:"string",defaultValue:"none"},noDataTitle:{type:"string"},noDataDescription:{type:"string"},noDataType:{type:"string"}},aggregations:{items:{type:"sap.ui.mdc.chart.SelectionButtonItem",multiple:true}},associations:{},events:{itemSelected:{parameters:{item:{type:"sap.ui.mdc.chart.SelectionButtonItem"}}},beforeOpen:{}}},renderer:o});S.prototype.init=function(){e.prototype.init.apply(this,arguments);this.attachPress(this.openPopover.bind(this))};S.prototype.setSearchEnabled=function(e){this.setProperty("searchEnabled",e);this._updateHeader();return this};S.prototype.setSortEnabled=function(e){this.setProperty("sortEnabled",e);this._updateHeader();return this};S.prototype.openPopover=function(e){if(!this.oReadyPromise){this.oReadyPromise=new Promise(e=>{if(h){e(true)}else{sap.ui.require(["sap/m/ResponsivePopover","sap/m/List","sap/m/SearchField","sap/m/ToggleButton","sap/m/Bar","sap/m/StandardListItem","sap/ui/core/InvisibleText"],(t,o,i,s,r,a,p)=>{h=t;u=o;g=i;m=s;y=r;f=a;b=p;if(!v){n.load({name:"sap.ui.mdc"}).then(()=>{v=n.getResourceBundleFor("sap.ui.mdc");e(true)})}else{e(true)}})}})}this.oReadyPromise.then(()=>{if(!this.oPopover||!this.oPopover?.isOpen()){this.fireBeforeOpen();if(this.getItems().length===0){return}this._openPopover()}else if(this.oPopover?.isOpen()){this.oPopover.close()}})};S.prototype._openPopover=function(){if(!this.oPopover){this.oPopover=this._createPopover();this.oPopover.attachAfterOpen(function(){const e=this.oPopover.getContent()[1];const t=e.getItems().filter(e=>e.getSelected())[0];t?.focus()}.bind(this))}this._createModel();this.oPopover.openBy(this)};S.prototype._createPopover=function(){const e=new f({title:"{$items>text}",icon:"{$items>icon}",selected:"{$items>selected}"});let t=null;if(this.getSorted()!=="none"){t=new a({path:"text",descending:this.getSorted()==="descending"})}const o=new u({mode:"SingleSelectMaster",noData:new s({title:this.getNoDataTitle(),description:this.getNoDataDescription(),illustrationType:this.getNoDataType()}),items:{path:"$items>/AvailableItems",sorter:t,template:e,templateShareable:false},selectionChange:function(e){if(e&&e.mParameters&&e.mParameters.listItem){const t=e.mParameters.listItem.getBinding("title");if(t){const e=t.getContext();if(e){const t=e.getObject();if(t&&t.key){this.fireItemSelected({item:t});this.setSelectedItemKey(t.key)}}}}r.close()}.bind(this)});const i=new g({placeholder:this.getSearchPlaceholder(),liveChange:function(e){this._triggerSearch(e,o)}.bind(this)});const n=new m({icon:"sap-icon://sort",press:function(e){this._triggerSort(e,o)}.bind(this)});const r=new h({id:this.getId()+"-btnSelectionButtonPopover",placement:d.VerticalPreferredBottom,contentWidth:"25rem"});r.addStyleClass("sapUiMDCSelectionButton");const p=new y({contentMiddle:[i,n]});if(!l.system.phone){r.setSubHeader(p)}else{r.addContent(p)}if(l.system.desktop){const e=new b({text:this.getTitle()});r.setShowHeader(false);r.addContent(e);r.addAriaLabelledBy(e)}else{r.setTitle(this.getTitle())}r.addContent(o);this._updateHeader(r);return r};S.prototype._updateHeader=function(e){e=e||this.oPopover;let t=e?.getSubHeader();if(!t&&l.system.phone){t=e?.getContent()}if(!t){return}const[o,i]=t.getContentMiddle();o.setVisible(this.getSearchEnabled());o.setValue("");i.setVisible(this.getSortEnabled());t.setVisible(this.getSearchEnabled()||this.getSortEnabled())};S.prototype._createModel=function(){const e=new p;e.setSizeLimit(1e3);const t=this.getItems()||[];const o=this.getSelectedItemKey()||"";const i=[];t.forEach(e=>{i.push({key:e.getKey(),text:e.getText(),tooltip:e.getTooltip()||e.getText(),icon:e.getIcon(),selected:e.getKey()===o})});e.setProperty("/AvailableItems",i);this.oPopover.setModel(e,"$items")};S.prototype._triggerSearch=function(e,t){const o=e.getParameter("newValue");let i=[];if(o){i=new r("text","Contains",o)}t.getBinding("items").filter(i)};S.prototype._triggerSort=function(e,t){this._updateSort(t,e.getSource().getPressed())};S.prototype._updateSort=function(e,t){const o=new a({path:"text",descending:t});const i=e.getBinding("items");if(i){i.sort(o);return}};S.prototype.exit=function(){e.prototype.exit.apply(this,arguments);if(this.oPopover){this.oPopover.destroy();this.oPopover=null}if(this._oObserver){this._oObserver.disconnect();this._oObserver.destroy();delete this._oObserver}};S.prototype._getAppliedIcon=function(){if(this._bInOverflow||this.getDisplay()===c.Icon||this.getDisplay()===c.Both){return this.getIcon()||this._sTypeIconURI}return undefined};S.prototype._getText=function(){if(this._bInOverflow||this.getDisplay()===c.Text||this.getDisplay()===c.Both){return t.prototype._getText.call(this)}return""};S.prototype.getOverflowToolbarConfig=function(){const t=e.prototype.getOverflowToolbarConfig.apply(this);t.canOverflow=this.getCanOverflow();return t};return S});
//# sourceMappingURL=SelectionButton.js.map