/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/mdc/condition/ConditionModelPropertyBinding","sap/ui/model/json/JSONModel","sap/ui/model/ChangeReason","sap/ui/mdc/condition/FilterOperatorUtil","sap/base/util/merge","sap/base/Log","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/FilterConverter","sap/ui/core/date/UI5Date"],(t,e,i,n,o,s,r,d,c)=>{"use strict";const h=e.extend("sap.ui.mdc.condition.ConditionModel",{constructor:function(){e.apply(this,arguments);this.setSizeLimit(1e3);if(!this.getProperty("/conditions")){this.setProperty("/conditions",{})}if(!this.getProperty("/fieldPath")){this.setProperty("/fieldPath",{})}}});h.prototype.bindProperty=function(e,i,n){let o=e;if(e.startsWith("/conditions/")){let t=e.slice(12);this._getFieldPathProperty(t);t=l.call(this,t);o="/conditions/"+t}const s=new t(this,o,i,n);s._sOriginapPath=e;return s};h.prototype.getContext=function(t){if(t.startsWith("/conditions/")){let e=t.slice(12);e=l.call(this,e);t="/conditions/"+e}return e.prototype.getContext.apply(this,[t])};h.prototype.bindList=function(t,i,n,o,s){const r=e.prototype.bindList.apply(this,arguments);r.enableExtendedChangeDetection(true);return r};h.prototype.destroy=function(){e.prototype.destroy.apply(this,arguments)};h.prototype.clone=function(t){const e=new h;e._sName=this._sName+"_clone";let i={};if(typeof t==="string"){const e=this.getConditions(t);for(const n of e){const e=l.call(this,t);if(!i[e]){i[e]=[]}i[e].push(o({},n))}}else{i=o({},this.getAllConditions())}e.setConditions(i);return e};h.prototype.merge=function(t,e,i){this.removeAllConditions(t);const n=o({},e.getAllConditions());for(const t in n){if(!(typeof i==="string")||t===i){const e=r._removeEmptyConditions(n[t]);for(const i of e){this.addCondition(t,i)}}}this.checkUpdate(true,true)};h.prototype.getConditions=function(t){return p.call(this,t)};function p(t,e){const i=this.getProperty("/conditions");let n;if(typeof t=="string"){t=l.call(this,t);if(!i[t]&&e){i[t]=[]}n=i[t]||[]}else{throw new Error("ConditionModel","getConditions without FieldPath is not supported!")}return n}h.prototype.getAllConditions=function(t){const e=this.getProperty("/conditions");const i={};for(const n in e){const s=this.getProperty("/fieldPath");const r=s[n];const d=r?r.fieldPath:n;if(t&&[].concat(t).indexOf(d)===-1){continue}i[d]=o([],e[n])}return i};h.prototype.indexOf=function(t,e,i){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}const o=this.getConditions(t);const s=i?[i(e),o.map(i)]:[e,o];const r=n.indexOfCondition(...s);return r};h.prototype.exist=function(t,e){if(typeof e==="string"){return this.indexOf(e,t)>=0}else{throw new Error("sFieldPath must be provided "+this)}};h.prototype.setConditions=function(t){let e=0;let s;if(Array.isArray(t)){throw new Error("setConditions with an Array of condition is not supported! "+this)}else{this._bNoSingleEvent=true;let r=false;let d;let c;const h=o({},this.getProperty("/conditions"));for(d in t){this._getFieldPathProperty(d);c=l.call(this,d);const o=h[c]||[];const p=t[d]||[];if(!n.compareConditionsArray(o,p)){r=true;this.removeAllConditions(d);for(e=0;e<t[d].length;e++){s=t[d][e];this.insertCondition(d,-1,s,true)}this.firePropertyChange({reason:i.Binding,path:"/conditions/"+d,context:undefined,value:t[d]})}delete h[c]}const p=this.getProperty("/fieldPath");for(c in h){if(h[c].length>0){r=true;d=p[c].fieldPath;this.removeAllConditions(d);this.firePropertyChange({reason:i.Binding,path:"/conditions/"+d,context:undefined,value:[]})}}if(r){this.checkUpdate(false,true)}this._bNoSingleEvent=false}return this};h.prototype.addCondition=function(t,e,i){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}return this.insertCondition(t,-1,e,i)};h.prototype.insertCondition=function(t,e,o,s){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}if(!o){return this}n.checkConditionsEmpty(o);n.updateConditionsValues(o);this._getFieldPathProperty(t);if(!s){const e=this.indexOf(t,o);if(e>=0){return this}}const r=p.call(this,t,true);if(e==-1){r.push(o)}else{r.splice(e,0,o)}if(!this._bNoSingleEvent){this.checkUpdate(false,true);this.firePropertyChange({reason:i.Binding,path:"/conditions/"+t,context:undefined,value:r})}return this};h.prototype.createItemCondition=function(t,e,i){s.error("ConditionModel","createItemCondition is deprecated");return r.createItemCondition(e,i)};h.prototype.createCondition=function(t,e,i){s.error("ConditionModel","createCondition is deprecated");return r.createCondition(e,i)};h.prototype.removeCondition=function(t,e){if(typeof t!=="string"){throw new Error("sFieldPath must be a string "+this)}let n=-1;if(typeof e==="object"){n=this.indexOf(t,e)}else if(typeof e==="number"){n=e}if(n>=0){const e=this.getConditions(t);if(e.length>n){e.splice(n,1);this.checkUpdate(false,true);this.firePropertyChange({reason:i.Binding,path:"/conditions/"+t,context:undefined,value:e});return true}}return false};h.prototype.removeAllConditions=function(t){const e=this.getProperty("/conditions");if(typeof t==="string"){const n=l.call(this,t);if(e[n]&&e[n].length>0){e[n]=[];if(!this._bNoSingleEvent){this.firePropertyChange({reason:i.Binding,path:"/conditions/"+t,context:undefined,value:e[n]})}}}else{for(const t in e){if(e[t]&&e[t].length>0){e[t]=[];if(!this._bNoSingleEvent){const n=this.getProperty("/fieldPath");const o=n[t].fieldPath;this.firePropertyChange({reason:i.Binding,path:"/conditions/"+o,context:undefined,value:e[t]})}}}}if(!this._bNoSingleEvent){this.checkUpdate(false,true)}return this};h.prototype._getFieldPathProperty=function(t){const e=l.call(this,t);const i=this.getProperty("/fieldPath");if(!i[e]){i[e]={fieldPath:t}}const n=this.getProperty("/conditions");if(!n[e]){n[e]=[]}return i[e]};h.prototype.getFilters=function(t){s.error("ConditionModel","usage or deprecated getFilters() function! Please use the FilterConverter.createFilters() function instead.");return d.createFilters(this.getAllConditions(),{})};h.prototype.serialize=function(){const t=o({},this.getAllConditions());for(const e in t){const i=t[e];i.forEach(t=>{delete t.isEmpty},this);if(i.length===0){delete t[e]}}return'{"conditions":'+JSON.stringify(t)+"}"};h.prototype.parse=function(t){const e=function(t,e){let i;if(!isNaN(parseInt(t))&&typeof e==="string"){i=/^(\d{4})-(\d{2})-(\d{2})T(\d{2}):(\d{2}):(\d{2}).(\d{3})Z$/.exec(e);if(i){return c.getInstance(e)}}return e};this.setConditions(JSON.parse(t,e).conditions)};function l(t){if(t){const e=t.split("/");if(e.length>1){t="";e.forEach((i,n)=>{if(n>0){if(!isNaN(i)||!isNaN(e[n-1])){t=t+"/"}else{t=t+"\\"}}t=t+i})}}return t}return h});
//# sourceMappingURL=ConditionModel.js.map