/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/model/FilterOperator","sap/ui/model/Filter","sap/ui/model/ValidateException","sap/base/Log","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","./Operator","./RangeOperator","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/loadModules","sap/ui/core/date/UniversalDate","sap/ui/core/date/UniversalDateUtils","sap/ui/core/date/UI5Date","sap/ui/core/format/DateFormat","sap/ui/core/StaticArea","sap/ui/model/json/JSONModel","sap/ui/model/type/Integer","sap/ui/model/BindingMode","sap/base/i18n/Localization"],(e,t,n,a,r,o,s,u,i,l,T,p,m,c,d,f,g,_,O,E,A,D)=>{"use strict";let y=e.getResourceBundleFor("sap.ui.mdc");let I=e.getResourceBundleFor("sap.m");D.attachChange(()=>{y=e.getResourceBundleFor("sap.ui.mdc");I=e.getResourceBundleFor("sap.m")});const x={_mOperators:{equal:new u({name:s.EQ,alias:{Date:"DATE",DateTime:"DATETIME"},filterOperator:t.EQ,tokenTest:"^=(.+)?$",tokenParse:"^=?(.+)?$",tokenFormat:"{1} ({0})",longText:k(s.EQ,true),valueTypes:[p.Self,null],displayFormats:{DescriptionValue:"{1} ({0})",ValueDescription:"{0} ({1})",Description:"{1}",Value:"{0}"},format:function(e,t,n,a,r,s,u){n=n||o.DescriptionValue;let i=this.valueTypes.length;const l=e.values;const p=e&&e.validated===T.Validated||l.length===2||a?"":"=";let m=p+this.displayFormats[n];if(!l[1]){m=p+this.displayFormats["Value"];i=1}for(let e=0;e<i;e++){let n,a=l[e];if(a===null||a===undefined){a=""}if(e===0){n=this._formatValue(a,t,r)}else{n=this._formatValue(a,s,u)}if(n===null){m=null;break}if(typeof n==="string"){n=n.replace(/\$/g,"$$$")}m=m.replace(new RegExp("\\$"+e+"|"+e+"\\$"+"|"+"\\{"+e+"\\}","g"),n)}return m},parse:function(e,t,n,a,r,s,i,l){n=n||o.DescriptionValue;let T=u.prototype.parse.apply(this,[e,t,n,a,r,s,i,l]);if(a&&(!T||T[0]===null||T[0]===undefined)&&n!==o.Value){n=o.Value;T=u.prototype.parse.apply(this,[e,t,n,a,r,s,i,l])}if(T&&(T[1]===null||T[1]===undefined)&&n===o.Value){T=[T[0]]}return T},getValues:function(e,t,n,a){const r=a?this.hiddenOperatorRegExp:this.tokenParseRegExp;const o=e.match(r);let s;if(o&&o.length>1&&o[1]!==undefined){const e=o[1];const n=this.displayFormats[t];const a=n.indexOf("{0}");const r=n.indexOf("{1}");let u;let i;if(a>=0&&r>=0){const t=a<r;let o=t?n.substring(a+3,r):n.substring(r+3,a);const s=t?n.slice(r+3):n.slice(a+3);let l=t?e.indexOf(o):e.lastIndexOf(o);if(l===-1){o="(";l=t?e.indexOf(o):e.lastIndexOf(o)}if(l>0&&(e.lastIndexOf(s)===e.length-s.length||e.lastIndexOf(s)<l)){let n=e.length;if(e.slice(n-s.length)===s){n=n-s.length}const a=e.substring(0,l);const r=e.substring(l+o.length,n);if(t){u=a;i=r}else{u=r;i=a}}else if(t){u=e}else{i=e}}else if(a>=0){u=e}else{i=e}s=[u];if(r>=0){s.push(i)}}return s},isEmpty:function(e,t){let n=false;const a=e.values[0];if((a===null||a===undefined||a==="")&&!e.values[1]){n=true}return n},getCheckValue:function(e){return{value:e.values[0]}},checkValidated:function(e){if(e.values.length===2&&e.values[0]!==undefined&&e.values[1]!==null&&e.values[1]!==undefined){e.validated=T.Validated}else{e.validated=T.NotValidated}},validateInput:true,getTextForCopy:function(e,t,n,a,r,o,s){if(e.validated!==T.Validated){return u.prototype.getTextForCopy.apply(this,arguments)}else{const[n,a]=e.values;const u=this._formatValue(n,t,r);const i=a===undefined?"":this._formatValue(a,o,s);return u+"\t"+i}}}),between:new u({name:s.BT,alias:{Date:"DATERANGE",DateTime:"DATETIMERANGE"},filterOperator:t.BT,tokenTest:"^([^!].*)\\.\\.\\.(.+)$",tokenParse:"^(.*)\\.\\.\\.(.*)$|^(.+)$",tokenFormat:"{0}...{1}",longText:k(s.BT,true),valueTypes:[p.Self,p.Self],validate:function(e,t){if(e.length===2){if(h(e[0])&&h(e[1])){return}else if(h(e[0])||h(e[1])){throw new a(y.getText("operator.between.validate.missingValue"))}else if(e[0]===e[1]){throw new a(y.getText("operator.between.validate.sameValues"))}}u.prototype.validate.apply(this,[e,t])}}),notBetween:new u({name:s.NOTBT,filterOperator:t.NB,tokenTest:["^!\\((.+)\\.\\.\\.(.+)\\)$","^!(.+)\\.\\.\\.(.+)$"].join("|"),tokenParse:["^!\\((.*)\\.\\.\\.(.*)\\)$","^!(.*)\\.\\.\\.(.*)$","^(.+)$"].join("|"),tokenFormat:"!({0}...{1})",longText:k(s.NOTBT,true),valueTypes:[p.Self,p.Self],exclude:true,validate:function(e,t){x._mOperators.between.validate(e,t)}}),lessThan:new u({name:s.LT,filterOperator:t.LT,tokenTest:"^<([^=].*)?$",tokenParse:"^<?(.+)?$",tokenFormat:"<{0}",longText:k(s.LT,true),longTextForTypes:C(s.LT,[l.Date]),valueTypes:[p.Self]}),notLessThan:new u({name:s.NOTLT,filterOperator:t.GE,tokenTest:["^!\\(<([^=].*)?\\)$","^!<([^=].*)?$"].join("|"),tokenParse:["^!\\(<?(.+)?\\)$","^(!<)?(.+)?$"].join("|"),tokenFormat:"!(<{0})",longText:k(s.NOTLT,true),longTextForTypes:C(s.NOTLT,[l.Date]),valueTypes:[p.Self],exclude:true}),greaterThan:new u({name:s.GT,filterOperator:t.GT,tokenTest:"^>([^=].*)?$",tokenParse:"^>?(.+)?$",tokenFormat:">{0}",longText:k(s.GT,true),longTextForTypes:C(s.GT,[l.Date]),valueTypes:[p.Self]}),notGreaterThan:new u({name:s.NOTGT,filterOperator:t.LE,tokenTest:["^!\\(>([^=].*)?\\)$","^!>([^=].*)?$"].join("|"),tokenParse:["^!\\(>(.+)?\\)$","^(!>)?(.+)?$"].join("|"),tokenFormat:"!(>{0})",longText:k(s.NOTGT,true),longTextForTypes:C(s.NOTGT,[l.Date]),valueTypes:[p.Self],exclude:true}),lessEqual:new u({name:s.LE,alias:{Date:"TO",DateTime:"TODATETIME"},filterOperator:t.LE,tokenTest:"^<=(.+)?$",tokenParse:"^(<=)?(.+)?$",tokenFormat:"<={0}",longText:k(s.LE,true),longTextForTypes:C(s.LE,[l.Date]),valueTypes:[p.Self]}),notLessEqual:new u({name:s.NOTLE,filterOperator:t.GT,tokenTest:["^!\\(<=(.+)?\\)$","^!<=(.+)?$"].join("|"),tokenParse:["^!\\(<=(.+)?\\)$","^(!<=)?(.+)?$"].join("|"),tokenFormat:"!(<={0})",longText:k(s.NOTLE,true),longTextForTypes:C(s.NOTLE,[l.Date]),valueTypes:[p.Self],exclude:true}),greaterEqual:new u({name:s.GE,alias:{Date:"FROM",DateTime:"FROMDATETIME"},filterOperator:t.GE,tokenTest:"^>=(.+)?$",tokenParse:"^(>=)?(.+)?$",tokenFormat:">={0}",longText:k(s.GE,true),longTextForTypes:C(s.GE,[l.Date]),valueTypes:[p.Self]}),notGreaterEqual:new u({name:s.NOTGE,filterOperator:t.LT,tokenTest:["^!\\(>=(.+)?\\)$","^!>=(.+)?$"].join("|"),tokenParse:["^!\\(>=(.+)?\\)$","^(!>=)?(.+)?$"].join("|"),tokenFormat:"!(>={0})",longText:k(s.NOTGE,true),longTextForTypes:C(s.NOTGE,[l.Date]),valueTypes:[p.Self],exclude:true}),startsWith:new u({name:s.StartsWith,filterOperator:t.StartsWith,tokenTest:"^([^!\\*]+.*)\\*$",tokenParse:"^(.+)\\*$|^(.*[^\\*])$",tokenFormat:"{0}*",longText:k(s.StartsWith,true),valueTypes:[p.SelfNoParse]}),notStartsWith:new u({name:s.NotStartsWith,filterOperator:t.NotStartsWith,tokenTest:["^!\\(([^\\*].*)\\*\\)$","^!([^\\*].*)\\*$"].join("|"),tokenParse:["^!\\((.+)\\*\\)$","^!?(.+)\\*$","^(.*[^\\*])$"].join("|"),tokenFormat:"!({0}*)",longText:k(s.NotStartsWith,true),valueTypes:[p.SelfNoParse],exclude:true}),endsWith:new u({name:s.EndsWith,filterOperator:t.EndsWith,tokenTest:"^\\*(.*[^\\*])$",tokenParse:"^\\*?(.+)?$",tokenFormat:"*{0}",longText:k(s.EndsWith,true),valueTypes:[p.SelfNoParse]}),notEndsWith:new u({name:s.NotEndsWith,filterOperator:t.NotEndsWith,tokenTest:["^!\\(\\*(.*[^\\*])\\)$","^!\\*(.*[^\\*])$"].join("|"),tokenParse:["^!\\(\\*(.+)?\\)$","^(!\\*)?(.+)?$"].join("|"),tokenFormat:"!(*{0})",longText:k(s.NotEndsWith,true),valueTypes:[p.SelfNoParse],exclude:true}),contains:new u({name:s.Contains,filterOperator:t.Contains,tokenTest:"^\\*(.*)\\*$",tokenParse:"^\\*(.+)?\\*$|^([^\\*]?.*[^\\*]?)$",tokenFormat:"*{0}*",longText:k(s.Contains,true),valueTypes:[p.SelfNoParse]}),notContains:new u({name:s.NotContains,filterOperator:t.NotContains,tokenTest:["^!\\(\\*(.*)\\*\\)$","^!\\*(.*)\\*$"].join("|"),tokenParse:["^!\\(\\*(.+)?\\*\\)$","^!\\*(.+)?\\*$","^!?(.+)$"].join("|"),tokenFormat:"!(*{0}*)",longText:k(s.NotContains,true),valueTypes:[p.SelfNoParse],exclude:true}),notEqual:new u({name:s.NE,filterOperator:t.NE,tokenTest:["^!\\(=(.+)?\\)$","^!=(.+)?$"].join("|"),tokenParse:["^!\\(=(.+)?\\)$","^(!=)?(.+)?$"].join("|"),tokenFormat:"!(={0})",longText:k(s.NE,true),valueTypes:[p.Self],exclude:true}),empty:new u({name:s.Empty,filterOperator:t.EQ,tokenParse:"^<#tokenText#>$",tokenFormat:"<#tokenText#>",longText:k(s.Empty,true),tokenText:k(s.Empty,false),valueTypes:[],getModelFilter:function(e,a,r,o,s){const u=L(a);if(u){return new n({path:u.navPath,operator:t.All,variable:"L1",condition:new n({filters:[new n({path:"L1/"+u.propertyPath,operator:t.EQ,value1:null}),new n({path:"L1/"+u.propertyPath,operator:t.NE,value1:null})],and:true})})}else if(s===l.String){let e=false;if(r){const t=r.parseValue("","string");try{r.validateValue(t);e=t===null}catch(t){e=false}}if(e){return new n({filters:[new n({path:a,operator:t.EQ,value1:""}),new n({path:a,operator:t.EQ,value1:null})],and:false})}else{return new n({path:a,operator:this.filterOperator,value1:""})}}else{return new n({path:a,operator:this.filterOperator,value1:null})}}}),notEmpty:new u({name:s.NotEmpty,filterOperator:t.NE,tokenParse:["^!\\(<#tokenText#>\\)$","^!<#tokenText#>$"].join("|"),tokenFormat:"!(<#tokenText#>)",longText:k(s.NotEmpty,true),tokenText:k(s.NotEmpty,false),valueTypes:[],exclude:true,getModelFilter:function(e,a,r,o,s){const u=L(a);if(u){return new n({path:u.navPath,operator:t.Any})}else if(s===l.String){let e=false;if(r){const t=r.parseValue("","string");try{r.validateValue(t);e=t===null}catch(t){e=false}}if(e){return new n({filters:[new n({path:a,operator:t.NE,value1:""}),new n({path:a,operator:t.NE,value1:null})],and:true})}else{return new n({path:a,operator:this.filterOperator,value1:""})}}else{return new n({path:a,operator:this.filterOperator,value1:null})}}}),yesterday:new i({name:s.YESTERDAY,longText:I.getText("DYNAMIC_DATE_YESTERDAY_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_YESTERDAY_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.yesterday()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),today:new i({name:s.TODAY,longText:I.getText("DYNAMIC_DATE_TODAY_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_TODAY_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.today()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),tomorrow:new i({name:s.TOMORROW,longText:I.getText("DYNAMIC_DATE_TOMORROW_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_TOMORROW_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.tomorrow()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDays:new i({name:s.LASTDAYS,tokenText:I.getText("DYNAMIC_DATE_LASTDAYS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastDays(e)}}),firstDayWeek:new i({name:s.FIRSTDAYWEEK,longText:I.getText("DYNAMIC_DATE_FIRSTDAYWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_FIRSTDAYWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.firstDayOfWeek()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayWeek:new i({name:s.LASTDAYWEEK,longText:I.getText("DYNAMIC_DATE_LASTDAYWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTDAYWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastDayOfWeek()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayMonth:new i({name:s.FIRSTDAYMONTH,longText:I.getText("DYNAMIC_DATE_FIRSTDAYMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_FIRSTDAYMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.firstDayOfMonth()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayMonth:new i({name:s.LASTDAYMONTH,longText:I.getText("DYNAMIC_DATE_LASTDAYMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTDAYMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastDayOfMonth()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayQuarter:new i({name:s.FIRSTDAYQUARTER,longText:I.getText("DYNAMIC_DATE_FIRSTDAYQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_FIRSTDAYQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.firstDayOfQuarter()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayQuarter:new i({name:s.LASTDAYQUARTER,longText:I.getText("DYNAMIC_DATE_LASTDAYQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTDAYQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastDayOfQuarter()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),firstDayYear:new i({name:s.FIRSTDAYYEAR,longText:I.getText("DYNAMIC_DATE_FIRSTDAYYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_FIRSTDAYYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.firstDayOfYear()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),lastDayYear:new i({name:s.LASTDAYYEAR,longText:I.getText("DYNAMIC_DATE_LASTDAYYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTDAYYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastDayOfYear()},formatRange:function(e,t){return t.formatValue(e[0],"string")}}),todayFromTo:new i({name:s.TODAYFROMTO,longText:I.getText("DYNAMIC_DATE_TODAYFROMTO_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_TODAYFROMTO_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}},{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null}}],paramTypes:["([-+]?\\d+)","([-+]?\\d+)"],additionalInfo:"",format:function(e,t,n,a,r,o,s,u){let i=u||this.tokenFormat;const l=(e.values[0]||0)*-1;const T=e.values[1]||0;let p=l<0?"":"+";p=p+this._formatValue(l,this._createLocalType(this.valueTypes[0],t));let m=T<0?"":"+";m=m+this._formatValue(T,this._createLocalType(this.valueTypes[1],t));if(l<=T){i=i.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),p);i=i.replace(new RegExp("\\$"+1+"|"+1+"\\$"+"|"+"\\{"+1+"\\}","g"),m)}else{i=i.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),m);i=i.replace(new RegExp("\\$"+1+"|"+1+"\\$"+"|"+"\\{"+1+"\\}","g"),p)}return i},parse:function(e,t,n,a,r,o,s,u){const i=this.getValues(e,n,a,u);let l=this._parseValue(i[0],this._createLocalType(this.valueTypes[0],t));let T=this._parseValue(i[1],this._createLocalType(this.valueTypes[1],t));if(l>T){const e=l;l=T;T=e}l=l*-1;return[l,T]},calcRange:function(e,t){let n=e>=0?d.ranges.lastDays(e)[0]:d.ranges.nextDays(-e)[1];let a=t>=0?d.ranges.nextDays(t)[1]:d.ranges.lastDays(-t)[0];if(n.oDate.getTime()>a.oDate.getTime()){a=[n,n=a][0]}return[d.resetStartTime(n),d.resetEndTime(a)]}}),nextDays:new i({name:s.NEXTDAYS,tokenText:I.getText("DYNAMIC_DATE_NEXTDAYS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextDays(e)}}),lastWeek:new i({name:s.LASTWEEK,longText:I.getText("DYNAMIC_DATE_LASTWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastWeek()}}),thisWeek:new i({name:s.THISWEEK,longText:I.getText("DYNAMIC_DATE_THISWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_THISWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.currentWeek()}}),nextWeek:new i({name:s.NEXTWEEK,longText:I.getText("DYNAMIC_DATE_NEXTWEEK_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_NEXTWEEK_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.nextWeek()}}),lastWeeks:new i({name:s.LASTWEEKS,tokenText:I.getText("DYNAMIC_DATE_LASTWEEKS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastWeeks(e)}}),nextWeeks:new i({name:s.NEXTWEEKS,tokenText:I.getText("DYNAMIC_DATE_NEXTWEEKS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextWeeks(e)}}),lastMonth:new i({name:s.LASTMONTH,longText:I.getText("DYNAMIC_DATE_LASTMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastMonth()}}),thisMonth:new i({name:s.THISMONTH,longText:I.getText("DYNAMIC_DATE_THISMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_THISMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.currentMonth()}}),nextMonth:new i({name:s.NEXTMONTH,longText:I.getText("DYNAMIC_DATE_NEXTMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_NEXTMONTH_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.nextMonth()}}),lastMonths:new i({name:s.LASTMONTHS,tokenText:I.getText("DYNAMIC_DATE_LASTMONTHS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastMonths(e)}}),nextMonths:new i({name:s.NEXTMONTHS,tokenText:I.getText("DYNAMIC_DATE_NEXTMONTHS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextMonths(e)}}),lastQuarter:new i({name:s.LASTQUARTER,longText:I.getText("DYNAMIC_DATE_LASTQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastQuarter()}}),thisQuarter:new i({name:s.THISQUARTER,longText:I.getText("DYNAMIC_DATE_THISQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_THISQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.currentQuarter()}}),nextQuarter:new i({name:s.NEXTQUARTER,longText:I.getText("DYNAMIC_DATE_NEXTQUARTER_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_NEXTQUARTER_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.nextQuarter()}}),lastQuarters:new i({name:s.LASTQUARTERS,tokenText:I.getText("DYNAMIC_DATE_LASTQUARTERS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastQuarters(e)}}),nextQuarters:new i({name:s.NEXTQUARTERS,tokenText:I.getText("DYNAMIC_DATE_NEXTQUARTERS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextQuarters(e)}}),quarter1:new i({name:s.QUARTER1,longText:I.getText("DYNAMIC_DATE_QUARTER1_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_QUARTER1_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.quarter(1)}}),quarter2:new i({name:s.QUARTER2,longText:I.getText("DYNAMIC_DATE_QUARTER2_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_QUARTER2_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.quarter(2)}}),quarter3:new i({name:s.QUARTER3,longText:I.getText("DYNAMIC_DATE_QUARTER3_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_QUARTER3_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.quarter(3)}}),quarter4:new i({name:s.QUARTER4,longText:I.getText("DYNAMIC_DATE_QUARTER4_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_QUARTER4_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.quarter(4)}}),lastYear:new i({name:s.LASTYEAR,longText:I.getText("DYNAMIC_DATE_LASTYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_LASTYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.lastYear()}}),thisYear:new i({name:s.THISYEAR,longText:I.getText("DYNAMIC_DATE_THISYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_THISYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.currentYear()}}),nextYear:new i({name:s.NEXTYEAR,longText:I.getText("DYNAMIC_DATE_NEXTYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_NEXTYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.nextYear()}}),lastYears:new i({name:s.LASTYEARS,tokenText:I.getText("DYNAMIC_DATE_LASTYEARS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastYears(e)}}),nextYears:new i({name:s.NEXTYEARS,tokenText:I.getText("DYNAMIC_DATE_NEXTYEARS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextYears(e)}}),specificMonth:new i({name:s.SPECIFICMONTH,longText:I.getText("DYNAMIC_DATE_SPECIFICMONTH_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_SPECIFICMONTH_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}}],paramTypes:[S.call(this)],additionalInfo:"",label:[y.getText("operators.SPECIFICMONTH_MONTH.label")],defaultValues:function(){const e=new c;return[e.getMonth()]},calcRange:function(e){let t=new c;t.setMonth(e);t=d.getMonthStartDate(t);return d.getRange(0,"MONTH",t)},format:function(e,t,n,a,r,o,s){const[u]=e.values;const i=this.tokenFormat;const l=R.apply(this)[u];if(a){return l}else{return l==null?null:i.replace(new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g"),l)}},getValues:function(e,t,n,a){const r=u.prototype.getValues.apply(this,arguments);if(r){return[N.call(this,r[0])]}return null},createControl:function(e,t,n,a){const s=sap.ui.require("sap/ui/mdc/Field");const u=F.call(this);if(s&&u){const n=new s(a,{value:{path:t,type:e,mode:A.TwoWay,targetType:"raw"},display:o.Description,width:"100%",valueHelp:u});return n}else{r.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null}}}),specificMonthInYear:new i({name:s.SPECIFICMONTHINYEAR,longText:I.getText("DYNAMIC_DATE_SPECIFICMONTHINYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_SPECIFICMONTHINYEAR_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",constraints:{minimum:0,maximum:11}},{name:"sap.ui.model.type.Integer",constraints:{minimum:1,maximum:9999}}],paramTypes:[S.call(this),"(.+)"],additionalInfo:"",label:[y.getText("operators.SPECIFICMONTHINYEAR_MONTH.label"),y.getText("operators.SPECIFICMONTHINYEAR_YEAR.label")],defaultValues:function(){const e=new c;return[e.getMonth(),e.getFullYear()]},calcRange:function(e,t){let n=new c;n.setMonth(e);n.setYear(t);n=d.getMonthStartDate(n);return d.getRange(0,"MONTH",n)},format:function(e,t,n,a,r,o,s){const[u,i]=e.values;let l=this.tokenFormat;const T=R.apply(this)[u];if(a){return T+" "+i}else{const e=new RegExp("\\$"+0+"|"+0+"\\$"+"|"+"\\{"+0+"\\}","g");const t=new RegExp("\\$"+1+"|"+1+"\\$"+"|"+"\\{"+1+"\\}","g");l=T==null?null:l.replace(e,T);return l.replace(t,i)}},getValues:function(e,t,n,a){const r=u.prototype.getValues.apply(this,arguments);if(r){return[N.call(this,r[0]),r[1]]}return null},createControl:function(e,t,n,a){let s;const u=sap.ui.require("sap/ui/mdc/Field");if(!u){r.warning("Operator.createControl","not able to create the control for the operator "+this.name);return null}if(n==0){const n=F.call(this);if(n){s=new u(a,{value:{path:t,type:e,mode:A.TwoWay,targetType:"raw"},display:o.Description,width:"100%",valueHelp:n})}else{r.warning("Operator.createControl","not able to create the control for the operator "+this.name)}}if(n==1){s=new u(a,{value:{path:t,type:e,mode:A.TwoWay,targetType:"raw"},width:"100%"})}return s}}),yearToDate:new i({name:s.YEARTODATE,longText:I.getText("DYNAMIC_DATE_YEARTODATE_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_YEARTODATE_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.yearToDate()}}),dateToYear:new i({name:s.DATETOYEAR,longText:I.getText("DYNAMIC_DATE_DATETOYEAR_TITLE",undefined,true),tokenText:I.getText("DYNAMIC_DATE_DATETOYEAR_FORMAT",undefined,true),valueTypes:[p.Static],calcRange:function(){return d.ranges.dateToYear()}}),lastMinutes:new i({name:s.LASTMINUTES,tokenText:I.getText("DYNAMIC_DATE_LASTMINUTES_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastMinutes(e)}}),nextMinutes:new i({name:s.NEXTMINUTES,tokenText:I.getText("DYNAMIC_DATE_NEXTMINUTES_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextMinutes(e)}}),lastHours:new i({name:s.LASTHOURS,tokenText:I.getText("DYNAMIC_DATE_LASTHOURS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.lastHours(e)}}),nextHours:new i({name:s.NEXTHOURS,tokenText:I.getText("DYNAMIC_DATE_NEXTHOURS_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){return d.ranges.nextHours(e)}}),lastMinutesIncluded:new i({name:s.LASTMINUTESINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTMINUTESINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastMinutes(e-1);t[0].setSeconds(0);return t}}),nextMinutesIncluded:new i({name:s.NEXTMINUTESINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTMINUTESINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextMinutes(e-1);t[1].setSeconds(59);return t}}),lastHoursIncluded:new i({name:s.LASTHOURSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTHOURSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastHours(e-1);t[0].setMinutes(0,0);return t}}),nextHoursIncluded:new i({name:s.NEXTHOURSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTHOURSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextHours(e-1);t[1].setMinutes(59,59);return t}}),lastDaysIncluded:new i({name:s.LASTDAYSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTDAYSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastDays(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextDaysIncluded:new i({name:s.NEXTDAYSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTDAYSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextDays(e-1);t[0]=c.getInstance(f.getInstance());return t}}),lastWeeksIncluded:new i({name:s.LASTWEEKSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTWEEKSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastWeeks(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextWeeksIncluded:new i({name:s.NEXTWEEKSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTWEEKSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextWeeks(e-1);t[0]=c.getInstance(f.getInstance());return t}}),lastMonthsIncluded:new i({name:s.LASTMONTHSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTMONTHSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastMonths(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextMonthsIncluded:new i({name:s.NEXTMONTHSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTMONTHSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextMonths(e-1);t[0]=c.getInstance(f.getInstance());return t}}),lastQuartersIncluded:new i({name:s.LASTQUARTERSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTQUARTERSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastQuarters(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextQuartersIncluded:new i({name:s.NEXTQUARTERSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTQUARTERSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextQuarters(e-1);t[0]=c.getInstance(f.getInstance());return t}}),lastYearsIncluded:new i({name:s.LASTYEARSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_LASTYEARSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.lastYears(e-1);t[1]=c.getInstance(f.getInstance());return t}}),nextYearsIncluded:new i({name:s.NEXTYEARSINCLUDED,tokenText:I.getText("DYNAMIC_DATE_NEXTYEARSINCLUDED_FORMAT",undefined,true),valueTypes:[{name:"sap.ui.model.type.Integer",formatOptions:{emptyString:null},constraints:{minimum:0}}],paramTypes:["(\\d+)"],additionalInfo:"",calcRange:function(e){const t=d.ranges.nextYears(e-1);t[0]=c.getInstance(f.getInstance());return t}})},_mDefaultOpsForType:{},addOperator:function(e){x._mOperators[e.name]=e},addOperators:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(e=>{x.addOperator(e)})},removeOperators:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(e=>{x.removeOperator(e)})},removeOperator:function(e){if(typeof e==="string"){delete x._mOperators[e]}else{delete x._mOperators[e.name]}},setOperatorsForType:function(e,t,n){if(!Array.isArray(t)){t=[t]}if(!x._mDefaultOpsForType[e]){x._mDefaultOpsForType[e]={}}x._mDefaultOpsForType[e].operators=[];t.forEach(t=>{x.addOperatorForType(e,t)});if(n){x.setDefaultOperatorForType(e,n)}},setDefaultOperatorForType:function(e,t){if(!x._mDefaultOpsForType[e]){x._mDefaultOpsForType[e]={}}if(typeof t==="string"){t=x.getOperator(t)}x._mDefaultOpsForType[e].defaultOperator=t},addOperatorForType:function(e,t){x.insertOperatorForType(e,t)},insertOperatorForType:function(e,t,n){if(!x._mDefaultOpsForType[e]){x._mDefaultOpsForType[e]={operators:[]}}n=n===undefined?x._mDefaultOpsForType[e].operators.length:n;if(typeof t==="string"){t=x.getOperator(t)}x._mDefaultOpsForType[e].operators.splice(n,0,t)},removeOperatorForType:function(e,t){let n;if(typeof t==="string"){n=t}else{n=t.name}for(let t=0;t<x._mDefaultOpsForType[e].operators.length;t++){if(x._mDefaultOpsForType[e].operators[t].name===n){x._mDefaultOpsForType[e].operators.splice(t,1);return}}},getOperatorsForType:function(e){const t=[];for(let n=0;n<x._mDefaultOpsForType[e].operators.length;n++){t.push(x._mDefaultOpsForType[e].operators[n].name)}return t},getDefaultOperator:function(e){return x._mDefaultOpsForType[e].defaultOperator||x._mOperators.equal},getMatchingOperators:function(e,t){const n=[];for(let t=0;t<e.length;t++){const a=this.getOperator(e[t]);if(a){n.push(a)}}return M.call(this,n,t)},getOperator:function(e){for(const t in x._mOperators){const n=x._mOperators[t];if(n.name===e){return n}}return undefined},getEQOperator:function(e){if(e){for(let t=0;t<e.length;t++){const n=this.getOperator(e[t]);if(n&&n.validateInput&&!n.exclude&&n.valueTypes[0]&&n.valueTypes[0]!==p.Static){return n}}}return x._mOperators.equal},onlyEQ:function(e){if(e.length===1&&e[0]===s.EQ){return true}else{return false}},checkConditionsEmpty:function(e){if(!Array.isArray(e)){e=[e]}e.forEach(e=>{const t=this.getOperator(e.operator);if(t){e.isEmpty=t.isEmpty(e)}})},updateConditionsValues:function(e){if(!Array.isArray(e)){e=[e]}for(let t=0;t<e.length;t++){this.updateConditionValues(e[t])}},updateConditionValues:function(e){const t=this.getOperator(e.operator);if(t&&e.validated!==T.Validated){let n=t.valueTypes.length;if(t.valueTypes.length===2&&t.valueTypes[1]===null&&(e.values.length<2||e.values[1]===null||e.values[1]===undefined)){n=n-1}if(t.valueTypes[0]===p.Static){e.values=[]}else{while(e.values.length!=n){if(e.values.length<n){e.values.push(null)}if(e.values.length>n){e.values=e.values.slice(0,e.values.length-1)}}}}},indexOfCondition:function(e,t){let n=-1;for(let a=0;a<t.length;a++){if(this.compareConditions(e,t[a])){n=a;break}}return n},compareConditions:function(e,t){let n=false;if(e.operator===t.operator){const a=this.getOperator(e.operator);if(a){n=a.compareConditions(e,t)}}return n},compareConditionsArray:function(e,t){let n=false;if(e.length===t.length){n=true;for(let a=0;a<e.length;a++){if(!this.compareConditions(e[a],t[a])){n=false;break}}}return n},checkConditionValidated:function(e){const t=this.getOperator(e.operator);if(!e.validated&&t&&t.checkValidated){t.checkValidated(e)}},getOperatorForDynamicDateOption:function(e,t){let n;if(t&&e.startsWith(t)){n=this.getOperator(e.slice(t.length+1))}else{n=this.getOperator(e)}if(!n&&t){for(const a in x._mOperators){const r=x._mOperators[a];if(r.alias&&r.alias[t]===e){n=r;break}}}return n},getDynamicDateOptionForOperator:function(e,t,n){let a;if(e){if(t[e.name]){a=e.name}else if(e.alias&&t[e.alias[n]]){a=e.alias[n]}}return a},getCustomDynamicDateOptionForOperator:function(e,t){return t+"-"+e.name}};x.setOperatorsForType(l.String,[x._mOperators.contains,x._mOperators.equal,x._mOperators.between,x._mOperators.startsWith,x._mOperators.endsWith,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.empty,x._mOperators.notContains,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notStartsWith,x._mOperators.notEndsWith,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual,x._mOperators.notEmpty],x._mOperators.equal);x.setOperatorsForType(l.Date,[x._mOperators.equal,x._mOperators.between,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.empty,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual,x._mOperators.notEmpty,x._mOperators.today,x._mOperators.yesterday,x._mOperators.tomorrow,x._mOperators.firstDayWeek,x._mOperators.lastDayWeek,x._mOperators.firstDayMonth,x._mOperators.lastDayMonth,x._mOperators.firstDayQuarter,x._mOperators.lastDayQuarter,x._mOperators.firstDayYear,x._mOperators.lastDayYear,x._mOperators.todayFromTo,x._mOperators.lastDays,x._mOperators.lastDaysIncluded,x._mOperators.nextDays,x._mOperators.nextDaysIncluded,x._mOperators.thisWeek,x._mOperators.lastWeek,x._mOperators.lastWeeks,x._mOperators.lastWeeksIncluded,x._mOperators.nextWeek,x._mOperators.nextWeeks,x._mOperators.nextWeeksIncluded,x._mOperators.specificMonth,x._mOperators.specificMonthInYear,x._mOperators.thisMonth,x._mOperators.lastMonth,x._mOperators.lastMonths,x._mOperators.lastMonthsIncluded,x._mOperators.nextMonth,x._mOperators.nextMonths,x._mOperators.nextMonthsIncluded,x._mOperators.thisQuarter,x._mOperators.lastQuarter,x._mOperators.lastQuarters,x._mOperators.lastQuartersIncluded,x._mOperators.nextQuarter,x._mOperators.nextQuarters,x._mOperators.nextQuartersIncluded,x._mOperators.quarter1,x._mOperators.quarter2,x._mOperators.quarter3,x._mOperators.quarter4,x._mOperators.thisYear,x._mOperators.lastYear,x._mOperators.lastYears,x._mOperators.lastYearsIncluded,x._mOperators.nextYear,x._mOperators.nextYears,x._mOperators.nextYearsIncluded,x._mOperators.yearToDate,x._mOperators.dateToYear]);x.setOperatorsForType(l.DateTime,[x._mOperators.equal,x._mOperators.between,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.empty,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual,x._mOperators.notEmpty,x._mOperators.lastMinutes,x._mOperators.lastMinutesIncluded,x._mOperators.nextMinutes,x._mOperators.nextMinutesIncluded,x._mOperators.lastHours,x._mOperators.lastHoursIncluded,x._mOperators.nextHours,x._mOperators.nextHoursIncluded,x._mOperators.today,x._mOperators.yesterday,x._mOperators.tomorrow,x._mOperators.firstDayWeek,x._mOperators.lastDayWeek,x._mOperators.firstDayMonth,x._mOperators.lastDayMonth,x._mOperators.firstDayQuarter,x._mOperators.lastDayQuarter,x._mOperators.firstDayYear,x._mOperators.lastDayYear,x._mOperators.todayFromTo,x._mOperators.lastDays,x._mOperators.lastDaysIncluded,x._mOperators.nextDays,x._mOperators.nextDaysIncluded,x._mOperators.thisWeek,x._mOperators.lastWeek,x._mOperators.lastWeeks,x._mOperators.lastWeeksIncluded,x._mOperators.nextWeek,x._mOperators.nextWeeks,x._mOperators.nextWeeksIncluded,x._mOperators.specificMonth,x._mOperators.specificMonthInYear,x._mOperators.thisMonth,x._mOperators.lastMonth,x._mOperators.lastMonths,x._mOperators.lastMonthsIncluded,x._mOperators.nextMonth,x._mOperators.nextMonths,x._mOperators.nextMonthsIncluded,x._mOperators.thisQuarter,x._mOperators.lastQuarter,x._mOperators.lastQuarters,x._mOperators.lastQuartersIncluded,x._mOperators.nextQuarter,x._mOperators.nextQuarters,x._mOperators.nextQuartersIncluded,x._mOperators.quarter1,x._mOperators.quarter2,x._mOperators.quarter3,x._mOperators.quarter4,x._mOperators.thisYear,x._mOperators.lastYear,x._mOperators.lastYears,x._mOperators.lastYearsIncluded,x._mOperators.nextYear,x._mOperators.nextYears,x._mOperators.nextYearsIncluded,x._mOperators.yearToDate,x._mOperators.dateToYear]);x.setOperatorsForType(l.Numeric,[x._mOperators.equal,x._mOperators.between,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual]);x.setOperatorsForType(l.Time,[x._mOperators.equal,x._mOperators.between,x._mOperators.lessThan,x._mOperators.lessEqual,x._mOperators.greaterThan,x._mOperators.greaterEqual,x._mOperators.notEqual,x._mOperators.notBetween,x._mOperators.notLessThan,x._mOperators.notLessEqual,x._mOperators.notGreaterThan,x._mOperators.notGreaterEqual]);x.setOperatorsForType(l.Boolean,[x._mOperators.equal,x._mOperators.notEqual]);function M(e,t){const n=[];for(const a of e){if(a&&a.test&&a.test(t)){n.push(a)}}return n}function h(e){return e===null||e===undefined||e===""}function R(){if(!this._aMonths){const e=new c,t=g.getDateInstance({pattern:"LLLL"});e.setDate(15);e.setMonth(0);const n=[];for(let a=0;a<12;a++){n.push(t.format(e));e.setMonth(e.getMonth()+1)}this._aMonths=n}return this._aMonths}function N(e){const t=e.toLowerCase();const n=R.apply(this);let a=-1;n.some((n,r)=>{if(n.toLowerCase()===t||Number.parseInt(e)===r+1){a=r;return true}});return a}function S(){if(!this._sMonthRegExp){const e=R.apply(this);this._sMonthRegExp="("+e.join("|")+"|[1-9]|1[0-2])"}return this._sMonthRegExp}let Y=false;function F(){const e="LFHForSpecificMonth";if(!Y){Y=true;m(["sap/ui/mdc/valuehelp/content/FixedList","sap/ui/mdc/valuehelp/content/FixedListItem","sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/core/Control"]).then(t=>{const n=t[0];const a=t[1];const o=t[2];const s=t[3];const u=t[4];const i=function(){if(!this._aMonthsItems){const e=R.apply(this);this._aMonthsItems=[];for(let t=0;t<12;t++){this._aMonthsItems.push({text:e[t],key:t})}}return this._aMonthsItems}.bind(this);const l=new o(e,{typeahead:new s(e+"-pop",{content:[new n(e+"-FL",{filterList:false,useFirstMatch:true,items:{path:"$items>/",template:new a({text:"{$items>text}",key:"{$items>key}"}),templateShareable:false}})]})}).setModel(new O(i()),"$items");try{const t=_.getUIArea();const n=new u(e+"-parent",{dependents:[l]});t.addContent(n,true)}catch(e){r.error(e);throw new Error("MonthValueHelp cannot be assigned because static UIArea cannot be determined.")}})}return e}function k(e,t){const n="operators."+e+(t?".longText":".tokenText");return y.getText(n,undefined,true)}function C(e,t){const n="operators."+e+".longText";const a={};for(let e=0;e<t.length;e++){a[t[e]]=y.getText(n+"."+t[e].toLowerCase(),undefined,true)}return a}function L(e){const[t,n,a,r]=e.split(/([\*\+]\/)/);if(n){if(!r){return{navPath:t,propertyPath:a}}else{throw new Error("FilterOperatorUtil: not supported binding "+e)}}}return x},true);
//# sourceMappingURL=FilterOperatorUtil.js.map