/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/core/Lib","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/ui/model/ParseException","sap/base/Log","sap/base/util/merge","sap/base/util/deepEqual","sap/base/i18n/Localization","sap/base/strings/escapeRegExp","./Condition","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorOverwrite","sap/ui/mdc/enums/OperatorValueType"],(e,t,s,i,a,r,o,n,l,p,u,f,h,d,c,y)=>{"use strict";let g=t.getResourceBundleFor("sap.ui.mdc");l.attachChange(()=>{g=t.getResourceBundleFor("sap.ui.mdc")});const T=e.extend("sap.ui.mdc.condition.Operator",{constructor:function(t){e.apply(this,arguments);if(!t){throw new Error("Operator configuration missing")}if(!t.name){r.warning("Operator configuration expects a name property")}if(!t.filterOperator&&!t.getModelFilter){throw new Error("Operator configuration for "+t.name+" needs a default filter operator from sap.ui.model.FilterOperator or the function getModelFilter")}this._enableOverwrites(t);this.name=t.name;if(t.alias){this.alias=t.alias}this.filterOperator=t.filterOperator;this.valueTypes=t.valueTypes;this.paramTypes=t.paramTypes;this.displayFormats=t.displayFormats;this.longText=t.longText||"";this.tokenText=t.tokenText||"";this.longTextForTypes=t.longTextForTypes||{};if(!this.longText){if(this.tokenText){this.longText=this.tokenText.replace(/\{0\}/g,"X").replace(/\{1\}/g,"Y")}else{this.longText=this.name}}let s;const i=this.tokenText&&p(this.tokenText);if(t.tokenParse){this.tokenParse=t.tokenParse.replace(/#tokenText#/g,i);for(let e=0;e<this.valueTypes.length;e++){const t=this.paramTypes?this.paramTypes[e]:"(.+)";this.tokenParse=this.tokenParse.replace(new RegExp("\\\\\\$"+e+"|"+e+"\\\\\\$"+"|"+"\\\\\\{"+e+"\\\\\\}","g"),t)}s=this.tokenParse}else{s=i}this.tokenParseRegExp=new RegExp(s,"i");if(t.tokenTest){this.tokenTest=t.tokenTest.replace(/#tokenText#/g,i);for(let e=0;e<this.valueTypes.length;e++){const t=this.paramTypes?this.paramTypes[e]:"(.+)";this.tokenTest=this.tokenTest.replace(new RegExp("\\\\\\$"+e+"|"+e+"\\\\\\$"+"|"+"\\\\\\{"+e+"\\\\\\}","g"),t)}this.tokenTestRegExp=new RegExp(this.tokenTest,"i")}else{this.tokenTestRegExp=this.tokenParseRegExp}this.hiddenOperatorRegExp=new RegExp("^(.+)$","is");if(t.tokenFormat){this.tokenFormat=t.tokenFormat.replace(/\#tokenText\#/g,this.tokenText)}else{this.tokenFormat=this.tokenText||this.longText}if(t.additionalInfo!==undefined){this.additionalInfo=t.additionalInfo}this.exclude=!!t.exclude;this.validateInput=!!t.validateInput;if(t.group){this.group=t.group}else{this.group={id:!this.exclude?"1":"2"};if(!this.group.text){this.group.text=g.getText("VALUEHELP.OPERATOR.GROUP"+this.group.id)}}this.symbol=t.symbol},destroy:function(){this._oMethodOverwrites=null;e.prototype.destroy.apply(this,arguments)}});T.ValueType={Self:"self",Static:"static",SelfNoParse:"selfNoParse"};T.prototype.getLongText=function(e){if(e===f.Time||e===f.DateTime){e=f.Date}let t=this.longTextForTypes[e];if(!t){t=this.longText}return t};T.prototype.getModelFilter=function(e,t,a,r,o){let n=e.values[0];let l;let p;const u=t.split(",");if(Array.isArray(n)&&u.length>1){n=n[0];t=u[0];p=new s({path:u[1],operator:i.EQ,value1:e.values[0][1]})}if(p&&n===undefined){l=p;p=undefined}else if(!this.valueTypes[1]){if(!r&&e.validated===h.Validated){r=true}l=new s({path:t,operator:this.filterOperator,value1:n,caseSensitive:r===false?false:undefined})}else{let i=e.values[1];if(Array.isArray(i)&&u.length>1){i=i[0]}l=new s({path:t,operator:this.filterOperator,value1:n,value2:i,caseSensitive:r===false?false:undefined})}if(p){l=new s({filters:[l,p],and:true})}if(e.inParameters){const t=[l];for(const a in e.inParameters){if(a.startsWith("conditions/")){t.push(new s({path:a.slice(11),operator:i.EQ,value1:e.inParameters[a]}))}}if(t.length>1){l=new s({filters:t,and:true})}}return l};T.prototype.isEmpty=function(e,t){let s=false;if(e){for(let t=0;t<this.valueTypes.length;t++){if(this.valueTypes[t]!==y.Static){const i=e.values[t];if(i===null||i===undefined||i===""){s=true;break}}}}return s};T.prototype.format=function(e,t,s,i,a,r,o,n){const l=e.values;const p=this.valueTypes.length;const u=n||this.tokenFormat;let f=i&&p===1?"{0}":u;for(let e=0;e<p;e++){let s;let i;if(this.valueTypes[e]!==y.Static){if(this.valueTypes[e]===y.Self){s=t;i=a}else if(this.valueTypes[e]===null){s=r;i=o}else{s=this._createLocalType(this.valueTypes[e],t)}let n=l[e];if(n===undefined||n===null){n=s?s.parseValue("","string"):""}let p=this._formatValue(n,s,i);if(typeof p==="string"){p=p.replace(/\$/g,"$$$")}f=f.replace(new RegExp("\\$"+e+"|"+e+"\\$"+"|"+"\\{"+e+"\\}","g"),p)}}return f};T.prototype._formatValue=function(e,t,s){let i;if(t){if(t.isA("sap.ui.model.CompositeType")&&t.getUseInternalValues()&&Array.isArray(e)&&s){e=o([],e);for(let t=0;t<e.length;t++){if(s[t]){const i=s[t].getModelFormat();if(i&&typeof i.parse==="function"){e[t]=i.parse(e[t])}}}}i=t.formatValue(e,"string")}else{i=e}return i};T.prototype.parse=function(e,t,s,i,a,o,n,l){const p=this.getValues(e,s,i,l);let u;if(p){u=[];for(let e=0;e<this.valueTypes.length;e++){let s;let i;if(this.valueTypes[e]===y.Self){s=t;i=a}else if(this.valueTypes[e]===null){s=o;i=n}else if(this.valueTypes[e]&&this.valueTypes[e]!==y.Static){s=this._createLocalType(this.valueTypes[e],t)}try{if(this.valueTypes[e]!==y.Static&&p.length>e){let t;if(s&&p[e]!==undefined){t=this._parseValue(p[e],s,i)}else{t=p[e]}u.push(t)}}catch(e){r.warning(e.message);throw e}}}return u};T.prototype._parseValue=function(e,t,s){if(e===undefined){return e}let i;if(t&&t.isA("sap.ui.model.CompositeType")&&t._aCurrentValue&&t.getParseWithValues()){i=t._aCurrentValue}const a=t?t.parseValue(e,"string",i):e;if(t&&t.isA("sap.ui.model.CompositeType")&&Array.isArray(a)&&(t._aCurrentValue||t.getUseInternalValues()&&s)){for(let e=0;e<a.length;e++){if(a[e]===undefined&&t._aCurrentValue){a[e]=t._aCurrentValue[e]===undefined?null:t._aCurrentValue[e]}else if(t.getUseInternalValues()&&s&&s[e]){const t=s[e].getModelFormat();if(t&&typeof t.format==="function"){a[e]=t.format(a[e])}}}}return a};T.prototype.validate=function(e,t,s,i,a,r){const n=this.valueTypes.length;for(let l=0;l<n;l++){if((this.valueTypes[l]||this.valueTypes[l]===null)&&this.valueTypes[l]!==y.Static){let n;let p;if(this.valueTypes[l]===y.Self){n=t;p=s}else if(this.valueTypes[l]===null){n=a;p=r}else{n=this._createLocalType(this.valueTypes[l],t)}if(e.length<l+1&&this.valueTypes[l]){throw new Error("value "+l+" for operator "+this.name+" missing")}if(n&&e.length>l){let t=e[l];if(t===undefined||t===null){t=n?n.parseValue("","string"):""}let s=t;if(n.isA("sap.ui.model.CompositeType")&&Array.isArray(t)&&p&&n.getUseInternalValues()){s=o([],t);for(let e=0;e<s.length;e++){if(p[e]){const t=p[e].getModelFormat();if(t&&typeof t.parse==="function"){s[e]=t.parse(s[e])}}}}n.validateValue(s);if(n.isA("sap.ui.model.CompositeType")&&Array.isArray(t)&&p){for(let e=0;e<t.length;e++){if(p[e]){if(i===undefined||e===i){p[e].validateValue(t[e])}}}}}}}};T.prototype.getTextForCopy=function(e,t,s,i,a,r,o){return"\t"+this.format(e,t,s,i,a,r,o)};T.prototype._createLocalType=function(e,t){if(!this._aTypes){this._aTypes=[]}let s;let i;let a;let r;if(e===y.SelfNoParse){s=t.getMetadata().getName();i=o({},t.getFormatOptions());a=o(t.getConstraints())}else if(typeof e==="string"){s=e}else if(e&&typeof e==="object"){s=e.name;i=e.formatOptions;a=e.constraints}for(const e of this._aTypes){if(e.name===s&&n(e.formatOptions,i)&&n(e.constraints,a)){r=e.type;break}}if(!r){const t=sap.ui.require(s.replace(/\./g,"/"));r=new t(i,a);r._bCreatedByOperator=true;if(e===y.SelfNoParse){r.parseValue=function(e,s){t.prototype.parseValue.apply(this,arguments);return e};r.validateValue=function(e){const s=t.prototype.parseValue.apply(this,[e,"string"]);t.prototype.validateValue.apply(this,[s])};r.formatValue=function(e,s){t.prototype.formatValue.apply(this,arguments);return e}}this._aTypes.push({name:s,formatOptions:i,constraints:a,type:r})}return r};T.prototype.test=function(e){return this.tokenTestRegExp.test(e)};T.prototype.getValues=function(e,t,s,i){const a=i?this.hiddenOperatorRegExp:this.tokenParseRegExp;let r=e.match(a);let o;if(r){r.splice(0,1);r=r.filter(e=>e!==undefined);o=[];for(let e=0;e<this.valueTypes.length;e++){const t=r.length-this.valueTypes.length+e;if(r.length>=e){const e=r[t];o.push(e)}}}return o};T.prototype.getCondition=function(e,t,s,i,r,o,n,l){if(this.test(e)||(i||l)&&e&&this.hasRequiredValues()){const p=this.parse(e,t,s,i,r,o,n,l);if(p&&p.length===this.valueTypes.length||this.valueTypes[0]===y.Static||p&&p.length===1&&this.valueTypes.length===2&&!this.valueTypes[1]){const e=u.createCondition(this.name,p);this.checkValidated(e);return e}else if(p&&p.length>0){throw new a("Parsed value don't meet operator")}}return null};T.prototype.isSingleValue=function(){if(this.valueTypes.length>1&&this.valueTypes[1]){return false}return true};T.prototype.getCheckValue=function(e){if(this.valueTypes[0]&&this.valueTypes[0]===y.Static){return{}}else{return{values:e.values}}};T.prototype.hasRequiredValues=function(){if(this.valueTypes[0]&&this.valueTypes[0]!==y.Static){return true}else{return false}};T.prototype.compareConditions=function(e,t){let s=false;if(e.operator===this.name&&e.operator===t.operator){const i=this.getCheckValue(e);const a=this.getCheckValue(t);if(e.inParameters&&t.inParameters){i.inParameters=e.inParameters;a.inParameters=t.inParameters}if(e.outParameters&&t.outParameters){i.outParameters=e.outParameters;a.outParameters=t.outParameters}if(e.payload||t.payload){i.payload=e.payload;a.payload=t.payload}if(e.validated&&t.validated){i.validated=e.validated;a.validated=t.validated}if(n(i,a)){s=true}}return s};T.prototype.checkValidated=function(e){e.validated=h.NotValidated};T.prototype._enableOverwrites=function(e){this._oMethodOverwrites={};["format","parse","validate","getModelFilter","isEmpty","createControl","getCheckValue","getValues","checkValidated","getLongText","getTextForCopy"].forEach(t=>{Object.defineProperty(this,t,{get:function(){return this._oMethodOverwrites&&this._oMethodOverwrites[t]||Object.getPrototypeOf(this)[t]}});if(e&&e[t]){this._oMethodOverwrites[t]=e[t]}})};const m=Object.values(c);T.prototype.overwrite=function(e,t){if(m.indexOf(e)>=0){const s=this[e];this._oMethodOverwrites[e]=t;return s.bind(this)}throw"Operator: Illegal overwrite detected. Please see sap.ui.mdc.enums.OperatorOverwrite"};return T});
//# sourceMappingURL=Operator.js.map