/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/mdc/field/ConditionTypeMixin","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/ConditionValidated","sap/base/util/merge","sap/base/strings/whitespaceReplacer","sap/ui/base/SyncPromise","sap/base/util/Deferred"],(t,e,i,n,s,o,a,l,r,u,c,p,d,f,h,g,_,y,m)=>{"use strict";const C="sap.ui.mdc.raw";const v="sap.ui.mdc.raw:";const V=i.extend("sap.ui.mdc.field.ConditionType",{constructor:function(t,n){i.apply(this,arguments);this.sName="Condition";this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc");this._oCalls={active:0,last:0,condition:undefined,exception:undefined}}});V.prototype.destroy=function(){i.prototype.destroy.apply(this,arguments);if(this._oDefaultType){this._oDefaultType.destroy();delete this._oDefaultType}this._bDestroyed=true};V.prototype.getPrimitiveType=function(t){if(t===C||I(t)>=0){return t}else{return i.prototype.getPrimitiveType.apply(this,arguments)}};V.prototype.formatValue=function(t,e){let i=this._getValueType();if(t==undefined||t==null||this._bDestroyed){A.call(this,t,i);return null}if(typeof t!=="object"||!t.operator||!t.values||!Array.isArray(t.values)){throw new n("No valid condition provided")}if(!e){e="string"}const s=this._getAdditionalValueType();const o=this._isUnit(i);const a=this.oFormatOptions.preventGetDescription;A.call(this,t,i);let r,u,p,d,f;switch(this.getPrimitiveType(e)){case"string":case"any":r=this._getDisplay();u=this._getOperators();p=c.getEQOperator(u);if(!this.oFormatOptions.maxConditions||this.oFormatOptions.maxConditions===1){this._oCalls.active++;this._oCalls.last++}d=this._oCalls.last;if(!a&&r!==l.Value&&t.validated===h.Validated&&(o||t.operator===p.name&&!t.values[1])){const e=this.oFormatOptions.bindingContext;const a=o?t.values[0][1]:t.values[0];const l=this.oFormatOptions.awaitFormatCondition;const r=l&&new m;l?.(t,r.promise);return y.resolve().then(()=>U.call(this,a,t,i,s,e)).then(e=>{const n=g({},t);if(e){t=g({},t);if(o){i=this._getDefaultType();t.operator=p.name;if(typeof e!=="object"){e={key:a,description:e}}}const s=typeof e==="object"?e.description:e;n.values[1]=s;r?.resolve(n)}else{r?.reject(null)}return w.call(this,n,undefined,d,true,i,s)}).catch(e=>{let o;if(!(e instanceof n)||!N.call(this)){o=e}r?.reject(e);return w.call(this,t,o,d,true,i,s)}).unwrap()}return w.call(this,t,undefined,d,true,i,s);default:f=I(e);if(f>=0){if(this._isCompositeType(i)){return t.values.length>=1?t.values[0][f]:null}}else if(e===C){return t.values.length>=1?t.values[0]:null}else if(i&&t.values.length>=1){return i.formatValue(t.values[0],e)}throw new n("Don't know how to format Condition to "+e)}};function T(t,e,i){const s=this._getDisplay();const o=this._isUnit(e);if(o&&t.values.length>1&&t.values[0][1]===t.values[1][1]){t=g({},t);t.operator=r.EQ;t.values.splice(1)}const a=this._getHideOperator()&&t.values.length===1||o;const u=c.getOperator(t.operator);const p=this._getCompositeTypes();const d=this._getAdditionalCompositeTypes();if(!u){throw new n("No valid condition provided, Operator wrong.")}let h=u.format(t,e,s,a,p,i,d);const y=this.oFormatOptions.convertWhitespaces;if(y&&(this._getBaseType(e)===f.String||s!==l.Value)){h=_(h)}return h}function w(t,e,i,n,s,o){if(this._oCalls.active>0){this._oCalls.active--}if(i<this._oCalls.last&&(this._oCalls.condition!==undefined||this._oCalls.exception!==undefined)){t=this._oCalls.condition;e=this._oCalls.exception}if(i===this._oCalls.last&&this._oCalls.active>0){this._oCalls.condition=g({},t);this._oCalls.exception=e}else if(this._oCalls.active===0&&this._oCalls.last>0){this._oCalls={active:0,last:0,condition:undefined,exception:undefined}}if(e){throw e}let a;if(n){a=T.call(this,t,s,o)}else{a=O.call(this,t,s)}return a}V.prototype.getTextForCopy=function(t){const e=c.getOperator(t.operator);const i=this._getValueType();const n=this._getDisplay();const s=this._isUnit(i);const o=this._getHideOperator()&&t.values.length===1||s;const a=this._getCompositeTypes();const l=this._getAdditionalValueType();const r=this._getAdditionalCompositeTypes();return e.getTextForCopy(t,i,n,o,a,l,r)};V.prototype.parseValue=function(t,e){const i=F.call(this);if(!e){e="string"}else if(e==="any"&&typeof t==="string"){e="string"}return this._parseValue(t,e,i)};V.prototype._parseValue=function(t,e,i,n){if(this._bDestroyed){return null}let o;const a=this.oFormatOptions.navigateCondition;if(a){let i;if(a.hasOwnProperty("output")){i=a.output}else{i=this.formatValue(a,e)}if(i===t){o=g({},a);delete o.output;delete o.itemId;return o}}const l=n?n:this._getDisplay();const r=this._getValueType();const u=this._getOriginalType();const d=this._getOperators();const f=this._isUnit(r);let _;if(t===null||t===undefined||t===""&&!i){if(!this._isCompositeType(r)){return null}}E.call(this,r);let y,m,v;let V=this._getHideOperator();switch(this.getPrimitiveType(e)){case"string":m=false;v=false;if(d.length===1){y=c.getOperator(d[0]);v=true}else{const e=c.getMatchingOperators(d,t);if(e.length===0){y=this._getDefaultOperator(d,r);if(i&&!this._isCompositeType(r)){const t=c.getEQOperator(d);if(d.indexOf(t.name)>=0){m=!!y&&y.name!==t.name;y=t}}v=true}else{const t=e.filter(t=>t.valueTypes.length===0);if(t.length>=1){y=t[0]}else{y=e[0]}V=false}}if(y){if(f&&y!==c.getEQOperator(d)){throw new s("unsupported operator")}const e=this._isCompositeType(r);const n=this._getCompositeTypes();const a=this._getAdditionalValueType();const g=this._getAdditionalCompositeTypes();this._oCalls.active++;this._oCalls.last++;const _=this._oCalls.last;if((!e||f)&&y.validateInput&&i){o=D.call(this,y,t,r,a,v,V,m,d,l,true);return this._fnReturnPromise(o)}else{try{if(t===""&&e&&v){o=p.createCondition(y.name,[r.parseValue(t,"string",r._aCurrentValue)],undefined,undefined,h.NotValidated)}else{o=y.getCondition(t,r,l,v,n,a,g,V)}}catch(i){let n=i;if(n instanceof s&&u&&!e){try{u.parseValue(t,"string",u._aCurrentValue)}catch(t){n=t}}return w.call(this,undefined,n,_,false,r)}}if(o){return w.call(this,o,undefined,_,false,r)}}if(o!==null){throw new s("Cannot parse value "+t)}break;default:if(r){if(d.length===1){_=d[0]}else{_=this._getDefaultOperator(d,r).name;if(d.indexOf(_)<0){_=undefined}}if(_){const i=I(e);if(i>=0){if(this._isCompositeType(r)){const e=g([],r._aCurrentValue);e[i]=t;return p.createCondition(_,[e],undefined,undefined,h.NotValidated)}}else if(e===C){return p.createCondition(_,[t],undefined,undefined,h.NotValidated)}else{return p.createCondition(_,[r.parseValue(t,e)],undefined,undefined,h.NotValidated)}}}throw new s("Don't know how to parse Condition from "+e)}};function O(t,e){const i=this._isUnit(e);const n=this._isCompositeType(e);if(t&&!i&&n){const i=this._getOriginalType()||e;const n=i.getMetadata().getName();const s=i.getFormatOptions();const o=i.getConstraints();const a=this._getDelegate();const l=this.oFormatOptions.control;const u=a.getTypeMap(l).getBaseType(n,s,o);if((u===f.Unit||u===f.DateTime)&&!t.values[0][1]&&e._aCurrentValue){const i=e._aCurrentValue[1]===undefined?null:e._aCurrentValue[1];t.values[0][1]=i;if(t.operator===r.BT){t.values[1][1]=i}}}A.call(this,t,e);return t}function D(t,e,i,a,c,d,f,g,_,m){let C;let v;let V=true;let T=false;let O;let A;const E=this.oFormatOptions.bindingContext;const F=d?false:t.test(e);let U=e!==""&&t.getValues(e,_,c,d);let I=true;if(!U){U=[];C="";O=""}else{I=F;C=m?U[0]:U[1];v=m?U[1]:U[0];T=_!==l.Value;O=C||v}const Q=function(o){if(o&&!(o instanceof s)&&!(o instanceof n)){throw o}if(!o._bNotUnique){if(O===""){return null}if(m&&U[0]&&U[1]){return D.call(this,t,e,i,a,c,d,f,g,_,false)}if(f){return x.call(this,i,a,g,e,_,d)}}if(F||N.call(this)){return b.call(this,i,a,g,e,_,d)}throw new s(o.message)};const S=function(i){if(i){const e=[i.key];if(t.valueTypes.length>1&&t.valueTypes[1]!==u.Static){e.push(i.description)}return p.createCondition(t.name,e,i.inParameters,i.outParameters,h.Validated,i.payload)}else if(e===""){return null}else{return Q.call(this,new s(this._oResourceBundle.getText("valuehelp.VALUE_NOT_EXIST",[e])))}};const B=this._oCalls.last;const j=function(n,o){let a;let l;try{a=o.call(this,n);if(this._isUnit(i)){if(a){if(a.operator!==r.EQ){throw new s("unsupported operator")}const t=i._aCurrentValue&&i._aCurrentValue[0]!==undefined?i._aCurrentValue[0]:null;const e=a.values[0];a.values=[[t,e]]}else if(e===""){a=p.createCondition(t.name,[i.parseValue(e,"string",i._aCurrentValue)],undefined,undefined,h.NotValidated)}}}catch(t){l=t}return w.call(this,a,l,B,false,i)};const k=function(t,e,i,n){let a;try{if(this._isUnit(t)){const t=e&&e.length>1&&e[1]?e[1]:this._getDefaultType();a=t.parseValue(i,"string");t.validateValue(a)}else{a=t.parseValue(i,"string");t.validateValue(a)}}catch(t){if(t&&!(n&&(t instanceof s||t instanceof o))&&i!==""){throw t}a=undefined}return a}.bind(this);const H=k(i,this._getCompositeTypes(),C||O,T);V=H!==undefined;if(T){A=k(a,this._getAdditionalCompositeTypes(),v||O,V);T=A!==undefined}if(!V&&!T){return null}return y.resolve().then(()=>P.call(this,O,H,A,i,a,E,V,T,I)).then(t=>j.call(this,t,S)).catch(t=>j.call(this,t,Q)).unwrap()}function x(t,e,i,n,s,o){const a=this._getDefaultOperator(i,t);let r;if(a&&i.indexOf(a.name)>=0){r=a.getCondition(n,t,l.Value,true,undefined,e,undefined,o);r.validated=h.NotValidated}return r}function b(t,e,i,n,o,a){let r;if(this._isUnit(t)){r=c.getEQOperator()}else if(i.length===1){r=c.getOperator(i[0])}else{r=c.getEQOperator(i);if(i.indexOf(r.name)<0){r=undefined}}if(!r){throw new s("Cannot parse value "+n)}const u=r.getCondition(n,t,l.Value,true,undefined,e,undefined,a);if(u){u.validated=h.NotValidated;if(this._isUnit(t)&&Array.isArray(u.values[0])){u.values[0]=u.values[0][1]}}return u}V.prototype.validateValue=function(t){const e=this._getValueType();const i=this._getOriginalType();const n=this._getOperators();const s=this._isUnit(e);const a=this._isCompositeType(e);const l=this._getCompositeTypes();let r=0;const u=this._getAdditionalValueType();const p=this._getAdditionalCompositeTypes();if(t===undefined||this._bDestroyed){return null}else if(t===null){if(c.onlyEQ(n)){let t=null;try{if(e.hasOwnProperty("_sParsedEmptyString")&&e._sParsedEmptyString!==null){t=e._sParsedEmptyString}e.validateValue(t)}catch(e){if(e instanceof o){try{if(i&&!a){i.validateValue(t)}throw e}catch(t){if(t instanceof o){throw new d(t.message,t.violatedConstraints,null)}throw t}}else{return null}}}return null}if(typeof t!=="object"||!t.operator||!t.values||!Array.isArray(t.values)){throw new d(this._oResourceBundle.getText("field.VALUE_NOT_VALID"),undefined,typeof t==="object"?g({},t):t)}let f=c.getOperator(t.operator);if(s){f=c.getEQOperator();r=1}if(!f||n.indexOf(f.name)===-1){throw new d("No valid condition provided, Operator wrong.",undefined,g({},t))}try{f.validate(t.values,e,l,r,u,p)}catch(e){try{if(e instanceof o&&i&&!a){f.validate(t.values,i,l,r,u,p)}throw e}catch(e){if(e instanceof o){throw new d(e.message,e.violatedConstraints,g({},t))}throw e}}};function A(t,e){if(this._isCompositeType(e)){let i;if(t&&t.values[0]){i=t.values[0]}else{i=[]}e._aCurrentValue=g([],i);const n=this._getAdditionalType();if(this._isCompositeType(n)){n._aCurrentValue=g([],i)}const s=this._getOriginalType();if(this._isCompositeType(s)){s._aCurrentValue=g([],i)}}}function E(t){if(this._isCompositeType(t)){const e=this._getAdditionalType();if(this._isCompositeType(e)){if(!e._aCurrentValue){e._aCurrentValue=[]}t._aCurrentValue=e._aCurrentValue}}}function F(){const t=this._getValueHelp();const e=this._getDelegate();return e.isInputValidationEnabled(this.oFormatOptions.control,t)}function N(){const t=this._getValueHelp();const e=this._getDelegate();return e.isInvalidInputAllowed(this,t)}function P(t,e,i,n,o,a,l,r,u){const c=this._getValueHelp();const p=this._getDelegate();const d=this.oFormatOptions.control;const f={value:t,parsedValue:e,parsedDescription:i,dataType:n,bindingContext:a,checkKey:l,checkDescription:r,caseSensitive:u?true:undefined,exception:s,exactMatch:u,control:d};return p.getItemForValue(d,c,f)}function U(t,e,i,n,s){const o=this._getValueHelp();const a=this._getDelegate();const l=this.oFormatOptions.control;return a.getDescription(l,o,t,e.inParameters,e.outParameters,s,undefined,undefined,e.payload,l,i)}function I(t){let e=-1;if(t.startsWith(v)){e=parseInt(t[v.length])}return e}a.call(V.prototype);return V});
//# sourceMappingURL=ConditionType.js.map