/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/mdc/field/ConditionType","sap/ui/mdc/field/ConditionTypeMixin","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/OperatorName","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/base/util/merge","sap/ui/base/SyncPromise","sap/ui/core/util/PasteHelper"],(t,e,i,n,o,s,r,a,l,u,p,d,h,c,f,y)=>{"use strict";const g=u.extend("sap.ui.mdc.field.ConditionsType",{constructor:function(i,n){u.apply(this,arguments);this.sName="Conditions";i=m(i);this._oConditionType=new e(i,this.oConstraints);this._oResourceBundle=t.getResourceBundleFor("sap.ui.mdc")}});g.prototype.destroy=function(){u.prototype.destroy.apply(this,arguments);if(this._oConditionType){this._oConditionType.destroy();this._oConditionType=undefined}this._bDestroyed=true};g.prototype.setFormatOptions=function(t){u.prototype.setFormatOptions.apply(this,arguments);t=m(t);if(this._oConditionType){this._oConditionType.setFormatOptions(t)}};function m(t){t=c({},t);if(t.asyncParsing){delete t.asyncParsing}return t}g.prototype.setConstraints=function(t){u.prototype.setConstraints.apply(this,arguments);if(this._oConditionType){this._oConditionType.setConstraints(this.oConstraints)}};g.prototype.formatValue=function(t,e){if(t==undefined||t==null||this._bDestroyed){return null}if(!Array.isArray(t)){throw new p("No valid conditions provided")}let i;if(!e||e==="string"||e==="any"){i=""}else if(e==="float"||e==="int"){i=0}if(this._getNoFormatting()){return this._getKeepValue()||i}const n=this._getMaxConditions();const o=[];const s=function(t,e){return f.resolve().then(()=>this._oConditionType.formatValue(t,e))};if(t.length===0){o.push(s.call(this,null,e))}else{for(let i=0;i<t.length;i++){o.push(s.call(this,t[i],e));if(n>0&&i>=n-1){break}}}return f.all(o).then(t=>_.call(this,t,i)).unwrap()};function _(t,e){for(let i=0;i<t.length;i++){if(e){e=e+this._oResourceBundle.getText("field.SEPARATOR")+t[i]}else if(t[i]){e=t[i]}}return e}g.prototype.parseValue=function(t,e){if(this._bDestroyed){return null}if(this._getNoFormatting()&&t===""){return this.oFormatOptions.getConditions?this.oFormatOptions.getConditions():[]}return this._parseValueToIndex(t,e,-1)};g.prototype._parseValueToIndex=function(t,e,i){const n=this._getValueType();const o=this._getDefaultOperator(this._getOperators(),n);const s=o&&o.name===l.BT;const r=this._getMultipleLines();const u=r||e&&e!=="string"?[[t]]:y.getPastedDataAs2DArray(t);if(u.length>1||u.length===1&&u[0].length>1){const t=s?n:this._getDefaultType();const e=[{property:"value",type:n},{property:"additionalValue",type:t}];return this._fnReturnPromise(y.parse(u,e).then(e=>{if(e.errors){if(e.errors.length===1){throw new d(e.errors[0].message)}else{throw new d(this._oResourceBundle.getText("field.PASTE_ERROR"))}}return Promise.resolve(this._getDelegate().parsePasteDataToConditions(this.oFormatOptions.control,e.parsedData,{defaultOperator:o,valueType:n,additionalValueType:t})).then(t=>{const e=t.map(t=>typeof t==="string"?this._oConditionType._parseValue(t,"string",false,a.Value):t);let n=this.oFormatOptions.getConditions&&this.oFormatOptions.getConditions();e.forEach((t,e)=>{n=v.call(this,t,n,i>=0?i+e:i,true)});return n})}))}else{return C.call(this,t,e,i)}};function C(t,e,i){const n=function(t,e){return this._oConditionType.parseValue(t,e)};const o=function(t){throw t};return T.call(this,[t],e,i,n,o)}function T(t,e,i,n,o){const s=[];for(let i=0;i<t.length;i++){s.push(n.call(this,t[i],e))}const r=f.all(s).then(t=>{let e=this.oFormatOptions.getConditions&&this.oFormatOptions.getConditions();for(let n=0;n<t.length;n++){e=v.call(this,t[n],e,i,false);if(i>=0){i++}}return e}).catch(t=>{o.call(this,t)}).unwrap();return this._fnReturnPromise(r)}function v(t,e,i,n){const o=this._isUnit(this.oFormatOptions.valueType);const s=this._getMaxConditions();const r=this._getValueHelp();const a=this._getDelegate();const u=this.oFormatOptions.control;if(s!==1&&this.oFormatOptions.getConditions){if(t){if(this._isCompositeType(this.oFormatOptions.valueType)&&!o&&e.length===1&&(e[0].values[0][0]===null||e[0].values[0][0]===undefined||e[0].values[0][1]===null||e[0].values[0][1]===undefined)&&(t.values[0][0]!==null&&t.values[0][0]!==undefined&&t.values[0][1]!==null&&t.values[0][1]!==undefined)){e.splice(0,1)}if(a.indexOfCondition(u,r,t,e)===-1){if(i>=0&&e.length>i){e.splice(i,0,t)}else{e.push(t)}}else if(!n){throw new d(this._oResourceBundle.getText("field.CONDITION_ALREADY_EXIST",[t.values[0]]))}if(s>0&&s<e.length){e.splice(0,e.length-s)}}return e}else if(o&&this.oFormatOptions.getConditions&&e.length>1){const i=t&&t.values[0][1];const n=t&&t.inParameters;const o=t&&t.outParameters;const s=t&&t.payload;for(let r=0;r<e.length;r++){e[r].values[0][1]=i;if(i===undefined){e[r].values[0][0]=t.values[0][0]}e[r].values[0].splice(2);if(e[r].operator===l.BT){e[r].values[1][1]=i;if(i===undefined){e[r].values[1][0]=t.values[0][0]}e[r].values[1].splice(2)}if(n||e[r].inParameters){e[r].inParameters=n}if(o||e[r].outParameters){e[r].outParameters=o}if(s||e[r].payload){e[r].payload=s}}if(e.length===0){e.push(t)}return e}else if(t){return[t]}else{return[]}}g.prototype.validateValue=function(t){if(t===undefined||t===null||this._bDestroyed){return}if(!Array.isArray(t)){throw new o("No valid conditions provided",undefined,undefined,t)}let e;try{for(let i=0;i<t.length;i++){e=t[i];this._oConditionType.validateValue(e)}const i=this._getMaxConditions();if(t.length===0&&i===1){this._oConditionType.validateValue(null)}}catch(i){if(i instanceof o){i.setConditions(t)}else if(i instanceof h){throw new o(i.message,i.violatedConstraints,c({},e))}throw i}};i.call(g.prototype);return g});
//# sourceMappingURL=ConditionsType.js.map