/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Lib","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/OperatorValueType","sap/ui/mdc/util/DateUtil","sap/ui/model/SimpleType","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/m/library","sap/base/util/merge"],(e,t,o,i,a,s,n,r,p,u,l,d,c,y,f)=>{"use strict";const h=t.extend("sap.ui.mdc.field.DynamicDateRangeConditionsType",{constructor:function(t,o){u.apply(this,arguments);this.sName="ConditionsDateRange";this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc")}});h.prototype.destroy=function(){u.prototype.destroy.apply(this,arguments);this._bDestroyed=true};h.prototype.formatValue=function(e,t){if(e==undefined||e==null||this._bDestroyed){return null}if(!Array.isArray(e)){throw new l("No valid conditions provided")}const o=this._getMaxConditions();let a;if(o!==1){throw new l("MaxConditions must be 1")}if(e.length===1){const t=e[0];const o=i.getOperator(t.operator);if(!t.operator||!o){throw new l("No valid condition provided, Operator wrong.")}const s=[];const u=this._getValueType();const d=this._getBaseType(u);let c=i.getDynamicDateOptionForOperator(o,y.StandardDynamicDateRangeKeys,d);for(let e=0;e<o.valueTypes.length;e++){if(o.valueTypes[e]&&o.valueTypes[e]!==r.Static){if(c){if(o.valueTypes[e]===r.Self){s.push(p.typeToDate(t.values[e],u,d))}else{const i=this._getBaseTypeForValueType(o.valueTypes[e]);if(i===n.Date||i===n.DateTime){s.push(p.typeToDate(t.values[e],T.call(this,o,e),i))}else{s.push(t.values[e])}}}else{s.push(t.values[e])}}}if(!c){c=i.getCustomDynamicDateOptionForOperator(o,d)}a={operator:c,values:s}}return a};h.prototype.parseValue=function(e,t){if(this._bDestroyed){return null}if(this._getMaxConditions()!==1){throw new d("Only one condition supported for parsing")}const o=this._getOperators();const u=[];if(e&&e.operator){if(e.operator==="PARSEERROR"){throw new d(e.values[0])}const t=this._getValueType();const l=e.operator;const c=i.getOperatorForDynamicDateOption(l,this._getBaseType(t));if(c){const d=this._getBaseType(t);const f=[];for(let o=0;o<c.valueTypes.length;o++){if(c.valueTypes[o]&&c.valueTypes[o]!==r.Static){if(y.StandardDynamicDateRangeKeys[l]){if(c.valueTypes[o]===r.Self){f.push(p.dateToType(e.values[o],t,d))}else{const t=c.valueTypes[o]===r.Self?d:this._getBaseTypeForValueType(c.valueTypes[o]);if(t===n.Date||t===n.DateTime){f.push(p.dateToType(e.values[o],T.call(this,c,o),t))}else{f.push(e.values[o])}}}else{f.push(e.values[o])}}}const h=a.createCondition(c.name,f,undefined,undefined,s.NotValidated);i.updateConditionValues(h);i.checkConditionsEmpty(h,o);u.push(h)}}return u};h.prototype.validateValue=function(e){if(e===undefined||e===null||this._bDestroyed){return}if(!Array.isArray(e)){throw new o("No valid conditions provided",undefined,undefined,e)}const t=this._getValueType();const a=this._getOperators();for(const s of e){if(typeof s!=="object"||!s.operator||!s.values||!Array.isArray(s.values)){throw new o(this._oResourceBundle.getText("field.VALUE_NOT_VALID"),undefined,typeof s==="object"?f({},s):s,e)}const n=i.getOperator(s.operator);if(!n||a.indexOf(n.name)===-1){throw new o("No valid condition provided, Operator wrong.",undefined,f({},s),e)}try{n.validate(s.values,t)}catch(t){if(t instanceof c){throw new o(t.message,t.violatedConstraints,f({},s),e)}throw t}}};function T(e,t){return e._createLocalType(e.valueTypes[t])}h.prototype._sDefaultBaseType=n.Date;return h});
//# sourceMappingURL=DynamicDateRangeConditionsType.js.map