/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/Control","sap/ui/mdc/enums/BaseType","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/FieldDisplay","sap/ui/mdc/enums/ConditionValidated","sap/ui/mdc/enums/OperatorName","sap/ui/mdc/field/FieldBaseRenderer","sap/ui/mdc/field/ConditionType","sap/ui/mdc/field/ConditionsType","sap/ui/mdc/field/splitValue","sap/ui/mdc/field/content/ContentFactory","sap/ui/mdc/condition/FilterOperatorUtil","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionValidateException","sap/ui/mdc/util/loadModules","sap/ui/core/library","sap/ui/core/LabelEnablement","sap/ui/core/message/MessageMixin","sap/base/util/deepEqual","sap/base/util/merge","sap/base/util/restricted/_debounce","sap/ui/dom/containsOrEquals","sap/ui/model/BindingMode","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/events/KeyCodes","sap/ui/Device","sap/ui/mdc/enums/RequestShowContainerReason"],(t,e,i,n,s,o,a,l,r,h,c,g,u,p,d,f,y,C,m,v,_,F,b,I,T,D,V,P,M,E,O,A,S)=>{"use strict";const{ValueState:H}=C;const{TextAlign:x}=C;const{TextDirection:w}=C;const N=i.extend("sap.ui.mdc.field.FieldBase",{metadata:{interfaces:["sap.ui.core.IFormContent","sap.ui.core.ISemanticFormContent","sap.m.IOverflowToolbarContent","sap.ui.core.ILabelable"],designtime:"sap/ui/mdc/designtime/field/FieldBase.designtime",library:"sap.ui.mdc",properties:{dataType:{type:"string",group:"Data",defaultValue:"sap.ui.model.type.String"},dataTypeConstraints:{type:"object",group:"Data",defaultValue:null},dataTypeFormatOptions:{type:"object",group:"Data",defaultValue:null},editMode:{type:"sap.ui.mdc.enums.FieldEditMode",group:"Data",defaultValue:s.Editable},required:{type:"boolean",group:"Data",defaultValue:false},display:{type:"sap.ui.mdc.enums.FieldDisplay",defaultValue:o.Value},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:x.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:w.Inherit},placeholder:{type:"string",group:"Misc",defaultValue:""},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:H.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},multipleLines:{type:"boolean",group:"Appearance",defaultValue:false},maxConditions:{type:"int",group:"Behavior",defaultValue:-1},conditions:{type:"object[]",group:"Data",defaultValue:[],byValue:true,bindable:"bindable"},label:{type:"string",group:"Misc",defaultValue:""},delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/field/FieldBaseDelegate",payload:{}}},showEmptyIndicator:{type:"boolean",group:"Appearance",defaultValue:false},_valueHelpEnabled:{type:"boolean",group:"Appearance",defaultValue:false,visibility:"hidden"},_ariaAttributes:{type:"object",defaultValue:{},byValue:true,visibility:"hidden"},_operators:{type:"string[]",defaultValue:[],visibility:"hidden"}},aggregations:{content:{type:"sap.ui.core.Control",multiple:false},contentEdit:{type:"sap.ui.core.Control",multiple:false},contentDisplay:{type:"sap.ui.core.Control",multiple:false},_content:{type:"sap.ui.core.Control",multiple:true,visibility:"hidden"},fieldInfo:{type:"sap.ui.mdc.field.FieldInfoBase",multiple:false}},associations:{fieldHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},valueHelp:{type:"sap.ui.mdc.ValueHelp",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},press:{},submit:{parameters:{promise:{type:"Promise"}}}},publicMethods:[],defaultAggregation:"content"},renderer:r,_oManagedObjectModel:null,_oInvalidInput:null});v.call(N.prototype);const B={onsapup:ht,onsapdown:ht,onsaphome:ht,onsapend:ht,onsappageup:ht,onsappagedown:ht,onsapbackspace:ht,onkeydown:ht,onsapenter:$,onchange:$t,onsapfocusleave:jt,onpaste:z};const L={onsapenter:G};N._init=function(){u._init()};N._init();N.prototype.init=function(){i.prototype.init.apply(this,arguments);this._oObserver=new E(this.observeChanges.bind(this));this._oObserver.observe(this,{properties:["display","editMode","dataType","dataTypeFormatOptions","dataTypeConstraints","multipleLines","maxConditions","conditions","delegate"],aggregations:["fieldInfo","content","contentEdit","contentDisplay"],associations:["fieldHelp","valueHelp","ariaLabelledBy"]});this.attachEvent("modelContextChange",this.handleModelContextChange,this);this._oResourceBundle=e.getResourceBundleFor("sap.ui.mdc");this._aAsyncChanges=[];this._bPreventGetDescription=false;this._oContentFactory=this.getContentFactory();this._oCreateContentPromise=undefined;this._oValueHelpRequestPromise=undefined;this._sFilterValue=""};N.prototype.getContentFactory=function(){if(this.isFieldDestroyed()){return}if(!this._oContentFactory){this._oContentFactory=new u(this.getId()+"-contentFactory",{field:this,handleTokenUpdate:bt.bind(this),handleContentChange:Ct.bind(this),handleContentLiveChange:vt.bind(this),handleValueHelpRequest:Dt.bind(this),handleEnter:G.bind(this),handleContentPress:Ft.bind(this)})}return this._oContentFactory};const k=function(t){const e=Vt.call(this);const i=this.getControlForSuggestion();if(this.getEditMode()===s.Editable&&e&&!this._iFocusTimer&&!e.isOpen()&&I(i.getDomRef(),t.target)){e.requestShowTypeahead(S.Focus).then(i=>{if(i){this._iFocusTimer=setTimeout(()=>{if(!this.isFieldDestroyed()&&!e.isOpen()&&Xt.call(this)){Et.call(this,t,true)}this._iFocusTimer=null},300)}})}};const R=function(){if(this._iFocusTimer){clearTimeout(this._iFocusTimer);this._iFocusTimer=null}};N.prototype.exit=function(){R.call(this);const t=this.getFieldInfo();if(t){t.detachEvent("dataUpdate",zt,this)}const e=this.getContent();if(e){st.call(this,e)}const i=this.getContentEdit();if(i){st.call(this,i)}const n=this.getContentDisplay();if(n){st.call(this,n)}if(this._oManagedObjectModel){this._oManagedObjectModel.destroy();delete this._oManagedObjectModel}this._oObserver.disconnect();this._oObserver=undefined;this._oCreateContentPromise=undefined;this._oValueHelpRequestPromise=undefined;const s=Vt.call(this);if(s){if(this._bConnected){Ut.call(this,s);s.connect()}}if(this._oContentFactory){this._oContentFactory.destroy();this._oContentFactory=undefined}_t.call(this);delete this._fnLiveChangeTimer};N.prototype.applySettings=function(){i.prototype.applySettings.apply(this,arguments);if(!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate()}this.triggerCheckCreateInternalContent();this._bSettingsApplied=true;return this};N.prototype.setProperty=function(t,e,n){if(t==="editMode"){const t=this.getEditMode();if(t!==s.Display&&t!==s.EditableDisplay&&e!==s.Display&&e!==s.EditableDisplay){n=true}}else if(t!=="width"&&t!=="multipleLines"&&t!=="showEmptyIndicator"){n=true}return i.prototype.setProperty.apply(this,[t,e,n])};N.prototype.onBeforeRendering=function(){ot.call(this)};N.prototype.onAfterRendering=function(){};N.prototype.focus=function(t){this._oFocusInfo=t;i.prototype.focus.call(this,t);delete this._oFocusInfo};N.prototype.onfocusin=function(t){this._oFocusInHelp=undefined;qt.call(this);if(t.isMarked("doNotOpenOnFocus")){const t=Vt.call(this);t?.close()}else if(!this._oFocusInfo?.targetInfo?.silent){k.call(this,t)}};N.prototype.onsapfocusleave=function(t){R.call(this);_t.call(this);if(this._aAsyncChanges.length===0&&!this._bPendingChange){this._bDirty=false}};function U(t){const e=t.getParameter("fieldGroupIds");t.cancelBubble();t.preventDefault();const i=e.indexOf(this.getId());if(i>-1){if(this._bPendingChange){const t=Vt.call(this);if(!(t&&Xt.call(t))){const t=Wt.call(this);if(t){j.call(this,undefined,undefined,undefined,t)}else{j.call(this,this.getConditions(),!this.isInvalidInput())}}}if(e.length>1){e.splice(i,1);this.fireValidateFieldGroup({fieldGroupIds:e})}}else{this.fireValidateFieldGroup({fieldGroupIds:e})}}N.prototype.onsapup=function(t){this._handleNavigate(t,-1)};N.prototype.onsapdown=function(t){this._handleNavigate(t,1)};N.prototype.onsaphome=function(t){this._handleNavigate(t,-9999)};N.prototype.onsappageup=function(t){this._handleNavigate(t,-10)};N.prototype.onsappagedown=function(t){this._handleNavigate(t,10)};N.prototype.onsapend=function(t){this._handleNavigate(t,9999)};N.prototype._handleNavigate=async function(t,e){if(this.getEditMode()===s.Editable){const i=Vt.call(this);const n=t.srcControl;if(i){if(i.isNavigationEnabled(e)&&(!this.getContentFactory().isMeasure()||n.getShowValueHelp())){const n=this.getControlForSuggestion();const s=n.hasStyleClass("sapMFocus");const o=i.isOpen();t.preventDefault();t.stopPropagation();if(!o){i.setFilterValue(this._sFilterValue);const e=await i.requestShowTypeahead(S.Navigate);if(!this.isFieldDestroyed()&&!i.isOpen()&&e){await Et.call(this,t,true)}}i.navigate(o&&s&&e===1?0:e)}}}};N.prototype.onsapenter=function(t){const e=Vt.call(this);if(e&&e.isOpen()){e.close()}this._sFilterValue="";if(this._oNavigateCondition){const e=t.srcControl;this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();if(e.selectText&&e.getDOMValue){e.selectText(e.getDOMValue().length,e.getDOMValue().length)}}};N.prototype.onsapescape=function(t){this.onsapenter(t)};N.prototype._redirectFocus=function(t,e){const i=t.srcControl;if(!A.system.phone&&e.isOpen()&&(!this.getContentFactory().isMeasure()||i.getShowValueHelp&&i.getShowValueHelp())){Zt(i,e)}};N.prototype._requestShowTypeahead=function(t,e){const i=Vt.call(this);const n=this.getControlForSuggestion();if(this.getEditMode()===s.Editable&&i&&I(n.getDomRef(),t.target)){if(!this._bConnected){qt.call(this)}const s=!Xt.call(this);if(!i.isOpen()){i.requestShowTypeahead(e).then(e=>{if(e&&!this.isFieldDestroyed()&&(s||Xt.call(this))&&!i.isOpen()){if(s){n.focus()}Et.call(this,t,true)}})}this._redirectFocus(t,i)}};N.prototype.onkeyup=function(t){if(t.keyCode===O.TAB){this._requestShowTypeahead(t,S.Tab)}};N.prototype.ontap=function(t){if(t.isMarked("tokenTap")||t.getMark("tokenizerMoreIndicatorTap")||t.srcControl.isA("sap.ui.core.Icon")){return}this._requestShowTypeahead(t,S.Tap)};N.prototype.clone=function(t,e){this.detachEvent("modelContextChange",this.handleModelContextChange,this);const n=this.getContent();if(n){st.call(this,n)}const s=this.getContentEdit();if(s){st.call(this,s)}const o=this.getContentDisplay();if(o){st.call(this,o)}const a=this.getFieldInfo();if(a){a.detachEvent("dataUpdate",zt,this)}const l=i.prototype.clone.apply(this,arguments);this.attachEvent("modelContextChange",this.handleModelContextChange,this);if(n){nt.call(this,n)}if(s){nt.call(this,s)}if(o){nt.call(this,o)}if(a){a.attachEvent("dataUpdate",zt,this)}if(this._bTriggerable){l._bTriggerable=this._bTriggerable}return l};N.prototype.getFieldPath=function(){const t=this.getBindingPath("conditions");if(t&&t.startsWith("/conditions/")){return t.slice(12)}else{return""}};function q(t,e,i,n){if(this.getCurrentContent().length>1){this._bPendingChange=true}else{j.call(this,t,e,i,n)}}function j(t,e,i,n){if(!n){if(e){n=Promise.resolve(this.getResultForChangePromise(t))}else{const t=this._getInvalidInputException();if(t){n=Promise.reject(t)}else{n=Promise.reject(i)}}}if(this._aAsyncChanges.length===0){this._bDirty=false}this.fireChangeEvent(t,e,i,n);this._bPendingChange=false}N.prototype.fireChangeEvent=function(t,e,i,n){};function $(t){if(this._oNavigateCondition){t.setMarked("MDCNavigated")}}function G(t){const e=this.getEditMode();if(this._aAsyncChanges.length===0){this._bDirty=false}if(u._getEditable(e)&&(!t.isMarked||!t.isMarked("MDCNavigated"))&&(this.hasListeners("submit")||this._bPendingChange)){let t=Wt.call(this);let e=false;if(t){e=true}else if(this.isInvalidInput()){t=Promise.reject()}else{t=Promise.resolve(this.getResultForChangePromise(this.getConditions()))}if(this._bPendingChange){if(e){j.call(this,undefined,undefined,undefined,t)}else{j.call(this,this.getConditions(),!this.isInvalidInput(),undefined,t)}}this.fireSubmit({promise:t})}}function z(t){const e=this.getMaxConditions();if(e===1){return}const i=t.originalEvent.clipboardData.getData("text/plain");const n=g(i,true);if(n.length<=1){return}const s=t.srcControl;let o;for(const t in s.getMetadata().getAllProperties()){if(s.getBindingPath(t)==="/conditions"){o=t;break}}s.updateModelProperty(o,i,s.getProperty(o));t.stopImmediatePropagation(true);t.preventDefault();t.source=t.srcControl;t.parameters={};const a=this._aAsyncChanges.length;let l;let r;let h;if(a>0){this._aAsyncChanges[a-1].changeFired=true;this._aAsyncChanges[a-1].changeEvent=t;l=this._aAsyncChanges[a-1].promise}else{r=!this._bParseError;h=this.getConditions()}q.call(this,h,r,undefined,l)}N.prototype.initDataType=function(){if(this.getContentFactory().getDataType()){this.getContentFactory().getDataType().destroy();this.getContentFactory().setDataType(undefined)}if(this.getContentFactory().getDateOriginalType()){if(this.getContentFactory().getDateOriginalType()._bCreatedByField){this.getContentFactory().getDateOriginalType().destroy()}this.getContentFactory().setDateOriginalType(undefined)}if(this.getContentFactory().getUnitOriginalType()){if(this.getContentFactory().getUnitOriginalType()._bCreatedByField){this.getContentFactory().getUnitOriginalType().destroy()}this.getContentFactory().setUnitOriginalType(undefined)}this.getContentFactory().setIsMeasure(false)};function Q(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"){return t.getMetadata().getName()}else if(this.bDelegateInitialized){return this.getTypeMap().getDataTypeClassName(this.getDataType())}else{return this.getDataType()}}function W(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"&&t.getConstraints()){return t.getConstraints()}else{return this.getDataTypeConstraints()}}function K(){const t=this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType()||this.getContentFactory().getDataType();if(t&&typeof t==="object"&&t.getFormatOptions()){return t.getFormatOptions()}else{return this.getDataTypeFormatOptions()}}N.prototype.getBaseType=function(){const t=Q.call(this);const e=W.call(this);const i=K.call(this);const n=this.getTypeMap().getBaseType(t,i,e);return n};function Y(t,e){const i=Vt.call(this);if(i&&this._bConnected){Pt.call(this,t,i)}}N.prototype.getCurrentContent=function(){let t=this.getContent();if(!t){if(this.getEditMode()===s.Display){t=this.getContentDisplay()}else{t=this.getContentEdit()}}if(t){return[t]}else{return this.getAggregation("_content",[])}};N.prototype.handleModelContextChange=function(t){};function J(t){this.setValueState(H.Error);this.setValueStateText(t)}N.prototype._removeUIMessage=function(){this.setValueState(H.None);this.setValueStateText()};N.prototype.observeChanges=function(t){if(t.name==="dataType"){if(this.getContentFactory().getDataType()){const e=function(t){this.getContentFactory().checkDataTypeChanged(t).then(t=>{if(t&&!this.isFieldDestroyed()){this.initDataType();this.destroyAggregation("_content");this.getContentFactory().updateConditionType()}}).catch(t=>{throw t})}.bind(this);if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{e.call(this,t.current)});return}e.call(this,t.current)}}if(t.name==="dataTypeFormatOptions"||t.name==="dataTypeConstraints"){if(this.getContentFactory().getDataType()){this.initDataType();this.destroyAggregation("_content");this.getContentFactory().updateConditionType()}}if(t.name==="maxConditions"){this.updateInternalContent()}if(t.name==="conditions"){this.resetInvalidInput(!this._bKeepValueState);Y.call(this,t.current,t.old);let e=false;let i=0;for(i=0;i<this._aAsyncChanges.length;i++){const n=this._aAsyncChanges[i];if(n.waitForUpdate&&_(n.result,t.current)){mt.call(this,n);e=true;break}}if(e){this._aAsyncChanges.splice(i,1)}if((t.current.length===0||t.old.length===0)&&this.getShowEmptyIndicator()&&this.getEditMode()===s.Display&&!this.getContent()&&!this.getContentDisplay()){this.invalidate()}}if(t.name==="display"){this.destroyInternalContent();this.getContentFactory().updateConditionType()}if((t.name==="fieldHelp"||t.name==="valueHelp")&&t.ids){It.call(this,t.ids,t.mutation);this.getContentFactory().updateConditionType()}if(t.name==="fieldInfo"&&t.child){Gt.call(this,t.child,t.mutation)}if(t.name==="content"&&t.child){et.call(this,t.child,t.mutation,t.name)}if(t.name==="contentEdit"&&t.child){et.call(this,t.child,t.mutation,t.name)}if(t.name==="contentDisplay"&&t.child){et.call(this,t.child,t.mutation,t.name)}if(t.name==="delegate"&&!this.bDelegateInitialized&&!this.bDelegateLoading){this.initControlDelegate.call(this)}if(t.name==="ariaLabelledBy"&&t.ids){X.call(this,t.ids,t.mutation)}if(t.name==="editMode"){tt.call(this);if(this._bSettingsApplied&&(t.old===s.Display||t.old===s.EditableDisplay||t.current===s.Display||t.current===s.EditableDisplay)){if(this._aCustomControlNames){this.destroyInternalContent()}this.triggerCheckCreateInternalContent()}}};N.prototype.updateInternalContent=function(){if(this.getAggregation("_content",[]).length>0){if(this._aCustomControlNames){this.destroyInternalContent()}ot.call(this);this.getContentFactory().updateConditionType()}};N.prototype.getFocusDomRef=function(){const t=this.getCurrentContent();if(t.length>0){return t[0].getFocusDomRef()}else{return this.getDomRef()}};N.prototype.getIdForLabel=function(){let t;const e=this.getCurrentContent();if(e.length>0){t=e[0].getIdForLabel()}else{t=lt.call(this)}return t};N.prototype.hasLabelableHTMLElement=function(){let t=false;const e=this.getCurrentContent();if(e.length>0&&e[0].hasLabelableHTMLElement){t=e[0].hasLabelableHTMLElement()}else{const e=this.getEditMode();t=e!==s.Display}return t};N.prototype.getEditable=function(){return u._getEditable(this.getEditMode())};N.prototype.getControlForSuggestion=function(){const t=this.getCurrentContent();if(t.length>0){if(this.getContentFactory().isMeasure()&&t.length>1){return t[1]}else{return t[0]}}else{return this}};N.prototype.getFocusElementForValueHelp=function(t){const e=this.getControlForSuggestion();const i=e&&e.getMetadata().getAllPrivateAggregations()._endIcon&&e.getAggregation("_endIcon",[]);let n;if(i){for(let t=0;t<i.length;t++){if(i[t].getVisible()){n=i[t];break}}}return t||!n?e:n};N.prototype.getMaxConditionsForHelp=function(){if(this.getContentFactory().isMeasure()){return 1}else{return this.getMaxConditions()}};N.prototype.getFormFormattedValue=function(){const t=this.getConditions();const i=this.getShowEmptyIndicator()&&t.length===0&&!this.getContent()&&!this.getContentDisplay();if(i){if(!this._oResourceBundleM){this._oResourceBundleM=e.getResourceBundleFor("sap.m")}return this._oResourceBundleM.getText("EMPTY_INDICATOR")}else if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitOriginalType(true)){const e=t.length>0?t[0].values[0]:[0,null];return this.getContentFactory().getUnitOriginalType().formatValue(e,"string")}else if(this.getContentFactory().getDateOriginalType(true)){const e=t.length>0?t[0].values[0]:null;return this.getContentFactory().getDateOriginalType().formatValue(e,"string")}else{const e=this.getContentFactory().getConditionsType();const i=e.getFormatOptions();const n=i.noFormatting;i.noFormatting=false;e.setFormatOptions(i);const s=e.formatValue(t);i.noFormatting=n;e.setFormatOptions(i);return s}};N.prototype.getFormValueProperty=function(){return"conditions"};N.prototype.getFormObservingProperties=function(){return["conditions","editMode"]};N.prototype.getFormRenderAsControl=function(){if(this.getEditMode()===s.Display){const t=this.getCurrentContent();if(t.length===1){if(t[0].getFormRenderAsControl){return t[0].getFormRenderAsControl()}else{return false}}else if(t.length>1){return false}else{return true}}else{return false}};N.prototype.getOverflowToolbarConfig=function(){return{canOverflow:true,invalidationEvents:[],propsUnrelatedToSize:["conditions","editMode","display","valueState","valueStateText"]}};N.prototype.enhanceAccessibilityState=function(t,e){const i=this.getParent();if(i&&i.enhanceAccessibilityState){i.enhanceAccessibilityState(t,e)}};N.prototype.getAccessibilityInfo=function(){const t=this.getCurrentContent();if(t.length===1&&t[0].getAccessibilityInfo){return t[0].getAccessibilityInfo()}else if(t.length>0){return{children:t}}else{return{}}};function X(t,e){const i=this.getAggregation("_content",[]);let n=this.getContent();if(n){i.push(n)}n=this.getContentDisplay();if(n){i.push(n)}n=this.getContentEdit();if(n){i.push(n)}for(let s=0;s<i.length;s++){n=i[s];if(n.getMetadata().getAllAssociations().ariaLabelledBy){if(e==="remove"){n.removeAriaLabelledBy(t)}else if(e==="insert"){n.addAriaLabelledBy(t)}}}}function Z(t,e){const i={aria:{}};const n=Vt.call(this);if(n){const s=n.getAriaAttributes(this.getMaxConditionsForHelp());const o=s.roleDescription;i["role"]=s.role;if(o){i.aria["roledescription"]=o}i.aria["haspopup"]="dialog";i["autocomplete"]="off";if(t){if(s.role){i.aria["expanded"]="true"}i.aria["controls"]=s.contentId;if(e){i.aria["activedescendant"]=e}}else if(s.role){i.aria["expanded"]="false"}i["valueHelpEnabled"]=s.valueHelpEnabled;if(s.autocomplete&&s.autocomplete!=="none"){i.aria["autocomplete"]=s.autocomplete}}this.setProperty("_ariaAttributes",i,true)}N.prototype.connectLabel=function(t){rt.call(this,t);t.bindProperty("text",{path:"$field>/label"});t.setLabelFor(this);return this};function tt(){const e=m.getReferencingLabels(this);for(let i=0;i<e.length;i++){const n=t.getElementById(e[i]);n.setLabelFor(n.getLabelFor());n.invalidate()}}function et(t,e,i){if(e==="remove"){st.call(this,t);gt.call(this,t);if(this.getContentFactory().getContentConditionTypes()){delete this.getContentFactory().getContentConditionTypes()[i]}t.setModel(null,"$field")}else if(e==="insert"){if(!t.isA("sap.ui.core.IFormContent")){throw new Error(t+" is not a valid content! Only use valid content in "+this)}ct.call(this,t,true);nt.call(this,t);if(this.getAggregation("_content",[]).length>0){this.destroyInternalContent()}this.getContentFactory().setNoFormatting(false);this.awaitControlDelegate().then(()=>{if(!this.isFieldDestroyed()){const t=pt.call(this,this.getSupportedOperators());if(t!==this.getContentFactory().getHideOperator()){this.getContentFactory().setHideOperator(t);this.getContentFactory()._setUsedConditionType(this.getContent(),this.getContentEdit(),this.getContentDisplay(),this.getEditMode())}}});it.call(this,t,i)}}function it(t,e){if(!this.getContentFactory().getContentConditionTypes()){this.getContentFactory().setContentConditionTypes({})}if(!this.getContentFactory().getContentConditionTypes()[e]){this.getContentFactory().getContentConditionTypes()[e]={}}let i;let n;let s=false;for(n in t.getMetadata().getAllProperties()){if(t.getBindingPath(n)==="/conditions"){i=t.getBindingInfo(n);if(i&&i.type&&i.type instanceof c){this.getContentFactory().getContentConditionTypes()[e].oConditionsType=i.type}s=true}if(n==="editable"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:u._getEditable})}if(n==="enabled"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:u._getEnabled})}if(n==="displayOnly"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/editMode",formatter:u._getDisplayOnly})}if(n==="required"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/required"})}if(n==="textAlign"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/textAlign"})}if(n==="textDirection"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/textDirection"})}if(n==="valueState"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/valueState"})}if(n==="valueStateText"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/valueStateText"})}if(n==="placeholder"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/placeholder"})}if(n==="showValueHelp"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.bindProperty(n,{path:"$field>/_valueHelpEnabled"})}if(n==="valueHelpIconSrc"&&!t.getBindingPath(n)&&t.isPropertyInitial(n)){t.setValueHelpIconSrc(this._getValueHelpIcon())}}for(const o in t.getMetadata().getAllAggregations()){if(t.getBindingPath(o)==="/conditions"){i=t.getBindingInfo(o);if(i&&i.template){for(n in i.template.getMetadata().getAllProperties()){const t=i.template.getBindingInfo(n);if(t&&t.type&&t.type instanceof h){this.getContentFactory().getContentConditionTypes()[e].oConditionType=t.type;if(s){this.getContentFactory().setNoFormatting(true)}break}}}}if(o==="tooltip"&&!t.getBindingPath(o)&&!t.getAggregation(o)){t.bindProperty(o,{path:"$field>/tooltip"})}}if(t.getMetadata().getAllAssociations().ariaLabelledBy){this.getContentFactory().setAriaLabelledBy(t)}}function nt(t){if(t.getMetadata().getAllEvents().change){t.attachEvent("change",Ct,this)}if(t.getMetadata().getAllEvents().liveChange){t.attachEvent("liveChange",vt,this)}if(t.getMetadata().getAllEvents().press){t.attachEvent("press",Ft,this)}if(t.getMetadata().getAllEvents().valueHelpRequest){t.attachEvent("valueHelpRequest",Dt,this)}if(t.getMetadata().getAllEvents().tokenUpdate){t.attachEvent("tokenUpdate",bt,this)}if(t.getMetadata().getAllEvents().validateFieldGroup){t.attachEvent("validateFieldGroup",U,this)}}function st(t){if(t.getMetadata().getAllEvents().change){t.detachEvent("change",Ct,this)}if(t.getMetadata().getAllEvents().liveChange){t.detachEvent("liveChange",vt,this)}if(t.getMetadata().getAllEvents().press){t.detachEvent("press",Ft,this)}if(t.getMetadata().getAllEvents().valueHelpRequest){t.detachEvent("valueHelpRequest",Dt,this)}if(t.getMetadata().getAllEvents().tokenUpdate){t.detachEvent("tokenUpdate",bt,this)}if(t.getMetadata().getAllEvents().validateFieldGroup){t.detachEvent("validateFieldGroup",U,this)}}function ot(){const t=function(){if(!this.bDelegateInitialized){this.awaitControlDelegate().then(()=>{ot.call(this)})}else{at.call(this)}};if(this._oCreateContentPromise){this._oCreateContentPromise.then(()=>{ot.call(this)})}else{t.call(this)}}N.prototype.checkCreateInternalContent=function(){if(!this.isFieldDestroyed()&&this.getVisible()){ot.call(this)}};N.prototype.triggerCheckCreateInternalContent=function(){if(!this._oCheckCreateInternalContentPromise){this._oCheckCreateInternalContentPromise=this.awaitControlDelegate().then(()=>{delete this._oCheckCreateInternalContentPromise;this.checkCreateInternalContent()})}};function at(){if(this.isFieldDestroyed()){return}const t=this.getEditMode();const e=this.getContent();const i=this.getContentEdit();const n=this.getContentDisplay();this.getContentFactory()._setUsedConditionType(e,i,n,t);Tt.call(this,this._getValueHelp());Z.call(this,false);if(e||t===s.Display&&n||t!==s.Display&&i){this.destroyInternalContent();const t=this.getCurrentContent();if(t.length===1){rt.call(this,t[0])}return}const o=this.getMaxConditions();const a=this.getSupportedOperators();const l=this.getAggregation("_content",[]);const r=this.getMultipleLines();const h=this._bTriggerable;const c=this.getContentFactory().getContentType(this.getBaseType(),this.getMaxConditions(),h);const[g]=l;const u=g?.getMetadata().getName().replace(/\./g,"/");const p=this.getContentFactory().getContentMode(c,t,o,r,a);const d=this._aCustomControlNames||c.getControlNames(p,a[0]);const[f]=d;if(f!==u){this.getContentFactory().setHideOperator(pt.call(this,a));if(g){this.destroyInternalContent();if(g.isA("sap.m.DateTimeField")){this.initDataType()}this.getContentFactory().updateConditionType()}const i=!this._getValueHelp()&&this.getContentFactory().getProvideDefaultValueHelp(c,a,t,o,pt.call(this,a));if(!i&&this._sDefaultValueHelp){delete this._sDefaultValueHelp}const n=lt.call(this);const s=this.getControlDelegate();this._oCreateContentPromise=s.createContent(this,p,n,i);this._oCreateContentPromise.then(t=>{delete this._oCreateContentPromise;for(const i of t){if(i.isA("sap.ui.mdc.ValueHelp")){this._sDefaultValueHelp=i.getId();if(!i.getControl()){i.connect(this)}this.getContentFactory().updateConditionType();ut.call(this,this._sDefaultValueHelp);Z.call(this,false);continue}if(!i._bByContentFactory){if(!i.isA("sap.ui.core.IFormContent")){throw new Error(e+" is not a valid content! Only use valid content in "+this)}if(!this._aCustomControlNames){this._aCustomControlNames=[]}this._aCustomControlNames.push(i.getMetadata().getName().replace(/\./g,"/"));it.call(this,i,"_content");this.getContentFactory()._setUsedConditionType(this.getContent(),this.getContentEdit(),this.getContentDisplay(),this.getEditMode())}i.attachEvent("parseError",dt,this);i.attachEvent("validationError",ft,this);i.attachEvent("validationSuccess",yt,this);i.attachEvent("validateFieldGroup",U,this);ct.call(this,i,c.getUseDefaultEnterHandler());rt.call(this,i);this.addAggregation("_content",i)}tt.call(this)}).catch(t=>{delete this._oCreateContentPromise;throw t})}}function lt(){return this.getId()+"-inner"}N.prototype.destroyInternalContent=function(){this.destroyAggregation("_content");if(this.getContentFactory().getDateOriginalType()){this.getContentFactory().setDataType(this.getContentFactory().getDateOriginalType());this.getContentFactory().setDateOriginalType(undefined)}else if(this.getContentFactory().getUnitOriginalType()){this.getContentFactory().setDataType(this.getContentFactory().getUnitOriginalType());this.getContentFactory().setUnitOriginalType(undefined)}if(this.isInvalidInput()){this.resetInvalidInput(true)}if(this.getContentFactory().isMeasure()){this.getContentFactory().setIsMeasure(false)}delete this._aCustomControlNames;if(this.getContentFactory().getContentConditionTypes()?.["_content"]){delete this.getContentFactory().getContentConditionTypes()["_content"]}};function rt(t){if(!this._oManagedObjectModel&&!this.isFieldDestroyed()){this._oManagedObjectModel=new M(this)}t.setModel(this._oManagedObjectModel,"$field")}function ht(t){let e=false;const i=Vt.call(this);if(!i){return}else{switch(t.type){case"sapup":e=i.isNavigationEnabled(-1);break;case"sapdown":e=i.isNavigationEnabled(1);break;case"saphome":e=i.isNavigationEnabled(-9999);break;case"sapend":e=i.isNavigationEnabled(9999);break;case"sappageup":e=i.isNavigationEnabled(-10);break;case"sappagedown":e=i.isNavigationEnabled(10);break;case"sapbackspace":this._bPreventAutocomplete=true;break;case"keydown":if(t.which!==O.BACKSPACE&&t.which!==O.DELETE){this._bPreventAutocomplete=false}break;default:e=i.isOpen();break}}if(e){t.stopPropagation();t.stopImmediatePropagation(true);switch(t.type){case"sapup":this.onsapup(t);break;case"sapdown":this.onsapdown(t);break;case"saphome":this.onsaphome(t);break;case"sapend":this.onsapend(t);break;case"sappageup":this.onsappageup(t);break;case"sappagedown":this.onsappagedown(t);break;default:break}}}function ct(t,e){t.addDelegate(B,true,this);if(e){t.addDelegate(L,false,this)}}function gt(t){t.removeDelegate(B);t.removeDelegate(L)}function ut(t){It.call(this,t,"insert")}function pt(t){if(t.length===1){const e=p.getOperator(t[0]);return!e||e.isSingleValue()}else{return false}}N.prototype._setInvalidInput=function(t,e,i,n){const s=n?n.getId():this.getId();if(!this._oInvalidInput){this._oInvalidInput={}}this._oInvalidInput[s]={exception:t,value:e,reason:i}};N.prototype._getInvalidInputException=function(t){let e;if(this._oInvalidInput){if(t){if(this._oInvalidInput[t.getId()]){return this._oInvalidInput[t.getId()].exception}else if(this._oInvalidInput[this.getId()]){return this._oInvalidInput[this.getId()].exception}}else{for(const t in this._oInvalidInput){e=this._oInvalidInput[t].exception;if(e){break}}}}return e};N.prototype.resetInvalidInput=function(t){if(this._oInvalidInput){this._oInvalidInput=null;if(t){this._removeUIMessage()}}};N.prototype.isInvalidInput=function(){return!!this._oInvalidInput};N.prototype._isInvalidInputForContent=function(t){return this._oInvalidInput&&(this._oInvalidInput[t.getId()]||this._oInvalidInput[this.getId()])};function dt(t){const e=t.getParameter("newValue");const i=t.getParameter("exception");const n=t.getSource();this._setInvalidInput(i,e,"ParseError",n);this._sFilterValue="";const s=n.getBinding("valueState");if(s&&s.getBindingMode()===T.OneWay){J.call(this,t.getParameter("message"))}}function ft(t){const e=t.getParameter("newValue");const i=t.getParameter("exception");const n=t.getSource();this._setInvalidInput(i,e,"ValidationError",n);this._sFilterValue="";const s=i&&i instanceof f&&i.getConditions();let o=false;let a=0;for(a=0;a<this._aAsyncChanges.length;a++){const n=this._aAsyncChanges[a];if(n.waitForUpdate&&Array.isArray(n.result)){if(n.result.length===0&&e===""){n.reject(t.getParameter("exception"));o=true;break}else if(_(n.result,s)){n.reject(i);o=true;break}}}if(o){this._aAsyncChanges.splice(a,1)}const l=n.getBinding("valueState");if(l&&l.getBindingMode()===T.OneWay){J.call(this,t.getParameter("message"))}}function yt(t){const e=t.getSource();if(this._isInvalidInputForContent(e)){const t=e.getBinding("valueState");let i=false;if(t&&t.getBindingMode()===T.OneWay){i=true}this.resetInvalidInput(i)}}function Ct(t){const e={parameters:F({},t.getParameters()),source:t.getSource()};const i=this._aAsyncChanges.length;if(i>0&&!this._aAsyncChanges[i-1].changeFired){this._aAsyncChanges[i-1].changeFired=true;this._aAsyncChanges[i-1].changeEvent=e;q.call(this,undefined,undefined,undefined,this._aAsyncChanges[i-1].promise);return}const n={changeEvent:e};mt.call(this,n)}function mt(e){const i=this.getConditions();let n=true;let s;const o=e.changeEvent.source;if(e.changeEvent.parameters.hasOwnProperty("valid")){n=e.changeEvent.parameters["valid"]}else if(this.isInvalidInput()){n=false}if(!n&&e.changeEvent.parameters.hasOwnProperty("value")){s=e.changeEvent.parameters["value"]}const a=Vt.call(this);if(a&&this._bConnected){if(t.getActiveElement()===o){a.close()}this._sFilterValue="";if(n){Pt.call(this,i,a);a.onControlChange()}_t.call(this)}if(this._oNavigateCondition){this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();const t=o.getDOMValue?.();if(o.selectText&&t){o.selectText(t.length,t.length)}}if(e.resolve){Kt.call(this,e)}else{q.call(this,i,n,s)}}function vt(t){let e;let i;let n=false;const s=t.getSource();if("value"in t.getParameters()){e=t.getParameter("value")}else if("newValue"in t.getParameters()){e=t.getParameter("newValue")}if("escPressed"in t.getParameters()){n=t.getParameter("escPressed")}const o=Vt.call(this);if(this._oNavigateCondition){o.setHighlightId();this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();if(this.getMaxConditionsForHelp()===1){o.setConditions([])}}if("previousValue"in t.getParameters()){i=t.getParameter("previousValue")}else{const t=this.getConditions();i=t[0]&&t[0].values[0]}if(o&&(!this.getContentFactory().isMeasure()||s.getShowValueHelp())){if(n){Pt.call(this,this.getConditions(),o);if(o.isOpen()){o.close();_t.call(this);this._sFilterValue=""}}else{const t=this.getSupportedOperators();let i=false;for(let e=0;e<t.length;e++){const n=p.getOperator(t[e]);if(n.validateInput){i=true;break}}if(i){this._bIgnoreInputValue=false;this._vLiveChangeValue=e;if(!this._fnLiveChangeTimer){R.call(this);this._fnLiveChangeTimer=b(()=>{const e=this.getDisplay();if(typeof this._vLiveChangeValue!=="undefined"){this._sFilterValue=""}if(this._vLiveChangeValue){const i=p.getEQOperator(t);const n=this.getContentFactory().getHideOperator();const s=n?false:i.test(this._vLiveChangeValue);const o=i.getValues(this._vLiveChangeValue,e,true,n);if(o){if(o[0]){this._sFilterValue=o[0]}else if(o[1]){this._sFilterValue=o[1]}}else{this._sFilterValue=""}if(s){this._bPreventAutocomplete=true}}const i=function(){if(Xt.call(this)){const t=o.isOpen();if(this.getMaxConditionsForHelp()===1&&o.getConditions().length>0){o.setConditions([])}o.setFilterValue(this._sFilterValue);if(!t){o.open(true)}else{Ot.call(this,false)}delete this._vLiveChangeValue}}.bind(this);if(this._bConnected&&this.getCurrentContent()[0]){o.requestShowTypeahead(S.Typing).then(t=>!!t&&i());delete this._vLiveChangeValue}},300,{leading:false,trailing:true})}o.requestShowTypeahead(S.Typing).then(t=>{if(Xt.call(this)&&this._fnLiveChangeTimer){this._fnLiveChangeTimer()}});this._fnLiveChangeTimer()}}}this._bDirty=true;this.fireLiveChange({value:e,escPressed:n,previousValue:i})}function _t(){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.cancel();delete this._vLiveChangeValue}}function Ft(t){const e=this.getFieldInfo();if(e){e.getTriggerHref().then(i=>{if(!i){e.open(this.getCurrentContent()[0],t);Z.call(this,true)}})}this.firePress()}function bt(t){if(t.getParameter("type")==="removed"){const e=t.getParameter("removedTokens");let i=this.getConditions();let n;let s;let o;for(o=0;o<e.length;o++){const t=e[o];const{sPath:n}=t.getBindingContext("$field");const s=parseInt(n.slice(n.lastIndexOf("/")+1));i[s].delete=true}for(o=i.length-1;o>=0;o--){if(i[o].delete){if(this.getContentFactory().isMeasure()){n=i[o].values[0][1];s=i[o].payload}i.splice(o,1)}}if(this.getContentFactory().isMeasure()&&n&&i.length===0){i=[d.createItemCondition([undefined,n],undefined,undefined,undefined,s)]}const a=Vt.call(this);let l;if(a?.isOpen()){l=new Promise((t,e)=>{setTimeout(()=>{this.setProperty("conditions",i,true);t(this.getResultForChangePromise(i))},0)})}else{this.setProperty("conditions",i,true)}j.call(this,i,true,undefined,l);t.preventDefault(true)}}function It(e,i){let n;if(i==="remove"){n=t.getElementById(e);if(n){Ut.call(this,n)}this.resetProperty("_valueHelpEnabled")}else if(i==="insert"){if(this._sDefaultValueHelp&&e!==this._sDefaultValueHelp){It.call(this,this._sDefaultValueHelp,"remove");delete this._sDefaultValueHelp}Tt.call(this,e);const t=this.getCurrentContent()[0];if(t&&t.setValueHelpIconSrc){t.setValueHelpIconSrc(this._getValueHelpIcon())}}Y.call(this,this.getConditions())}function Tt(e){if(e&&this.isPropertyInitial("_valueHelpEnabled")){const i=t.getElementById(e);if(i){if(i.getIcon()){this.setProperty("_valueHelpEnabled",true,true)}}}}async function Dt(t){if(await(Vt.call(this)?.requestShowValueHelp())){Et.call(this,t,false)}}N.prototype._getValueHelp=function(){return this.getValueHelp()||this.getFieldHelp&&this.getFieldHelp()};function Vt(){let e=this._getValueHelp();let i;if(!e&&this._sDefaultValueHelp){e=this._sDefaultValueHelp}if(e){i=t.getElementById(e)}return i}function Pt(t,e){if(!e){e=Vt.call(this)}let i;if(this.isInvalidInput()&&this.getMaxConditionsForHelp()===1){i=[]}else if(this.getContentFactory().isMeasure()){i=[];for(const e of t){if(e.values[0]&&e.values[0][1]){const t=d.createItemCondition(e.values[0][1],undefined,e.inParameters,e.outParameters,e.payload);i.push(t)}}}else{i=t}e.setConditions(i)}function Mt(){const t=this.getFormattingPromise();const e=t&&!this.getBusy();if(e){this.setBusy(true)}return t?.finally(()=>{if(e){this.setBusy(false)}})}async function Et(t,e){const i=Vt.call(this);if(i&&!this._oValueHelpRequestPromise){if(this._fnLiveChangeTimer){this._fnLiveChangeTimer.flush()}this._oValueHelpRequestPromise=Mt.call(this);await this._oValueHelpRequestPromise;if(!this.isFieldDestroyed()){if(!i.isOpen()){const e=t.getParameter?.("fromKeyboard");const n=i.isFocusInHelp();const s=this.getMaxConditionsForHelp();const o=t.srcControl||t.getSource();i.setFilterValue(this._sFilterValue);let a;if(this._oNavigateCondition&&s===1){a=[this._oNavigateCondition]}else if(this._bDirty&&s===1){a=[]}else{a=this.getConditions()}if(e&&this._sFilterValue&&!n){this._sFilterValue="";const t=o.getDOMValue?.();if(o.selectText&&t){o.selectText(0,t.length)}}Pt.call(this,a,i);this._bFocusOnValueHelp=e&&!n;if(!n){if(o.bValueHelpRequested){o.bValueHelpRequested=false}}}i.toggleOpen(!!e);this._oValueHelpRequestPromise=undefined}}}function Ot(t){this.getCurrentContent().forEach(e=>{if(e.closeValueStateMessage&&!t){e.closeValueStateMessage()}if(e.setShowValueStateMessage){e.setShowValueStateMessage(t)}})}function At(t){let e=this.getConditions();const i=t.getParameter("conditions");const n=t.getParameter("add");const s=t.getParameter("close");const o=t.oSource;const r=this.getMaxConditions();let h;const c=this.getControlForSuggestion();let g;let u=0;const f=this.getControlDelegate();if(this.getContentFactory().isMeasure()){if(i.length>1){throw new Error("Only one item must be selected! "+this)}if(i[0].operator!==l.EQ){throw new Error("Only EQ allowed! "+this)}if(e.length>0){for(u=0;u<e.length;u++){e[u].values[0][1]=i[0].values[0];if(e[u].operator===l.BT){e[u].values[1][1]=i[0].values[0]}if(i[0].inParameters){e[u].inParameters=i[0].inParameters}if(i[0].outParameters){e[u].outParameters=i[0].outParameters}if(i[0].payload){e[u].payload=i[0].payload}}}else{const t=p.getEQOperator(this.getSupportedOperators());const n=[null,i[0].values[0]];h=d.createCondition(t.name,[n],i[0].inParameters,i[0].outParameters,a.NotValidated,i[0].payload);e.push(h);const s=this.getContentFactory().getConditionType(true);const o=this.getContentFactory().getUnitConditionsType(true);if(s){g=s.formatValue(h)}else if(o){g=o.formatValue(e)}}}else{if(!n){e=[]}for(u=0;u<i.length;u++){h=i[u];if(!Jt.call(this,h.operator)){continue}const t=f.indexOfCondition(this,o,h,e);if(t===-1){e.push(h)}else if(h.validated===a.Validated&&h.values.length>1&&(e[t].values.length===1||h.values[1]!==e[t].values[1])){e[t].values=h.values}}}if(r>0&&r<e.length){e.splice(0,e.length-r)}let y=false;if(c&&c.setDOMValue){if(this.getMaxConditionsForHelp()===1&&e.length>0){if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitConditionsType(true)){g=this.getContentFactory().getUnitConditionsType().formatValue(e)}else if(this.getContentFactory().getConditionType(true)){g=this.getContentFactory().getConditionType().formatValue(e[0])}else if(this.getContentFactory().getConditionsType(true)){g=this.getContentFactory().getConditionsType().formatValue(e)}const t=function(t){const i=c.getDOMValue();c.setDOMValue("");c.setDOMValue(t);if(i!==t&&r===1){this.fireLiveChange({value:e[0].values[0]})}}.bind(this);if(g instanceof Promise){g.then(e=>{t(e)})}else{t(g)}this._sFilterValue=""}else if(s){c.setDOMValue("");this._sFilterValue="";this._bIgnoreInputValue=false;this._oFocusInHelp=undefined}else{this._bIgnoreInputValue=true}if(this.isInvalidInput()){this.resetInvalidInput(true);y=true}}const C=this.getConditions();if(!_(e,C)){this._oNavigateCondition=undefined;this.getContentFactory().updateConditionType();this.setProperty("conditions",e,true);if(!p.compareConditionsArray(e,C)){o.onControlChange();q.call(this,e,true)}}else if(y){q.call(this,e,true)}}function St(t){let e=t.getParameter("value");let i=t.getParameter("key");let n=t.getParameter("condition");let s=t.getParameter("itemId");const a=t.getParameter("leaveFocus");const l=t.getParameter("caseSensitive");if(!n&&i){n=d.createItemCondition(i,e)}let r;const h=this.getControlForSuggestion();const c=Vt.call(this);const g=c.isOpen();const u=this._vLiveChangeValue||this._sFilterValue;if(a){Zt(h,c);h.focus();if(u&&this._oNavigateCondition&&h.getDOMValue&&h.getDOMValue()!==this._oNavigateCondition.output){wt.call(this,this._oNavigateCondition,u,h,l);s=this._oNavigateCondition.itemId;this.fireLiveChange({value:this._oNavigateCondition.output})}Z.call(this,g,s);return}this._oNavigateCondition=xt.call(this,n,s);if(this._oNavigateCondition&&this.getMaxConditionsForHelp()===1){[i,e]=this._oNavigateCondition.values;c.setConditions([n])}this._bPreventGetDescription=true;this.getContentFactory().updateConditionType();if(this.getDisplay()!==o.Value){r=i}else if(e){r=e}else{r=i}if(h&&h.setDOMValue){let t;if(u&&this._oNavigateCondition){t=wt.call(this,this._oNavigateCondition,u,h,l);if(t){this._oNavigateCondition.output=t}}if(!t){if(this.getContentFactory().isMeasure()&&this.getContentFactory().getUnitConditionsType(true)&&this._oNavigateCondition){t=this.getContentFactory().getUnitConditionsType().formatValue([this._oNavigateCondition])}else if(this.getContentFactory().getConditionType(true)&&this._oNavigateCondition){t=this.getContentFactory().getConditionType().formatValue(this._oNavigateCondition)}else if(this.getContentFactory().getConditionsType(true)&&this._oNavigateCondition){t=this.getContentFactory().getConditionsType().formatValue([this._oNavigateCondition])}else{t=e||i}h.setDOMValue(t);if(h._doSelect){h._doSelect()}}if(c.isOpen()&&h.hasStyleClass("sapMFocus")){te(h,c)}}this._bPreventGetDescription=false;this.getContentFactory().updateConditionType();Z.call(this,g,s);this._bIgnoreInputValue=false;this._bDirty=true;this._oFocusInHelp=undefined;this.fireLiveChange({value:r})}function Ht(t){const e=t.getParameter("condition");const i=t.getParameter("filterValue");const n=t.getParameter("itemId");const s=t.getParameter("items");const o=t.getParameter("caseSensitive");const a=this.getControlForSuggestion();const l=this._vLiveChangeValue||this._sFilterValue;if(Xt.call(this)&&!this._bPreventAutocomplete&&e&&l===i&&a&&a.setDOMValue&&a.selectText&&(!a.isComposingCharacter||!a.isComposingCharacter())){const t=this.getContentFactory();const s=wt.call(this,e,i,a,o);if(s){const i=Vt.call(this);if(i?.isOpen()){Zt(a,i);i.setHighlightId(!this._bPreventAutocomplete&&n)}this._oNavigateCondition=xt.call(this,e,n);this._oNavigateCondition.output=s;t.updateConditionType();Z.call(this,true,null)}}if(a?._applySuggestionAcc){a._applySuggestionAcc(s)}}function xt(t,e){const i=p.getEQOperator(this.getSupportedOperators());let n;if(t){n=F({},t);n.operator=i.name;const s=t.values[0];if(this.getContentFactory().isMeasure()){const t=this.getConditions();if(t.length>0){n.operator=t[0].operator;n.values[0]=[t[0].values[0][0],s];if(t[0].operator===l.BT){n.values[1]=[t[0].values[1][0],n.values[0][1]]}else if(n.values.length>1){n.values.splice(1)}}else{n.values=[[null,s]]}}n.itemId=e}return n}function wt(t,e,i,n){const s=this.getContentFactory();const o=s.isMeasure();const a=this.getControlDelegate();let l;const r=s.getAdditionalDataType();if(o){const t=this.getContentFactory().getCompositeTypes();if(t&&t.length>1){l=t[1]}}else{l=s.getDataType()}let h;let c;if(l){h=l.formatValue(t.values[0],"string")}else{h=t.values[0]}if(t.values.length>1){if(r){c=r.formatValue(t.values[1],"string")}else{c=t.values[1]}}const g=!!h&&a.isInputMatchingText(this,e,h,false,n);const u=!!c&&a.isInputMatchingText(this,e,c,true,n);let p=a.getAutocompleteOutput(this,t,h,c,g,u);if(p){p=typeof p==="string"?e+p.substr(e.length):e;i.setDOMValue(p);i.focus();i.selectText(e.length,p.length)}return p}function Nt(t){const e=this.getControlForSuggestion();if(this._bIgnoreInputValue){this._bIgnoreInputValue=false;e.setDOMValue("");this._sFilterValue="";this.getContentFactory().updateConditionType();if(this.getMaxConditions()!==1){this._oManagedObjectModel.checkUpdate(true)}}Ot.call(this,true);Z.call(this,false);const i=t.getSource();if(!this._oNavigateCondition){const t=this.getConditions();Pt.call(this,t,i)}if(Xt.call(this)){Zt(e,i)}else if(this._oFocusInHelp){e.onsapfocusleave(this._oFocusInHelp)}delete this._bFocusOnValueHelp}function Bt(t){let e;const i=this.getControlForSuggestion();if(this._bFocusOnValueHelp){const n=t.getSource();te(i,n);if(this.getMaxConditionsForHelp()===1||this._sFilterValue){e=t.getParameter("itemId")}if(!this._sFilterValue&&!this._oNavigateCondition&&(this._bDirty||this.getConditions().length===0)){n.navigate(0)}}Z.call(this,true,e);Ot.call(this,false);delete this._bFocusOnValueHelp;const n=t.getParameter("items");if(n&&i?._applySuggestionAcc){i._applySuggestionAcc(n)}}function Lt(t){const e=this.getControlForSuggestion();te(e)}function kt(t){const e=this.getControlForSuggestion();e.focus();if(e.fireValueHelpRequest){e.bValueHelpRequested=true;e.fireValueHelpRequest()}}function Rt(t){const e=Vt.call(this);Ut.call(this,e)}function Ut(t){if(this._bConnected){t.detachEvent("select",At,this);t.detachEvent("navigated",St,this);t.detachEvent("disconnect",Rt,this);t.detachEvent("afterClose",Nt,this);t.detachEvent("switchToValueHelp",kt,this);t.detachEvent("closed",Nt,this);t.detachEvent("opened",Bt,this);t.detachEvent("typeaheadSuggested",Ht,this);t.detachEvent("visualFocusSet",Lt,this);this._bConnected=false}}function qt(){const t=Vt.call(this);if(t){let e;const i=this.getContentFactory().isMeasure();if(i){const t=this.getContentFactory().getCompositeTypes();if(t&&t.length>1){e=t[1]}}else{e=this.getContentFactory().getDataType()}const n={maxConditions:this.getMaxConditions(),dataType:e,additionalDataType:this.getContentFactory().getAdditionalDataType(),operators:this.getSupportedOperators(),display:i?o.Value:this.getDisplay(),delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null};t.connect(this,n);if(!this._bConnected){this._bConnected=true;t.attachEvent("select",At,this);t.attachEvent("navigated",St,this);t.attachEvent("disconnect",Rt,this);t.attachEvent("afterClose",Nt,this);t.attachEvent("switchToValueHelp",kt,this);t.attachEvent("closed",Nt,this);t.attachEvent("opened",Bt,this);t.attachEvent("typeaheadSuggested",Ht,this);t.attachEvent("visualFocusSet",Lt,this);const e=this.getConditions();Pt.call(this,e,t);if(t._bIsDefaultHelp){this.getContentFactory().updateDefaultValueHelpTitle(t,this.getLabel())}}}}function jt(e){const i=Vt.call(this);const n=this.getCurrentContent();const s=this.getControlForSuggestion();const o=e.srcControl;if(n.length>1||i&&s===o){const a=t.getElementById(e.relatedControlId);if(a){if(n.indexOf(a)>=0){e.stopPropagation();R.call(this);_t.call(this)}else if(i&&s===o){if(I(i.getDomRef(),a.getFocusDomRef())){e.stopPropagation();e.stopImmediatePropagation(true);if(s.bValueHelpRequested){s.bValueHelpRequested=false}if(this._sFilterValue){s.setDOMValue(this._sFilterValue)}this._oFocusInHelp=e}else{i.skipOpening()}}}}}function $t(t){if(Vt.call(this)){t.stopImmediatePropagation(true)}}N.prototype._getValueHelpIcon=function(){const t=Vt.call(this);if(t){return t.getIcon()}};function Gt(t,e){if(e==="remove"){t.detachEvent("dataUpdate",zt,this)}else if(e==="insert"){t.attachEvent("dataUpdate",zt,this);zt.call(this)}}function zt(){const t=this.getFieldInfo();const e=this;t.isTriggerable().then(i=>{e._bTriggerable=i;let n=e.getAggregation("_content",[]);if(n.length>0&&e.getEditMode()===s.Display){ot.call(e);if(e._bTriggerable){n=e.getAggregation("_content",[]);const i=n[0];t.getDirectLinkHrefAndTarget().then(t=>{u._updateLink(i,t)})}}})}N.prototype.getFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=Qt.bind(this)}return{valueType:this.getContentFactory().retrieveDataType(),originalDateType:this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType(),additionalType:this.getContentFactory().getUnitType(),compositeTypes:this.getContentFactory().getCompositeTypes(),additionalValueType:this.getContentFactory().retrieveAdditionalDataType(),additionalCompositeTypes:this.getContentFactory().getAdditionalCompositeTypes(),display:this.getContentFactory().isMeasure()?o.Value:this.getDisplay(),valueHelpID:this.getContentFactory().isMeasure()?undefined:this._getValueHelp()||this._sDefaultValueHelp,operators:this.getSupportedOperators(),hideOperator:this.getContentFactory().getHideOperator(),maxConditions:this.getMaxConditions(),bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,convertWhitespaces:this.getEditMode()===s.Display||this.getMaxConditions()!==1,control:this,defaultOperatorName:this.getDefaultOperator?this.getDefaultOperator():null,getConditions:this.getConditions.bind(this),noFormatting:this.getContentFactory().getNoFormatting(),keepValue:this._bIgnoreInputValue?this._sFilterValue:null,multipleLines:this.getMultipleLines()}};N.prototype.checkValueInitial=function(t){if(t===null||t===undefined){return true}if(t===""||typeof t==="string"&&t.match(/^0+$/)){const e=this.getContentFactory().retrieveDataType();const i=e.parseValue("","string");if(i===t){return true}else{try{e.validateValue(i)}catch(t){return true}}}else{const e=Q.call(this);if(this.getTypeMap().getBaseType(e)===n.Unit&&Array.isArray(t)&&t.length>1&&(t[0]===undefined||t[0]===null)&&!t[1]){return true}}return false};N.prototype.getUnitFormatOptions=function(){if(!this._asyncParsingCall){this._asyncParsingCall=Qt.bind(this)}return{valueType:this.getContentFactory().getUnitType(),originalDateType:this.getContentFactory().getDateOriginalType()||this.getContentFactory().getUnitOriginalType(),additionalType:this.getContentFactory().retrieveDataType(),compositeTypes:this.getContentFactory().getCompositeTypes(),additionalValueType:this.getContentFactory().retrieveAdditionalDataType(),additionalCompositeTypes:this.getContentFactory().getAdditionalCompositeTypes(),display:this.getDisplay(),valueHelpID:this._getValueHelp()||this._sDefaultValueHelp,operators:[l.EQ],hideOperator:true,maxConditions:1,bindingContext:this.getBindingContext(),asyncParsing:this._asyncParsingCall,navigateCondition:this._oNavigateCondition,delegate:this.getControlDelegate(),delegateName:this.getDelegate()&&this.getDelegate().name,payload:this.getPayload(),preventGetDescription:this._bPreventGetDescription,convertWhitespaces:this.getEditMode()===s.Display||this.getEditMode()===s.EditableDisplay,control:this,getConditions:this.getConditions.bind(this),noFormatting:false,multipleLines:false}};function Qt(t){const e=Vt.call(this);if(e&&e.isOpen()&&(Xt.call(this)||Xt.call(e))){e.close()}const i={};const n=new Promise((e,n)=>{i.resolve=e;i.reject=n;t.then(t=>{i.result=t;this.resetInvalidInput();const e=this.getConditions();if(_(t,e)){Kt.call(this,i);Yt.call(this,i)}else{i.waitForUpdate=true}}).catch(t=>{if(t&&!(t instanceof V)&&!(t instanceof D)&&!(t instanceof P)){throw t}const e=this.getControlForSuggestion();this._setInvalidInput(t,undefined,"AsyncParsing",e);n(t);Yt.call(this,i)})});i.promise=n;this._aAsyncChanges.push(i)}function Wt(){const t=[];for(let e=0;e<this._aAsyncChanges.length;e++){t.push(this._aAsyncChanges[e].promise)}if(t.length>0){return Promise.all(t).then(()=>this.getResultForChangePromise(this.getConditions()))}return null}N.prototype.getResultForChangePromise=function(t){return t};function Kt(t){if(this._aAsyncChanges.length<=1){this._bDirty=false}t.resolve(this.getResultForChangePromise(t.result))}function Yt(t){let e=false;let i=0;for(i=0;i<this._aAsyncChanges.length;i++){if(t===this._aAsyncChanges[i]){e=true;break}}if(e){this._aAsyncChanges.splice(i,1)}if(this._aAsyncChanges.length===0){this._bDirty=false}return e}N.prototype.getSupportedOperators=function(){let t;if(this.isSearchField()){t=[l.Contains]}else{let e=this.getBaseType();if(e===n.Unit){e=n.Numeric}t=p.getOperatorsForType(e)}this.setProperty("_operators",t,true);return t};N.prototype.isSearchField=function(){{let t=false;const e=this.getFieldPath();if(e){const i=new RegExp("^\\*(.*)\\*|\\$search$");t=i.test(e)&&this.getMaxConditions()===1}return t}};function Jt(t){const e=this.getSupportedOperators();for(let i=0;i<e.length;i++){if(t===e[i]){return true}}return false}N.prototype.isFieldPropertyInitial=function(t){if(this.isBound(t)&&!this.getBinding(t)){return!Object.hasOwn(this.mProperties,t)}else{return this.isPropertyInitial(t)}};N.prototype.isFieldDestroyed=function(){return this.isDestroyed()||this.isDestroyStarted()};N.prototype.hasPendingUserInput=function(){return!!this._bDirty};N.prototype.getAdditionalDataTypeConfiguration=function(){return null};N.prototype.getFormattingPromise=function(){return undefined};function Xt(){const t=document.activeElement;return t&&I(this.getDomRef(),t)}function Zt(t,e){t.addStyleClass("sapMFocus");e?.removeVisualFocus()}function te(t,e){t.removeStyleClass("sapMFocus");e?.setVisualFocus()}return N});
//# sourceMappingURL=FieldBase.js.map