/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/mdc/enums/FieldEditMode","sap/ui/mdc/enums/ContentMode","sap/ui/mdc/util/loadModules","sap/ui/mdc/field/content/DefaultContent","sap/ui/mdc/field/content/SearchContent","sap/ui/mdc/field/content/DateContent","sap/ui/mdc/field/content/TimeContent","sap/ui/mdc/field/content/DateTimeContent","sap/ui/mdc/field/content/LinkContent","sap/ui/mdc/field/content/BooleanContent","sap/ui/mdc/field/content/UnitContent","sap/ui/mdc/field/ConditionType","sap/ui/mdc/field/ConditionsType","sap/ui/base/SyncPromise"],(t,e,n,i,o,s,a,r,p,d,l,y,u,c,f)=>{"use strict";const h=t.extend("sap.ui.mdc.field.content.ContentFactory",{metadata:{library:"sap.ui.mdc"},constructor:function(e,n){this.init();this._oField=n?n.field:null;this._fnHandleTokenUpdate=n?n.handleTokenUpdate:null;this._fnHandleContentChange=n?n.handleContentChange:null;this._fnHandleContentLiveChange=n?n.handleContentLiveChange:null;this._fnHandleValueHelpRequest=n?n.handleValueHelpRequest:null;this._fnHandleEnter=n?n.handleEnter:null;this._fnHandleContentPress=n?n.handleContentPress:null;t.prototype.constructor.apply(this,arguments)}});const C={Default:o,Search:s,Date:a,Time:r,DateTime:p,Link:d,Boolean:l,Unit:y};let g;h._init=function(){if(g&&g.bool&&g.bool.control){g.bool.control.destroy()}if(g&&g.defineConditions&&g.defineConditions.control){g.defineConditions.control.destroy()}g={bool:{modules:["sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Popover","sap/ui/mdc/valuehelp/content/Bool"],id:"BoolDefaultHelp",contentProperties:{},dialog:false,control:undefined,updateTitle:function(t,e){t.getTypeahead().setTitle(e)}},defineConditions:{modules:["sap/ui/mdc/ValueHelp","sap/ui/mdc/valuehelp/Dialog","sap/ui/mdc/valuehelp/content/Conditions"],id:"Field-DefineConditions-Help",contentProperties:{},dialog:true,control:undefined,updateTitle:function(t,e){t.getDialog().setTitle(e);t.getDialog().getContent()[0].setLabel(e)}}}};h._init();h.prototype.init=function(){this._oContentTypeClass=undefined;this._sOperator=undefined;this._bNoFormatting=false;this._bHideOperator=false};h.prototype.exit=function(){this._oField=undefined;this._fnHandleTokenUpdate=undefined;this._fnHandleContentChange=undefined;this._fnHandleContentLiveChange=undefined;this._fnHandleValueHelpRequest=undefined;this._fnHandleEnter=undefined;this._fnHandleContentPress=undefined;this._oContentTypeClass=undefined;this._sOperator=undefined;if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy();this._oConditionType=undefined}if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy();this._oConditionsType=undefined}};h.prototype.destroy=function(){t.prototype.destroy.apply(this,arguments);this.exit()};h.prototype.createContent=function(t,e,n,o){const s=this._sOperator;let a=t.getControlNames(e,s);const r=o&&t.getUseDefaultValueHelp().name;const p=r&&g[r];let d;this.setNoFormatting(t.getNoFormatting(e));if(a.every(t=>!t)){return Promise.resolve([])}if(!this.getDataType()){let t=this.getField().getDataType();if(t){t=this.getField().getTypeMap().getDataTypeClassName(t);a.push(t.replaceAll(".","/"))}}if(p){if(p.control&&p.control.isDestroyed()){p.control=undefined}if(!p.control){a=a.concat(p.modules)}}try{d=i(a).catch(t=>{throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:createContent function call - could not load data type "+JSON.stringify(a))}).then(i=>{if(this.getField()&&!this.getField().isFieldDestroyed()){const o=_.call(this,p,i);this.updateConditionType();const a=t.create(this,e,s,i,n);if(o){a.push(o)}for(const t of a){t._bByContentFactory=true}return a}else{return[]}}).unwrap()}catch(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+t.message+"'")}if(d.then){d.catch(t=>{throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:createContent function call ErrorMessage: '"+t.message+"'")});return d}return f.resolve(d)};h.prototype.getContentMode=function(t,i,o,s,a){let r=n.Edit;if(i===e.Display){if(o!==1){r=n.DisplayMultiValue}else if(s){r=n.DisplayMultiLine}else{r=n.Display}}else if(o!==1){r=n.EditMultiValue}else if(s){r=n.EditMultiLine}else if(this.getField()._getValueHelp()){r=n.EditForHelp}else if(a.length===1&&t.getEditOperator()&&t.getEditOperator()[a[0]]){this._sOperator=a[0];r=n.EditOperator}return r};h.prototype.getContentType=function(t,e,n){const i=this.getField();let o=C[t]?C[t]:null;if(!o){if(i.isSearchField()){o=C.Search}else{o=C.Default}}if(i.getFieldInfo()&&n){o=C.Link.extendBaseContent(o)}return o};h._updateLink=function(t,e){if(e){t.setHref(e.href);t.setTarget(e.target)}};h._getEnabled=function(t){return t&&t!==e.Disabled};h._getEditable=function(t){return t===e.Editable||t===e.EditableReadOnly||t===e.EditableDisplay};h._getDisplayOnly=function(t){return t&&t!==e.Editable};h._getEditableUnit=function(t){return t===e.Editable};h.prototype.getField=function(){return this._oField};h.prototype.getValueHelpIcon=function(){return this.getField()._getValueHelpIcon()};h.prototype.getHandleTokenUpdate=function(){return this._fnHandleTokenUpdate};h.prototype.getHandleContentChange=function(){return this._fnHandleContentChange};h.prototype.getHandleContentLiveChange=function(){return this._fnHandleContentLiveChange};h.prototype.getHandleValueHelpRequest=function(){return this._fnHandleValueHelpRequest};h.prototype.getHandleEnter=function(){return this._fnHandleEnter};h.prototype.getHandleContentPress=function(){return this._fnHandleContentPress};h.prototype.setAriaLabelledBy=function(t){if(t.addAriaLabelledBy){const e=this.getField().getAriaLabelledBy();for(const n of e){t.addAriaLabelledBy(n)}}};h.prototype.setHideOperator=function(t){this._bHideOperator=t};h.prototype.getHideOperator=function(){return this._bHideOperator};function T(t,e,n,i){if(!i){if(this[t]&&this[t].getMetadata().getName()!==e.getMetadata().getName()){this[t].destroy();this[t]=undefined}if(!this[t]){const i=n();this[t]=new e(i);this[t]._bCreatedByField=true}}return this[t]}h.prototype.getConditionType=function(t){return T.call(this,"_oConditionType",u,this.getField().getFormatOptions.bind(this.getField()),t)};h.prototype.setConditionType=function(t){this._oConditionType=t};h.prototype.getConditionsType=function(t,e){const n=e||c;return T.call(this,"_oConditionsType",n,this.getField().getFormatOptions.bind(this.getField()),t)};h.prototype.setConditionsType=function(t){this._oConditionsType=t};h.prototype.getUnitConditionsType=function(t){return T.call(this,"_oUnitConditionsType",c,this.getField().getUnitFormatOptions.bind(this.getField()),t)};h.prototype.getContentConditionTypes=function(){return this._oContentConditionTypes};h.prototype.setContentConditionTypes=function(t){this._oContentConditionTypes=t};h.prototype._setUsedConditionType=function(t,n,o,s){if(this._oConditionType&&!this._oConditionType._bCreatedByField){this._oConditionType=undefined}if(this._oConditionsType&&!this._oConditionsType._bCreatedByField){this._oConditionsType=undefined}let a;let r;if(t){if(this._oContentConditionTypes.content){a=this._oContentConditionTypes.content.oConditionType;r=this._oContentConditionTypes.content.oConditionsType}}else if(s===e.Display&&o){if(this._oContentConditionTypes.contentDisplay){a=this._oContentConditionTypes.contentDisplay.oConditionType;r=this._oContentConditionTypes.contentDisplay.oConditionsType}}else if(s!==e.Display&&n){if(this._oContentConditionTypes.contentEdit){a=this._oContentConditionTypes.contentEdit.oConditionType;r=this._oContentConditionTypes.contentEdit.oConditionsType}}else if(this._oContentConditionTypes?._content){a=this._oContentConditionTypes._content.oConditionType;r=this._oContentConditionTypes._content.oConditionsType}if(a){if(this._oConditionType&&this._oConditionType._bCreatedByField){this._oConditionType.destroy()}this._oConditionType=a}if(r){if(this._oConditionsType&&this._oConditionsType._bCreatedByField){this._oConditionsType.destroy()}this._oConditionsType=r}if(a||r){if(!this.getDataType()){let t=this.getField().getDataType();if(t){t=this.getField().getTypeMap().getDataTypeClassName(t);t=t.replaceAll(".","/");try{i([t]).catch(e=>{throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:_setUsedConditionType function call - could not load controls "+t)}).then(t=>{if(this.getField()&&!this.getField().isFieldDestroyed()){this.updateConditionType()}}).unwrap()}catch(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:_setUsedConditionType function call ErrorMessage: '"+t.message+"'")}}}else{this.updateConditionType()}}};h.prototype.getDataType=function(){return this._oDataType};h.prototype.setDataType=function(t){this._oDataType=t};h.prototype.checkDataTypeChanged=function(t){t=this.getField().getTypeMap().getDataTypeClassName(t);try{return i([t.replaceAll(".","/")]).catch(e=>{throw new Error("loadModules promise rejected in sap.ui.mdc.field.content.ContentFactory:checkDataTypeChanged function call - could not load data type "+t)}).then(e=>!this._oDataType||this._oDataType.getMetadata().getName()!==t)}catch(t){throw new Error("Error in sap.ui.mdc.field.content.ContentFactory:checkDataTypeChanged function call ErrorMessage: '"+t.message+"'")}};h.prototype.retrieveDataType=function(){if(!this._oDataType){const t=this.getField().getDataType();if(typeof t==="string"){this._oDataType=this.getField().getTypeMap().getDataTypeInstance(t,this.getField().getDataTypeFormatOptions(),this.getField().getDataTypeConstraints());this._oDataType._bCreatedByField=true}}return this._oDataType};h.prototype.getAdditionalDataType=function(){return this._oAdditionalDataType};h.prototype.setAdditionalDataType=function(t){this._oAdditionalDataType=t};h.prototype.retrieveAdditionalDataType=function(){if(!this._oAdditionalDataType){const t=this.getField().getAdditionalDataTypeConfiguration();if(t){if(t.isA&&t.isA("sap.ui.model.Type")){this._oAdditionalDataType=t}else if(t.name){this._oAdditionalDataType=this.getField().getTypeMap().getDataTypeInstance(t.name,t.formatOptions,t.constraints);this._oAdditionalDataType._bCreatedByField=true}}}return this._oAdditionalDataType};h.prototype.getDateOriginalType=function(){return this._oDateOriginalType};h.prototype.setDateOriginalType=function(t){this._oDateOriginalType=t};h.prototype.getUnitOriginalType=function(){return this._oUnitOriginalType};h.prototype.setUnitOriginalType=function(t){this._oUnitOriginalType=t};h.prototype.getUnitType=function(){return this._oUnitType};h.prototype.setUnitType=function(t){this._oUnitType=t};h.prototype.getCompositeTypes=function(){return this._aCompositeTypes};h.prototype.setCompositeTypes=function(t){this._aCompositeTypes=t};h.prototype.getAdditionalCompositeTypes=function(){return this._aAdditionalCompositeTypes};h.prototype.setAdditionalCompositeTypes=function(t){this._aAdditionalCompositeTypes=t};h.prototype.isMeasure=function(){return this._bIsMeasure};h.prototype.setIsMeasure=function(t){this._bIsMeasure=t};h.prototype.getDisplayFormat=function(){return this._sDisplayFormat};h.prototype.setDisplayFormat=function(t){this._sDisplayFormat=t};h.prototype.getValueFormat=function(){return this._sValueFormat};h.prototype.setValueFormat=function(t){this._sValueFormat=t};h.prototype.getCalendarType=function(){return this._sCalendarType};h.prototype.setCalendarType=function(t){this._sCalendarType=t};h.prototype.getSecondaryCalendarType=function(){return this._sSecondaryCalendarType};h.prototype.setSecondaryCalendarType=function(t){this._sSecondaryCalendarType=t};h.prototype.getFieldTypeInitialization=function(){return this.getField()._oTypeInitialization};h.prototype.updateConditionType=function(){const t=this._oConditionType;const e=this._oConditionsType;if(t||e){let n=this.getField().getFormatOptions();if(t){t.setFormatOptions(n)}if(e){e.setFormatOptions(n)}if(this._oUnitConditionsType){n=this.getField().getUnitFormatOptions();this._oUnitConditionsType.setFormatOptions(n)}}};h.prototype.setNoFormatting=function(t){this._bNoFormatting=t};h.prototype.getNoFormatting=function(){return this._bNoFormatting};h.prototype.getProvideDefaultValueHelp=function(t,n,i,o,s){const a=t.getUseDefaultValueHelp();if(a&&i!==e.Display){if(o===1&&a.single||o!==1&&a.multi){if(n.length===1){if(o===1){if(!(t.getEditOperator()&&t.getEditOperator()[n[0]])&&(a.oneOperatorSingle||!s)){return true}}else if(a.oneOperatorMulti||!s){return true}}else{return true}}}return false};h.prototype.updateDefaultValueHelpTitle=function(t,e){for(const n in g){if(g[n].control===t){g[n].updateTitle(t,e);break}}};function _(t,e){if(t&&!t.control){const n=e[e.length-3];const i=e[e.length-2];const o=e[e.length-1];const s=new n(t.id,{delegate:{name:"sap/ui/mdc/ValueHelpDelegate",payload:{isDefaultHelp:true}}});const a=new i(t.id+"-container",{content:[new o(t.id+"-content",t.contentProperties)]});s._bIsDefaultHelp=true;t.control=s;if(t.dialog){s.setDialog(a)}else{s.setTypeahead(a)}}return t?.control}return h});
//# sourceMappingURL=ContentFactory.js.map