/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/Lib","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/core/library","sap/ui/core/ShortcutHintsMixin","sap/ui/Device","sap/ui/mdc/Control","sap/base/Log","sap/base/util/merge","sap/ui/model/base/ManagedObjectModel","sap/ui/base/ManagedObjectObserver","sap/ui/mdc/condition/ConditionModel","sap/ui/mdc/condition/Condition","sap/ui/mdc/condition/ConditionConverter","sap/ui/mdc/util/IdentifierUtil","sap/ui/mdc/util/FilterUtil","sap/ui/mdc/filterbar/PropertyHelper","sap/ui/mdc/enums/ReasonMode","sap/ui/mdc/enums/FilterBarValidationStatus","sap/ui/mdc/enums/OperatorName","sap/m/library","sap/m/Button","./FilterBarBaseRenderer","sap/ui/mdc/FilterField","sap/ui/mdc/filterbar/PropertyInfoValidator"],(e,t,i,r,n,o,s,a,l,h,d,p,c,u,g,f,_,y,m,F,C,I,b,S,P)=>{"use strict";let A;const{ValueState:v}=r;const M="$search";const E=s.extend("sap.ui.mdc.filterbar.FilterBarBase",{metadata:{library:"sap.ui.mdc",designtime:"sap/ui/mdc/designtime/filterbar/FilterBarBase.designtime",defaultAggregation:"filterItems",interfaces:["sap.ui.mdc.IFilterSource","sap.ui.mdc.IFilter","sap.ui.mdc.IxState"],properties:{delegate:{type:"object",defaultValue:{name:"sap/ui/mdc/FilterBarDelegate",payload:{modelName:undefined,collectionName:""}}},liveMode:{type:"boolean",defaultValue:false},showMessages:{type:"boolean",group:"Misc",defaultValue:true},showGoButton:{type:"boolean",defaultValue:true},filterConditions:{type:"object",defaultValue:{}},propertyInfo:{type:"object",defaultValue:[]},suspendSelection:{type:"boolean",defaultValue:false},_filterCount:{type:"string",visibility:"hidden"}},aggregations:{filterItems:{type:"sap.ui.mdc.FilterField",multiple:true},basicSearchField:{type:"sap.ui.mdc.FilterField",multiple:false},layout:{type:"sap.ui.mdc.filterbar.IFilterContainer",multiple:false,visibility:"hidden"}},associations:{variantBackreference:{type:"sap.ui.fl.variants.VariantManagement",multiple:false}},events:{search:{parameters:{reason:{type:"sap.ui.mdc.enums.ReasonMode"}}},filtersChanged:{parameters:{conditionsBased:{type:"boolean"},filtersText:{type:"string"},filtersTextExpanded:{type:"string"}}}}},renderer:b});const{ButtonType:N}=C;E.INNER_MODEL_NAME="$sap.ui.filterbar.mdc.FilterBarBase";E.CONDITION_MODEL_NAME="$filters";E.prototype.init=function(){s.prototype.init.apply(this,arguments);this._oRb=t.getResourceBundleFor("sap.ui.mdc");this._createInnerModel();this._oObserver=new d(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["filterItems","basicSearchField"]});this._createInnerLayout();this.getEngine().register(this,{controller:{Filter:new i({control:this})}});this._fResolveInitialFiltersApplied=undefined;this._oInitialFiltersAppliedPromise=new Promise(e=>{this._fResolveInitialFiltersApplied=e});this._bIgnoreChanges=false;this._aOngoingChangeAppliance=[];this._bSearchTriggered=false;this._bIgnoreQueuing=false};E.prototype._createInnerLayout=function(){this._cLayoutItem=null;this._oFilterBarLayout=null;this._btnAdapt=null;this.setAggregation("layout",this._oFilterBarLayout,true)};E.prototype._isPhone=function(){return o.system.phone?true:false};E.prototype._isLiveMode=function(){if(this._isPhone()){return false}return this.getLiveMode()};E.prototype._getConditionModel=function(){return this._oConditionModel};E.prototype._getSearchButton=function(){if(!this._btnSearch){this._btnSearch=new I(this.getId()+"-btnSearch",{text:this._oRb.getText("filterbar.GO"),press:this.onSearch.bind(this),type:N.Emphasized});n.addConfig(this._btnSearch,{addAccessibilityLabel:true,message:this._oRb.getText("filterbar.GoBtnShortCutHint")},this)}return this._btnSearch};E.prototype.getConditionModelName=function(){return this._getConditionModelName()};E.prototype._getConditionModelName=function(){return E.CONDITION_MODEL_NAME};E.prototype._createConditionModel=function(){this._oConditionModel=new p;this.setModel(this._oConditionModel,this._getConditionModelName())};E.prototype.applySettings=function(e,t){this._setPropertyHelperClass(_);this._setupPropertyInfoStore("propertyInfo");if(e?.propertyInfo&&e?.filterItems&&Array.isArray(e.filterItems)){this._validatePropertyInfos(e.propertyInfo,e.filterItems)}this._applySettings(e,t);Promise.all([this.awaitPropertyHelper()]).then(()=>{if(!this._bIsBeingDestroyed){this._applyInitialFilterConditions();this.getFilterItems().forEach(e=>{this._enhanceFilterField(e)});const e=this.getBasicSearchField();if(e){this._enhanceBasicSearchField(e)}}})};E.prototype._validatePropertyInfos=function(e,t){t.forEach(t=>{const i=t.getPropertyKey();const r=e=>e.name===i;if(i&&e.some(r)){const i=e.find(r);P.comparePropertyInfoWithControl(t,i)}})};E.prototype._applySettings=function(e,t){s.prototype.applySettings.apply(this,arguments);this._createConditionModel();this._oConditionModel.attachPropertyChange(this._handleConditionModelPropertyChange,this)};E.prototype._waitForMetadata=function(){return this._retrieveMetadata().then(()=>{this._applyInitialFilterConditions()})};E.prototype.setIgnoreQueuing=function(e){this._bIgnoreQueuing=e};E.prototype.getIgnoreQueuing=function(){return this._bIgnoreQueuing};E.prototype.setSuspendSelection=function(e){this.setProperty("suspendSelection",e);if(!e){if(this._bSearchTriggered&&!this.getIgnoreQueuing()){this.triggerSearch()}this._bSearchTriggered=false;this.setIgnoreQueuing(false)}return this};E.prototype._createInnerModel=function(){this._oModel=new h(this);this.setModel(this._oModel,E.INNER_MODEL_NAME);return this};E.prototype.getCurrentState=function(){const e={};e.filter=l({},this.getFilterConditions());const t=this.getFilterItems();const i=[];t.forEach(e=>{const t=e.getPropertyKey();i.push({key:t,name:t})});e.items=i;return e};E.prototype.getAssignedFilterNames=function(){let e,t=null;const i=this._getConditionModel();if(i){t=[];const r=i.getConditions(M);if(r&&r.length>0){t.push(this._oRb.getText("filterbar.ADAPT_SEARCHTERM"))}this._getNonHiddenPropertyInfoSet().forEach(r=>{e=g.getPropertyKey(r);const n=i.getConditions(e);if(n&&n.length>0){t.push(r.label||e)}})}return t};E.prototype._getAssignedFiltersText=function(){const e={};e.filtersText=this._getAssignedFiltersCollapsedText(this.getAssignedFilterNames());e.filtersTextExpanded=this._getAssignedFiltersExpandedText();return e};E.prototype._getAssignedFiltersExpandedText=function(){let e=0,t=0;const i=this._getConditionModel();if(i){const r=i.getAllConditions();for(const i in r){const n=this._getPropertyByName(i);if(n&&!n.hiddenFilter&&r[i].length>0){++e;if(!(i===M&&this.getAggregation("basicSearchField")||this._getFilterField(i))){++t}}}}if(!e&&!t){return this._oRb.getText("filterbar.ADAPT_NOTFILTERED")}if(!t){if(e===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_NON_HIDDEN",[e])}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_NON_HIDDEN",[e])}if(e===1){return this._oRb.getText("filterbar.ADAPT_FILTER_WITH_HIDDEN",[e,t])}return this._oRb.getText("filterbar.ADAPT_FILTERS_WITH_HIDDEN",[e,t])};E.prototype._getAssignedFiltersCollapsedText=function(e){let t;e=e||[];if(e.length){t=Object.keys(e).map(t=>e[t]).join(", ");if(e.length===1){return this._oRb.getText("filterbar.ADAPT_FILTER_COLLAPSED",[e.length,t])}return this._oRb.getText("filterbar.ADAPT_FILTERS_COLLAPSED",[e.length,t])}return this._oRb.getText("filterbar.ADAPT_NOTFILTERED")};E.prototype.getAssignedFiltersText=function(){return this._getAssignedFiltersText()};E.prototype._reportModelChange=function(e){if(e.triggerFilterUpdate){this._handleAssignedFilterNames(false)}if(this.getLiveMode()||e.triggerSearch||this._bExecuteOnSelect){this._bExecuteOnSelect=false;this.triggerSearch()}else if(e.recheckMissingRequired){this._recheckMissingRequiredFields()}};E.prototype.getPropertyInfoSet=function(){return this.getPropertyHelper()?this.getPropertyHelper().getProperties():[]};E.prototype._addConditionChange=function(e){this._aOngoingChangeAppliance.push(this.getEngine().createChanges({control:this,applySequentially:true,applyAbsolute:true,key:"Filter",state:e}))};E.prototype._handleConditionModelPropertyChange=function(e){let t;const i=function(e,t){const i={};i[e]=this._stringifyConditions(e,l([],t));this._cleanupConditions(i[e]);return i}.bind(this);if(!this._bIgnoreChanges&&!e.getParameter("_descriptionOnly")){const r=e.getParameter("path");if(r.indexOf("/conditions/")===0){const n=r.substring("/conditions/".length);const o=e.getParameter("value");if(this._getPropertyByName(n)){t=i(n,o)}else{t=this._retrieveMetadata().then(()=>i(n,o))}}}if(t){this._addConditionChange(t)}};E.prototype._toExternal=function(e,t){let i=l({},t);i=u.toString(i,e.typeConfig.typeInstance,this.getTypeMap());this._cleanupCondition(i);this._convertInOutParameters(t,i,"inParameters",u.toString);this._convertInOutParameters(t,i,"outParameters",u.toString);return i};E.prototype._toInternal=function(e,t){let i=l({},t);i=u.toType(i,e.typeConfig.typeInstance,this.getTypeMap());this._convertInOutParameters(t,i,"inParameters",u.toType);this._convertInOutParameters(t,i,"outParameters",u.toType);return i};E.prototype._convertInOutParameters=function(e,t,i,r){if(e[i]&&Object.keys(e[i]).length>0){Object.keys(e[i]).forEach(n=>{const o=n.startsWith("conditions/")?n.slice(11):n;const s=this._getPropertyByName(o);if(s){const a=c.createCondition(F.EQ,[e[i][n]]);const l=r(a,s.typeConfig.typeInstance,this.getTypeMap());if(!t[i]){t[i]={}}if(!n.startsWith("conditions/")){delete t[i][n];n="conditions/"+o}t[i][n]=l.values[0]}else{a.error("mdc.FilterBar._convertInOutParameters: could not find property for '"+o+"'")}})}};E.prototype._cleanupCondition=function(e){if(e){if(e.hasOwnProperty("isEmpty")){delete e.isEmpty}}};E.prototype._cleanupConditions=function(e){if(e){e.forEach(function(e){this._cleanupCondition(e)},this)}};E.prototype._stringifyCondition=function(e,t){let i=t;if(t&&t.values){if(t.values.length>0){i=this._toExternal(e,t)}else{i=l({},t);this._cleanupCondition(i)}}return i};E.prototype._stringifyConditions=function(e,t){const i=this._getPropertyByName(e);let r=t;if(i&&t){r=[];t.forEach(function(e){r.push(this._stringifyCondition(i,e))},this)}return r};E.prototype._internalizeConditions=function(e){const t=l({},e);Object.keys(t).forEach(function(e){t[e].forEach(function(i,r){const n=this._getPropertyByName(e);if(n){try{t[e][r]=this._toInternal(n,i)}catch(e){a.error(e.message)}}else{a.error("Property '"+e+"' does not exist")}},this)},this);return t};E.prototype._handleAssignedFilterNames=function(e){if(this._bIsBeingDestroyed){return}if(!e){if(this._btnAdapt){const e=this.getAssignedFilterNames();this.setProperty("_filterCount",this._oRb.getText(e.length?"filterbar.ADAPT_NONZERO":"filterbar.ADAPT",[e.length]),false)}}const t=this._getAssignedFiltersText();const i={conditionsBased:!e&&!this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch,filtersText:t.filtersText,filtersTextExpanded:t.filtersTextExpanded};this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=false;this.fireFiltersChanged(i)};E.prototype.onSearch=function(e){if(!this._bSearchPressed){this._bSearchPressed=true;this._sReason=y.Go;this.triggerSearch().then(()=>{this._bSearchPressed=false},()=>{this._bSearchPressed=false})}};E.prototype.triggerSearch=function(){if(this.getSuspendSelection()){this._bSearchTriggered=true;return Promise.resolve()}this._bFireSearch=true;return this.validate()};E.prototype._hasRetrieveMetadataToBeCalled=function(){return this.getPropertyHelper()===null||this.getPropertyHelper().getProperties().length===0&&!this.isPropertyHelperFinal()};E.prototype.validate=function(e){const t=!e;this._bFireSearch=this._bFireSearch||t;const i=function(){if(!this._oValidationPromise){this._oValidationPromise=new Promise((e,t)=>{this._fResolvedSearchPromise=e;this._fRejectedSearchPromise=t});const e=function(){this._validate(t)};setTimeout(e.bind(this),0)}return this._oValidationPromise}.bind(this);return this.waitForInitialization().then(()=>{if(this._hasRetrieveMetadataToBeCalled()){return this._retrieveMetadata().then(()=>i())}else{return i()}})};E.prototype._clearDelayedSearch=function(){if(this._iDelayedSearchId){clearTimeout(this._iDelayedSearchId);this._iDelayedSearchId=null}};E.prototype._checkAsyncValidation=function(){let e=m.NoError;if(this._aFIChanges&&this._aFIChanges.length>0){e=m.AsyncValidation}return e};E.prototype._checkOngoingChangeAppliance=function(){let e=m.NoError;if(this._aOngoingChangeAppliance&&this._aOngoingChangeAppliance.length>0){e=m.OngoingChangeAppliance}return e};E.prototype._getRequiredFilterFieldValueText=function(e){if(e){return this._oRb.getText("filterbar.REQUIRED_FILTER_VALUE_MISSING",[e.getLabel()])}else{return""}};E.prototype._recheckMissingRequiredFields=function(){this.getFilterItems().forEach(e=>{let t;if(e){if(e.getValueState()!==v.None&&e.getValueStateText()===this._getRequiredFilterFieldValueText(e)){if(!t){t=f.getRequiredFieldNamesWithoutValues(this)}if(t.indexOf(e.getPropertyKey())<0){e.setValueState(v.None)}}}})};E.prototype._checkRequiredFields=function(){let e=m.NoError;const t=f.getRequiredFieldNamesWithoutValues(this);t.forEach(t=>{const i=this._getFilterField(t);if(i){if(i.getValueState()===v.None){i.setValueState(v.Error);i.setValueStateText(this._getRequiredFilterFieldValueText(i))}}else{a.error("Mandatory filter field '"+t+"' not visible on FilterBarBase has no value.")}e=m.RequiredHasNoValue});return e};E.prototype._checkFieldsInErrorState=function(){let e=m.NoError;if(this._bFieldInErrorState){return m.FieldInErrorState}this.getFilterItems().some(t=>{if(t&&t.getValueState()!==v.None){if(t.getValueStateText()!==this._getRequiredFilterFieldValueText(t)){e=m.FieldInErrorState}}return e!==m.NoError});return e};E.prototype._hasAppliancePromises=function(){return this._aOngoingChangeAppliance&&this._aOngoingChangeAppliance.length>0?this._aOngoingChangeAppliance.slice():null};E.prototype._handleFilterItemSubmit=function(e){const t=e.getParameter("promise");if(t){this._sReason=y.Enter;t.then(()=>{const e=this._hasAppliancePromises();if(!e){this.triggerSearch()}else{Promise.all(e).then(()=>{if(!this.getLiveMode()){this.triggerSearch()}})}}).catch(e=>{a.error(e);this.triggerSearch().catch(e=>{})})}};E.prototype._handleFilterItemChanges=function(e){if(this._bIgnoreChanges){return}const t=e.oSource;if(t.getRequired()&&t.getValueState()===v.Error&&e.getParameter("valid")){t.setValueState(v.None);return}if(!this._aFIChanges){this._aFIChanges=[]}const i=t.getPropertyKey();this._aFIChanges.some((e,t)=>{if(e.name===i){this._aFIChanges.splice(t,1);return true}return false});this._aFIChanges.push({name:i,promise:e.getParameter("promise")})};E.prototype.checkFilters=function(){let e=this._checkAsyncValidation();if(e!==m.NoError){return e}e=this._checkOngoingChangeAppliance();if(e!==m.NoError){return e}e=this._checkFieldsInErrorState();if(e!==m.NoError){return e}e=this._checkRequiredFields();if(e!==m.NoError){return e}return e};E.prototype._setFocusOnFirstErroneousField=function(){let e=null;this.getFilterItems().some(t=>{if(t.getValueState()!==v.None){e=t;setTimeout(t["focus"].bind(t),0)}return e!=null});return e};E.prototype.setFocusOnFirstErroneousField=function(){return this._setFocusOnFirstErroneousField()};E.prototype._handleAsyncValidation=function(e,t){if(!t){t=this._validate.bind(this)}if(this._aFIChanges&&this._aFIChanges.length>0){const i=this._aFIChanges.slice();this._aFIChanges=null;const r=[];i.forEach(e=>{r.push(e.promise)});Promise.all(r).then(r=>{r.forEach(function(e,t){const r=this._getFilterField(i[t].name);if(r&&r.getRequired()&&r.getValueState()===v.Error){r.setValueState(v.None)}},this);t(e)},()=>{this._bFieldInErrorState=true;t(e)}).catch(i=>{this._bFieldInErrorState=true;t(e)})}};E.prototype._handleOngoingChangeAppliance=function(e,t){if(!t){t=this._validate.bind(this)}if(this._aOngoingChangeAppliance&&this._aOngoingChangeAppliance.length>0){const i=this._aOngoingChangeAppliance.slice();this._aOngoingChangeAppliance=[];Promise.all(i).then(()=>{const i=this._oApplyingChanges?this._oApplyingChanges:Promise.resolve();i.then(()=>t(e))},()=>{this._bFieldInErrorState=true;t(e)}).catch(i=>{this._bFieldInErrorState=true;t(e)})}};E.prototype._determineValidationState=function(){return this.awaitControlDelegate().then(e=>e.determineValidationState(this,this.checkFilters()))};E.prototype._visualizeValidationState=function(e){if(this._oDelegate){this._oDelegate.visualizeValidationState(this,{status:e})}};E.prototype.getResourceFileText=function(e,t){return e?this._oRb.getText(e,t):""};E.prototype._restartCheckAndNotify=function(e){const t=this.checkFilters();this._checkAndNotify(e,t)};E.prototype._checkAndNotify=function(e,t){const i=function(){if(e||this._bFireSearch){const e={reason:this._sReason?this._sReason:y.Unclear};this._sReason=y.Unclear;this.fireSearch(e)}}.bind(this);const r=function(){this._bFieldInErrorState=false;this._oValidationPromise=null;this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null;this._bFireSearch=false}.bind(this);if(t===m.AsyncValidation){this._handleAsyncValidation(e,this._restartCheckAndNotify.bind(this));return}if(t===m.OngoingChangeAppliance){this._handleOngoingChangeAppliance(e,this._restartCheckAndNotify.bind(this));return}if(t===m.NoError){if(this._fResolvedSearchPromise){i();this._fResolvedSearchPromise()}}else if(this._fRejectedSearchPromise){this._setFocusOnFirstErroneousField();this._fRejectedSearchPromise()}this._visualizeValidationState(t);r()};E.prototype._validate=function(e){const t=function(){this._oValidationPromise=null;this._fRejectedSearchPromise=null;this._fResolvedSearchPromise=null}.bind(this);if(this.bIsDestroyed){t();return}this._determineValidationState().then(t=>{this._checkAndNotify(e,t)})};E.prototype.setInternalConditions=function(e){const t=this._getConditionModel();if(t){t.setConditions(e)}};E.prototype.getInternalConditions=function(){return this._getModelConditions(this._getConditionModel(),true)};E.prototype.waitForInitialization=function(){return Promise.all([this._oInitialFiltersAppliedPromise,this._oMetadataAppliedPromise])};E.prototype.initialized=function(){return this.waitForInitialization()};E.prototype.initializedWithMetadata=function(){if(!this._oMetadataAppliedPromise){this._retrieveMetadata()}return this.waitForInitialization()};E.prototype._getModelConditions=function(e,t,i){const r={};if(e){const n=l({},e.getAllConditions());for(const e in n){if(n[e]&&(i||n[e].length>0)){r[e]=n[e];if(!t){this._cleanupConditions(r[e]);const t=this._stringifyConditions(e,r[e]);r[e]=t}}}}return r};E.prototype._isPathKnown=function(e,t){let i,r;if(!this._getPropertyByName(e)){return false}for(i in t["inParameters"]){r=i.startsWith("conditions/")?i.slice(11):i;if(!this._getPropertyByName(r)){return false}}for(i in t["outParameters"]){r=i.startsWith("conditions/")?i.slice(11):i;if(!this._getPropertyByName(r)){return false}}return true};E.prototype._onModifications=function(e){if(e&&e.indexOf("Filter")===-1){return Promise.resolve()}let t;if(!this._oApplyingChanges){this._oApplyingChanges=new Promise(e=>{t=e})}return this._setXConditions(this.getFilterConditions()).then(()=>{this._reportModelChange({triggerSearch:false,triggerFilterUpdate:true,recheckMissingRequired:true});t();this._oApplyingChanges=null})};E.prototype._setXConditions=function(e){if(e){let t=true;for(const i in e){const r=e[i];if(!this._isPathKnown(i,r)){t=false;break}}const i=t?Promise.resolve():this._retrieveMetadata();const r=this._getConditionModel();return i.then(()=>{const t=this._internalizeConditions(e);const i=this._getModelConditions(r,true);r.detachPropertyChange(this._handleConditionModelPropertyChange,this);try{return this.getEngine().diffState(this,{Filter:i},{Filter:t}).then(e=>{Object.keys(e.Filter).forEach(t=>{e.Filter[t].forEach(e=>{if(e.filtered!==false){r.addCondition(t,e)}else{r.removeCondition(t,e)}})});r.attachPropertyChange(this._handleConditionModelPropertyChange,this)})}catch(e){a.error(e.message);r.attachPropertyChange(this._handleConditionModelPropertyChange,this)}})}else{return Promise.resolve()}};E.prototype._getXConditions=function(){return this._getModelConditions(this._getConditionModel(),false)};E.prototype._getRequiredPropertyNames=function(){const e=[];this._getNonHiddenPropertyInfoSet().forEach(t=>{if(t.required){e.push(g.getPropertyKey(t))}});return e};E.prototype._getNonRequiredPropertyNames=function(){const e=[];this._getNonHiddenPropertyInfoSet().forEach(t=>{if(!t.required){e.push(g.getPropertyKey(t))}});return e};E.prototype._insertFilterFieldtoContent=function(e,t){if(!this._cLayoutItem){return}const i=this._cLayoutItem;const r=new i;r.setFilterField(e);this._oFilterBarLayout.insertFilterField(r,t)};E.prototype._filterItemInserted=function(e){if(!e.getVisible()){return}if(e.setWidth){e.setWidth("")}this._applyFilterItemInserted(e);this._handleAssignedFilterNames(true)};E.prototype._applyFilterItemInserted=function(e){let t;t=this.indexOfAggregation("filterItems",e);if(this.getAggregation("basicSearchField")){t++}const i=t;const r=this.getFilterItems();for(let e=0;e<i;e++){if(!r[e].getVisible()){t--}}this._handleAddedFilterField(e);this._insertFilterFieldtoContent(e,t);if(!this._oObserver.isObserved(e,{properties:["visible"]})){this._oObserver.observe(e,{properties:["visible"]})}};E.prototype._filterItemRemoved=function(e){this._handleRemovedFilterField(e);this._applyFilterItemRemoved(e.getPropertyKey());this._handleAssignedFilterNames(true)};E.prototype._applyFilterItemRemoved=function(e){this._removeFilterFieldFromContentByName(e)};E.prototype._removeFilterFieldFromContent=function(e){this._removeFilterFieldFromContentByName(e.getPropertyKey())};E.prototype._removeFilterFieldFromContentByName=function(e){const t=this._getFilterItemLayoutByName(e);if(t){this._oFilterBarLayout.removeFilterField(t);t.destroy()}};E.prototype._handleAddedFilterField=function(e){};E.prototype._handleRemovedFilterField=function(e){};E.prototype._observeChanges=function(e){let t;if(e.type==="aggregation"){if(e.name==="filterItems"){switch(e.mutation){case"insert":t=e.child;t=this._enhanceFilterField(t);t.attachChange(this._handleFilterItemChanges,this);t.attachSubmit(this._handleFilterItemSubmit,this);this._filterItemInserted(t);break;case"remove":e.child.detachChange(this._handleFilterItemChanges,this);e.child.detachSubmit(this._handleFilterItemSubmit,this);this._filterItemRemoved(e.child);break;default:a.error("operation "+e.mutation+" not yet implemented")}}else if(e.name==="basicSearchField"){switch(e.mutation){case"insert":e.child.attachSubmit(this._handleFilterItemSubmit,this);this._insertFilterFieldtoContent(e.child,0);break;case"remove":e.child.detachSubmit(this._handleFilterItemSubmit,this);this._removeFilterFieldFromContent(e.child);break;default:a.error("operation "+e.mutation+" not yet implemented")}}}else if(e.type==="property"){if(e.object.isA&&e.object.isA("sap.ui.mdc.FilterField")){t=e.object;if(t){if(e.current){this._filterItemInserted(t)}else{this._filterItemRemoved(t)}this._oFilterBarLayout.invalidate()}}}};E.prototype._getFilterItemLayout=function(e){return this._getFilterItemLayoutByName(e.getPropertyKey())};E.prototype._getFilterItemLayoutByName=function(e){let t=null;if(this._oFilterBarLayout){this._oFilterBarLayout.getFilterFields().some(i=>{if(i._getFieldPath()===e){t=i}return t!==null})}return t};E.prototype._getFilterField=function(e){let t=null;this.getFilterItems().some(i=>{if(i&&i.getPropertyKey()===e){t=i}return t!==null});return t};E.prototype._retrieveMetadata=function(){if(this.isPropertyHelperFinal()){return Promise.resolve()}if(this._oMetadataAppliedPromise){return this._oMetadataAppliedPromise}this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=new Promise((e,t)=>{this._fResolveMetadataApplied=e;this._fRejectMetadataApplied=t});this.initControlDelegate().then(()=>{if(!this._bIsBeingDestroyed){const e=function(e){e?this._fResolveMetadataApplied():this._fRejectMetadataApplied();this._fResolveMetadataApplied=null;this._fRejectMetadataApplied=null}.bind(this);if(this.isControlDelegateInitialized()){this.finalizePropertyHelper().then(()=>{e(true)})}else{a.error("Delegate not initialized.");e(false)}}});return this._oMetadataAppliedPromise};E.prototype._enhanceFilterField=function(e){if(e){const t=e.getPropertyKey();if(!t){a.error("filter field with the id = '"+e.getId()+"' should have an assigned 'propertyKey'");return e}if(!e.getBindingInfo("conditions")){e.bindProperty("conditions",{path:`/conditions/${t}`,model:"$filters"})}let i=this._getPropertyByName(t);const r=this.getPropertyInfo();if(!i&&r.length>0){i=r.find(e=>e.key===t||e.name===t)}if(!i){if(!this.isA("sap.ui.mdc.valuehelp.FilterBar")){a.warning("Property '"+t+"' does not exist for filter field with the id = '"+e.getId()+"' on filter bar='"+this.getId()+"'")}P.checkMandatoryProperties(e);return e}P.compareControlWithPropertyInfo(e,i);e.triggerCheckCreateInternalContent()}return e};E.prototype.setBasicSearchField=function(e){const t=this.getAggregation("basicSearchField");if(t){this.removeAggregation("basicSearchField",t)}this.setAggregation("basicSearchField",e);if(e){this._enhanceBasicSearchField(e);if(!this._oObserver.isObserved(e,{properties:["visible"]})){this._oObserver.observe(e,{properties:["visible"]})}}return this};E.prototype._enhanceBasicSearchField=function(e){const t=e.getPropertyKey();if(t!==M){if(t||t===""){a.warning(`sap.ui.mdc.FilterBar: BasicSearchField has incorrect 'propertyKey' '${t}'. Overriding to default '${M}'`)}e.setPropertyKey(M)}this._enhanceFilterField(e)};E.prototype._getNonHiddenPropertyInfoSet=function(){const e=[];this.getPropertyInfoSet().every(t=>{if(!t.hiddenFilter){if(g.getPropertyKey(t)!==M){e.push(t)}}return true});return e};E.prototype._getNonHiddenPropertyByName=function(e){let t=null;this._getNonHiddenPropertyInfoSet().some(i=>{if(g.getPropertyKey(i)===e){t=i}return t!=null});return t};E.prototype._cleanUpFilterFieldInErrorStateByName=function(e){let t=null;const i=this.getFilterItems();i.some(i=>{if(i.getPropertyKey()===e){t=i}return t!=null});if(t){this._cleanUpFilterFieldInErrorState(t)}};E.prototype.cleanUpAllFilterFieldsInErrorState=function(){this._getConditionModel().checkUpdate(true);const e=this.getFilterItems();e.forEach(e=>{this._cleanUpFilterFieldInErrorState(e)})};E.prototype._cleanUpFilterFieldInErrorState=function(e){if(e&&e.getValueState()!==v.None){e.setValueState(v.None)}};E.prototype._applyInitialFilterConditions=function(){this._bIgnoreChanges=true;this._applyFilterConditionsChanges().then(()=>{this._bIgnoreChanges=false;this._reportModelChange({triggerFilterUpdate:true,triggerSearch:false});this._bInitialFiltersApplied=true;this._fResolveInitialFiltersApplied();this._fResolveInitialFiltersApplied=null})};E.prototype._applyFilterConditionsChanges=function(){let e;const t=this.getProperty("filterConditions");if(Object.keys(t).length>0){e=l({},t);return this._setXConditions(e)}return Promise.resolve()};E.prototype._loadFlex=function(){return new Promise(e=>{t.load({name:"sap.ui.fl"}).then(()=>{sap.ui.require(["sap/ui/fl/apply/api/ControlVariantApplyAPI"],t=>{e(t)})}).catch(t=>{a.error(t);e(null)})})};E.prototype.setVariantBackreference=function(e){if(!this._hasAssignedVariantManagement()){this.setAssociation("variantBackreference",e);this._loadFlex().then(e=>{A=e;A.attachVariantApplied({selector:this,vmControlId:this.getVariantBackreference(),callback:this._handleVariantSwitch.bind(this),callAfterInitialVariant:true})})}else{a.error("the association 'variantBackreference' may only be assigned once and may not change afterwards.")}return this};E.prototype._handleVariantSwitch=function(e){this._bExecuteOnSelect=this._getExecuteOnSelectionOnVariant(e);this._sReason=this._bExecuteOnSelect?y.Variant:y.Unclear;this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=false;if(e.hasOwnProperty("createScenario")&&e.createScenario==="saveAs"){this._bDoNotTriggerFiltersChangeEventBasedOnVariantSwitch=true}return this.awaitPendingModification().then(e=>{this.cleanUpAllFilterFieldsInErrorState();if(this._bInitialFiltersApplied&&e.indexOf("Filter")===-1){this._reportModelChange({triggerFilterUpdate:false,triggerSearch:this._bExecuteOnSelect})}})};E.prototype._getExecuteOnSelectionOnVariant=function(e){let t=false;const i=this._getAssignedVariantManagement();if(i){t=i.getApplyAutomaticallyOnVariant(e)}return t};E.prototype._hasAssignedVariantManagement=function(){return this._getAssignedVariantManagement()?true:false};E.prototype._getAssignedVariantManagement=function(){const t=this.getVariantBackreference();if(t){const i=e.getElementById(t);if(i&&i.isA("sap.ui.fl.variants.VariantManagement")){return i}}return null};E.prototype._getView=function(){return g.getView(this)};E.prototype.getConditions=function(){const e=this.getCurrentState().filter;if(e&&e[M]){delete e[M]}return e};E.prototype.getSearch=function(){const e=this._getConditionModel()?this._getConditionModel().getConditions(M):[];return e[0]?e[0].values[0]:""};E.prototype.exit=function(){if(this._hasAssignedVariantManagement()&&A){A.detachVariantApplied({selector:this,vmControlId:this.getVariantBackreference()});A=undefined}if(this.isControlDelegateInitialized()&&this.getControlDelegate().cleanup){this.getControlDelegate().cleanup(this)}s.prototype.exit.apply(this,arguments);this._clearDelayedSearch();this._oFilterBarLayout=null;this._cLayoutItem=null;this._btnAdapt=undefined;this._btnSearch=undefined;this._oRb=null;if(this._oModel){this._oModel.destroy();this._oModel=null}if(this._oConditionModel){this._oConditionModel.detachPropertyChange(this._handleConditionModelPropertyChange,this);this._oConditionModel.destroy();this._oConditionModel=null}this._oObserver.disconnect();this._oObserver=undefined;this._oDelegate=null;this._oFlexPromise=null;this._fResolveMetadataApplied=undefined;this._oMetadataAppliedPromise=null;this._oInitialFiltersAppliedPromise=null;this._oValidationPromise=null;this._aBindings=null;this._aFIChanges=null;this._aOngoingChangeAppliance=null};return E});
//# sourceMappingURL=FilterBarBase.js.map