/*!
 * OpenUI5
 * (c) Copyright 2025 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Element","sap/ui/core/library","sap/ui/mdc/p13n/subcontroller/FilterController","sap/ui/mdc/p13n/subcontroller/AdaptFiltersController","sap/ui/mdc/filterbar/p13n/GroupContainer","sap/ui/mdc/filterbar/p13n/FilterColumnLayout","sap/ui/mdc/filterbar/p13n/FilterGroupLayout","sap/ui/mdc/filterbar/p13n/TableContainer","sap/ui/mdc/filterbar/FilterBarBase","sap/ui/mdc/filterbar/FilterBarBaseRenderer","sap/base/util/merge","sap/m/p13n/enums/PersistenceMode"],(t,e,i,o,n,r,a,s,l,p,h,c)=>{"use strict";const{ValueState:d}=e;const u=l.extend("sap.ui.mdc.filterbar.p13n.AdaptationFilterBar",{metadata:{library:"sap.ui.mdc",properties:{_useFixedWidth:{type:"boolean",defaultValue:false,visibility:"hidden"}},associations:{adaptationControl:{type:"sap.ui.mdc.Control",multiple:false}},events:{change:{}}},renderer:p});u.prototype.WIDTH="30rem";u.prototype.getVerticalScrolling=function(){return this._oFilterBarLayout.getInner().getVerticalScrolling instanceof Function?this._oFilterBarLayout.getInner().getVerticalScrolling():false};u.prototype.init=function(){l.prototype.init.apply(this,arguments);this.addStyleClass("sapUIAdaptationFilterBar");this.getEngine().defaultProviderRegistry.attach(this,c.Transient);this._fnResolveAdaptationControlPromise=null;this._oAdaptationControlPromise=new Promise((t,e)=>{this._fnResolveAdaptationControlPromise=t})};u.prototype.keepAlive=function(){return true};u.prototype._onModifications=function(){const t=l.prototype._onModifications.apply(this,arguments);if(this._oFilterBarLayout.getInner().isA("sap.ui.mdc.p13n.panels.FilterPanel")){const t=this._oFilterBarLayout.getInner().getP13nData();this._updateActiveStatus(t);this._oFilterBarLayout.setP13nData({items:t})}return t};u.prototype.getInitialFocusedControl=function(){return this._oFilterBarLayout.getInitialFocusedControl()};u.prototype.getWidth=function(){return this.WIDTH};u.prototype.applySettings=function(){l.prototype._applySettings.apply(this,arguments);this._waitForAdaptControlAndPropertyHelper().then(()=>{this._initControlDelegate()})};u.prototype.setVisibleFields=function(t){const e=this._getAdaptationControlInstance();if(this._checkAdvancedParent(e)){throw new Error("Only supported for simple parents")}this._aVisibleKeys=t};u.prototype._getPropertyByName=function(t){let e=l.prototype._getPropertyByName.apply(this,arguments);const i=this.getPropertyHelper();if(!e||e.filterable===false){e=i.getProperties().find(e=>e.path===t&&e.filterable)}return e};u.prototype._waitForAdaptControlAndPropertyHelper=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().awaitPropertyHelper().then(t=>{this._oPropertyHelper=t}))};u.prototype._initControlDelegate=function(){return this.initControlDelegate().then(()=>{if(!this._bIsBeingDestroyed){this._applyInitialFilterConditions()}})};u.prototype.getControlDelegate=function(){return this._getAdaptationControlInstance().getControlDelegate()};u.prototype.initControlDelegate=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().initControlDelegate())};u.prototype.awaitControlDelegate=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().awaitControlDelegate())};u.prototype.initPropertyHelper=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().initPropertyHelper())};u.prototype.finalizePropertyHelper=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().finalizePropertyHelper())};u.prototype.getTypeUtil=function(){return this.getTypeMap()};u.prototype.getTypeMap=function(){if(!this._getAdaptationControlInstance()){throw new Error("No adaptation control assigned yet.")}return this._getAdaptationControlInstance().getTypeMap()};u.prototype.setMessageStrip=function(t){this._oFilterBarLayout.setMessageStrip(t)};u.prototype.setLiveMode=function(t,e){l.prototype.setLiveMode.apply(this,arguments);this._oConditionModel.attachPropertyChange(t=>{const e=t.getParameter("path").substring(12);if(this.oAdaptationData){const t=this.oAdaptationData.items;const i=t.find(t=>t.name==e);if(i&&this._checkAdvancedParent(this._getAdaptationControlInstance())){i.active=this._getConditionModel().getConditions(e).length>0?true:false}}});return this};u.prototype._retrieveMetadata=function(){return this._oAdaptationControlPromise.then(()=>this._getAdaptationControlInstance().awaitPropertyHelper().then(function(t){if(!this._getAdaptationControlInstance().isPropertyHelperFinal()){return this.finalizePropertyHelper()}return l.prototype._retrieveMetadata.apply(this,arguments)}.bind(this)))};u.prototype.isControlDelegateInitialized=function(){return this._getAdaptationControlInstance().isControlDelegateInitialized()};u.prototype.createConditionChanges=function(){return Promise.all([this._oAdaptationControlPromise,this.awaitControlDelegate()]).then(()=>{const t=this._getModelConditions(this._getConditionModel(),false,true);return this.getEngine().createChanges({control:this._getAdaptationControlInstance(),applyAbsolute:true,key:"Filter",state:t,suppressAppliance:true})})};u.prototype.setP13nData=function(t){this.oAdaptationData=t;this._getConditionModel().checkUpdate(true);this._updateActiveStatus(this.oAdaptationData.items);this._oFilterBarLayout.update(t)};u.prototype._updateActiveStatus=function(t){const e=this.getFilterConditions();t.forEach(t=>{const i=this.mFilterFields&&this.mFilterFields[t.name];if(i){const o=i.getPropertyKey();if(e[o]&&e[o].length>0){t.active=true}}})};u.prototype.getP13nData=function(){if(this._aVisibleKeys&&this._aVisibleKeys.length>0){this.oAdaptationData.items.forEach(function(t){if(this._aVisibleKeys.indexOf(t.name)>-1){t.active=true}},this)}return this.oAdaptationData};u.prototype._handleFilterItemSubmit=function(){return};u.prototype._getWaitForChangesPromise=function(){return this.getEngine().waitForChanges(this._getAdaptationControlInstance())};u.prototype.createFilterFields=function(){return this.initializedWithMetadata().then(()=>{const t=this._getAdaptationControlInstance().getFilterConditions();this.setFilterConditions(t);const e=this._setXConditions(t);if(this._bFilterFieldsCreated){return e.then(()=>{this._updateActiveStatus(this.oAdaptationData.items);this._oFilterBarLayout.setP13nData(this.getP13nData());return this})}const i=this._getAdaptationControlInstance();const o=i.getControlDelegate();const n=this._checkAdvancedParent(i)?o:o.getFilterDelegate();this._mOriginalsForClone={};this.mFilterFields={};const r=[];this.getP13nData().items.forEach((t,e)=>{const o=this._checkExisting(t,n);o.then(e=>{let n;if(this._checkAdvancedParent(i)){if(e._bTemporaryOriginal){delete o._bTemporaryOriginal;this._mOriginalsForClone[e.getPropertyKey()]=e}n=e.clone();if(i._handleFilterItemChanges){n.detachChange(i._handleFilterItemChanges,i)}if(i._handleFilterItemSubmit){n.detachSubmit(i._handleFilterItemSubmit,i)}if(n.getValueState()!==d.None){n.setValueState(d.None);n.setValueStateText()}}else{n=e}this.mFilterFields[t.name]=n});r.push(o)});return Promise.all(r).then(()=>{const t=this.getP13nData();t.items.forEach(t=>{this.addAggregation("filterItems",this.mFilterFields[t.name])});this._attachFields();this._updateActiveStatus(t.items);this._oFilterBarLayout.setP13nData(t);this._bFilterFieldsCreated=true;return this})})};u.prototype._attachFields=function(){this.getFilterItems().forEach(t=>{t.attachChange(t=>{this.fireChange()})})};u.prototype._checkExisting=function(t,e){let i;const o=this._getAdaptationControlInstance();const n=this._checkAdvancedParent(o)?o.getFilterItems():[];const r=n.reduce((t,e)=>{t[e.getPropertyKey()]=e;return t},{});if(r[t.name]){i=Promise.resolve(r[t.name])}else{i=e.addItem(this._getAdaptationControlInstance(),t.name);i=i.then(e=>{if(!e){throw new Error("No FilterField could be created for property: '"+t.name+"'.")}e._bTemporaryOriginal=true;return e})}return i};u.prototype.executeRemoves=function(){const t=this._oFilterBarLayout.getInner().getSelectedFields();const e=[];Object.keys(this._mOriginalsForClone).forEach(i=>{const o=this._getAdaptationControlInstance().getControlDelegate();if(t.indexOf(i)<0){const t=o.removeItem.call(o,this._getAdaptationControlInstance(),i).then(t=>{if(t&&this._mOriginalsForClone[i]){this._mOriginalsForClone[i].destroy();delete this._mOriginalsForClone[i]}});e.push(t)}});return Promise.all(e)};u.prototype._checkAdvancedParent=function(t){if(!t.isA("sap.ui.mdc.IFilterSource")&&!t.isA("sap.ui.mdc.IFilter")){throw new Error("The 'adaptationControl' needs to implement the IFilterSource or IFilter interface")}return t.isA("sap.ui.mdc.IFilter")};u.prototype.setAdaptationControl=function(t,e){if(this._fnResolveAdaptationControlPromise){this._fnResolveAdaptationControlPromise();this._fnResolveAdaptationControlPromise=null}this.setAssociation("adaptationControl",t,e);this._cLayoutItem=a;this._oFilterBarLayout=this._checkAdvancedParent(t)?new n:new s;this._oFilterBarLayout.getInner().setParent(this);this.setAggregation("layout",this._oFilterBarLayout,true);if(this._oFilterBarLayout.getInner().attachChange){this._oFilterBarLayout.getInner().attachChange(t=>{if(t.getParameter("reason")==="Remove"){const e=t.getParameter("item");const i={};i[this.mFilterFields[e.name].getPropertyKey()]=[];return this.getEngine().createChanges({control:this,applyAbsolute:true,key:"Filter",state:i})}this.fireChange()})}return this};u.prototype._getAdaptationControlInstance=function(){const e=this.getAdaptationControl();return e&&t.getElementById(e)};u.prototype.exit=function(){this.getEngine().defaultProviderRegistry.detach(this);l.prototype.exit.apply(this,arguments);for(const t in this._mOriginalsForClone){this._mOriginalsForClone[t].destroy()}this._mOriginalsForClone=null;this.oAdaptationData=null;this.mFilterFields=null;this._fnResolveAdaptationControlPromise=null;this._oAdaptationControlPromise=null};return u});
//# sourceMappingURL=AdaptationFilterBar.js.map